/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.HostObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.RecordsPanel;
import COM.ibm.raleigh.ddnssgui.client.TTLPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class AliasHostFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
TabViewEventListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int HOST_NAME_FIELD = 0;
    public static final int ALIAS_NAME_FIELD = 1;
    public static final int TTL_ALIAS_FIELD = 2;
    private static final int TABVIEW_ALIAS_CFG_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_TTL_INDEX = 1;
    private static final int TABVIEW_COMMENTS_INDEX = 2;
    private static final int TABVIEW_SIG_KEY_INDEX = 3;
    private static final int NUM_TABS = 4;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 16;
    private HostObjectMgr parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private Panel cfgPanel;
    private Label aliasNameLabel;
    private TextField aliasName;
    private Label hostNameLabel;
    private TextField hostName;
    private Label fullyQualifiedLabel;
    private Label domainNameLabel;
    private Choice domainName;
    private Panel ttlPanel;
    private WrappedTextPanel ttlExplanation;
    private TTLPanel ttlAliasPanel;
    private RecordsPanel commentsPanel;
    private RecordsPanel sigAndKeyPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private msgBox okBox;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox invalidBox;

    public AliasHostFrame(HostObjectMgr hostObjectMgr) {
        this.setResizable(false);
        this.parent = hostObjectMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("ALIAS_HOST_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.hostName.requestFocus();
                return;
            }
            case 1: {
                this.aliasName.requestFocus();
                return;
            }
            case 2: {
                this.ttlAliasPanel.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.hostName.selectAll();
                return;
            }
            case 1: {
                this.aliasName.selectAll();
                return;
            }
            case 2: {
                this.ttlAliasPanel.selectAll(0);
                return;
            }
        }
    }

    public String getAliasName() {
        return this.aliasName.getText().trim().toLowerCase();
    }

    public void setAliasName(String string) {
        if (string != null) {
            ((TextComponent)this.aliasName).setText(string.trim().toLowerCase());
            this.checkToDisableNames();
            if (this.getAliasName().compareTo("") == 0) {
                this.setTitle(this.resources.getString("ALIAS_HOST_FRAME_NAME"));
                return;
            }
            this.setTitle(String.valueOf(this.resources.getString("ALIAS_HOST_FRAME_NAME")) + " -- " + this.getAliasName());
        }
    }

    public String getHostName() {
        return this.hostName.getText().trim().toLowerCase();
    }

    public void setHostName(String string) {
        if (string != null) {
            ((TextComponent)this.hostName).setText(string.trim().toLowerCase());
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.domainName.getSelectedItem().trim().toLowerCase();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null && string.length() > 0) {
            this.domainName.select(string.trim().toLowerCase());
            this.checkToDisableNames();
        }
    }

    public String[] getFullyQualifiedDomainNameList() {
        int n = this.domainName.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(this.domainName.getItem(n2).trim().toLowerCase());
            ++n2;
        }
        return stringArray;
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domainName.addItem(stringArray[n].trim().toLowerCase());
                ++n;
            }
            if (stringArray.length > 1) {
                this.domainName.setEnabled(true);
            }
            this.checkToDisableNames();
        }
    }

    public int getAliasTTL() {
        return this.ttlAliasPanel.getTTL();
    }

    public void setAliasTTL(int n) {
        this.ttlAliasPanel.setTTL(n);
    }

    public String[] getComments() {
        return this.commentsPanel.getRecords();
    }

    public void setComments(String[] stringArray) {
        if (stringArray != null) {
            this.commentsPanel.setRecords(stringArray);
        }
    }

    public void setEnabledComments(boolean bl) {
        this.commentsPanel.setEnabled(bl);
    }

    public String[] getSigAndKeyRecords() {
        return this.sigAndKeyPanel.getRecords();
    }

    public void setSigAndKeyRecords(String[] stringArray) {
        if (stringArray != null) {
            this.sigAndKeyPanel.setRecords(stringArray);
        }
    }

    public void setEnabled(boolean bl) {
        this.cfgPanel.setEnabled(bl);
        this.aliasNameLabel.setEnabled(bl);
        this.aliasName.setEnabled(bl);
        this.hostNameLabel.setEnabled(bl);
        this.hostName.setEnabled(bl);
        this.fullyQualifiedLabel.setEnabled(bl);
        this.domainNameLabel.setEnabled(bl);
        this.domainName.setEnabled(bl);
        this.ttlPanel.setEnabled(bl);
        this.ttlExplanation.setEnabled(bl);
        this.ttlAliasPanel.setEnabled(bl);
        this.setEnabledComments(bl);
        if (bl) {
            this.checkToDisableNames();
        }
        if (!bl) {
            this.sigAndKeyPanel.setEnabled(false);
        }
    }

    public void setEnabledAll(boolean bl) {
        if (bl) {
            this.cfgPanel.setEnabled(true);
            this.aliasNameLabel.setEnabled(true);
            this.aliasName.setEnabled(true);
            this.hostNameLabel.setEnabled(true);
            this.hostName.setEnabled(true);
            this.fullyQualifiedLabel.setEnabled(true);
            this.domainNameLabel.setEnabled(true);
            this.domainName.setEnabled(true);
            this.ttlPanel.setEnabled(true);
            this.ttlExplanation.setEnabled(true);
            this.ttlAliasPanel.setEnabled(true);
            this.setEnabledComments(true);
            this.sigAndKeyPanel.setEnabled(false);
        }
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.cfgPanel = new Panel();
        this.aliasNameLabel = new Label(this.resources.getString("ALIAS_NAME_LABEL"), 0);
        this.aliasName = new TextField("", 16);
        this.hostNameLabel = new Label(this.resources.getString("ALIAS_HOST_NAME_LABEL"), 0);
        this.hostName = new TextField("", 16);
        this.fullyQualifiedLabel = new Label(this.resources.getString("FULLY_QUALIFIED_LABEL"), 0);
        this.domainNameLabel = new Label(this.resources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainName = new Choice();
        this.domainName.addItemListener(this);
        this.ttlPanel = new Panel();
        this.ttlExplanation = new WrappedTextPanel(this.resources.getString("TTL_EXPLANATION_LABEL"));
        this.ttlAliasPanel = new TTLPanel(this.parent.MyParent.clientResources, this.resources.getString("TTL_ALIAS_LABEL"));
        this.commentsPanel = new RecordsPanel(this.resources.getString("ALIAS_COMMENTS_EXPLANATION_LABEL"));
        this.sigAndKeyPanel = new RecordsPanel(this.resources.getString("ALIAS_SIG_KEY_EXPLANATION_LABEL"));
        this.sigAndKeyPanel.setEnabled(false);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("AHF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("AHF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.layoutCfgPanel(gridBagConstraints);
        this.layoutTTLPanel(gridBagConstraints);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.checkRequiredFields() && this.validateFields()) {
            this.parent.SaveAndExit(this);
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            String string = this.tabView.getSelectedTab().getText();
            if (string.equals(this.resources.getString("TABVIEW_ALIAS_CFG_LABEL"))) {
                this.parent.MyParent.handleHelp("ddscnbac.htm#HDRNBATC");
                return;
            }
            if (string.equals(this.resources.getString("TABVIEW_TTL_LABEL"))) {
                this.parent.MyParent.handleHelp("ddscnbat.htm#HDRNBATT");
                return;
            }
            if (string.equals(this.resources.getString("TABVIEW_COMMENTS_LABEL"))) {
                this.parent.MyParent.handleHelp("ddscnbax.htm#HDRNBATX");
                return;
            }
            if (string.equals(this.resources.getString("TABVIEW_SIG_KEY_LABEL"))) {
                this.parent.MyParent.handleHelp("ddscnbak.htm#HDRNBATK");
                return;
            }
            this.parent.MyParent.handleHelp("ddscnba.htm#HDRNBA");
        }
    }

    private boolean checkRequiredFields() {
        boolean bl = true;
        String string = new String(this.getAliasName());
        String string2 = new String(this.getHostName());
        if (string == null || string.length() <= 0) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.okBox = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), this.resources.getString("ALIAS_NAME_REQUIRED_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        } else if (string2 == null || string2.length() <= 0) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.okBox = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), this.resources.getString("HOST_NAME_REQUIRED_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        return bl;
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    private void layoutCfgPanel(GridBagConstraints gridBagConstraints) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.cfgPanel.setLayout(gridBagLayout);
        gridBagConstraints2.fill = 0;
        this.constrain(this.hostNameLabel, gridBagLayout, gridBagConstraints2, 0, 0, 1, 1);
        this.cfgPanel.add(this.hostNameLabel);
        this.constrain(this.hostName, gridBagLayout, gridBagConstraints2, 1, 0, 1, 1);
        this.cfgPanel.add(this.hostName);
        this.constrain(this.fullyQualifiedLabel, gridBagLayout, gridBagConstraints2, 2, 0, 0, 1);
        this.cfgPanel.add(this.fullyQualifiedLabel);
        this.constrain(this.aliasNameLabel, gridBagLayout, gridBagConstraints2, 0, 1, 1, 1);
        this.cfgPanel.add(this.aliasNameLabel);
        this.constrain(this.aliasName, gridBagLayout, gridBagConstraints2, 1, 1, 1, 1);
        this.cfgPanel.add(this.aliasName);
        gridBagConstraints2.fill = 0;
        this.constrain(this.domainNameLabel, gridBagLayout, gridBagConstraints2, 2, 1, 1, 1);
        this.cfgPanel.add(this.domainNameLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainName, gridBagLayout, gridBagConstraints2, 3, 1, 0, 0);
        this.cfgPanel.add(this.domainName);
    }

    private void layoutTTLPanel(GridBagConstraints gridBagConstraints) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        int n = this.ttlExplanation.getNumDividedTextLines();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        this.ttlPanel.setLayout(gridBagLayout);
        this.constrain(this.ttlExplanation, gridBagLayout, gridBagConstraints2, 0, 0, 0, n);
        this.ttlPanel.add(this.ttlExplanation);
        gridBagConstraints2.fill = 2;
        this.constrain(this.ttlAliasPanel, gridBagLayout, gridBagConstraints2, 0, n, 0, 1);
        this.ttlPanel.add(this.ttlAliasPanel);
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!TcpipValidation.IsValidNonFQTcpipName(this.getAliasName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), this.resources.getString("INVALID_ALIAS_NAME_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        } else if (!TcpipValidation.IsValidFQTcpipName(this.getHostName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else {
            this.getAliasTTL();
            if (!this.ttlAliasPanel.isValidTTL()) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[1]);
                this.invalidBox = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), this.resources.getString("INVALID_ALIAS_TTL_TEXT"), 1, true, this);
                this.selectAll(2);
                this.requestFocus(2);
                bl = false;
            }
        }
        return bl;
    }

    private void checkToDisableNames() {
        if (this.getAliasName().compareTo("") != 0) {
            this.aliasNameLabel.setEnabled(false);
            this.aliasName.setEnabled(false);
            ((Component)this.aliasName).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            this.domainNameLabel.setEnabled(false);
            this.domainName.setEnabled(false);
            this.domainName.setBackground(DDNSUtility.BACKGROUND_COLOR);
            return;
        }
        this.aliasNameLabel.setEnabled(true);
        this.aliasName.setEnabled(true);
        ((Component)this.aliasName).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
        this.domainNameLabel.setEnabled(true);
        this.domainName.setEnabled(true);
        this.domainName.setBackground(Color.white);
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[4];
        int n = 0;
        while (n < 4) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_ALIAS_CFG_LABEL"));
        this.tabNodes[0].setPanel(this.cfgPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_TTL_LABEL"));
        this.tabNodes[1].setPanel(this.ttlPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_COMMENTS_LABEL"));
        this.tabNodes[2].setPanel((Panel)this.commentsPanel);
        this.tabNodes[3].setText(this.resources.getString("TABVIEW_SIG_KEY_LABEL"));
        this.tabNodes[3].setPanel((Panel)this.sigAndKeyPanel);
        int n = 0;
        while (n < 4) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.domainName) {
            this.domainName.select(this.domainName.getSelectedItem());
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        String string = this.getAliasName();
        if (string.compareTo("") == 0) {
            this.setTitle(this.resources.getString("ALIAS_HOST_FRAME_NAME"));
        } else {
            this.setTitle(String.valueOf(this.resources.getString("ALIAS_HOST_FRAME_NAME")) + " -- " + string);
        }
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.ttlAliasPanel.selectAll(0);
                this.ttlAliasPanel.requestFocus(0);
                return;
            }
            if (tabViewNode != this.tabNodes[2] && tabViewNode != this.tabNodes[3]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
        } else {
            this.selectTabForError = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

