/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.AddHostFrame;
import COM.ibm.raleigh.ddnssgui.client.CreateDomainDialog;
import COM.ibm.raleigh.ddnssgui.client.DDNSManager;
import COM.ibm.raleigh.ddnssgui.client.HostFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class AddHostMgr
extends DDNSManager {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private ResourceBundle resources;
    private HostObject aHost;
    private Vector owningDomainName;
    private String initialDomain;
    private AddHostFrame theWizPanel;
    private HostFrame aHostPanel;
    private Vector hostsToAdd;
    private String[] domList;
    private PrimaryDomain pDom;
    private DomainNameAndIpAddress detailedHostData;
    private Vector newDomains;

    public AddHostMgr(MainFrame mainFrame) {
        super(mainFrame);
        this.resources = mainFrame.clientResources;
        this.owningDomainName = new Vector();
        this.initialDomain = null;
        this.hostsToAdd = new Vector();
        this.newDomains = new Vector();
    }

    public void exit() {
        if (this.theWizPanel != null) {
            this.theWizPanel.dispose();
            if (this.aHostPanel != null) {
                this.aHostPanel.dispose();
            }
        }
    }

    public boolean isShowing() {
        return this.theWizPanel != null;
    }

    public void requestFocus() {
        if (this.theWizPanel != null) {
            this.theWizPanel.requestFocus();
        }
    }

    public void CreateNewHost() {
        this.CreateNewHost("");
    }

    public void CreateNewHost(String string) {
        this.initialDomain = new String(string);
        if (string != null && !string.equals("")) {
            Question question = new Question(1, string);
            if (question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                this.MyParent.dataOut.sendToServer("PDOM=GET,name=" + string + "," + "EPDOM" + ",");
                DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                this.pDom = new PrimaryDomain(dDNSNetworkStringParser.getParsed());
            } else {
                this.pDom = null;
            }
        } else {
            this.pDom = null;
        }
        this.theWizPanel = new AddHostFrame(this);
        this.InitWizardFrame();
    }

    public boolean isUniqueHost(String string, String string2) {
        boolean bl = true;
        Question question = new Question(3, string, string2);
        if (!question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
            Object[] objectArray = new Object[]{string, string2};
            new msgBox(this.resources, this.resources.getString("APP_TITLE"), MessageFormat.format(this.resources.getString("AHM_DUP_MSG"), objectArray), 1, true, this.theWizPanel);
            bl = false;
        }
        return bl;
    }

    private void InitWizardFrame() {
        RequestList requestList = new RequestList(3);
        this.domList = requestList.getReturnedList(this.resources, this.MyParent.dataOut);
        this.theWizPanel.setFullyQualifiedDomainNameList(this.domList);
        if (this.initialDomain != null) {
            this.theWizPanel.setFullyQualifiedDomainName(this.initialDomain);
        }
        Dimension dimension = this.theWizPanel.getMinSize();
        this.theWizPanel.setEnabled(true);
        ((Component)this.theWizPanel).setVisible(true);
        this.theWizPanel.requestFocus();
    }

    private void InitHostFrame(String string) {
        this.aHostPanel = new HostFrame(this);
        this.aHostPanel.setFullyQualifiedDomainNameList(this.domList);
        this.aHostPanel.setFullyQualifiedDomainName(string);
        this.aHostPanel.setHostName(this.aHost.getHostName());
        this.aHostPanel.setIPAddrList(this.aHost.getAllIpAddresses());
        this.aHostPanel.setPlatformList(this.aHost.getCpuOpSys());
        this.aHostPanel.setMailList(this.aHost.getMailExchange());
        this.aHostPanel.setHostTextList(this.aHost.getTextEntry());
        this.aHostPanel.setTTLForHostName(this.aHost.getATTL());
        this.aHostPanel.setTTLForIPAddr(this.aHost.getPTRTTL());
        this.aHostPanel.setTTLForMail(this.aHost.getMXTTL());
        this.aHostPanel.setTTLForPlatform(this.aHost.getHINFOTTL());
        this.aHostPanel.setTTLForText(this.aHost.getTXTTTL());
        this.aHostPanel.setComments(this.makeCommentsDisplayable(this.aHost.getComments()));
        this.aHostPanel.setSigAndKeyRecords(this.aHost.getKeyAndSigRecs());
        this.aHostPanel.setOtherRecords(this.aHost.getOtherRecs());
        Dimension dimension = this.aHostPanel.getMinSize();
        this.aHostPanel.setEnabled(true);
        this.aHostPanel.setEnabledButtons(true);
        ((Component)this.aHostPanel).setVisible(true);
        this.aHostPanel.requestFocus();
    }

    private boolean saveDetailHostData() {
        if (this.aHost != null) {
            this.aHost.setHostName(this.aHostPanel.getHostName());
            String[] stringArray = this.aHostPanel.getIPAddrList();
            this.aHost.addAllIpAddresses(stringArray);
            this.aHost.setCpuOpSys(this.aHostPanel.getPlatformList());
            this.aHost.setMailExchange(this.aHostPanel.getMailList());
            this.aHost.setTextEntry(this.aHostPanel.getHostTextList());
            this.aHost.setATTL(this.aHostPanel.getTTLForHostName());
            this.aHost.setPTRTTL(this.aHostPanel.getTTLForIPAddr());
            this.aHost.setMXTTL(this.aHostPanel.getTTLForMail());
            this.aHost.setHINFOTTL(this.aHostPanel.getTTLForPlatform());
            this.aHost.setTXTTTL(this.aHostPanel.getTTLForText());
            this.aHost.setComments(this.makeCommentsValid(this.aHostPanel.getComments()));
            this.aHost.setOtherRecs(this.aHostPanel.getOtherRecords());
            this.hostsToAdd.addElement(this.aHost);
            if (stringArray == null || stringArray.length == 0) {
                this.detailedHostData.setIpAddress("");
            } else if (!this.detailedHostData.getIpAddress().equals(stringArray[0])) {
                this.detailedHostData.setIpAddress(stringArray[0]);
            }
            this.aHost = null;
            return true;
        }
        return false;
    }

    private void SaveAllData(DomainNameAndIpAddressList domainNameAndIpAddressList) {
        String string = null;
        PrimaryDomain primaryDomain = null;
        Enumeration enumeration = domainNameAndIpAddressList.elements();
        BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.resources, this.resources.getString("AHM_WAIT_MESSAGE"));
        ((Component)busyWaitFrame).setSize(300, 75);
        busyWaitFrame.doLayout();
        ((Component)busyWaitFrame).setVisible(true);
        busyWaitFrame.repaint();
        while (enumeration.hasMoreElements()) {
            DomainNameAndIpAddress domainNameAndIpAddress = (DomainNameAndIpAddress)enumeration.nextElement();
            if (this.isNotSameDomain(string, domainNameAndIpAddress)) {
                primaryDomain = this.getTheDomainObj(domainNameAndIpAddress);
                this.owningDomainName.addElement(primaryDomain.getDomName());
            }
            string = domainNameAndIpAddress.getDomainName();
            this.aHost = this.getHostObjFor(domainNameAndIpAddress);
            if (primaryDomain.getReverseMappingState()) {
                this.doReverseMapping(this.aHost, string);
            }
            this.MyParent.dataOut.sendToServer(this.aHost.toString("ADD", "dname=" + string));
            this.MyParent.dataOut.receiveFromServer();
            this.MyParent.dataOut.sendToServer(this.aHost.toString("LNK", "dname=" + string));
            this.MyParent.dataOut.receiveFromServer();
        }
        if (!this.newDomains.isEmpty()) {
            Object[] objectArray = new String[this.newDomains.size()];
            this.newDomains.copyInto(objectArray);
            CreateDomainDialog createDomainDialog = new CreateDomainDialog(this.MyParent, this.resources.getString("APP_TITLE"), (String[])objectArray);
            createDomainDialog.getMinSize();
            ((Component)createDomainDialog).setVisible(true);
        }
        busyWaitFrame.dispose();
    }

    public void doDetails(DomainNameAndIpAddress domainNameAndIpAddress) {
        this.aHost = this.getHostObjFor(domainNameAndIpAddress);
        this.InitHostFrame(domainNameAndIpAddress.getDomainName());
        this.theWizPanel.setEnabled(false);
        this.detailedHostData = domainNameAndIpAddress;
    }

    public void SaveAndExit(Object object) {
        this.aHostPanel.setEnabled(false);
        this.aHostPanel.setEnabledButtons(false);
        String string = this.detailedHostData.getIpAddress();
        this.saveDetailHostData();
        this.aHostPanel.dispose();
        this.aHostPanel = null;
        this.theWizPanel.setEnabled(true);
        if (this.detailedHostData != null) {
            if (!this.theWizPanel.isInList(this.detailedHostData, 1)) {
                this.theWizPanel.addToList(this.detailedHostData);
            } else if (!string.equals(this.detailedHostData)) {
                this.theWizPanel.replaceHostInList(this.detailedHostData);
            }
            this.detailedHostData = null;
        }
    }

    public void CancelAndExit(Object object) {
        this.aHostPanel.setEnabled(false);
        this.aHostPanel.setEnabledButtons(false);
        this.aHostPanel.dispose();
        this.aHostPanel = null;
        this.detailedHostData = null;
        this.theWizPanel.setEnabled(true);
    }

    public void SaveAndExit(DomainNameAndIpAddressList domainNameAndIpAddressList) {
        this.theWizPanel.setEnabled(false);
        this.SaveAllData(domainNameAndIpAddressList);
        this.theWizPanel.dispose();
        this.theWizPanel = null;
        this.aHost = null;
        if (!this.owningDomainName.isEmpty()) {
            Object[] objectArray = new String[this.owningDomainName.size()];
            this.owningDomainName.copyInto(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null && !((String)objectArray[n]).equals("")) {
                    this.MyParent.changed(this, (String)objectArray[n]);
                }
                ++n;
            }
        } else {
            this.MyParent.changed(this);
        }
        this.MyParent.requestFocus();
    }

    public void CancelAndExit() {
        this.theWizPanel.setEnabled(false);
        this.theWizPanel.dispose();
        this.theWizPanel = null;
        this.MyParent.changed(this);
        this.MyParent.requestFocus();
    }

    private HostObject getHostObjFor(DomainNameAndIpAddress domainNameAndIpAddress) {
        HostObject hostObject;
        if (this.hostsToAdd != null && this.hostsToAdd.size() != 0) {
            Enumeration enumeration = this.hostsToAdd.elements();
            while (enumeration.hasMoreElements()) {
                hostObject = (HostObject)enumeration.nextElement();
                if (!hostObject.getHostName().equalsIgnoreCase(domainNameAndIpAddress.getFqName())) continue;
                return hostObject;
            }
        }
        hostObject = new HostObject();
        hostObject.setHostName(domainNameAndIpAddress.getFqName());
        hostObject.setIpAddress(domainNameAndIpAddress.getIpAddress());
        return hostObject;
    }

    private PrimaryDomain getTheDomainObj(DomainNameAndIpAddress domainNameAndIpAddress) {
        this.MyParent.dataOut.sendToServer("PDOM=GET,name=" + domainNameAndIpAddress.getDomainName() + "," + "EPDOM" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        return new PrimaryDomain(dDNSNetworkStringParser.getParsed());
    }

    private void doReverseMapping(HostObject hostObject, String string) {
        String[] stringArray = hostObject.getAllIpAddresses();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Question question = new Question(4, stringArray[n]);
                int n2 = question.getIntFromString(this.MyParent.dataOut);
                if (n2 != 1) {
                    DDNSNetworkStringParser dDNSNetworkStringParser;
                    if (n2 == 2) {
                        this.newDomains.addElement(ReverseHost.reverseDomainFromAddrClassC(stringArray[n]));
                        this.MyParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=MAP," + "addr=" + stringArray[n] + "," + "name=" + hostObject.getHostName() + "," + "state=" + 2 + "," + "dname=" + string + "," + "ptrttl=" + hostObject.getPTRTTL() + "," + ReverseHost.EREVH_tag + ",");
                        dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                        this.MyParent.changed((Object)this, hostObject.getHostName(), ReverseHost.reverseDomainFromAddrClassC(stringArray[n]));
                    } else {
                        String string2 = "";
                        this.MyParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=MAP," + "addr=" + stringArray[n] + "," + "name=" + hostObject.getHostName() + "," + "state=" + 0 + "," + "dname=" + string + "," + "ptrttl=" + hostObject.getPTRTTL() + "," + ReverseHost.EREVH_tag + ",");
                        dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
                        ParsedObject parsedObject = parsedVector.getElement("dname");
                        String string3 = null;
                        string3 = parsedObject != null ? new String((String)parsedObject.getValue()) : ReverseHost.reverseDomainFromAddrClassC(stringArray[n]);
                        if (string2 != null) {
                            this.MyParent.changed((Object)this, hostObject.getHostName(), string3);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private boolean isNotSameDomain(String string, DomainNameAndIpAddress domainNameAndIpAddress) {
        if (string != null) {
            return !string.equalsIgnoreCase(domainNameAndIpAddress.getDomainName());
        }
        return true;
    }

    private String[] makeCommentsValid(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = !stringArray[n].startsWith(";") ? new String(";" + stringArray[n]) : stringArray[n];
                ++n;
            }
        }
        return stringArray2;
    }

    private String[] makeCommentsDisplayable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = !stringArray[n].startsWith(";") ? stringArray[n] : stringArray[n].substring(1);
                ++n;
            }
        }
        return stringArray2;
    }
}

