#ifndef STRESS_H
#define STRESS_H
/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: STRESS
 *
 * Purpose: Include file for STRESS.DLL
 *
 *  $header$
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *                 - created initial file
 *               12/17/90, PDVT, Mike Abuzant
 *                 - Added function prototypes
 *                 - Deleted 'hAB' parameter.
 *               12/28/90, PDVT, Darin C. Hafer
 *                 - Adjust from GRETXTST.H
 *
 * SRS References:
 *
 * Contents:  This file contains the following definitions:
 *              - function prototypes
 *                        - define's specific to STRESS
 *
 * Limitations:
 *           none
 *\\end
 *****************************************************************************/



/*---------------------- Declare all dll functions -----------------------*/
//
VOID  APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);
VOID  APIENTRY GpiClipFontExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiClipBitsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiClipColorExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiMaxPolyLinesExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiMaxPolySplinesExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiCharBoxMetricsInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiCharBoxMetricsDefault(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiSpaceInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiBitMapClipExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiThinLinesInPath(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiThickLinesInPath(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiShadeCharactersInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID  APIENTRY GpiShadeCharactersDefault(HPS hPS,HWND hWndClient,BOOL SelectionCall);

INT GpiApp4           (HPS hPS, HWND hWndClient);

/*---------------------- Declare all dll subroutines ---------------------*/
BOOL FaceList(HPS hPS, HWND hWndClient, LONG Enum, POINTL *pptl,
              LONG syPosition, LONG Number, PTEMPTYPE *FontStorage);
LONG PrintFonts(HPS hPS, HWND hWndClient, POINTL *pptl);
MRESULT EXPENTRY FontListDlgProc( HWND hwndDlg, USHORT msg,
                                     MPARAM mp1, MPARAM mp2 );
/*------------------------------------------------------------------------*/

#define USER_LCID 1L
#define NUMLINES  (sizeof(devcaps) / sizeof(devcaps[0]))

#define TOKENIZEFUNCTIONNAME(FunctionName) {#FunctionName,FunctionName}

#define  FOURT_BITMAP_ID     104
#define  FIFTH_BITMAP_ID     105

#define  CHS_UNDERSCORE 0x0200L
#define  CHS_STRIKEOUT  0x0400L

#define  NUMBEROFELEMENTS(ArrayName)  (sizeof(ArrayName)/sizeof(ArrayName[0]))

static  NAMES_AND_ADDRESSES EntryPointList[]=
    {
        TOKENIZEFUNCTIONNAME(GpiClipFontExh                  ),
        TOKENIZEFUNCTIONNAME(GpiClipBitsExh                  ),
        TOKENIZEFUNCTIONNAME(GpiClipColorExh                 ),
        TOKENIZEFUNCTIONNAME(GpiMaxPolyLinesExh              ),
        TOKENIZEFUNCTIONNAME(GpiMaxPolySplinesExh            ),
        TOKENIZEFUNCTIONNAME(GpiCharBoxMetricsInteractive    ),
        TOKENIZEFUNCTIONNAME(GpiCharBoxMetricsDefault        ),
        TOKENIZEFUNCTIONNAME(GpiSpaceInteractive             ),
        TOKENIZEFUNCTIONNAME(GpiBitMapClipExh                ),
        TOKENIZEFUNCTIONNAME(GpiThinLinesInPath              ),
        TOKENIZEFUNCTIONNAME(GpiThickLinesInPath             ),
        TOKENIZEFUNCTIONNAME(GpiShadeCharactersInteractive   ),
        TOKENIZEFUNCTIONNAME(GpiShadeCharactersDefault       )
    };

#ifdef MAINSOURCEFILE

struct {
    LONG  lIndex;
    CHAR  *szIdentifier;
  }
  devcaps[] =
  {
    CAPS_FAMILY                       , "CAPS_FAMILY",
    CAPS_IO_CAPS                      , "CAPS_IO_CAPS",
    CAPS_TECHNOLOGY                   , "CAPS_TECHNOLOGY",
    CAPS_DRIVER_VERSION               , "CAPS_DRIVER_VERSION",
    CAPS_HEIGHT                       , "CAPS_HEIGHT",
    CAPS_WIDTH                        , "CAPS_WIDTH",
    CAPS_HEIGHT_IN_CHARS              , "CAPS_HEIGHT_IN_CHARS",
    CAPS_WIDTH_IN_CHARS               , "CAPS_WIDTH_IN_CHARS",
    CAPS_VERTICAL_RESOLUTION          , "CAPS_VERTICAL_RESOLUTION",
    CAPS_HORIZONTAL_RESOLUTION        , "CAPS_HORIZONTAL_RESOLUTION",
    CAPS_CHAR_HEIGHT                  , "CAPS_CHAR_HEIGHT",
    CAPS_CHAR_WIDTH                   , "CAPS_CHAR_WIDTH",
    CAPS_SMALL_CHAR_HEIGHT            , "CAPS_SMALL_CHAR_HEIGHT",
    CAPS_SMALL_CHAR_WIDTH             , "CAPS_SMALL_CHAR_WIDTH",
    CAPS_COLORS                       , "CAPS_COLORS",
    CAPS_COLOR_PLANES                 , "CAPS_COLOR_PLANES",
    CAPS_COLOR_BITCOUNT               , "CAPS_COLOR_BITCOUNT",
    CAPS_COLOR_TABLE_SUPPORT          , "CAPS_COLOR_TABLE_SUPPORT",
    CAPS_MOUSE_BUTTONS                , "CAPS_MOUSE_BUTTONS",
    CAPS_FOREGROUND_MIX_SUPPORT       , "CAPS_FOREGROUND_MIX_SUPPORT",
    CAPS_BACKGROUND_MIX_SUPPORT       , "CAPS_BACKGROUND_MIX_SUPPORT",
    CAPS_VIO_LOADABLE_FONTS           , "CAPS_VIO_LOADABLE_FONTS",
    CAPS_WINDOW_BYTE_ALIGNMENT        , "CAPS_WINDOW_BYTE_ALIGNMENT",
    CAPS_BITMAP_FORMATS               , "CAPS_BITMAP_FORMATS",
    CAPS_RASTER_CAPS                  , "CAPS_RASTER_CAPS",
    CAPS_MARKER_HEIGHT                , "CAPS_MARKER_HEIGHT",
    CAPS_MARKER_WIDTH                 , "CAPS_MARKER_WIDTH",
    CAPS_DEVICE_FONTS                 , "CAPS_DEVICE_FONTS",
    CAPS_GRAPHICS_SUBSET              , "CAPS_GRAPHICS_SUBSET",
    CAPS_GRAPHICS_VERSION             , "CAPS_GRAPHICS_VERSION",
    CAPS_GRAPHICS_VECTOR_SUBSET       , "CAPS_GRAPHICS_VECTOR_SUBSET",
    CAPS_DEVICE_WINDOWING             , "CAPS_DEVICE_WINDOWING",
    CAPS_ADDITIONAL_GRAPHICS          , "CAPS_ADDITIONAL_GRAPHICS",
    CAPS_PHYS_COLORS                  , "CAPS_PHYS_COLORS",
    CAPS_COLOR_INDEX                  , "CAPS_COLOR_INDEX",
    CAPS_GRAPHICS_CHAR_WIDTH          , "CAPS_GRAPHICS_CHAR_WIDTH",
    CAPS_GRAPHICS_CHAR_HEIGHT         , "CAPS_GRAPHICS_CHAR_HEIGHT",
    CAPS_HORIZONTAL_FONT_RES          , "CAPS_HORIZONTAL_FONT_RES",
    CAPS_VERTICAL_FONT_RES            , "CAPS_VERTICAL_FONT_RES",
  };

struct {
    CHAR *szMetric;
  }
  FontMets[] =
  {
    "IDRegistry"         ,
    "CodePage"           ,
    "EmHeight"           ,
    "XHeight"            ,
    "MaxAscender"        ,
    "MaxDescender"       ,
    "LowerCaseAscent"    ,
    "LowerCaseDescent"   ,
    "InternalLeading"    ,
    "ExternalLeading"    ,
    "AveCharWidth"       ,
    "MaxCharInc"         ,
    "EmInc"              ,
    "MaxBaselineExt"     ,
    "CharSlope"          ,
    "InlineDir"          ,
    "CharRot"            ,
    "WeightClass"        ,
    "WidthClass"         ,
    "XDeviceRes"         ,
    "YDeviceRes"         ,
    "FirstChar"          ,
    "LastChar"           ,
    "DefaultChar"        ,
    "BreakChar"          ,
    "NominalPointSize"   ,
    "MinimumPointSize"   ,
    "MaximumPointSize"   ,
    "FSType"             ,
    "FSDefn"             ,
    "FSSelection"        ,
    "FSCapabilities"     ,
    "SubscriptXSize"     ,
    "SubscriptYSize"     ,
    "SubscriptXOffset"   ,
    "SubscriptYOffset"   ,
    "SuperscriptXSize"   ,
    "SuperscriptYSize"   ,
    "SuperscriptXOffset" ,
    "SuperscriptYOffset" ,
    "UnderscoreSize"     ,
    "UnderscorePosition" ,
    "StrikeoutSize"      ,
    "StrikeoutPosition"  ,
    "KerningPairs"       ,
    "FamilyClass"        ,
    "Match"              ,
   };

USHORT Offset[] = {0,32,
                   64,66,
                   68,72,76,80,84,88,92,96,100,104,108,112,116,
                   118,120,122,124,126,128,130,132,134,
                   136,138,140,142,144,146,148,150,152,
                   156,160,164,168,172,176,180,184,188,192,196,200,
                   202,204,208};

PCHAR  TestCaseName = "STRESS";
CHAR   achLogLine[256];
CHAR   sOut[256];
POINTL ptl;
BOOL   bSuccess;
LONG   lSuccess;
LONG   ErrorCount=0L;

#else
   extern CHAR   achLogLine[];
   extern POINTL ptl;
   extern BOOL   bSuccess;
   extern LONG   lSuccess;
   extern LONG   ErrorCount;
#endif


#endif
