#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define INCL_PRF
#define INCL_DEV
#define INCL_ERRORS   // include all error definitions
#define INCL_DOSINFOSEG
#define INCL_DOSMODULEMGR
#define MAINSOURCEFILE
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <malloc.h>
#include <search.h>
#include <math.h>
#include <process.h>
#include "PTTDLLDF.h"                // test case defines
#include "common.h"
#include "STRESS.h"                 // gre text dll include file

#define  FXTOLONG 65536

VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO init_info_p)
{
  register USHORT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(sel);
  return;
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiClipFontExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           clipping of available fonts.
 *
 * Restrictions:  This test must not be run in STD mode!
 *
 * Revision Log: 09/27/91, PDVT, Timothy S. Seevers
 *                 - Test Case Design and Implementation
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiClipFontExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiClipFontExh";
  LONG   PubFonts=0L;
  LONG   PriFonts=0L;
  LONG   Index=0L, xVal;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y));   // - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    xVal = ptl.x;

    // To make display output look as much like printer output,
    // the x coordinates will differ.
    if DeviceIsDisplay()
      ptl.x += MapX(80);
    else
      ptl.x += MapX(100);
    ptl.x = xVal;
    ptl.y -= syPosition;

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);



    for (Index=0; Index < PubFonts; Index++) {
      if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, USER_LCID))
        CLEANUP("GpiSetCharSet", EntryName);
      if ((lSuccess = PrintFonts(hPS, hWndClient, &ptl)) == 1)
        CLEANUP("PrintFonts", EntryName);
      else if (lSuccess == -1) {
        EXIT_MAIN(EntryName);
        return;
      }
    } /* End For */

    free(FontStorage);


    /********************************************************************
    /*        Return the proper log messages for GPI's.
    /********************************************************************/

    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    if (!GpiResetPS(hPS, GRES_ALL))
      CLEANUP("GpiResetPS", EntryName);

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiClipFontExh */


/***************************************************************************
 *\\ddd
 * Routine Name: PrintFonts
 *
 * Purpose: To get, create, and print info about the fonts.
 *
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   If output is to the display and at bottom of display, return -1.
 *   If output is to the printer and at bottom of page
 *     Start a new page (DevEscape).
 *     Return to the default font.
 *     Print test signature.
 *     Print header.
 *     Return to previous logical font when this function was called.
 *   Endif
 *
 *   Print the font facename in its native typeface.
 *
 *   Delete the logical font and return to the default.
 *
 *   Print NominalPointSize, Match Number, CodePage, Bold or not,
 *   Underline or not, Italic or not, Outline or not.
 *
 *\\end
 ***************************************************************************/
LONG PrintFonts(HPS hPS, HWND hWndClient, POINTL *pptl)
{
  HDC   hDC;
  LONG  yChar, xVal;
  FONTMETRICS fm;
  POINTL PathPtl;
  POINTL delta_ptl;
  ARCPARAMS arcparam1;

   // HDC used in DevEscape call
   hDC = GpiQueryDevice(hPS);

      PathPtl.x = 0;
      PathPtl.y = (LONG)delta_y/2;
      MapPt(PathPtl);
      GpiMove(hPS, &PathPtl);

      PathPtl.x = delta_x*4;
      PathPtl.y = delta_y*11;
      MapPt(PathPtl);

      GpiBeginPath(hPS, 1L);


    // Delta x and y initialization

         delta_ptl.x = delta_x/8;
         delta_ptl.y = delta_y/8;

         arcparam1.lR = 8*delta_ptl.x;
         arcparam1.lQ = 4*delta_ptl.y;
         arcparam1.lP = -5*delta_ptl.x;
         arcparam1.lS = 4*delta_ptl.y;
         MapArc(arcparam1);
         GpiSetArcParams (hPS, &arcparam1);

         PathPtl.x = delta_x*3;
         PathPtl.y = (LONG)delta_y*2+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

         PathPtl.x = delta_x*5;
         PathPtl.y = (LONG)delta_y*8+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

      GpiEndPath( hPS );
      GpiStrokePath( hPS, 1L, 0L );



      GpiBeginPath(hPS, 1L);


    // Delta x and y initialization

         delta_ptl.x = delta_x/8;
         delta_ptl.y = delta_y/8;

         arcparam1.lR = 8*delta_ptl.x;
         arcparam1.lQ = 4*delta_ptl.y;
         arcparam1.lP = -5*delta_ptl.x;
         arcparam1.lS = 4*delta_ptl.y;
         MapArc(arcparam1);
         GpiSetArcParams (hPS, &arcparam1);

         PathPtl.x = delta_x*3;
         PathPtl.y = (LONG)delta_y*2+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

         PathPtl.x = delta_x*5;
         PathPtl.y = (LONG)delta_y*8+(LONG)(delta_y/4);
         MapPt(PathPtl);
         GpiMove(hPS, &PathPtl);
         GpiFullArc( hPS, DRO_OUTLINE, 65536*2 );

      GpiEndPath( hPS );


   // Get fontmetrics of Current Logical Font.
   if (!GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)) {
     CLEANUP("GpiQueryFontMetrics", "PrintFonts");
     return 1L;
   }

   yChar = fm.lMaxBaselineExt + fm.lExternalLeading;
   if (syPosition > (SHORT)yChar)
     pptl->y -= syPosition;
   else
     pptl->y -= yChar;


      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
   if ((UnMapY(pptl->y) <= 75L) && DeviceIsDisplay()) {
     if (!GpiSetCharSet(hPS,LCID_DEFAULT))
       CLEANUP("GpiSetCharSet", "PrintFonts");
     if (!GpiDeleteSetId(hPS,LCID_ALL))
       CLEANUP("GpiDeleteSetId", "PrintFonts");
     return -1L;
   }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
   if ( (UnMapY(pptl->y) <= 50L) && (DeviceIsPrinter()) ) {
     if ((lSuccess = DevEscape(hDC, DEVESC_NEWFRAME,
                               0L, NULL, 0L, NULL)) == DEVESC_ERROR) {
       CLEANUP("DevEscape", "PrintFonts");
       return 1L;
     }

     if (!GpiSetCharSet(hPS,DESIRED_FONT_ID)) {
       CLEANUP("GpiSetCharSet", "PrintFonts");
       return 1L;
     }
     GpiSetClipPath( hPS, 0L, SCP_RESET );
     TEST_SIGNATURE(0,0);

     xVal = pptl->x;

     pptl->y=MapY((LONG) (pg_size_y) * delta_y);
     pptl->y -= 2*syPosition;

     // Move down two lines.
     pptl->x = xVal;
     pptl->y -= 2*syPosition;

     if (!GpiSetCharSet(hPS,USER_LCID)) {
       CLEANUP("GpiSetCharSet", "PrintFonts");
       return 1L;
     }
   } /* End Printer */


   GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND );


   sprintf(achLogLine, "abcdefghijklmnopqurstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890/!@#$%^&*()_+=abcdefghijklmnopqurstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890/!@#$%^&*()_+=abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ" );
   GpiMove(hPS, pptl);
   GpiCharString(hPS, (LONG)strlen(achLogLine), achLogLine);

   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", "PrintFonts");
     return 1L;
   }
   if (!GpiDeleteSetId(hPS,USER_LCID)) {
     CLEANUP("GpiDeleteSetId", "PrintFonts");
     return 1L;
   }

 return 0L;
}

//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiClipBitsExh tests the ability of the driver to clip the
//  GpiSetPel command.  A clip path in the shape of a star is
//  defined and set.  Then a grid of pels are drawn accross the
//  clip path.
//
//*************************************************************************

VOID APIENTRY GpiClipBitsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  SHORT    i;
  LONG     sX, sY;
  POINTL   Pline[6];
  POINTL   PelPt;
  static PCHAR EntryName="GpiClipBitsExh";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    Pline[0].x = delta_x*2-(LONG)(delta_x/2);
    Pline[0].y = delta_y*2;
    Pline[1].x = delta_x*3+(LONG)(delta_x/2);
    Pline[1].y = delta_y*6+(LONG)(delta_y/2);
    Pline[2].x = delta_x*5+(LONG)(delta_x/2);
    Pline[2].y = delta_y*2;
    Pline[3].x = delta_x*1;
    Pline[3].y = delta_y*5;
    Pline[4].x = delta_x*6;
    Pline[4].y = delta_y*5;
    Pline[5].x = delta_x*2-(LONG)(delta_x/2);
    Pline[5].y = delta_y*2;

    for( i=0; i<=5; i++ )
       MapPt( Pline[i] );

   if( GpiMove(hPS, &Pline[0]) == FALSE )
       CLEANUP("GpiMove", EntryName);

   if( GpiBeginPath(hPS, 1L) == FALSE )
       CLEANUP("GpiBeginPath", EntryName);

      if( GpiSetLineWidthGeom( hPS, 150L ) == FALSE )
          CLEANUP("GpiSetLineWidthGeom", EntryName);
      if( GpiPolyLine(hPS, 6L, Pline ) != GPI_OK)
          CLEANUP("GpiPolyLine", EntryName);

    if( GpiEndPath( hPS ) == FALSE )
        CLEANUP("GpiEndPath", EntryName);

    if( GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE )
        CLEANUP("GpiSetClipPath", EntryName);

    for( sY=Pline[0].y; sY<=Pline[1].y; sY+=2 ) {
          for( sX=Pline[3].x; sX<=Pline[4].x; sX+=3 ) {
                 PelPt.x = sX;
                 PelPt.y = sY;
                 if( GpiSetPel( hPS, &PelPt ) != GPI_OK )
                     CLEANUP("GpiSetPel", EntryName);
               }
      }

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiClipBitsExh */


//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiClipColorExh tests the ability of the driver to clip when
//  color shading is involved.  A clip path in the shape of a circle is
//  defined and set.  Then a color pattern is drawn accross the
//  clip path.
//
//*************************************************************************

VOID APIENTRY GpiClipColorExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   POINTL  PathPtl;
   POINTL  delta_ptl;
   POINTL  apt;
   LONG    lLineWidth;
   LONG    lcolor = 0L;
   FIXED   fxmultiplier = 0;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;
   ULONG   rcgpi = 0L;
   ARCPARAMS arcparam1;
   static PCHAR EntryName="GpiClipColorExh";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);


      if( GpiBeginPath(hPS, 1L) == FALSE )
          CLEANUP("GpiBeginPath", EntryName);

    // Delta x and y initialization
         delta_ptl.x = delta_x/8;
         delta_ptl.y = delta_y/8;

         arcparam1.lR = 5*delta_ptl.x;
         arcparam1.lQ = 2*delta_ptl.y;
         arcparam1.lP = -2*delta_ptl.x;
         arcparam1.lS = 7*delta_ptl.y;
         MapArc(arcparam1);
         if( GpiSetArcParams (hPS, &arcparam1) == FALSE )
             CLEANUP("GpiSetArcParams", EntryName);

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         if( GpiMove(hPS, &PathPtl) == FALSE )
              CLEANUP("GpiMove", EntryName);
         if( GpiFullArc( hPS, DRO_OUTLINE, 65536*5 ) != GPI_OK )
             CLEANUP("GpiFullArc", EntryName);

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         if( GpiMove(hPS, &PathPtl) == FALSE )
              CLEANUP("GpiMove", EntryName);
         if( GpiFullArc( hPS, DRO_OUTLINE, 65536*4 ) != GPI_OK )
             CLEANUP("GpiFullArc", EntryName);

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         if( GpiMove(hPS, &PathPtl) == FALSE )
             CLEANUP("GpiMove", EntryName);
         if( GpiFullArc( hPS, DRO_OUTLINE, 65536*3 ) != GPI_OK )
             CLEANUP("GpiFullArc", EntryName);

      if( GpiEndPath( hPS ) == FALSE )
        CLEANUP("GpiEndPath", EntryName);


   if( GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE )
        CLEANUP("GpiSetClipPath", EntryName);


  //  Set current pointer position

          apt.x = 4*delta_x;
          apt.y = (LONG)(5*delta_y+delta_y/4);
          MapPt( apt );
          if( GpiMove( hPS, &apt ) == FALSE )
             CLEANUP("GpiMove", EntryName);

  //   Set Line Width

          lLineWidth = 5;
          if( GpiSetLineWidthGeom( hPS, lLineWidth ) == FALSE )
              CLEANUP("GpiSetLineWidthGeom", EntryName);


  //   Begin loop to create circles
    while ( fxmultiplier <= 7*FXTOLONG  ) {

  //  Begin a path.
         if( GpiBeginPath( hPS, 1L ) == FALSE )
             CLEANUP("GpiBeginPath", EntryName);
         rcgpi = GpiPartialArc( hPS, &apt, fxmultiplier, fxStartAngle,
                 fxSweepAngle );
         if ( rcgpi != GPI_OK )
              CLEANUP("GpiPartialArc", EntryName);

  //   Increase radius
         fxmultiplier += (LONG)(FXTOLONG / 1000) ;

  //   Change the start angle

         fxStartAngle += FXTOLONG * 24;
         if ( fxStartAngle >= 360 * FXTOLONG) fxStartAngle = 0;

  //   Set new color,
         lcolor += 1;
         if (lcolor > 15 ) lcolor = 1;         //  repeat the color scheme
         if (GpiSetColor( hPS, lcolor ) != TRUE)
             CLEANUP("GpiSetColor", EntryName);

         if( GpiEndPath( hPS ) == FALSE )
             CLEANUP("GpiEndPath", EntryName);
         if( GpiStrokePath( hPS, 1L, (ULONG) 0 ) != GPI_OK )
             CLEANUP("GpiStrokePath", EntryName);

    } /* endwhile */

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiClipColorExh */




//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiMaxPolyLinesExh tests the ability of the driver to gracefully
//  abort when more than the max number of polylines is sent to it.
//
//  Restrictions:  This test must not be run in STD mode!
//
//
//*************************************************************************

VOID APIENTRY GpiMaxPolyLinesExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  SHORT  i;
  //16 POINTL huge *Pline;
  POINTL *Pline;
  static PCHAR EntryName="GpiMaxPolyLinesExh";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    //16 Pline = (POINTL *)halloc(10000L,sizeof(POINTL));
    Pline = (POINTL *)malloc(10000L * sizeof(POINTL));
    if( Pline == NULL )
        CLEANUP("malloc", EntryName);

    for( i=0; i<=9999; i++ )
      {
       Pline[i].x = (LONG)(i/12);
       Pline[i].y = (LONG)((delta_y*5)+(delta_y*5)*(double)(exp((double)(-Pline[i].x*3.1415927/500)))*sin((double)(Pline[i].x*3.1415927/20)));
       MapPt( Pline[i] );
      }



    for( i=8000; i<=9999; i++ )
      {
        GpiMove(hPS, &Pline[0] );
        if( GpiPolyLine( hPS, (LONG)i, Pline ) != GPI_OK )  {
             sprintf(sOut, "GpiPolyLine Failed with %d points.\n", i );
             CWRITELOG(L_TRACE,0,sOut);
             break;
        }
      }



    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiMaxPolyLinesExh */



//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiMaxPolySplinesExh tests the ability of the driver to gracefully
//  abort when more than the max number of polysplines is sent to it.
//
//  Restrictions:  This test must not be run in STD mode!
//
//
//*************************************************************************

VOID APIENTRY GpiMaxPolySplinesExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  INT    negate=1;
  LONG   i;
  POINTL *Pline;
  static PCHAR EntryName="GpiMaxPolySplinesExh";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    //16 Pline = (POINTL *)halloc(5000L,sizeof(POINTL));
    Pline = (POINTL *)malloc(5000L * sizeof(POINTL));
    if( Pline == NULL )
        CLEANUP("malloc", EntryName);

    for( i=0; i<=4999; i+=3 )
      {
       Pline[i].x = (LONG)(delta_x*8);
       Pline[i].y = (LONG)(delta_y*9);
       MapPt( Pline[i] );
      }
    for( i=1; i<=4999; i+=3 )
      {
       Pline[i].x = (LONG)(delta_x*8);
       Pline[i].y = (LONG)(delta_y*1);
       MapPt( Pline[i] );
      }
    for( i=2; i<=4999; i+=3 )
      {
       Pline[i].x = (LONG)(i/4);
       Pline[i].y = (LONG)((delta_y*5)+(delta_y*4*negate)*sin((double)(Pline[i].x*3.1415927/20)));
       MapPt( Pline[i] );
       negate = -negate;
      }

    for( i=3000; i<=5000; i++ )
      {
        GpiMove(hPS, &Pline[2] );
        if( GpiPolySpline( hPS, (LONG)i, Pline ) != GPI_OK )  {
             sprintf(sOut, "GpiPolySpline Failed with %d points.\n", i );
             CWRITELOG(L_TRACE,0,sOut);
             break;
        }
      }

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiMaxPolySplinesExh */




//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiCharBoxMetricsInteractive is a user interactive test in which
//  a listbox allows the tester to choose which fonts to run.  Once chosen,
//  every character for each font is printed with its associated
//  character box, along with the the title of the font.  Generally,
//  the characters should be contained inside the box.
//
//  Restrictions:  This test must not be run in STD mode!
//                 This test requires FONTLIST.EXE in order to work!
//
//*************************************************************************


VOID APIENTRY GpiCharBoxMetricsInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  SHORT  sAsciiNum=0;
  USHORT  usFontAttr;
  LONG   PubFonts=0L;
  LONG   PriFonts=0L;
  LONG   Index=0L;
  LONG   lDevHeight;
  LONG   lDevWidth;
  LONG   CharWidth;
  LONG   CharHeight;
  LONG   BaseWidth;
  POINTL CharBoxPt[TXTBOX_COUNT];
  POINTL Box[4];
  POINTL apt;
  CHAR   String[2];
  CHAR   strMatch[3];
  CHAR   FntName[256];
  HDC    outHDC;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  FILE   *fontfile;
  FILE   *attrfile;
  static PCHAR EntryName="GpiCharBoxMetricsInteractive";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);


    outHDC=GpiQueryDevice(hPS);
    if( outHDC == HDC_ERROR )
        CLEANUP("GpiQueryDevice", EntryName);
    if( DevQueryCaps( outHDC, CAPS_HEIGHT, 1L, &lDevHeight ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);
    if( DevQueryCaps( outHDC, CAPS_WIDTH, 1L, &lDevWidth ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);

    apt.x = 0;
    apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
    if( GpiMove( hPS, &apt ) == FALSE )
        CLEANUP("GpiMove", EntryName);

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    fontfile = fopen("fontlist", "w");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);


    for (Index=0; Index < PubFonts; Index++) {
       if(FontStorage[Index].lMatch < 0 )
          fprintf( fontfile, "(df) %-25s(%5d)\n", FontStorage[Index].Fontname,
                                         FontStorage[Index].usCodePage );
          else
          fprintf( fontfile, "(sf) %-25s(%5d)\n", FontStorage[Index].Fontname,
                                         FontStorage[Index].usCodePage );

    }
    fclose( fontfile );

    if( spawnl( P_WAIT, "FONTLIST.EXE", NULL ) == -1 ) {
       CLEANUP("spawnl", EntryName);
       return;
       }


    attrfile = fopen("oneattr", "r");
    if( attrfile == NULL )
      CLEANUP("fopen", EntryName);
    fscanf( attrfile, "%d", &usFontAttr );
    fclose( attrfile );

    fontfile = fopen("fontlist", "r");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);

    fscanf( fontfile, "%d", &Index );

 while( !feof( fontfile )) {

    FontStorage[Index].fsSelection = usFontAttr;
    if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
      CLEANUP("EzCreateLogicalFonts", EntryName);
     if (!GpiSetCharSet(hPS, USER_LCID))
      CLEANUP("GpiSetCharSet", EntryName);

      CWRITELOG(L_TRACE,0,FontStorage[Index].Fontname);

      sprintf(String, "%c", sAsciiNum);
      if( GpiQueryTextBox( hPS, 1L, String, TXTBOX_COUNT, CharBoxPt ) == FALSE)
          CLEANUP("GpiQueryTextBox", EntryName);
                          // tss was botleft
      CharWidth = (CharBoxPt[TXTBOX_TOPRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
      CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);
      BaseWidth = (CharBoxPt[TXTBOX_BOTTOMRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
      sAsciiNum = 0;

      if( FontStorage[Index].lMatch < 0 )
          strcpy( strMatch, "df" );
      else
          strcpy( strMatch, "sf" );


      sprintf(FntName, "%s Cp=%d %s\n", FontStorage[Index].Fontname,
                                      FontStorage[Index].usCodePage,
                                      strMatch );

      if( (lDevHeight - apt.y) < CharHeight )
      {
         apt.y = apt.y - CharHeight;
         if( GpiMove(hPS, &apt) == FALSE )
             CLEANUP("GpiMove", EntryName);
      }


      if( GpiCharString( hPS, (LONG)(strlen(FntName)-1), FntName ) != GPI_OK )
                  CLEANUP("GpiCharString", EntryName);
      apt.x = 0;
      apt.y = apt.y - CharHeight;

   while( sAsciiNum <= 255 )
   {
      while( (apt.y > (LONG)(MapY(delta_y)+CharHeight)) && (sAsciiNum <= 255)  )
      {
         while( (apt.x < (lDevWidth - CharWidth)) && (sAsciiNum <= 255) )
         {

              if( (lDevHeight - apt.y) < CharHeight ) apt.y = apt.y - CharHeight;

              Box[0].x = apt.x + CharBoxPt[TXTBOX_BOTTOMRIGHT].x;
              Box[0].y = apt.y + CharBoxPt[TXTBOX_BOTTOMRIGHT].y;
              Box[1].x = apt.x + CharBoxPt[TXTBOX_TOPRIGHT].x;
              Box[1].y = apt.y + CharBoxPt[TXTBOX_TOPRIGHT].y;
              Box[2].x = apt.x + CharBoxPt[TXTBOX_TOPLEFT].x;
              Box[2].y = apt.y + CharBoxPt[TXTBOX_TOPLEFT].y;
              Box[3].x = apt.x + CharBoxPt[TXTBOX_BOTTOMLEFT].x;
              Box[3].y = apt.y + CharBoxPt[TXTBOX_BOTTOMLEFT].y;

              if( GpiMove(hPS, &Box[3]) == FALSE )
                  CLEANUP("GpiMove", EntryName);
              if( GpiPolyLine( hPS, 4L, Box ) != GPI_OK )
                  CLEANUP("GpiPolyLine", EntryName);
              if( GpiMove(hPS, &apt) == FALSE )
                  CLEANUP("GpiMove", EntryName);

              if( GpiCharString( hPS, 1L, String ) != GPI_OK )
                  CLEANUP("GpiCharString", EntryName);
              sAsciiNum += 1;

              apt.x = apt.x + BaseWidth + MapX((LONG)(delta_x/16));



              sprintf(String, "%c", sAsciiNum);
              if( GpiQueryTextBox( hPS, 1L, String, TXTBOX_COUNT, CharBoxPt ) == FALSE )
                  CLEANUP("GpiQueryTextBox", EntryName);

                                  // tss was botleft
              CharWidth = (CharBoxPt[TXTBOX_TOPRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
              CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);
              BaseWidth = (CharBoxPt[TXTBOX_BOTTOMRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);

              sprintf(sOut, "%d ---> %d\n", sAsciiNum, BaseWidth);
              CWRITELOG(L_TRACE,0,sOut);


         } //end x position while

         if(apt.y < MapY( (LONG)(delta_y*2)) ) {
             if ((lSuccess = DevEscape(outHDC, DEVESC_NEWFRAME,
                         0L, NULL, 0L, NULL)) == DEVESC_ERROR)
                         CLEANUP("DevEscape", "GpiCharBoxMetricsAllFonts");
             apt.x = 0;
             apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
             if( GpiMove( hPS, &apt ) == FALSE )
                  CLEANUP("GpiMove", EntryName);
             if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
               CLEANUP("GpiSetCharSet", EntryName);
               return;
             }
           //  TEST_SIGNATURE(0,0);
             if (!GpiSetCharSet(hPS, USER_LCID))
                CLEANUP("GpiSetCharSet", EntryName);
           }
           else {
              apt.x = 0;
              apt.y = apt.y - CharHeight - MapY((LONG)(delta_y/16));
              if( GpiMove( hPS, &apt ) == FALSE )
                  CLEANUP("GpiMove", EntryName);
           }

       } //end y postion while

       if(apt.y < MapY( (LONG)(delta_y*2)) ) {
           if ((lSuccess = DevEscape(outHDC, DEVESC_NEWFRAME,
                       0L, NULL, 0L, NULL)) == DEVESC_ERROR)
                       CLEANUP("DevEscape", "GpiCharBoxMetricsAllFonts");
           apt.x = 0;
           apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
           if( GpiMove( hPS, &apt ) == FALSE )
               CLEANUP("GpiMove", EntryName);

           if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
             CLEANUP("GpiSetCharSet", "GpiCharBoxMetricsAllFonts");
             return;
           }
        //   TEST_SIGNATURE(0,0);
            if (!GpiSetCharSet(hPS, USER_LCID))
               CLEANUP("GpiSetCharSet", EntryName);
         }
         else {
            apt.x = 0;
            apt.y = apt.y - CharHeight - MapY((LONG)(delta_y/16));
            if( GpiMove( hPS, &apt ) == FALSE )
                CLEANUP("GpiMove", EntryName);
         }


  } //end while loop to check for sAsciiNum >= 255



   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", "PrintFonts");
     return;
   }
   if (!GpiDeleteSetId(hPS,USER_LCID)) {
     CLEANUP("GpiDeleteSetId", "GpiCharBoxMetricsAllFonts");
     return;
   }

    fscanf( fontfile, "%d", &Index );

  } // End While not end of file

  fclose( fontfile );

  EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiCharBoxMetricsInteractive */





//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiCharBoxMetricsDefault is essentially similar to
//  GpiCharBoxMetricsInteractive except that it simply uses the
//  the default font for its output.
//
//  Restrictions:  This test must not be run in STD mode!
//                 This test requires FONTLIST.EXE in order to work!
//
//*************************************************************************


VOID APIENTRY GpiCharBoxMetricsDefault(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  SHORT  sAsciiNum=0;
  LONG   Index=0L;
  LONG   lDevHeight;
  LONG   lDevWidth;
  LONG   CharWidth;
  LONG   CharHeight;
  LONG   BaseWidth;
  POINTL CharBoxPt[TXTBOX_COUNT];
  POINTL Box[4];
  POINTL apt;
  CHAR   String[2];
  HDC    outHDC;
  static PCHAR EntryName="GpiCharBoxMetricsDefault";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    outHDC=GpiQueryDevice(hPS);
    if( outHDC == HDC_ERROR )
        CLEANUP("GpiQueryDevice", EntryName);
    if( DevQueryCaps( outHDC, CAPS_HEIGHT, 1L, &lDevHeight ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);
    if( DevQueryCaps( outHDC, CAPS_WIDTH, 1L, &lDevWidth ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);

//    lDevWidth = (LONG)(pg_size_x * delta_x);
//    lDevHeight = (LONG)(pg_size_y * delta_y);

    apt.x = 0;
    apt.y = lDevHeight - MapY( (LONG)(delta_y/2) ) ;
    if( GpiMove( hPS, &apt ) == FALSE )
        CLEANUP("GpiMove", EntryName);

    sprintf(String, "%c", sAsciiNum);
    if( GpiQueryTextBox( hPS, 1L, String, TXTBOX_COUNT, CharBoxPt ) == FALSE )
        CLEANUP("GpiQueryTextBox", EntryName);

                       // tss was botleft
    CharWidth = (CharBoxPt[TXTBOX_TOPRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
    CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);
    BaseWidth = (CharBoxPt[TXTBOX_BOTTOMRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
    sAsciiNum = 0;

 while( sAsciiNum <= 255 )
   {
      while( (apt.y > (LONG)(MapY(delta_y)+CharHeight)) && (sAsciiNum <= 255)  )
      {
         while( (apt.x < (lDevWidth - CharWidth)) && (sAsciiNum <= 255) )
         {

              if( (lDevHeight - apt.y) < CharHeight ) apt.y = apt.y - CharHeight;

              Box[0].x = apt.x + CharBoxPt[TXTBOX_BOTTOMRIGHT].x;
              Box[0].y = apt.y + CharBoxPt[TXTBOX_BOTTOMRIGHT].y;
              Box[1].x = apt.x + CharBoxPt[TXTBOX_TOPRIGHT].x;
              Box[1].y = apt.y + CharBoxPt[TXTBOX_TOPRIGHT].y;
              Box[2].x = apt.x + CharBoxPt[TXTBOX_TOPLEFT].x;
              Box[2].y = apt.y + CharBoxPt[TXTBOX_TOPLEFT].y;
              Box[3].x = apt.x + CharBoxPt[TXTBOX_BOTTOMLEFT].x;
              Box[3].y = apt.y + CharBoxPt[TXTBOX_BOTTOMLEFT].y;

              if( GpiMove(hPS, &Box[3]) == FALSE )
                  CLEANUP("GpiMove", EntryName);
              if( GpiPolyLine( hPS, 4L, Box ) != GPI_OK )
                  CLEANUP("GpiPolyLine", EntryName);
              if( GpiMove(hPS, &apt) == FALSE )
                  CLEANUP("GpiMove", EntryName);


              if( GpiCharString( hPS, 1L, String ) != GPI_OK )
                  CLEANUP("GpiCharString", EntryName);
              sAsciiNum += 1;
              apt.x = apt.x + BaseWidth + MapX((LONG)(delta_x/16));

              sprintf(String, "%c", sAsciiNum);
              if( GpiQueryTextBox( hPS, 1L, String, TXTBOX_COUNT, CharBoxPt ) == FALSE )
                  CLEANUP("GpiQueryTextBox", EntryName);

                                 // tss was botleft
              CharWidth = (CharBoxPt[TXTBOX_TOPRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
              CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);
              BaseWidth = (CharBoxPt[TXTBOX_BOTTOMRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);

         } //end x position while

         if(apt.y < MapY( (LONG)(delta_y*2)) ) {
             if ((lSuccess = DevEscape(outHDC, DEVESC_NEWFRAME,
                         0L, NULL, 0L, NULL)) == DEVESC_ERROR)
                         CLEANUP("DevEscape", "GpiCharBoxMetricsAllFonts");
             apt.x = 0;
             apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
             if( GpiMove( hPS, &apt ) == FALSE )
                  CLEANUP("GpiMove", EntryName);
             if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
               CLEANUP("GpiSetCharSet", EntryName);
               return;
             }
             if (!GpiSetCharSet(hPS, USER_LCID))
                CLEANUP("GpiSetCharSet", EntryName);
           }
           else {
              apt.x = 0;
              apt.y = apt.y - CharHeight - MapY((LONG)(delta_y/16));
              if( GpiMove( hPS, &apt ) == FALSE )
                  CLEANUP("GpiMove", EntryName);
           }

       } //end y postion while

       if(apt.y < MapY(delta_y) ) {
           if ((lSuccess = DevEscape(outHDC, DEVESC_NEWFRAME,
                       0L, NULL, 0L, NULL)) == DEVESC_ERROR)
                       CLEANUP("DevEscape", "GpiCharBoxMetricsAllFonts");
           apt.x = 0;
           apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
           if( GpiMove( hPS, &apt ) == FALSE )
               CLEANUP("GpiMove", EntryName);

           if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
             CLEANUP("GpiSetCharSet", "GpiCharBoxMetricsAllFonts");
             return;
           }
           TEST_SIGNATURE(0,0);
           if (!GpiSetCharSet(hPS, USER_LCID))
               CLEANUP("GpiSetCharSet", EntryName);
         }
         else {
            apt.x = 0;
            apt.y = apt.y - CharHeight - MapY((LONG)(delta_y/16));
            if( GpiMove( hPS, &apt ) == FALSE )
                CLEANUP("GpiMove", EntryName);
         }


  } //end while loop to check for sAsciiNum >= 255

  EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiCharBoxMetricsInteractive */




//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiSpaceInteractive is a user interactive test in which
//  a listbox allows the tester to choose which fonts to run.  Once chosen,
//  a string with dashes is printed.  This string is then overlayed
//  with a string in which spaces are substituded for the characters
//  except for the dashes.  These dashes should be printed exactly over
//  the top of the original dashes.
//
//  Restrictions:  This test must not be run in STD mode!
//                 This test requires FONTLIST.EXE in order to work!
//                 This test cannot be used with PS type fonts!
//
//*************************************************************************


VOID APIENTRY GpiSpaceInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  USHORT i;
  SHORT  sAsciiNum=0;
  LONG   lDevHeight;
  LONG   CharWidth;
  LONG   CharHeight;
  LONG   lDevWidth;
  LONG   PubFonts=0L;
  LONG   PriFonts=0L;
  LONG   Index=0L;
  CHAR   FntName[256];
  CHAR   String[2];
  POINTL CharBoxPt[TXTBOX_COUNT];
  POINTL apt;
  HDC    outHDC;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  FILE   *fontfile;
  static PCHAR EntryName="GpiSpaceInteractive";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    outHDC=GpiQueryDevice(hPS);
    if( outHDC == HDC_ERROR )
        CLEANUP("GpiQueryDevice", EntryName);
    if( DevQueryCaps( outHDC, CAPS_HEIGHT, 1L, &lDevHeight ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);
    if( DevQueryCaps( outHDC, CAPS_WIDTH, 1L, &lDevWidth ) == FALSE )
        CLEANUP("DevQueryCaps", EntryName);


    apt.x = 0;
    apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
    if( GpiMove( hPS, &apt ) == FALSE )
        CLEANUP("GpiMove", EntryName);

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    fontfile = fopen("fontlist", "w");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);

    for (Index=0; Index < PubFonts; Index++) {

       if(FontStorage[Index].lMatch < 0 )
          fprintf( fontfile, "(df) %-25s(%5d)\n", FontStorage[Index].Fontname,
                                         FontStorage[Index].usCodePage );
          else
          fprintf( fontfile, "(sf) %-25s(%5d)\n", FontStorage[Index].Fontname,
                                         FontStorage[Index].usCodePage );


    }
    fclose( fontfile );

    if( spawnl( P_WAIT, "FONTLIST.EXE", NULL ) == -1 ) {
       CLEANUP("spawnl", EntryName);
       return;
       }

    fontfile = fopen("fontlist", "r");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);

    fscanf( fontfile, "%d", &Index );

 while( !feof( fontfile )) {
      if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, USER_LCID))
        CLEANUP("GpiSetCharSet", EntryName);

      if( GpiQueryTextBox( hPS, 1L, String, TXTBOX_COUNT, CharBoxPt ) == FALSE)
          CLEANUP("GpiQueryTextBox", EntryName);
      CharWidth = (CharBoxPt[TXTBOX_BOTTOMRIGHT].x - CharBoxPt[TXTBOX_BOTTOMLEFT].x);
      CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);

      sprintf(FntName, "%s Cp=%d\n", FontStorage[Index].Fontname,
                                     FontStorage[Index].usCodePage );
      if( GpiCharString( hPS, (LONG)(strlen(FntName)-1), FntName ) != GPI_OK )
          CLEANUP("GpiCharString", EntryName);
      apt.x = 0;
      apt.y = apt.y - CharHeight;
      if( GpiMove( hPS, &apt ) == FALSE )
          CLEANUP("GpiMove", EntryName);

     for( i=0; i<= 100; i++ ) {
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, "D" );
        GpiCharString( hPS, 1L, "A" );
        GpiCharString( hPS, 1L, "S" );
        GpiCharString( hPS, 1L, "H" );
        GpiCharString( hPS, 1L, "E" );
        GpiCharString( hPS, 1L, "S" );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, "S" );
        GpiCharString( hPS, 1L, "H" );
        GpiCharString( hPS, 1L, "O" );
        GpiCharString( hPS, 1L, "U" );
        GpiCharString( hPS, 1L, "L" );
        GpiCharString( hPS, 1L, "D" );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, "L" );
        GpiCharString( hPS, 1L, "I" );
        GpiCharString( hPS, 1L, "N" );
        GpiCharString( hPS, 1L, "E" );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, "U" );
        GpiCharString( hPS, 1L, "P" );
    }

    apt.x = 0;
    GpiMove( hPS, &apt );

     for( i=0; i<= 100; i++ ) {
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, "-" );
        GpiCharString( hPS, 1L, " " );
        GpiCharString( hPS, 1L, " " );
      }

      apt.x = 0;
      apt.y = apt.y - CharHeight;
      if( GpiMove( hPS, &apt ) == FALSE )
          CLEANUP("GpiMove", EntryName);


         if(apt.y < MapY( (LONG)(delta_y*2)) ) {
             if ((lSuccess = DevEscape(outHDC, DEVESC_NEWFRAME,
                         0L, NULL, 0L, NULL)) == DEVESC_ERROR)
                         CLEANUP("DevEscape", "GpiCharBoxMetricsAllFonts");
             apt.x = 0;
             apt.y = lDevHeight - MapY( (LONG)(delta_y/2) );
             if( GpiMove( hPS, &apt ) == FALSE )
                 CLEANUP("GpiMove", EntryName);
             if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
               CLEANUP("GpiSetCharSet", "GpiCharBoxMetricsAllFonts");
               return;
             }
             TEST_SIGNATURE(0,0);
             if (!GpiSetCharSet(hPS, USER_LCID))
                CLEANUP("GpiSetCharSet", EntryName);
           }

   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", "PrintFonts");
     return;
   }
   if (!GpiDeleteSetId(hPS,USER_LCID)) {
     CLEANUP("GpiDeleteSetId", "GpiCharBoxMetricsAllFonts");
     return;
   }


    fscanf( fontfile, "%d", &Index );

  } // End While not end of file

    fclose( fontfile );

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiCharBoxMetricsInteractive */






//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiThinLinesInPath
//
//
//
//
//*************************************************************************

VOID APIENTRY GpiThinLinesInPath(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   POINTL  apt1;
   POINTL  apt2;
   static PCHAR EntryName="GpiThinLinesInPath";
   SHORT   sPattern;
   CHAR    stOut[100];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    apt1.x = delta_x*1;
    apt2.x = delta_x*5;
    apt1.y = delta_x*1;
    apt2.y = delta_x*1;

    MapPt( apt1 );
    MapPt( apt2 );

    if( GpiSetLineWidthGeom( hPS, 2L ) == FALSE )
        CLEANUP("GpiSetPattern", EntryName);

    for(sPattern=1; sPattern<=16; sPattern++) {

       if( GpiSetPattern( hPS, (LONG)sPattern ) == FALSE )
           CLEANUP("GpiSetPattern", EntryName);

       if( GpiBeginPath(hPS, 1L) == FALSE )
           CLEANUP("GpiBeginPath", EntryName);

           if( GpiMove( hPS, &apt1 ) == FALSE )
               CLEANUP("GpiMove", EntryName);
           if( GpiLine( hPS, &apt2 ) != GPI_OK )
               CLEANUP("GpiLine", EntryName);

       if( GpiEndPath( hPS ) == FALSE )
           CLEANUP("GpiEndPath", EntryName);
       if( GpiStrokePath( hPS, 1L, (ULONG) 0 ) != GPI_OK )
           CLEANUP("GpiStrokePath", EntryName);

       sprintf( stOut, "Pattern # %d", sPattern );
       GpiCharString( hPS, (LONG)strlen( stOut ), stOut );

       apt1.y += MapY( (LONG)delta_y/2 );
       apt2.y += MapY( (LONG)delta_y/2 );

   } // End for loop

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiThinLinesInPath */




//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiThickLinesInPath
//
//
//
//
//*************************************************************************

VOID APIENTRY GpiThickLinesInPath(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   POINTL  apt1;
   POINTL  apt2;
   static PCHAR EntryName="GpiThickLinesInPath";
   SHORT   sPattern;
   CHAR    stOut[100];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    apt1.x = delta_x*1;
    apt2.x = delta_x*5;
    apt1.y = delta_x*1;
    apt2.y = delta_x*1;

    MapPt( apt1 );
    MapPt( apt2 );

    if( GpiSetLineWidthGeom( hPS, (LONG)(MapY(delta_y/2)) ) == FALSE )
        CLEANUP("GpiSetPattern", EntryName);

    for(sPattern=1; sPattern<=16; sPattern++) {

       if( GpiSetPattern( hPS, (LONG)sPattern ) == FALSE )
           CLEANUP("GpiSetPattern", EntryName);

       if( GpiBeginPath(hPS, 1L) == FALSE )
           CLEANUP("GpiBeginPath", EntryName);

           if( GpiMove( hPS, &apt1 ) == FALSE )
               CLEANUP("GpiMove", EntryName);
           if( GpiLine( hPS, &apt2 ) != GPI_OK )
               CLEANUP("GpiLine", EntryName);

       if( GpiEndPath( hPS ) == FALSE )
           CLEANUP("GpiEndPath", EntryName);
       if( GpiStrokePath( hPS, 1L, (ULONG) 0 ) != GPI_OK )
           CLEANUP("GpiStrokePath", EntryName);

       sprintf( stOut, "Pattern # %d", sPattern );
       GpiCharString( hPS, (LONG)strlen( stOut ), stOut );

       apt1.y += MapY( (LONG)delta_y/2 );
       apt2.y += MapY( (LONG)delta_y/2 );

   } // End for loop

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiThickLinesInPath */





//*************************************************************************
//
//  Author: Tim Seevers
//          Lexmark International
//
//  Date:   10/30/91
//
//  GpiBitMapClipExh
//
//  Restrictions:  This test must not be run in STD mode!
//
//*************************************************************************


VOID APIENTRY GpiBitMapClipExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {

    (VOID)GpiApp4(hPS,hWndClient);

 }
  return;
}



/****************************************************************************
 *\\ddd
 * Routine Name: GpiApp4()
 *
 * Purpose: This function tests the basic functionality of the following
 *                    Gpi functions:
 *          GpiLoadBitmap()
 *          GpiWCBitBlt()
 *          GpiQueryBitmapParameters().
 *
 * System Requirements:
 *
 * Revision Log:
 *               02/04/1991 ,PDVT , Mike Abuzant
 *               -initial file.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *
 * Outputs:
 *
 * Subroutines Required:
 *   set_delta().
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    Setup conditions to load bitmaps by calling the Gpi function
 *    GpiLoadBitmap(). This algorithm will Load two large bitmaps
 *    that are stored in this DLL. Then the function GpiWCBitBlt()
 *    will be used to display each bitmap. Also, GpiWCBitBlt() will
 *    stretch each bitmap to fill the entire width of the presentation
 *    space and fill 1/2 the height of the presentation space.
 *
 *   FOR (index=0 ;index <NumberOfBitmapsToLoad ; index++) DO
 *        Load the next bitmap
 *          hBM=GpiLoadBitmap(hPS,...)
 *
 *        Get the bitmap parameters. These parameters will be used to
 *        determine the loaded bitmap size.
 *           GpiQueryBitmapParameters(hBM,&InfoBuffer..)
 *
 *        Setup the coordinates of the Target rectangle and
 *        Draw the bitmap on current PS using GpiWCBitBlt()
 *          GpiWCBitBlt(hPS,hBM,...,ROP_SRCCOPY)...
 *
 *        Delete the bitmap.
 *           GpiDeletetBitmap(hBM);
 *
 *   ENDFOR
 *
 *\\end
 ***************************************************************************/
INT GpiApp4(HPS hPS,HWND hWndClient)
{
    static USHORT  aBitMapId[]={FOURT_BITMAP_ID,
                               FIFTH_BITMAP_ID
                              };

    static   PCHAR EntryName="GpiApp4()";
    static   CHAR *DllName="Gpibtmp";
    HMODULE  hMOD;
    HBITMAP  hBM=(HBITMAP)NULL ;
    POINTL   aptl[4];
    LONG     lIndex;                           // long Counter
    BITMAPINFOHEADER BitMapHeader;      //bitmap info header

    POINTL  PathPtl;
    POINTL  delta_ptl;
    LONG    lcolor = 0L;
    FIXED   fxmultiplier = 0;
    FIXED   fxStartAngle = 0;
    FIXED   fxSweepAngle = FXTOLONG * 24;
    ULONG   rcgpi = 0L;
    ARCPARAMS arcparam1;

    ENTER_MAIN(EntryName);

         delta_ptl.x = delta_x/8;
         delta_ptl.y = delta_y/8;

         arcparam1.lR = 5*delta_ptl.x;
         arcparam1.lQ = 2*delta_ptl.y;
         arcparam1.lP = -2*delta_ptl.x;
         arcparam1.lS = 7*delta_ptl.y;
         MapArc(arcparam1);
         if( GpiSetArcParams (hPS, &arcparam1) == FALSE )
             CLEANUP("GpiSetArcParams", EntryName);

         PathPtl.x = delta_x*4;
         PathPtl.y = (LONG)delta_y*5+(LONG)(delta_y/4);
         MapPt(PathPtl);
         if( GpiMove(hPS, &PathPtl) == FALSE )
              CLEANUP("GpiMove", EntryName);
         if( GpiMove(hPS, &PathPtl) == FALSE )
              CLEANUP("GpiMove", EntryName);
      if( GpiSetLineWidthGeom( hPS, 5L ) == FALSE )
          CLEANUP("GpiSetLineWidthGeom", EntryName);

      if( GpiBeginPath(hPS, 1L) == FALSE )
          CLEANUP("GpiBeginPath", EntryName);

         if( GpiFullArc( hPS, DRO_OUTLINE, 65536*4 ) != GPI_OK )
             CLEANUP("GpiFullArc", EntryName);

      if( GpiEndPath( hPS ) == FALSE )
        CLEANUP("GpiEndPath", EntryName);
      if( GpiStrokePath( hPS, 1L, (ULONG) 0 ) != GPI_OK )
          CLEANUP("GpiStrokePath", EntryName);


      if( GpiBeginPath(hPS, 1L) == FALSE )
          CLEANUP("GpiBeginPath", EntryName);

         if( GpiFullArc( hPS, DRO_OUTLINE, 65536*4 ) != GPI_OK )
             CLEANUP("GpiFullArc", EntryName);

      if( GpiEndPath( hPS ) == FALSE )
        CLEANUP("GpiEndPath", EntryName);


   if( GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE )
        CLEANUP("GpiSetClipPath", EntryName);

    //Ask OS/2 to load resources stored in this DLL.
    if (DosLoadModule(NULL,0,DllName,&hMOD)){
       CLEANUP("DosLoadModule()",EntryName);
       CWRITELOG(L_LOTRACE,0,"GPIBTMP.DLL must be in current directory\n");
       return FALSE;
    }

   /******************************************************************
     Setup conditions to load bitmaps by calling the Gpi function
     GpiLoadBitmap(). This algorithm will Load two large bitmaps
     that are stored in this DLL. Then the function GpiWCBitBlt()
     will be used to display each bitmap. Also, GpiWCBitBlt() will
     stretch each bitmap to fill the entire width of the presentation
     space and fill 1/2 the height of the presentation space.
   ******************************************************************/

   //Setup dimensions for Source rectangle.(only lower left corner)
    aptl[2].x=
    aptl[2].y=0L;

    //Setup dimensions for Target rectangle.
    aptl[0].x=MapX(0L);
    aptl[1].x=MapX(delta_x*pg_size_x);
    aptl[0].y=MapY(0L);
    aptl[1].y=MapY((2L*delta_y/3L));

    for (lIndex=0 ;lIndex<NUMBEROFELEMENTS(aBitMapId); lIndex++){

      //Setup dimensions for the next Target rectangle
       aptl[0].y=aptl[1].y;
       aptl[1].y+=MapY((delta_y*(pg_size_y)/2))-MapY((2L*delta_y/3L));

       //Load,into memory, the next bitmap identified by the Resource ID
       //stored at address pointed to by 'abitMapId[lIndex]'

       if((hBM=GpiLoadBitmap(hPS,hMOD,aBitMapId[lIndex],0L,0L))==GPI_ERROR){
           CLEANUP("GpiLoadBitmap()",EntryName);
           return FALSE ;
       }

       //Retrieve this bitmap's parameters namely,
       // width and height.
       if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
           CLEANUP("GpiQueryBitmapParameters()",EntryName);
           return FALSE;
       }

       aptl[3].x=(LONG)BitMapHeader.cx;
       aptl[3].y=(LONG)BitMapHeader.cy;

       //Now copy bitmap to display. The bitmap will be stretched to fill
       //the entire device width and only 1/2 the device height.

       if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_SRCCOPY,BBO_IGNORE)==GPI_ERROR){
           CLEANUP("GpiWCBitBlt()",EntryName);
           return FALSE ;
       }

       //Release memory space occupied by this bitmap.
       if (GpiDeleteBitmap(hBM)==FALSE){
          CLEANUP("GpiDeleteBitmap()",EntryName);
          return FALSE ;
       }
    }

    EXIT_MAIN (EntryName);

  return TRUE;
}




VOID APIENTRY GpiShadeCharactersInteractive(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL apt;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  FILE   *fontfile;
  FILE   *attrfile;
  LONG   PubFonts=0L;
  LONG   PriFonts=0L;
  LONG   CharHeight;
  LONG   Index;
  POINTL CharBoxPt[5];
  static   PCHAR EntryName="GpiShadeCharactersInteractive";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else
        {
     ENTER_MAIN(EntryName);

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage)) {
      CLEANUP("EzQueryFonts", EntryName);
      return;
    }

    fontfile = fopen("onefont", "w");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);
    for (Index=0L; Index < PubFonts; Index++)
          fprintf( fontfile, "%-30s/%-10ld\n", FontStorage[Index].Fontname,
                                         FontStorage[Index].lMatch );

    fclose( fontfile );

    if( spawnl( P_WAIT, "ONEFONT.EXE", NULL ) == -1 ) {
       CLEANUP("spawnl", EntryName);
       return;
       }

    fontfile = fopen("onefont", "r+");
    if( fontfile == NULL )
      CLEANUP("fopen", EntryName);

    fscanf( fontfile, "%d\n", &Index );
    fclose( fontfile );

    attrfile = fopen("oneattr", "r+");
    if( attrfile == NULL )
      CLEANUP("fopen", EntryName);

    fscanf( attrfile, "%d\n", &FontStorage[Index].fsSelection );
    fclose( attrfile );

    if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
      CLEANUP("EzCreateLogicalFonts", EntryName);
    if (!GpiSetCharSet(hPS, USER_LCID))
      CLEANUP("GpiSetCharSet", EntryName);

     CWRITELOG(L_TRACE,0,FontStorage[Index].Fontname);

        apt.x = (LONG)(delta_x);
        apt.y = (LONG)(delta_y);
        MapPt( apt );
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);

        sprintf( sOut, "%s / %ld", FontStorage[Index].Fontname,
                       FontStorage[Index].lMatch );


        if( GpiCharString( hPS, (LONG)strlen(sOut), sOut) != GPI_OK )
            CLEANUP("GpiCharString", EntryName);


      if( GpiQueryTextBox( hPS, (LONG)strlen(sOut), sOut, TXTBOX_COUNT, CharBoxPt ) == FALSE)
          CLEANUP("GpiQueryTextBox", EntryName);
      CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);


        apt.y += CharHeight + MapY( (LONG)(delta_y/4) );
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_WHITE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "WHITE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BLACK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "BLACK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BLUE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "BLUE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_RED ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 3L, "RED") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_PINK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "PINK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_GREEN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "GREEN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_CYAN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "CYAN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_YELLOW ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 6L, "YELLOW") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_NEUTRAL ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 7L, "NEUTRAL") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKGRAY ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKGRAY") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKBLUE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKBLUE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKRED ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 7L, "DARKRED") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKPINK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKPINK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKGREEN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 9L, "DARKGREEN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKCYAN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKCYAN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BROWN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "BROWN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_PALEGRAY ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "PALEGRAY") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);


   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", EntryName);
     return;
   }
   if (!GpiDeleteSetId(hPS,USER_LCID)) {
     CLEANUP("GpiDeleteSetId", EntryName);
     return;
   }


        EXIT_MAIN(EntryName);
        }
  return;
}



VOID APIENTRY GpiShadeCharactersDefault(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL apt;
  LONG   CharHeight;
  LONG   Index=0L;
  LONG   TempIndex=0L;
  POINTL CharBoxPt[5];
  static   PCHAR EntryName="GpiShadeCharactersDefault";

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else
        {
     ENTER_MAIN(EntryName);

        apt.x = (LONG)(delta_x);
        apt.y = (LONG)(delta_y);
        MapPt( apt );
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        sprintf( sOut, "Used the default font!" );
        if( GpiCharString( hPS, (LONG)strlen(sOut), sOut) != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

      if( GpiQueryTextBox( hPS, (LONG)strlen(sOut), sOut, TXTBOX_COUNT, CharBoxPt ) == FALSE)
          CLEANUP("GpiQueryTextBox", EntryName);
      CharHeight= (CharBoxPt[TXTBOX_TOPLEFT].y - CharBoxPt[TXTBOX_BOTTOMLEFT].y);

        apt.y += CharHeight + MapY( (LONG)(delta_y/4) );
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_WHITE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "WHITE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BLACK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "BLACK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BLUE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "BLUE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_RED ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 3L, "RED") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_PINK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "PINK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_GREEN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "GREEN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_CYAN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 4L, "CYAN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_YELLOW ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 6L, "YELLOW") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_NEUTRAL ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 7L, "NEUTRAL") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKGRAY ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKGRAY") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKBLUE ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKBLUE") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKRED ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 7L, "DARKRED") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKPINK ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKPINK") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKGREEN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 9L, "DARKGREEN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_DARKCYAN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "DARKCYAN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_BROWN ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 5L, "BROWN") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);

        apt.y += CharHeight;
        if( GpiMove( hPS, &apt ) == FALSE )
            CLEANUP("GpiMove", EntryName);
        if( GpiSetColor( hPS, CLR_PALEGRAY ) == FALSE )
            CLEANUP("GpiSetColor", EntryName);
        if( GpiCharString( hPS, 8L, "PALEGRAY") != GPI_OK )
            CLEANUP("GpiCharString", EntryName);


   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", EntryName);
     return;
   }


        EXIT_MAIN(EntryName);
        }
  return;
}



