/**************************************************************************
 *
 * SOURCE FILE NAME = PTTMAIN.H
 *
 * DESCRIPTIVE NAME = This header file contains all the constants, variables,
 *                    function prototypes for use by the PTT.C module only.
 *
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

/*
** external function prototypes
*/

extern BOOL PTT_Init(INT argc, CHAR **argv);
extern VOID PTT_Command(HWND hwnd, USHORT message, MPARAM mp1, MPARAM mp2);
extern VOID LogToDlgBox(PSZ string);
extern MRESULT EXPENTRY LoggingDlgProc(HWND, USHORT, MPARAM, MPARAM);
extern MRESULT EXPENTRY TestCasesDlgProc(HWND, USHORT, MPARAM, MPARAM);

/*
** external variables
*/
extern HMQ hMQPrintThread;

/*
** local function prototypes
*/

INT main(INT argc, CHAR **argv);
MRESULT EXPENTRY PTTWndProc(HWND, USHORT, MPARAM, MPARAM);
INT     RegisterClass(VOID);
HWND    CreateWindow(HWND, ULONG, PCH, PCH, USHORT, INT, INT, INT, INT,
                     PHWND, ULONG, USHORT);
VOID    SignatureProc(USHORT msg, MPARAM mp1, MPARAM mp2);

VOID APIENTRY CleanUpFunction(VOID);
/*
** Local variables
*/

/*
** these structures are used to add the program name to the task list
*/

HSWITCH hSwitch;
SWCNTRL pSwctl;
CHAR    szAppName[20];   /* class name of application                      */

TID ScriptThreadID;      /* Thread ID for background script thread         */
TID PrintThreadID;       /* Thread ID for background print thread          */
CHAR *pass_fail;         /* test log pass/fail variable                    */

/*
** These defines are used to place the test signature in a default location.
** The values are in world coordinates.
*/

#define DEFAULT_SIGNATURE_LOCATION_X  (2 * xChar)
#define DEFAULT_SIGNATURE_LOCATION_Y  (2 * yChar)

POINTL    ptlName;              /* Used to print the Test Case signature
                                   at a particular location.               */

FONTMETRICS fm;                 /* Used to get the avg size of a char      */
SHORT       xChar;              /* contains avg width of a character       */
SHORT       yChar;              /* contains avg height of a character      */
CHAR        szDCType[25];       /* string describing the DC Type           */
CHAR        szPSType[25];       /* string describing the PS Type           */
CHAR        szPSUnits[25];      /* string describing the PS Units          */
CHAR        szSignature1[100];  /* string containing the signature         */
CHAR        szSignature2[100];  /* string containing the signature         */
CHAR        szLogEntry[100];    /* string contains a log entry             */
