/**************************************************************************
 *
 * SOURCE FILE NAME = PTTLOG.H
 *
 * DESCRIPTIVE NAME = This header file defines the macros and external functions
 *                    for access to the PTT logging tool.
 *
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

/*
** Open the logging file
** - filename is a null terminated string specifying the name of the log file
** example:  PTT_OPENLOG("PTT_LOG");
*/

#define  PTT_OPENLOG(filename) ptt_openlog(filename)
VOID ptt_WriteHeader(VOID);

VOID ptt_RecordLogLevel(VOID);

/*
** Write to the log file
** - level is logging level
** - rc is a return code (not used but kept for compatibility with testlog)
** - string is the string to output to the log file
** example:  PTT_CWRITELOG(L_FAIL,0,"*ERROR - partial arc did not close\n");
*/

/*
** Close the log file
** - no parms (yet)
** example:  PTT_CLOSELOG();
*/

#define  PTT_CLOSELOG() ptt_closelog()

/*
** if in PTTLOG module then define as local
*/

#if      defined(PTTLOG)
INT pttloglevel;                      /* ptt log level (from command line) */
HFILE logfile;
ULONG Wrote = 0;
VOID ptt_openlog(CHAR *logname);      /* open log                          */
VOID ptt_closelog();                  /* close log file                    */


#else
extern INT pttloglevel;                 /* logging level (from CWRITELOG)  */
extern HFILE logfile;                   /* pointer to log file             */
extern VOID ptt_openlog(CHAR *logname); /* open log                        */
extern VOID ptt_closelog(VOID);         /* close log file                  */
#endif
