/**************************************************************************
 *
 * SOURCE FILE NAME = PTTLOG.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 *   Purpose: Provides an alternative logging method for PTT--ie, instead
 *            of using the Testlog logging method.
 *
 *
 *
 * FUNCTIONS  : ptt_openlog
 *              ptt_closelog
 *
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 ****************************************************************************/

#define INCL_DOSFILEMGR
#include <stdio.h>
#include <os2.h>
#include "PTT.h"
#define  PTTLOG
#include "PTTLog.h"

/***************************************************************************
 *
 * FUNCTION NAME =   ptt_openlog
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Open the logging file and print out the header
 *             to the log file.
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/






VOID ptt_WriteHeader(VOID)
{
  CHAR buffer[200];

  DosGetDateTime(&DateTime);    /* get the date and time to enter into log  */

   /*
   ** Print out the header to the log file
   */


    sprintf(buffer,"Start of PTT\n");
    sprintf(buffer,"%02d/%02d/%02d      %02d:%02d\n",DateTime.month,DateTime.day,
                                                     DateTime.year,DateTime.hours,
                                                     DateTime.minutes);
    sprintf(buffer,"=== START ===\n");

    DosWrite(logfile,(PVOID)buffer,strlen(buffer),&Wrote);
  return ;
}

/***************************************************************************
 *
 * FUNCTION NAME =   ptt_RecordLogLevel
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID ptt_RecordLogLevel(VOID)
{
  CHAR szLogLevel[20];
  CHAR buffer1[200];
  CHAR buffer2[200];

  DosGetDateTime(&DateTime);    /* get the date and time to enter into log */

   /*
   ** find out the log level for entry into the log file header
   */

  switch (pttloglevel)
  {
    case  L_HDR :
      strcpy(szLogLevel,
             "L_HDR");
      break;
    case  L_ABORT :
      strcpy(szLogLevel,
             "L_ABORT");
      break;
    case  L_FAIL :
      strcpy(szLogLevel,
             "L_FAIL");
      break;
    case  L_WARN :
      strcpy(szLogLevel,
             "L_WARN");
      break;
    case  L_TRACE :
      strcpy(szLogLevel,
             "L_TRACE");
      break;
    case  L_LOTRACE :
      strcpy(szLogLevel,
             "L_LOTRACE");
      break;
    case  L_DEBUG :
      strcpy(szLogLevel,
             "L_DEBUG");
      break;
    default  :                /* should never get here, but just in case.  */
      strcpy(szLogLevel,
             "L_HDR");
      break;
  }

  sprintf(buffer1,"----------- Current Logging Level -----------.\n");
  sprintf(buffer2,"Logging Level = %d (%s)\n",pttloglevel,szLogLevel);

  DosWrite(logfile,(PVOID) buffer1,strlen(buffer1),&Wrote);
  DosWrite(logfile,(PVOID) buffer2,strlen(buffer2),&Wrote);
  return ;
}

/***************************************************************************
 *
 * FUNCTION NAME =   ptt_openlog
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = CHAR *Filename
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID ptt_openlog(CHAR *filename)
{
  APIRET rc;
  ULONG Action;


  rc = DosOpen(filename,
               &logfile,
               &Action,
               0L,
               FILE_NORMAL,
               OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
               OPEN_SHARE_DENYNONE | OPEN_ACCESS_WRITEONLY ,
               NULL);

   if( rc != 0)
   {
     PostErrorMessage(hWndClient,IDS_ERR_OPENFILE);
     DosExit(0,0);
   }


  return ;
}                                      /* end ptt_openlog                  */

/***************************************************************************
 *
 * FUNCTION NAME =   ptt_closelog
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Close the logging file and print out the trailer
 *             to the log file.
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = CHAR *Filename
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID ptt_closelog()
{
  CHAR buffer1[200];
  CHAR buffer2[200];
  CHAR buffer3[200];

  DosGetDateTime(&DateTime);    /* get the date and time to enter into log  */


  sprintf(buffer1,"\n=== END ===\n");
  sprintf(buffer2,"%02d:%02d\n",DateTime.hours,DateTime.minutes);
  sprintf(buffer3,"=== End of PTT run \n");


  DosWrite(logfile,(PVOID)buffer1,strlen(buffer1),&Wrote);
  DosWrite(logfile,(PVOID)buffer2,strlen(buffer2),&Wrote);
  DosWrite(logfile,(PVOID)buffer3,strlen(buffer3),&Wrote);


  DosClose(logfile);

  logfile = NULLHANDLE;
}                                      /* end ptt_closelog                  */



