/**************************************************************************
 *
 * SOURCE FILE NAME = PTTCOMM.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose: Handle WM_COMMAND message processing--ie, Testcases,
 *          Actions, Options, and Help menu items.
 *
 *
 *
 * FUNCTIONS  : PTT_Command
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 ****************************************************************************/


#include "PTT.h"
#include "PTTcomm.h"

/***************************************************************************
 *
 * FUNCTION NAME =   PTT_Command(HWND hwnd, msg, mp1, mp2)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle WM_COMMAND message processing.
 *
 *
 *   Function Calls:  TestCasesDlgProc
 *                    ConfigDlgProc
 *                    cwCheckPulldown
 *                    LogLevelDlgProc
 *                    AboutDlgProc
 *
 * INPUT = HWND   hwnd
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID PTT_Command(HWND   hwnd,
                 USHORT message,
                 MPARAM mp1,
                 MPARAM mp2)
{
  USHORT junk1 = message;
  MPARAM junk2 = mp2;


  switch (SHORT1FROMMP(mp1))
  {
    case  IDM_TESTCASES :

      /*
      ** Display the testcases dialog box
      */

      WinShowWindow(hwndTestCasesDlg,
                    TRUE);
      WinSendMsg(hwndTestCasesDlg,
                 WM_DISABLE_DISPLAY_OPTION,
                 NULL,
                 MPFROMSHORT(MIA_DISABLED));
      WinSetFocus(HWND_DESKTOP,
                  hwndTestCasesDlg);
      break;
    case  IDM_ACTIONS_DISPLAY :

      /*
      ** send test output to the display
      */

      if (bRunMultipleTests)
      {
        WinPostQueueMsg(hMQPrintThread,
                        WM_START_MULTIPLE,
                        MPFROMSHORT(WM_TEST_DISPLAY),
                        NULL);
      }

      else
      {
        WinPostQueueMsg(hMQPrintThread,
                        WM_TEST_DISPLAY,
                        MPFROMP(pSelectedTestCase),
                        NULL);
      }
      break;
    case  IDM_ACTIONS_PRINT :

      /*
      ** send test output to the printer
      */

      if (bRunMultipleTests)
      {
        WinPostQueueMsg(hMQPrintThread,
                        WM_START_MULTIPLE,
                        MPFROMSHORT(WM_TEST_PRINT),
                        NULL);
      }

      else
      {
        WinPostQueueMsg(hMQPrintThread,
                        WM_TEST_PRINT,
                        MPFROMP(pSelectedTestCase),
                        NULL);
      }
      break;
    case  IDM_OPTIONS_CONFIGURATION :

      /*
      ** Display the configuration dialog box
      */

      WinDlgBox(HWND_DESKTOP,
                hwnd,
                (PFNWP)ConfigDlgProc,
                (HMODULE)NULL,
                IDLG_CONFIG,
                NULL);
      break;
    case  IDM_OPTIONS_DISPLAYLOG :

      /*
      ** Menu Item Named "~Display log window"
      */

      bDisplayLogWindow = !bDisplayLogWindow;

      /*
      ** display/hide window
      */

      WinShowWindow(hwndLogDlg,
                    bDisplayLogWindow);
      WinSetFocus(HWND_DESKTOP,
                  bDisplayLogWindow == TRUE?hwndLogDlg:hwnd);

      /*
      ** set the menu item as checked/unchecked
      */

      cwCheckPulldown(hWndFrame,
                      IDM_OPTIONS_DISPLAYLOG);
      break;
    case  IDM_OPTIONS_LOGLEVEL :

      /*
      ** Display the log level dialog box
      */

      WinDlgBox(HWND_DESKTOP,
                hwnd,
                (PFNWP)LogLevelDlgProc,
                (HMODULE)NULL,
                IDLG_LOGLEVEL,
                NULL);
      break;
    case  IDM_HELP_ABOUT :

       /*
       ** Display the about dialog box
       */

      WinDlgBox(HWND_DESKTOP,
                hwnd,
                (PFNWP)AboutDlgProc,
                (HMODULE)NULL,
                IDLG_ABOUT,
                NULL);
      break;
    case  IDM_EXIT :
     WinSendMsg(hWndClient,WM_CLOSE,0L,0L);
    break;
    default  :
      break;                        /* End of default case for switch(mp1) */
  }                                 /* End switch                          */
}                                   /* End PTTCommand                      */
