#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_DEV
#define INCL_GPITRANSFORMS  // transforms and transform conversion functions
#define INCL_GPICONTROL   // for GpiQueryPS
#define INCL_ERRORS
#include <string.h>
#include <stdio.h>
#include <os2.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpixform.h"               // transform dll header file
/* set function name for dll init routine */

PCHAR pTestName1  = "GpiSetAndQryPageViewportPre";
PCHAR pTestName2  = "GpiSetAndQryModelXformMatPre";
PCHAR pTestName3  = "GpiSetAndQrySegmentXformMatPre";
PCHAR pTestName4  = "GpiCallSegmentMatrixPre";
PCHAR pTestName5  = "GpiSetAndQryDefViewMatrixPre";
PCHAR pTestName6  = "GpiSetAndQryViewingXformMatPre";
PCHAR pTestName7  = "GpiTransformApp";
PCHAR pTestName8  = "GpiSetAndQryPageViewportExh";
PCHAR pTestName9  = "GpiSetAndQryModelXformMatExh";
PCHAR pTestName10 = "GpiSetAndQrySegmentXformMatExh";
PCHAR pTestName11 = "GpiCallSegmentMatrixExh";
PCHAR pTestName12 = "GpiSetAndQryDefViewMatrixExh";
PCHAR pTestName13 = "GpiSetAndQryViewingXformMatExh";
PCHAR pTestName14 = "GpiConvertExh";

PCHAR pCurTestName; // used by entry points that use set_transform

CHAR achLogLine[100];      //Buffer used for printing error messages

LONG ErrorCount;          //Error counter.

/****************************************************************************
 *\\ddd
 * Subtask Name: gpixform.dll
 *
 * Module name: gpixform.c
 *
 * Purpose: transform gpi dll test functions
 *          GpiSetModelTransformMatrix, GpiQueryModelTransformMatrix
 *          GpiSetSegmentTransformMatrix, GpiQuerySegmentTransformMatrix
 *          GpiCallSegmentMatrix,
 *          GpiSetDefaultViewMatrix, GpiQueryDefaultViewMatrix
 *          GpiSetViewingTransformMatrix, GpiQueryViewingTransfromMatrix
 *          GpiSetPageViewport, GpiQueryPageViewport
 *          GpiConvert,
 *          GpiScale, GpiRotate, GpiTranslate
 *
 * Revision Log:
 *               - initial file
 *               01/10/91 ,PDVT, Thom Bain
 *               -Test Case Design.
 *               03/21/91, PDVT, Thom Bain
 *               - cleanup, comments, etc.
 *
 * SAD References:
 *
 * SRS References: Printer Driver Verification Tool
 *
 * Contents:
 *         InitTest - setups testcase and entrypoints for PTT
 *
 *         GpiPageViewportCommon - common part of PageViewport functions
 *                                 precision and exhaustive entry points
 *         GpiSetAndQryPageViewportPre - Page Viewport precision test
 *         GpiSetAndQryPageViewportExh - Page Viewport exhaustive test
 *
 *         set_transform: common support function to setup transform matrix
 *                        using GpiScale, GpiRotate, and GpiTranslate.
 *
 *         GpiTransformApp - test that uses all transform GPIs together
 *                           and generally manipulates their relationships
 *                           and combination possiblities (also uses
 *                           GpiRotate, GpiScale, & GpiTranslate functions)
 *
 *         GpiModelTransformCommon - common part of Model transform
 *                                   precision and exhaustive entry points
 *         GpiSetAndQryModelXformMatPre - Model Transform precision test
 *         GpiSetAndQryModelXformMatExh - Model Transform exhaustive test
 *
 *         GpiSegmentTransformCommon - common part of Segment transform
 *                                   precision and exhaustive entry points
 *         GpiSetAndQrySegmentXformMatPre - Segment Transform precision test
 *         GpiSetAndQrySegmentXformMatExh - Segment Transform exhaustive test
 *
 *         GpiCallSegmentCommon - common code for GpiCallSegmentMatrix
 *                                   precision and exhaustive entry points
 *         GpiCallSegmentMatrixPre - Instance transform precision test
 *         GpiCallSegmentMatrixExh - Instance transform exhaustive test
 *
 *         GpiDefaultViewCommon - common code for Default View Matrix
 *                                   precision and exhaustive entry points
 *         GpiSetAndQryDefViewMatrixPre - Default View precision test
 *         GpiSetAndQryDefViewMatrixExh - Default View exhaustive test
 *
 *         GpiViewingTransformCommon - common part of Viewing Transform
 *                                     precision and exhaustive entry points
 *         GpiSetAndQryViewingXformMatPre - Viewing Transform precision test
 *         GpiSetAndQryViewingXformMatExh - Viewing Transform exhaustive test
 *
 *         report - support function for GpiConvertExh (uses ERRSTATUS to
 *                  indicate and log mismatch between recieved and expected.
 *         GpiConvertExh - establishes known transforms and uses GpiConvert
 *                         on know input and checks for expected results.
 *
 *
 *********** following moved from View test case ***************
 *         GpiQueryPageViewPort - GpiSetPageViewPort                            *
 *         as:                                                 *
 *            GpiPageViewportPre/Exh()                                                                  *
 *            GpiPageViewportRc()                              *
 *                                                                                                                                                                      *
 *          also note that current Phase I View testcase has   *
 *          no precision test only an exhaustive and a return  *
 ***************************************************************
 *
 *********** following moved to Phase I View testcase **********
 *         GpiQueryDefViewingLimits w/GpiSetDefViewingLimits   *
 *         GpiQueryGraphicsField w/GpiSetGraphicsField                  *
 *         GpiQueryViewingLimits w/GpiSetViewingLimits                  *
 ***************************************************************
 *
 *
 * Design Overview:
 *   This TestCase is designed to test the GPI Transformation functions.
 *   All the precision and exhaustive entry points are identical. They
 *   are only separated so testers can logically attack the testcase
 *   (i.e. only run exhaustive tests one night).
 *
 * Limitations:
 *
 *  All the Gpi and Gre functions, other than the above, which are used in
 *  implementing this testcase, are assumed to be fully tested in other
 *  testcases.
 *
 *  Some of the test GPIs require a "NORMAL" presentation space.  The "App"
 *  entry point simply skips what it can't do if in "MICRO".  The precision
 *  and exhaustive tests that require a "NORMAL" PS (GpiSetAndQrySegment-
 *  XformMatPre/Exh, GpiCallSegmentMatrixPre/Exh, and GpiSetAndQryViewing-
 *  XformMatPre/Exh) simple log that fact and exit FAIL with an error count
 *  of one.  The return code tests effected (GpiSetAndQrySegmentMatRc,
 *  GpiCallSegmentMatrixRc, and GpiSetAndQryViewingXformMatRc) log what
 *  mode they are in an inform user/tester what part of test can be done
 * (usually PMERR_INV_MICROPS_FUNCTION when in MICRO PS vs. anything else).
 *
 *\\end
****************************************************************************/

/****************************************************************************
 *\\ddd
 * Routine Name: InitTest()
 *
 * Purpose:  Initialize function name and address array for ptt.
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *
 * Inputs:
 *   sel          // passed through to the InitTestSegVars function
 *   pInit_info   // name and address array used by ptt interface
 *
 * Outputs:
 *   pInit_info   // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the ptt interface
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   for the number of test functions {
 *       set function name
 *       set function address
 *   }
 *   call init set function
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID Selector, PTESTINITINFO init_info_p)
{
  register USHORT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(Selector);
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiPageViewportCommon()
 *
 * Purpose:  Common code between precision and exhaustive testing of the
 *                PageViewport functions
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    - client window handle
 *        pTestName     - which test is running name
 *
 * Outputs: boolean TRUE or FALSE indicating an error occurred or not.
 *
 *    device output:
 *                   - one grid
 *                   - 4 inch square box with lower left corner at [1",1"]
 *                     outline filled with horizontal line pattern
 *                   - one inch square boxes at every other position in
 *                     the original where x + y of lower left corner is odd
 *                     outline filled with vertical line pattern.
 *
 * Subroutines Required: GpiQueryDevice, CLEANUP, LOGINFO, ENTER_MAIN,
 *  EXIT_MAIN, GpiMove, GpiBox, MapAndWriteString, GpiSetPageViewport,
 *  GpiQueryPageViewport, and gpi_grid
 *
 * Subroutines tested: GpiSetPageViewport
 *                     GpiQueryPageViewport
 *
 * Limitations: none
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   - The current Viewport is saved via GpiQueryPageViewport
 *   - A four square inch Viewport is established with corner coordinates
 *     [1",1"] and [5",5"]
 *   - An outline filled box is drawn the size of the entire page (used
 *     GpiQueryPS to determine size).  The fill pattern is horizontal
 *     lines.
 *   - The original viewport is restored to original and descriptive
 *     text is written about this viewport.
 *   - The fill pattern is changed to vertical lines.
 *   - Create one inch square Viewports within the original Viewport
 *     at each even increment of an inch such that the viewport will
 *     be contained in the original and the lower left coordinates sum
 *     is odd ((x+y) modulo 2 == 1).  In each Viewport draw an outline
 *     filled box the size of the entire page (same page coordinates
 *     as used in the original 4 inch Viewport).
 *   - The viewport is restored to original and descriptive
 *     text is written about the sub-viewports.
 *   - A one inch precision grid is drawn.
 *
 *\\end
 ***************************************************************************/

static BOOL GpiPageViewportCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  RECTL   rectangle, save_viewport;
  POINTL  ptlLLC, ptlURC;
  INT     x,y;
  HDC     tmp_hdc;

  tmp_hdc = GpiQueryDevice(hPS);  // insure a device context is associated
  if ( tmp_hdc == HDC_ERROR )     // INV_HDC or INV_HPS
  {
     CLEANUP("GpiQueryDevice", pTestName);
     return(FALSE);
  }

  if ( tmp_hdc == NULLHANDLE)           // no device context associated
  {
     LOGINFO(L_HDR, "@", "System ERROR! No device context associated!");
     EXIT_MAIN(pTestName);
     return(FALSE);
  }

  // save original page viewport for restoration and printing later
  if (GpiQueryPageViewport(hPS, &save_viewport) == FALSE) {
    CLEANUP("GpiQueryPageViewport", pTestName);
    return(FALSE);
  }

  // Set the page viewport to be a 4" x 4" rectangle from
  // coordinates (1",1") to (5",5") coordinates must be specified
  // in device coordinates.


  rectangle.xLeft   =  (LONG)((0.0254 * (double)hori_pels_per_m) + 0.5);
  rectangle.yBottom =  (LONG)((0.0254 * (double)vert_pels_per_m) + 0.5);

  rectangle.xRight  = (LONG)((0.127 * (double)hori_pels_per_m) + 0.5) + 1L;
  rectangle.yTop    = (LONG)((0.127 * (double)vert_pels_per_m) + 0.5) + 1L;

  if (GpiSetPageViewport(hPS, &rectangle) == FALSE) {
    CLEANUP("GpiSetPageViewport", pTestName);
    return(FALSE);
  }

  // set up fill pattern for large box (upper left to bottom right)
  if (GpiSetPattern(hPS, PATSYM_HORIZ) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return(FALSE);
  }

  // draw an outline filled box for the entire window
  ptlLLC.x = 0L;
  ptlLLC.y = 0L;
  ptlURC.x = pg_width - 1;
  ptlURC.y = pg_height - 1;
  GpiMove(hPS, &ptlLLC);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURC, 0L, 0L);

  // restore the saved viewport and write about first viewport
  if (GpiSetPageViewport(hPS, &save_viewport) == FALSE) {
    CLEANUP("GpiSetPageViewport", pTestName);
    return(FALSE);
  }

  //  Print a message on the PS that GpiSetPageViewport is being called.
  MapAndWriteString(200L, 570L, "Calling GpiSetPageViewport");

  //  Print the size of the page viewport on the PS.
  MapAndWriteString(100L, 510L,
                "First Page Viewport is 4\" x 4\" at [1\",1\"], [5\",5\"]");

  // indicate boxes to be drawn
  MapAndWriteString(510L, 470L, "  horizontal line filled.");

  // set up fill pattern for small boxes (lower left to upper right)
 if (GpiSetPattern(hPS, PATSYM_VERT) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return(FALSE);
  }

  // using the Query'd page space size draw box outline filled
  // at every other square in the viewport at 1/4 the size of
  // the presentation space.  This should map to the original grid!

  for (x = 1; x < 5; x++) {
    for (y = 1; y < 5; y++) {
      if ( ((x+y) % 2) == 1 ) {

        // set viewport for one inch box
        rectangle.xLeft =
          (LONG)(((double)x * 0.0254 * (double)hori_pels_per_m) + 0.5);
        rectangle.yBottom =
          (LONG)(((double)y * 0.0254 * (double)vert_pels_per_m) + 0.5);
        rectangle.xRight =
        (LONG)(((double)(x+1) * 0.0254 * (double)hori_pels_per_m) + 0.5) + 1L;
        rectangle.yTop =
        (LONG)(((double)(y+1) * 0.0254 * (double)vert_pels_per_m) + 0.5) + 1L;

        if (GpiSetPageViewport(hPS, &rectangle) == FALSE) {
          CLEANUP("GpiSetPageViewport", pTestName);
          return(FALSE);
        }

        // draw an outline filled box for the entire window
        GpiMove(hPS, &ptlLLC);
        GpiBox(hPS, DRO_OUTLINEFILL, &ptlURC, 0L, 0L);

      } /* if */
    } /* for y */
  }  /* for x */

  // restore the saved viewport and write about sub-viewports
  if (GpiSetPageViewport(hPS, &save_viewport) == FALSE) {
    CLEANUP("GpiSetPageViewport", pTestName);
    return(FALSE);
  }

  gpi_grid(hPS, ONE_INCH);

  MapAndWriteString(510L, 440L, "1\" square sub-Viewports");
  MapAndWriteString(510L, 410L, " in original at every other");

  MapAndWriteString(510L, 370L, " inch such that (x+y) is odd,");

  MapAndWriteString(510L, 340L, " with a page sized, outlined");

  MapAndWriteString(510L, 310L, " vertical line filled box in each.");

  return(TRUE);
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryPageViewportPre()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Transform
 *                               precision tests for GpiSetPageViewport/GpiQueryPageViewport
 *           to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiPageViewportCommon
 *
 * Subroutines Required:
 *                       ENTER_MAIN, LOGINFO, GpiQueryPS, GpiPageViewportCommon, EXIT_MAIN
 *        WindSendMsg, MapAndWriteString
 *
 * Subroutines tested: GpiSetPageViewport,
 *                     GpiQueryPageViewport
 *
 * Limitations: Testcase entry point only valid in a GPIT_NORMAL presentation
 *   space.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   - ENTER_MAIN
 *        - Query the PS for type
 *   - if PS_UNITS == PU_PELS then log fact test is valid precision test
 *            else log fact test is not a valid prescion test
 *   - Call GpiPageViewportCommon to do the test
 *   - if common function succeeded then EXIT_MAIN (otherwise its been
 *       done already.
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryPageViewportPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  SIZEL   sizlPS;
  ULONG   flOptions;
  BOOL    bSuccess;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(pTestName1);

    // get presentation space size
    // if PS_UNITS == PU_PELS log fact that is valid precision test
    flOptions = GpiQueryPS(hPS, &sizlPS);
    if ( (flOptions & PS_UNITS) == PU_PELS) {
      MapAndWriteString(150L, 540L,
                        "PS units == PU_PELS, precision test VALID!");
      LOGINFO(L_HDR,"*","PS units == PU_PELS, precision test VALID!");
    }
    else
    {
      MapAndWriteString(150L, 540L,
                        "PS units != PU_PELS, precision test NOT VALID!");
      LOGINFO(L_HDR,"*","PS units != PU_PELS, precision test NOT VALID!");
    }

    bSuccess = GpiPageViewportCommon(hPS, hWndClient, pTestName1);

    if (bSuccess) EXIT_MAIN(pTestName1);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryPageViewportExh()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Transform
 *                               precision tests for GpiSetPageViewport/GpiQueryPageViewport
 *           to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiPageViewportCommon
 *
 * Subroutines Required:
 *                       WindSendMsg, ENTER_MAIN, GpiPageViewportCommon, EXIT_MAIN
 *
 * Subroutines tested: GpiSetPageViewport,
 *                     GpiQueryPageViewport
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   - ENTER_MAIN
 *   - Call GpiPageViewportCommon to do the test
 *   - if common function succeeded then EXIT_MAIN (otherwise its been
 *       done already.
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryPageViewportExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  BOOL bSuccess;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(pTestName8);

    pCurTestName = pTestName8;
    bSuccess = GpiPageViewportCommon(hPS, hWndClient, pTestName8);

    if (bSuccess) EXIT_MAIN(pTestName8);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: set_transform
 *
 * Purpose:  This is a support function for the test cases that will use
 *                               GpiScale, GpiRotate, and GpiTranslate to maniputlate the
 *                               given transform always REPLACING the given matrix.
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        pmatlfMat     - transformation matrix
 *        fxXScale      - scale to apply to the x coordinate
 *        fxYScale      - scale to apply to the y coordinate
 *        fRotate       - flag indicating rotation or not
 *        fxAngle       - rotation angle
 *        lXCenter      - X coordinate to center rotation on
 *        lYCenter      - Y coordinate to center rotation on
 *        lXTranslate   - X axis translation amount
 *        lYTranslate   - Y axis translation amount
 *
 * Outputs:
 *        pmatlfMat     - adjusted transformation matrix
 *
 * Subroutines Required:
 *       GpiScale, GpiRotate, GpiTranslate
 *
 * Limitations:
 *        this function assumes that all scaling is done relative to [0,0]
 *        zero value scaling is invalid.
 *        error checking is done and appropriate logging/reporting will occur
 *        it is left up to the calling function, whether to terminate the
 *        current test entry point.  The function terminates on the first
 *        helper function to fail and returns FALSE to indicate failure.
 *        It should also be noted that the functions are applied to the
 *        given matrix in the order, GpiScale, GpiRotate, & GpiTranslate.
 *        If one wishes to scale after rotation the two calls are required
 *        with the first specifying a scale of one with the rotation then
 *        the second call with the desired scaling.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *  - initialize return flag to TRUE
 *  - if either scale is zero, invalid input and don't scale
 *    else assume scaling from origin is desired and call GpiScale
 *    to perfrom desired scaling. if an error occurred call CLEANUP
 *    and set return flag to FALSE to abort rest of function.
 *  - if given rotation angle is not equal to zero then call
 *      GpiRotate with given angle and center points (call MapX, & MapY
 *      to convert to appropriate page units for center point, use care
 *      to not "map" 0). if an error occurred call CLEANUP and set flag
 *      to FALSE to abort rest of function
 *  - if either given translation amount is not zero (something to do)
 *      call GpiTranslate with SizeX and SizeY mapping of amounts (note
 *      the difference between location (Map?) and amount (Size?)). If
 *      an error occurred call CLEANUP set flag to FLASE to indicate failure
 *      Also use care to not "Size" zero 0.
 *  - return return flag
 *
 *\\end
 ***************************************************************************/

BOOL set_transform( HPS hPS, HWND hWndClient, PMATRIXLF pmatlfMatrix,
                           FIXED fxXScale, FIXED fxYScale,
                           FIXED fxAngle, LONG lXCenter, LONG lYCenter,
                           LONG lXTranslate, LONG lYTranslate)
{
  FIXED   afxScales[2];         /* X & Y scale values for GpiScale */
  POINTL  ptlScaleCenter;       /* point about which the scale occurs */
  POINTL  ptlTranslate;         /* translation values */
  POINTL  ptlRotateCenter;      /* center point for rotation, if any */
  BOOL    retcode;              /* return value of function */

  retcode = TRUE;
  // test for zero scaling, it is invalid, means no scaling desired */
  if ((fxXScale != ZERO_FIXED) && (fxYScale !=ZERO_FIXED)) {
    afxScales[0] = fxXScale;
    afxScales[1] = fxYScale;
    ptlScaleCenter.x = 0L;
    ptlScaleCenter.y = 0L;
    retcode = GpiScale(hPS,pmatlfMatrix,TRANSFORM_REPLACE,afxScales,
                                                            &ptlScaleCenter);
    if (retcode == FALSE) {
      // handle error - increment error count and log error
      CLEANUP("GpiScale", pCurTestName);
      return(retcode);
    }   /* if retcode */
  } /* if not zero scale */

  // test for zero angle, means no rotation desired
  if (fxAngle != ZERO_FIXED) {
    if (lXCenter != 0L)
      ptlRotateCenter.x = MapX(lXCenter);
    else
      ptlRotateCenter.x = 0L;
    if (lYCenter != 0L)
      ptlRotateCenter.y = MapY(lYCenter);
    else
      ptlRotateCenter.y = 0L;
    retcode = GpiRotate(hPS,pmatlfMatrix,TRANSFORM_ADD,fxAngle,
                                                           &ptlRotateCenter);
    if (retcode == FALSE) {
      // handle error - increment error count and log error
      CLEANUP("GpiRotate", pCurTestName);
      return(retcode);
    }
  }

  // test for no translation, don't waste time if none given
  if ((lXTranslate != 0L) || (lYTranslate != 0L)) {
    if (lXTranslate != 0L)
      ptlTranslate.x = SizeX(lXTranslate);
    else
      ptlTranslate.x = 0L;
    if (lYTranslate != 0L)
      ptlTranslate.y = SizeY(lYTranslate);
    else
      ptlTranslate.y = 0L;
    retcode = GpiTranslate(hPS,pmatlfMatrix,TRANSFORM_ADD,&ptlTranslate);
    if (retcode == FALSE) {
      // handle error - increment error count and log error
      CLEANUP("GpiTranslate", pCurTestName);
      return(retcode);
    }
  }
  return(retcode);
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiTransformApp
 *
 * Purpose: Transform GPI functionality test.  General exercise of all GPIs
 *          in the testcase.
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:  (in GPIT_NORMAL PS_TYPE) six boxes on a half-inch grid
 *            box 1: one inch square w/lower left corner at [2",2"]
 *            box 2: half-inch square w/lower left corner at [1",1"]
 *            box 3: two inch wide by one inch high rectangle with lower
 *                   left corner at [1",5"]
 *            box 4: one inch square w/ lower left corner at [2", 4"]
 *            box 5: half-inch square w/lower left corner at [3.5", 3"]
 *            box 6: half-inch square w/lower left corner at [3.5", 4.5"]
 *            All boxes are outlined and filled with diagonal line pattern
 *
 * Subroutines Required: WindSendMsg, ENTER_MAIN, EXIT_MAIN, gpi_grid
 *   MapAndWriteString, GpiQueryPS, LOGINFO, CLEANUP, set_transform,
 *   GpiCallSegmentMatrix, GpiSetViewingTransformMatrix, GpiQueryViewing-
 *   TransformMatrix, GpiSetPattern, GpiSetPattern, GpiSetInitialSegmentAttrs,
 *   GpiSetModelTransformMatrix, GpiQueryModelTransformMatrix,
 *   GpiSetSegmentTransformMatrix, GpiQuerySegmentTransformMatrix,
 *   GpiOpenSegment, GpiMove, GpiBox, GpiCloseSegment, GpiDrawSegment,
 *   GpiSetDefaultViewMatrix, GpiQueryDefaultViewMatrix,
 *   GpiSetPageViewport, and GpiQueryPageViewport
 *
 * Subroutines tested:
 *              GpiSetModelTransformMatrix, GpiQueryModelTransformMatrix
 *              GpiSetSegmentTransformMatrix, GpiQuerySegmentTransformMatrix
 *              GpiCallSegmentMatrix
 *              GpiSetViewingTransformMatrix, GpiQueryViewingTransformMatrix
 *              GpiSetDefaultViewMatrix, GpiQueryDefaultViewMatrix,
 *              GpiSetPageViewport, GpiQueryPageViewport
 *
 * Limitations: Only part of test will run if not in NORMAL PS.
 *    Also not incorrect documentation on GpiCallSegmentMatrix on pg
 *   4-26 of PM Prog. Ref. "The called segment must have a unity transform
 *   for the viewing transform (see GpiSetViewingTransformMatrix) and on pg.
 *   4-332 "The viewing transform must be set (or defaulted) to the unity
 *   transform, before any segment that is to be called is first opened.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *    - Query the presentation space type, set a flag fNormalPS = TRUE if
 *      GPIT_NORMAL, else set it to FALSE. If not NORMAL then log message
 *      to user/tester indicating normal execution won't happen.
 *    - Draw a precision grid of one-half inch squares
 *    - Query the Model Transform Matrix (output counts on this
 *      being the unity matrix by default).
 *    - Set the Model Transform Matrix to scale by factor of one-half
 *      and translate by [2", 2"].
 *    - if fNormalPS == FALSE skip to x1x
 *    - Query the current Viewing Transform Matrix (output counts on
 *      this beign the unity matrix by default).
 *    - Set the Viewing Transform Matrix to scale by a factor of
 *      one-half without any translation.
 * x1x- Set default fill pattern to a diagonal line
 *    - Draw a box 2" x 2" at [0,0] [2,2], outside a segment
 *      note that the viewing transform has no effect and the box is
 *      drawn 1" x 1" at [2", 2"]
 *    - if fNormalPS == FALSE skip to x2x
 *    - Create a box with the same definition but in a segment and
 *      draw that.   Note that with the viewing transform in effect
 *      the box appears as 1/2" x 1/2" at [1",1"].
 *    - Setup an "instance" transform to scale x by 1/2 and y by 1 and
 *      translate by [1", 5"], then rotate that 270 degrees about the
 *      center point of [1.5",5.5"].
 *    - "call" the sement with this transform.  Note that the model
 *      and view transforms are overridden by the instance transform
 *      and the box appears 2" x 1" at [1", 5"].
 *    - Query then set a segment transform matrix to scale by a factor of
 *      two and translate by [6", 3"].
 *    - Draw the previously defined segment.  Note the combined effects
 *      of the Model, Viewing, and Segment transforms.  The box now
 *      appears 1" x 1" at [5", 3.5"].
 * x2x- restore the model transform matrix to scale by 1/2 and translate
 *      [2",2"] (GpiDrawSegment when segment matrix is not unity will
 *      effect the model transform - see GpiSetAndQrySegmentXformMatExh)
 *    - set the default view matrix to scale by 1/2
 *    - draw a box at [0,0] [2,2] (outside segment w/GpiMove & GpiBox).
 *      Note that only the model and default view apply here.
 *    - Query the PageViewport and save the current values.
 *    - Set the page viewport to be 1.5 inches up from the bottom to the
 *      device but the same size as originally.
 *    - draw box 5 again, note that it's just 1.5 inches higher in the
 *      window (above change to viewport was effectively setting the
 *      device transform to scale by 1 and translate [1.5,0]).
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiTransformApp(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL        ptlURCorner, ptlLLCorner;
  MATRIXLF  matlfModel;
  MATRIXLF  matlfViewing;
  MATRIXLF  matlfSegment;
  MATRIXLF  matlfInstance;
  MATRIXLF  matlfView;
  BOOL      bSuccess, fNormalPS;
  LONG      lHits;
  ULONG     flOptions;
  SIZEL     sizlSize;
  RECTL     rectangle, save_viewport;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(pTestName7);

    //   Draw precision test grid of 1/2-inch squares *
    gpi_grid(hPS, HALF_INCH);

    MapAndWriteString(250L, 630L, "Half Inch Precision Grid");
    MapAndWriteString(150L, 610L,
    "All boxes drawn via \"GpiMove(0\",0\"); GpiBox(OUTLINEFILL,2\",2\");\"");

    // set global test name pointer for set_transform
    pCurTestName = pTestName7;

    fNormalPS = TRUE;
    // query Presentation Space to insure a type of GPIT_NORMAL
    flOptions = GpiQueryPS(hPS, &sizlSize);
         if ( (flOptions & PS_TYPE) != GPIT_NORMAL) {
      MapAndWriteString(100L, 170L,
                         "To execute properly, PS_UNITS must be Normal!");
      LOGINFO(L_LOTRACE,"*",
                         "To execute properly, PS_UNITS must be Normal!");
      fNormalPS = FALSE;
    }

    // initialize the model transform matrix    to scale by 1/2 and translate
    // by 2 inches both x and y.

    // get the current model transform
         bSuccess = GpiQueryModelTransformMatrix(hPS, 9L, &matlfModel);
    if ( bSuccess == FALSE) {
      // handle unexpected error
      CLEANUP("GpiQueryModelTransformMatrix", pTestName7);
      return;
    }

    // set the scale to 1/2 and translate [2",2"]
    bSuccess = set_transform(hPS, hWndClient, &matlfModel,
    /* scale factors */       HALF_FIXED,HALF_FIXED,
    /* rotation factors */    ZERO_FIXED, 0L, 0L,
    /* translation factors */ 200L, 200L);
    if (bSuccess == FALSE) return;

         // set the model transform, all primitives are effected by model
    // transforms when they are actually drawn
    bSuccess =
       GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
           CLEANUP("GpiSetModelTransformMatrix", pTestName7);
           return;
         }

    //    set a Viewing Transform to scale by one half, no translation
         //    Viewing transforms only affect subsequently opened segments
    //    and immediately effect coordinates in the segment.

    if (fNormalPS) {
      // get the current viewing transform
         bSuccess = GpiQueryViewingTransformMatrix(hPS, 9L, &matlfViewing);
      if ( bSuccess == FALSE) {
        // handle unexpected error
        CLEANUP("GpiQueryViewingTransformMatrix", pTestName7);
        return;
      }

      // set the scale to 1/2
      bSuccess = set_transform(hPS, hWndClient, &matlfViewing,
      /* scale factors */       HALF_FIXED,HALF_FIXED,
      /* rotation factors */    ZERO_FIXED, 0L, 0L,
      /* translation factors */ 0L, 0L);
      if (bSuccess == FALSE) return;

                 // set the viewing transform to scale by one half, no translation
      bSuccess =
        GpiSetViewingTransformMatrix(hPS, 9L, &matlfViewing, TRANSFORM_REPLACE);
                 if (bSuccess == FALSE) {
                   CLEANUP("GpiSetViewingTransformMatrix", pTestName7);
                   return;
                 }
    }

    // set up fill pattern to cross hatched so printers don't work too hard!
         if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
      CLEANUP("GpiSetPattern", pTestName7);
      return;
    }

    // Draw a 2" x 2" filled box at [0",0"] [2",2"].  This box is drawn
    // outside a segment so only the model transform applies.  This box
    // will actually appear as a 1" x 1" box [0",0"]
    ptlLLCorner.x = 0L;
    ptlLLCorner.y = 0L;
    ptlURCorner.x=MapX(200L);
    ptlURCorner.y=MapY(200L);

    GpiMove(hPS, &ptlLLCorner);
    GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

// start of fNormalPS testing ********************************************
    if (fNormalPS) {
      // Set drawing mode to retain.
      if (GpiSetDrawingMode(hPS, DM_RETAIN) == FALSE) {
        CLEANUP("GpiSetDrawingMode", pTestName7);
        return;
      }

      // Turn off the chained attribute as we are about to create a segment
      // that is to be "called" via GpiCallSegmentMatrix.
      if (GpiSetInitialSegmentAttrs(hPS, ATTR_CHAINED, ATTR_OFF) == FALSE) {
        CLEANUP("GpiSetInitialSegmentAttrs", pTestName7);
        return;
      }

                 //  Open a segment
      if (GpiOpenSegment(hPS, 888L) == FALSE) {
        CLEANUP("GpiOpenSegment", pTestName7);
        return;
      }

      // Draw a 2" x 2" filled box at [0",0"] [2",2"].  Note that since a
      // a viewing transform is defined this is actually a 1" x 1" box at
      // [0", 0"] [1", 1"] within the segment.
      GpiMove(hPS, &ptlLLCorner);
      GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

      //  Close the segment.
      if (GpiCloseSegment(hPS) == FALSE) {
        CLEANUP("GpiCloseSegment", pTestName7);
        return;
      }

      // Set drawing mode to draw
      if (GpiSetDrawingMode(hPS, DM_DRAW) == FALSE) {
        CLEANUP("GpiSetDrawingMode", pTestName7);
        return;
      }

                 //  Draw the box,  note that the model and the view transforms apply
      if (GpiDrawSegment(hPS, 888L) == FALSE) {
        CLEANUP("GpiDrawSegment", pTestName7);
        return;
      }

      //    set an Instance Transform for the given segment to keep the scale
      //    and translate by [1,5]. An "instance" transform will replace the
      //    model transform for this one call, then the original model
      //    transform will be restored.  Also note that IBM documentation
      //    for this gpi is incorrect as the viewing transform is not
      //    the unity transform and no error is generated by the "call" -
      //    it is simply ignored (proof: a subsequent DrawSegment uses
      //    the currently established viewing transform later in this test)

                 // fxM11 is x axis scale amount
                 matlfInstance.fxM11 = HALF_FIXED;
                 matlfInstance.fxM12 = ZERO_FIXED;
                 // lM13 is required entry for a transform matrix
                 matlfInstance.lM13  = 0L;
                 matlfInstance.fxM21 = ZERO_FIXED;
                 // fxM22 is y axis scale amount
                 matlfInstance.fxM22 = ONE_FIXED;
                 // lM23 is required entry for a transform matrix
                 matlfInstance.lM23  = 0L;
                 // lM31 is the x axis translation amount
      matlfInstance.lM31 = SizeX( 100L );
                 // lM32 is the y axis translation amount
      matlfInstance.lM32 = SizeY( 500L );
                 // lM33 is required entry for a transfrom matrix
                 matlfInstance.lM33  = 1L;

      // use set_transform (GpiRotate to rotate box 90 degrees at [2,6]
      bSuccess = set_transform(hPS, hWndClient, &matlfInstance,
         /* no scaling */            ZERO_FIXED, ZERO_FIXED,
         /* rotate 90 about center*/ MAKEFIXED(270,0), 150L, 550L,
         /* no translation */        0L, 0L );
      if (bSuccess == FALSE) return;

                 lHits = GpiCallSegmentMatrix( hPS, 888L, 9L, &matlfInstance,
                                                                                                                                                         TRANSFORM_REPLACE );
      if( lHits == GPI_ERROR ) {
                        CLEANUP("GpiCallSegmentMatrix", pTestName7);
           return;
      }

      //    set a Segment Transform for the given segment to scale by two
                 //    and translate by [4,3].  this will affect only this segment

      // get the current segment transform
         bSuccess = GpiQuerySegmentTransformMatrix(hPS, 888L, 9L, &matlfSegment);
      if ( bSuccess == FALSE) {
        // handle unexpected error
        CLEANUP("GpiQuerySegmentTransformMatrix", pTestName7);
        return;
      }

      // set the scale to 2 and translate [0",3"]
      bSuccess = set_transform(hPS, hWndClient, &matlfSegment,
      /* scale factors */       TWO_FIXED,TWO_FIXED,
      /* rotation factors */    ZERO_FIXED, 0L, 0L,
      /* translation factors */ 0L, 300L );
      if (bSuccess == FALSE) return;

                 // set the segment transform
      bSuccess = GpiSetSegmentTransformMatrix( hPS, 888L, 9L, &matlfSegment,
                                                                                                                                 TRANSFORM_REPLACE );
      if (bSuccess == FALSE) {
        CLEANUP("GpiSetSegmentTransformMatrix", pTestName7);
           return;
         }

                 //  Draw the box (2 x 2 at [0,0], note that the transforms are applied
      //  in the order: view (scale 1/2), segment (scale 2, translate [4,3]),
      //  and model (scale 1/2, translate [2,2]) to produce a box  1" x 1"
      //  at [4", 3.5"]
      if (GpiDrawSegment(hPS, 888L) == FALSE) {
        CLEANUP("GpiDrawSegment", pTestName7);
        return;
      }
   }
// end fNormalPS *****************************************

    // restore the model transform to 1/2 [2,2]
    bSuccess =
       GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
           CLEANUP("GpiSetModelTransformMatrix", pTestName7);
           return;
         }

    // get the default view transform
         bSuccess = GpiQueryDefaultViewMatrix(hPS, 9L, &matlfView);
    if ( bSuccess == FALSE) {
      // handle unexpected error
      CLEANUP("GpiQueryDefaultViewMatrix", pTestName7);
      return;
    }

    // set the scale to 1/2 and translate [0",0"]
    bSuccess = set_transform(hPS, hWndClient, &matlfView,
    /* scale factors */       HALF_FIXED,HALF_FIXED,
    /* rotation factors */    ZERO_FIXED, 0L, 0L,
    /* translation factors */ 250L, 200L);
    if (bSuccess == FALSE) return;

         // set the default view matrix - will combine with current model
    // transform to determine box location and size
    bSuccess =
       GpiSetDefaultViewMatrix( hPS, 9L, &matlfView, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
           CLEANUP("GpiSetDefaultViewMatrix", pTestName7);
           return;
         }

    GpiMove(hPS, &ptlLLCorner);
    GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

    // set a page viewport 1.5" above bottom of device and draw box again

    // save original page viewport for restoration and printing later
    if (GpiQueryPageViewport(hPS, &save_viewport) == FALSE) {
      CLEANUP("GpiQueryPageViewport", pTestName7);
      return;
    }

    // x inches * (.0254 meters/inch) * units/meter = x in device units.
    // 1.5 time 0.0254 = 0.0381
    rectangle.xLeft = save_viewport.xLeft;
    rectangle.xRight = save_viewport.xRight;
    rectangle.yBottom = save_viewport.yBottom +
                        (LONG)((0.0381 * (double)vert_pels_per_m) + 0.5);
    rectangle.yTop = save_viewport.yTop +
                     (LONG)((0.0381 * (double)vert_pels_per_m) + 0.5);

    if (GpiSetPageViewport(hPS, &rectangle) == FALSE) {
      CLEANUP("GpiSetPageViewport", pTestName7);
      return;
    }

    // draw the box again, should be 1.5" higher
    GpiMove(hPS, &ptlLLCorner);
    GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

    // reset transforms and page viewport

    if (GpiSetPageViewport(hPS, &save_viewport) == FALSE) {
      CLEANUP("GpiSetPageViewport", pTestName7);
      return;
    }

    // establish unity matrix for the Viewing transform
    bSuccess =
       GpiSetDefaultViewMatrix( hPS, 0L, &matlfView, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
           CLEANUP("GpiSetDefaultViewMatrix", pTestName7);
           return;
         }

    // establish unity matrix for the model transform
    bSuccess =
       GpiSetModelTransformMatrix( hPS, 0L, &matlfModel, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
           CLEANUP("GpiSetModelTransformMatrix", pTestName7);
           return;
         }

    // test over now tell user what happened.  Must do here as "WriteString"
    // deletes segments and resets viewing transform to unity.
    MapAndWriteString(305L, 260L, "-->Box #1:GpiSetModelTransformMatrix");
    MapAndWriteString(305L, 230L, "     (scale:1/2, translate:[2,2])");

    if (fNormalPS) {
      MapAndWriteString(155L, 120L,
                       "-->Box #2:GpiSetViewingTransformMatrix (scale 1/2)");

      MapAndWriteString(305L, 560L,
                         "-->Box #3:GpiCallSegmentMatrix (scale x:1/2, y:1,");
      MapAndWriteString(305L, 530L,
                               "   translate:[1,5], rotate:270 @ [1.5,5.5])");

      MapAndWriteString(305L, 410L, "-->Box #4:GpiSetSegmentTransformMatrix");
      MapAndWriteString(305L, 380L, "    (scale:2, translate:[0,3])");

      MapAndWriteString(050L, 170L,
               "Boxes 2, 3, & 4 use same segment, 2 & 4 via GpiDrawSegment");
    }

    MapAndWriteString(405L, 330L, "-->Box #5:GpiSetDefaultViewMatrix");
    MapAndWriteString(405L, 310L, "   (scale:1/2, translate:[2.5,2])");

    MapAndWriteString(405L, 480L, "-->Box #6:GpiSetPageViewport");
    MapAndWriteString(405L, 460L, "   (1.5\" up from bottom of device)");

    EXIT_MAIN(pTestName7);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiModelTransformCommon
 *
 * Purpose: Common code part of Model Transform precision and exhautive
 *               testing
 *
 * System Requirements:  Section
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS           - presentation space.
 *        hWndClient    - client window handle
 *        pTestName     - test case entry point name "...Exh" or "...Pre"
 *
 * Outputs:
 *           four boxes on a one inch grid
 *           box1: one inch square at [1",1"]
 *           box2: two inch square at [4",4"]
 *           box3: one inch square at [2",2"]
 *           box4: one inch square at [3",3"]
 *           All boxes are outlined and filled with diagonal line pattern
 *
 * Subroutines Required: ENTER_MAIN, EXIT_MAIN, gpi_grid, CLEANUP,
 *   GpiSetPattern, MapAndWriteString, GpiMove, GpiBox, MapX, MapY,
 *   SizeX, SizeY, GpiSetModelTransformMatrix, GpiQueryModelTransformMatrix
 *
 * Subroutines tested:
 *                   GpiSetModelTransformMatrix
 *                   GpiQueryModelTransformMatrix
 *
 * Limitations: none
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *     - draw a one inch grid
 *     - set default fill pattern to diagonal lines.
 *     - draw a one inch box at [1",1"] using GpiMove(1", 1") and
 *       GpiBox(OUTLINEFILL, 2", 2")
 *     - use GpiQueryModelTransformMatrix to initialize matrix structure
 *       to the unity matrix (default of current model transform)
 *     - set Model transform to scale by factor of two and translate
 *       [2", 2"] using the TRANSFORM_REPLACE option
 *     - Save this transform by calling GpiQueryModelTransform
 *     - draw the same box again, note it's at [4", 4"] and 2" inches square
 *     - concatenate a transform to existing transform to scale by a factor
 *       of one-half with no translation, using TRANSFORM_ADD
 *     - draw a 1" x 1" outlined box at [1",1"] and get 1" x 1" at [2", 2"]
 *     - re-set Model transform to scale by factor of two and translate
 *       [2", 2"] using the TRANSFORM_REPLACE option with save matrix
 *     - insert a transform to existing transform to scale by a factor
 *       of one-half with no translation, using TRANSFORM_PREEMPT
 *     - draw a 1" x 1" outlined box at [1",1"] and get 1" x 1" at [3", 3"]
 *
 *
 *\\end
 ***************************************************************************/

static VOID GpiModelTransformCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  POINTL        ptlURCorner, ptlLLCorner;
  MATRIXLF  matlfModel, matlfModelSaved;
  BOOL      bSuccess;

  ENTER_MAIN(pTestName);

  // call the grid function to draw 1" X 1" grid cells.
  gpi_grid(hPS, ONE_INCH);

  MapAndWriteString(110L, 570L, "Grid size is 1 inch");

  MapAndWriteString(110L, 610L,
     "All Boxes drawn via GpiMove(1\",1\"), GpiBox(OUTLINEFILL,2\",2\")");

  // set up fill pattern to cross hatched so printers don't work too hard!
 if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return;
  }

  ptlLLCorner.x=MapX(100L);
  ptlLLCorner.y=MapY(100L);
  ptlURCorner.x=MapX(200L);
  ptlURCorner.y=MapY(200L);

  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  MapAndWriteString(200L, 140L, "<--Box #1: NO TRANSFORM");

  // initialize matrix structure to unity matrix by using query on default
  bSuccess = GpiQueryModelTransformMatrix(hPS, 9L, &matlfModel);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQueryModelTransformMatrix", pTestName);
    return;
  }

  // setup a specific transform w/scale & offset using REPLACE
  // (set transform to scale by 1 and offset to [2,2] )

 // fxM11 is x axis scale amount
  matlfModel.fxM11 = TWO_FIXED;
  // fxM22 is y axis scale amount
  matlfModel.fxM22 = TWO_FIXED;
  // lM31 is the x axis translation amount
  matlfModel.lM31 = SizeX(200L);
 // lM32 is the y axis translation amount
  matlfModel.lM32 = SizeY(200L);

 // set the model transform, all primitives are effected by model
  // transforms when they are actually drawn
  bSuccess =
     GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetModelTransformMatrix", pTestName);
   return;
 }

  //  save the new transform for later restoration
  bSuccess = GpiQueryModelTransformMatrix(hPS, 9L, &matlfModelSaved);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQueryModelTransformMatrix", pTestName);
    return;
  }

  //  2) draw something (draw 2x2 box at [2,2], get 2x2 at [4,4])

  // Draw a 2" x 2" filled box at [2",2"] [4",4"].  This box
  // will actually appear as a 2" x 2" box [4",4"]
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  MapAndWriteString(600L, 540L, "<--Box #2:");
  MapAndWriteString(600L, 510L, "   TRANSFORM_REPLACE");
  MapAndWriteString(600L, 480L, "   scale: 2");
  MapAndWriteString(600L, 450L, "   translate: [2\",2\"]");

 // fxM11 is x axis scale amount
  matlfModel.fxM11 = HALF_FIXED;
  // fxM22 is y axis scale amount
  matlfModel.fxM22 = HALF_FIXED;
  // lM31 is the x axis translation amount
  matlfModel.lM31  = 0L;
 // lM32 is the y axis translation amount
  matlfModel.lM32  = 0L;

 // set the model transform, scale by 1/2 but concatenate on end of
  // current model transform
  bSuccess =
     GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_ADD );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetModelTransformMatrix", pTestName);
   return;
 }

  // draw the same thing again
  // (scale by 1/2: get 1x1 at [2,2])

  // Draw a 2" x 2" filled box at [2",2"] [4",4"].  This box
  // will actually appear as a 1" x 1" box [2",2"]
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  MapAndWriteString(300L, 240L, "<--Box #3:TRANSFORM_ADD w/scale 1/2");

  // reset transform to original values
  // (set transform to scale by 1 and offset to [2,2] )

  bSuccess =
     GpiSetModelTransformMatrix( hPS, 9L, &matlfModelSaved,
                                                        TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetModelTransformMatrix", pTestName);
   return;
 }

  // change transform to same as second above but use PREEMPT

  // set the model transform, scale by 1/2 but concatenate current
  // model transform on end of new one.
  bSuccess =
     GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_PREEMPT );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetModelTransformMatrix", pTestName);
   return;
 }

  // draw the same thing again (note scaling effect on orig.
  // translation amount). (scale by 1/2: get 1x1 at [3,3])

  // Draw a 2" x 2" filled box at [2",2"] [4",4"].  This box
  // will actually appear as a 1" x 1" box [3",3"]
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  MapAndWriteString(400L, 340L, "<--Box #4:TRANSFORM_PREEMPT w/scale 1/2");

  EXIT_MAIN(pTestName);

  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryModelXformMatExh()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Transform
 *                               exhaustive test to be run.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiModelTransformCommon
 *
 * Subroutines Required: WinSendMsg, GpiModelTransformCommon
 *
 * Subroutines tested: see GpiModelTransformCommon
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   call GpiModelTransformCommon with test name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryModelXformMatExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiModelTransformCommon(hPS, hWndClient, pTestName9);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryModelXformMatPre()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Transform
 *                               precision test to be run.
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiModelTransformCommon
 *
 * Subroutines Required: WinSendMsg, GpiModelTransformCommon
 *
 * Subroutines tested: see GpiModelTransformCommon
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryModelXformMatPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiModelTransformCommon(hPS, hWndClient, pTestName2);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSegmentTransformCommon
 *
 * Purpose: common code for testing GpiCallSegmentMatrix precision and
 *               exhaustive tests.
 *
 * System Requirements:  Section
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        pTestName     - test entry point name "...Exh" or "...Pre"
 *
 * Outputs:
 *           four boxes on a one inch grid
 *           box1: one inch square at [1",1"]
 *           box2: two inch square at [4",4"]
 *           box3: one inch square at [2",2"]
 *           box4: one inch square at [3",3"]
 *           All boxes are outlined and filled with diagonal line pattern
 *
 * Subroutines Required: ENTER_MAIN, EXIT_MAIN, gpi_grid, LOGINFO,
 *   MapAndWriteString, GpiSetDrawingMode, MapX, MapY, GpiOpenSegment,
 *   GpiMove, GpiBox, GpiCloseSegment, GpiSetPattern, GpiQueryPS,
 *   GpiSetSegmentTransformMatrix, GpiQuerySegmentTransformMatrix
 *
 * Subroutines tested:
 *                      GpiSetSegmentTransformMatrix
 *                      GpiQuerySegmentTransformMatrix
 *
 * Limitations: For proper execution PS_TYPE must == GPIT_NORMAL
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   - draw a one inch grid
 *   - set default fill pattern to diagonal lines.
 *   - setup: drawing mode = retained, fast_chained segments off.
 *   - create a segment to draw a 1" x 1" outlined box at [1",1"]
 *   - turn drawing mode back on
 *   - draw the box via GpiDrawSegment, get expected 1" box at [1",1"]
 *   - use GpiQuerySegmentTransformMatrix to fecth default value of
 *     untity transform from this segment
 *   - set Segment transform to scale by factor of two and translate
 *     [2", 2"] using the TRANSFORM_REPLACE option
 *   - use GpiDrawSegment to draw the box and get 2"x 2" at [4", 4"]
 *   - use GpiQuerySegmentTransformMatrix to save this matrix for later
 *     restoration
 *   - concatenate a transform to existing transform to scale by a factor
 *     of one-half with no translation, using TRANSFORM_ADD
 *   - use GpiDrawSegment to draw the box again and get 1"x 1" at [2", 2"]
 *   - re-set Segment transform to scale by factor of one and translate
 *     [2", 2"] using the TRANSFORM_REPLACE option from the saved matrix
 *   - insert a transform to existing transform to scale by a factor
 *     of one-half with no translation, using TRANSFORM_PREEMPT
 *   - use GpiDrawSegment to draw the box again and get 1"x 1" at [3", 3"]
 *
 *\\end
 ***************************************************************************/

static VOID GpiSegmentTransformCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  POINTL        ptlURCorner, ptlLLCorner;
  MATRIXLF  matlfSegment, matlfSaved;
  BOOL      bSuccess;
  ULONG     flOptions;
  SIZEL     sizlPS;

  ENTER_MAIN(pTestName);

  // query Presentation Space to insure a type of GPIT_NORMAL
  flOptions = GpiQueryPS(hPS, &sizlPS);
  if ( (flOptions & PS_TYPE) != GPIT_NORMAL) {
    MapAndWriteString(100L, 170L,
                       "To execute properly, PS_UNITS must be Normal!");
    LOGINFO(L_LOTRACE,"*",
                       "To execute properly, PS_UNITS must be Normal!");
    ErrorCount++;
    EXIT_MAIN(pTestName);
    return;
  }

  // call the grid function to draw 1" X 1" grid cells.
  gpi_grid(hPS,ONE_INCH);

  MapAndWriteString(110L, 570L, "Grid size is 1 inch");

  MapAndWriteString(110L, 610L,
     "All Boxes drawn via GpiMove(1\",1\"), GpiBox(OUTLINEFILL,2\",2\")");

  // Set drawing mode to retain.
  if (GpiSetDrawingMode(hPS, DM_RETAIN) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // turn of the fast chain attribute so the model transform isn't reset
  // each time the segment is drawn via GpiDrawSegment
  if (GpiSetInitialSegmentAttrs(hPS, ATTR_FASTCHAIN, ATTR_OFF) == FALSE) {
    CLEANUP("GpiSetInitialSegmentAttrs", pTestName);
    return;
  }

  ptlLLCorner.x=MapX(100L);
  ptlLLCorner.y=MapY(100L);
  ptlURCorner.x = MapX(200L);
  ptlURCorner.y = MapY(200L);

  if (GpiOpenSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiOpenSegment", pTestName);
    return;
  }

  // set up fill pattern to cross hatched so printers don't work too hard!
 if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return;
  }

  // Draw a 1" x 1" filled box at [1",1"] [2",2"].
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  //  Close the segment.
  if (GpiCloseSegment(hPS) == FALSE) {
    CLEANUP("GpiCloseSegment", pTestName);
    return;
  }

  // Set drawing mode to draw
  if (GpiSetDrawingMode(hPS, DM_DRAW) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // Draw the first box with no transform in place
  if (GpiDrawSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiDrawSegment", pTestName);
    return;
  }

  // initialize matrix structure to unity transform by calling query
  bSuccess = GpiQuerySegmentTransformMatrix(hPS, 1L, 9L, &matlfSegment);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQuerySegmentTransformMatrix", pTestName);
    return;
  }

  // set a transform to scale by 2 and offset to [2,2]
  // fxM11 is x axis scale amount
  matlfSegment.fxM11 = TWO_FIXED;
  // fxM22 is y axis scale amount
  matlfSegment.fxM22 = TWO_FIXED;
  // lM31 is the x axis translation amount
  matlfSegment.lM31 = SizeX(200L);
  // lM32 is the y axis translation amount
  matlfSegment.lM32 = SizeY(200L);

  // initialize transform for Box 2
  bSuccess = GpiSetSegmentTransformMatrix( hPS, 1L, 9L, &matlfSegment,
                                                       TRANSFORM_REPLACE );
  if (bSuccess == FALSE) {
    CLEANUP("GpiSetSegmentTransformMatrix", pTestName);
    return;
  }

  // save this matrix for later restoration
  bSuccess = GpiQuerySegmentTransformMatrix(hPS, 1L, 9L, &matlfSaved);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQuerySegmentTransformMatrix", pTestName);
    return;
  }

 //  Draw Box 2
  //  This box will actually appear as a 2" x 2" box [4",4"]
  if (GpiDrawSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiDrawSegment", pTestName);
    return;
  }

  // set a transform to scale by one half w/no offset

  // fxM11 is x axis scale amount
  matlfSegment.fxM11 = HALF_FIXED;
  // fxM22 is y axis scale amount;
  matlfSegment.fxM22 = HALF_FIXED;
  // lM31 is the x axis translation amount
  matlfSegment.lM31  = 0L;
  // lM32 is the y axis translation amount
  matlfSegment.lM32  = 0L;

  // Add 1/2 scale transform to segment for Box 3
  bSuccess =
     GpiSetSegmentTransformMatrix( hPS, 1L, 9L, &matlfSegment, TRANSFORM_ADD );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetSegmentTransformMatrix", pTestName);
   return;
 }

  // Draw Box 3
  // This box will actually appear as a 1" x 1" box [2",2"]
  if (GpiDrawSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiDrawSegment", pTestName);
    return;
  }

  // set a transform to scale by 2 and offset to [2,2]
  // initialize transform same as for Box 1
  bSuccess =
     GpiSetSegmentTransformMatrix( hPS, 1L, 9L, &matlfSaved, TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetSegmentTransformMatrix", pTestName);
   return;
 }

  // set a transform to scale by one half w/no offset
  // Preempt 1/2 scale transform to segment for Box 4
  bSuccess =
     GpiSetSegmentTransformMatrix( hPS, 1L, 9L, &matlfSegment, TRANSFORM_PREEMPT );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetSegmentTransformMatrix", pTestName);
   return;
 }

  // Draw Box 4
  // This box will actually appear as a 1" x 1" box [3",3"]
  if (GpiDrawSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiDrawSegment", pTestName);
    return;
  }

  // all text after drawing as write string functions delete segments
  MapAndWriteString(200L, 140L, "<--Box #1: NO TRANSFORM");

  MapAndWriteString(600L, 540L, "<--Box #2:");
  MapAndWriteString(600L, 510L, "   TRANSFORM_REPLACE");
  MapAndWriteString(600L, 480L, "   scale: 2");
  MapAndWriteString(600L, 450L, "   translate: [2\",2\"]");

  MapAndWriteString(300L, 240L, "<--Box #3:TRANSFORM_ADD w/scale 1/2");

  MapAndWriteString(400L, 340L, "<--Box #4:TRANSFORM_PREEMPT w/scale 1/2");

  EXIT_MAIN(pTestName);
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQrySegmentXformMatPre()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Segment
 *           Transform precision test to run
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiSegmentTransformCommon
 *

 * Subroutines Required: WinSendMsg, GpiSegmentTransformCommon
 *
 *
 * Subroutines tested: GpiSetSegmentTransformMatrix
 *                     GPiQuerySegmentTransformMatrix
 *
 * Limitations:  Requires GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   call the common segment matrix function with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQrySegmentXformMatPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiSegmentTransformCommon(hPS, hWndClient, pTestName3);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQrySegmentXformMatExh()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi Segment
 *           Transform exhaustive test to run
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiSegmentTransformCommon
 *

 * Subroutines Required: WinSendMsg, GpiSegmentTransformCommon
 *
 *
 * Subroutines tested: GpiSetSegmentTransformMatrix
 *                     GPiQuerySegmentTransformMatrix
 *
 * Limitations:  Requires GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   call the common segment matrix function with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQrySegmentXformMatExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiSegmentTransformCommon(hPS, hWndClient, pTestName10);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiCallSegmentCommon
 *
 * Purpose: common function for both GpiCallSegmentMatrixPre and
 *               GpiCallSegmentMatrixExh
 *
 *
 * System Requirements:  Section
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        pTestName      - name of which test is running
 *
 * Outputs:
 *           four boxes on a one inch grid
 *           box1: one inch square at [1",1"]
 *           box2: two inch square at [4",4"]
 *           box3: one inch square at [2",2"]
 *           box4: one inch square at [3",3"]
 *           All boxes are outlined and filled with diagonal line pattern
 *
 * Subroutines Required: ENTER_MAIN, LOGINFO, EXIT_MAIN, MapAndWriteString,
 *   GpiQueryPS, gpi_grid, GpiSetDrawingMode, GpiSetInitialSegmentAttrs,
 *   GpiSetPattern, GpiOpenSegment, GpiCloseSegment, GpiMove, GpiBox,
 *   GpiCallSegmentMatrix, CLEANUP
 *
 * Subroutines tested:   GpiCallSegmentMatrix
 *
 * Limitations: Requires GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *  - draw a one inch grid
 *  - set default fill pattern to diagonal lines.
 *  - setup: drawing mode = retained, turn off chained attribute to
 *         enable use of "called" segments.
 *  - create a segment to draw a 1" x 1" outlined box at [1",1"]
 *  - turn drawing mode back on
 *  - set Instance transform matrix to unity matrix
 *  - draw segment via GpiCallSegmentMatrix, 1" box at [1",1"]
 *  - set Instance transform to scale by factor of two and translate
 *    [2", 2"] using the TRANSFORM_REPLACE option
 *  - use GpiCallSegment to draw the box and get 2"x 2" at [4", 4"]
 *  - concatenate a transform to existing transform to scale by a factor
 *    of one-half with no translation, using TRANSFORM_ADD
 *  - use GpiCallSegment to draw the box again and get 1"x 1" at [2", 2"]
 *  - re-set Segment transform to scale by factor of one and translate
 *    [2", 2"] using the TRANSFORM_REPLACE option
 *  - insert a transform to existing transform to scale by a factor
 *    of one-half with no translation, using TRANSFORM_PREEMPT
 *  - use GpiCallSegment to draw the box again and get 1"x 1" at [3", 3"]
 *
 *\\end
 ***************************************************************************/

static VOID GpiCallSegmentCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  POINTL        ptlUpper_Right, ptlLower_Left;
  MATRIXLF  matlfSegment;
  LONG      lHits;
  BOOL      bSuccess;
  ULONG     flOptions;
  SIZEL     sizlPS;

  ENTER_MAIN(pTestName);

  // query Presentation Space to insure a type of GPIT_NORMAL
  flOptions = GpiQueryPS(hPS, &sizlPS);
  if ( (flOptions & PS_TYPE) != GPIT_NORMAL) {
    MapAndWriteString(100L, 170L,
                       "To execute properly, PS_UNITS must be Normal!");
    LOGINFO(L_LOTRACE,"*",
                       "To execute properly, PS_UNITS must be Normal!");
    ErrorCount++;
    EXIT_MAIN(pTestName);
    return;
  }

  // call the grid function to draw 1" X 1" grid cells.
  gpi_grid( hPS, ONE_INCH );

  MapAndWriteString(110L, 570L, "Grid size is 1 inch");

  MapAndWriteString(110L, 610L,
     "All Boxes drawn via GpiMove(1\",1\"), GpiBox(OUTLINEFILL,2\",2\")");

  // Set drawing mode to retain.
  if (GpiSetDrawingMode(hPS, DM_RETAIN) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // Turn off the chained attribute as we are about to create a segment
  // that is to be "called" via GpiCallSegmentMatrix.
  if (GpiSetInitialSegmentAttrs(hPS, ATTR_CHAINED, ATTR_OFF) == FALSE) {
    CLEANUP("GpiSetInitialSegmentAttrs", pTestName);
    return;
  }

  // set up fill pattern to cross hatched so printers don't work too hard!
 if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return;
  }

  // 1" x 1" at [1",1"] [2",2"]
  ptlLower_Left.x=MapX(100L);
  ptlLower_Left.y=MapY(100L);
  ptlUpper_Right.x=MapX(200l);
  ptlUpper_Right.y=MapY(200L);

  if (GpiOpenSegment(hPS, 1L) == FALSE) {
    CLEANUP("GpiOpenSegment", pTestName);
    return;
  }

  // Draw a 1" x 1" filled box at [1",1"] [2",2"].
  GpiMove(hPS, &ptlLower_Left);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlUpper_Right, 0L, 0L);

  //  Close the segment.
  if (GpiCloseSegment(hPS) == FALSE) {
    CLEANUP("GpiCloseSegment", pTestName);
    return;
  }

  // Set drawing mode to draw
  if (GpiSetDrawingMode(hPS, DM_DRAW) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // setup unity transform for segment
 // fxM11 is x axis scale amount
  matlfSegment.fxM11 = ONE_FIXED;
  matlfSegment.fxM12 = ZERO_FIXED;
 // lM13 is required entry for a transform matrix
  matlfSegment.lM13  = 0L;
  matlfSegment.fxM21 = ZERO_FIXED;
  // fxM22 is y axis scale amount
  matlfSegment.fxM22 = ONE_FIXED;
 // lM23 is required entry for a transform matrix
  matlfSegment.lM23  = 0L;
  // lM31 is the x axis translation amount
  matlfSegment.lM31  = 0L;
 // lM32 is the y axis translation amount
  matlfSegment.lM32  = 0L;
 // lM33 is required entry for a transfrom matrix
  matlfSegment.lM33  = 1L;

 //  Draw Box 1
  //  This box will actually appear as a 1" x 1" box [1",1"]
 lHits = GpiCallSegmentMatrix( hPS, 1L, 9L, &matlfSegment,
                                                                                                                                         TRANSFORM_REPLACE );
  if( lHits == GPI_ERROR ) {
        CLEANUP("GpiCallSegmentMatrix", pTestName);
           return;
  }

  // set a transform to scale by 1 and offset to [2,2]

 // fxM11 is x axis scale amount
  matlfSegment.fxM11 = TWO_FIXED;
  matlfSegment.fxM22 = TWO_FIXED;
  // lM31 is the x axis translation amount
  matlfSegment.lM31  = SizeX(200L);
 // lM32 is the y axis translation amount
  matlfSegment.lM32  = SizeY(200L);

 //  Draw Box 2
  //  This box will actually appear as a 2" x 2" box [4",4"]
 lHits = GpiCallSegmentMatrix( hPS, 1L, 9L, &matlfSegment,
                                                                                                                                         TRANSFORM_REPLACE );
  if( lHits == GPI_ERROR ) {
    CLEANUP("GpiCallSegmentMatrix", pTestName);
    return;
  }

  // set model transform to value used in replace on call segment
  bSuccess =
     GpiSetModelTransformMatrix( hPS, 9L, &matlfSegment, TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetModelTransformMatrix", pTestName);
   return;
 }

  // set a transform to scale by one half w/no offset

 // fxM11 is x axis scale amount
  matlfSegment.fxM11 = HALF_FIXED;
  // fxM22 is y axis scale amount
  matlfSegment.fxM22 = HALF_FIXED;
  // lM31 is the x axis translation amount
  matlfSegment.lM31  = 0L;
 // lM32 is the y axis translation amount
  matlfSegment.lM32  = 0L;

  // Draw Box 3
  // This box will actually appear as a 1" x 1" box [2",2"]
 lHits = GpiCallSegmentMatrix( hPS, 1L, 9L, &matlfSegment,
                                                                                                                                         TRANSFORM_ADD );
  if( lHits == GPI_ERROR ) {
   CLEANUP("GpiCallSegmentMatrix", pTestName);
   return;
  }

  // Draw Box 4
  // This box will actually appear as a 1" x 1" box [3",3"]
 lHits = GpiCallSegmentMatrix( hPS, 1L, 9L, &matlfSegment,
                                                                                                                                         TRANSFORM_PREEMPT );
  if( lHits == GPI_ERROR ) {
    CLEANUP("GpiCallSegmentMatrix", pTestName);
    return;
  }

  MapAndWriteString(200L, 140L, "<--Box #1: NO TRANSFORM");

  MapAndWriteString(600L, 540L, "<--Box #2:");
  MapAndWriteString(600L, 510L, "   TRANSFORM_REPLACE");
  MapAndWriteString(600L, 480L, "   scale: 2");
  MapAndWriteString(600L, 450L, "   translate: [2\",2\"]");

  MapAndWriteString(300L, 240L, "<--Box #3:TRANSFORM_ADD w/scale 1/2");

  MapAndWriteString(400L, 340L, "<--Box #4:TRANSFORM_PREEMPT w/scale 1/2");

  EXIT_MAIN(pTestName);
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiCallSegmentMatrixPre()
 *
 * Purpose:  This is an entry point for the PTT that causes
 *                               GpiCallSegmentMatrix function precision testing
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiCallSegmentCommon
 *
 * Subroutines Required: WinSendMsg, GpiCallSegmentCommon
 *
 *
 * Subroutines tested: GpiCallSegmentMatrix
 *
 * Limitations: GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    call GpiCallSegmentCommon function with test name
 *
 *\\end

 ***************************************************************************/

VOID APIENTRY GpiCallSegmentMatrixPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiCallSegmentCommon(hPS, hWndClient, pTestName4);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiCallSegmentMatrixExh()
 *
 * Purpose:  This is an entry point for the PTT that causes
 *                               GpiCallSegmentMatrix function exhaustive testing
 *
 *
 * System Requirements:  Section 6.3.2
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiCallSegmentCommon
 *
 * Subroutines Required: WinSendMsg, GpiCallSegmentCommon
 *
 *
 * Subroutines tested: GpiCallSegmentMatrix
 *
 * Limitations: GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    call GpiCallSegmentCommon function with test name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiCallSegmentMatrixExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiCallSegmentCommon(hPS, hWndClient, pTestName11);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDefaultViewCommon
 *
 * Purpose: common part of GpiSetDefaultViewMatrix/GpiQueryDefaultViewMatirx
 *          exhaustive and precision testing
 *
 * System Requirements:  Section
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        pTestName     - name of function running
 *
 * Outputs:
 *           four boxes on a one inch grid
 *           box1: one inch square at [1",1"]
 *           box2: two inch square at [4",4"]
 *           box3: one inch square at [2",2"]
 *           box4: one inch square at [3",3"]
 *           All boxes are outlined and filled with diagonal line pattern
 *
 * Subroutines Required: ENTER_MAIN, EXIT_MAIN, gpi_grid, MapAndWriteString,
 *   GpiSetPattern, GpiMove, GpiBox, GpiSetDefaultViewMatrix,
 *   GpiQueryDefaultMatrix, CLEANUP
 *
 * Subroutines tested: GpiSetDefaultViewMatrix
 *                     GpiQueryDefaultViewMatrix
 *
 * Limitations: N/A
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    - draw a one inch grid
 *    - set default fill pattern to diagonal lines.
 *    - draw a 1" by 1" box at [1",1"]
 *    - set Default View Matrix to scale by factor of two and translate
 *      [2", 2"] using the TRANSFORM_REPLACE option
 *    - draw a 1" x 1" outlined box at [1",1"] and get 2" x 2" at [4", 4"]
 *    - concatenate to existing Default View Matrix to scale by a factor
 *      of one-half with no translation, using TRANSFORM_ADD
 *    - draw a 1" x 1" outlined box at [1",1"] and get 1" x 1" at [2", 2"]
 *    - set Default View Matrix to scale by factor of two and translate
 *      [2", 2"] using the TRANSFORM_REPLACE option
 *    - insert a transform to existing Matrix to scale by a factor
 *      of one-half with no translation, using TRANSFORM_PREEMPT
 *    - draw a 1" x 1" outlined box at [1",1"] and get 1" x 1" at [3", 3"]
 *
 *\\end
 ***************************************************************************/

static VOID GpiDefaultViewCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  POINTL        ptlURCorner, ptlLLCorner;
  MATRIXLF  matlfDefView, matlfSaved;
  BOOL      bSuccess;

  ENTER_MAIN(pTestName);

  // call the grid function to draw 1" X 1" grid cells.
  gpi_grid(hPS,ONE_INCH);

  MapAndWriteString(110L, 570L, "Grid size is 1 inch");

  MapAndWriteString(110L, 610L,
     "All Boxes drawn via GpiMove(1\",1\"), GpiBox(OUTLINEFILL,2\",2\")");

  // set up fill pattern to cross hatched so printers don't work too hard!
 if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return;
  }

  // 1" x 1" at [1",1"] [2",2"]
  ptlLLCorner.x=MapX(100L);
  ptlLLCorner.y=MapY(100L);
  ptlURCorner.x=MapX(200L);
  ptlURCorner.y=MapY(200L);

  // Draw box 1 with no transform
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  // initialize matrix structure to unity transform by calling query
  bSuccess = GpiQueryDefaultViewMatrix(hPS, 9L, &matlfDefView);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQueryDefaultViewMatrix", pTestName);
    return;
  }

  // set a transform to scale by 2 and offset to [2,2]

 // fxM11 is x axis scale amount
  matlfDefView.fxM11 = TWO_FIXED;
  matlfDefView.fxM22 = TWO_FIXED;
  // lM31 is the x axis translation amount
  matlfDefView.lM31 = SizeX(200L);
 // lM32 is the y axis translation amount
  matlfDefView.lM32 = SizeY(200L);

  // initialize transform for Box 2
  bSuccess =
     GpiSetDefaultViewMatrix( hPS, 9L, &matlfDefView, TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetDefaultViewMatrix", pTestName);
   return;
 }

  // save this matrix for later restoration
  bSuccess = GpiQueryDefaultViewMatrix(hPS, 9L, &matlfSaved);
  if (bSuccess == FALSE) {
    CLEANUP("GpiQueryDefaultViewMatrix", pTestName);
    return;
  }

  // 2" x 2" at [4",4"] [6",6"]
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  // set a transform to scale by one half w/no offset

 // fxM11 is x axis scale amount
  matlfDefView.fxM11 = HALF_FIXED;
  // fxM22 is y axis scale amount
  matlfDefView.fxM22 = HALF_FIXED;
  // lM31 is the x axis translation amount
  matlfDefView.lM31  = 0L;
 // lM32 is the y axis translation amount
  matlfDefView.lM32  = 0L;

  // Add 1/2 scale transform to view for Box 3
  bSuccess =
     GpiSetDefaultViewMatrix( hPS, 9L, &matlfDefView, TRANSFORM_ADD );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetDefaultViewMatrix", pTestName);
   return;
 }

  // Draw box 3
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  // initialize transform same as for Box 1
  // set a transform to scale by 2 and offset to [2,2]
  bSuccess =
     GpiSetDefaultViewMatrix( hPS, 9L, &matlfSaved, TRANSFORM_REPLACE );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetDefaultViewMatrix", pTestName);
   return;
 }

  // Preempt 1/2 scale transform to segment for Box 4
  bSuccess =
     GpiSetDefaultViewMatrix( hPS, 9L, &matlfDefView, TRANSFORM_PREEMPT );
 if (bSuccess == FALSE) {
   CLEANUP("GpiSetDefaultViewMatrix", pTestName);
   return;
 }

  // Draw box 4
  GpiMove(hPS, &ptlLLCorner);
  GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

  MapAndWriteString(200L, 140L, "<--Box #1: NO TRANSFORM");

  MapAndWriteString(600L, 540L, "<--Box #2:");
  MapAndWriteString(600L, 510L, "   TRANSFORM_REPLACE");
  MapAndWriteString(600L, 480L, "   scale: 2");
  MapAndWriteString(600L, 450L, "   translate: [2\",2\"]");

  MapAndWriteString(300L, 240L, "<--Box #3:TRANSFORM_ADD w/scale 1/2");

  MapAndWriteString(400L, 340L, "<--Box #4:TRANSFORM_PREEMPT w/scale 1/2");

  EXIT_MAIN(pTestName);
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryDefViewMatrixPre
 *
 * Purpose:  This is an entry point for the PTT that causes Gpis
 *                               GpiSetDefaultViewMatrix and GpiQueryDefaultViewMatrix
 *           precision tests to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiDefaultViewCommon
 *
 * Subroutines Required: WinSendMsg, GpiDefaultViewCommon
 *
 *
 * Subroutines tested: GpiSetDefaultViewMatrix
 *                     GpiQueryDefaultViewMatrix
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   call GpiDefaultViewCommon with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryDefViewMatrixPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiDefaultViewCommon(hPS, hWndClient, pTestName5);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryDefViewMatrixExh
 *
 * Purpose:  This is an entry point for the PTT that causes Gpis
 *                               GpiSetDefaultViewMatrix and GpiQueryDefaultViewMatrix
 *           exhaustive tests to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiDefaultViewCommon
 *
 * Subroutines Required: WinSendMsg, GpiDefaultViewCommon
 *
 *
 * Subroutines tested: GpiSetDefaultViewMatrix
 *                     GpiQueryDefaultViewMatrix
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   call GpiDefaultViewCommon with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryDefViewMatrixExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiDefaultViewCommon(hPS, hWndClient, pTestName12);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiViewingTransformCommon
 *
 * Purpose: common part of GpiSetViewingTransformMatrix and GpiQueryViewing-
 *          TransfromMatrix precision and exhautive testing
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        pTestName      - name of test running
 *
 * Outputs:
 *        One inch grid
 *        Six outlined and diagonal line pattern filled one inch square boxes
 *         w/lower left corners at [1", 3"], [2", 2"], [3", 3"], [4", 2"],
 *         [5", 3"], and [6", 2"] respectively.
 *
 * Subroutines Required: ENTER_MAIN, EXIT_MAIN, gpi_grid, MapAndWriteString,
 *  GpiQueryPS, CLEANUP, set_transform, LOGINFO, GpiSetPattern,
 *  GpiQueryModelTransformMatrix, GpiSetModelTransformMatrix,
 *  GpiSetViewingTransformMatrix, GpiQueryViewingTransformMatrix,
 *  GpiSetDrawingMode, GpiMove, GpiBox, GpiOpenSegment, GpiCloseSegment,
 *  GpiDrawSegment
 *
 * Subroutines tested: GpiSetViewingTransformMatrix
 *                     GpiQueryViewingTransformMatrix
 *
 * Limitations: GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    - draw grid of one inch squares
 *    - set default fill pattern to diagonal lines, set drawing mode to
 *      RETAINED
 *    - query the Viewing Transform Matrix to initialize the matrix structure
 *      to the unity matrix
 *    - change the scale values (both x and y) to scale by one-half
 *    - set the viewing transform matrix to this value
 *    - in a for loop create six segments that draw a two inch box with
 *      lower left corner at [0",0"].  Before each segment is created,
 *      set a viewing transform by querying the existing one and setting
 *      a new one from that value by changing the translation amount to
 *      increase by one inch in the x direction and to alternate between
 *      two inches and three inches in the y direction.
 *    - turn drawing mode back on
 *    - set a completely outlandish viewing transform (to further prove that
 *      only subsequently opened segments are effected by a viewing transform)
 *    - draw each of the segments in a for loop.  Should get outlined boxes
 *      filled with diagonal line pattern, one inch square with lower left
 *      corners at [1",3"], [2",2"], [3",3"], [4",2"], [5",3"], and [6",2"].
 *
 *\\end
 ***************************************************************************/

static VOID GpiViewingTransformCommon(HPS hPS, HWND hWndClient, PCHAR pTestName)
{
  POINTL        ptlURCorner, ptlLLCorner;
  MATRIXLF  matlfView;
  BOOL      bSuccess;
  ULONG     flOptions;
  SIZEL     sizlPS;
  LONG      lSegId;

  ENTER_MAIN(pTestName);

  // query Presentation Space to insure a type of GPIT_NORMAL
  flOptions = GpiQueryPS(hPS, &sizlPS);
  if ( (flOptions & PS_TYPE) != GPIT_NORMAL) {
    MapAndWriteString(100L, 170L,
                       "To execute properly, PS_UNITS must be Normal!");
    LOGINFO(L_LOTRACE,"*",
                       "To execute properly, PS_UNITS must be Normal!");
    ErrorCount++;
    EXIT_MAIN(pTestName);
    return;
  }

  // call the grid function to draw 1" X 1" grid cells.
  gpi_grid(hPS,ONE_INCH);

  MapAndWriteString(010L, 560L,
   "1) Grid is 1 inch squares; GpiSetPattern to diagonal lines");

  // set global test name pointer for set_transform
  pCurTestName = pTestName;

  ptlLLCorner.x = 0L;
  ptlLLCorner.y = 0L;
  ptlURCorner.x=MapX(200L);
  ptlURCorner.y=MapY(200L);

  // set up fill pattern to cross hatched so printers don't work too hard!
 if (GpiSetPattern(hPS, PATSYM_DIAG1) == FALSE) {
    CLEANUP("GpiSetPattern", pTestName);
    return;
  }

  // Set drawing mode to retain.
  if (GpiSetDrawingMode(hPS, DM_RETAIN) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // initialize matrix structure by querying the default (unity) matrix
  bSuccess = GpiQueryViewingTransformMatrix(hPS, 9L, &matlfView);
  if (bSuccess == FALSE) {
    // handle error
    CLEANUP("GpiQueryViewingTransformMatrix", pTestName);
    return;
  }

  // always scale by one half
  matlfView.fxM11 = HALF_FIXED;
  matlfView.fxM22 = HALF_FIXED;

  // set the viewing transform
  bSuccess =
     GpiSetViewingTransformMatrix( hPS, 9L, &matlfView, TRANSFORM_REPLACE );
  if (bSuccess == FALSE) {
    CLEANUP("GpiSetViewingTransformMatrix", pTestName);
    return;
  } /* if */

  // create a viewing transform for each of six segments that draw
  // a two inch box outline-filled at [0,0] [2,2]
  for (lSegId = 1; lSegId < 7; lSegId++) {

    // query the current viewing transform
    bSuccess = GpiQueryViewingTransformMatrix(hPS, 9L, &matlfView);
    if (bSuccess == FALSE) {
      // handle error
      CLEANUP("GpiQueryViewingTransformMatrix", pTestName);
      return;
    }
    // set the x direction translation amount
    // cross screen drawing each box at 1", 2", ... in x direction
    matlfView.lM31 = SizeX( lSegId * 100L );
    // set the y direction translation amount
    // atlternate boxes at 2" and 3" for y translation amount
    matlfView.lM32 = SizeY( 200L + (lSegId % 2) * 100L );

    // set the viewing transform
    bSuccess =
       GpiSetViewingTransformMatrix( hPS, 9L, &matlfView, TRANSFORM_REPLACE );
    if (bSuccess == FALSE) {
      CLEANUP("GpiSetViewingTransformMatrix", pTestName);
      return;
    } /* if */

    // Create segment with 2" x 2" filled box at [0",0"] [2",2"].  This box
    // will actually appear as a 1" x 1" box at various x, y's because of
    // the viewing transform in effect when the segment is created.
    if (GpiOpenSegment(hPS, lSegId) == FALSE) {
      CLEANUP("GpiOpenSegment", pTestName);
      return;
    }

    GpiMove(hPS, &ptlLLCorner);
    GpiBox(hPS, DRO_OUTLINEFILL, &ptlURCorner, 0L, 0L);

    //  Close the segment.
    if (GpiCloseSegment(hPS) == FALSE) {
      CLEANUP("GpiCloseSegment", pTestName);
      return;
    } /* if */
  } /* for */

  // Set drawing mode to draw
  if (GpiSetDrawingMode(hPS, DM_DRAW) == FALSE) {
    CLEANUP("GpiSetDrawingMode", pTestName);
    return;
  }

  // set another viewing transform to show it has no effect on
  // the already defined segment when it is drawn.  Use values that
  // generate an obvious effect on the output   (scale by 255, translate
  // by [10", -25"])

  bSuccess = set_transform(hPS, hWndClient, &matlfView,
  /* scale factors */       (FIXED)0x00FF0000, (FIXED)0x00FF0000,
  /* rotation factors */    ZERO_FIXED, 0L, 0L,
  /* translation factors */ 1000L, -2500L);

  if (bSuccess == FALSE) {
    // error logging has already been done - end the test setup FAIL
    return;
  }

  // set the viewing transform
   bSuccess =
      GpiSetViewingTransformMatrix( hPS, 9L, &matlfView, TRANSFORM_REPLACE );
  if (bSuccess == FALSE) {
    CLEANUP("GpiSetViewingTransformMatrix", pTestName);
    return;
  }

  for (lSegId = 1; lSegId < 7; lSegId++) {
    if (GpiDrawSegment(hPS, lSegId) == FALSE) {
      CLEANUP("GpiDrawSegment", pTestName);
      return;
    } /* if */
  } /* for */

  // must put output here as MapAndWriteString will delete any segments

  MapAndWriteString(010L, 510L,
  "2) GpiSetViewingTransformMatrix to scale 1/2; For N = 1 to 6 do #3 & #4");

  MapAndWriteString(010L, 460L,
  "3) Set viewing matrix to previous but translate x: N\", y: 2+(N modulo 2)\"");

  MapAndWriteString(010L, 410L,
  "4) Create Segment N: GpiMove(0\",0\"), GpiDrawBox(OUTLINEFILL,2\",2\")");

  MapAndWriteString(010L, 160L,
  "5) GpiSetViewingTransformMatrix: scale 255, translate [10\",-25\"]");

  MapAndWriteString(010L, 110L,
  "6) Draw segments: 1\" boxes @ [1\",3\"] [2\",2\"] [3\",3\"] [4\",2\"] [5\",3\"] [6\",2\"]");

  EXIT_MAIN(pTestName);
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryViewingXformMatPre()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpis
 *                               GpiSetViewingTransformMatrix & GpiQueryViewingTransformMatrix
 *           precision tests to be run.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiViewingTransformCommaon
 *
 * Subroutines Required: WinSendMsg, GpiViewingTransformCommon
 *
 *
 * Subroutines tested: GpiSetViewingTransformMatrix
 *                     GpiQueryViewingTransformMatrix
 *
 * Limitations: GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *  call GpiViewingTransformCommon with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryViewingXformMatPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiViewingTransformCommon(hPS, hWndClient, pTestName6);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryViewingXformMatExh()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpis
 *                               GpiSetViewingTransformMatrix & GpiQueryViewingTransformMatrix
 *           exhaustive tests to be run.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: see GpiViewingTransformCommon
 *
 * Subroutines Required: WinSendMsg, GpiViewingTransformCommon
 *
 *
 * Subroutines tested: GpiSetViewingTransformMatrix
 *                     GpiQueryViewingTransformMatrix
 *
 * Limitations: GPIT_NORMAL PS_TYPE
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *  call GpiViewingTransformCommon with function name
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetAndQryViewingXformMatExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiViewingTransformCommon(hPS, hWndClient, pTestName13);
  }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: report()
 *
 * Purpose:  support funtion for GpiConverExh to log mistmatches in
 *           expected vs. received value from conversion
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/21/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hWndClient    -client window handle
 *        expected      -value expected from GpiConvert
 *        received      -actual value generated by GpiConvert
 *
 * Outputs: logs message about GpiConvert mismatch between expected and
 *          received value
 *
 * Subroutines Required:  sprintf and ERRSTATUS
 *
 * Subroutines tested:  N/A
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    build buffer
 *    call ERRSTATUS to log message with "FAIL" indicater
 *
 *\\end
 ***************************************************************************/

static VOID report(HWND hWndClient, LONG expected, LONG received)
{
  CHAR buffer[100];

  ErrorCount++;
  sprintf(buffer,"expected: %ld and received: %ld\n",
                                                       expected, received);
  ERRSTATUS(TRUE, "GpiConvert", buffer);
}

#define REPORT(a) report( hWndClient, expected, ptlTests[i].a )

/****************************************************************************
 *\\ddd
 * Routine Name: GpiConvertExh
 *
 * Purpose:  exhautively test the GpiConvert function
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/10/91, PDVT, Thom Bain
 *               -Testcase design and implementation
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs: appropriate log entries for the test. This test has no device
 *          outputs.
 *
 * Subroutines Required: ENTER_MAIN, EXIT_MAIN, MapAndWriteString, LOGINFO
 *   GpiQueryDevice, GpiSetModelTransformMatrix, GpiSetDefaultViewMatrix,
 *   GpiQueryPageViewport, GpiSetPageViewport, REPORT, GpiConvert,
 *   GpiQueryPS, SUBENTER, SUBEXIT, SHOWERROR
 *
 *
 * Subroutines tested: GpiConvert
 *
 * Limitations:
 *  NOTE: Originally the device transform was set to scale by 2
 *  but the display driver returned PMERR_COORDINATE_OVERFLOW
 *  (probably rightfully so) but the system was unstable after-
 *  ward (probably a PTT bug) so I changed the code to this JTB 03/19/91
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *    - Establish a model transform to scale by one-half and translate
 *      by 100 units (we don't care what type for this test).
 *    - Establish a "Default" view matrix to scale by a factor of two.
 *    - Establish a device transform to scale by factor of one and to
 *      translate 100 units (set page viewport to same size as page
 *      space plus 100).  (The configuration is unimportant!)
 *    - Create an array of points evenly distributed about the page.
 *    - Convert these points from World space to Model space.
 *    - Test these points to see if they have been converted as expected
 *      to scale by one-half and translate by 100.
 *    - Convert these new points from Model space to Page space before
 *      the default viewing transform.  These points are checked to
 *      verify that they have not changed.
 *    - Convert these points from Model to Page space after the default
 *      viewing transfrom.  These points are checked to verify that they
 *      are now twice their previous value.
 *    - Convert these points from Page space after the default viewing
 *      transform to Device space.  These points are checked that they
 *      have applied the transform and translated 100 units.
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiConvertExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL    ptlTests[100];
  INT       i;
  MATRIXLF  matlfModel;
  MATRIXLF  matlfView;
  BOOL      bSuccess;
  ULONG     flOptions;
  SIZEL     sizlPS;
  RECTL     rectangle, save_viewport;
  LONG      x_inc, y_inc;
  LONG      expected;
  HDC       tmp_hdc;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    tmp_hdc = GpiQueryDevice(hPS);  // insure a device context is associated
    if ( tmp_hdc == HDC_ERROR )     // INV_HDC or INV_HPS
    {
       CLEANUP("GpiQueryDevice", pTestName14);
       return;
    }

    if ( tmp_hdc == NULLHANDLE)           // no device context associated
    {
       LOGINFO(L_HDR, "@", "System ERROR! No device context associated!");
       EXIT_MAIN(pTestName14);
       return;
    }

    ENTER_MAIN(pTestName14);

    NO_OUTPUT();    // indicate no expected output to display or printer

    // set global test name pointer for set_transform
    pCurTestName = pTestName14;

    // initialize the model transform matrix    to scale by 1/2 and translate
    // by 100 world units both x and y.

         // fxM11 is x axis scale amount
         matlfModel.fxM11 = HALF_FIXED;
         matlfModel.fxM12 = ZERO_FIXED;
         // lM13 is required entry for a transform matrix
         matlfModel.lM13  = 0L;
         matlfModel.fxM21 = ZERO_FIXED;
         // fxM22 is y axis scale amount
         matlfModel.fxM22 = HALF_FIXED;
         // lM23 is required entry for a transform matrix
         matlfModel.lM23  = 0L;
         // lM31 is the x axis translation amount
    matlfModel.lM31  = 100L;
         // lM32 is the y axis translation amount
    matlfModel.lM32  = 100L;
         // lM33 is required entry for a transfrom matrix
         matlfModel.lM33  = 1L;

         // set the model transform, all primitives are effected by model
    // transforms when they are actually drawn
    bSuccess =
       GpiSetModelTransformMatrix( hPS, 9L, &matlfModel, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
      CLEANUP("GpiSetModelTransformMatrix", pTestName14);
      return;
         }

         // fxM11 is x axis scale amount
         matlfView.fxM11 = TWO_FIXED;
         matlfView.fxM12 = ZERO_FIXED;
         // lM13 is required entry for a transform matrix
         matlfView.lM13  = 0L;
         matlfView.fxM21 = ZERO_FIXED;
         // fxM22 is y axis scale amount
         matlfView.fxM22 = TWO_FIXED;
         // lM23 is required entry for a transform matrix
         matlfView.lM23  = 0L;
         // lM31 is the x axis translation amount
    matlfView.lM31  = 0L;
         // lM32 is the y axis translation amount
    matlfView.lM32  = 0L;
         // lM33 is required entry for a transfrom matrix
         matlfView.lM33  = 1L;

         // set the default view matrix - will combine with current model
    // transform to determine box location and size
    bSuccess =
       GpiSetDefaultViewMatrix( hPS, 9L, &matlfView, TRANSFORM_REPLACE );
         if (bSuccess == FALSE) {
      CLEANUP("GpiSetDefaultViewMatrix", pTestName14);
      return;
    }

    if (GpiQueryPageViewport(hPS, &save_viewport) == FALSE) {
      CLEANUP("GpiQueryPageViewport", pTestName14);
      return;
    }

    // get presentation space size
    flOptions = GpiQueryPS(hPS, &sizlPS);
    x_inc = sizlPS.cx / 100;
    x_inc -= x_inc % 2;     // insure we stay on page but no round-off
    y_inc = sizlPS.cy / 100;
    y_inc -= y_inc % 2;     // insure we stay on page but no round-off

    // force device transform to scale by 1 and translate 100L units
 /**********************************************
  The device transform is defined as:
      [ a 0 0 ]   where: a = (xRight - xLeft)/pg_width
      [ 0 b 0 ]          b = (yTop - yBottom)/pg_height
      [ c d 0 ]          c = xLeft + (a-1)/2
                   and   d = yTop + (b-1)/2
  (see IBM Programming Guide pg 25-19
  NOTE: Originally the device transform was set to scale by 2
  but the display driver returned PMERR_COORDINATE_OVERFLOW
  (probably rightfully so) but the system was unstable after-
  ward (probably a PTT bug) so I changed the code to this JTB 03/19/91
  ***********************************************/
    rectangle.xLeft = 100L;
    rectangle.xRight = sizlPS.cx + 100L;
    rectangle.yBottom = 100L;
    rectangle.yTop = sizlPS.cy + 100L;

    if (GpiSetPageViewport(hPS, &rectangle) == FALSE) {
      CLEANUP("GpiSetPageViewport", pTestName14);
      return;
    }

    // initialize the input array to GpiConvert
    for ( i=0; i < 100; i++ ) {
      ptlTests[i].x = i * x_inc;
      ptlTests[i].y = i * y_inc;
    }

    SUBENTER(GpiConvert:, "World to Model Space" );

    // use GpiConvert to validate transform
    if (GpiConvert(hPS, CVTC_WORLD, CVTC_MODEL, 100L, ptlTests) == FALSE){
      SHOWERROR("GpiConvert", pTestName14);
      SUBEXIT();
      EXIT_MAIN(pTestName14);
      return;
    }

    for ( i=0; i < 100; i++ ) {
      expected = ( (i * x_inc) / 2) + 100L;
      if (ptlTests[i].x != expected) {
        // GpiConvert translated incorrectly
        REPORT(x);
      }
      expected = ( (i * y_inc) / 2) + 100L;
      if (ptlTests[i].y != expected) {
        // GpiConvert translated incorrectly
        REPORT(y);
      }
    }

    SUBEXIT();

    SUBENTER(GpiConvert:, "Model to Page Space Before Default View" );

    // use GpiConvert to validate transform
    if (GpiConvert(hPS, CVTC_MODEL, CVTC_DEFAULTPAGE, 100L, ptlTests) == FALSE){
      SHOWERROR("GpiConvert", pTestName14);
      SUBEXIT();
      EXIT_MAIN(pTestName14);
      return;
    }

    for ( i=0; i < 100; i++ ) {
      expected = ( (i * x_inc) / 2) + 100L;
      if (ptlTests[i].x != expected) {
        // GpiConvert translated incorrectly
        REPORT(x);
      }
      expected = ( (i * y_inc) / 2) + 100L;
      if (ptlTests[i].y != expected) {
        // GpiConvert translated incorrectly
        REPORT(y);
      }
    }

    SUBEXIT();

    SUBENTER(GpiConvert:, "Model to Page Space After Default View" );

    // use GpiConvert to validate transform
    if (GpiConvert(hPS, CVTC_MODEL, CVTC_PAGE, 100L, ptlTests) == FALSE){
      SHOWERROR("GpiConvert", pTestName14);
      SUBEXIT();
      EXIT_MAIN(pTestName14);
      return;
    }

    for ( i=0; i < 100; i++ ) {
      expected = (((i * x_inc) / 2L) + 100L) * 2L;
      if (ptlTests[i].x != expected) {
        // GpiConvert translated incorrectly
        REPORT(x);
      }
      expected = (((i * y_inc) / 2) + 100L) * 2L;
      if (ptlTests[i].y != expected) {
        // GpiConvert translated incorrectly
        REPORT(y);
      }
    }

    SUBEXIT();

    SUBENTER(GpiConvert:, "Page to Device Space" );

    // use GpiConvert to validate transform
    if (GpiConvert(hPS, CVTC_PAGE, CVTC_DEVICE, 100L, ptlTests) == FALSE){
      SHOWERROR("GpiConvert", pTestName14);
      SUBEXIT();
      EXIT_MAIN(pTestName14);
      return;
    }

    for ( i=0; i < 100; i++ ) {
      expected = (((i * x_inc) / 2L) + 100L) * 2L + 100L;
      if (ptlTests[i].x != expected) {
        // GpiConvert translated incorrectly
        REPORT(x);
      }
      expected = (((i * y_inc) / 2) + 100L) * 2L + 100L;
      if (ptlTests[i].y != expected) {
        // GpiConvert translated incorrectly
        REPORT(y);
      }
    }

    SUBEXIT();

    // Restore the device page for subsequent runs.
    // Without this, future runs seem to have problems, PTT disappears
    if (GpiSetPageViewport(hPS, &save_viewport) == FALSE) {
      CLEANUP("GpiSetPageViewport", pTestName14);
      return;
    }

    EXIT_MAIN(pTestName14);

  }
  return;
}

