/*********************************************************/
/*  Function: Create_gpimeta1()                          */
/*  Purpose : Creates a metafile and saves it to disk to */
/*            be used by GpiMetaApp1                     */
/*    Input : None                                       */
/*   Return : a pointer to a string giving a discription */
/*            of errors if any.                          */
/*********************************************************/
PSZ APIENTRY Create_gpimeta1()  {

HPS     hpsMeta;
HAB     hab;
HDC     hdcMetafile;
SIZEL   sizlPage;
HMF     hmfPicture;
LONG    lLineWidth;
LONG    lcolor = 0L;
FIXED   fxmultiplier = FXTOLONG;
FIXED   fxStartAngle = 0;
FIXED   fxSweepAngle = FXTOLONG * 24;
USHORT  usRC;
ULONG   rcgpi = 0L;


static  DEVOPENSTRUC dop = { NULL, "DISPLAY" };
static  POINTL       apt;


  // Open metafile device context

          hdcMetafile = DevOpenDC ( hab, OD_METAFILE, "*", 2L,
                                    (PDEVOPENDATA) &dop, NULLHANDLE);

  //  Create a presentation space associated with that DC

          sizlPage.cx = 850;
          sizlPage.cy = 1100;
          hpsMeta = GpiCreatePS( hab, hdcMetafile, &sizlPage,
                                 GPIA_ASSOC | PU_LOENGLISH );

  //  Set current pointer position

          apt.x = 425;
          apt.y = 375;
          GpiMove( hpsMeta, &apt );

  //   Set Line Width

          lLineWidth = 9;
          GpiSetLineWidthGeom( hpsMeta, lLineWidth );


  //   Begin loop to create circles

    while ( fxmultiplier <= 252 * FXTOLONG ) {

  //  Begin a path.

         if( GpiBeginPath( hpsMeta, 1L ) == FALSE )
              return( "Create_gpimeta1() died at GpiBeginPath\n" );
         rcgpi = GpiPartialArc( hpsMeta, &apt, fxmultiplier, fxStartAngle,
                 fxSweepAngle );
         if ( rcgpi != GPI_OK )
              return( "Create_gpimeta1() died at GpiPartialArc\n" );

  //   Increase radius

         fxmultiplier += FXTOLONG * 1 ;

  //   Change the start angle

         fxStartAngle += FXTOLONG * 24;
         if ( fxStartAngle >= 360 * FXTOLONG) fxStartAngle = 0;

  //   Set new color,

         lcolor += 1L;
         if (lcolor > 15L ) lcolor = 1L;         //  repeat the color scheme
         if (GpiSetColor( hpsMeta, (LONG)lcolor ) != TRUE)
           return( "Create_gpimeta1() died at GpiSetColor\n" );


  //   End the path and then output it to the metafile DC
         if( GpiCloseFigure( hpsMeta ) == FALSE )
              return( "Create_gpimeta1() died at GpiCloseFigure\n" );
         if( GpiEndPath( hpsMeta ) == FALSE )
              return( "Create_gpimeta1() died at GpiEndPath\n" );
         if( GpiStrokePath( hpsMeta, 1L, (ULONG) 0 ) != GPI_OK )
              return( "Create_gpimeta1() died at GpiStrokePath\n" );

    } /* endwhile */


         apt.x = 0;
         apt.y = 75;
         GpiMove( hpsMeta, &apt );
         GpiSetColor( hpsMeta, 1L );
         GpiCharString( hpsMeta, 31L, "SPOOLER FORMAT MUST BE PM_Q_RAW" );


  //    Destroy the presentation space
         if( GPI_ERROR == GpiAssociate( hpsMeta, (HDC)NULL ) )
         {
             usRC = ERRORIDERROR( WinGetLastError( hab ) );
             return( "Create_gpimeta1() died at GpiDisAssociatePS\n" );
         }

         if( GPI_ERROR == GpiDestroyPS( hpsMeta ) )
         {
             ERRORIDERROR( WinGetLastError( hab ) );
             return( "Create_gpimeta1() died at GpiDestroyPS\n" );
         }

  //    Close the device context to get the metafile handle

          hmfPicture = DevCloseDC( hdcMetafile );

  //    Save the metafile to disk

         DosDelete( "gpimeta1.met");
         if( GpiSaveMetaFile( hmfPicture, "gpimeta1.met" ) == FALSE)
              return( "Create_gpimeta1() died at GpiSaveMetaFile\n" );



     return( "Create_gpimeta1 passed\n" );

}





/*********************************************************/
/*  Function: Create_gpimeta2()                          */
/*  Purpose : Creates a metafile and saves it to disk to */
/*            be used by GpiMetaApp2                     */
/*    Input : None                                       */
/*   Return : a pointer to a string giving a discription */
/*            of errors if any.                          */
/*********************************************************/

PSZ APIENTRY Create_gpimeta2()  {

HPS      hpsMeta;
HAB      hab;
HDC      hdcMetafile;
SIZEL    sizlPage;
HMF      hmfPicture;
LONG     lHRound = 0L;
LONG     lVRound = 0L;

static  DEVOPENSTRUC dop = { NULL, "DISPLAY" };
static  POINTL       apt;


  // Open metafile device context

          hdcMetafile = DevOpenDC ( hab, OD_METAFILE, "*", 2L,
                                    (PDEVOPENDATA) &dop, NULLHANDLE);

  //  Create a presentation space associated with that DC

          sizlPage.cx = 800;
          sizlPage.cy = 1100;
          hpsMeta = GpiCreatePS( hab, hdcMetafile, &sizlPage,
                                 GPIA_ASSOC | PU_LOENGLISH );

         apt.x = 0L;
         apt.y = 100L;
         GpiMove( hpsMeta, &apt );

         apt.x = 640L;
         GpiLine( hpsMeta, &apt );

  //  Set current pointer position

         apt.x = 100L;
         apt.y = 300L;
         GpiMove( hpsMeta, &apt );

         apt.x = 300L;
         apt.y = 100L;

  //  Create the first box

      while ( lHRound <= 500 ) {

           lHRound += 10;
           lVRound += 10;
           GpiBox( hpsMeta, DRO_OUTLINE, &apt, lHRound, lVRound );

      } /* endwhile */

  //  Set current pointer position

         apt.x = 350L;
         apt.y = 300L;
         GpiMove( hpsMeta, &apt );

         apt.x = 550L;
         apt.y = 100L;

         lHRound = 0;
         lVRound = 0;

  //  Create the second box

      while ( lHRound <= 500 ) {

           lHRound += 10;
           lVRound += 10;
           GpiBox( hpsMeta, DRO_OUTLINE, &apt, lHRound, lVRound );

      } /* endwhile */

  //  Set current pointer position

         apt.x = 200L;
         apt.y = 400L;
         GpiMove( hpsMeta, &apt );

         apt.x = 450L;
         apt.y = 300L;

         lHRound = 0;
         lVRound = 0;

  //  Create the third box

      while ( lHRound <= 500 ) {

           lHRound += 10;
           lVRound += 10;
           GpiBox( hpsMeta, DRO_OUTLINE, &apt, lHRound, lVRound );

      } /* endwhile */

  //  Set current pointer position

         apt.x = 275L;
         apt.y = 600L;
         GpiMove( hpsMeta, &apt );

         apt.x = 375L;
         apt.y = 400L;

         lHRound = 0;
         lVRound = 0;

  //  Create the fourth box

      while ( lHRound <= 500 ) {

           lHRound += 10;
           lVRound += 10;
           GpiBox( hpsMeta, DRO_OUTLINE, &apt, lHRound, lVRound );

      } /* endwhile */

         apt.x = 0;
         apt.y = 75;
         GpiMove( hpsMeta, &apt );

         GpiCharString( hpsMeta, 31L, "SPOOLER FORMAT MUST BE PM_Q_RAW" );

         if( GPI_ERROR == GpiAssociate( hpsMeta, (HDC)NULL ) )
         {
             ERRORIDERROR( WinGetLastError( hab ) );
             return( "Create_gpimeta2() died at GpiAssociate(dis)\n" );
         }

  //    Destroy the presentation space

         if( GPI_ERROR == GpiDestroyPS( hpsMeta ) )
         {
             ERRORIDERROR( WinGetLastError( hab ) );
             return( "Create_gpimeta2() died at GpiDestroyPS\n" );
         }

  //    Close the device context to get the metafile handle

          hmfPicture = DevCloseDC( hdcMetafile );

  //    Save the metafile to disk

         DosDelete( "gpimeta2.met" );
         if( GpiSaveMetaFile( hmfPicture, "gpimeta2.met" ) == FALSE)
              return( "Create_gpimeta2() died at GpiSaveMetaFile\n" );



     return( "Create_gpimeta2 passed\n" );

}


