/**************************************************************************
 *
 * SOURCE FILE NAME = PTT-DLL.H
 *
 * DESCRIPTIVE NAME = Common include file for PTT and the test case DLLs.
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : This header file is a common include file that is included
 *               by the PTT.H and PTTDLLDF.H includes files.  It contains
 *               variables, constants, and typedefs that are common to both
 *               the printer test tool and the test case DLLs.
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

#include <stdlib.h>

/*
** User defined messages for communication between test cases and the
** client window of the test processor.
*/

#define  WM_TEST_DOES_DEVCALLS WM_USER + 200
#define  WM_PTHREAD_DOES_DEVCALLS WM_TEST_DOES_DEVCALLS + 1
#define  WM_GET_DEVOPENSTRUC WM_PTHREAD_DOES_DEVCALLS + 1
#define  WM_TEST_SIGNATURE WM_GET_DEVOPENSTRUC + 1
#define  WM_TEST_LOG   WM_TEST_SIGNATURE + 1
#define  WM_GET_ENV_INFO WM_TEST_LOG + 1
#define  WM_LOG_SIGNATURE WM_GET_ENV_INFO + 1

/*
  Define the function type for the test cases defined in the DLLs
  and the parameters that will be passed to the InitTest procedure
  of each DLL to determine the test case entry points.
*/

/*
  definition of the initialization info structure used by PTT to get
  info from the test case dll
*/

#define  ENTRYPOINTS   50              /* Maximum number of test cases
                                          within a DLL                      */
#define  NAMELENGTH    40              /* Maximum length of test case name  */

/*
** #defines and typedef used by the WM_GET_ENV_INFO user defined message
*/

#define  PTT_INTERACTIVE 0
#define  PTT_SCRIPT    1
#define  PTT_SCREEN    0
#define  PTT_PRINTER   1
#define  TEST_CASE_SIZE (sizeof(TEST_CASE_COMPONENT))
#define  ENTRY_POINT_SIZE (sizeof(ENTRYPOINT))
typedef  VOID (APIENTRY DLLFN) (HPS,HWND,BOOL);
typedef  DLLFN *PDLLFN;

typedef struct _TESTINITINFO
{
  USHORT ntests;
  CHAR group_name[NAMELENGTH];
  CHAR test_names[ENTRYPOINTS][NAMELENGTH];
  PDLLFN test_addrs[ENTRYPOINTS];
} TESTINITINFO,*PTESTINITINFO;

typedef struct _EntryPoint
{
  CHAR szTestName[NAMELENGTH];
  PDLLFN TestAddress;
} ENTRYPOINT,*PENTRYPOINT;

typedef struct _TestCaseComponent
{
  USHORT ntests;
  CHAR group_name[NAMELENGTH];
  PENTRYPOINT pEntryPoint;
  CHAR FullDllName[_MAX_PATH];
} TEST_CASE_COMPONENT,*PTEST_CASE_COMPONENT;

/*
** definition of the operating environment info structure that is filled in
** upon request of the test case dll
*/

typedef struct _TESTENVIRONMENTINFO
{
  USHORT usOperatingMode;
  USHORT usOutputMode;
  ULONG ulPSType;
} TESTENVINFO,*PTESTENVINFO;

/*
** TESTLOG logging level defines
*/

#define  L_HDR         1
#define  L_ABORT       2
#define  L_FAIL        4
#define  L_WARN        6
#define  L_TRACE       7
#define  L_LOTRACE     8
#define  L_DEBUG       9
