#define INCL_DEV      // include all DEV definitions
#define INCL_GPI      // include all Gpi definitions
#define INCL_WIN
#define INCL_DOSMEMMGR
#include <string.h>
#include <search.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <malloc.h>
#include "PTTDLLDF.h"   // test case defines
#include "stdutil3.h"   // format specifiers for logging

typedef INT (FTNPTR) (const void *, const void *);
/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT (Phase II)
 *
 * Module name: COMMON.C
 *
 * Purpose: This source file contains the function needed to log errors
 *          and functiona that are needed to select a font that is
 *          used to draw text on current Device Context.
 *
 * Revision Log:
 *               01/22/91 ,PDVT ,Mike Abuzant and David MCcombs
 *               -Initial file.
 *               02/19/91 ,PDVT ,Mike Abuzant
 *               - Wrot functions to select and create logical
 *                 fonts.
 *
 * SAD References:  None.
 *
 * SRS References: Printer Driver Verification Tool
 *
 * Limitations:
 *  None at This time.
 *
 *\\end
****************************************************************************/

static  LONG lCurrentPSId=0L,       //Logical Font ID.
             lHorzFontRes=0L,
             lVertFontRes=0L,
             lPelsPerInch=0L,
             lMyFontMatchNumber=0x0FFFF,
             AveFontCharWidth=0L;

static  BOOL FontIsFound=FALSE;     //Indicates if a font is found.

static  CHAR MyFontFaceName[34],    //Matched font name
         MyFontFamilyname  [34],    //Matched font family name.
         ieStorString      [100];
static CHAR ieStorage[150];

static  USHORT    usMyFontPointSize=0x0FFF,
                  aPointSize[]={
                                 8,
                                 10,
                                 12,
                                 14,
                                 18,
                                 24
                               };


LONG   pg_width, pg_height;
LONG   dev_height, dev_width, hori_pels_per_m, vert_pels_per_m;
LONG   pg_size_x, pg_size_y;
LONG   x_units_per_inch, y_units_per_inch;
LONG   delta_x,delta_y;
double CommonXMult;
double CommonYMult;

/***************************************************************************
 *\\ddd
 * Routine Name: CleanUp()
 *
 * Purpose:  This function log a message indicating that a Gpi or
 *           Gre function has failed.
 *
 *
 * System Requirements: None
 *
 * Revision Log: 01/23/91, PDVT, Mike Abuzant
 *               -initial creation
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient     //client window handle
 *   Function       // Function that failed.
 *   ExitPoint      // test case Entry point
 *   ErrorCount
 *   Filename       // file name where error occurred.
 *   LineNo         // Line number where error occurred.
 * Outputs:
 *   ErrorCount
 *
 * Subroutines Required:
 *       ReportSetupError()          //Defined in PTT.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Increment the error count.
 *   call ReportSetupError() to log the error information.
 *   Print a message to LOG FILE to indicate that this entry point will be
 *   terminated.
 * }
 *\\end
 ***************************************************************************/
VOID CleanUp(CHAR *Function,HWND hWndClient,CHAR *ExitPoint,PLONG ErrorCount,
             PSZ szFileName,USHORT LineNo,BOOL fExit)
{
  CHAR  achLogLine[200];

  ++*ErrorCount;
  (VOID)ReportSetupError(hWndClient,Function ,szFileName,LineNo);
  if (fExit){
    CWRITELOG( L_LOTRACE, 0, CLEANUP_SPEC );
    sprintf( achLogLine, EXIT_SPEC, ExitPoint );
    CWRITELOG( L_LOTRACE, 0, achLogLine );
  }

  return;

}

/***************************************************************************
 *\\ddd
 * Routine Name: ExitMain()
 *
 * Purpose:  This function will print needed information before
 *           exiting the current entry point. This function will
 *           print the the number of Gpi or Gre that failed within
 *           the entry point.
 *
 *
 * System Requirements: None
 *
 * Revision Log: 01/23/91, PDVT, Mike Abuzant
 *               -initial creation
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient     //client window handle
 *   ExitPoint      // test case Entry point
 *   ErrorCount     // Error count.
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *   None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   if (ErrorCount==0)
 *      print  a PASS message
 *   else
 *      print the Error Count and
 *      print  a FAIL message.
 * }
 *\\end
 ***************************************************************************/

VOID ExitMain( CHAR * ExitPoint, HWND hWndClient, LONG ErrorCount )
{
  CHAR  achLogLine[200];

  if (!ErrorCount) {
     sprintf( achLogLine, PASS_SPEC, ExitPoint );
  }
  else {
     LOG_SIGNATURE;
          sprintf( achLogLine, ERRORC_SPEC , ErrorCount );
     CWRITELOG(L_HDR, 0,achLogLine);
     sprintf( achLogLine, FAIL_SPEC, ExitPoint );
  }
  CWRITELOG( L_HDR, 0, achLogLine );
  sprintf( achLogLine, EXIT_SPEC , ExitPoint );
  CWRITELOG( L_LOTRACE, 0, achLogLine );
  return;

}

/***************************************************************************
 *\\ddd
 * Routine Name: EnterMain()
 *
 * Purpose:  This function will do call some functions to
 *           initialize variables that are used within this entry point.
 *           This function will also select the font to use for drawing
 *           text on current Device Context.
 *
 * System Requirements: None
 *
 * Revision Log: 01/23/91, PDVT, Mike Abuzant
 *               -initial creation
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient     //client window handle
 *   EntryPoint     // test case Entry point
 *   ErrorCount     // Error count.
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *   set_delta()
 *   InitDefaultPrintFont()
 *   CreateCourFont()
 *
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *    ErrorCount=0;
 *    Select a font by calling InitDefaultPrintFont().
 *    Create a logical font .
 *    LOG_SIGNATURE;
 *    TEST_SIGNATURE(0,0);
 *
 * }
 *\\end
 ***************************************************************************/
#define RESOLUTION(Value)  (.0254*(Value)+.50)

 VOID EnterMain(HPS hPS, HWND hWndClient, CHAR * EntryPoint, PLONG ErrorCount)
{
  FONTMETRICS     fm;
  HDC             hDC;
  double          xPixels,
                  yPixels;

   //Get Device Context associated with current PS.
   if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
      REPORTSETUPERROR("GpiQueryDevice()");
      return ;      //Can't continue without this DC.
   }

   // Had to Do this step since PTT does not retrieve all
   // the device CAPS.
   if(DevQueryCaps (hDC, 0L,40L, alDevCaps)==FALSE)
       REPORTSETUPERROR ("DevQueryCaps()");

   (VOID)new_set_delta(hPS);
   FontIsFound=FALSE;                     //A good font is not fount yet.?!
   *ErrorCount=0L;
   lCurrentPSId=0;

   // Calculate the pixels per inch in X-direction
   xPixels=(double)RESOLUTION(hori_pels_per_m);

   // Calculate the pixels per inch in Y-direction
   yPixels=(double)RESOLUTION(vert_pels_per_m);

   if DeviceIsDisplay(){
                                          //Current Device is Screen
       FontIsFound=FALSE;                //Fonts are O.K for Screen,
                                         //Lets' not change it.
   }
   else {                                //Current Device is a printer.
      if ((lCurrentPSId=GpiSavePS(hPS))==GPI_ERROR){
           REPORTSETUPERROR ("GpiSavePS()");
           return;
      }
      FontIsFound=InitDefaultPrintFont(hPS,hWndClient);
      if (FontIsFound && CreateCourFont(hPS,DESIRED_FONT_ID)){
        if (GpiSetCharSet(hPS,DESIRED_FONT_ID)==FALSE){
             REPORTSETUPERROR ("GpiSetCharSet()");
             FontIsFound=FALSE;
        }
      }
      else{
         FontIsFound=FALSE;
      }
   }

   TEST_SIGNATURE(0,0);
        ErrorStatus(hWndClient, *ErrorCount, FALSE, NULL, NULL);


   //Determine the char height of the selected font. This will be
   //used for placing text on the display.
   if (GpiQueryFontMetrics(hPS,(LONG)sizeof(fm),&fm )==FALSE){
      REPORTSETUPERROR("GpiQueryFontMetrics()");
   }
   syPosition=(SHORT)fm.lMaxBaselineExt;

   if (lCurrentPSId){
      if(GpiRestorePS(hPS,lCurrentPSId)==GPI_ERROR){
         REPORTSETUPERROR ("GpiRestorePS()");
      }
   }

   if (FontIsFound && (CreateCourFont(hPS,DESIRED_FONT_ID)==GPI_ERROR)){
       REPORTSETUPERROR ("GpiCreateLogFont()");
       FontIsFound=FALSE;
   }

   return;
}
/***************************************************************************
 *\\ddd
 * Routine Name: CheckRc()
 *
 * Purpose: Out a PASS or FAIL message to indicate the status of
 *          testing a return code.
 *
 * System Requirements: None
 *
 * Revision Log: 01/24/91, PDVT, Mike Abuzant
 *               -initial creation
 * Input:
 *
 *   hPS            //Presentation space
 *   hWndClient     //Client window handle
 *   EntryPoint     //Test case Entry point
 *   ReturnCode     //Gpi or Gre return code.
 *   ErrorToCheck   //Tested return code.
 *   message1       //a message
 *   message2       //a message
 *   szFileName     // .c file name
 *   LineNo         // location of the gpi /gre in .c file
 *
 * Outputs:
 *    0  If successfull in producing error code.
 *    1  If unsuccessfull in producing error code.
 *
 * Subroutines Required:
 *    VerifyReturnedErrorCode()
 *
 * Limitations:
 *   None at this time.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *
 *    Call VerifyReturnedErrorCode() check return code.
 * }
 *\\end
 ***************************************************************************/

LONG CheckRc(HWND hWndClient,LONG ReturnCode,USHORT ErrorToCheck,
             CHAR *Message1,CHAR *Message2,PSZ szFileName,USHORT LineNo)
{
  CHAR  achLogLine[200];

  strcpy(achLogLine,Message1);
  if (Message2){
     strcat(achLogLine,"  \\  ");
     strcat(achLogLine,Message2);
  }
  return (LONG) VerifyReturnedErrorCode(hWndClient,ReturnCode,
                achLogLine,SEVERITY_ERROR,ErrorToCheck,szFileName,LineNo);

}


/***************************************************************************
 *\\ddd
 * Routine Name: CheckRc1()
 *
 * Purpose: Out a PASS or FAIL message to indicate the status of
 *          testing a return code.
 *
 * System Requirements: None
 *
 * Revision Log: 10/15/91, Rickey C. Brown
 *               -initial creation
 * NOTE: This function is a virtual copy of CheckRc() above, with the exception
 *       that it calls VerifyReturnCode() instead of VerifyReturnedErrorCode().
 *       This was needed specifically for testing the function GpiQueryPel(),
 *       in which a NULL return code does not constitute an error.  The
 *       corresponding #define statement is CHECKRC1. For more information,
 *       see DEBUGGING NOTE in GpiBtMpr.c, entrypoint GpiQueryPelRc.
 * Input:
 *
 *   hPS            //Presentation space
 *   hWndClient     //Client window handle
 *   EntryPoint     //Test case Entry point
 *   ReturnCode     //Gpi or Gre return code.
 *   ErrorToCheck   //Tested return code.
 *   message1       //a message
 *   message2       //a message
 *   szFileName     // .c file name
 *   LineNo         // location of the gpi /gre in .c file
 *
 * Outputs:
 *    0  If successful in producing error code.
 *    1  If unsuccessful in producing error code.
 *
 * Subroutines Required:
 *    VerifyReturnedErrorCode()
 *
 * Limitations:
 *   None at this time.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *
 *    Call VerifyReturnedErrorCode() check return code.
 * }
 *\\end

 ***************************************************************************/

LONG CheckRc1(HWND hWndClient,LONG ReturnCode,USHORT ErrorToCheck,
             CHAR *Message1,CHAR *Message2,PSZ szFileName,USHORT LineNo)
{
  CHAR  achLogLine[200];

  strcpy(achLogLine,Message1);
  if (Message2){
     strcat(achLogLine," ");
     strcat(achLogLine,Message2);
  }
  return (LONG) VerifyReturnCode(hWndClient,ReturnCode,
                achLogLine,SEVERITY_ERROR,ErrorToCheck,szFileName,LineNo);

}


/***************************************************************************
 *\\ddd
 * Routine Name: SubEnter()
 *
 * Purpose:  This function will do call some functions to
 *           initialize variables that are used within this subentry point.
 *           This function is used when testing for return codes.
 *
 * System Requirements: None
 *
 * Revision Log: 01/23/91, PDVT, Mike Abuzant
 *               -initial creation
 * Inputs:
 *   hWndClient     //client window handle
 *   ErrorToCheck   // Indicate which error message we testing for.
 *   addedmessga   // Additional message.
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *  None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Print a Message to the log file signaling that this current subentry
 *   point is about to start.
 * }
 *\\end
 ***************************************************************************/
VOID SubEnter(HWND hWndClient, CHAR * errortocheck, CHAR * addedmessage)
{
 CHAR  achLogLine[200];

   strcpy(ieStorString,errortocheck);
        if (addedmessage){
     strcat(ieStorString,"  \\  ");
     strcat(ieStorString,addedmessage);
   }
        sprintf(achLogLine,IENTRY_SPEC,ieStorString);
        CWRITELOG(L_LOTRACE,0,achLogLine);
        return;

}
/***************************************************************************
 *\\ddd
 * Routine Name: SubExit()
 *
 * Purpose:  This function will print needed information before
 *           exiting the current subentry point. This function is used
 *           when testing for return codes.
 *
 *
 * System Requirements: None
 *
 * Revision Log: 01/23/91, PDVT, Mike Abuzant
 *               -initial creation
 * Inputs:
 *   hWndClient     //client window handle
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *   None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Print a Message to the log file signaling that this current subentry
 *   point is terminating.
 * }
 *\\end
 ***************************************************************************/
VOID SubExit(HWND hWndClient)
{
 CHAR  achLogLine[200];

        sprintf( achLogLine, IEXIT_SPEC, ieStorString );
   CWRITELOG(L_LOTRACE,0,achLogLine);
   return;

}

 /***************************************************************************
 *\\ddd
 * Routine name:  CreateCourFont()
 *
 * Purpose:  This is a function to create logical font .
 *
 * System Requirements:  None
 *
 * Revision Log:  01/16/91, PDVT, Kim Cairns
 *                - modified EzfCreateLogFont to create standard font
 *                02/20/91 ,PDVT ,Mike Abuzant
 *                -modified version from Phase I
 *
 * Inputs:     hPS            - presentation space handle
 *             lcid           - font id
 *
 * Outputs:    The lcid of the selected font.
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   set FATTRS value from global variables set by InitDefaultPrintFont().
 *   GpiCreateLogFont for desired criteria and return lcid
 *
 *\\end
 ***************************************************************************/
static LONG CreateCourFont(HPS hPS, LONG lcid)
{
  static FATTRS FontAttributes;

  //
  // Use values set in InitDefaultPrintFont()
  //

  memset((VOID *)&FontAttributes,0x00,sizeof(FontAttributes));
  FontAttributes.lMatch = lMyFontMatchNumber;
  FontAttributes.usRecordLength = sizeof(FontAttributes);
  strcpy(FontAttributes.szFacename,MyFontFaceName);

  return GpiCreateLogFont(hPS, NULL, lcid, &FontAttributes);
}


 /***************************************************************************
 *\\ddd
 * Routine name:  InitDefaultPrintFont()
 *
 * Purpose:  This is used to select a font that is used to draw text
 *           on current device surface.
 *
 * System Requirements:  None
 *
 * Revision Log:  02/20/92, PDVT, Mike Abuzant
 *                - initial function design
 *
 *
 * Inputs:
 *             hPS            - presentation space handle
 *
 * Outputs:
 *             TRUE if useable font(s) available
 *             FALSE if Error Occured  within this function or
 *             if could not find any fonts.
 *
 * Subroutines Required:
 *             None
 *
 * Limitations:
 *     "Helv" font must be installed using the CONTROL PANEL.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      if the Current Device has built-in fonts ,
 *
 *        Select        a font that is compatible with the current device resolution.
 *
 *    if a font is found
 *       try to find another font with the same attributes but
 *       smaller point size. This is needed since the text on printers
 *       always seems to be longer,in the X-Direction, than the screen.
 *      endif
 *
 *      return success or failure indicator.
 *
 *      endif
 *
 *
 *      if the Current Device has NO built-in fonts ,
 *
 *        Select        a system font that compatible with the current device resolution.
 *
 *    if a font is found
 *       try to find another font with the same attributes but
 *       larger point size since the system fonts are designed
 *       for device that have a low resolution.
 *      endif
 *
 *      return success or failure indicator.
 *
 *      endif
 *
 *
 *
 *\\end
 ***************************************************************************/
static BOOL InitDefaultPrintFont(HPS hPS,HWND hWndClient)
{
  HDC              hDC;

  FONTMETRICS      *pfm;
  PFONTMETRICS     FontPtr;
  LONG             Requested=0L,
                   Number;

  SHORT            Index,
                   Index1,
                   PointSize;
  UINT             uiNumber;
  BOOL             fDeviceHasFonts=TRUE,
                   FontIsFound=FALSE;
  PCHAR            FontNameToLookFor=(PCHAR)NULL;
  double           Increment;

  FTNPTR           *FunctionPtr;
  LONG             lSize;
  SHORT            sCount;

    lSize = sizeof(FONTMETRICS);

    //Get device context associated of  Presentation Space.
    if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
       REPORTSETUPERROR ("GpiQueryDevice()");
       return FALSE;
    }

    // Obtain the width and the height of the current device
    lHorzFontRes=alDevCaps[CAPS_HORIZONTAL_FONT_RES];
    lVertFontRes=alDevCaps[CAPS_VERTICAL_FONT_RES];

    lPelsPerInch=MapX(delta_x);  // # of pels per hori. inch
    AveFontCharWidth = 0x0fffL;                    // initialize to high value
    PointSize=8;
    Increment=((double)lHorzFontRes/67);           //67 is the scrren resolution.
    PointSize=(USHORT)(Increment*2.0+8.0);

    for (Index=0;Index <5; Index++){
        if (PointSize >= (SHORT) aPointSize[Index] &&
            PointSize <= (SHORT) aPointSize[Index+1]){
                Index++;
                break;
        }
    }

    PointSize=aPointSize[Index]*10;

    //alDevCaps[] is initialized By PTT.EXE.

    fDeviceHasFonts=(BOOL)((Number=alDevCaps[CAPS_DEVICE_FONTS])>0L);

    FunctionPtr=fDeviceHasFonts ? FontResolutionFunction : PointSizeFunction;

    FontNameToLookFor=fDeviceHasFonts ? (PCHAR)NULL : (PCHAR)"Helv";

    if (!fDeviceHasFonts &&((Number=GpiQueryFonts(hPS,QF_PUBLIC,
                            FontNameToLookFor,&Requested,(LONG)NULL,
                            NULL))==GPI_ALTERROR)){
          REPORTSETUPERROR("GpiQueryFonts()");
          return FALSE;
    }


    if ((Number==0L) || ((pfm=(PFONTMETRICS)malloc((SHORT)Number*
                                  sizeof(FONTMETRICS)))==NULL)){
         return FALSE;
    }

    if ((GpiQueryFonts(hPS,QF_PUBLIC,FontNameToLookFor,
                    &Number,lSize,pfm))==GPI_ALTERROR){
         REPORTSETUPERROR("GpiQueryFonts()");
         free(pfm);
         return FALSE;
    }


    uiNumber=(USHORT)Number;




    for (Index1 =0 ; Index1 < 2 ;Index1++){

       FontPtr=(PFONTMETRICS)lfind((CHAR *)&PointSize,
                            (CHAR *)pfm,&uiNumber,
                            (USHORT)lSize,FunctionPtr); //BSC -Removed (INT) cast

       if (fDeviceHasFonts){

           FontPtr=(PFONTMETRICS)NULL;

  // Added by TSS...to find Courier 10 if it exists

           for (sCount=0; sCount<(SHORT)uiNumber; sCount++) {

              if(stricmp(pfm[sCount].szFacename, "Courier 10") == 0 ) {
                 FontPtr = &pfm[sCount];
                 break;
              }
           } /* endfor */

   // If Courier 10 not found, continue with pointsize search.

           while (!FontPtr && usMyFontPointSize){
               usMyFontPointSize--;
               FontPtr=(PFONTMETRICS)lfind((CHAR *)&usMyFontPointSize,
                                   (CHAR *)pfm,&uiNumber,
                                   (USHORT)lSize,DevicePointSizeFunction);

          }

          break;
       }
       if (FontPtr){
         if (FontPtr->sXDeviceRes >(SHORT)lHorzFontRes){
             Index=Index==0 ? Index : (Index-1);
         }
         else{
           if (Increment < 2.0)
             Index=Index==5 ? Index : (Index+1);
           else if (Increment > 2.0 && Increment < 4.0)
             Index+=2;
           else
             Index+=3;

         }

         Index=Index > 5 ? 5 : (Index);
         PointSize=aPointSize[Index]*10;
       }
    }

    if (FontPtr){
        lMyFontMatchNumber = FontPtr->lMatch;
        AveFontCharWidth = FontPtr->lAveCharWidth;
        strcpy (MyFontFaceName, FontPtr->szFacename);
        free(pfm);
      return TRUE;
    }

    free(pfm);
    return fDeviceHasFonts;
}

/**********************************************************************
   The next three function are used as an argument to the C run-time
   function lfind(). These are the comparsion function that help
   in finding the desired font.

   1. PointSizeFunction() : Used to find the System font that
                            matches the specified point size.

   2. DevicePointSizeFunction() : Used to find the Device font that
                            matches the specified point size.

   3. FontResolutionFunction() : Used to find the Device font that
                            matches the device current resolution.

***********************************************************************/
static INT PointSizeFunction(const void *PointSizeOld ,const void *pfmold)
{
   const USHORT *PointSize = (const USHORT *) PointSizeOld;
   const PFONTMETRICS pfm = (const PFONTMETRICS) pfmold;
             //Normal Font.
      return pfm->fsSelection ? TRUE :
                                    *PointSize-pfm->sNominalPointSize;
}

static INT DevicePointSizeFunction(const void *PointSizeOld ,const void *pfmold)
{
  const USHORT *PointSize = (const USHORT *) PointSizeOld;
  const PFONTMETRICS pfm = (const PFONTMETRICS) pfmold;

  if (pfm->sXDeviceRes == (SHORT) lHorzFontRes &&
      pfm->sYDeviceRes == (SHORT) lVertFontRes &&
      *PointSize==(USHORT) pfm->sNominalPointSize &&
      stricmp(pfm->szFamilyname,MyFontFamilyname)==0){
        lMyFontMatchNumber = pfm->lMatch;
        AveFontCharWidth = pfm->lAveCharWidth;
        strcpy (MyFontFaceName, pfm->szFacename);
        return *PointSize-pfm->sNominalPointSize;
  }
  else {
    return TRUE;
  }
}


static INT FontResolutionFunction(const void *Dummy ,const void *pfmold)
{
  //Recast - BSC
  const PFONTMETRICS pfm = (const PFONTMETRICS) pfmold;
  //Removed Dummy - BSC
  if (pfm->sXDeviceRes <= (SHORT) lHorzFontRes &&
      pfm->sYDeviceRes <= (SHORT) lVertFontRes &&
                 pfm->fsSelection == 0x00        ){   //Normal Font.
      //
      //  AveCharWidth closer to 1/10in than previous value
      //
      if (abs((SHORT) (pfm->lAveCharWidth - lPelsPerInch/10))
          < abs((SHORT) (AveFontCharWidth - lPelsPerInch/10))){
          //
          // Set values to create logical font with
          //

         lMyFontMatchNumber = pfm->lMatch;
         AveFontCharWidth = pfm->lAveCharWidth;
         usMyFontPointSize=pfm->sNominalPointSize;
         strcpy (MyFontFaceName, pfm->szFacename);
         strcpy (MyFontFamilyname, pfm->szFamilyname);
      } /* endif */
  } /* endif */

  return TRUE;

}


 /***************************************************************************
 *\\ddd
 * Routine name:  new_set_delta()
 *
 * Purpose:
 *            This is the initialization routine that sets the following
 *            global variables for use in formatting output to the proper
 *            screen or printer location.  Sets:
 *                 dev_width  - device width
 *                 dev_height - device height
 *                 hori_pels_per_m- horizontal resolution
 *                 vert_pels_per_m- vertical resolution
 *                 pg_size_x      - horizontal page size in smallest whole inch
 *                 pg_size_y      - vertical page size in smallest whole inch
 *
 *
 * System Requirements:  None
 *
 * Revision Log:  11/28/90, PDVT, Kim Cairns
 *                               - initial module completion
 *
 * Inputs:
 *            hPS                 - presentation space handle
 *
 * Outputs:
 *            hDC                 - device context handle
 *
 * Subroutines Required:
 *            None
 *
 * Limitations:
 *            None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  use DevQueryCaps() to get:
 *    dev_width
 *    dev_height
 *    hori_pels_per_m
 *    vert_pels_per_m
 *  and calculate:
 *    pg_size_x
 *    pg_size_y
 *  use GpiQueryPS() to get:
 *    pg_width
 *    pg_height
 *
 *\\end
 ***************************************************************************/

HDC new_set_delta(HPS hPS)
{
    ULONG  flOptions;
    SIZEL  sizlPS;
    HDC    hDC;

         hDC = GpiQueryDevice(hPS);

         dev_width=alDevCaps[CAPS_WIDTH];

         dev_height=alDevCaps[CAPS_HEIGHT];

         hori_pels_per_m=alDevCaps[CAPS_HORIZONTAL_RESOLUTION];

         vert_pels_per_m=alDevCaps[CAPS_VERTICAL_RESOLUTION];

    // page size in whole inches, first get resolution of device
    x_units_per_inch=alDevCaps[CAPS_HORIZONTAL_FONT_RES];
    y_units_per_inch=alDevCaps[CAPS_VERTICAL_FONT_RES];

    // if device is a display don't count on font resolution being accurate
    if DeviceIsPrinter(){
      pg_size_x = dev_width / x_units_per_inch;
      pg_size_y = dev_height / y_units_per_inch;
    }
    else {
      pg_size_x = (LONG)( ( (double)dev_width * 10000.0 ) /
                         ( (double)hori_pels_per_m * 254.0 ) );
      pg_size_y = (LONG)( ( (double)dev_height * 10000.0 ) /
                         ( (double)vert_pels_per_m * 254.0 ) );
    }

    // get presentation space size
    flOptions = GpiQueryPS(hPS, &sizlPS);
    pg_width = sizlPS.cx;
    pg_height = sizlPS.cy;

    CommonXMult=0.000254*pg_width *hori_pels_per_m;
    CommonYMult=0.000254*pg_height *vert_pels_per_m;

    delta_x=100;
    delta_y=100;

         return(hDC);                                                                                    // device context handle
}


/***************************************************************************
 *\\ddd
 * Routine Name: SetEnter()
 *
 * Purpose:  This function will do call some functions to
 *           initialize variables that are used within this subentry point.
 *           This function is used when testing for return codes.
 *
 * System Requirements: None
 *
 * Revision Log: 03/04/91, PDVT, D.K. McCombs
 *               -initial creation
 * Inputs:
 *   hWndClient     //client window handle
 *   ErrorToCheck   // Indicate which error message we testing for.
 *   addedmessga   // Additional message.
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *  None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Print a Message to the log file indicating Set Up functions
 *   Are to follow.
 * }
 *\\end
 ***************************************************************************/
VOID SetEnter(HWND hWndClient, CHAR * text1, CHAR * text2)
{
 CHAR  achLogLine[200];

   strcpy(ieStorage, text1);
        if (text2){
     strcat(ieStorage," ");
     strcat(ieStorage, text2);
   }
        sprintf(achLogLine,SET_SPEC,ieStorage);
        CWRITELOG(L_LOTRACE,0,achLogLine);
        return;

}
/***************************************************************************
 *\\ddd
 * Routine Name: SetExit()
 *
 * Purpose:  This function will print needed information before
 *           exiting the current subentry point. This function is used
 *           when testing for return codes.
 *
 *
 * System Requirements: None
 *
 * Revision Log: 03/04/91, PDVT, D.K. McCombs
 *               -initial creation
 * Inputs:
 *   hWndClient     //client window handle
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *   None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Print a Message indicating that Set Up functions have completed.
 * }
 *\\end
 ***************************************************************************/

VOID SetExit(HWND hWndClient)
{
 CHAR  achLogLine[200];

        sprintf( achLogLine, SET_EXIT_SPEC, ieStorage );
   CWRITELOG(L_LOTRACE,0,achLogLine);
   return;

}




/***************************************************************************
 *\\ddd
 * Routine Name: ErrStatus()
 *
 * Purpose:  This function will do call some functions to
 *           initialize variables that are used within this subentry point.
 *           This function is used when testing for return codes.
 *
 * System Requirements: None
 *
 * Revision Log: 03/04/91, PDVT, D.K. McCombs
 *               -initial creation
 * Inputs:
 *   hWndClient     // client window handle.
 *   bFailOption    // option to check for pass / fail.
 *   text1, text2         // two text strings passed to log.
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *  None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *       Initialize a static variable "lComparison" for comparison to errorcount
 *       Build the text string from two strings and a space.
 *       If no text then syncronize lComparison to ErrorCount and return true.
 *       If the failoption is TRUE:
 *              if Errorcount is not equal to lComparison:
 *                set bPassFail to 0    and log failure.
 *              or else
 *                        set bPassFail to 1 and log pass.
 *  If the failoption is FALSE:
 *      log an informational message with a * in front of it.
 *
 *   LOGGING LEVEL IS LEVEL 7, L_TRACE.
 *
 * }
 *\\end
 ***************************************************************************/
BOOL ErrorStatus(HWND hWndClient, LONG  ErrorCount, BOOL bFailOption, CHAR * text1, CHAR * text2)
{
        CHAR  LogLine[100];
        CHAR  LogLine2[100];
        static LONG lComparison = 0;
        BOOL bPassFail;

   if ( text1 )
                {

                strcpy( LogLine2, text1);
                if (text2)
                        {
                strcat( LogLine2," ");
                strcat( LogLine2,text2);
                }               // end if text2

                if ( bFailOption )
                        {                                                                                                       //check for failure option,

                        if (lComparison != ErrorCount)
                                {                                                                                               // Failed: log as failed
                                bPassFail = TRUE;                                                       // Set return to TRUE.
                                sprintf( LogLine,ERR_FAIL_SPEC, LogLine2);
                                }  // end if

                        else
                                {                                                                                                 // Pass: log as pass
                                bPassFail = FALSE;                                                // Set return FALSE
                                sprintf( LogLine,ERR_PASS_SPEC, LogLine2);
                                }       // end else

                        CWRITELOG(L_TRACE,0, LogLine);

                        }       //      end if (text1or2)

                else
                        {                                                                                               // information logging.
                        bPassFail = 1;
                        sprintf( LogLine,STAT_INFO_SPEC, LogLine2);
                        CWRITELOG(L_TRACE, 0,  LogLine);
                        }       // end else

                } // end if bFailOption

        else
                {
                bPassFail = FALSE;
                }                               // end else no text

   lComparison = ErrorCount;
        return (bPassFail) ;

}

/***************************************************************************
 *\\ddd
 * Routine Name: LogInfo()
 *
 * Purpose:  This function will print needed information to ptt_log
 *           In formatted paragraph form.
 *
 *
 *
 * System Requirements: None
 *
 * Revision Log: 03/04/91, PDVT, D.K. McCombs
 *               -initial creation
 * Inputs:
 *   hWndClient     //client window handle
 *
 * Outputs:
 *   None.
 *
 * Subroutines Required:
 *   None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Print information to ptt_log in formatted paragraph form.
 *   LOGGING LEVEL IS VARIABLE.
 * }
 *\\end
 ***************************************************************************/

VOID LogInfo(HWND hWndClient, SHORT LogOption, CHAR * TypeFlag, CHAR  * TextToLog )
{
        CHAR LogEntry[100];
        CHAR ptest[100];
        LONG MainVar, SubVar, WhitePos, Maxsize, LineNum;
        WhitePos = 0L;
        SubVar = 0L;
        MainVar = 0L;
        LineNum = 0L;
        Maxsize = 50L;


        while ( TextToLog[MainVar] )
                {

                ptest[SubVar] = TextToLog[MainVar];
                ptest[SubVar+1]='\0';

                if (isspace(ptest[SubVar])) WhitePos = SubVar;

                if ( ptest[SubVar] == '\n' || SubVar == Maxsize )
                        {

                        if (WhitePos && ptest[SubVar] != '\n')
                                {
                                MainVar = MainVar - SubVar + WhitePos;
                                SubVar = WhitePos;
                                ptest[SubVar] = '\0';
                                SubVar = -1L;
                                sprintf(LogEntry, LOG_SPEC,TypeFlag, ptest);
                                }

                        else
                                {

                                if (ptest[SubVar] == '\n') ptest[SubVar] = '\0';
                                sprintf(LogEntry, LOG_SPEC,TypeFlag, ptest);
                                SubVar = -1L;
                                }

                        CWRITELOG(LogOption, 0, LogEntry);
                        LineNum++;
                        }

                MainVar++;
                SubVar++;
                }

        sprintf(LogEntry, LOG_SPEC,TypeFlag, ptest);
        CWRITELOG(LogOption, 0, LogEntry);
}


/***************************************************************************
 *\\ddd
 * Routine Name: EzQueryFont
 *
 * Purpose:  The purpose of this function is to Query and store all the
 *           fonts supported By current device. If none is supported,
 *           The Graphic Engine fonts are retreived.
 *
 * System Requirements: NONE
 *
 * Revision Log: 12/18/90, PDVT, Mike Abuzant \
 *               - Function implementation.    \ For GreTxtst.dll
 *               12/24/90, PDVT, Mike Abuzant  /
 *               - Function Design            /
 *
 *               1/3/91, PDVT, Darin C. Hafer \
 *               - Function Re-implementation. \ For GpiFnt1.dll
 *               1/4/91, PDVT, Darin C. Hafer  /
 *               - Function Re-Design         /
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    Count          //Number of font found
 *    FontStorage    // Array of fonts names and match numbers.
 *
 *
 * Outputs:
 *    1. All font facenames and match numbers are returned in the
 *       dynamically allocated array 'FontStorage'.
 *    2. The number of fonts found are returned in 'Count'.
 *
 * Subroutines Required:
 *  None
 *
 * Limitations:
 *
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *    // Get the Device Context associated with Presentation Space.
 *      hDC=GpiQueryDevice(hPS) ....
 *
 *    // Get the current device Character horizontal resl.
 *       DevQueryCaps(hDC,CAPS_HORIZONTAL_FONT_RES,1L,&Hori_res)
 *
 *    // Get the current device Character vertical resl.
 *        DevQueryCaps(hDC,CAPS_VERTICAL_FONT_RES,1L,&Vert_res)
 *
 *
 *     Setup condition to query number of fonts supported by current device
 *     by passing a value of zero in the parameter 'Requested'.
 *
 *       Number=GpiQueryFonts(,,,&(Requested=0),,)
 *
 *     Allocate enough storage hold the all the metrics of all fonts.
 *     and return with an error if could not allocate storage.
 *
 *         pfm=malloc(Number*sizeof(fm));
 *
 *     Query all font metrics supported by current device
 *
 *         GpiQueryFonts(hPS,QF_PUBLIC,NULL,&Number,
 *                       (LONG)sizeof(FONTMETRICS), pfm)
 *
 *
 *     // For all the fonts found, return the Facename and Match
 *     // numbers via FontStorage.
 *
 *     FOR (All the fonts queried ) Do
 *
 *          //Allocate storage to new font
 *
 *       increment the font counter.
 *       store the font facename and match number in the array 'FontStorage'
 *
 *     ENDDO
 *
 *\\end
 ***************************************************************************/
BOOL EzQueryFonts(HPS hPS, HWND hWndClient, LONG Enum, PLONG Count ,
                  PTEMPTYPE *FontStorage)
{
  HDC    hDC;
  FONTMETRICS   *pfm;
  LONG          Hori_res,
                Vert_res,
                Returned=0L,
                Requested=0L,
                Number;
  SHORT         Index;
  LONG          lSize;
  TEMPTYPE      *TempType;
  LONG          lTestSize;


  lSize = sizeof(FONTMETRICS);



//Get device context associated of Presentation Space.

   if ((hDC = GpiQueryDevice(hPS)) == HDC_ERROR) {
       REPORTSETUPERROR("GpiQueryDevice()");
       return FALSE;
   }

   //Get the device horizontal character resolution.

   if (DevQueryCaps(hDC,CAPS_HORIZONTAL_FONT_RES,1L,&Hori_res) == FALSE) {
        REPORTSETUPERROR("DevQueryCaps()");
        return FALSE;
   }

   //Get the device vertical character resolution.

   if (DevQueryCaps(hDC,CAPS_VERTICAL_FONT_RES,1L,&Vert_res) == FALSE) {
        REPORTSETUPERROR("DevQueryCaps()");
        return FALSE;
   }

   //Get total number of fonts supported by the current device

   if ((Number = GpiQueryFonts(hPS,Enum,NULL,
                               &Requested, (LONG) NULL, NULL)) == GPI_ALTERROR) {
       REPORTSETUPERROR("GpiQueryFonts() # 1");
       return(FALSE);
   }


   // Allocate storage for "Number" fonts

                         //was malloc

    if( Number != 0L ) {

     if ((pfm=(PFONTMETRICS)malloc((SHORT)Number*sizeof(FONTMETRICS)))==NULL){
         REPORTSETUPERROR("malloc()");
         return FALSE;
     }
   }
   else
      CWRITELOG(L_LOTRACE,0,"Number of Fonts found in EZQueryFonts was 0\n");




   // Call GpiQueryFonts again to request "Number" fonts and their
   // metrics to be returned in the space pointed to by "pfm"

   if ((Returned = GpiQueryFonts(hPS,Enum,NULL,
                               &Number,
                               lSize,
                               pfm)) == GPI_ALTERROR){
     REPORTSETUPERROR("GpiQueryFonts() # 2");
     free(pfm);
     return(FALSE);
   }

            *Count = Number;




    lTestSize = sizeof(TEMPTYPE);

  // For each font, allocate space for the Facename and Match
  // number and FontStorage will point to it.

        if ((TempType=(TEMPTYPE *)malloc((size_t)(Number*sizeof(TEMPTYPE))))
                                                                    ==NULL){
                REPORTSETUPERROR("malloc()");
                free(pfm);
                return FALSE;
        }

        *FontStorage=TempType;

        for(Index = 0; Index < (SHORT)Number ; Index++){
           if( (Index != 315) && (Index != 630) && (Index != 945) && (Index != 1260) ) {
                strcpy(TempType[Index].Fontname,pfm[Index].szFacename);
                TempType[Index].lMatch=pfm[Index].lMatch ;
                TempType[Index].fsSelection=pfm[Index].fsSelection;
                TempType[Index].usCodePage=pfm[Index].usCodePage;
                TempType[Index].fsFontUse=0;
                if (pfm[Index].fsDefn == FM_DEFN_OUTLINE)
                        TempType[Index].fsFontUse|=FATTR_FONTUSE_OUTLINE;
                if (pfm[Index].fsCapabilities == FM_CAP_NOMIX)
                        TempType[Index].fsFontUse|=FATTR_FONTUSE_NOMIX;
           }         //TSS temp add else
           else {
                strcpy(TempType[Index].Fontname,pfm[Index-1].szFacename);
                TempType[Index].lMatch=pfm[Index-1].lMatch ;
                TempType[Index].fsSelection=pfm[Index-1].fsSelection;
                TempType[Index].usCodePage=pfm[Index-1].usCodePage;
                TempType[Index].fsFontUse=0;
                if (pfm[Index].fsDefn == FM_DEFN_OUTLINE)
                        TempType[Index].fsFontUse|=FATTR_FONTUSE_OUTLINE;
                if (pfm[Index].fsCapabilities == FM_CAP_NOMIX)
                        TempType[Index].fsFontUse|=FATTR_FONTUSE_NOMIX;
           }




        }





  free(pfm);
  return TRUE;
}




/***************************************************************************
 *\\ddd
 * Routine Name: EzCreateLogicalFont()
 *
 * Purpose:  The purpose of this function is to realize a logical font
 *          of a known face name and font matching number.
 *
 * System Requirements: NONE
 *
 * Revision Log: 12/18/90, PDVT, Mike Abuzant \
 *               - Function implementation.    \ For GreTxtst.dll
 *               12/24/90, PDVT, Mike Abuzant  /
 *               - Function Design            /
 *
 *               1/3/91, PDVT, Darin C. Hafer \
 *               - Function Re-implementation. \ For GpiFnt1.dll
 *               1/4/91, PDVT, Darin C. Hafer  /
 *               - Function Re-Design         /
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    Lcid           // Local indentifier
 *    fsSelection    // Kind of font needed (Italic ,Bold ...)
 *    FontStorage    // Font name and match number.
 *
 *
 * Outputs:
 *    A new logical font associated with a local identifier (lcid).
 *
 * Subroutines Required:
 *  None
 *
 * Limitations:
 *  None
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *    Store the logical font face name, match number,and selection type
 *    into the structure 'fat' that will be passed as a parameter to the
 *    function GpiCreateLogFont().
 *
 *    //Create the desired logical font
 *
 *      GpiCreateLogFont(hDC,Name,lcid,&fat);
 *
 *     return TRUE if the logical font has been created or
 *            FALSE otherwise.
 *\\end
 ***************************************************************************/

LONG EzCreateLogicalFonts(HPS hPS, HWND hWndClient, LONG lcid,
                                         TEMPTYPE FontStorage)
{

  static FATTRS   Fattr;
  STR8     Name;
  LONG     ReturnCode;


  // Set up the FATTRS structure with appropriate values
  // that you need to pass to GpiCreateLogFont

    Fattr.usRecordLength = sizeof(Fattr);
    Fattr.fsSelection    = FontStorage.fsSelection;
    Fattr.lMatch         = FontStorage.lMatch;
         Fattr.fsType                    = FATTR_TYPE_KERNING;
    Fattr.fsFontUse      = FontStorage.fsFontUse;
         Fattr.usCodePage                = FontStorage.usCodePage;
    strcpy(Fattr.szFacename,FontStorage.Fontname);
    strcpy(Name, "Testing");

    if ((ReturnCode=GpiCreateLogFont(hPS,(PSTR8)Name,lcid,&Fattr))==GPI_ERROR)
         REPORTSETUPERROR("GpiCreateLogFont");

  return ReturnCode;

}
