#ifndef STD_UTIL_H
#define STD_UTIL_H

/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module name:  STD_UTIL
 *
 * Purpose:  Include file for STD_UTIL.C.
 *
 * Revision Log: 01/08/91, PDVT, Frederik Johannessen
 *                     - initial creation
 *               01/22/91, PDVT, Donna Williams
 *                     - converted from std_wrt.h to std_util.h
 *
 * SRS References:  NONE.
 *
 * Contents: This file contains the following definitions:
 *           - function prototypes
 *           - global variable declarations
 *           - function prototype
 *
 * Limitations: none
 *
 *\\end
****************************************************************************/

LONG   height_in_pels, width_in_pels, hori_pels_per_m, vert_pels_per_m;
LONG   delta_x, delta_y, pg_size_x, pg_size_y, line_space;
HDC    set_delta(HPS hPS);

VOID  APIENTRY MapAndWriteString(HPS hPS, LONG x, LONG y, char *out_str);
VOID  APIENTRY WriteString(HPS hPS, LONG x, LONG y, char *out_str);
extern LONG bad_error(HWND hWndClient,
                     CHAR *func_name, BOOL do_return, CHAR *entry_point);
VOID  APIENTRY MapArrayOfPoints (int num_pts, POINTL aptl[]);

#define BADERROR(FUNCNAME,DORETURN,ENTRYPOINT) \
        (LONG) bad_error(hWndClient, FUNCNAME, DORETURN, ENTRYPOINT)

BOOL EzfQueryFonts(HPS hPS);
LONG EzfCreateLogFont(HPS hPS, LONG lcid, USHORT idFace, USHORT idSize,
                               USHORT fsSelection);
BOOL QueryCourFonts(HPS hPS);
LONG CreateCourFont(HPS hPS, LONG lcid);

#define FONTFACE_SYSTEM   0
#define FONTFACE_COUR     1
#define FONTFACE_HELV     2
#define FONTFACE_TIMES    3

#define FONTSIZE_8        0
#define FONTSIZE_10       1
#define FONTSIZE_12       2
#define FONTSIZE_14       3
#define FONTSIZE_18       4
#define FONTSIZE_24       5

#endif
