#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#define INCL_ERRORS    // PM error definitions

#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include "PTTDLLDF.h"  // test case defines
#include "std_util.h"  // map, write, and delta functions

/****************************************************************************
 *\\ddd
 * Routine Name: line_type()
 *
 * Purpose: This function tests the functionality of the following APIs:
 *          GpiLine(), GpiSetCurrentPosition(), GpiSetLineType(), and
 *          GpiQueryLineType().
 *
 * System Requirements: Section 5.12.3
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               10/29/90, PDVT, Donna Williams
 *                     - testcase design
 *               11/01/90, PDVT, Donna Williams
 *                     - design implementation
 *               11/19/90, PDVT, Donna Williams
 *                     - redesign
 *
 * Inputs:  hPS            - presentation space
 *          hWndClient     - client window handle
 *          SelectionCall  - selection indicator
 *
 * Outputs: None.
 *
 * Subroutines Required: CWRITELOG(), TEST_SIGNAUTRE(), LOG_SIGNATURE,
 *                       set_delta(), MapPt(), BADERROR().
 *
 * Limitations: None.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *       for(every line type){
 *         // test functionality of GpiSetCurrentPosition
 *         GpiSetCurrentPosition(...);
 *        // test functionality of GpiSetLineType
 *        GpiSetLineType(...);
 *        // test functionality of GpiLine
 *        GpiLine(...);
 *        // test functionality of GpiQueryLineType and compare results
 *        GpiQueryLineType(...);
 *        // if there are any errors report these with BADERROR
 *      }
 * }
 *\\end
 ***************************************************************************/
VOID line_type(HPS hPS, HWND hWndClient)
{
  POINTL   ptl,
           EndPoint;
  LONG     LineType,
           lErrorCount;
  CHAR     out_string[100];

  lErrorCount = 0L;
  set_delta(hPS);
  LOG_SIGNATURE;
  TEST_SIGNATURE(0,0);
  CWRITELOG(L_LOTRACE,0,"+ee+ GpiLineExh - Entry.\n");

  sprintf(out_string,"Tests: GpiLine, GpiSetCurrentPosition");
  MapAndWriteString(hPS,(4*delta_x),(6*delta_y),out_string);
  sprintf(out_string,"       GpiSetLineType, GpiQueryLineType");
  MapAndWriteString(hPS,(4*delta_x),(6*delta_y-250),out_string);

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,0L,(delta_y-250),"DEFAULT");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test1 - Entry.\n");
  ptl.x = delta_x / 2;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test1 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test1 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_DEFAULT)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test1 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test1 - Entry.\n");
  EndPoint.x = delta_x / 2;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 3 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = 3 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 0;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test1 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test1 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test1 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(2*delta_x),(delta_y-250),"DOT");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test2 - Entry.\n");
  ptl.x = 5 * delta_x / 2;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test2 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  // TSS... the previous line was missing a '/' which I added to
  //        end the comment.  Before I added this, the code which
  //        set the line to type DOT was also commented out.

  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test2 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_DOT)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test2 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test2 - Entry.\n");
  EndPoint.x = 5 * delta_x / 2;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 2 * delta_x;
  ptl.y = 3 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",FALSE,"GpiLineExh");
    return;
  }
  EndPoint.x = 3 * delta_x;
  EndPoint.y = 3 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 2 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 3 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 3 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 2 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test2 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test2 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test2 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(4*delta_x),(delta_y-250),"SHORTDASH");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test3 - Entry.\n");
  ptl.x = 9 * delta_x / 2;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test3 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test3 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_SHORTDASH)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test3 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test3 - Entry.\n");
  EndPoint.x = 9 * delta_x / 2;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 4 * delta_x;
  ptl.y = 3 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 5 * delta_x;
  EndPoint.y = 3 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 4 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 5 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 5 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 4 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test3 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test3 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test3 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(6*delta_x),(delta_y-250),"DASHDOT");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test4 - Entry.\n");
  ptl.x = 13 * delta_x / 2;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test4 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test4 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_DASHDOT)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test4 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test4 - Entry.\n");
  EndPoint.x = 13 * delta_x / 2;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 6 * delta_x;
  ptl.y = 3 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 7 * delta_x;
  EndPoint.y = 3 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 6 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 7 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 7 * delta_x;
  ptl.y = 2 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 6 * delta_x;
  EndPoint.y = delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test4 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test4 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test4 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,0L,(5*delta_y-250),"DOUBLEDOT");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test5 - Entry.\n");
  ptl.x = delta_x / 2;
  ptl.y = 6 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test5 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test5 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_DOUBLEDOT)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test5 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test5 - Entry.\n");
  EndPoint.x = delta_x / 2;
  EndPoint.y = 5 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 11 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = 11 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 6 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = 5 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = delta_x;
  ptl.y = 6 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 0;
  EndPoint.y = 5 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test5 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test5 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test5 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,0L,(3*delta_y-250),"LONGDASH");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test6 - Entry.\n");
  ptl.x = delta_x / 2;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test6 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test6 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_LONGDASH)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test6 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test6 - Entry.\n");
  EndPoint.x = delta_x / 2;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 7 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = 7 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 0;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 0;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test6 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test6 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test6 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(2*delta_x),(3*delta_y-250),"DASHDOUBLEDOT");

  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test7 - Entry.\n");
  ptl.x = 5 * delta_x / 2;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test7 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test7 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_DASHDOUBLEDOT)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test7 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test7 - Entry.\n");
  EndPoint.x = 5 * delta_x / 2;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 2 * delta_x;
  ptl.y = 7 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 3 * delta_x;
  EndPoint.y = 7 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 2 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 3 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 3 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 2 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test7 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test7 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test7 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(4*delta_x),(3*delta_y-250),"SOLID");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test8 - Entry.\n");
  ptl.x = 9 * delta_x / 2;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test8 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test8 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_SOLID)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test8 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test8 - Entry.\n");
  EndPoint.x = 9 * delta_x / 2;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 4 * delta_x;
  ptl.y = 7 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 5 * delta_x;
  EndPoint.y = 7 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 4 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 5 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 5 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 4 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test8 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test8 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test8 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(6*delta_x),(3*delta_y-250),"ALTERNATE");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test9 - Entry.\n");
  ptl.x = 13 * delta_x / 2;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test9 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test9 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_ALTERNATE)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test9 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test9 - Entry.\n");
  EndPoint.x = 13 * delta_x / 2;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 6 * delta_x;
  ptl.y = 7 * delta_y / 2;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 7 * delta_x;
  EndPoint.y = 7 * delta_y / 2;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 6 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 7 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  ptl.x = 7 * delta_x;
  ptl.y = 4 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  EndPoint.x = 6 * delta_x;
  EndPoint.y = 3 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test9 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test9 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test9 - Exit.\n");

  /*
   * Test the functionality of GpiSetCurrentPosition.
   */
  MapAndWriteString(hPS,(2*delta_x),(5*delta_y-250),"INVISIBLE");
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetCurrentPosition Test10 - Entry.\n");
  ptl.x = 5 * delta_x / 2;
  ptl.y = 6 * delta_y;
  MapPt(ptl);
  if(!GpiSetCurrentPosition(hPS,&ptl)){
    BADERROR("GpiSetCurrentPosition",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetCurrentPosition Test10 - Exit.\n");

  /*
   * Test the functionality of GpiSetLineType.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiSetLineType Test10 - Entry.\n");
  if(!GpiSetLineType(hPS,LINETYPE_INVISIBLE)){
    lErrorCount += BADERROR("GpiSetLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiSetLineType Test10 - Exit.\n");

  /*
   * Test the functionality of GpiLine.
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiLine Test10 - Entry.\n");
  EndPoint.x = 5 * delta_x / 2;
  EndPoint.y = 5 * delta_y;
  MapPt(EndPoint);
  if(!GpiLine(hPS,&EndPoint)){
    BADERROR("GpiLine",TRUE,"GpiLineExh");
    return;
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiLine Test10 - Exit.\n");

  /*
   * Test the Functionality of GpiQueryLineType
   */
  CWRITELOG(L_LOTRACE,0,"+ie+ GpiQueryLineType Test10 - Entry.\n");
  LineType = GpiQueryLineType(hPS);
  if(LineType == LINETYPE_ERROR){
    lErrorCount += BADERROR("GpiQueryLineType",FALSE,NULL);
  }
  CWRITELOG(L_LOTRACE,0,"+ix+ GpiQueryLineType Test10 - Exit.\n");
  GpiSetLineType(hPS,LINETYPE_DEFAULT);

  if(!lErrorCount){
     CWRITELOG(L_HDR,0,"$GpiLineExh                                                     -    PASS.\n");
  }
  else{
     sprintf(out_string,"$ERRORCOUNT = %d\n",lErrorCount);
     CWRITELOG(L_HDR,0,out_string);
     CWRITELOG(L_HDR,0,"$GpiLineExh                                                     -    FAIL.\n");
  }
  CWRITELOG(L_LOTRACE,0,"+ex+ GpiLineExh - Exit.\n");

}
