PROJ = gpiimage
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ge- /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

IMPLIB = implib/NOIGNORECASE

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = gpiimage.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = gpiimage.DEF

OBJS  = gpiimage.obj   gpi_grid.obj  \
        std_util.obj  stdutil2.obj \
        pttdllvr.obj

.dll.lib:
        $(IMPLIB) $*.lib $*.dll

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).dll

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc


gpiimage.obj: gpiimage.c gpiimage.h pttdlldf.h std_util.h
    $(compile) /Fo$@ gpiimage.c

gpi_grid.obj: gpi_grid.c
    $(compile) /Fo$@ gpi_grid.c

std_util.obj: std_util.c
    $(compile) /Fo$@ std_util.c

stdutil2.obj: stdutil2.c
    $(compile) /Fo$@ stdutil2.c

pttdllvr.obj: pttdllvr.c
    $(compile) /Fo$@ pttdllvr.c

gpiimage.dll: $(OBJS)
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),gpiimage.dll,gpiimage.map,$(LLIBS),gpiimage.def


