#define INCL_WIN
#define INCL_GPI
#define INCL_DEV
#define INCL_DOS
#define INCL_ERRORS   // include all error definitions
#define INCL_DOSINFOSEG
#define MAINSOURCEFILE
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <malloc.h>
#include <search.h>
#include "PTTDLLDF.h"                // test case defines
#include "common.h"
#include "GPIFONT.h"                 // gre text dll include file

/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: GPIFONT
 *
 * Purpose: This module is called by the PTT to test the first part of the
 *          GPI Font API's.
 *
 * Revision Log: 12/28/90, PDVT, Darin C. Hafer
 *                 -Test Case Design.
 *
 *
 * Design Overview:
 *
 *    This testcase is designed to test some of the Gpi text functions
 *    that:
 *
 *    1. Determine whether a given file is a font resource file.
 *       - GpiQueryFontFileDescriptions()
 *    2. Query the font metrics for the current logical font.
 *       - GpiQueryFontMetrics()
 *    3. Query the font metrics for all available fonts, or for the fonts
 *       you specify by facename.
 *       - GpiQueryFonts()
 *    4. Load one or more fonts from the specified resource file.
 *       - GpiLoadFonts()
 *    5. Unload and font(s) previously loaded from the resource file.
 *       - GpiUnloadFonts()
 *    6. Create a logical definition of a font that an application
 *       requires to use.
 *       - GpiCreateLogFont()
 *    7. Query kerning pair info. for the logical font identified by the
 *       current value of the character set attribute.
 *       - GpiQueryKerningPairs()
 *    8. Set the current value of the character-set attribute.
 *       - GpiSetCharSet()
 *    9. Query the character-set lcid.
 *       - GpiQueryCharSet()
 *   10. Sets the code page ID for graphics characters for the default font.
 *       - GpiSetCp()
 *   11. Query the currently selected graphics code page.
 *       - GpiQueryCp()
 *   12. Query the fonts that have been created by GpiCreateLogFont, and
 *       tagged bit maps.
 *       - GpiQuerySetIds()
 *   13. Query the number of local identifiers currently in use, referring
 *       to fonts or bit maps.
 *       - GpiQueryNumberSetIds()
 *   14. Delete a logical font or bit-map tag.
 *       - GpiDeleteSetId()
 *   15. Query width table info. for the logical font identified by the
 *       value of the character-set attribute.
 *       - GpiQueryWidthTable()
 *   16. Query the device characteristics.
 *       - DevQueryCaps()
 *
 * Limitations:
 *
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\ddd
 * Routine Name: InitTest
 *
 * Purpose: Initialize function name and address array for ptt.
 *
 * System Requirements: NONE
 *
 * Revision Log: 01/2/90 ,PDVT, Darin C. Hafer
 *                 -Test Case Design.
 *
 * Inputs:
 *   sel           //passed through to the InitTestSegVars function
 *   init_info_p   // name and address array used by ptt interface
 *
 * Outputs:
 *   init_info_p   // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the ptt interface
 *
 * Limitations:
 *   init_info_p is of size ENTRYPOINTS defined in ptt.h and pttdlldf.h(both)
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\\ algorithm
 * {
 *    for all test functions in this test case {
 *      init_info_p->function name = function name[i]
 *      init_info_p->function address = function address[i]
 *    }
 *    call inittestsegvars routine
 * }
 *\\end
 *****************************************************************************/
VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO init_info_p)
{
  register USHORT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(sel);
  return;
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiFontApp1
 *
 * Purpose:
 *
 *
 *
 * System Requirements:
 *
 * Revision Log: 02/25/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  TEST_SIGNATURE
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *  The output of this testcase may differ from machine to machine.
 *  This is because the order in which fonts were added from the Control
 *  Panel is the order in which they are printed.
 *
 *  Also, if a user has more than 64K of fonts, this test case may trap.
 *  I didn't check for this but malloc may only allocate that much space.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Query to get the number of PUBLIC fonts.
 *   Allocate space for the fonts.
 *   Query the fonts again to retrieve the font metrics.
 *
 * PART 1
 *   For all PUBLIC fonts
 *     1) Set up FATTR structure.
 *     2) Create the logical font.
 *     3) If at the end of the sentence, print total width.
 *     4) If (end of the sentence) but we are at the last font,
 *        print the rest of the sentence in the last font and print
 *        total width.
 *     5) If not at last font, print character, increment total width
 *        counter, and delete the font.
 *   Endfor
 *
 * PART 2
 *   For the first 5 fonts returned
 *     1) Set up FATTR structure.
 *     2) Create the logical font.
 *     3) Set the character set.
 *     4) Query the character set, and print the value returned.
 *     5) Query the number of set ids, and print the value returned.
 *     6) Query the list of set ids, and print the list returned.
 *   Endfor
 *
 * PART 3
 *   For all .FON files added in the Control Panel
 *     1) Query the font file descriptions, and print the number
 *        of fonts in each file.
 *   Endfor
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiFontApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiFontApp1";
  HAB    hAB;
  HDC    hDC;
  CHAR *String=(CHAR *)NULL;
  CHAR   Path[200];
  CHAR   KeyName[100];
  INT    usMax = 200;
  INT    usReturn=0;
  LONG   PubFonts=0L,
         lReturned=0L,
         lIndex  =0L,
         lLoop   =0L,
         Width   =0L,
         TotalWidth=0L,
         Offset  =0L,
         xVal    =0L;
  BOOL   End = FALSE;
  PSTR8  pNames;
  PLONG  pTypes;
  PLONG  pLcids;
  static FATTRS Fattr;
  CHAR   Sentence[50];
  PFFDESCS pfNames;
//  PVOID    FileSelector;
  FONTMETRICS  *pfm;
  LONG        lSize;

  lSize = sizeof(FONTMETRICS);

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Initialize coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the points.
    MapPt(ptl);

    // Backup of initial left margin
    xVal = ptl.x;

    // HDC used in DevEscape call
    hDC = GpiQueryDevice(hPS);

    // Query PUBLIC fonts
    if ((lSuccess = GpiQueryFonts(hPS,
                                  QF_PUBLIC,
                                  NULL, &PubFonts,
                                  (LONG) NULL, NULL)) == GPI_ALTERROR)
      CLEANUP("GpiQueryFonts", EntryName);

    // Keep number of PUBLIC fonts
    PubFonts = lSuccess;

    //32 Allocate storage for "PubFonts" font metrics
    if ((pfm=(PFONTMETRICS)malloc((LONG)PubFonts*sizeof(FONTMETRICS)))==NULL)
        CLEANUP("malloc", EntryName);

    // Call GpiQueryFonts again to request "Number" fonts and their
    // metrics to be returned in the space pointed to by "pfm"
    if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,NULL,
                                  &PubFonts,
                                  (LONG)sizeof(FONTMETRICS),
                                  //was pfm without *
                                  pfm)) == GPI_ALTERROR){
      CLEANUP("GpiQueryFonts", EntryName);
      free(pfm);
    }

    sprintf(achLogLine, "%3ld PUBLIC fonts...", PubFonts);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= 2*syPosition;

    strcpy(Sentence, "This is Text in Many Unique Fonts.");

    for (lIndex=0; lIndex < PubFonts; lIndex++) {
      if( (lIndex != 315) && (lIndex != 630) && (lIndex != 945) && (lIndex != 1260) )
          lIndex++;  //TSS.....temp

        // Set up the FATTRS structure with appropriate values
        // that you need to pass to GpiCreateLogFont
        Fattr.usRecordLength = sizeof(Fattr);
        Fattr.lMatch         = pfm[lIndex].lMatch;
        strcpy(Fattr.szFacename,pfm[lIndex].szFacename);

        if ((lSuccess=GpiCreateLogFont(hPS,(PSTR8)"Darin",USER_LCID,&Fattr))==GPI_ERROR)
          CLEANUP("GpiCreateLogFont", EntryName);
        if (!GpiSetCharSet(hPS,USER_LCID))
          CLEANUP("GpiSetCharSet", EntryName);

        // If at the end of the output sentence and haven't gone through
        // all of the fonts, print the total width of the sentence and
        // start a new line.
        if ((Offset == (LONG) strlen(Sentence)) && (lIndex < PubFonts)){
          Offset=0L;
          if (!GpiSetCharSet(hPS,LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
          ptl.x += MapX(25);
          sprintf(achLogLine, "Total Width=%ld", TotalWidth);
          WorldWriteString(ptl.x, ptl.y, achLogLine);
          ptl.x  = xVal;
          ptl.y -= 2*syPosition;
          TotalWidth=0L;
          if (!GpiSetCharSet(hPS,USER_LCID))
            CLEANUP("GpiSetCharSet", EntryName);
        }

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
      if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
        if (!GpiSetCharSet(hPS,LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
        if (!GpiDeleteSetId(hPS,LCID_ALL))
          CLEANUP("GpiDeleteSetId", EntryName);
        EXIT_MAIN(EntryName);
        return;
      }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
      if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
        if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                                   0L, NULL, 0L, NULL)) == DEVESC_ERROR)
          CLEANUP("DevEscape", EntryName);
        if (!GpiSetCharSet(hPS, DESIRED_FONT_ID))
          CLEANUP("GpiSetCharSet", EntryName);
        TEST_SIGNATURE(0,0);
        ptl.y = MapY((LONG) (pg_size_y) * delta_y);
        ptl.y -= 2*syPosition;
        if (!GpiSetCharSet(hPS, USER_LCID))
          CLEANUP("GpiSetCharSet", EntryName);
      }

      // If not at the end of the output sentence but at the last font,
      // finish the sentence in the last font and print the total width
      // of the sentence and start a new line.
      if ((Offset < (LONG) strlen(Sentence)) && (lIndex == (PubFonts-1L))){
        End = TRUE;
        for ( ; Offset < (LONG) strlen(Sentence); Offset++) {

          // If the current character in the sentence is a space
          // character, print that character in the default font.
          if (Sentence[Offset] == 0x20) {
            if (!GpiSetCharSet(hPS,LCID_DEFAULT))
              CLEANUP("GpiSetCharSet", EntryName);
            sprintf(achLogLine, "%c", Sentence[Offset]);
            GpiCharStringAt(hPS, &ptl, (LONG)strlen(achLogLine), achLogLine);
            GpiQueryWidthTable(hPS, (LONG)Sentence[Offset], 1L, &Width);
            TotalWidth += Width;
            ptl.x += Width;
            Offset++;
            if (!GpiSetCharSet(hPS,USER_LCID))
              CLEANUP("GpiSetCharSet", EntryName);
          }

          sprintf(achLogLine, "%c", Sentence[Offset]);
          GpiCharStringAt(hPS, &ptl, (LONG)strlen(achLogLine), achLogLine);
          GpiQueryWidthTable(hPS, (LONG)Sentence[Offset], 1L, &Width);
          TotalWidth += Width;
          ptl.x += Width;
        }
          if (!GpiSetCharSet(hPS,LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
          if (!GpiDeleteSetId(hPS,USER_LCID))
            CLEANUP("GpiDeleteSetId", EntryName);
          ptl.x += MapX(25);
          sprintf(achLogLine, "Total Width=%ld", TotalWidth);
          WorldWriteString(ptl.x, ptl.y, achLogLine);
          ptl.x  = xVal;
          ptl.y -= 2*syPosition;
      }

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
      if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
        if (!GpiSetCharSet(hPS,LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
        if (!GpiDeleteSetId(hPS,LCID_ALL))
          CLEANUP("GpiDeleteSetId", EntryName);
        EXIT_MAIN(EntryName);
        return;
      }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
      if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
        if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                            0L, NULL, 0L, NULL)) == DEVESC_ERROR)
          CLEANUP("DevEscape", EntryName);
        if (!GpiSetCharSet(hPS, DESIRED_FONT_ID))
          CLEANUP("GpiSetCharSet", EntryName);
        TEST_SIGNATURE(0,0);
        ptl.y = MapY((LONG) (pg_size_y) * delta_y);
        ptl.y -= 2*syPosition;
        if (!GpiSetCharSet(hPS, LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
      }


      // If not at the last font and not at the end of the sentence, print
      // the character and increment the width counter.  If the character
      // is the space character, print it in the default font.
      if (!End) {
        if (Sentence[Offset] == 0x20) {
          if (!GpiSetCharSet(hPS,LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
          sprintf(achLogLine, "%c", Sentence[Offset]);
          GpiCharStringAt(hPS, &ptl, (LONG)strlen(achLogLine), achLogLine);
          GpiQueryWidthTable(hPS, (LONG)Sentence[Offset], 1L, &Width);
          TotalWidth += Width;
          ptl.x += Width;
          Offset++;
          if (!GpiSetCharSet(hPS,USER_LCID))
            CLEANUP("GpiSetCharSet", EntryName);
        }

        sprintf(achLogLine, "%c", Sentence[Offset]);
        GpiCharStringAt(hPS, &ptl, (LONG)strlen(achLogLine), achLogLine);
        GpiQueryWidthTable(hPS, (LONG)Sentence[Offset], 1L, &Width);
        TotalWidth += Width;
        ptl.x += Width;

        if (!GpiSetCharSet(hPS,LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
        if (!GpiDeleteSetId(hPS,USER_LCID))
          CLEANUP("GpiDeleteSetId", EntryName);

        Offset++;
      }
    }


    /*--------------------------------------------------------------------\
    | PART 2 - for the first five fonts, create one at a time, assign a   |
    | LCID, query the LCID, query the total number of LCIDs at the point, |
    | and query the list of all current LCIDs and output the returns from |
    | these queries.                                                      |
    \--------------------------------------------------------------------*/

    // Output a header

    ptl.x += MapX(350);
    strcpy(achLogLine, "QueryCharSet");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
    if DeviceIsDisplay()
      ptl.x += MapX(150);
    else
      ptl.x += MapX(120);
    strcpy(achLogLine, "QueryNumberSetIds");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
    if DeviceIsDisplay()
      ptl.x += MapX(210);
    else
    ptl.x += MapX(180);
    strcpy(achLogLine, "QuerySetIds");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x = xVal;
    ptl.y -= 2*syPosition;

    // Want to do only for the first five fonts
    if (PubFonts > 5) PubFonts = 5;

    for (lIndex=0; lIndex < PubFonts; lIndex++) {
      sprintf(achLogLine, "Creating %s",pfm[lIndex].szFacename);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x += MapX(370);

      // Set up the FATTRS structure with appropriate values
      // that you need to pass to GpiCreateLogFont
      Fattr.usRecordLength = sizeof(Fattr);
      Fattr.lMatch         = pfm[lIndex].lMatch;
      strcpy(Fattr.szFacename,pfm[lIndex].szFacename);

      if ((lSuccess=GpiCreateLogFont(hPS,(PSTR8)"Darin",lIndex+1,&Fattr))==GPI_ERROR)
        CLEANUP("GpiCreateLogFont", EntryName);
      if (!GpiSetCharSet(hPS,lIndex+1))
        CLEANUP("GpiSetCharSet", EntryName);

      if ((lSuccess=GpiQueryCharSet(hPS))==LCID_ERROR)
        CLEANUP("GpiQueryCharSet", EntryName);

      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);

      sprintf(achLogLine, "LCID= %ld",lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      // To make display output look as much like printer output,
      // the x coordinates will differ.
      if DeviceIsDisplay()
        ptl.x += MapX(150);
      else
        ptl.x += MapX(130);

      if ((lReturned=GpiQueryNumberSetIds(hPS))==GPI_ALTERROR)
        CLEANUP("GpiQueryNumberSetIds", EntryName);

      // Decrement the number returned if the device is a printer
      // because EnterMain creates a font automatically which I do
      // not want information on.
      if DeviceIsPrinter()
        lReturned--;

      sprintf(achLogLine, "# of LCIDs= %ld",lReturned);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      // To make display output look as much like printer output,
      // the x coordinates will differ.
      if DeviceIsDisplay()
        ptl.x += MapX(220);
      else
        ptl.x += MapX(180);

      if ((pTypes = (PLONG)malloc((SHORT)lReturned * sizeof(LONG))) == NULL)
        CLEANUP("malloc", EntryName);
      if ((pNames = (PSTR8)malloc((SHORT)lReturned * sizeof(STR8))) == NULL)
        CLEANUP("malloc", EntryName);
      if ((pLcids = (PLONG)malloc((SHORT)lReturned * sizeof(LONG))) == NULL)
        CLEANUP("malloc", EntryName);

      if (!GpiQuerySetIds(hPS, lReturned, pTypes, pNames, pLcids))
        CLEANUP("GpiQuerySetIds", EntryName);

      // Print the list of LCIDs
      for (lLoop=0; lLoop < lReturned; lLoop++) {
        sprintf(achLogLine, "%ld ",pLcids[lLoop]);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.x +=MapX(15);
      }

      // Free all allocated space
      free(pTypes);
      free(pNames);
      free(pLcids);

      ptl.x = xVal;
      ptl.y -=syPosition;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
      if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
        if (!GpiSetCharSet(hPS,LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
        if (!GpiDeleteSetId(hPS,LCID_ALL))
          CLEANUP("GpiDeleteSetId", EntryName);
        EXIT_MAIN(EntryName);
        return;
      }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
      if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
        if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                            0L, NULL, 0L, NULL)) == DEVESC_ERROR)
          CLEANUP("DevEscape", EntryName);
        if (!GpiSetCharSet(hPS, DESIRED_FONT_ID))
          CLEANUP("GpiSetCharSet", EntryName);
        TEST_SIGNATURE(0,0);
        ptl.y = MapY((LONG) (pg_size_y) * delta_y);
        ptl.y -= 2*syPosition;
        if (!GpiSetCharSet(hPS, LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
      }
    }
    ptl.y -=syPosition;


    for ( ; lIndex > 0; lIndex--) {
      sprintf(achLogLine, "Deleting %s",pfm[lIndex-1].szFacename);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x += MapX(370);

      if (!GpiSetCharSet(hPS,lIndex))
        CLEANUP("GpiSetCharSet", EntryName);

      if ((lSuccess=GpiQueryCharSet(hPS))==LCID_ERROR)
        CLEANUP("GpiQueryCharSet", EntryName);

      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);

      sprintf(achLogLine, "LCID= %ld",lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      // To make display output look as much like printer output,
      // the x coordinates will differ.
      if DeviceIsDisplay()
        ptl.x += MapX(150);
      else
        ptl.x += MapX(130);

      if ((lReturned=GpiQueryNumberSetIds(hPS))==GPI_ALTERROR)
        CLEANUP("GpiQueryNumberSetIds", EntryName);

      // Decrement the number returned if the device is a printer
      // because EnterMain creates a font automatically which I do
      // not want information on.
      if DeviceIsPrinter()
        lReturned--;

      sprintf(achLogLine, "# of LCIDs= %ld",lReturned);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      // To make display output look as much like printer output,
      // the x coordinates will differ.
      if DeviceIsDisplay()
        ptl.x += MapX(220);
      else
        ptl.x += MapX(180);

      if ((pTypes = (PLONG)malloc((SHORT)lReturned * sizeof(LONG))) == NULL)
        CLEANUP("malloc", EntryName);
      if ((pNames = (PSTR8)malloc((SHORT)lReturned * sizeof(STR8))) == NULL)
        CLEANUP("malloc", EntryName);
      if ((pLcids = (PLONG)malloc((SHORT)lReturned * sizeof(LONG))) == NULL)
        CLEANUP("malloc", EntryName);

      if (!GpiQuerySetIds(hPS, lReturned, pTypes, pNames, pLcids))
        CLEANUP("GpiQuerySetIds", EntryName);

      // Print the list of LCIDs
      for (lLoop=0; lLoop < lReturned; lLoop++) {
        sprintf(achLogLine, "%ld ",pLcids[lLoop]);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.x +=MapX(15);
      }

      if (!GpiDeleteSetId(hPS,lIndex))
        CLEANUP("GpiDeleteSetId", EntryName);

      // Free all allocated space
      free(pTypes);
      free(pNames);
      free(pLcids);

      ptl.x = xVal;
      ptl.y -=syPosition;

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
      if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
        if (!GpiSetCharSet(hPS,LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
        if (!GpiDeleteSetId(hPS,LCID_ALL))
          CLEANUP("GpiDeleteSetId", EntryName);
        EXIT_MAIN(EntryName);
        return;
      }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
      if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
        if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                            0L, NULL, 0L, NULL)) == DEVESC_ERROR)
          CLEANUP("DevEscape", EntryName);
        if (!GpiSetCharSet(hPS, DESIRED_FONT_ID))
          CLEANUP("GpiSetCharSet", EntryName);
        TEST_SIGNATURE(0,0);
        ptl.y = MapY((LONG) (pg_size_y) * delta_y);
        ptl.y -= 2*syPosition;
        if (!GpiSetCharSet(hPS, LCID_DEFAULT))
          CLEANUP("GpiSetCharSet", EntryName);
      }
    }
    ptl.y -= 2*syPosition;


    /*------------------------------------------------------------------\
    | PART 3 - Look for any FONT files from information in the OS2.ini  |
    | file and report how many fonts are in each file.                  |
    \------------------------------------------------------------------*/


    // Get Anchor Block handle for use in WinQueryProfile
    if ((hAB=WinQueryAnchorBlock(hWndClient)) == NULLHANDLE)
      CLEANUP("WinQueryAnchorBlock", EntryName);

    //Allocate a 64K segment
    //32 Memory Allocation
    DosAllocMem((PVOID)&String,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT);

    // Look for PM_Fonts in OS2.INI
    if (usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", NULL, "WIN Error",
                                     String,(ULONG)0xFFFF) <= 0)
      CLEANUP("PrfQueryProfileString", EntryName);

    lIndex=0L;

    // If the PM_Fonts is found, then String is a list of the Keynames.
    // Go through the list of Keynames to get Path, the path of the .FON file
    if (usReturn > 0) {

      // String will equal NULL when there are no more Keynames.
      while (String[lIndex]) {
        strcpy(KeyName, String+lIndex);
        if ((usReturn = PrfQueryProfileString(HINI_PROFILE,(PSZ)"PM_Fonts", (PSZ)KeyName,
                                              "Darin", (PSZ)Path, (LONG)sizeof(Path))) <= 0)
          CLEANUP("PrfQueryProfileString", EntryName);


        lReturned = 0L;
        if ((lSuccess = GpiQueryFontFileDescriptions(hAB, Path, &lReturned,
                                                     pfNames))==GPI_ALTERROR)
          CLEANUP("GpiQueryFontFileDescriptions", EntryName);

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
        if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
          if (!GpiSetCharSet(hPS,LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
          if (!GpiDeleteSetId(hPS,LCID_ALL))
            CLEANUP("GpiDeleteSetId", EntryName);
          EXIT_MAIN(EntryName);
          return;
        }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
        if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
          if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                              0L, NULL, 0L, NULL)) == DEVESC_ERROR)
            CLEANUP("DevEscape", EntryName);
          GpiSetCharSet(hPS, DESIRED_FONT_ID);
          TEST_SIGNATURE(0,0);
          ptl.y = MapY((LONG) (pg_size_y) * delta_y);
          ptl.y -= 2*syPosition;
          GpiSetCharSet(hPS, LCID_DEFAULT);
        }

        sprintf(achLogLine, "There are %2ld fonts in %s", lSuccess, Path);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -=syPosition;
        lIndex += strlen(KeyName) + 1;
      }
    }
    else if (usReturn == 0L) {
      ptl.y -=syPosition;
      sprintf(achLogLine, "There are %d FONT files ADDED"
                          " in the Control Panel", usReturn);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -=syPosition;
    }

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    // Delete all Logical Fonts;
    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    free(pfm);
    DosFreeMem(String);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiFontApp1  */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiFontApp2
 *
 * Purpose:
 *
 *
 *
 * System Requirements:
 *
 * Revision Log: 02/25/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *  This entrypoint doesn't do the actual call to DevQueryCaps.
 *  It is done in ENTER_MAIN, and I use the variable alDevCaps
 *  which is initialized there.  Also, if to the display, notice
 *  that it says the device is OD_DIRECT, but the test signature
 *  says it is OD_QUEUED - the test signature is wrong in this case.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   1) Use the "alDevCaps" array initialized in PTT but set to current
 *   values in EnterMain.
 *   2) Print the title of the DevCaps field, the value, and what it means.
 *
 *   Do 1 & 2 for  CAPS_FAMILY, CAPS_IO_CAPS, CAPS_TECHNOLOGY,
 *                 CAPS_ADDITIONAL_GRAPHICS, CAPS_RASTER_CAPS,
 *                 CAPS_HORIZONTAL_FONT_RES, CAPS_VERTICAL_FONT_RES
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiFontApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiFontApp2";
  LONG   lValue, xVal, xVal2;
  FILE *fptr;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);
    fptr = fopen("out","w");
    // Initialize coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the points.
    MapPt(ptl);

    xVal = ptl.x;


    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_FAMILY");
    lValue = alDevCaps[CAPS_FAMILY];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);

    fprintf(fptr,"lValue = %ld\n",lValue);
    switch ((int)lValue) {
      case 2:
         strcpy(achLogLine, "Device Type is OD_QUEUED");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 5:
         strcpy(achLogLine, "Device Type is OD_DIRECT");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 6:
         strcpy(achLogLine, "Device Type is OD_INFO");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 7:
         strcpy(achLogLine, "Device Type is OD_METAFILE");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 8:
         strcpy(achLogLine, "Device Type is OD_MEMORY");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 9:
         strcpy(achLogLine, "Device Type is OD_METAFILE_NOQUERY");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
    } /* End Switch */
    ptl.x = xVal;
    ptl.y -= syPosition;




    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_IO_CAPS");
    lValue = alDevCaps[CAPS_IO_CAPS];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);


    fprintf(fptr,"lValue = %ld\n",lValue);
    switch ((int)lValue) {
      case 1:
         strcpy(achLogLine, "This is a Dummy Device");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 2:
         strcpy(achLogLine, "Device Supports Output");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 3:
         strcpy(achLogLine, "Device Supports Input");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 4:
         strcpy(achLogLine, "Device Supports Input and Output");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;

    } /* End Switch */
    ptl.x = xVal;
    ptl.y -= syPosition;



    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_TECHNOLOGY");
    lValue = alDevCaps[CAPS_TECHNOLOGY];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);

    fprintf(fptr,"lValue = %ld\n",lValue);
    switch ((int)lValue) {
      case 0:
         strcpy(achLogLine, "Unknown Technology");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 1:
         strcpy(achLogLine, "Vector Plotter");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 2:
         strcpy(achLogLine, "Raster Display");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 3:
         strcpy(achLogLine, "Raster Printer");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 4:
         strcpy(achLogLine, "Raster Camera");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
      case 5:
         strcpy(achLogLine, "PostScript Device");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         break;
    } /* End Switch */
    ptl.x = xVal;
    ptl.y -= syPosition;



    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_ADDITIONAL_GRAPHICS  ");
    lValue = alDevCaps[CAPS_ADDITIONAL_GRAPHICS];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);
    xVal2 = ptl.x;


    fprintf(fptr,"lValue = %ld\n",lValue);
    if (lValue & CAPS_GRAPHICS_KERNING_SUPPORT) {
      strcpy(achLogLine, "Device Supports Kerning");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_FONT_OUTLINE_DEFAULT) {
      strcpy(achLogLine, "Default Font is an Outline Font");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_FONT_IMAGE_DEFAULT) {
      strcpy(achLogLine, "Default Font is an Image Font");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_SCALED_DEFAULT_MARKERS) {
      strcpy(achLogLine, "Markers Scales by Marker-Box Attribute");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    fptr = fopen("out","w");
    ptl.x = xVal;



    fprintf(fptr,"POS1 = %ld\n",ptl.x);

    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
/*    WorldWriteString(ptl.x, ptl.y, "CAPS_RASTER_CAPS");
    lValue = alDevCaps[CAPS_RASTER_CAPS];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);
    xVal2 = ptl.x;


    fprintf(fptr,"lValue = %ld\n",lValue);
    if (lValue & CAPS_RASTER_BITBLT) {
      strcpy(achLogLine, "GpiBitBlt, GpiWCBitBlt Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_BANDING) {
      strcpy(achLogLine, "Device Supports Banding");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_BITBLT_SCALING) {
      strcpy(achLogLine, "GpiBitBlt, GpiWCBitBlt with Scaling Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_SET_PEL) {
      strcpy(achLogLine, "GpiSetPel Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_FONTS) {
      strcpy(achLogLine, "Device can draw Raster Fonts");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }
    ptl.x = xVal;
  */

    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_HORIZONTAL_FONT_RES");
    lValue = alDevCaps[CAPS_HORIZONTAL_FONT_RES];

    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x = MapX(385);
    strcpy(achLogLine, "Horiz. Resolution in Pels/Inch");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= syPosition;



    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_VERTICAL_FONT_RES");
    lValue = alDevCaps[CAPS_VERTICAL_FONT_RES];

    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x = MapX(385);
    strcpy(achLogLine, "Vert. Resolution in Pels/Inch");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= syPosition;


    // Print the DevCaps field name and the value,
    // and move over to print the meaning of the value.
    WorldWriteString(ptl.x, ptl.y, "CAPS_RASTER_CAPS");
    lValue = alDevCaps[CAPS_RASTER_CAPS];
    ptl.x += MapX(300);
    sprintf(achLogLine, "%5ld", lValue);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(385);
    xVal2 = ptl.x;


    fprintf(fptr,"lValue = %ld\n",lValue);
    if (lValue & CAPS_RASTER_BITBLT) {
      strcpy(achLogLine, "GpiBitBlt, GpiWCBitBlt Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
    fprintf(fptr,"POS2 = %ld\n",xVal2);
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_BANDING) {
      strcpy(achLogLine, "Device Supports Banding");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_BITBLT_SCALING) {
      strcpy(achLogLine, "GpiBitBlt, GpiWCBitBlt with Scaling Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_SET_PEL) {
      strcpy(achLogLine, "GpiSetPel Supported");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }

    if (lValue & CAPS_RASTER_FONTS) {
      strcpy(achLogLine, "Device can draw Raster Fonts");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = xVal2;
      ptl.y -= syPosition;
    }
    ptl.x = xVal;
    fclose(fptr);



    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiFontApp2 */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryFontFileDescriptionsExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryFontFileDescriptions function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    LONG   lRemFonts = GpiQueryFontFileDescriptions (hab, pszFilename,
 *                                                     plCount, affdescsNames)
 *
 *    HAB    hab;           Anchor-block handle
 *    PSZ    pszFilename;   Fully qualified filename
 *    PLONG  plCount;       Maximum number of family and facename pairs to
 *                            be returned
 *    PFFDESCS  affdescsNames;  Array of font file descriptors
 *
 *    LONG    lRemFonts;    Returns
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/18/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  TEST_SIGNATURE
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *  This entrypoint will only find .FON files if they are
 *  added in the Control Panel using the ADD FONT option.
 *
 *  Also, the output may differ from machine to machine depending
 *  on the order in which the fonts were added.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   For all .FON files found
 *     1) Call GpiQueryFontFileDescriptions to return a Count of the fonts in
 *        the .FON file.
 *     2) Allocate space to hold Count FFDESCS.
 *     3) Call GpiQueryFontFileDescriptions again to return the FFDESCS.
 *     4) Print out the number of fonts in each file.
 *   Endfor
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryFontFileDescriptionsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiQueryFontFileDescriptionsExh";
  HDC    hDC;
  CHAR   Path[200];
  CHAR   KeyName[100];    // Max Length of a filename
  USHORT usReturn=0,usMax=200;
  HAB    hAB;
  LONG   Count, Fnts, lIndex;
  PFFDESCS pfNames;
  CHAR *String=(CHAR *)NULL;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Initialize coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the points.
    MapPt(ptl);

    // HDC used in DevEscape call
    hDC = GpiQueryDevice(hPS);

    // Get the Anchor Block handle.
    hAB = WinQueryAnchorBlock(hWndClient);

    //Allocate a 64K segment.

    //32 Memory Allocation
    DosAllocMem((PVOID)&String,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT);
    // String = FileSelector;



    // Get the KeyNames from the INI file, put in String.
    // The KeyNames are delimited by NULLS in String.
    // String is delimited by two NULLS.
    if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", NULL, "WIN Error",
                                          String, 0xFFFF)) <= 0)
      CLEANUP("PrfQueryProfileString", EntryName);

    lIndex=0L;

    if (usReturn > 0) {

      // Go through String one KeyName at a time until
      // String[lIndex] is NULL.
      while (String[lIndex]) {
        strcpy(KeyName, String+lIndex);
        if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", KeyName,
                                              "WIN Error", Path, usMax)) <= 0)
          CLEANUP("PrfQueryProfileString", EntryName);

        // Pass the count to zero to find how many font file
        // descriptions there are in the file specified in achFile.
        Count=0L;

        if ((Fnts = GpiQueryFontFileDescriptions(hAB, (PSZ)Path,&Count,
                                                (PFFDESCS) pfNames)) == GPI_ALTERROR)
          CLEANUP("GpiQueryFontFileDescriptions", EntryName);

        // Allocate space for the number of font file descriptions
        if ((pfNames = (PFFDESCS)malloc((LONG)Fnts*sizeof(FFDESCS))) == NULL)
          CLEANUP("malloc", EntryName);

        // Call again to return the font file descriptions into
        // the area pointed to by pfNames.
        lSuccess = GpiQueryFontFileDescriptions(hAB, Path,
                                                &Fnts, pfNames);
        // Produce message and print it
        sprintf(achLogLine, "%3ld FACENAMES in %s", Fnts, Path);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;

        // Quit if the output is to the display and the current
        // position is 3/4 inches from the bottom of the page.
        if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
          if (!GpiSetCharSet(hPS,LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
          if (!GpiDeleteSetId(hPS,LCID_ALL))
            CLEANUP("GpiDeleteSetId", EntryName);
          EXIT_MAIN(EntryName);
          return;
        }

        // If the output is to the printer and the current position
        // is 1/2 inch from the bottom of the page, start a new page,
        // print the test signature in the same font as the first page,
        // and reset the x,y coordinates.
        if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
          if ((lSuccess = DevEscape(hDC, DEVESC_NEWFRAME,
                                     0L, NULL, 0L, NULL)) == DEVESC_ERROR)
            CLEANUP("DevEscape", EntryName);
          if (!GpiSetCharSet(hPS, DESIRED_FONT_ID))
            CLEANUP("GpiSetCharSet", EntryName);
          TEST_SIGNATURE(0,0);
          ptl.y = MapY((LONG) (pg_size_y) * delta_y);
          ptl.y -= 2*syPosition;
          if (!GpiSetCharSet(hPS, LCID_DEFAULT))
            CLEANUP("GpiSetCharSet", EntryName);
        }

        free(pfNames);
          lIndex += strlen(KeyName) + 1;
      } /* End While */
    }
    else if (usReturn == 0) {
      ptl.y -=syPosition;
      sprintf(achLogLine, "There are %2d FONT files ADDED"
                          " in the Control Panel", usReturn);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -=syPosition;
    }

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    DosFreeMem(String);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiQueryFontFileDescriptionsExh */


/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryFontMetricsExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryFontMetrics function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    BOOL      fSuccess = GpiQueryFontMetrics (hps, lMetricsLength,
 *                                     pfmMetrics)
 *
 *    HPS       hps;              Presentation-space handle
 *    LONG      lMetricsLength;   Length of metrics
 *    PFONTMETRICS  pfmMetrics;   Metrics of font
 *
 *    BOOL      fSuccess;     Success indicator
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/21/91, PDVT, Darin C. Hafer
 *                 - Test Case Design
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  TEST_SIGNATURE
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *    This entrypoint only gets the metrics of the current
 *    default font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    Call GpiQueryFontMetrics to get current font metrics.
 *    Print the family and face name.
 *    For fm.idRegistry to fm.lMatch
 *      1) Print the name of the FONTMETRIC field.
 *      2) Print the value of the FONTMETRIC field.
 *    Endfor
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryFontMetricsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiQueryFontMetricsExh";
  FONTMETRICS fm;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  LONG       xVal=0L,
             Index=0L,
             PubFonts=0L;
  BYTE * Pointer;
  BOOL   bNewColumn = TRUE;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Initialize coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - ((delta_y*3L/4L) - 10L));

    // Map the coordinates.
    MapPt(ptl);

    // Get PUBLIC Fontnames
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[0]))
      CLEANUP("EzCreateLogicalFonts", EntryName);
    if (!GpiSetCharSet(hPS, USER_LCID))
      CLEANUP("GpiSetCharSet", EntryName);

    // Get fontmetrics of Current Logical Font.
    if (!GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm))
      CLEANUP("GpiQueryFontMetrics", EntryName);

    if (!GpiSetCharSet(hPS, LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS, USER_LCID))
      CLEANUP("GpiDeleteSetId", EntryName);

    sprintf(achLogLine, "Familyname   %s", strupr(fm.szFamilyname));
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    sprintf(achLogLine, "Facename     %s", strupr(fm.szFacename));
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    // Pointer will point to the FONTMETRICS of the Current
    // Logical Font.
    Pointer = (BYTE *)&fm;

    // Do this for all the fields in the FONTMETRICS structure
    // except for the Familyname and Facename, thus 47 times.
    for (Index = 0; Index < 47; Index++) {

      // If at the bottom of the screen, start a new column.
      if ((Index >= 23) && (bNewColumn == TRUE)) {
//        UnMapX(ptl.x);
        ptl.x = (LONG) (delta_x * 4L + 20L);
//        UnMapY(ptl.y);
        ptl.y = (LONG) ((pg_size_y * delta_y) - ((delta_y*3L/4L) - 10L));
        MapPt(ptl);
        ptl.y -= syPosition;
        bNewColumn = FALSE;
      }

      // Print the name of the FONTMETRIC field.
      WorldWriteString(ptl.x, ptl.y, FontMets[Index].szMetric);

      // Save the current x coordinate, move over, and print
      // the value of the FONTMETRIC field.
      xVal = ptl.x;
      ptl.x += MapX(300);
      if (Offset[Index+3] - Offset[Index+2] == 2) {
        sprintf(achLogLine, "%5d", (*(SHORT *)(Pointer + Offset[Index+2])));
        WorldWriteString(ptl.x, ptl.y, achLogLine);
      }
      else if (Offset[Index+3] - Offset[Index+2] == 4) {
        sprintf(achLogLine, "%5ld", (*(LONG *)(Pointer + Offset[Index+2])));
        WorldWriteString(ptl.x, ptl.y, achLogLine);
      }

      // Restore the original x coordinate.
      ptl.x = xVal;
      ptl.y -= syPosition;

    } /* End For */


    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    EXIT_MAIN("GpiQueryFontMetrics");
  } /* End main else */
  return;
} /* End GpiQueryFontMetrics */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryFontsExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryFonts function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    LONG      lRemFonts = GpiQueryFonts (hps, flOptions, pszFacename,
 *                                 plReqFonts, lMetricsLength, afmMetrics)
 *
 *    HPS       hps;              Presentation-space handle
 *    ULONG     flOptions;        Enumeration options
 *    PSZ       pszFacename;      Facename of fonts
 *    PLONG     plReqFonts;       Count of fonts
 *    LONG      lMetricsLength;   Length of metrics
 *    PFONTMETRICS  afmMetrics;   Metrics of font
 *
 *    LONG      lRemFonts;     Count of fonts not returned
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/18/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  LOGINFO
 *  EzQueryFonts
 *  FaceList
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *    This entrypoint uses all .FON files it finds
 *    in the C:\OS2\DLL directory, whether they are added
 *    in the Control Panel or not.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Query Public, Private, Public|Private and print the count of each.
 *   For all .FON files in C:\OS2\DLL
 *     1) Load the font file.
 *     2) Query Public, Private, Public|Private and print the count of each.
 *     3) Unload the font file.
 *   Endfor
 *
 *  i) Call EzQueryFonts for Public fonts to get facenames and match numbers.
 * ii) Call FaceList which counts how many of each unique facename there are
 *     and prints that information.
 *
 *  Do i) and ii) for Private and Public|Private
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  typedef struct _XYZ {          // This allows me to keep a running list
           CHAR Filename[300];   // of all the .FON files and their paths
              }XYZ;              // so that I can unload them one at a time.
  XYZ *FontFilePtr=(XYZ *)NULL;  // as he/she wants as long as the sum of the
                                 // strings containing the path and filename
                                 // (in bytes) do not go beyond 64 K.
  static PCHAR EntryName="GpiQueryFontsExh";
  PTEMPTYPE   FontStorage=(PTEMPTYPE)NULL;
  LONG        Count=0L,
              lIndex=0L,
              PubFonts=0L,
              PriFonts=0L,
              Pub_Pri_Fonts=0L;
  HAB         hAB;
  CHAR        Path[200];
  CHAR        KeyName[100];
  USHORT      usReturn=0,usMax=200;
  CHAR *String=(CHAR *)NULL;


  if(SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);


    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    // Query PUBLIC fonts
    if ((lSuccess = GpiQueryFonts(hPS,
                                  QF_PUBLIC,
                                  NULL, &PubFonts,
                                  0L, NULL)) == GPI_ALTERROR)
      CLEANUP("GpiQueryFonts", EntryName);
    PubFonts = lSuccess;


    // Query PRIVATE fonts
    if ((lSuccess = GpiQueryFonts(hPS,
                                  QF_PRIVATE,
                                  NULL, &PriFonts,
                                  0L, NULL)) == GPI_ALTERROR)
      CLEANUP("GpiQueryFonts", EntryName);
    PriFonts = lSuccess;

    // Query PUBLIC|PRIVATE fonts
    if ((lSuccess = GpiQueryFonts(hPS,
                                  QF_PUBLIC|QF_PRIVATE,
                                  NULL, &Pub_Pri_Fonts,
                                  0L, NULL)) == GPI_ALTERROR)
      CLEANUP("GpiQueryFonts", EntryName);
    Pub_Pri_Fonts = lSuccess;

    sprintf(achLogLine, " %3ld PUBLIC fonts    %3ld PRIVATE fonts"
                        "    %3ld PUBLIC|PRIVATE fonts",
                        PubFonts, PriFonts, Pub_Pri_Fonts);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= 2*syPosition;


    if ( (PubFonts + PriFonts) != Pub_Pri_Fonts) {
       strcpy(achLogLine, "   !! The Fonts do not add up correctly !!");
       WorldWriteString(ptl.x, ptl.y, achLogLine);
       ptl.y -= syPosition;
    }

    hAB = WinQueryAnchorBlock(hWndClient);

    //Allocate a 64K segment

    //32 Memory Allocation
    DosAllocMem((PVOID)&String,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT);

    // Get the KeyNames from the INI file, put in String.
    // The KeyNames are delimited by NULLS in String.
    // String is delimited by two NULLS.
    if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", NULL, "WIN Error",
                                          String, 0xFFFF)) <= 0)
      CLEANUP("PrfQueryProfileString", EntryName);

    lIndex=0L;

    if (usReturn > 0) {

       //Allocate a 64K segment.

       //32 bit
       DosAllocMem((PVOID)&FontFilePtr,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT);

      // Go through String one KeyName at a time until
      while (String[lIndex]) {
        strcpy(KeyName, String+lIndex);
        if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", KeyName,
                                              "WIN Error", Path, usMax)) <= 0)
          CLEANUP("PrfQueryProfileString", EntryName);

        strcpy(FontFilePtr[Count].Filename,Path);


        // Initialize a message and print it
        sprintf(achLogLine, "     \t- Now Loading %s with GpiLoadFonts", FontFilePtr[Count].Filename);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;



        // Load the font
        if (GpiLoadFonts(hAB, FontFilePtr[Count].Filename) == FALSE)
          CLEANUP("GpiLoadFonts", EntryName);

        // Query PUBLIC fonts
        PubFonts=0L;
        if ((lSuccess = GpiQueryFonts(hPS,
                                      QF_PUBLIC,
                                      NULL, &PubFonts,
                                      0L, NULL)) == GPI_ALTERROR)
          CLEANUP("GpiQueryFonts", EntryName);
        PubFonts = lSuccess;

        // Query PRIVATE fonts
        PriFonts=0L;
        if ((lSuccess = GpiQueryFonts(hPS,
                                      QF_PRIVATE,
                                      NULL, &PriFonts,
                                      0L, NULL)) == GPI_ALTERROR)
          CLEANUP("GpiQueryFonts", EntryName);
        PriFonts = lSuccess;

        // Query PUBLIC|PRIVATE fonts
        Pub_Pri_Fonts=0L;
        if ((lSuccess = GpiQueryFonts(hPS,
                                      QF_PUBLIC|QF_PRIVATE,
                                      NULL, &Pub_Pri_Fonts,
                                      0L, NULL)) == GPI_ALTERROR)
          CLEANUP("GpiQueryFonts", EntryName);
        Pub_Pri_Fonts = lSuccess;

        sprintf(achLogLine, " %3ld PUBLIC fonts    %3ld PRIVATE fonts"
                            "    %3ld PUBLIC|PRIVATE fonts",
                            PubFonts, PriFonts, Pub_Pri_Fonts);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= 2*syPosition;
        Count++;
        lIndex += strlen(KeyName) + 1;
                }
    }


      // Get PUBLIC Fontnames
      if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,&PubFonts,&FontStorage))
        CLEANUP("EzQueryFonts", EntryName);
      if (!FaceList(hPS, hWndClient, QF_PUBLIC, &ptl,
                    (LONG)syPosition, PubFonts, &FontStorage))
        CLEANUP("FaceList", EntryName);


      // Get PRIVATE Fontnames
      if (!EzQueryFonts(hPS,hWndClient,QF_PRIVATE,&PriFonts,&FontStorage))
        CLEANUP("EzQueryFonts", EntryName);
      if (!FaceList(hPS, hWndClient, QF_PRIVATE, &ptl,
                    (LONG)syPosition, PriFonts, &FontStorage))
        CLEANUP("FaceList", EntryName);


      // Get PUBLIC|PRIVATE Fontnames
      if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC|QF_PRIVATE,
                        &Pub_Pri_Fonts,&FontStorage))
        CLEANUP("EzQueryFonts", EntryName);
      if (!FaceList(hPS, hWndClient, QF_PUBLIC|QF_PRIVATE,
                    &ptl,(LONG)syPosition, Pub_Pri_Fonts, &FontStorage))
        CLEANUP("FaceList", EntryName);

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

     // Unload the .FON files, since we're done.
     while (--Count >= 0) {
       if (GpiUnloadFonts(hAB, FontFilePtr[Count].Filename) == FALSE)
         CLEANUP("GpiUnloadFonts", EntryName);
     }

    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    DosFreeMem(FontFilePtr);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiQueryFontsExh */


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCreateLogFontExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiCreateLogFont function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    LONG   lMatch = GpiCreateLogFont (hps, pName, lLcid, pfatAttrs)
 *
 *    HPS      hps;        Presentation-space handle
 *    PSTR8    pName;      Logical font name
 *    LONG     lLcid;      Local identifier
 *    PFATTRS  pfatAttrs;  Attributes of font
 *
 *    LONG   lMatch;    Match indicator
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/18/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  PrintFonts
 *  DeviceIsDisplay
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *    The Match numbers of the system fonts (or, non-device fonts),
 *    vary from machine to machine.  I think this is an OS/2 "feature".
 *    Depending on the order in which the fonts were added from the Control
 *    Panel, the match numbers for those fonts will vary.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Print a Header
 *   Call EzQueryFonts for PUBLIC fonts
 *   For all PUBLIC fonts
 *     1) Create it
 *     2) Call PrintFonts which prints the facename in its native typeface
 *        and then, in a Courier 10 typeface, prints some metric information
 *        for that font.
 *   Endfor
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiCreateLogFontExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiCreateLogFontExh";
  LONG   PubFonts=0L,
         PriFonts=0L,
         Index=0L, xVal;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    xVal = ptl.x;

    strcpy(achLogLine, "FACENAME (Unique Codepoints)");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
    ptl.x += MapX(400);
    strcpy(achLogLine, "POINT");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x += MapX(70);
    strcpy(achLogLine, "MATCH");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
    if DeviceIsDisplay()
      ptl.x += MapX(80);
    else
      ptl.x += MapX(100);
    strcpy(achLogLine, "CDPG");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x += MapX(65);
    strcpy(achLogLine, "B");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x += MapX(30);
    strcpy(achLogLine, "U");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x += MapX(30);
    strcpy(achLogLine, "I");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    ptl.x += MapX(30);
    strcpy(achLogLine, "Defn");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= syPosition;

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);


    for (Index=0; Index < PubFonts; Index++) {
      if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, USER_LCID))
        CLEANUP("GpiSetCharSet", EntryName);
      if ((lSuccess = PrintFonts(hPS, hWndClient, &ptl)) == 1)
        CLEANUP("PrintFonts", EntryName);
      else if (lSuccess == -1) {
        EXIT_MAIN(EntryName);
        return;
      }
    } /* End For */


    /********************************************************************
              Return the proper log messages for GPI's.
    ********************************************************************/

    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    if (!GpiResetPS(hPS, GRES_ALL))
      CLEANUP("GpiResetPS", EntryName);

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiCreateLogFontExh */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryKerningPairsExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryKerningPairs function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    LONG      lReturned = GpiQueryKerningPairs (hps, lCount, akrnprData)
 *
 *    HPS       hps;       Presentation-space handle
 *    LONG      lCount;    The number of elements in Data
 *    PKERNINGPAIRS  akrnprData;  Kerning pairs
 *
 *    LONG      lReturned;   Number returned/error indicator
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/18/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  TEST_SIGNATURE
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   For all PUBLIC fonts
 *     1) Create the font
 *     2) Query the font metrics to get the # of kerning pairs.
 *     If # of kerning pairs > 0
 *        Allocate space for those kerning pairs.
 *        Call GpiQueryKerningPairs.
 *        Delete the font, restore the default.
 *       If # returned > 0
 *          Print the facename and kerning pair information.
 *   Endfor
 *   If no fonts had kerning pairs
 *     Print a message saying so.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryKerningPairsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiQueryKerningPairsExh";
  HDC    hDC;
  LONG   PubFonts=0,
         Index=0L,
         Count=0L, xVal=0L, lReturned=0L;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  PKERNINGPAIRS aKernData=(PKERNINGPAIRS)NULL;
  FONTMETRICS  fm;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

   xVal = ptl.x;

    // HDC used in DevEscape call
    hDC = GpiQueryDevice(hPS);


    // Get PUBLIC Fontname and Match Number.
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    strcpy(achLogLine, "Facename");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(300);
    strcpy(achLogLine, "Expected");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(150);
    strcpy(achLogLine, "Actual");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= syPosition;
    ptl.x += MapX(300);
    strcpy(achLogLine, "Kern. Pairs");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(150);
    strcpy(achLogLine, "Kern. Pairs");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= 2*syPosition;


    for (Index=0; Index < PubFonts; Index++) {
       if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
         CLEANUP("EzCreateLogicalFonts", EntryName);
       if (!GpiSetCharSet(hPS, USER_LCID))
         CLEANUP("GpiSetCharSet", EntryName);

       // Get fontmetrics of current font to get the number
       // of kerning pairs for the current fonts.
       if (!GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm))
         CLEANUP("GpiQueryFontMetrics", EntryName);

       if (fm.sKerningPairs > 0) {
         if ((aKernData = (PKERNINGPAIRS)malloc((fm.sKerningPairs) * sizeof(KERNINGPAIRS))) == NULL)
           CLEANUP("malloc", EntryName);

         // Get the kerning pair information.
         if ((lSuccess = GpiQueryKerningPairs(hPS, (LONG)fm.sKerningPairs,
                                              aKernData)) == GPI_ALTERROR)
           CLEANUP("GpiQueryKerningPairs", EntryName);

         free(aKernData);

         // Quit if the output is to the display and the current
         // position is 3/4 inches from the bottom of the page.
         if ((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) {
           if (!GpiSetCharSet(hPS,LCID_DEFAULT))
             CLEANUP("GpiSetCharSet", EntryName);
           if (!GpiDeleteSetId(hPS,LCID_ALL))
             CLEANUP("GpiDeleteSetId", EntryName);
           EXIT_MAIN(EntryName);
           return;
         }

         // If the output is to the printer and the current position
         // is 1/2 inch from the bottom of the page, start a new page,
         // print the test signature in the same font as the first page,
         // and reset the x,y coordinates.
         if ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter()) {
           if ((lReturned = DevEscape(hDC, DEVESC_NEWFRAME,
                                      0L, NULL, 0L, NULL)) == DEVESC_ERROR)
             CLEANUP("DevEscape", EntryName);
           GpiSetCharSet(hPS, DESIRED_FONT_ID);
           TEST_SIGNATURE(0,0);
           ptl.y = MapY((LONG) (pg_size_y) * delta_y);
           ptl.y -= 2*syPosition;
           GpiSetCharSet(hPS, USER_LCID);
           strcpy(achLogLine, "Facename");
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x += MapX(300);
           strcpy(achLogLine, "Expected");
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x += MapX(150);
           strcpy(achLogLine, "Actual");
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x = xVal;
           ptl.y -= 2*syPosition;
         }

         if (lSuccess > 0L) {
           Count++;
           sprintf(achLogLine, "%s", fm.szFacename);
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x += MapX(300);
           sprintf(achLogLine, "%3d", fm.sKerningPairs);
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x += MapX(150);
           sprintf(achLogLine, "%3d", lSuccess);
           WorldWriteString(ptl.x, ptl.y, achLogLine);
           ptl.x = xVal;
           ptl.y -= syPosition;
         }
       }

       if (!GpiSetCharSet(hPS,LCID_DEFAULT))
         CLEANUP("GpiSetCharSet", EntryName);
       if (!GpiDeleteSetId(hPS,USER_LCID))
         CLEANUP("GpiDeleteSetId", EntryName);
    } /* End For*/


    if (Count < PubFonts) {
                if (Count != 0L)
        sprintf(achLogLine, "NO Kerning Pair information for the remaining %ld fonts", PubFonts-Count);
                else
        sprintf(achLogLine, "NO Kerning Pair information for %ld fonts", PubFonts-Count);

      ptl.y -= syPosition;
      WorldWriteString(ptl.x, ptl.y, achLogLine);
    }

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/
    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiQueryKerningPairsExh */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQueryCpExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiSetCp and GpiQueryCp function calls.
 *
 *
 *     #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *
 *    BOOL   fSuccess = GpiSetCp (hps, usCodePage)
 *
 *    HPS   hps;            Presentation-space handle
 *    USHORT  usCodePage;   Code-page id
 *
 *    BOOL   fSuccess;      Success indicator
 *
 *--------------------------------------------------------------
 *
 *    USHORT  usCodePage = GpiQueryCp (hps)
 *
 *    HPS   hps;            Presentation-space handle
 *
 *    USHORT  usCodePage;   Code page
 *
 *--------------------------------------------------------------
 *
 * System Requirements:
 *
 * Revision Log: 01/22/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  LOGINFO
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Get the anchor block
 *   Call WinQueryAnchorBlock 1st to get a count of the available code pages.
 *   Allocate space for the # of code pages.
 *   Call WinQueryAnchorBlock again to retrieve those code pages.
 *   Query the default code page.
 *   For all code pages returned from WinQueryAnchorBlock
 *     Print the current code page # about to be set
 *     Call GpiSetCp to set the code page.
 *     Call GpiQueryCp
 *     Print the code page # as returned from GpiQueryCp.
 *     Print some sample code points in the current code page.
 *     restore the default code page.
 *   Endfor
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQueryCpExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiSetAndQueryCpExh";
  HAB    hAB;
  PULONG     aCodePage;
  USHORT     TotalReturned=0,
             usIndex, CodePage,
             TotalAvailable, DefCp;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 100L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    // Get the Anchor Block handle.
    if ((hAB = WinQueryAnchorBlock(hWndClient)) == NULLHANDLE){
        CLEANUP("WinQueryAnchorBlock", EntryName);
        return;     // Can't proceed without Anchor block
    }

    // Get total number of available code pages.
    TotalReturned = 0L;
    if ((TotalAvailable = WinQueryCpList(hAB,TotalReturned,NULL)) == 0) {
       CLEANUP("GpiQueryCpList", EntryName);
       return;
    }

    // Allocate storage for those code pages.
    if ((aCodePage=(PULONG)malloc((USHORT)TotalAvailable * sizeof(USHORT))) == NULL)
       CLEANUP("malloc", EntryName);

    // Get those code pages and put them into the
    // area pointed to by aCodePage.
    if (WinQueryCpList(hAB,TotalAvailable,aCodePage) == 0) {
       CLEANUP("WinQueryCpList", EntryName);
       return;
    }

    // Move Down a line.
    ptl.y -= syPosition;

    // Query the default code page.
    if ((DefCp = GpiQueryCp(hPS)) == GPI_ERROR)
       CLEANUP("GpiQueryCp", EntryName);

    strcpy(achLogLine, "CODEPAGE");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    // Do this for all code pages.
    for (usIndex = 0; usIndex < TotalAvailable; usIndex++) {

        // Print the code page as returned by WinQueryCpList
        // and set by GpiSetCp
        sprintf(achLogLine, "%4d  /  ", aCodePage[usIndex]);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.x += MapX(80);

        // Set the code page.
        if (!GpiSetCp(hPS, aCodePage[usIndex])) {
          sprintf(achLogLine, "CodePage %d is not available", aCodePage[usIndex]);
          LOGINFO(L_LOTRACE, "@", achLogLine);
        }

        // Query the code page.
        if ((CodePage = GpiQueryCp(hPS)) == GPI_ERROR)
           CLEANUP("GpiQueryCp", EntryName);

        // Return to the default code page.
        if (!GpiSetCp(hPS, DefCp))
           CLEANUP("GpiSetCp", EntryName);

        // Check if equal
        if (aCodePage[usIndex] != CodePage) {
          sprintf(achLogLine, "%3d not available !",aCodePage[usIndex]);
          WorldWriteString(ptl.x, ptl.y, achLogLine);
        }
        else {
          // Print the code page as returned by GpiQueryCp
          sprintf(achLogLine, "%3d", CodePage);
          WorldWriteString(ptl.x, ptl.y, achLogLine);

          // Set the code page.
          if (!GpiSetCp(hPS, aCodePage[usIndex]))
             CLEANUP("GpiSetCp", EntryName);

          // Move over 3 inches and print some sample code points.
          ptl.x += MapX(200);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xE0");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xE1");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xE2");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xEC");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xED");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xEE");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xEF");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\x97");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\x98");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\x99");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\x9E");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xD0");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xD8");
          ptl.x += MapX(30);

          GpiMove(hPS, &ptl);
          GpiCharString(hPS, 1L, "\xDE");
          ptl.x += MapX(30);

          // Return to the default code page.
          if (!GpiSetCp(hPS, DefCp))
             CLEANUP("GpiSetCp", EntryName);
        } /* End Else */

        // Move back over and move up a line.
        ptl.x = MapX(100);
        ptl.y -= syPosition;

    } /* End For */

    ptl.x = MapX(50);
    ptl.y -= syPosition;

    // Initialize message and print it
    strcpy(achLogLine, "  GpiSetCp  /  GpiQueryCp");
    WorldWriteString(ptl.x, ptl.y, achLogLine);


    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    free(aCodePage);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiSetAndQueryCpExh */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQueryCharSetExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiSetCharSet and GpiQueryCharSet function calls.
 *
 *
 *    #define INCL_GPIPRIMITIVES   Or use INCL_GPI or INCL_PM
 *
 *    BOOL  fSuccess = GpiSetCharSet (hps, llcid)
 *
 *    HPS  hps;         Presentation-space handle
 *    LONG  llcid;      Character-set local identifier
 *
 *    BOOL  fSuccess;   Success indicator
 *
 *--------------------------------------------------------------
 *
 *    LONG  lLcid = GpiQueryCharSet (hps)
 *
 *    HPS  hps;         Presentation-space handle
 *
 *    LONG  lLcid;      Character-set local identifier
 *
 *
 * System Requirements:
 *
 * Revision Log: 02/27/91, PDVT, Darin C. Hafer
 *                 - Test Case Design and Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  LOGINFO
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Print header
 *   Query to get number of PUBLIC fonts.
 *   For all PUBLIC fonts
 *     1) Print font face name
 *     2) Print LCID to be assigned to the new logical font.
 *     3) Create the new logical font.
 *     4) Query the character set to get LCID of current logical font,
 *        and print the value returned.
 *   Endfor
 *
 *   Delete all fonts.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQueryCharSetExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiSetAndQueryCharSetExh";
  PTEMPTYPE   FontStorage=(PTEMPTYPE)NULL;
  LONG        Index=0L,
              PubFonts=0L,
              xVal=0L;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Initialize the coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    xVal = ptl.x;
    strcpy(achLogLine, "Facename");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(380);
    strcpy(achLogLine, "GpiSetCharSet");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(150);
    strcpy(achLogLine, "GpiQueryCharSet");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= 2*syPosition;

    // Get PUBLIC Fontnames and  Match numbers
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    for (Index=0; Index < PubFonts; Index++) {

      sprintf(achLogLine, "%s", strupr(FontStorage[Index].Fontname));
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x += MapX(380);

      sprintf(achLogLine, "LCID=%2ld", Index+1);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x += MapX(150);

      if (!EzCreateLogicalFonts(hPS,hWndClient,Index+1,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, Index+1))
        CLEANUP("GpiSetCharSet", EntryName);

      if ((lSuccess=GpiQueryCharSet(hPS))==LCID_ERROR)
        CLEANUP("GpiQueryCharSet", EntryName);

      if (lSuccess != Index+1) {
        sprintf(achLogLine, "*** LCID=%2ld Mismatch!", lSuccess);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        LOGINFO(L_LOTRACE, "@", achLogLine);
      }
      else {
        sprintf(achLogLine, "LCID=%2ld", lSuccess);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
      }

      ptl.x = xVal;
      ptl.y -= syPosition;

      if (((UnMapY(ptl.y) <= 75L) && DeviceIsDisplay()) ||
          ((UnMapY(ptl.y) <= 50L) && DeviceIsPrinter())) {
        Index = PubFonts;
      }
    }

    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);

    // Delete all Logical Fonts;
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);


    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiSetAndQueryCharSetExh  */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryNumberSetIdsExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryNumberSetIdsExh function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    LONG  lCount = GpiQueryNumberSetIds (hps)
 *
 *    HPS  hps;        Presentation-space handle
 *
 *    LONG  lCount;    Number of lcids
 *
 * System Requirements:
 *
 * Revision Log: 02/27/91, PDVT, Darin C. Hafer
 *                 - Test Case Design
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Print header
 *   Query to get the number of PUBLIC fonts.
 *
 * PART 1 - Query one at a time.
 *   For the first 5 fonts found
 *     1) Print the font face name to be created.
 *     2) Create the logical font.
 *     3) Query the number of set ids (LCIDs).
 *     4) If output is to the printer, decrement the number of set ids by
 *        one because there is an id set when EnterMain is called that this
 *        test does not use.
 *     5) Print the number of currently set ids.
 *     6) Print the font face name to be deleted.
 *     7) Delete the font.
 *   Endfor
 *
 * PART 2 - Query more than one at a time.
 *   For fonts 11 through 20
 *     1) Print the font face name.
 *     2) Create the logical font.
 *     3) Query the number of set ids (LCIDs).
 *     4) If output is to the printer, decrement the number of set ids by
 *        one because there is an id set when EnterMain is called that this
 *        test does not use.
 *     5) Print the accumulated number of currently set ids.
 *   Endfor
 *
 *   Print the total number of LCIDs.
 *   Delete all the fonts.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryNumberSetIdsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiQueryNumberSetIdsExh";
  PTEMPTYPE   FontStorage=(PTEMPTYPE)NULL;
  LONG        Index=0L,
              PubFonts=0L,
              xVal=0L;



  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Initialize the coordinates to 3/4 inch from top of screen.
    ptl.x = 50L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - ((delta_y*3L/4L) - 10L));

    // Map the coordinates.
    MapPt(ptl);

    xVal = ptl.x;
    strcpy(achLogLine, "Facename");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(380);
    strcpy(achLogLine, "# of LCIDs");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(150);
    strcpy(achLogLine, "Deleting");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = MapX(20);
    ptl.y -= syPosition;
    strcpy(achLogLine, "PART 1");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= 2*syPosition;

    // Get PUBLIC Fontnames and  Match numbers
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    // Just do for 6 fonts.
    if (PubFonts > 6L) PubFonts = 6L;

    for (Index=0; Index < PubFonts; Index++) {
      sprintf(achLogLine, "%s", strupr(FontStorage[Index].Fontname));
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = MapX(380);

      if (!EzCreateLogicalFonts(hPS,hWndClient,Index+1,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, Index+1))
        CLEANUP("GpiSetCharSet", EntryName);

      if ((lSuccess=GpiQueryNumberSetIds(hPS))==GPI_ALTERROR)
        CLEANUP("GpiQueryNumberSetIds", EntryName);

      if DeviceIsPrinter()
        lSuccess--;

      sprintf(achLogLine, "%ld", lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x += MapX(150);

      sprintf(achLogLine, "%s", strupr(FontStorage[Index].Fontname));
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);
      if (!GpiDeleteSetId(hPS,Index+1))
        CLEANUP("GpiDeleteSetId", EntryName);

      ptl.x = xVal;
      ptl.y -= syPosition;
    }

    ptl.x = MapX(20);
    ptl.y -= syPosition;
    strcpy(achLogLine, "PART 2");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= 2*syPosition;

    // Get PUBLIC Fontnames and  Match numbers
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    if (PubFonts > 20L) PubFonts = 20L;

    for (Index=10; Index < PubFonts; Index++) {
      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);
      sprintf(achLogLine, "%s", strupr(FontStorage[Index].Fontname));
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.x = MapX(380);

      if (!EzCreateLogicalFonts(hPS,hWndClient,Index+1,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS, Index+1))
        CLEANUP("GpiSetCharSet", EntryName);

      if ((lSuccess=GpiQueryNumberSetIds(hPS))==GPI_ALTERROR)
        CLEANUP("GpiQueryNumberSetIds", EntryName);

      if DeviceIsPrinter()
        lSuccess--;

      sprintf(achLogLine, "%ld", lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      ptl.x = xVal;
      ptl.y -= syPosition;
    }

    if (Index > 10) {
      if ((lSuccess=GpiQueryNumberSetIds(hPS))==GPI_ALTERROR)
        CLEANUP("GpiQueryNumberSetIds", EntryName);

      ptl.y -= syPosition;

      if DeviceIsPrinter()
        lSuccess--;

      sprintf(achLogLine, "...Total Number of LCIDs is %ld", lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -= syPosition;
      sprintf(achLogLine, "...Deleting %ld LCIDs", lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);

      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);

      // Delete all Logical Fonts;
      if (!GpiDeleteSetId(hPS,LCID_ALL))
        CLEANUP("GpiDeleteSetId", EntryName);
    }
    else {
      ptl.y -=syPosition;
      strcpy(achLogLine, "There are NO DEVICE FONTS");
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -=syPosition;
    }
    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiQueryNumberSetIdsExh */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiDeleteSetIdExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiDeleteSetIdExh function call.
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    BOOL  fSuccess = GpiDeleteSetId (hps, lLcid)
 *
 *    HPS  hps;         Presentation-space handle
 *    LONG  lLcid;      Local identifier
 *
 *    BOOL  fSuccess;   Success indicator
 *
 *
 * System Requirements:
 *
 * Revision Log: 02/27/91, PDVT, Darin C. Hafer
 *                 - Test Case Design
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Query to get the number of PUBLIC fonts.
 *   // Since the maximun number of logical fonts is 254, make sure
 *   // I don't try to create more than that.
 *   If PubFonts >= 254 , PubFonts = 253.
 *
 * PART 1 - Delete one at a time.
 *   For all PUBLIC fonts
 *     1) Create the logical font.
 *     2) Delete the font.
 *   Endfor
 *
 * PART 2 - Delete all fonts at once.
 *   For all PUBLIC fonts
 *     1) Create the logical font.
 *   Endfor
 *   Delete all fonts.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDeleteSetIdExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiDeleteSetIdExh";
  LONG   PubFonts=0L,
         Index=0L;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;



  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    // Get PUBLIC Fontname and Match Number
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage))
      CLEANUP("EzQueryFonts", EntryName);

    sprintf(achLogLine, "Creating %ld fonts...", PubFonts);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;
    strcpy(achLogLine, "and Deleting associated SetIds one at a time...");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    for (Index=0; Index < PubFonts; Index++) {
      if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", EntryName);
      if (!GpiDeleteSetId(hPS,USER_LCID))
        CLEANUP("GpiDeleteSetId", EntryName);
    }

    ptl.y -= syPosition;
    sprintf(achLogLine, "Creating %ld fonts...", PubFonts);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    // Can only assign a maximum of 254 LCIDs which implies
    // only 254 logical fonts can be defined at once.
    if (PubFonts >= 254L) PubFonts = 253L;

    for (Index=0; Index < PubFonts; Index++) {
      if (Index == 199) Index++;
      if (!EzCreateLogicalFonts(hPS,hWndClient,Index+1L,FontStorage[Index]))
        CLEANUP("EzCreateLogicalFonts", EntryName);
    }

    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);

    strcpy(achLogLine, "Deleting ALL associated SetIds at once...");
    WorldWriteString(ptl.x, ptl.y, achLogLine);

    // Delete all Logical Fonts;
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);


    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/
    if (!GpiSetCharSet(hPS,LCID_DEFAULT))
      CLEANUP("GpiSetCharSet", EntryName);
    if (!GpiDeleteSetId(hPS,LCID_ALL))
      CLEANUP("GpiDeleteSetId", EntryName);

    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiDeleteSetIdExh  */



/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryWidthTableExh
 *
 * Purpose:  This is an entry point for the PTT that exhaustively tests
 *           the GpiQueryWidthTable function call.
 *
 *
 *    #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *    BOOL  fSuccess = GpiQueryWidthTable (hps, lFirstChar, lCount, alData)
 *
 *    HPS   hps;         Presentation-space handle
 *    LONG  lFirstChar;  Codepoint of first character
 *    LONG  lCount;      Count of elements in Data
 *    PLONG  alData;     Array of width values
 *
 *    BOOL  fSuccess;    Success indicator
 *
 *
 * System Requirements:
 *
 * Revision Log: 01/18/91, PDVT, Darin C. Hafer
 *                 - Test Case Design
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  TEST_SIGNATURE
 *  EzQueryFonts
 *  EzCreateLogicalFonts
 *  WorldWriteString
 *  DeviceIsDisplay
 *  DeviceIsPrinter
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *    The font metric "sLastChar" returns as 330 on a system font.
 *    On a Device font it is returned as 255 which is correct.
 *
 *    GpiQueryWidthTable returns a PMERR_INV_LENGTH_OR_COUNT if the
 *    count is greater than 256, so for all fonts I pass 256 as the
 *    length.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Get the hDC
 *   Call EzQueryFonts for PUBLIC to get facename and match #'s.
 *   For all PUBLIC fonts
 *     1) Create it.
 *     2) Get the font metrics to get first and last char info.
 *     3) Suctract FirstChar from LastChar to get total # of code points.
 *     4) Allocate space for width data for the # of code points.
 *     5) Call GpiQueryWidthTable to get width data for each code point.
 *     6) Restore the default font.
 *     7) Print facename and match number of font.
 *     If the font is not fixed
 *        Sort the width table
 *        Print the narrowest and widest char.
 *      else
 *        Print the fixed width.
 *   Endfor
 *
 *\\end
 ***************************************************************************/
static INT MyCompareFunction(const VOID  *First , const VOID  *Second)
{

      return (int)(*(PULONG)First - *(PULONG)Second);
}

VOID APIENTRY GpiQueryWidthTableExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiQueryWidthTableExh";
  HDC    hDC;
  LONG   PubFonts=0,
         Count=0L,
         Index=0L,
         xVal=0L;
  LONG * WidthData;
  PTEMPTYPE  FontStorage=(PTEMPTYPE)NULL;
  FONTMETRICS  fm;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

    // Set up coordinates for printing.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    xVal = ptl.x;

    // HDC used in DevEscape call
    hDC = GpiQueryDevice(hPS);

    // Get PUBLIC Fontname and Match Number.
    if (!EzQueryFonts(hPS,hWndClient,QF_PUBLIC,(LONG *)&PubFonts,&FontStorage)) {
      CLEANUP("EzQueryFonts", EntryName);
      return;
      }

    strcpy(achLogLine, "Match #");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x += MapX(100);
    strcpy(achLogLine, "Facename");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.x = xVal;
    ptl.y -= 2*syPosition;


    for (Index=0; Index < PubFonts; Index++) {
       if (!EzCreateLogicalFonts(hPS,hWndClient,USER_LCID,FontStorage[Index])) {
         CLEANUP("EzCreateLogicalFonts", EntryName);
         return;
         }
       if (!GpiSetCharSet(hPS, USER_LCID)) {
         CLEANUP("GpiSetCharSet", EntryName);
         return;
         }

       // Get fontmetrics of current font to get the number
       // of the first character.
       if (!GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)) {
         CLEANUP("GpiQueryFontMetrics", EntryName);
         return;
         }


       Count =  (fm.sFirstChar == 1) ? 255 : 256;

       if ((WidthData = (LONG *)malloc((LONG)Count * sizeof(LONG))) == NULL) {
         CLEANUP("malloc", EntryName);
         return;
         }

       if (!GpiQueryWidthTable(hPS, (LONG)fm.sFirstChar, Count, WidthData)) {
         CLEANUP("GpiQueryWidthTable", EntryName);
         return;
       }

       if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
         CLEANUP("GpiSetCharSet", EntryName);
         return;
         }
       if (!GpiDeleteSetId(hPS,USER_LCID)) {
         CLEANUP("GpiDeleteSetId", EntryName);
         return;
         }

       // Quit if the output is to the display and the current
       // position is 3/4 inches from the bottom of the page.
       if ((UnMapY(ptl.y)) <= 75L && DeviceIsDisplay()) {
         if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
           CLEANUP("GpiSetCharSet", EntryName);
           return;
           }
         if (!GpiDeleteSetId(hPS,LCID_ALL)) {
           CLEANUP("GpiDeleteSetId", EntryName);
           return;
           }
         EXIT_MAIN(EntryName);
         return;
       }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
       if ((UnMapY(ptl.y)) <= 50L && DeviceIsPrinter()) {
         if ((lSuccess = DevEscape(hDC, DEVESC_NEWFRAME,
                                   0L, NULL, 0L, NULL)) == DEVESC_ERROR) {
           CLEANUP("DevEscape", EntryName);
           return;
           }
         GpiSetCharSet(hPS, DESIRED_FONT_ID);
         TEST_SIGNATURE(0,0);
         ptl.y = MapY((LONG) (pg_size_y) * delta_y);
         ptl.y -= 2*syPosition;
         strcpy(achLogLine, "Match #");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         ptl.x += MapX(100);
         strcpy(achLogLine, "Facename");
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         ptl.x = xVal;
         ptl.y -= 2*syPosition;
       }

       sprintf(achLogLine, "%4ld)", fm.lMatch);
       WorldWriteString(ptl.x, ptl.y, achLogLine);
       ptl.x += MapX(100);
       sprintf(achLogLine, "%s", strupr(fm.szFacename));
       WorldWriteString(ptl.x, ptl.y, achLogLine);

       if (!(fm.fsType & FM_TYPE_FIXED)) {
        (VOID)qsort((VOID *)WidthData,(int)Count,sizeof(LONG),MyCompareFunction);

         ptl.x += MapX(300);
         sprintf(achLogLine, "%2ld pels narrow and %2ld pels wide",
                             WidthData[0], WidthData[Count-1]);
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         ptl.x = xVal;
         ptl.y -= syPosition;
       }
       else {
         ptl.x += MapX(300);
         sprintf(achLogLine, "Fixed Pitch:  %2ld pels wide", WidthData[0]);
         WorldWriteString(ptl.x, ptl.y, achLogLine);
         ptl.x = xVal;
         ptl.y -= syPosition;
       }
    } /* Endfor */

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/
    if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
      CLEANUP("GpiSetCharSet", EntryName);
      return;
      }
    if (!GpiDeleteSetId(hPS,LCID_ALL)) {
      CLEANUP("GpiDeleteSetId", EntryName);
      return;
      }

    free(WidthData);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiQueryWidthTableExh */



/*****************************************************************************
 *\ddd
 * Routine Name: GpiLoadFontsExh
 *
 * Purpose: This is an entry point for the PTT that tests the
 *          Return Codes for GpiLoadFontsExh.
 *
 *
 *     #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *     BOOL  fSuccess = GpiLoadFonts (hab, pszFilename)
 *
 *     HAB   hab;          Anchor-block handle
 *     PSZ   pszFilename;  Filename
 *
 *     BOOL  fSuccess;    Success indicator
 *
 *
 * System Requirements:
 *
 *
 * Revision Log: 01/23/90 ,PDVT, Darin C. Hafer
 *                 -Test Case Design.
 *
 *               07/02/91        James F. Read  FVT
 *           1 - Added code to get the FONT names from C:\OS2\DLL\...
 *               GPI/GRE DLLs were inconsistent in providing drive
 *               and directory from SYSINI files for system FONTs.
 *           2 - Allowed testcase to be rerun in one session (serially
 *               reusable) by unloading fonts as soon as they were GpiQueryed.
 *           3 - Added code to print/display number of FONTs loaded
 *               with each GpiLoadFont API.
 *
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 *****************************************************************************/
 
/*****************************************************************************
 *\\algorithm
 *
 *   Get the anchor block handle.
 *   Query PRIVATE fonts to see how many there are. (Should be zero)
 *   Print how many there are. (zero)
 *   For all .FON files added in the Control Panel
 *     1) Call GpiLoadFonts to load the .FON file
 *     2) Query the PRIVATE fonts again (Should be > zero)
 *     3) Print how many there are.
 *   Endfor
 *   Unload all .FON files
 *
 *\\end
 ************************************************************.LOADFONT ******/
VOID APIENTRY GpiLoadFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  typedef struct _XYZ {           // This allows me to keep a running list
           CHAR Filename[500];    // of all the .FON files and their paths
              }XYZ;               // so that I can unload them one at a time.
  XYZ *FontFilePtr=(XYZ *)NULL;   // as he/she wants as long as the sum of the
                                  // strings containing the path and filename
                                  // (in bytes) do not go beyond 64 K.

  CHAR  TempDrvDir[24];
  static PCHAR EntryName="GpiLoadFontsExh";
  CHAR   Path[200];
  CHAR   KeyName[100];
  ULONG  usReturn=0L,usMax=200L;
  HAB    hAB;
  LONG   lIndex=0L,
         Returned=0L,
         Count=0L;
  FONTMETRICS Metrics;
  CHAR *String=(CHAR *)NULL;


   SHORT Loop_Ctr=0;                           /* simple loop counter*/
   LONG  Old_Fonts=0;                          /* previous cum tot   */
   LONG  Delta_Fonts=0;                        /* loaded this time   */

   SHORT iint=0;                               /* subscript          */
   CHAR *Fon1Ptr;                              /* pointer            */
   CHAR  FFile[200];                           /* path working array */


   CHAR  DrvDir[24];                           /* to be filled in at */
   UCHAR ucdata[10];
   ULONG ulsize = 10;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {

    strcpy( DrvDir, "?:" );

    ENTER_MAIN(EntryName);

    // Initialize coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    //Allocate a 64K segment.

    //32 bit
    if(DosAllocMem((PVOID)&String,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT) != 0)
    {
     CLEANUP("DosAllocMem", EntryName);
    }


    // Get the Anchor Block handle.
    hAB = WinQueryAnchorBlock(hWndClient);

    // Find out how many PRIVATE fonts there are.
    if ((lSuccess = GpiQueryFonts(hPS, QF_PRIVATE,
                                  NULL, &Returned,
                                  (LONG)sizeof(FONTMETRICS),
                                  &Metrics)) == GPI_ALTERROR) {
       CLEANUP("GpiQueryFonts", EntryName);
    }

    // Initialize message and print it.
    sprintf(achLogLine, "First Query says there are %ld Private fonts loaded", lSuccess);
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= syPosition;

    // Get the KeyNames from the INI file, put in String.
    // The KeyNames are delimited by NULLS in String.
    // String is delimited by two NULLS.
    if ((usReturn = PrfQueryProfileString(HINI_PROFILE, (PSZ) "PM_Fonts", NULL, (PSZ) "WIN Error",
                                         String,0xFFFF)) == 0)
     CLEANUP("PrfQueryProfileString", EntryName);

    lIndex=0L;

    if (usReturn > 0) {

       //Allocate a 64K segment.

       //32 bit
     if(DosAllocMem((PVOID)&FontFilePtr,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT) != 0)
      {
        CLEANUP("DosAllocMem", EntryName);
      }

      // Go through String one KeyName at a time until
      // String[lIndex] is NULL.

      Old_Fonts = 0;  Delta_Fonts = 0;  Loop_Ctr = 0;


      while (String[lIndex]) {

        Loop_Ctr++;


        strcpy(KeyName, String+lIndex);
        if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", KeyName,
                                              "Prf Error", Path, usMax)) == 0)
          CLEANUP("PrfQueryProfileString", EntryName);

        strcpy(FontFilePtr[Count].Filename,Path);

        // Initialize a message and print it
        sprintf(achLogLine, "   \t- Now Loading %s with GpiLoadFonts", Path);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;

      // Load the font
        if (!GpiLoadFonts(hAB, FontFilePtr[Count].Filename))
          CLEANUP("GpiLoadFonts", EntryName);

      // Find out how many PRIVATE fonts there are in the file.
        Returned = 0L;

        Fon1Ptr = strrchr((CHAR *)Path,'\\');  /* get last \ in path */
        Fon1Ptr++;                             /* one past \         */
        iint=0;                                /* initialize subscript */
        while (*Fon1Ptr!='.')                  /* loop til . in name */
        {                                      /*                    */
        FFile[iint] = *Fon1Ptr;                /* move a byte        */
        Fon1Ptr++;                             /* bump to next chtr  */
        iint++;                                /* bump to next chtr  */
        }                                      /*                    */
        FFile[iint] = '\0';                    /* put in whopper stopper */

        if ((lSuccess = GpiQueryFonts(hPS, QF_PRIVATE,
                                      NULL,
                                      &Returned,
                                      (LONG)sizeof(FONTMETRICS),
                                      &Metrics)) == GPI_ALTERROR) {
           CLEANUP("GpiQueryFonts", EntryName);
        }
        if (Loop_Ctr == 1)                       /* first time thru     */
          Delta_Fonts = lSuccess;                /* set up fonts loaded */
         else                                    /* otherwise           */
          Delta_Fonts = lSuccess - Old_Fonts ;   /* get the changes     */

        Old_Fonts = lSuccess ;                   /* reset for next time */

     // Setup the font specific message and print it.
        sprintf(achLogLine, "Just loaded %ld Private fonts from %s",
                                         Delta_Fonts,FFile);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;

     // Initialize the cumulative message and print it.

        sprintf(achLogLine, "Now there are %ld Private fonts loaded", lSuccess);         WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;

        Count++;
        lIndex += strlen(KeyName) + 1;
      }

      // Unload the .FON files, since we're done.
      // 32 bit
        if (DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, ucdata, ulsize) != 0)
          {
             CLEANUP("DosQuerySysInfo", EntryName);
          }
          else
          {
             DrvDir[0] = ucdata[0] + ('A' - 1);
          }

      // Above code necessary because multi-boot machine may give
      // improper drive from Prf call    J.READ   7/91

      while (--Count >= 0) {

        DrvDir[2] = '\0';                      //TSS...was 21    /*prepare       */
        strncat(DrvDir,FontFilePtr[Count].Filename,23);    /* add file name*/

//TSS...added to strip a double drive notation occurring under 1.3 but not 2.0
        if( DrvDir[1] == ':' )
            if( DrvDir[3] == ':' ) {
               strcpy( TempDrvDir, &DrvDir[2] );
               strcpy( DrvDir, TempDrvDir );
            }


 //TSS...added to determine what DrvDir is in 2.0
        CWRITELOG( L_LOTRACE, 0, DrvDir );


        lSuccess=GpiUnloadFonts(hAB, DrvDir);

        if (lSuccess == FALSE)
         {
           CLEANUP("GpiUnloadFonts", EntryName);
         }
      }
    }
    else if (usReturn == 0){
      ptl.y -=syPosition;
      sprintf(achLogLine, "There are %2d FONT files ADDED"
                          " in the Control Panel", usReturn);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -=syPosition;
    }

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    DosFreeMem((PVOID)String);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiLoadFontsExh */


/****************************************** ORIGINAL ***** .UNLOADFONT *******
 *\ddd
 * Routine Name: GpiUnloadFontsExh
 *
 * Purpose: This is an entry point for the PTT that tests the
 *          Return Codes for GpiUnloadFontsExh.
 *
 *
 *     #define INCL_GPILCIDS   Or use INCL_GPI or INCL_PM
 *
 *     BOOL  fSuccess = GpiUnloadFonts (hab, pszFilename)
 *
 *     HAB   hab;          Anchor-block handle
 *     PSZ   pszFilename;  Filename
 *
 *     BOOL  fSuccess;    Success indicator
 *
 *
 * System Requirements:
 *
 *
 * Revision Log: 01/23/90 ,PDVT, Darin C. Hafer
 *                 -Test Case Design.
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *
 *  ENTER_MAIN
 *  CLEANUP
 *  WorldWriteString
 *  EXIT_MAIN
 *
 * Limitations:
 *
 *\\end
 ****************************************************************************/
/****************************************************************************
 *\\algorithm
 *
 *   Get the anchor block
 *   For all .FON files added in the Control Panel
 *     1) Load the .FON files
 *   Endfor
 *   Query PRIVATE fonts to see how many
 *   Print how many there are
 *   For all .FON files
 *     1) Unload one .FON file
 *     2) Query PRIVATE fonts to see how many
 *     3) Print how many there are.
 *   Endfor
 *
 *\\end
 ****************************************************************************/
VOID APIENTRY GpiUnloadFontsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  typedef struct _XYZ {          // This allows me to keep a running list
           CHAR Filename[500];   // of all the .FON files and their paths
              }XYZ;              // so that I can unload them one at a time.
  XYZ *FontFilePtr=(XYZ *)NULL;  // as he/she wants as long as the sum of the
                                 // strings containing the path and filename
                                 // (in bytes) do not go beyond 64 K.

  CHAR  TempDrvDir[24];
  static PCHAR EntryName="GpiUnloadFontsExh";
  HAB    hAB;
  CHAR   Path[200];
  CHAR   KeyName[100];
  USHORT usReturn=0,usMax=200;
  LONG   lIndex=0L,
         Count=0L,
         Returned=0L;
  FONTMETRICS Metrics;
  CHAR *String=(CHAR *)NULL;

  LONG   lrc=0L;


  CHAR  DrvDir[24];                           /* to be filled in at */
  UCHAR ucdata[10];
  ULONG ulsize = 10;



  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
    }
  else {
    ENTER_MAIN(EntryName);

   strcpy( DrvDir, "?:" );

    // Initialize coordinates to 3/4 inch from top of screen.
    ptl.x = 20L;
    ptl.y = (LONG) ((pg_size_y * delta_y) - (delta_y*3L/4L));

    // Map the coordinates.
    MapPt(ptl);

    // Get the Anchor Block
    hAB = WinQueryAnchorBlock(hWndClient);

    //Allocate a 64K segment.


       //32 bit
       if(DosAllocMem((PVOID)&String,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT) != 0)
       {
          CLEANUP("DosAllocMem", EntryName);
       }


    // Initialize message and print it.
    strcpy(achLogLine, "Loading all FONT files first ...");
    WorldWriteString(ptl.x, ptl.y, achLogLine);
    ptl.y -= 2*syPosition;

    // Get the KeyNames from the INI file, put in String.
    // The KeyNames are delimited by NULLS in String.
    // String is delimited by two NULLS.
    if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", NULL, "Prf Error",
                                          String, 0xFFFF)) <= 0)
      CLEANUP("PrfQueryProfileString", EntryName);

    lIndex=0L;

    if (usReturn > 0){

      //Allocate a 64K segment.

       //32 bit
       DosAllocMem((PVOID)&FontFilePtr,65536L,PAG_READ | PAG_WRITE | PAG_COMMIT);

      // Go through String one KeyName at a time until
      // String[lIndex] is NULL.

      while (String[lIndex]) {

        strcpy(KeyName, String+lIndex);
        if ((usReturn = PrfQueryProfileString(HINI_PROFILE, "PM_Fonts", KeyName,
                                              "Prf Error", Path, usMax)) <= 0)
          CLEANUP("PrfQueryProfileString", EntryName);

        strcpy(FontFilePtr[Count].Filename,Path);

        // Load the .FON file
        if (!GpiLoadFonts(hAB, FontFilePtr[Count].Filename))
          CLEANUP("GpiLoadFonts", EntryName);

        // Count the .FON files.
        Count++;
        lIndex += strlen(KeyName) + 1;
      } /* end while */

      // Query the PRIVATE fonts, to get a number.
      if ((lSuccess = GpiQueryFonts(hPS, QF_PRIVATE,
                                    NULL, &Returned,
                                    (LONG)sizeof(FONTMETRICS),
                                    &Metrics)) == GPI_ALTERROR) {
         CLEANUP("GpiQueryFonts", EntryName);
      }

      // Initialize a message and print it.
     sprintf(achLogLine, "First Query says there are %ld Private fonts loaded",
                                                      lSuccess);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -= syPosition;

      // Unload the .FON files, one at a time.

        if (DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, ucdata, ulsize) != 0)
          {
             CLEANUP("DosQuerySysInfo", EntryName);
          }
          else
          {
             DrvDir[0] = ucdata[0] + ('A' - 1);
          }
      // Above code necessary because multi-boot machine may give
      // improper drive from Prf call    J.READ   7/91


      while (--Count >= 0) {

        // Initialize a message and print it.
        sprintf(achLogLine, "   \t- Now Unloading %s with GpiUnloadFonts",
                                              FontFilePtr[Count].Filename);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;


        // Unload the .FON file.

        DrvDir[2] = '\0';                    //TSS...was 21     /*prepare       */
        strncat(DrvDir,FontFilePtr[Count].Filename,23);    /* add file name*/


//TSS...added to strip a double drive notation occurring under 1.3 but not 2.0
        if( DrvDir[1] == ':' )
            if( DrvDir[3] == ':' ) {
               strcpy( TempDrvDir, &DrvDir[2] );
               strcpy( DrvDir, TempDrvDir );
            }
 //TSS...added to determine what DrvDir is in 2.0
        CWRITELOG( L_LOTRACE, 0, DrvDir );

        lSuccess=GpiUnloadFonts(hAB, DrvDir);
        if (lSuccess == FALSE)
         {
      //         iint=ERRIDERROR(WinGetLastError(hAB));
           CLEANUP("GpiUnloadFonts", EntryName);
         }


        // Query the fonts again and make sure the count decremented.
        Returned = 0L;
        if ((lSuccess = GpiQueryFonts(hPS, QF_PRIVATE,
                                      NULL, &Returned,
                                      (LONG)sizeof(FONTMETRICS),
                                      &Metrics)) == GPI_ALTERROR) {
           CLEANUP("GpiQueryFonts", EntryName);
        }

        // Initialize a message and print it.
        ptl.y -= syPosition;
        sprintf(achLogLine, "Next Query says there are %ld Private fonts loaded", lSuccess);
        WorldWriteString(ptl.x, ptl.y, achLogLine);
        ptl.y -= syPosition;
      }
    } /* end if */
    else if (usReturn == 0) {
      ptl.y -=syPosition;
      sprintf(achLogLine, "There are %2d FONT files ADDED"
                          " in the Control Panel", usReturn);
      WorldWriteString(ptl.x, ptl.y, achLogLine);
      ptl.y -=syPosition;
    }

    /********************************************************************
              Return the proper log messages for GPI's.
     ********************************************************************/

    DosFreeMem((PVOID)String);
    EXIT_MAIN(EntryName);
  } /* End main else */
  return;
} /* End GpiUnloadFontsExh */


//  RCB  DevQueryCapsExh has been removed 10/18/91.
//       It is now found in DevCalls.c



/***************************************************************************
 *\\ddd
 * Routine Name: FaceList
 *
 * Purpose: To print/display facenames of fonts.
 *
 *
 * System Requirements: NONE
 *
 * Revision Log: 02/12/91, PDVT, Darin C. Hafer
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    Enum           // QF_PUBLIC or QF_PRIVATE
 *    pptl           // points of where right-justified text should end.
 *    syPosition     // vertical line spacing variable
 *    Number         // Number of fonts
 *    FontStorage    // Holds the Facenames of the fonts.
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *  NONE
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Print the enumeration type.
 *
 *   For the number of fonts passed to this function
 *     For all the fonts with the same facename except for the 1st
 *     occurrence of that font.
 *       1) Make the font face name NULL.  // This will tell me that it
 *                                         // isn't the 1st occurrence.
 *       2) Increment counter of fonts with same facename
 *     Endfor
 *
 *     If the font facename is not NULL  // First occurrence of that font.
 *       Print the number of the 1st occurrence of the font in the
 *       FontStorage area, the count of how many of the same facenames
 *       exist, and the font face name.
 *     Endif
 *   Endfor
 *
 *\\end
 ***************************************************************************/
BOOL FaceList(HPS hPS, HWND hWndClient, LONG Enum, POINTL *pptl, LONG syPosition,
              LONG Number, PTEMPTYPE *FontStorage)
{
 LONG Count=0L,
      Faces=0L,
      Index=0L;
 HDC  hDC;


      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
    if ((UnMapY(pptl->y) <= 75L) && DeviceIsDisplay()) {
      if (!GpiSetCharSet(hPS,LCID_DEFAULT))
        CLEANUP("GpiSetCharSet", "FaceList");
      if (!GpiDeleteSetId(hPS,LCID_ALL))
        CLEANUP("GpiDeleteSetId", "FaceList");
      return TRUE;
    }

     hDC = GpiQueryDevice(hPS);

     // Initialize a message and print it
     switch ((int)Enum) {
       case QF_PUBLIC:
                     strcpy(achLogLine, "PUBLIC FONTS");
                     break;
       case QF_PRIVATE:
                     strcpy(achLogLine, "PRIVATE FONTS");
                     break;
       case QF_PUBLIC|QF_PRIVATE:
                     strcpy(achLogLine, "PUBLIC|PRIVATE FONTS");
                     break;
     }
     pptl->y -= syPosition;
     WorldWriteString(pptl->x, pptl->y, achLogLine);
     pptl->y -= syPosition;

     for (Index=0; Index < Number; Index++) {
       Count=1L;
       for (Faces=Index+1; Faces <= Number; Faces++) {
         if (strncmp((*FontStorage+Index)->Fontname, (*FontStorage+Faces)->Fontname, 33) == 0) {
           strcpy((*FontStorage+Faces)->Fontname, "");
           Count++;
         }
       }

       // Initialize a message and print it
       if (strcmp((*FontStorage+Index)->Fontname, "") != 0) {

      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
         if ((UnMapY(pptl->y) <= 75L) && DeviceIsDisplay()) {
           if (!GpiSetCharSet(hPS,LCID_DEFAULT))
             CLEANUP("GpiSetCharSet", "FaceList");
           if (!GpiDeleteSetId(hPS,LCID_ALL))
             CLEANUP("GpiDeleteSetId", "FaceList");
           return TRUE;
         }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
         if ((UnMapY(pptl->y) <= 50L) && DeviceIsPrinter()) {
           if ((lSuccess = DevEscape(hDC, DEVESC_NEWFRAME,
                                     0L, NULL, 0L, NULL)) == DEVESC_ERROR) {
             CLEANUP("DevEscape", "FaceList");
             return FALSE;
           }
           GpiSetCharSet(hPS, DESIRED_FONT_ID);
           TEST_SIGNATURE(0,0);
           pptl->y=MapY((LONG) (pg_size_y) * delta_y);
           pptl->y -= 2*syPosition;
         }

         sprintf(achLogLine, "    %5ld %5ld %s", Index, Count, (*FontStorage+Index)->Fontname);
         WorldWriteString(pptl->x, pptl->y, achLogLine);
         pptl->y -= syPosition;
       }
     }
     return TRUE;
}


/***************************************************************************
 *\\ddd
 * Routine Name: PrintFonts
 *
 * Purpose: To get, create, and print info about the fonts.
 *
 *
 * System Requirements: NONE
 *
 * Revision Log: 02/18/91, PDVT, Darin C. Hafer
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    pptl           // coordinates on paper/display
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *  NONE
 *
 * Limitations:
 *
 * This is called from GpiCreateLogFontExh after having
 * already created a logical font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   If output is to the display and at bottom of display, return -1.
 *   If output is to the printer and at bottom of page
 *     Start a new page (DevEscape).
 *     Return to the default font.
 *     Print test signature.
 *     Print header.
 *     Return to previous logical font when this function was called.
 *   Endif
 *
 *   Print the font facename in its native typeface.
 *
 *   Delete the logical font and return to the default.
 *
 *   Print NominalPointSize, Match Number, CodePage, Bold or not,
 *   Underline or not, Italic or not, Outline or not.
 *
 *\\end
 ***************************************************************************/
LONG PrintFonts(HPS hPS, HWND hWndClient, POINTL *pptl)
{
  HDC   hDC;
  LONG  yChar, xVal;
  FONTMETRICS fm;

   // HDC used in DevEscape call
   hDC = GpiQueryDevice(hPS);

   // Get fontmetrics of Current Logical Font.
   if (!GpiQueryFontMetrics(hPS, (LONG)sizeof(FONTMETRICS), &fm)) {
     CLEANUP("GpiQueryFontMetrics", "PrintFonts");
     return 1L;
   }

   yChar = fm.lMaxBaselineExt + fm.lExternalLeading;
   if (syPosition > (SHORT)yChar)
     pptl->y -= syPosition;
   else
     pptl->y -= yChar;


      // Quit if the output is to the display and the current
      // position is 3/4 inches from the bottom of the page.
   if ((UnMapY(pptl->y) <= 75L) && DeviceIsDisplay()) {
     if (!GpiSetCharSet(hPS,LCID_DEFAULT))
       CLEANUP("GpiSetCharSet", "PrintFonts");
     if (!GpiDeleteSetId(hPS,LCID_ALL))
       CLEANUP("GpiDeleteSetId", "PrintFonts");
     return -1L;
   }

      // If the output is to the printer and the current position
      // is 1/2 inch from the bottom of the page, start a new page,
      // print the test signature in the same font as the first page,
      // and reset the x,y coordinates.
   if ((UnMapY(pptl->y) <= 50L) && DeviceIsPrinter()) {
     if ((lSuccess = DevEscape(hDC, DEVESC_NEWFRAME,
                               0L, NULL, 0L, NULL)) == DEVESC_ERROR) {
       CLEANUP("DevEscape", "PrintFonts");
       return 1L;
     }

     if (!GpiSetCharSet(hPS,DESIRED_FONT_ID)) {
       CLEANUP("GpiSetCharSet", "PrintFonts");
       return 1L;
     }
     TEST_SIGNATURE(0,0);
     pptl->y=MapY((LONG) (pg_size_y) * delta_y);
     pptl->y -= 2*syPosition;
     sprintf(achLogLine, "%s", "FACENAME (Unique Codepoints)");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     xVal = pptl->x;
     pptl->x += MapX(400);
     sprintf(achLogLine, "%s", "POINT");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(70);
     sprintf(achLogLine, "%s", "MATCH");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(100);
     sprintf(achLogLine, "%s", "CDPG");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(65);
     sprintf(achLogLine, "%s", "B");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(30);
     sprintf(achLogLine, "%s", "U");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(30);
     sprintf(achLogLine, "%s", "I");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     pptl->x += MapX(30);
     sprintf(achLogLine, "%s", "Defn");
     WorldWriteString(pptl->x, pptl->y, achLogLine);

     // Move down two lines.
     pptl->x = xVal;
     pptl->y -= 2*syPosition;

     if (!GpiSetCharSet(hPS,USER_LCID)) {
       CLEANUP("GpiSetCharSet", "PrintFonts");
       return 1L;
     }
   } /* End Printer */

   sprintf(achLogLine, "%s (%c%c%c%c%c%c)", fm.szFacename,157,126,166,150,242,128);
   GpiMove(hPS, pptl);
   GpiCharString(hPS, (LONG)strlen(achLogLine), achLogLine);

   if (!GpiSetCharSet(hPS,LCID_DEFAULT)) {
     CLEANUP("GpiSetCharSet", "PrintFonts");
     return 1L;
   }
   if (!GpiDeleteSetId(hPS,USER_LCID)) {
     CLEANUP("GpiDeleteSetId", "PrintFonts");
     return 1L;
   }

   GpiQueryCurrentPosition(hPS, pptl);

   if ( (UnMapX(pptl->x) >= 420) || (UnMapX(pptl->x) < 0L) )
      pptl->y -= syPosition;
               //TSS...was 460
   pptl->x = MapX(420L);
   sprintf(achLogLine, "%4d", fm.sNominalPointSize);
   WorldWriteString(pptl->x, pptl->y, achLogLine);

   pptl->x += MapX(70);
   sprintf(achLogLine, "%4ld", fm.lMatch);
   WorldWriteString(pptl->x, pptl->y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
   if DeviceIsDisplay()
     pptl->x += MapX(100);
   else if DeviceIsPrinter()
                   //TSS...was 70
     pptl->x += MapX(100);
   sprintf(achLogLine, "%u", fm.usCodePage);
   WorldWriteString(pptl->x, pptl->y, achLogLine);

    // To make display output look as much like printer output,
    // the x coordinates will differ.
   if DeviceIsDisplay()
     pptl->x += MapX(45);
   else if DeviceIsPrinter()
     pptl->x += MapX(65);
   if (fm.usWeightClass & FM_SEL_BOLD)
     WorldWriteString(pptl->x, pptl->y, "1");
   else
     WorldWriteString(pptl->x, pptl->y, "0");

   pptl->x += MapX(30);
   if (fm.fsSelection & FM_SEL_UNDERSCORE)
     WorldWriteString(pptl->x, pptl->y, "1");
   else
     WorldWriteString(pptl->x, pptl->y, "0");

   pptl->x += MapX(30);
   if (fm.fsSelection & FM_SEL_ITALIC)
     WorldWriteString(pptl->x, pptl->y, "1");
   else
     WorldWriteString(pptl->x, pptl->y, "0");

   pptl->x += MapX(30);
   if (fm.fsDefn & FM_DEFN_OUTLINE)
     WorldWriteString(pptl->x, pptl->y, "OUTLINE");
   else
     WorldWriteString(pptl->x, pptl->y, "IMAGE");

   pptl->x = MapX(20L);
 return 0L;
}

