#include <search.h>
#ifndef COMMON_H
#define COMMOM_H
/***************************************************************************
 *\\ddd
 * Subtask Name: PDVT (Phase II).
 *
 * Module name: COMMON.H
 *
 * Purpose: This Include file was created to provide a consistant format for
 *          error logging. Also, this file include all functions that
 *          are necessary to create a logical font to use for drawing
 *          text on current device.
 *
 * Revision Log:  01/22/91,PDVT (Phase II),David McCombs.
 *                                     -First draft:
 *                01/24/91 ,PDVT ,Mike Abuzant
 *                              - Wrote functions and macros.
 *                03/04/91 ,PDVT ,Mike Abuzant
 *                              - Included a new set_delta() and gpi_grid() functions.
 *                                              03/16/91 ,PDVT ,David McCombs.
 *                                              - New format specifiers for LogInfo, ErrorStatus,
 *                                                SetEnter and SetExit functions.
 * Contents:
 *              - function prototypes
 *              - define's specific to COMMON.C
 *
 * Limitations:
 *   none at this time.
 *
 *\\end
 ***************************************************************************/

#ifndef CWRITELOG

   #error COMMON.H must be included after PTTDLLDF.H .

#endif

#ifdef MapX
   #undef     MapX
   #undef     MapY
   #undef     UnMapX
   #undef     UnMapY
#endif


#define SizeX(rXin)  (LONG)(CommonXMult*(double)(rXin)/(double)dev_width+0.5)

#define SizeY(rYin)  (LONG)(CommonYMult*(double)(rYin)/(double)dev_height+0.5)

#define MapX(rXin) (LONG)((CommonXMult*(double)(rXin)-1.0)/(double)dev_width+0.5)

#define MapY(rYin) (LONG)((CommonYMult*(double)(rYin)-1.0)/(double)dev_height+0.5)

#define UnMapX(rXin) (LONG) (((double)(rXin) * (double)dev_width     \
                              /(double)pg_width + 1.0) /             \
                               ((double)hori_pels_per_m * 0.000254))

#define UnMapY(rYin) (LONG) (((double)(rYin) * (double)dev_height    \
                              /(double)pg_height + 1.0) /            \
                               ((double)vert_pels_per_m * 0.000254))


#define DeletePrinterOutput(EntryName)                                  \
              if DeviceIsPrinter(){                                     \
                 if (DevEscape(GpiQueryDevice(hPS),DEVESC_ABORTDOC,0L   \
                               ,NULL, NULL,NULL)==DEVESC_ERROR)         \
                       SHOWERROR("DevEscape()",EntryName);              \
              }

#define DeviceIsDisplay()                                                                                                                               \
                        (alDevCaps[CAPS_TECHNOLOGY] == CAPS_TECH_RASTER_DISPLAY)

#define DeviceIsPrinter()       (!DeviceIsDisplay())


#define NTESTS      ARRAYLEN(EntryPointList)

#define TOKENIZEFUNCTIONNAME(FunctionName) {#FunctionName,FunctionName}

#define ARRAYLEN(ArrayName)  (sizeof(ArrayName)/sizeof(ArrayName[0]))

#define SUBENTER( errnum, addmessage)                                                                                             \
                  (VOID) SubEnter(hWndClient,#errnum, addmessage)

#define SUBEXIT()                                                         \
                        (VOID) SubExit(hWndClient)

#define CLEANUP(Function,ExitPoint)                                       \
         (VOID)CleanUp(Function,hWndClient,ExitPoint,                     \
                  &ErrorCount,__FILE__,__LINE__,TRUE)

#define SHOWERROR(Function,ExitPoint)                                     \
         (VOID)CleanUp(Function,hWndClient,ExitPoint,                     \
                  &ErrorCount,__FILE__,__LINE__,FALSE)

#define EXIT_MAIN(ExitPoint)                                              \
         (VOID)ExitMain(ExitPoint,hWndClient,ErrorCount)


#define ENTER_MAIN(EntryPoint)                                            \
        (VOID)EnterMain(hPS,hWndClient,EntryPoint,&ErrorCount)

#define CHECKRC(ReturnCode,ErrorToCheck,Message)                          \
        ErrorCount +=                                                     \
            CheckRc(hWndClient,(LONG)ReturnCode,(USHORT)ErrorToCheck,     \
            #ErrorToCheck,Message,__FILE__,__LINE__)

#define CHECKRC1(ReturnCode,ErrorToCheck,Message)                          \
        ErrorCount +=                                                      \
            CheckRc1(hWndClient,(LONG)ReturnCode,(USHORT)ErrorToCheck,     \
            #ErrorToCheck,Message,__FILE__,__LINE__)

#define MapAndWriteString(x,y,String)                                     \
          (VOID)WriteString(hWndClient,hPS,MapX((LONG)(x)),               \
                            MapY((LONG)(y)),String)

#define WorldWriteString(x,y,String)                                     \
          (VOID)WriteString(hWndClient,hPS,(LONG)(x),                    \
                            (LONG)(y),String)


#define   DESIRED_FONT_ID   LCID_DEFAULT

#define   MAX_STORAGE       (2000*sizeof(SEL))

#define   ONE_MEGBYTE       (1024L*1024L)

#define   BIG_FILENAME      "c:\\__PTT__._B_"

#define   DEFAULT_FONT_NAME "C:\\OS2\\DLL\\COURIER.FON"

#define   CREATE_TESTING_ENV 0x0F0F

#define   CLEAN_TESTING_ENV  0x0F1F

#define SETENTER(text1, text2)                                                                                                 \
                  (VOID) SetEnter(hWndClient, text1, text2)

#define SETEXIT()                                                        \
                        (VOID) SetExit(hWndClient)

#define ERRSTATUS(bFailoption,text1,text2)                               \
         (BOOL) ErrorStatus(hWndClient,ErrorCount,bFailoption,text1,text2)

#define LOGINFO(LogOption,TypeFlag,TextToLog)                            \
         (VOID) LogInfo(hWndClient,LogOption,TypeFlag,TextToLog )

#define NO_OUTPUT()                                                      \
        (VOID) MapAndWriteString(200L, 120L,"This test has no output!")

#define ABORTENTRY(EntryName, Setting)                                   \
        DeletePrinterOutput(EntryName);                                  \
        (VOID) AbortEntry(hWndClient, EntryName, Setting)

// Level 0

// No Format Specifiers are necessary - cwritelog is not
// called at this level.


// Levels 1, 2, and 3 (default).

#define ERRORC_SPEC   "     $ERRORCOUNT = %d\n"
#define PASS_SPEC     "     $%-61s- PASS.\n"
#define FAIL_SPEC     "     $%-61s- FAIL.\n"
#define TEST_SPEC     "     $%-61s- %-4s.\n"
#define CLEANUP_SPEC  "          $Unexpected Errors - Cannot continue.\n"

// Level 7

#define ATPMERR_SPEC  "               @%s\n"

// Level 7

# define ERR_PASS_SPEC  "      @ %-54s- PASS.\n"
# define ERR_FAIL_SPEC  "      @ %-43sERROR#%-4.4x - FAIL.\n"
# define STAT_INFO_SPEC "      * %-56s\n"

// Level 8 and 9.

#define ENTRY_SPEC    "  +ee+ %-62s - Entry.\n"
#define EXIT_SPEC     "  +ex+ %-62s - Exit.\n"
#define IENTRY_SPEC   "    +ie+ %-56s - Entry.\n"
#define IEXIT_SPEC    "    +ix+ %-56s - Exit.\n"

// Level 8

#define SET_SPEC       "    +se+ %-56s - Setup.\n"
#define SET_EXIT_SPEC  "    +sx+ %-56s - End Setup.\n"

// Level independant.(Set by user)

# define LOG_SPEC        "       %1s %-60s\n"

// These defines are used when calling the grid function

#define HALF_INCH 1L
#define ONE_INCH  2L
#define TWO_INCH  4L
#define HALFINCH        HALF_INCH
#define INCH            ONE_INCH
#define TWOINCH   TWO_INCH

/* This variable is used for line space and is
   accessable by test cases.
                                                   */
SHORT   syPosition;

extern LONG   pg_width, pg_height, vert_pels_per_m;
extern LONG   dev_height, dev_width, hori_pels_per_m;
extern LONG   pg_size_x, pg_size_y,delta_x,delta_y;
extern LONG   x_units_per_inch, y_units_per_inch;
extern double CommonXMult,CommonYMult;

typedef struct _NAMES_AND_ADDRESSES
          {
            CHAR   TestName[NAMELENGTH];
            PDLLFN TestAddress;
          } NAMES_AND_ADDRESSES;

typedef struct _TEMPTYPE{
                        CHAR Fontname[33];
                        LONG lMatch;
                        USHORT fsSelection;
                        USHORT usCodePage;
                        USHORT fsFontUse;
}TEMPTYPE;

typedef TEMPTYPE  FAR *PTEMPTYPE;

static BOOL InitDefaultPrintFont(HPS ,HWND );

VOID WriteString(HWND ,HPS ,LONG ,LONG ,CHAR * );


char * lfind( const char *, const char *, unsigned int *,
unsigned int, int ( * __compare )( const void *, const void *) );
//unsigned int, int ( * __compare )( const USHORT *, const PFONTMETRICS) );
//BSC^

//static INT FontResolutionFunction(const USHORT * ,const  PFONTMETRICS );
//static INT PointSizeFunction(const USHORT *,const PFONTMETRICS );
//static INT DevicePointSizeFunction(const USHORT * ,const PFONTMETRICS );
//BSC V
static INT FontResolutionFunction(const void * ,const void * );
static INT PointSizeFunction(const void *,const void * );
static INT DevicePointSizeFunction(const void * ,const void * );

//16 static INT _cdecl FontResolutionFunction(const USHORT * ,const  PFONTMETRICS );
//16 static INT _cdecl PointSizeFunction(const USHORT *,const PFONTMETRICS );
//16 static INT _cdecl DevicePointSizeFunction(const USHORT * ,const PFONTMETRICS );

VOID CleanUp(CHAR *,HWND ,CHAR *,PLONG ,PSZ ,USHORT,BOOL);

LONG CheckRc(HWND ,LONG ,USHORT ,CHAR *,CHAR *,PSZ ,USHORT );

LONG CheckRc1(HWND ,LONG ,USHORT ,CHAR *,CHAR *,PSZ ,USHORT );

VOID ExitMain(CHAR * ,HWND ,LONG );

VOID EnterMain(HPS ,HWND ,CHAR * ,PLONG );

VOID SubExit(HWND);

VOID SubEnter(HWND ,CHAR * ,CHAR * );

static LONG CreateCourFont(HPS ,LONG );

HDC  set_delta(HPS );

VOID gpi_grid (HPS , LONG );

VOID SetEnter(HWND ,CHAR * ,CHAR * );
VOID AbortEntry(HWND, CHAR *, CHAR *);
VOID SetExit(HWND);
BOOL ErrorStatus(HWND, LONG, BOOL, CHAR *, CHAR *);
VOID LogInfo(HWND, SHORT, CHAR *, CHAR *);
BOOL EzQueryFonts(HPS, HWND,LONG,PLONG,PTEMPTYPE *);
LONG EzCreateLogicalFonts(HPS, HWND, LONG ,TEMPTYPE);

BOOL CreatTestingEnv(PSEL ahSEL);
VOID CleanTestingEnv(PSEL ahSEL);
BOOL InitNoMemoryTesting(USHORT usOperationToPerform);

#endif
