#define INCL_WIN
#define INCL_GPI
#define INCL_ERRORS

#include <os2.h>
#include "PTTDLLDF.h"
#include "routines.h"
#include "std_util.h"

extern int error_count;
/***************************************************************************
 *\\ddd
 * Routine Name: check_rtn
 *
 * Purpose: This function reports to CWRITELOG complexity unexpected
 *      indicator and call REPORTSETUPERROR in case of an ERROR.
 *
 * Revision Log: 11/12/90, PDVT, Gisselle Labault
 *                 - testcase design
 *               11/13/90, PDVT, Gisselle Labault
 *                 - design implementation
 *
 * Inputs:
 *   complx         // complexity indicator
 *   hWndClient     // client window
 *
 * Outputs: none
 *
 * Subroutines Required: CWRITELOG(), REPORTSETUPERROR()
 *
 * Limitations: none
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 * {
 *   switch(complx)
 *     RGN_RECT: CWRITELOG(L_FAIL,...)
 *     RGN_COMPLEX: CWRITELOG(L_FAIL,...)
 *     RGN_NULL: CWRITELOG(L_FAIL,...)
 *     RGN_ERROR: REPORTSETUPERROR()
 *   endcase
 * }
 *\\end
 ***************************************************************************/
VOID check_rtn(INT complx, HWND hWndClient, CHAR function_name[])
{

  switch(complx)
  {
      case RGN_RECT:
        CWRITELOG(L_FAIL,0,"Unexpected Indicator: RGN_RECT                        -    FAIL.\n");
        break;

      case RGN_COMPLEX:
        CWRITELOG(L_FAIL,0,"Unexpected Indicator: RGN_COMPLEX                     -    FAIL.\n");
        break;

      case RGN_NULL:
        CWRITELOG(L_FAIL,0,"Unexpected Indicator: RGN_NULL                        -    FAIL.\n");
        break;

      case RGN_ERROR:
        BADERROR(function_name, FALSE, NULL);
        break;
  }
  ++error_count;
}

/***************************************************************************
 *\\ddd
 * Routine Name: rvis_returned_rtn
 *
 * Purpose: This function reports to CWRITELOG unexpected visibility
 *      indicator and call REPORTSETUPERROR in case of an ERROR.
 *
 * Systems Requirements: none
 *
 * Revision Log: 11/5/90, PDVT, Gisselle Labault
 *                 - initial creation
 *               11/12/90, PDVT, Gisselle Labault
 *                 - design implementation
 *
 * Inputs:
 *   rvis_returned  // numeric visibility indicator
 *   hWndClient     // client window
 *
 * Outputs: none
 *
 * Subroutines Required: CWRITELOG(), REPORTSETUPERROR()
 *
 * Limitations: none
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 * {
 *   switch(rvis_returned_rtn)
 *     RVIS_INVISIBLE: CWRITELOG(L_FAIL,...)
 *
 *     RVIS_VISIBLE: CWRITELOG(L_FAIL,...)
 *
 *     RVIS_PARTIAL: CWRITELOG(L_FAIL,...)
 *
 *     RVIS_ERROR: REPORTSETUPERROR()
 *   endcase
 * }
 *\\end
 ***************************************************************************/
VOID rvis_returned_rtn(INT rvis_returned, HWND hWndClient, CHAR function_name[])
{

  switch (rvis_returned)
  {
     case RVIS_INVISIBLE:
       CWRITELOG(L_FAIL,0,"Unexpected Indicator: INVISIBLE                       -    FAIL.\n");
       break;

     case RVIS_VISIBLE:
       CWRITELOG(L_FAIL,0,"Unexpected Indicator: VISIBLE                         -    FAIL.\n");
       break;

     case RVIS_PARTIAL:
       CWRITELOG(L_FAIL,0,"Unexpected Indicator: PARTIAL                         -    FAIL.\n");
       break;

     case RVIS_ERROR:
       BADERROR(function_name, FALSE, NULL);
       break;
  }
  ++error_count;
}

/***************************************************************************
 *\\ddd
 * Routine Name: display_text
 *
 * Purpose: This function displays string in clipping area.
 *
 * Revision Log: 11/16/90, PDVT, Gisselle Labault
 *                 - testcase design
 *               11/16/90, PDVT, Gisselle Labault
 *                 - design implementation
 *
 * Inputs:
 *   hPS        // presentation space
 *   column     // column position
 *   row        // row position
 *   str_msg        // string to be display
 *
 * Outputs: none
 *
 * Subroutines Required: GpiMove(), GpiCharString(), strlen()
 *
 * Limitations: none
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 * {
 *   set i to zero
 *   while i is less than or equal row
 *     display string
 *     get to next row
 *   enddo
 * }
 *\\end
 ***************************************************************************/

VOID display_text(HPS hPS, LONG column, LONG row, CHAR str_msg[])
{
  POINTL ptl;

  ptl.y = line_space/4;
  while(MapY(ptl.y) <= MapY(row)) // display text/characters in clipping area
  {
    ptl.x = column;
    MapAndWriteString(hPS, ptl.x, ptl.y, str_msg);
    ptl.y = ptl.y + line_space;
  }  /* endwhile */
}

