PROJ = gpiclip
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ge- /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

IMPLIB = implib/NOIGNORECASE

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = gpiclip.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = gpiclip.DEF

OBJS = gpiclip.obj  clip_rtn.obj \
       routines.obj gpi_grid.obj std_util.obj \
       stdutil2.obj stdutil3.obj pttdllvr.obj

.dll.lib:
        $(IMPLIB) $*.lib $*.dll

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).dll

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc

gpiclip.obj : gpiclip.c gpiclip.h pttdlldf.h std_util.h stdutil3.h gpi_grid.h routines.h
    $(compile) /Fo$@ gpiclip.c

clip_rtn.obj : clip_rtn.c pttdlldf.h std_util.h gpi_grid.h routines.h
    $(compile) /Fo$@ clip_rtn.c

routines.obj : routines.c pttdlldf.h std_util.h routines.h
    $(compile) /Fo$@ routines.c

gpi_grid.obj : gpi_grid.c pttdlldf.h
    $(compile) /Fo$@ gpi_grid.c

std_util.obj : std_util.c pttdlldf.h
    $(compile) /Fo$@ std_util.c

stdutil2.obj : stdutil2.c pttdlldf.h
    $(compile) /Fo$@ stdutil2.c

stdutil3.obj : stdutil3.c pttdlldf.h
    $(compile) /Fo$@ stdutil3.c

pttdllvr.obj : pttdllvr.c pttdlldf.h
    $(compile) /Fo$@ pttdllvr.c

gpiclip.dll : $(OBJS)
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),gpiclip.dll,gpiclip.map,$(LLIBS),gpiclip.def

