#define INCL_DEV      // include all DEV definitions
#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gpi error definitions
#define INCL_FONTFILEFORMAT
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <search.h>
#include <malloc.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpichar.h"


#define PI 3.141592654
#define TWOPI 6.283185307
#define PISCALE  (PI / 180.0)
#define HALFPI (PI / 2.0)
#define LONGSCALEX 30000
#define LONGSCALEY 30000


/***************************************************************************
 *\\ddd
 * Routine Name: DrawCircle
 *
 * Purpose: To draw a circle of text of a specified radius.
 *
 *
 * System Requirements: NONE
 *
 * Revision Log: 02/18/91, PDVT, Stan Logan
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    pptl           // coordinates on paper/display
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *  NONE
 *
 * Limitations:
 *
 * This is called from GpiSetAndQryCharAngle after having
 * already created a logical font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Set center of concentric circles to (4", 3.75").
 *      Move character position to (1", 1").
 *      Query character mode to reset after drawing circle.
 *      For index = 0 until index = length of output string
 *              Calculate x and y coordinates of angle, where angle is based on
 *                      (360 / length of string) * index.
 *              Set character angle using calculated values.
 *              If character mode <> CM_MODE1, map point on circle of specified radius.
 *              If string length > 130 (outline string of all three modes), set mode
 *                      based on which third of the string is being printed.
 *              Put next character in string format.
 *              If character mode <> CM_MODE1, print string at calculated point
 *                      else print string at current position.
 *      End for
 *      Reset character mode to initial setting.
 *
 *\\end
 ***************************************************************************/

BOOL DrawCircle(HPS hPS, CHAR *out, double RadiusFactor)
{
        LONG                    i,                              //      loop variable
                                        Mode;                   //      initial character mode
        GRADIENTL       Angle;          //      angle vector structure
        CHAR                    strout[2];      //      output string
        POINTL          center,         //      point structure of center of circle
                                        ptlangle;       //      point structure of character on circle


        center.x = 4 * delta_x;
        center.y = (LONG)(3.75 * delta_x);

        ptlangle.x = delta_x;
        ptlangle.y = delta_y;
        MapPt(ptlangle);

        if(GpiMove(hPS, &ptlangle)==FALSE)
                return FALSE;

        if((Mode = GpiQueryCharMode(hPS))==FALSE)
                return FALSE;


        for (i=0; i<strlen(out); i++) {
                Angle.x = (LONG)(cos((double)(i * (360.0 / strlen(out)) * PISCALE))
                                                                                                                                                                        * LONGSCALEX);
                Angle.y = (LONG)(sin((double)(i * (360.0 / strlen(out)) * PISCALE))
                                                                                                                                                                        * LONGSCALEY);

                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        return FALSE;

                if(Mode != CM_MODE1) {
                        ptlangle.x = center.x + (LONG)(cos((double)(i * (360.0 / strlen(out))
                                                                                                        * PISCALE) - HALFPI) * RadiusFactor);
                        ptlangle.y = center.y + (LONG)(sin((double)(i * (360.0 / strlen(out))
                                                                                                        * PISCALE) - HALFPI) * RadiusFactor);
                        MapPt(ptlangle);
                }

                if (strlen(out) > 130)
                        switch((INT)(i/46)) {
                                case 1: GpiSetCharMode(hPS, CM_MODE1);
                                                        break;
                                case 2: GpiSetCharMode(hPS, CM_MODE2);
                                                        break;
                                case 3: GpiSetCharMode(hPS, CM_MODE3);
                                                        break;
                                default:        break;
                        }
                strout[0] = out[i];
                strout[1] = '\0';

                if((Mode == CM_MODE2))
                  if(GpiCharStringAt(hPS, &ptlangle, (LONG)strlen(strout), strout) == GPI_ERROR)
                      return FALSE;

                if((Mode == CM_MODE3))
                  if(GpiCharStringAt(hPS, &ptlangle, (LONG)strlen(strout), strout) == GPI_ERROR)
                     return FALSE;




                if(Mode == CM_MODE1)
                  if(GpiCharString(hPS, (LONG)strlen(strout), strout)==GPI_ERROR)
                    return FALSE;
         }
        if(GpiSetCharMode(hPS, Mode)==FALSE)
                return FALSE;

        return TRUE;

}

/***************************************************************************
 *\\ddd
 * Routine Name: DrawQueryBoxText
 *
 * Purpose: To draw lines of text of varying widths and heights.
 *
 *
 * System Requirements: NONE
 *
 * Revision Log: 02/18/91, PDVT, Stan Logan
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    pptl           // coordinates on paper/display
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *  NONE
 *
 * Limitations:
 *
 * This is called from GpiSetAndQryCharBox after having
 * already created a logical font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Set current font to be an image font.
 *      Query current character box for proper box size for image font.
 *      If font to be drawn is outline, set box size to 6 characters per inch
 *              else set box size to current character box size.
 *      For index = 0 until index = 5
 *              Query current character mode.
 *              If drawing image text from right to left or outline text,
 *                      Set character box to proper box size.
 *                      Set current font to image or outline, based on boolean parameter.
 *                      Build output string.
 *                      Query to get the box coordinates surrounding the string.
 *                      Set starting point x coordinate to queried concatenation point +
 *                              current character position.
 *              Decrement y field of the character position.
 *              Change sign on character box dimensions corresponding to index.
 *              Set current font to image or outline, based on boolean parameter.
 *              Set character box to default box for font selection.
 *              Draw width and height signs (+, -, 0).
 *              Set character box with proper width and height signs.
 *              Draw output string at specified position.
 *      End for
 *
 *\\end
 ***************************************************************************/

BOOL DrawQueryBoxText(HPS hPS, POINTL ptl, BOOL Image)
{
        LONG            i,                                                      //      loop variable
                                Mode;                                           //      current character mode
        CHAR            out[50];                                        //      output string
        SIZEF           ptl2,                                           //      base box structure
                                ptl3,                                           //      sign box structure
                                ptlout;                                 //      actual box structure
        SIZEL           Defaultbox;                             //      current character box structure
        BOOL            ReturnValue=FALSE;      //      boolean variable
        POINTL  ptlmap,                                 //      point structure at which to draw strings
                                Points[TXTBOX_COUNT],// point structures defining box
                                ptltemp;                                        //      point structure at which to draw signs

        static LONG sign[7][2]={        { 1, 1},
                                                                                {-1, 1},
                                                                                { 1,-1},
                                                                                {-1,-1},
                                                                                { 1, 0},
                                                                                { 0, 1},
                                                                                { 0, 0} };
        static CHAR *strtype[] ={       "normal",
                                                                                "backwards",
                                                                                "upside-down",
                                                                                "backwards & upside-down",
                                                                                "horizontal",
                                                                                "vertical",
                                                                                "point" };

        Image   ? (ReturnValue=GpiSetCharSet(hPS, DESIRED_FONT_ID))
                        : (ReturnValue=GpiSetCharSet(hPS, 5L));

        if (ReturnValue==FALSE)
                return FALSE;

        if(GpiQueryDefCharBox(hPS, &Defaultbox)==FALSE)
                return FALSE;

        if (!Image)     {
                ptl2.cx = (FIXED)(65536.0 * MapX(delta_x / 6.0));
                ptl2.cy = (FIXED)(65536.0 * MapY(delta_y / 6.0));
        }
        else
                if DeviceIsDisplay() {
                        ptl2.cx = (FIXED)(Defaultbox.cx * 1.5 * 65536.0);
                        ptl2.cy = (FIXED)(Defaultbox.cy * 1.5 * 65536.0);
                }
                else {
                        ptl2.cx = (FIXED)(Defaultbox.cx * 65536.0);
                        ptl2.cy = (FIXED)(Defaultbox.cy * 65536.0);
                }

        ptl3.cx = (FIXED)(Defaultbox.cx * 65536.0);
        ptl3.cy = (FIXED)(Defaultbox.cy * 65536.0);

        for(i=0; i<7; i++) {
                Mode = GpiQueryCharMode(hPS);
                if(Mode <= 0)
                        return FALSE;

                if (((i!=1)&&(i!=3))||(Image && (Mode==CM_MODE1)))
                        ptlmap.x = MapX(ptl.x);
                else {
                        if(GpiSetCharBox(hPS, &ptl2)==FALSE)
                                return FALSE;

                        Image   ? (ReturnValue=GpiSetCharSet(hPS, DESIRED_FONT_ID))
                                        : (ReturnValue=GpiSetCharSet(hPS, 5L));

                        if (ReturnValue==FALSE)
                                return FALSE;

                        sprintf(out,"%s %s", strtype[i],
                                                                                        (i<3) ? (Image ? "Image" : "Outline") : "");

                        if(GpiQueryTextBox(hPS, (LONG)strlen(out), out, TXTBOX_COUNT,
                                                                                                                                                                Points)==FALSE)
                                return FALSE;

                        ptlmap.x = Points[TXTBOX_CONCAT].x + MapX(ptl.x);
                }
                ptlmap.y = MapY(ptl.y -= (delta_y / 5L));

                ptlout.cx = ptl2.cx * sign[i][0];
                ptlout.cy = ptl2.cy * sign[i][1];

                Image   ? (ReturnValue = GpiSetCharSet(hPS, DESIRED_FONT_ID))
                                : (ReturnValue = GpiSetCharSet(hPS, 5L));

                if (ReturnValue==FALSE)
                        return FALSE;

                if(GpiSetCharBox(hPS, &ptl3)==FALSE)
                        return FALSE;

                ptltemp.x = MapX(Image ? (LONG)(4.6 * delta_x) : (LONG)(1.6 * delta_x));
                ptltemp.y = ptlmap.y;

                sprintf(out,"%c %c", ((ptlout.cx!=0)? ((ptlout.cx>0)? '+': '-'): '0'),
                                                                        ((ptlout.cy!=0)? ((ptlout.cy>0)? '+': '-'): '0'));

                if(GpiCharStringAt(hPS, &ptltemp, (LONG)strlen(out), out)==GPI_ERROR)
                        return FALSE;

                if(GpiSetCharBox(hPS, &ptlout)==FALSE)
                        return FALSE;

                sprintf(out,"%s %s", strtype[i],
                                                                                        (i<3) ? (Image ? "Image" : "Outline") : "");

                if(GpiCharStringAt(hPS, &ptlmap, (LONG)strlen(out), out)==GPI_ERROR)
                        return FALSE;
        }
        return TRUE;
}

/***************************************************************************
 *\\ddd
 * Routine Name: DrawShearText
 *
 * Purpose: To draw lines of text of various shear values.
 *
 *
 * System Requirements: NONE
 *
 * Revision Log: 02/18/91, PDVT, Stan Logan
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    pptl           // coordinates on paper/display
 *
 * Outputs:
 *  NONE
 *
 * Subroutines Required:
 *  NONE
 *
 * Limitations:
 *
 * This is called from GpiSetAndQryCharShear after having
 * already created a logical font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      For index = 0 until index = 4
 *              Calculate scaling factors.
 *              Calculate shear vectors based on  150 degrees - (30 * index).
 *              Set shearing based on calculated values.
 *              Calculate starting position coordinates.
 *              Set current font to image or outline, based on boolean parameter.
 *              Build and draw text.
 *      End for
 *
 *\\end
 ***************************************************************************/

BOOL DrawShearText(HPS hPS, SIZEF ptl, BOOL Image)
{
        INT     i;                  //      loop variable
        CHAR    out[30];            //      output string
        POINTL  ptl2;               //      point structure
        LONG    XLONGSCALE,         // x scaling factor
                YLONGSCALE;         //      y scaling factor
        double  x,                  //      x coordinate in inches
                y;                  //      y coordinate in inches
        BOOL    ReturnValue;        //      boolean variable

        for(i=0; i<5; i++) {
                XLONGSCALE = *pBasisX / 100;
                YLONGSCALE = *pBasisY / 100;

                ptl2.x = (LONG)(cos((150.0 - (30.0 * i)) * (double)PISCALE) *
                                                                                                                                                (double)(XLONGSCALE));
                ptl2.y = (LONG)(sin((150.0 - (30.0 * i)) * (double)PISCALE) *
                                                                                                                                                (double)(YLONGSCALE));

                if (ptl2.y==0L) ptl2.y=1L;

                if(GpiSetCharShear(hPS, &ptl2)==FALSE)
                        return FALSE;

                x=(double)ptl.cx/65536.0;
                y=((double)ptl.cy/65536.0) - ((double)i/5.0);

                ptl2.x = (LONG)(x * delta_x);
                ptl2.y = (LONG)(y * delta_y);
                MapPt(ptl2);

                if(GpiMove(hPS, &ptl2)==FALSE)
                        return FALSE;

                if (Image) {
                    ReturnValue=GpiSetCharSet(hPS, DESIRED_FONT_ID);
                }
                else
                     ReturnValue=GpiSetCharSet(hPS, 5L);

                if (ReturnValue==FALSE)
                        return FALSE;

                sprintf(out,"This %s text is sheared.", (Image ? "image" : "outline"));

                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        return FALSE;
        }
        return TRUE;
}


INT _Optlink FunctionPtr(const VOID *arg1, const VOID *arg2)
{
        PSHORT arg3;
        PFONTMETRICS arg4;
        BOOL George;
        BOOL Test;
        arg4 = (PFONTMETRICS)arg2;
        arg3 = (PSHORT)arg1;
        Test = (arg4->fsDefn & FM_DEFN_OUTLINE);

        George = !((*arg3 == arg4->sNominalPointSize) &&
                                 (Outline ? Test : (!Test)));
        return George;
}

/***************************************************************************
 *\\ddd
 * Routine Name: FindLogicalFonts
 *
 * Purpose: To find and create a font whose parameters are passed to this
 *         routine.
 *
 * System Requirements: Font desired must be installed.
 *
 * Revision Log: 02/18/91, PDVT, Stan Logan
 *               - Function Implementation
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    pptl           // coordinates on paper/display
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              FunctionPtr
 *
 * Limitations:
 *
 *              NONE
 *
 * This routine finds a public font which best meets the requirements and
 * creates the corresponding logical font.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Query to get number of fonts supported by the device.
 *      Allocate storage for fonts.
 *      Query to get fontmetrics for all fonts supported.
 *      Set flag based on whether outline or image font is desired.
 *      Find font with matching point size.
 *      Compare other features of matching point size with desired font.
 *      If font matches, create logical font.
 *
 *\\end
 ***************************************************************************/

BOOL    FindLogicalFonts(HPS hPS, LONG lcid, FONTTYPE FontStorage)
{
        FONTMETRICS  *pfm;
        void         *pmem;
        static FATTRS   Fattr;                                          //      font attributes structure
        PFONTMETRICS    FontPtr=(PFONTMETRICS)NULL;                                                //      fontmetrics structure
        LONG                            Returned=0L,                            //      # of fontmetrics returned
                                                Requested=0L,                           //      # of fonts requested
                                                Number;                                         //      # of fonts found
        UINT                            usNumber;                                       //      unsigned parameter
        BOOL                            Return = FALSE;                 //      boolean variable
        CHAR                            Name[33];                                       //      font name
   FONTMETRICS fmMetrics;
   BOOL bSuccess;

   //Get total number of fonts supported by the current device

   if ((Number = GpiQueryFonts(hPS, QF_PUBLIC, FontStorage.Fontname,
                                                                                                &Requested, NULLHANDLE, NULLHANDLE)) == GPI_ALTERROR)
       return(FALSE);

   // Allocate storage for "Number" fonts

  if ((pfm=(PFONTMETRICS)malloc((SHORT)Number*sizeof(FONTMETRICS)))==NULLHANDLE)
        return FALSE;



   // Call GpiQueryFonts again to request "Number" fonts and their
   // metrics to be returned in the space pointed to by "pfm"

   if ((Returned = GpiQueryFonts(hPS, QF_PUBLIC, FontStorage.Fontname,
                                                &Number, (LONG)sizeof(FONTMETRICS), pfm)) == GPI_ALTERROR) {
     free(pfm);
     return(FALSE);
   }

        Outline = ((FontStorage.fsFontUse & FATTR_FONTUSE_OUTLINE) == 4);

        // Search for the point size specified to determine if it
        // matches any font with the specified family name

                usNumber = (UINT)Number;
                FontPtr=(PFONTMETRICS)lfind((CHAR *)&FontStorage.PointSize, (CHAR *)pfm,
//                                                                &usNumber, (INT)sizeof(FONTMETRICS), (INT)FunctionPtr);
                                                                &usNumber, (INT)sizeof(FONTMETRICS), FunctionPtr);

        // compare the font found to determine if it matches the font desired

                if (FontPtr!=NULLHANDLE)      // If NULLHANDLE then the fonts have been modified
                        if(strcmp(FontPtr->szFacename, FontStorage.Fontname)==0)
                                if(((FontPtr->fsDefn & FM_DEFN_OUTLINE) &&
                                        (FontStorage.fsFontUse & FATTR_FONTUSE_OUTLINE)) ||
                                        (!(FontPtr->fsDefn & FM_DEFN_OUTLINE) &&
                                        !(FontStorage.fsFontUse & FATTR_FONTUSE_OUTLINE))) {

                                        Fattr.usRecordLength    = sizeof(Fattr);
                                        Fattr.fsSelection               = FontStorage.fsSelection;
                                        Fattr.lMatch                    = FontPtr->lMatch;
                                        Fattr.fsType                    = FATTR_TYPE_KERNING;
                                        if (FontPtr->fsDefn == FM_DEFN_OUTLINE)
                                                Fattr.fsFontUse = FATTR_FONTUSE_OUTLINE;
                                        Fattr.usCodePage                = FontStorage.usCodePage;
                                        strcpy(Fattr.szFacename,FontStorage.Fontname);
                                        strcpy(Name, "Testing");
                                        if (GpiCreateLogFont(hPS, (PSTR8)Name, lcid, &Fattr)
                                                                                                                                                                        ==GPI_ERROR) {
                                                free(pfm);
                                                return FALSE;
                                        }
                                        else {
                                                free(pfm);
      bSuccess = GpiQueryFontMetrics(hPS, sizeof(fmMetrics),
                                           &fmMetrics);
                                                return TRUE;
                                        }
                                }
        free(pfm);
        return FALSE;
}
