PROJ = gpichar
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ge- /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

IMPLIB = implib/NOIGNORECASE

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = gpichar.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = gpichar.DEF

OBJS  = gpichar.obj \
        gpichar2.obj \
        gpicharr.obj \
        common.obj \
        pttdllvr.obj

.dll.lib:
        $(IMPLIB) $*.lib $*.dll

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).dll

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc

gpichar2.obj : gpichar2.c gpichar.h common.h
   $(compile) /Fo$@ gpichar2.c

gpichar.obj : gpichar.c gpichar.h common.h
   $(compile) /Fo$@ gpichar.c

gpicharr.obj : gpicharr.c gpichar.h common.h
   $(compile) /Fo$@ gpicharr.c

common.obj : common.c common.h
    $(compile) /Fo$@ common.c

PTTDLLVR.OBJ: PTTDLLVR.C PTTDLLDF.H ERRORS.H
    $(compile) /Fo$@ pttdllvr.c

gpichar.dll: $(OBJS)
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),gpichar.dll,gpichar.map,$(LLIBS),gpichar.def

