#ifndef GPICHAR_H
#define GPICHAR_H
/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: CHARTEST
 *
 * Purpose: Include file for CHARTEST dll.
 *
 *  $header$
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *
 * SRS References: Section 6.4
 *
 * Contents:  This file contains the following definitions:
 *              - function prototypes
 *                                       - defines specific to CHARTEST
 *
 * Limitations:
 *           none
 *\\end
 *****************************************************************************/



/* declare all dll functions */


VOID APIENTRY   InitTest(PVOID sel, PTESTINITINFO pInitInfo);
VOID APIENTRY   GpiCharTestPre1(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharTestPre2(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharTestApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall);

VOID APIENTRY   GpiSetAndQryCharAngleExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiSetAndQryCharBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiSetAndQryCharDirExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiSetAndQryCharModeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiSetAndQryCharShearExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringAtExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAndQryExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAndQryShadeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAndQryBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAtAndQryExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAtAndQryShdExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiCharStringPosAtAndQryBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiQryDefCharBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY   GpiQryTextBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall);
BOOL    DrawCircle(HPS hPS, CHAR out[125], double RadiusFactor);
BOOL    DrawQueryBoxText(HPS hPS, POINTL ptl, BOOL Image);
BOOL    DrawShearText(HPS hPS, SIZEF ptl, BOOL Image);
BOOL    DrawQueryTextBoxText(HPS hPS, PPOINTL ptl, CHAR *out);
BOOL    Outline;

BOOL CreateSysImageFont(HPS,HWND,LONG,PSZ,SHORT,SHORT);
BOOL CreateDeviceImageFont(HPS,HWND,LONG,PSZ,SHORT,SHORT);
BOOL CreateDeviceOutlineFont(HPS,HWND,LONG,PSZ,USHORT);
BOOL CreateSysOutlineFont(HPS,HWND,LONG,PSZ,USHORT);

static CHAR * TestCaseName = "GpiChar";
static  NAMES_AND_ADDRESSES EntryPointList[]= {
        TOKENIZEFUNCTIONNAME(GpiCharTestPre1),
        TOKENIZEFUNCTIONNAME(GpiCharTestPre2),
        TOKENIZEFUNCTIONNAME(GpiCharTestApp1),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryCharAngleExh),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryCharBoxExh),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryCharDirExh),
       TOKENIZEFUNCTIONNAME(GpiSetAndQryCharModeExh),
        TOKENIZEFUNCTIONNAME(GpiSetAndQryCharShearExh),
       TOKENIZEFUNCTIONNAME(GpiCharStringExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringAtExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAndQryExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAndQryShadeExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAndQryBoxExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAtAndQryExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAtAndQryShdExh),
        TOKENIZEFUNCTIONNAME(GpiCharStringPosAtAndQryBoxExh),
        TOKENIZEFUNCTIONNAME(GpiQryDefCharBoxExh),
        TOKENIZEFUNCTIONNAME(GpiQryTextBoxExh),
    };

typedef struct _FONTTYPE{
                        CHAR            Fontname[33];
                        USHORT  fsSelection;
                        USHORT  usCodePage;
                        USHORT  fsFontUse;
                        SHORT           PointSize;
}FONTTYPE;

typedef FONTTYPE  FAR *PFONTTYPE;

BOOL    FindLogicalFonts(HPS hPS, LONG lcid, FONTTYPE FontStorage);

#define USER_LCID 1L

#define  SwapPoints(aptl)  {                                                                                                                              \
                                                                                POINTL  Temp;                                                                                     \
                                                                                Temp=aptl[TXTBOX_TOPRIGHT];                                               \
                                                                                aptl[TXTBOX_TOPRIGHT]=aptl[TXTBOX_BOTTOMRIGHT];\
                                                                                aptl[TXTBOX_BOTTOMRIGHT]=Temp;                                    \
                                                                                aptl[TXTBOX_CONCAT]=aptl[TXTBOX_TOPLEFT];                 \
                        };

#define AddStruct(Points) {                                                                                                                               \
                                                         Points[TXTBOX_TOPLEFT].x               +=Points[TXTBOX_CONCAT].x;\
                                                         Points[TXTBOX_TOPLEFT].y               +=Points[TXTBOX_CONCAT].y;\
                                                         Points[TXTBOX_BOTTOMLEFT].x    +=Points[TXTBOX_CONCAT].x;\
                                                         Points[TXTBOX_BOTTOMLEFT].y    +=Points[TXTBOX_CONCAT].y;\
                                                         Points[TXTBOX_TOPRIGHT].x              +=Points[TXTBOX_CONCAT].x;\
                                                         Points[TXTBOX_TOPRIGHT].y              +=Points[TXTBOX_CONCAT].y;\
                                                         Points[TXTBOX_BOTTOMRIGHT].x   +=Points[TXTBOX_CONCAT].x;\
                                                         Points[TXTBOX_BOTTOMRIGHT].y   +=Points[TXTBOX_CONCAT].y;\
                        };

#define DoCircle(outstr, factor)                                                                                                                          \
                                (BOOL)DrawCircle(hPS, outstr, factor)
#define DoQueryBoxText(ptl, Image)                                                                                                                \
                                (BOOL)DrawQueryBoxText(hPS, ptl, Image)
#define DoShearText(ptl, Image)                                                                                                                   \
                                (BOOL)DrawShearText(hPS, ptl, Image)
#define DoTextBoxText(ptl, out)                                                                                                                   \
                                (BOOL)DrawQueryTextBoxText(hPS, ptl, out)
#define min(a, b) (((a) < (b)) ? (a) : (b))

#endif
