

#define INCL_DEV      // include all DEV definitions
#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gpi error definitions
#define INCL_FONTFILEFORMAT
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpichar.h"

#define PI 3.141592654
#define TWOPI 6.283185307
#define PISCALE  (PI / 180.0)
#define HALFPI (PI / 2.0)
#define LONGSCALEX 30000
#define LONGSCALEY 30000
#define OUTLINE_FONT "Courier"



/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: GPICHAR
 *
 * Purpose: This module is called by the PTT to test the Gpi Char API's,
 *                              not including return codes.
 *
 * Revision Log: 1/3/91, PDVT, Stanley Logan
 *                                              - created initial module template
 *                                        2/1/91, PDVT, Stanley Logan
 *                                              - Test Case Design
 *
 *
 * SRS References: Section ???
 *
 * Contents:
 *   InitTest()
 *   GpiCharTestPre1()
 *   GpiCharTestPre2()
 *   GpiCharTestApp1()
 *   GpiSetAndQryCharAngleExh()
 *   GpiSetAndQryCharBoxExh()
 *   GpiSetAndQryCharDirExh()
 *   GpiSetAndQryCharModeExh()
 *   GpiSetAndQryCharShearExh()
 *   GpiCharStringExh()
 *   GpiCharStringAtExh()
 *   GpiCharStringPosAndQryExh()
 *   GpiCharStringPosAtAndQryExh()
 *   GpiQryDefCharBoxExh()
 *   GpiQryTextBoxExh()
 *
 *
 * Design Overview:
 *    This testcase is designed to test some of the Gpi text functions that:
 *
 *    1.        Set and query the current value of the baseline angle.
 *    2.        Set and query the current value of the character bax attribute.
 *    3.        Set and query the current value of the character direction attribute.
 *    4.        Set and query the current value of the character-mode attribute.
 *    5.        Set and query the current value of the character-shear angle.
 *              6.      Draw a character string at the current character position.
 *              7.      Draw a character string at a specified character position.
 *    8.        Set and query the position at which each character in a string
 *                      is drawn with positioning controls.
 *    9.        Set and query the position at which each character in a positioned
 *                      string is drawn with positioning controls.
 *   10.        Query the size of the default graphics character box.
 *   11.        Query the relative coordinates of the four corners of a text box.
 *
 *    This testcase includes application tests that are designed to test the
 * behavier of these character functions with other Gpi's.
 *
 *    Also, testing includes both exhaustive and return error codes
 * functions for each and every GPI function in this testcase. (Return
 *      error codes are tested in a supplementary module).
 *
 * Limitations:
 *
 *              Both the outline and bitmap versions of the Courier and Helv fonts
 *              MUST be installed on the system through the Control Panel.
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\ddd
 * Routine Name: InitTest
 *
 * Purpose: Initialize function name and address array for ptt.
 *
 * System Requirements: NONE
 *
 * Revision Log: 01/07/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *
 * Inputs:
 *   sel           //passed through to the InitTestSegVars function
 *   init_info_p   // name and address array used by ptt interface
 *
 * Outputs:
 *   init_info_p   // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the ptt interface
 *
 * Limitations:
 *   init_info_p is of size ENTRYPOINTS defined in ptt.h and pttdlldf.h(both)
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\\ algorithm
 * {
 *    for all test functions in this test case {
 *        init_info_p->function name = function name[i]
 *        init_info_p->function address = function address[i]
 *    }
 *    call inittestsegvars routine
 * }
 *\\end
 *****************************************************************************/
VOID InitTest(PVOID Selector, PTESTINITINFO init_info_p)
{
        register USHORT usTestCounter;

        init_info_p->ntests = NTESTS;
        strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

        for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

               init_info_p->test_addrs[usTestCounter]= EntryPointList[usTestCounter].TestAddress;
                strcpy(init_info_p->test_names[usTestCounter],EntryPointList[usTestCounter].TestName);
        }

        InitTestSegVars(Selector);  /* this call used by the ptt interface */

}


// end InitTest


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharTestPre1
 *
 * Purpose:  This is an entry point for the PTT that causes the first
 *                               precision test for the character GPI's to be run.
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               - Corrected problems with font selection
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              CreateSysImageFont
 *              CreateImageFont
 *              EXIT_MAIN
 *
 * Limitations:
 *              Devices with only outline fonts will use outline fonts,
 *              this will cause different output as characters will be
 *              rotated.
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      If possible
 *         Set current font to be an image font (1st try device then system).
 *      Else use the default font
 *      Draw grid.
 *      Set angle to 45 degrees.
 *      Set up character positioning array so that characters are one-half inch
 *              over and one-half inch above previous character.
 *      Print string "CharStrPos" at 45 degree angle.
 *      Set angle to 270 degrees.
 *      Set up character positioning array so that characters are one-half inch
 *              below previous character.
 *      Print string "CharAngle" at 270 degree angle.
 *      Set angle to 0 degrees.
 *      Set up character positioning array so that characters are one-half inch
 *              over from previous character.
 *      Print string "CharStringPosAt" at 0 degree angle.
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/
VOID   GpiCharTestPre1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharTestPre1";    //      entry point name
        CHAR                            output[60];                                                     //      output string
        FONTTYPE                        FontStorage;                                            //      font structure
        POINTL                  ptl;                                                                    //      point structure
        GRADIENTL               Angle;                                                          //      angle vector structure
        LONG                            Adx[15],                                                                //      positioning array
                                                ErrorCount,                                                     //      error count
                                                Sum;                                                                    //      var used in calculations
        INT                             i;                                                                              //      loop variable


        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Create system image font if printing to the display
                if DeviceIsDisplay() {
                        if(!ErrorCount) {
                                strcpy(FontStorage.Fontname,"Courier");
                                FontStorage.fsSelection=0;
                                FontStorage.fsFontUse=0;
                                FontStorage.usCodePage=0;
                                FontStorage.PointSize=100;
                                if(FindLogicalFonts(hPS, DESIRED_FONT_ID, FontStorage)==FALSE)
                                        SHOWERROR("FindLogicalFonts", EntryName);
                        }
                }

//      Set current font to be an image font.
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Draw half-inch grid for precision testing
                gpi_grid(hPS, HALF_INCH);

//      Set angle to 45 degrees.
                Angle.x = MapX(delta_x);
                Angle.y = MapY(delta_y);
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

// Set character position pointer
                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = delta_y;
                MapPt(ptl);

                GpiMove(hPS, &ptl);

// Build output string
                sprintf(output, "CharStrPos");

//      Set up character positioning array so that characters are one-half inch
//              over and one-half inch above previous character.
                Sum=0;
                for(i = 0; i < (INT)strlen(output); i++) {
                        Adx[i] = (LONG)(sqrt(MapX(delta_x / 2.0) * MapX(delta_x / 2.0) * 1.0
                                                                         + MapY(delta_y / 2.0) * MapY(delta_y / 2.0) * 1.0)
                                                                         * (float)(i + 1) - Sum);
                        Sum += Adx[i];
                }

// Set current character mode to CM_MODE2
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//      Print string "CharStrPos" at 45 degree angle.
                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_VECTOR,
                                                                                (LONG)strlen(output), output,   Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

//      Set angle to 270 degrees.
                Angle.x =  0;
                Angle.y = -1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

//Build output string
                sprintf(output, "CharAngle");

//      Set up character positioning array so that characters are one-half inch
//              below previous character.
                Sum = 0;
                for(i = 0; i < (INT)strlen(output); i++) {
                        Adx[i] = MapY(delta_y * 0.5 * (float)(i + 1)) - Sum;
                        Sum += Adx[i];
                }

//      Print string "CharAngle" at 270 degree angle.
                if(GpiCharStringPos(hPS, NULL, CHS_VECTOR,
                                                                                (LONG)strlen(output), output,   Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPos", EntryName);

//      Set angle to 0 degrees.
                Angle.x = 0;
                Angle.y = 0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

// Build output string
                sprintf(output, "CharStringPosAt");

//      Set up character positioning array so that characters are one-half inch
//              over from previous character.
                Sum = 0;
                for(i = 0; i < (INT)strlen(output); i++) {
                        Adx[i] = MapX(delta_x * 0.5 * (float)(i + 1)) - Sum;
                        Sum += Adx[i];
                }

//      Print string "CharStringPosAt" at 0 degree angle.
                if(GpiCharStringPosAt(hPS, &ptl, NULL, CHS_VECTOR,
                                                                                (LONG)strlen(output), output,   Adx)==GPI_ERROR)
                        SHOWERROR("GpiCharStringPosAt", EntryName);

// Set current font to default font
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

//      Delete all logical fonts.
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharTestPre2
 *
 * Purpose:  This is an entry point for the PTT that causes the second
 *                               precision test for the character GPI's to be run.
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               - Fixed font selection
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              CreateSysImageFont
 *              CreateImageFont
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      If possible
 *            Set current font to be an image font.
 *               (only look for device fonts. System font too small at
                 high resolution.)
 *      Else use the default font
 *      Draw grid.
 *      Set coordinates to draw string 1.5 inches up from bottom edge.
 *      Draw string 1.5 inches up from bottom edge.
 *      Set coordinates to draw string 2 inches up from bottom edge.
 *      Draw string 2 inches up from bottom edge.
 *      Set coordinates to draw string 3 inches up from bottom edge.
 *      Draw string 3 inches up from bottom edge.
 *      Set coordinates to draw string 5 inches up from bottom edge.
 *      Draw string 5 inches up from bottom edge.
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/
VOID   GpiCharTestPre2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharTestPre2";    //      entry point name
        CHAR                            output[60];   //      output string
        POINTL         ptl;                 //      point structure
        LONG           ErrorCount;           //      error count
        BOOL           fontfound=FALSE;
        char           sout[80];


        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

                  // try to create an image font
                  // if cannot create then use the default font

                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                      if DeviceIsPrinter() {
                          sprintf(sout,"No Device Image Font Found");
                          ptl.x = (LONG)(0.5 * delta_x);
                          ptl.y = 8*delta_y;
                          MapPt(ptl);

                          if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(sout), sout)==GPI_ERROR)
                              SHOWERROR("GpiCharString", EntryName);

                      } // end Device check
                    } // end if

//      Set current font to be an image font.

        if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

        } // end if

//
// Draw half-inch grid for precision testing
                gpi_grid(hPS, HALF_INCH);

//      Set coordinates to draw string 1.5 inches up from bottom edge.
                ptl.x = delta_x;
                ptl.y = (LONG)(delta_y * 1.5);
                MapPt(ptl);

// Build output string
                sprintf(output, "CharStringAt one and one-half inch from bottom edge");

//      Draw string 1.5 inches up from bottom edge.
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Set coordinates to draw string 2 inches up from bottom edge.
                ptl.x = delta_x;
                ptl.y = delta_y * 2;
                MapPt(ptl);

//      Draw string 2 inches up from bottom edge.
                sprintf(output, "CharStringAt two inches from bottom edge");
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Set coordinates to draw string 3 inches up from bottom edge.
                ptl.x = delta_x;
                ptl.y = delta_y * 3;
                MapPt(ptl);

//      Draw string 3 inches up from bottom edge.
                sprintf(output, "CharStringAt three inches from bottom edge");
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

//      Set coordinates to draw string 5 inches up from bottom edge.
                ptl.x = delta_x;
                ptl.y = delta_y * 5;
                MapPt(ptl);

//      Draw string 5 inches up from bottom edge.
                sprintf(output, "CharStringAt five inches from bottom edge");
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set current font to default font
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

//      Delete all logical fonts.
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiCharTestApp1
 *
 * Purpose:  This is an entry point for the PTT that causes the Gpi Char
 *           application test to be run.
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               - Corrected problems in font selection
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              CreateSysOutlineFont
 *              EXIT_MAIN
 *
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Set current font to be an outline font.
 *      Set coordinates for box.
 *      Draw box.
 *      Position pointer and draw string "PDVT".
 *      Draw string ", phase2".
 *      Change character direction to be top to bottom.
 *      Position pointer and draw strings "rint", "river", "erification", "ool".
 *      Change character direction to be left to right.
 *      Change angle to be 90 degrees.
 *      Position pointer and draw string "The Latest!"
 *      Change angle to be 270 degrees.
 *      Position pointer and draw string "The Greatest!"
 *      Change angle to be 0 degrees.
 *      Change shear angle to be 135 degrees.
 *      Position pointer and draw string "sponsored by our client"
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/
VOID   GpiCharTestApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiCharTestApp1";    //      entry point name
        POINTL          ptl,                            //      point structure
                        Shear,                          //      shear vector structure
                        Points[TXTBOX_COUNT];           //      array of text box points
        SIZEF           Box;                            //      character box structure
        GRADIENTL       Angle;                          //      angle vector structure
        LONG            lcid,                           //      logical font id
                        ErrorCount;                     //      error count
        CHAR            out[150];                       //      output string
        INT             i;                              //      loop variable

   FONTMETRICS          fmMetrics;
   BOOL                 bSuccess;
   BOOL                 fontfound=FALSE;
        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

//      Create system outline font

                lcid=5;

    if ((fontfound=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                        FATTR_SEL_OUTLINE))==FALSE)
       {
         sprintf(out,"No OutLine Font Found");
         ptl.x = (LONG)(0.5 * delta_x);
         ptl.y = 7.0*delta_y;
         MapPt(ptl);

         if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if

// Set up points for box
                Points[0].x = Points[3].x = Points[4].x = (LONG)(2.5 * delta_x);
                Points[0].y = Points[1].y = Points[4].y = (LONG)(0.75 * delta_y);
                Points[1].x = Points[2].x = (LONG)(6.75 * delta_x);
                Points[2].y = Points[3].y = (LONG)(6.25 * delta_y);

//Convert units to world coordinates
                for(i=0; i<5; i++)
                        MapPt(Points[i]);

// Move to starting point of box. Necessary for GpiPolyLine.
                if(GpiMove(hPS, &Points[0])==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Draw box
                if(GpiPolyLine(hPS, 5L, Points)==GPI_ERROR)
                        SHOWERROR("GpiPolyLine", EntryName);

// Build output string
                sprintf(out,"PDVT");

// Set current font to system outline font
            if (fontfound) {
                if(GpiSetCharSet(hPS,lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);
            }

// Set character box to 1.5 per inch
                Box.cx = (FIXED)(MapX(delta_x / 1.5) * 65536.0);
                   //TSS...temp change from Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 1.5) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Calculate character position
                ptl.x = 3 * delta_x;
                ptl.y = (LONG)(4.5 * delta_y);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set character mode to CM_MODE2
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Build output string
                sprintf(out,", phase2");

// Set character box to 6 characters per inch
                Box.cx = (FIXED)(MapX(delta_x / 6.0) * 65536.0);
                Box.cy = (FIXED)(MapY(delta_y / 6.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Draw string at current position
                if(GpiCharString(hPS, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set character box to 4 characters per inch
                Box.cx = (FIXED)(MapX(delta_x / 4.0) * 65536.0);
                Box.cy = (FIXED)(MapY(delta_y / 4.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Build output string
                sprintf(out,"rint");

// Set character direction to top to bottom
                if(GpiSetCharDirection(hPS, CHDIRN_TOPBOTTOM)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Calculate character position
                ptl.x = (LONG)(2.75 * delta_x) + (LONG)(delta_x / 2.5);
                ptl.y = (LONG)(4.5 * delta_y) - UnMapY(syPosition);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Build output string
                sprintf(out,"river");

// Calculate character position
                ptl.x = (LONG)(2.75 * delta_x) + 2 * (LONG)(delta_x / 2.5);
                ptl.y = (LONG)(4.5 * delta_y) - UnMapY(syPosition);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Build output string
                sprintf(out,"erification");

// Calculate character position
                ptl.x = (LONG)(2.75 * delta_x) + 3 * (LONG)(delta_x / 2.5);
                ptl.y = (LONG)(4.5 * delta_y) - UnMapY(syPosition);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Build output string
                sprintf(out,"ool");

// Calculate character position
                ptl.x = (LONG)(2.75 * delta_x) + 4 * (LONG)(delta_x / 2.5);
                ptl.y = (LONG)(4.5 * delta_y) - UnMapY(syPosition);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set current character direction to default setting
                if(GpiSetCharDirection(hPS, CHDIRN_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Build output string
                sprintf(out,"The Latest!");

// Set character box to 4 character / inch
                Box.cx = (FIXED)(MapX(delta_x / 4.0) * 65536.0);
                   //TSS...changed from Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 4.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);


// Set angle to 90 degrees
                Angle.x = 0;
                Angle.y = 1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

// Calculate character position
                ptl.x = (LONG)(2.75 * delta_x);
                ptl.y = (LONG)(2.75 * delta_y);
                MapPt(ptl);


//TSS...copied temp.
// Set character box to 4 character / inch
                Box.cx = (FIXED)(MapX(delta_x / 4.0) * 65536.0);
                   //TSS...changed from Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 4.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Draw string at specified position
      bSuccess = GpiQueryFontMetrics(hPS, sizeof(fmMetrics),
                                           &fmMetrics);
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Build output string
                sprintf(out,"The Greatest!");

// Set angle to 270 degrees
                Angle.x =  0;
                Angle.y = -1;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

// Calculate character position
                ptl.x = (LONG)(6.5 * delta_x);
                ptl.y = (LONG)(4.5 * delta_y);
                MapPt(ptl);


//TSS...copied temp.
// Set character box to 4 character / inch
                Box.cx = (FIXED)(MapX(delta_x / 4.0) * 65536.0);
                   //TSS...changed from Box.cy = Box.cx
                Box.cy = (FIXED)(MapY(delta_y / 4.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);


// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set character shear value to 45 degrees left
                Shear.x = (LONG)MapX(delta_x * -1);
                Shear.y = (LONG)MapY(delta_y);

                if(GpiSetCharShear(hPS, &Shear)==FALSE)
                        SHOWERROR("GpiSetCharShear", EntryName);

// Build output string
                sprintf(out,"sponsored by our client");

// Set angle to default
                Angle.x =  0;
                Angle.y =  0;
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                        SHOWERROR("GpiSetCharAngle", EntryName);

// Calculate character position
                ptl.x = (LONG)(3.0 * delta_x);
                ptl.y = (LONG)(1.0 * delta_y);
                MapPt(ptl);

// Draw string at specified position
                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set current font to default font
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}



/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryCharAngleExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryCharAngle()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               - Corrected problems with font selection
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsDisplay
 *              CreateSysImageFonts
 *              CreateImageFonts
 *              CreateSysOutlineFonts
 *              SUBENTER
 *              SUBEXIT
 *              LOGINFO
 *              DrawCircle
 *              EXIT_MAIN
 *
 * Limitations:
 *              If there are no device image fonts, system image fonts
 *              will be used, but the output gets very small at high
 *              resolutions.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Define image font and outline font.
 *      Set current box to be 6 character per inch.
 *      Check return code PMERR_FONT_AND_MODE_MISMATCH.
 *      Set current mode to be CM_MODE2.
 *      Draw image font circle with radius = 2.5 inches.
 *      Set current mode to be CM_MODE1.
 *      Draw image font circle with radius = 2.5 inches.  This should actually be
 *              a line drawn at (1", 1").
 *      Set current font to be an outline font.
 *      Set current mode to be CM_MODE3.
 *      Draw outline font circle with radius = 2 inches.
 *      Draw outline font arc from   0 - 120 in CM_MODE1 with radius = 2.25 inches.
 *      Draw outline font arc from 120 - 240 in CM_MODE2 with radius = 2.25 inches.
 *      Draw outline font arc from 240 - 360 in CM_MODE3 with radius = 2.25 inches.
 *      Delete all logical fonts.
 *      For angle set at 1 degree to angle set at 360 degrees
 *              Set angle.
 *              Query angle.
 *              If queried angle <> set angle, output log error message.
 *      End for.
 *
 *\\end
 ***************************************************************************/

VOID   GpiSetAndQryCharAngleExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiSetAndQryCharAngleExh";   //      entry point name
        GRADIENTL       Angle1,    //      angle to set
                        Angle2;    //      angle to query
        INT             i;         //      loop variable
        LONG            ErrorCount, //      error count
                        lcid;       //      logical font id
        double          Radius;     //      radius
        CHAR            outstr[150]; //      output string
        SIZEF           Box;         //      box structure
        BOOL            ReturnValue; //      return code value
        BOOL            fontfound=FALSE;
        BOOL            fontfound1=FALSE;
        CHAR            out[100];            //      output string
        POINTL          pt;                  //      point structure

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                      if DeviceIsPrinter() {
                          sprintf(out,"No Device Image Font Found");
                          pt.x = (LONG)(0.5 * delta_x);
                          pt.y = 8*delta_y;
                          MapPt(pt);

                          if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                              SHOWERROR("GpiCharString", EntryName);

                      }


                      if ((fontfound=CreateSysImageFont(hPS,hWndClient,
                                          DESIRED_FONT_ID,NULL,0,120))==FALSE)
                       {
                        if DeviceIsPrinter() {
                         sprintf(out,"No System Image Font Found");

                         pt.x = (LONG)(0.5 * delta_x);
                         pt.y = 7.5*delta_y;
                         MapPt(pt);
                        }
                         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                             SHOWERROR("GpiCharString", EntryName);
                       } // end if
                    } // end if

                lcid=5;

   // create an outline font


    if ((fontfound1=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                                          FATTR_SEL_OUTLINE))==FALSE)
       {
        if DeviceIsPrinter() {
         sprintf(out,"No OutLine Font Found");
         pt.x = (LONG)(0.5 * delta_x);
         pt.y = 7.0*delta_y;
         MapPt(pt);
        }

         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if

//      Set current box to be 6 character per inch.
                Box.cx = (FIXED)(MapX((double)delta_x / 6.0) * 65536.0);
                  //TSS...changed from Box.cy = Box.cx
                Box.cy = (FIXED)(MapY((double)delta_y / 6.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

   /**************************************************************
    * The following Code will check for PMERR_FONT_AND_MODE_MISMATCH
    **************************************************************/
              if (fontfound) { //Have an image font

                SUBENTER(PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                        if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);



                        if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                                SHOWERROR("GpiSetCharMode", EntryName);

                        Radius = (double)(delta_x / 4);  //Was 4 - JAH

                        strcpy(outstr,  "Shouldn't see an image font in CM_MODE3.");

                        ReturnValue = DoCircle(outstr, Radius);

                        CHECKRC(ReturnValue, PMERR_FONT_AND_MODE_MISMATCH, "test 1");


                SUBEXIT();


// Set character mode to CM_MODE2
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

//      Set radius of inner circle
                Radius = (double)(2.5 * delta_x);

// Build output string
                strcpy(outstr,
                                "This is an image font tested in character mode CM_MODE2."
                                "  Text isn't rotated.   ");

// Call DoCircle to draw circle
                ReturnValue = DoCircle(outstr, Radius);
                if (!ReturnValue)
                        SHOWERROR("DrawCircle", EntryName);

// Set character mode to CM_MODE1
                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE) //Was CM_MODE1 - JAH
                        SHOWERROR("GpiSetCharMode", EntryName);

// Set dummy radius of flat line of text
                Radius = (double)(2.5 * delta_x);

//      Build output string
                strcpy(outstr,
                                "This image font in CM_MODE1 should act as if the angle = 0. ");

// Call DoCircle to draw circle
                ReturnValue = DoCircle(outstr, Radius);
                if (!ReturnValue)
                        SHOWERROR("DrawCircle", EntryName);

// Set character box to 5 characters / inch
                Box.cx = (FIXED)(MapX((double)delta_x / 5.0) * 65536.0);
                // TSS...was cy = cy
                Box.cy = (FIXED)(MapY((double)delta_y / 5.0) * 65536.0);
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

              } //end if for fontfound check

// Set current font to be an outline font
            if (fontfound1) {
                if(GpiSetCharSet(hPS, lcid)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set character mode to CM_MODE3
                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Set radius for inner outline circle
                Radius = (double)(2 * delta_x);

// Build output string
                strcpy(outstr,
                                "Outline fonts do not change when character mode is changed. "
                                " They should follow the circle and rotate  each character.  ");

// Call DoCircle to draw circle
                ReturnValue = DoCircle(outstr, Radius);
                if (!ReturnValue)
                        SHOWERROR("DrawCircle", EntryName);

// Set radius for inner outline circle
                Radius = (double)(2.25 * delta_x);

// Build output string
                strcpy(outstr,
                                "Outline font in character mode CM_MODE1   |   Outline font i"
                                "n character mode CM_MODE2   |   Outline font in character mo"
                                "de CM_MODE3   |   ");

// Call DoCircle to draw circle
                ReturnValue = DoCircle(outstr, Radius);
                if (!ReturnValue)
                        SHOWERROR("DrawCircle", EntryName);

// Set current font to default
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

            } // end if for fontfound 1 check

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

// Exhaustively test all angles from 0 to 360.  This is done by first
// setting the angle, then subsequently querying the angle.
                for (i=0; i < 360; i++) {
                        Angle1.x = (LONG)(cos((double)i * PISCALE) * LONGSCALEX);
                        Angle1.y = (LONG)(sin((double)i * PISCALE)      * LONGSCALEY);

                        if(GpiSetCharAngle(hPS, &Angle1)==FALSE)
                                SHOWERROR("GpiSetCharAngle", EntryName);

                        if(GpiQueryCharAngle(hPS, &Angle2)==FALSE)
                                SHOWERROR("GpiQueryCharAngle", EntryName);

                        if(((Angle1.x == 1) && (Angle1.y == 0)) &&
                                                                                                        ((Angle2.x == 0) && (Angle2.y == 0)))
                                Angle2.x = Angle1.x;

                        if((Angle1.x != Angle2.x) || (Angle1.y != Angle2.y)) {
                                sprintf(outstr, "Failure of GpiQueryCharAngle().  Angle set and"
                                                                        " angle queried were not equal.");
                                LOGINFO((INT)4, "@", outstr);
                        }
                }

                EXIT_MAIN(EntryName);
 }
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryCharBoxExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GreQueryCharBox()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design
 *               - Changed font selection
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              CreateSysImageFonts
 *              CreateImageFonts
 *              CreateSysOutlineFonts
 *              SUBENTER
 *              SUBEXIT
 *              LOGINFO
 *              DrawQueryBoxText
 *              EXIT_MAIN
 *
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *      Define image font and outline font.
 *      Set current font to be an image font.
 *      Position pointer and draw strings "CM_MODE1", "CM_MODE2", "CM_MODE3"
 *      Position pointer and draw strings "W H", "W H"
 *      Set current mode to be CM_MODE1.
 *      Draw lines of outline text in CM_MODE1.
 *      Draw lines of image text in CM_MODE1.
 *      Set current mode to be CM_MODE2.
 *      Draw lines of outline text in CM_MODE2.
 *      Draw lines of image text in CM_MODE2.
 *      Set current mode to be CM_MODE3.
 *      Draw lines of outline text in CM_MODE3.
 *      Check return code PMERR_FONT_AND_MODE_MISMATCH with image text.
 *      Delete all logical fonts.
 *      Set box size to arbitrary value.
 *      Query box size.
 *      If box sizes are not equal, output log error message.
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/


VOID   GpiSetAndQryCharBoxExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

        static PCHAR    EntryName="GpiSetAndQryCharBoxExh";     //      entry point name
        LONG            ErrorCount;          //      error count
        LONG            lcid;                //      logical font id
        POINTL          ptl;                 //      point structure
        SIZEF           Box1,                //      box struct to set
                        Box2;                //      box struct to query
        CHAR            out2[75];            //      output string
        BOOL            ReturnValue,         // return code value
                        Image;               //      T=Image F=Outline
        BOOL            fontfound=FALSE;
        BOOL            fontfound1=FALSE;
        CHAR            out[100];            //      output string
        POINTL          pt;                  //      point structure
//  ERRORID debugerr; BSC-never used
//  HAB hab;          BSC-never used

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);
          CreateDeviceImageFont(hPS,hWndClient,2L,NULL,0,120);

//      Define image font and outline font.

         // define an image font
                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                      if DeviceIsPrinter() {
                          sprintf(out,"No Device Image Font Found");
                          pt.x = (LONG)(0.5 * delta_x);
                          pt.y = 8*delta_y;
                          MapPt(pt);

                          if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                              SHOWERROR("GpiCharString", EntryName);

                      }
                      if ((fontfound=CreateSysImageFont(hPS,hWndClient,
                                          DESIRED_FONT_ID,NULL,0,120))==FALSE)
                       {
                         sprintf(out,"No System Image Font Found");

                         pt.x = (LONG)(0.5 * delta_x);
                         pt.y = 7.5*delta_y;
                         MapPt(pt);

                         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                             SHOWERROR("GpiCharString", EntryName);
                       } // end if
                    } // end if

   // Try to create an outline font
   // If this fails then bypass tests that require outline fonts

    lcid=5;                       //outline font
    if ((fontfound1=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                     FATTR_SEL_OUTLINE | FATTR_SEL_BOLD))==FALSE)
       {
         sprintf(out,"No OutLine Font Found");
         pt.x = (LONG)(0.5 * delta_x);
         pt.y = 7.0*delta_y;
         MapPt(pt);

         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if


             // Use default font for row and column headings

// Set current character position
                ptl.x = (LONG)(delta_x * 0.2);
                ptl.y = (LONG)(delta_y * 5.4);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

// Draw row headings CM_MODE1, CM_MODE2, CM_MODE3
                if(GpiCharString(hPS, 8L, "CM_MODE1")==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                ptl.x = (LONG)(delta_x * 0.2);
                ptl.y = (LONG)(delta_y * 3.4);
                MapPt(ptl);

                if(GpiMove(hPS, &ptl)==FALSE)
                        SHOWERROR("GpiMove", EntryName);

                if(GpiCharString(hPS, 8L, "CM_MODE2")==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                ptl.x = (LONG)(delta_x * 0.2);
                ptl.y = (LONG)(delta_y * 1.4);
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, 8L, "CM_MODE3")==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);


// Draw column headings for width and height signs
                ptl.x = (LONG)(1.6 * delta_x);
                ptl.y = (LONG)(6.4  * delta_y);
                MapPt(ptl);
                sprintf(out2, "W H");

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out2), out2)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.x = (LONG)(1.6 * delta_x);
                ptl.y = (LONG)(6.6  * delta_y);
                MapPt(ptl);
                sprintf(out2, "Outline");

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out2), out2)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.x = (LONG)(4.6 * delta_x);
                ptl.y = (LONG)(6.4 * delta_y);
                MapPt(ptl);
                sprintf(out2, "W H");

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out2), out2)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                ptl.x = (LONG)(4.6 * delta_x);
                ptl.y = (LONG)(6.6 * delta_y);
                MapPt(ptl);
                sprintf(out2, "Image");

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out2), out2)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

   if (fontfound1) { // have an outline font

// Calculate character position
                ptl.x = (LONG)(2 * delta_x);
                ptl.y   = (LONG)(6.2 * delta_y);

// Set boolean flag for outline text and set character mode
                Image=FALSE;
                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Call DoQueryBoxText to draw 7 lines of text
                if(DoQueryBoxText(ptl, Image) ==FALSE)
                        SHOWERROR("DoQueryBoxText", EntryName);

   } // end if for outline font

   if (fontfound) { // have device font

// Calculate character position

                ptl.x = (LONG)(5 * delta_x);
                ptl.y   = (LONG)(6.2 * delta_y);

// Set boolean flag for image text
                Image=TRUE;

// Call DoQueryBoxText to draw 7 lines of text
                if(DoQueryBoxText(ptl, Image) ==FALSE)
                        SHOWERROR("DoQueryBoxText", EntryName);


// Calculate character position
                ptl.x = (LONG)(2 * delta_x);
                ptl.y   = (LONG)(4.2 * delta_y);

   } // end if for device font

   if (fontfound1) {  // have an outline font

// Set boolean flag for outline text and set character mode
                Image=FALSE;
                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Call DoQueryBoxText to draw 7 lines of text
                if(DoQueryBoxText(ptl, Image) ==FALSE)
                        SHOWERROR("DoQueryBoxText", EntryName);


// Calculate character position
                ptl.x = (LONG)(5 * delta_x);
                ptl.y   = (LONG)(4.2 * delta_y);

   } // end if for outline font

   if (fontfound) { // have an image font

// Set boolean flag for image text
                Image=TRUE;

// Call DoQueryBoxText to draw 7 lines of text
                if(DoQueryBoxText(ptl, Image) ==FALSE)
                        SHOWERROR("DoQueryBoxText", EntryName);


   } // end if for image font

   if (fontfound1) {  // have an outline font

// Calculate character position
                ptl.x = (LONG)(2 * delta_x);
                ptl.y   = (LONG)(2.2 * delta_y);

// Set boolean flag for outline text and set character mode
                Image=FALSE;
                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Call DoQueryBoxText to draw 7 lines of text
                if(DoQueryBoxText(ptl, Image) ==FALSE)
                        SHOWERROR("DoQueryBoxText", EntryName);

   } // end if for outline font

   if (fontfound) {   // have an image font

        /**************************************************************
        * The following Code will check for PMERR_FONT_AND_MODE_MISMATCH
        **************************************************************/

                SUBENTER(PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                ptl.x = (LONG)(5 * delta_x);
                ptl.y   = (LONG)(2.2 * delta_y);

                Image=TRUE;
                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ReturnValue = DoQueryBoxText(ptl, Image);

                CHECKRC(ReturnValue, PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                SUBEXIT();

   } // end if for image font

                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

// The following code will check GpiQueryCharBox with 4 arbitrary values
                Box1.cx = (FIXED)(65536.0 * 123);
                Box1.cy = (FIXED)(65536.0 * 456);
                if(GpiSetCharBox(hPS, &Box1)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryCharBox(hPS, &Box2)==FALSE)
                        SHOWERROR("GpiQueryCharBox", EntryName);

                if((Box1.cx != Box2.cx) || (Box1.cy != Box2.cy)) {
                        sprintf(out2,   "Failure of GpiQueryCharBox().  Box set and"
                                                                " box queried were not equal.");
                        LOGINFO((INT)4, "@", out2);
                }

                Box1.cx = (FIXED)(65536.0 * 1230);
                Box1.cy = (FIXED)(65536.0 * 4560);
                if(GpiSetCharBox(hPS, &Box1)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryCharBox(hPS, &Box2)==FALSE)
                        SHOWERROR("GpiQueryCharBox", EntryName);

                if((Box1.cx != Box2.cx) || (Box1.cy != Box2.cy)) {
                        sprintf(out2,   "Failure of GpiQueryCharBox().  Box set and"
                                                                " box queried were not equal.");
                        LOGINFO((INT)4, "@", out2);
                }

                Box1.cx = (FIXED)(65536.0 * 12300);
                Box1.cy = (FIXED)(65536.0 * 45600);
                if(GpiSetCharBox(hPS, &Box1)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryCharBox(hPS, &Box2)==FALSE)
                        SHOWERROR("GpiQueryCharBox", EntryName);

                if((Box1.cx != Box2.cx) || (Box1.cy != Box2.cy)) {
                        sprintf(out2,   "Failure of GpiQueryCharBox().  Box set and"
                                                                " box queried were not equal.");
                        LOGINFO((INT)4, "@", out2);
                }

                Box1.cx = (FIXED)(65536.0 * 0.123);
                Box1.cy = (FIXED)(65536.0 * 0.456);
                if(GpiSetCharBox(hPS, &Box1)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiQueryCharBox(hPS, &Box2)==FALSE)
                        SHOWERROR("GpiQueryCharBox", EntryName);

                if((Box1.cx != Box2.cx) || (Box1.cy != Box2.cy)) {
                        sprintf(out2,   "Failure of GpiQueryCharBox().  Box set and"
                                                                " box queried were not equal.");
                        LOGINFO((INT)4, "@", out2);
                }

                EXIT_MAIN(EntryName);
        }
}


/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryCharDirExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryCharDirection()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               09/23/93
 *               - Change way fonts are selected
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              CreateSysImageFonts
 *              CreateImageFonts
 *              CreateSysOutlineFonts
 *              FindLogicalFonts
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Define image and outline font.
 *      Set current character mode to CM_MODE2.
 *      Set current character direction to left to right.
 *      Query current character direction.
 *      If set direction <> queried direction, output log error message.
 *      Set current font to be an image font.
 *      Draw string "Testing Left->Right...Testing Left->Right..."
 *      Set current font to be an outline font.
 *      Draw "Testing Left->Right...Testing Left->Right...Testing Left->Right..."
 *      Set current character direction to top to bottom.
 *      Query current character direction.
 *      If set direction <> queried direction, output log error message.
 *      Set current font to be an image font.
 *      Draw string "Testing Top->Bottom...Testing Top->Bottom..."
 *      Set current font to be an outline font.
 *      Draw string "Testing Top->Bottom...Testing Top->Bottom..."
 *      Set current character direction to right to left.
 *      Query current character direction.
 *      If set direction <> queried direction, output log error message.
 *      Set current font to be an image font.
 *      Draw string "Testing Right->Left...Testing Right->Left..."
 *      Set current font to be an outline font.
 *      Draw "Testing Right->Left...Testing Right->Left...Testing Right->Left..."
 *      Set current character direction to bottom to top.
 *      Query current character direction.
 *      If set direction <> queried direction, output log error message.
 *      Set current font to be an image font.
 *      Draw string "Testing Bottom->Top...Testing Bottom->Top..."
 *      Set current font to be an outline font.
 *      Draw string "Testing Bottom->Top...Testing Bottom->Top..."
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/
VOID   GpiSetAndQryCharDirExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiSetAndQryCharDirExh";     //      entry point name
        POINTL          ptl;                 //      point structure
        LONG            ErrorCount;          //      error count
        LONG            lcid;                //      logical font id
        SIZEF           Box;                 //      box structure
        BOOL            fontfound=FALSE;
        BOOL            fontfound1=FALSE;
        CHAR            out[100];            //      output string
        CHAR            oute[100];           //      output error string
        POINTL          pt;                  //      point structure
        LONG            debugerr;
        LONG            debugerr1;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

// Define image and outline fonts
         // define an image font
                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                      if DeviceIsPrinter() {
                          sprintf(out,"No Device Image Font Found");
                          pt.x = (LONG)(0.5 * delta_x);
                          pt.y = 8*delta_y;
                          MapPt(pt);

                          if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                              SHOWERROR("GpiCharString", EntryName);

                      }
                      if ((fontfound=CreateSysImageFont(hPS,hWndClient,
                                          DESIRED_FONT_ID,NULL,0,120))==FALSE)
                       {
                         sprintf(out,"No System Image Font Found");

                         pt.x = (LONG)(0.5 * delta_x);
                         pt.y = 7.5*delta_y;
                         MapPt(pt);

                         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                             SHOWERROR("GpiCharString", EntryName);
                       } // end if
                    } // end if

   // Try to create an outline font
   // If this fails then bypass tests that require outline fonts

    lcid=5;                       //outline font
    if ((fontfound1=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                     FATTR_SEL_OUTLINE|FATTR_SEL_BOLD))==FALSE)
       {
         sprintf(out,"No OutLine Font Found");
         pt.x = (LONG)(0.5 * delta_x);
         pt.y = 7.0*delta_y;
         MapPt(pt);

         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if


                Box.cx = (MapX(delta_x) / 7) * 65536;
                  //TSS...was Box.cy = Box.cx
                Box.cy = (MapY(delta_y) / 7) * 65536;

                if(GpiSetCharBox(hPS, &Box)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);
// Build output string
                strcpy(out,"Testing Left->Right...Testing Left->Right...");

// Set character direction

                debugerr1=CHDIRN_LEFTRIGHT;
                if(GpiSetCharDirection(hPS, CHDIRN_LEFTRIGHT)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Immediately query character direction
                if((debugerr=GpiQueryCharDirection(hPS)) != CHDIRN_LEFTRIGHT) {
                        sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                         " set =%d: direction queried =%d ",debugerr1,debugerr);
                        LOGINFO((INT)4, "@", oute);
                }

// Set current font to image

            if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                ptl.x = (LONG)(1.25 * delta_x);
                ptl.y = 6 * delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                     } //end if
                ptl.x = (LONG)(1.5 * delta_x);
                ptl.y = (LONG)(5.75 * delta_y);
                MapPt(ptl);

                strcpy(out,"Testing Left->Right...Testing Left->Right..."
                                          "Testing Left->Right...");

// Set current font to outline

            if (fontfound1) {
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);


                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

            }             //end if
                strcpy(out,"Testing Top->Bottom...");

// Set character direction
                debugerr1=CHDIRN_TOPBOTTOM;
                if(GpiSetCharDirection(hPS, CHDIRN_TOPBOTTOM)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Immediately query direction
                if((debugerr=GpiQueryCharDirection(hPS)) != CHDIRN_TOPBOTTOM) {
                        sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                         " set =%d: direction queried =%d ",debugerr1,debugerr);
                     //   sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                     //                                           " set and direction queried were not equal.");
                        LOGINFO((INT)4, "@", oute);
                }

// Set current font to image

            if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                ptl.x = (LONG)(7.25 * delta_x);
                ptl.y = (LONG)(5.5 * delta_y);
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

            }           // end if
                ptl.x = (LONG)(7.0 * delta_x);
                ptl.y = (LONG)(5.25 * delta_y);
                MapPt(ptl);

// Set current font to outline

            if (fontfound1) {
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

            }             // end if
                strcpy(out,"Testing Right->Left...Testing Right->Left...");

// Set character direction
                debugerr1=CHDIRN_RIGHTLEFT;
                if(GpiSetCharDirection(hPS, CHDIRN_RIGHTLEFT)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Immediately query direction
                if((debugerr=GpiQueryCharDirection(hPS)) != CHDIRN_RIGHTLEFT) {
                        sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                         " set =%d: direction queried =%d ",debugerr1,debugerr);
                        LOGINFO((INT)4, "@", oute);
                }


             if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                ptl.x = (LONG)(6.75 * delta_x);
                ptl.y = (LONG)(1.0 * delta_y);
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

             }            //end if
                ptl.x = (LONG)(6.5 * delta_x);
                ptl.y = (LONG)(1.25 * delta_y);
                MapPt(ptl);

                strcpy(out,"Testing Right->Left...Testing Right->Left..."
                                          "Testing Right->Left...");

// Set current font to outline font

           if (fontfound1) {
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

           }             //end if
                strcpy(out,"Testing Bottom->Top...");

// Set character direction
                debugerr1=CHDIRN_BOTTOMTOP;
                if(GpiSetCharDirection(hPS, CHDIRN_BOTTOMTOP)==FALSE)
                        SHOWERROR("GpiSetCharDirection", EntryName);

// Immediately query direction
                if((debugerr=GpiQueryCharDirection(hPS)) != CHDIRN_BOTTOMTOP) {
                        sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                         " set =%d: direction queried =%d ",debugerr1,debugerr);
                     //   sprintf(oute,    "Failure of GpiQueryCharDirection().  Direction"
                     //                                           " set and direction queried were not equal.");
                        LOGINFO((INT)4, "@", oute);
                }

                ptl.x = (LONG)(0.75 * delta_x);
                ptl.y = (LONG)(1.5 * delta_y);
                MapPt(ptl);

// Set current font to image font

            if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

            }
                ptl.x = (LONG)(1.0 * delta_x);
                ptl.y = (LONG)(1.75 * delta_y);
                MapPt(ptl);

// Set current font to outline font

            if (fontfound1) {
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(out), out)==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

            }        // end if
// Set current font to default
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


 /***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryCharModeExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryCharMode()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - TestCase Design.
 *               - Changed way fonts are selected
 *
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              CreateSysImageFonts
 *              CreateImageFonts
 *              CreateSysOutlineFonts
 *
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Define image and outline font.
 *      Set current baseline angle to about 60 degrees.
 *      Set current font to be an outline font.
 *      Set current character mode to be CM_MODE3.
 *      Query current character mode.
 *      If set mode <> queried mode, output log error message.
 *      Draw string "Outline font -- Character Mode CM_MODE3".
 *      Set current font to be an image font.
 *      Check return code PMERR_FONT_AND_MODE_MISMATCH with system image font.
 *      Check return code PMERR_FONT_AND_MODE_MISMATCH with device image font.
 *      Set current font to be an outline font.
 *      Set current character mode to be CM_MODE2.
 *      Query current character mode.
 *      If set mode <> queried mode, output log error message.
 *      Draw string "Outline font -- Character Mode CM_MODE2".
 *      Set current font to be a system image font.
 *      Draw string "System image font -- Character Mode CM_MODE2".
 *      Set current font to be a device image font.
 *      Draw string "Device image font -- Character Mode CM_MODE2".
 *      Set current font to be an outline font.
 *      Set current character mode to be CM_MODE1.
 *      Query current character mode.
 *      If set mode <> queried mode, output log error message.
 *      Draw string "Outline font -- Character Mode CM_MODE1".
 *      Set current font to be a system image font.
 *      Draw string "System image font -- Character Mode CM_MODE1".
 *      Set current font to be a device image font.
 *      Draw string "Device image font -- Character Mode CM_MODE1".
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/


VOID   GpiSetAndQryCharModeExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiSetAndQryCharModeExh";//  entry point name
        CHAR            output[80];        //      output string
        POINTL          ptl;               //      point structure
        GRADIENTL       Angle;             //      angle vector struct
        LONG            ErrorCount,        //      error count
                        ReturnValue,       //      return code value
                        lcid;              //      logical font id
        SIZEF           Box,               //      outline font box size
                        Box2;              //      image font box size
        BOOL                    fontfound=FALSE;
        BOOL                    fontfound1=FALSE;
        BOOL                    fontfound2=FALSE;

        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

// Define image and outline fonts

      // Try to create a device image font
      // If this fails create a system image font
      // If this fails, tests that need image fonts will be bypassed

                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                     sprintf(output,"No Device Image Font Found");
                     ptl.x = (LONG)(0.5 * delta_x);
                     ptl.y = 8*delta_y;
                     MapPt(ptl);

                     if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                       SHOWERROR("GpiCharString", EntryName);

                    } // end if

   // Try to create an outline font
   // If this fails then bypass tests that require outline fonts

    lcid=5;                       //outline font
    if ((fontfound1=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                      FATTR_SEL_OUTLINE|FATTR_SEL_BOLD))==FALSE)
       {
         sprintf(output,"No OutLine Font Found");
         ptl.x = (LONG)(0.5 * delta_x);
         ptl.y = 7.0*delta_y;
         MapPt(ptl);

         if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if

   // Try to create a system image font
   // If this fails then bypass tests that require a system font

    lcid=7;                       //system image font font
    if ((fontfound2=CreateSysImageFont(hPS,hWndClient,lcid,NULL,
                                       FATTR_SEL_BOLD,240))==FALSE)
       {
          sprintf(output,"No System Image Font Found");

          ptl.x = (LONG)(0.5 * delta_x);
          ptl.y = 7.5*delta_y;
          MapPt(ptl);

          if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                    SHOWERROR("GpiCharString", EntryName);
          }

// Set character angle to 60 degrees

                Angle.x = MapX(delta_x);
                Angle.y = MapY(delta_y * 2.0);
                if(GpiSetCharAngle(hPS, &Angle)==FALSE)
                                SHOWERROR("GpiSetCharAngle", EntryName);

// Set character box size for outline fonts
                Box.cx = (FIXED)((MapX(delta_x) / 6) * 65536.0);
                Box.cy = Box.cx;

// Set character box size for image fonts
                Box2.cx = (FIXED)((MapX(delta_x) / 4) * 65536.0);
                  //TSS...was Box2.cy = Box2.cx
                Box2.cy = (FIXED)((MapY(delta_y) / 4) * 65536.0);

                if(GpiSetCharBox(hPS, &Box)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

// Select outline font
                if (fontfound1) {
                   if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set character mode
                if(GpiSetCharMode(hPS,CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Immediately query character mode
                if(GpiQueryCharMode(hPS) != CM_MODE3) {
                        sprintf(output,"Failure of GpiQueryCharMode().  Mode set"
                                                                " and mode queried were not equal.");
                        LOGINFO((INT)4, "@", output);
                }

                sprintf(output,"Outline font -- Character Mode CM_MODE3");

                ptl.x = (LONG)(0.5 * delta_x);
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }   // end if
        /**************************************************************
        * The following Code will check for PMERR_FONT_AND_MODE_MISMATCH
        **************************************************************/

                        if (fontfound2) {

                SUBENTER(PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                        GpiSetCharSet(hPS, 7L);

                        if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                        sprintf(output, "System Image font -- Character Mode CM_MODE3");

                        ptl.x = (LONG)(0.1 * delta_x);
                        ptl.y = delta_y;
                        MapPt(ptl);

                        ReturnValue = GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output);

                        CHECKRC(ReturnValue, PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                SUBEXIT();

                        } // end if
        /**************************************************************
        * The following Code will check for PMERR_FONT_AND_MODE_MISMATCH
        **************************************************************/

                if (fontfound) { // have device image font to test

                SUBENTER(PMERR_FONT_AND_MODE_MISMATCH, "test 2");

                        if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                                SHOWERROR("GpiSetCharSet", EntryName);

                        if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                        sprintf(output, "Device Image font -- Character Mode CM_MODE3");

                        ptl.x = (LONG)(0.2 * delta_x);
                        ptl.y = delta_y;
                        MapPt(ptl);

                        ReturnValue = GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output);

                        CHECKRC(ReturnValue, PMERR_FONT_AND_MODE_MISMATCH, "test 2");

                SUBEXIT();

                        }
// Set current font to be outline

                if (fontfound1) {
                if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set character mode
                if(GpiSetCharMode(hPS,CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Immediately query character mode
                if(GpiQueryCharMode(hPS) != CM_MODE2) {
                        sprintf(output, "Failure of GpiQueryCharMode().  Mode set"
                                                                " and mode queried were not equal.");
                        LOGINFO((INT)4, "@", output);
                }

// Set box for outline fonts
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output,"Outline font -- Character Mode CM_MODE2");

                ptl.x = delta_x;
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }             // end if
// Set current font to be system image font

                if (fontfound2) {

                GpiSetCharSet(hPS, 7L);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output, "System Image font -- Character Mode CM_MODE2");

                ptl.x = (LONG)(1.5 * delta_x);
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }             // end if
// Set current font to be device image font

                if (fontfound) {  //have image font
                  if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output, "Device Image font -- Character Mode CM_MODE2");

                ptl.x = 2 * delta_x;
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }            // end if
// Set current font to be outline

                if (fontfound1) {
                   if(GpiSetCharSet(hPS, 5L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set character mode
                if(GpiSetCharMode(hPS,CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

// Immediately query character mode
                if(GpiQueryCharMode(hPS) != CM_MODE1) {
                        sprintf(output, "Failure of GpiQueryCharMode().  Mode set"
                                                                " and mode queried were not equal.");
                        LOGINFO((INT)4, "@", output);
                }

// Set box for outline fonts
                if(GpiSetCharBox(hPS, &Box)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output, "Outline font -- Character Mode CM_MODE1");

                ptl.x = (LONG)(2.5 * delta_x);
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }             //end if
// Set current font to system image font

                if (fontfound2) {
                   if(GpiSetCharSet(hPS, 7L)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output, "System Image font -- Character Mode CM_MODE1");

                ptl.x = 3 * delta_x;
                ptl.y = delta_y;
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }             //end if
// Set current font to device font

                if (fontfound) { // have an image font
                    if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &Box2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                sprintf(output, "Device Image font -- Character Mode CM_MODE1");

                ptl.x = (LONG)(3.5 * delta_x);
                ptl.y = (LONG)(1.5 * delta_y);
                MapPt(ptl);

                if(GpiCharStringAt(hPS, &ptl, (LONG)strlen(output), output)==GPI_ERROR)
                        SHOWERROR("GpiCharString", EntryName);

                }
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

                EXIT_MAIN(EntryName);
        }
}


 /***************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryCharShearExh
 *
 * Purpose:  This is an entry point for the PTT that causes exhaustive
 *           testing of GpiQueryCharShear()
 *
 * System Requirements: Section ???
 *
 * Revision Log: 01/08/91, PDVT, Stanley Logan
 *               - created initial template
 *               - changed font selection
 *
 * Inputs:
 *
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SelectionCall  // selection parameter
 *
 * Outputs:
 *    NONE
 *
 * Subroutines Required:
 *              ENTER_MAIN
 *              SHOWERROR
 *              TEST_SIGNATURE
 *              DeviceIsPrinter
 *              DrawShearText
 *              LOGINFO
 *              EXIT_MAIN
 *
 * Limitations:
 *              NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      Define image and outline font.
 *      Query default character box size.
 *      Set current font to be image font.
 *      Position and draw strings "CM_MODE1", "CM_MODE2", "CM_MODE3".
 *      Set current mode to be CM_MODE1.
 *      Draw lines of outline text in CM_MODE1.
 *      Draw lines of image text in CM_MODE1.
 *      Set current mode to be CM_MODE2.
 *      Draw lines of outline text in CM_MODE2.
 *      Draw lines of image text in CM_MODE2.
 *      Set current mode to be CM_MODE3.
 *      Draw lines of outline text in CM_MODE3.
 *      Check return code PMERR_FONT_AND_MODE_MISMATCH with image text.
 *      Set shear value to arbitrary value.
 *      Query shear value.
 *      If shear values are not equal, output log error message.
 *      Set shear value to arbitrary value.
 *      Query shear value.
 *      If shear values are not equal, output log error message.
 *      Set shear value to arbitrary value.
 *      Query shear value.
 *      If shear values are not equal, output log error message.
 *      Set shear value to arbitrary value.
 *      Query shear value.
 *      If shear values are not equal, output log error message.
 *      Delete all logical fonts.
 *
 *\\end
 ***************************************************************************/

VOID   GpiSetAndQryCharShearExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
        static PCHAR    EntryName="GpiSetAndQryCharShearExh";   //      entry point name
        SIZEF           ptl,            //      box structure
                        ptl2,           //      def. box struct.
                        ptlbox;         //      box structure
        SIZEL           DefaultBox;     // def. box struct.
        LONG            ErrorCount,     //      error count
                        lcid;           //      logical font id
        CHAR            out[200];       //      output string
        BOOL            Image,          //      T=Image F=Outline
                        ReturnValue;    //      return code value
        POINTL          temppt,         //      point structure
                        Shear;          //      point structure
        BOOL            fontfound=FALSE;
        BOOL            fontfound1=FALSE;
        POINTL          pt;               //      point structure


        if (SelectionCall) {
                WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULLHANDLE, NULLHANDLE);
                *pBasisX = 10000;
                *pBasisY = 10000;
        }
        else {
                ENTER_MAIN(EntryName);

// Define image and outline fonts

                  if ((fontfound=CreateDeviceImageFont(hPS,hWndClient,
                                      DESIRED_FONT_ID,NULL,0,120))==FALSE)
                   {
                      if DeviceIsPrinter() {
                          sprintf(out,"No Device Image Font Found");
                          pt.x = (LONG)(0.5 * delta_x);
                          pt.y = 8*delta_y;
                          MapPt(pt);

                          if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                              SHOWERROR("GpiCharString", EntryName);

                      }
                      if ((fontfound=CreateSysImageFont(hPS,hWndClient,
                                          DESIRED_FONT_ID,NULL,0,120))==FALSE)
                       {
                         sprintf(out,"No System Image Font Found");

                         pt.x = (LONG)(0.5 * delta_x);
                         pt.y = 7.5*delta_y;
                         MapPt(pt);

                         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
                             SHOWERROR("GpiCharString", EntryName);
                       } // end if
                    } // end if

   // Try to create an outline font
   // If this fails then bypass tests that require outline fonts

    lcid=5;                       //outline font
    if ((fontfound1=CreateSysOutlineFont(hPS,hWndClient,lcid,NULL,
                         FATTR_SEL_OUTLINE|FATTR_SEL_BOLD))==FALSE)
       {
         sprintf(out,"No OutLine Font Found");
         pt.x = (LONG)(0.5 * delta_x);
         pt.y = 7.0*delta_y;
         MapPt(pt);

         if(GpiCharStringAt(hPS, &pt, (LONG)strlen(out), out)==GPI_ERROR)
            SHOWERROR("GpiCharString", EntryName);
         } // end if


   //
   // Use Default font to write row headers
   //


// Query to get default box dimensions
                if(GpiQueryDefCharBox(hPS, &DefaultBox)==FALSE)
                        SHOWERROR("GpiQueryDefCharBox", EntryName);

// Set box dimensions for image fonts
                ptl2.cx = (FIXED)(DefaultBox.cx * 1.5 * 65536.0);
                ptl2.cy = (FIXED)(DefaultBox.cy * 1.5 * 65536.0);

// Set box dimensions for outline fonts
                ptlbox.cx = (FIXED)(MapX(delta_x / 5.0) * 65536.0);
                ptlbox.cy = (FIXED)(MapY(delta_y / 5.0) * 65536.0);

                temppt.x=20;
                temppt.y=560;
                MapPt(temppt);

// Set current font to image font

                if(GpiCharStringAt(hPS, &temppt, 8L, "CM_MODE1")==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                temppt.x=20;
                temppt.y=360;
                MapPt(temppt);

                if(GpiCharStringAt(hPS, &temppt, 8L, "CM_MODE2")==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

                temppt.x=20;
                temppt.y=160;
                MapPt(temppt);

                if(GpiCharStringAt(hPS, &temppt, 8L, "CM_MODE3")==GPI_ERROR)
                        SHOWERROR("GpiCharStringAt", EntryName);

// Set current font to image font

                if (fontfound) {
                if(GpiSetCharSet(hPS, DESIRED_FONT_ID)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

                }            // end if

                if(GpiSetCharMode(hPS, CM_MODE1)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);


                ptl.cx=(FIXED)(2.0*65536.0);
                ptl.cy=(FIXED)(6.0*65536.0);

// Set box for outline fonts
                if(GpiSetCharBox(hPS, &ptlbox)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set flag for outline and call DoShearText to draw 5 lines of sheared text

                if (fontfound1) {
                Image=FALSE;
                if(DoShearText(ptl, Image)==FALSE)
                        SHOWERROR("DoShearText", EntryName);

                }
                ptl.cx=(FIXED)(5.0*65536.0);
                ptl.cy=(FIXED)(6.0*65536.0);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &ptl2)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set flag for image and call DoShearText to draw 5 lines of sheared text

                if (fontfound) {
                Image=TRUE;
                if(DoShearText(ptl, Image)==FALSE)
                        SHOWERROR("DoShearText", EntryName);

                }            // end if

                if(GpiSetCharMode(hPS, CM_MODE2)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);


                ptl.cx=(FIXED)(2.0*65536.0);
                ptl.cy=(FIXED)(4.0*65536.0);

// Set box for outline fonts
                if(GpiSetCharBox(hPS, &ptlbox)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set flag for outline and call DoShearText to draw 5 lines of sheared text

                if (fontfound1) {
                Image=FALSE;
                if(DoShearText(ptl, Image)==FALSE)
                        SHOWERROR("DoShearText", EntryName);

                }             // end if

                ptl.cx=(FIXED)(5.0*65536.0);
                ptl.cy=(FIXED)(4.0*65536.0);

// Set box for image fonts
                if(GpiSetCharBox(hPS, &ptl2)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set flag for image and call DoShearText to draw 5 lines of sheared text

                if (fontfound) {
                Image=TRUE;
                if(DoShearText(ptl, Image)==FALSE)
                        SHOWERROR("DoShearText", EntryName);

                }            // end if

                if(GpiSetCharMode(hPS, CM_MODE3)==FALSE)
                        SHOWERROR("GpiSetCharMode", EntryName);

                ptl.cx=(FIXED)(2.0*65536.0);
                ptl.cy=(FIXED)(2.0*65536.0);

// Set box for outline fonts
                if(GpiSetCharBox(hPS, &ptlbox)==FALSE)
                        SHOWERROR("GpiSetCharBox", EntryName);

// Set flag for outline and call DoShearText to draw 5 lines of sheared text

                if (fontfound1) {
                Image=FALSE;
                if(DoShearText(ptl, Image)==FALSE)
                        SHOWERROR("DoShearText", EntryName);

                }             // end if

        /**************************************************************
        * The following Code will check for PMERR_FONT_AND_MODE_MISMATCH
        **************************************************************/

                if (fontfound) {
                SUBENTER(PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                        ptl.cx = (FIXED)(5 * 65536.0);
                        ptl.cy = (FIXED)(2 * 65536.0);

                        if(GpiSetCharBox(hPS, &ptl2)==FALSE)
                                SHOWERROR("GpiSetCharBox", EntryName);

                        Image=TRUE;

                        ReturnValue = DoShearText(ptl, Image);

                        CHECKRC(ReturnValue, PMERR_FONT_AND_MODE_MISMATCH, "test 1");

                SUBEXIT();

                }
                if(GpiSetCharSet(hPS, LCID_DEFAULT)==FALSE)
                        SHOWERROR("GpiSetCharSet", EntryName);

// Delete all logical fonts
                if(GpiDeleteSetId(hPS, LCID_ALL)==FALSE)
                        SHOWERROR("GpiDeleteSetId", EntryName);

// The following code checks GpiQueryCharShear using arbitrary values
                temppt.x = (LONG)MapX(delta_x);
                temppt.y = (LONG)MapY(delta_y * 2);
                if(GpiSetCharShear(hPS, &temppt)==FALSE)
                        SHOWERROR("GpiSetCharShear", EntryName);

                if(GpiQueryCharShear(hPS, &Shear)==FALSE)
                        SHOWERROR("GpiQueryCharShear", EntryName);

                if((temppt.x != Shear.x) || (temppt.y != Shear.y)) {
                        sprintf(out,"Failure of GpiQueryCharShear().  Shear vector"
                                " set x=%d, set y=%d and shear vector queried x=%d, queried y=%d.",
                                 temppt.x,temppt.y,Shear.x,Shear.y);
                        LOGINFO((INT)4, "@", out);
                }

                temppt.x = (LONG)MapX(delta_x * 2);
                temppt.y = (LONG)MapY(delta_y * 3);
                if(GpiSetCharShear(hPS, &temppt)==FALSE)
                        SHOWERROR("GpiSetCharShear", EntryName);

                if(GpiQueryCharShear(hPS, &Shear)==FALSE)
                        SHOWERROR("GpiQueryCharShear", EntryName);

                if((temppt.x != Shear.x) || (temppt.y != Shear.y)) {
                        sprintf(out,"Failure of GpiQueryCharShear().  Shear vector"
                                " set x=%d, set y=%d and shear vector queried x=%d, queried y=%d.",
                                 temppt.x,temppt.y,Shear.x,Shear.y);
                    //    sprintf(out,    "Failure of GpiQueryCharShear().  Shear vector"
                    //                                            " set and shear vector queried were not equal.");
                        LOGINFO((INT)4, "@", out);
                }

                temppt.x = (LONG)MapX(delta_x * -1);
                temppt.y = (LONG)MapY(delta_y * 0.23);
                if(GpiSetCharShear(hPS, &temppt)==FALSE)
                        SHOWERROR("GpiSetCharShear", EntryName);

                if(GpiQueryCharShear(hPS, &Shear)==FALSE)
                        SHOWERROR("GpiQueryCharShear", EntryName);

                if((temppt.x != Shear.x) || (temppt.y != Shear.y)) {
                        sprintf(out,"Failure of GpiQueryCharShear().  Shear vector"
                                " set x=%d, set y=%d and shear vector queried x=%d, queried y=%d.",
                                 temppt.x,temppt.y,Shear.x,Shear.y);
                      //  sprintf(out,    "Failure of GpiQueryCharShear().  Shear vector"
                      //                                          " set and shear vector queried were not equal.");
                        LOGINFO((INT)4, "@", out);
                }

                temppt.x = (LONG)MapX(delta_x * 0.11);
                temppt.y = (LONG)MapY(delta_y * -2);
                if(GpiSetCharShear(hPS, &temppt)==FALSE)
                        SHOWERROR("GpiSetCharShear", EntryName);

                if(GpiQueryCharShear(hPS, &Shear)==FALSE)
                        SHOWERROR("GpiQueryCharShear", EntryName);

                if((temppt.x != Shear.x) || (temppt.y != Shear.y)) {
                        sprintf(out,"Failure of GpiQueryCharShear().  Shear vector"
                                " set x=%d, set y=%d and shear vector queried x=%d, queried y=%d.",
                                 temppt.x,temppt.y,Shear.x,Shear.y);
                       // sprintf(out,    "Failure of GpiQueryCharShear().  Shear vector"
                       //                                         " set and shear vector queried were not equal.");
                        LOGINFO((INT)4, "@", out);
                }

           EXIT_MAIN(EntryName);
        }
}
/************************************************************************
 ************************************************************************
 ************************************************************************
 *
 * Create a system image font
 *
 *
 ************************************************************************
 ************************************************************************
 ************************************************************************/
BOOL CreateSysImageFont(HPS hPS,HWND hWndClient,LONG lcid_font,PSZ facename,
                        SHORT fm_sel,SHORT ptsz)
{
  LONG         lNumberRequested = 0 ;
  LONG         lNumberReturned ;
  LONG         lReturned ;
  PVOID        afm=NULL;
  FONTMETRICS  *pfm;
  BOOL         fontfound=FALSE;
  LONG         i;
  FATTRS       fat;
//  POINTL       textptl;  BSC-never used
//  USHORT       usCodepage  ; BSC-never used
  LONG         ErrorCount;                                                     //      error count

// To query fonts, you first request no fonts so that the system will
// tell you how many are available.  Once you know that, you allocate
// memory for the font metrics returned.

     lNumberReturned = GpiQueryFonts (hPS, QF_PUBLIC, facename,
         (PLONG)&lNumberRequested,(LONG)(sizeof(FONTMETRICS)),NULL);

     if (lNumberReturned <= 0) {
         SHOWERROR("GpiQueryFonts", "CreateSysImageFont");
         return FALSE;
     } // end if

// allocate memory for font metrics

     if ((DosAllocMem(&afm,lNumberReturned*sizeof(FONTMETRICS),
         PAG_COMMIT | PAG_WRITE | PAG_READ ))==NO_ERROR)
        pfm=(PFONTMETRICS)afm;
        else
        {
         SHOWERROR("DosAllocMem", "CreateSysImageFont");
         return FALSE;
        }

 // Call GpiQueryFonts again to request "Number" fonts and their
 // metrics to be returned in the space pointed to by "pfm"

     if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,facename,
                                 (PLONG)&lNumberReturned,
                                 (LONG)sizeof(FONTMETRICS),
                                 pfm)) == GPI_ALTERROR){
         SHOWERROR("GpiQueryFonts", "CreateSysImageFont");
         DosFreeMem(afm);
          return FALSE;
     }
     else {

 // Select a font
 //
         for (i=0;(i<lNumberReturned) && (fontfound == FALSE) ; i++) {
             if (!(pfm[i].fsDefn & FM_DEFN_OUTLINE) &&
              (pfm[i].sNominalPointSize = ptsz) && (pfm[i].lMatch>0)) {
              fontfound=TRUE;
              fat.usRecordLength = sizeof(fat) ;
              fat.fsSelection = fm_sel;
              fat.lMatch = pfm[i].lMatch;
              strcpy (fat.szFacename, pfm[i].szFacename) ;
              fat.idRegistry = 0 ;
              fat.usCodePage  = 0;
              fat.lMaxBaselineExt = 0 ;
              fat.lAveCharWidth = 0;
              fat.fsType = 0;
              fat.fsFontUse = 0 ;
   // Create logical font, if default font returned then no image font
   // available. (No image fonts will be available for Postscript driver)
      if(FONT_MATCH==GpiCreateLogFont (hPS, NULL, lcid_font, &fat));
              else
              {
               DosFreeMem(afm);
               return FALSE;
              }
              }
          } // end for
          } // end else
 DosFreeMem(afm);
 return fontfound;

}
/************************************************************************
 ************************************************************************
 ************************************************************************
 *
 * Create a device image font
 *
 *
 ************************************************************************
 ************************************************************************
 ************************************************************************/
BOOL CreateDeviceImageFont(HPS hPS,HWND hWndClient,LONG lcid_font,PSZ facename,
                     SHORT fm_sel,SHORT ptsz)
{
  LONG         lNumberRequested = 0 ;
  LONG         lNumberReturned ;
  LONG         lReturned ;
  PVOID        afm=NULL;
  FONTMETRICS  *pfm;
  BOOL         fontfound=FALSE;
  LONG         i;
  FATTRS       fat;
//  POINTL       textptl;  BSC-Never used
//  USHORT       usCodepage  ; BSC-Never used
  LONG         ErrorCount;    //      error count

// To query fonts, you first request no fonts so that the system will
// tell you how many are available.  Once you know that, you allocate
// memory for the font metrics returned.
     lNumberReturned = GpiQueryFonts (hPS, QF_PUBLIC, facename,
         &lNumberRequested,(LONG)(sizeof(FONTMETRICS)),NULL);

     if (lNumberReturned <= 0) {
         SHOWERROR("GpiQueryFonts", "CreateImageFont");
         return FALSE;
     } // end if

// allocate memory for font metrics

     if ((DosAllocMem(&afm,(LONG)lNumberReturned*sizeof(FONTMETRICS),
         PAG_COMMIT | PAG_WRITE | PAG_READ ))==NO_ERROR)
        pfm=(PFONTMETRICS)afm;
        else
        {
         SHOWERROR("DosAllocMem", "CreateImageFont");
         return FALSE;
        }

 // Call GpiQueryFonts again to request "Number" fonts and their
 // metrics to be returned in the space pointed to by "pfm"

     if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,facename,
                                 &lNumberReturned,
                                 (LONG)sizeof(FONTMETRICS),
                                 pfm)) == GPI_ALTERROR){
         SHOWERROR("GpiQueryFonts", "CreateImageFont");
         DosFreeMem(afm);
          return FALSE;
     }
     else {

 // Select a font
 //

         for (i=0;(i<lNumberReturned) && (fontfound == FALSE) ; i++) {
             if (!(pfm[i].fsDefn & FM_DEFN_OUTLINE) &&
              (pfm[i].sNominalPointSize = ptsz) && (pfm[i].lMatch>0)) {
              fontfound=TRUE;
              fat.usRecordLength = sizeof(fat) ;
              fat.fsSelection = fm_sel;
              fat.lMatch = pfm[i].lMatch;
              strcpy (fat.szFacename, pfm[i].szFacename);
              fat.idRegistry = 0 ;
              fat.usCodePage  = 0;
              fat.lMaxBaselineExt = 0 ;
              fat.lAveCharWidth = 0;
              fat.fsType = 0;
              fat.fsFontUse = 0 ;
   // Create logical font, if default font returned then no image font
   // available. (No image fonts will be available for Postscript driver)

              if(FONT_MATCH==GpiCreateLogFont (hPS, NULL, lcid_font, &fat));
              else
              {
               DosFreeMem(afm);
               return FALSE;
              }
              }
          } // end for
          } // end else
 DosFreeMem(afm);
 return fontfound;

}
/************************************************************************
 ************************************************************************
 ************************************************************************
 *
 * Create an system outline font
 *
 *
 ************************************************************************
 ************************************************************************
 ************************************************************************/
BOOL CreateSysOutlineFont(HPS hPS,HWND hWndClient,LONG lcid_font,PSZ facename,USHORT fm_sel)
{
  LONG         lNumberRequested = 0 ;
  LONG         lNumberReturned ;
  LONG         lReturned ;
  PVOID        afm=NULL;
  FONTMETRICS  *pfm;
  BOOL         fontfound=FALSE;
  LONG         i;
  FATTRS       fat;
//  POINTL  textptl;  BSC-never used
  USHORT  usCodepage;
  LONG         ErrorCount;    //      error count
  FONTMETRICS fmMetrics;
  LONG        rc;

// To query fonts, you first request no fonts so that the system will
// tell you how many are available.  Once you know that, you allocate
// memory for the font metrics returned.

     lNumberReturned = GpiQueryFonts (hPS, QF_PUBLIC, facename,
         &lNumberRequested,(LONG)(sizeof(FONTMETRICS)),NULL);

     if (lNumberReturned <= 0) {
         SHOWERROR("GpiQueryFonts", "CreateSysOutlineFont");
         return FALSE;
     } // end if

// allocate memory for font metrics

     if ((DosAllocMem(&afm,(LONG)lNumberReturned*sizeof(FONTMETRICS),
         PAG_COMMIT | PAG_WRITE | PAG_READ ))==NO_ERROR)
        pfm=(PFONTMETRICS)afm;
        else
        {
         SHOWERROR("DosAllocMem", "CreateSysOutlineFont");
         return FALSE;
        }

 // Call GpiQueryFonts again to request "Number" fonts and their
 // metrics to be returned in the space pointed to by "pfm"

     if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,facename,
                                 &lNumberReturned,
                                 (LONG)sizeof(FONTMETRICS),
                                 pfm)) == GPI_ALTERROR){
         SHOWERROR("GpiQueryFonts", "CreateImageFont");
         DosFreeMem(afm);
          return FALSE;
     }
     else {

 // Select a generic outline font to use
 //
         for (i=0;(i<lNumberReturned) && (fontfound == FALSE) ; i++) {
           rc=strcmp(pfm[i].szFacename, OUTLINE_FONT);
           if ((pfm[i].fsDefn & FM_DEFN_OUTLINE) && (pfm[i].lMatch>0)  &&  (rc == 0))
                {
                   usCodepage= GpiQueryCp(hPS); // Necessary for 2.0 GA
                   fat.usCodePage  = usCodepage; // Necessary for 2.0 GA
                   fontfound=TRUE;
                   fat.usRecordLength = sizeof(fat) ;
                   fat.fsSelection = 0;
                   fat.fsSelection = FATTR_SEL_OUTLINE;
                   fat.fsSelection = fm_sel;
                   fat.lMatch = pfm[i].lMatch;
                   fat.lMatch = 0;
                   strcpy (fat.szFacename, pfm[i].szFacename) ;
                   fat.idRegistry = 0 ;
                   fat.usCodePage  = 0; // MAY need to set font 2.0 GA
                   fat.lMaxBaselineExt = 0 ;
                   fat.lAveCharWidth = 0;
                   fat.fsType = 0;
                   fat.fsFontUse = 0 ;
                   fat.fsFontUse = FATTR_FONTUSE_OUTLINE | FATTR_FONTUSE_TRANSFORMABLE;

                   if(FONT_MATCH==GpiCreateLogFont (hPS, NULL, lcid_font, &fat));
                   else // font creation failed
                      {
                         fontfound=FALSE;
                   //      GpiDeleteSetId(hPS,lcid_font);
                      }
                } // end if
          } // end for
          } // end else
 DosFreeMem(afm);
 return fontfound;
}
/************************************************************************
 ************************************************************************
 ************************************************************************
 *
 * Create an device outline font
 *
 *
 ************************************************************************
 ************************************************************************
 ************************************************************************/
BOOL CreateDeviceOutlineFont(HPS hPS,HWND hWndClient,LONG lcid_font,
                             PSZ facename,USHORT fm_sel)
{
  LONG         lNumberRequested = 0 ;
  LONG         lNumberReturned ;
  LONG         lReturned ;
  PVOID        afm=NULL;
  FONTMETRICS  *pfm;
  BOOL         fontfound=FALSE;
  LONG         i;
  FATTRS       fat;
//  POINTL  textptl;  BSC-never used
//  USHORT  usCodepage  ; BSC-never used
  LONG         ErrorCount;    //      error count
//  FONTMETRICS fmMetrics; BSC-never used

// To query fonts, you first request no fonts so that the system will
// tell you how many are available.  Once you know that, you allocate
// memory for the font metrics returned.

     lNumberReturned = GpiQueryFonts (hPS, QF_PUBLIC, facename,
         &lNumberRequested,(LONG)(sizeof(FONTMETRICS)),NULL);

     if (lNumberReturned <= 0) {
         SHOWERROR("GpiQueryFonts", "CreateSysOutlineFont");
         return FALSE;
     } // end if

// allocate memory for font metrics

     if ((DosAllocMem(&afm,(LONG)lNumberReturned*sizeof(FONTMETRICS),
         PAG_COMMIT | PAG_WRITE | PAG_READ ))==NO_ERROR)
        pfm=(PFONTMETRICS)afm;
        else
        {
         SHOWERROR("DosAllocMem", "CreateSysOutlineFont");
         return FALSE;
        }

 // Call GpiQueryFonts again to request "Number" fonts and their
 // metrics to be returned in the space pointed to by "pfm"

     if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,facename,
                                 &lNumberReturned,
                                 (LONG)sizeof(FONTMETRICS),
                                 pfm)) == GPI_ALTERROR){
         SHOWERROR("GpiQueryFonts", "CreateImageFont");
         DosFreeMem(afm);
          return FALSE;
     }
     else {

 // Select a generic outline font to use
 //
         for (i=0;(i<lNumberReturned) && (fontfound == FALSE) ; i++) {

           if ((pfm[i].fsDefn & FM_DEFN_OUTLINE) && (pfm[i].lMatch>0))
                {
                   fontfound=TRUE;
                   fat.usRecordLength = sizeof(fat) ;
                   fat.fsSelection = fm_sel;
                   fat.lMatch = pfm[i].lMatch;
                   strcpy (fat.szFacename, pfm[i].szFacename) ;
                   fat.idRegistry = 0 ;
                   fat.usCodePage  = 0; // MAY need to set font 2.0 GA
                   fat.lMaxBaselineExt = 0 ;
                   fat.lAveCharWidth = 0;
                   fat.fsType = 0;
                   fat.fsFontUse = FATTR_FONTUSE_OUTLINE | FATTR_FONTUSE_TRANSFORMABLE;

                   if(FONT_MATCH==GpiCreateLogFont (hPS, NULL, lcid_font, &fat));
                   else // font creation failed
                      {
                         fontfound=FALSE;
                      }
                } // end if
          } // end for
          } // end else
 DosFreeMem(afm);
 return fontfound;
}
