
#define INCL_DEV                    //Include all DEV definitions
#define INCL_WIN                    //Include all WIN definitions
#define INCL_GPI                    //Include all Gpi definitions
#define INCL_ERRORS                 //Include all error definitions
#define INCL_DOSMODULEMGR
#define MAINSOURCEFILE              //This main source code.
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpibtmp.h"                // bit map dll header file

/****************************************************************************
 *\\ddd
 * Subtask Name: Gpibtmp.dll
 *
 * Module name: Gpibtmp.c
 *
 * Purpose: Bitmap DLL test functions
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               11/13/90 ,PDVT ,Mike Abuzant
 *               -Test Case Design.
 *               12/09/90 ,PDVT, Mike Abuzant
 *                     -Eliminated hAB parameter.
 *                     -Edited limitation Section
 *               12/10/90 ,PDVT ,Mike Abuzant
 *               -Started integrating  MAPPING macros.
 *               02/12/91 ,PDVT ,Mike Abuzant
 *               -Started Documenting source code.
 *
 *
 * SAD References:
 *
 * SRS References: Printer Driver Verification Tool
 *
 * Contents:
 *
 * Design Overview:
 *   This TestCase is designed to test Bitmap manipulation functions.These
 *   range form Creating,Deleting,Querying, and Selecting bitmaps to functions
 *   that actually manipulate the bitmaps. Functions tested in this testcase
 *   are listed below :
 *
 *   1. GpiCreateBitmap()
 *   2. GpiSetBitmap()
 *   3. GpiDeleteBitmap()
 *   4. GpiQueryBitmapBits()
 *   5. GpiSetBitmapBits()
 *   6. GpiSetPel()
 *   7. GpiQueryPel()
 *   8. GpiBitBlt()
 *   9. GpiWCBitBlt()
 *  10. GpiQueryBitmapHandle()
 *  11. GpiSetBitmapId()
 *  12. GpiLoadBitmap()
 *  13. GpiQueryBitmapDimension()
 *  14. GpiSetBitmapDimension()
 *  15. GpiQueryBitmapParameters()
 *  16. GpiQueryBitmapFormats()
 *  17. DecOpenDC()
 *  18. DevCloseDC()
 *
 *     All tests include  abasic functionality test and an exhaustive
 *   (test all return codes at the lowest level) test.
 *
 * Limitations:
 *
 *    All hard-copy vector devices will fail on all bit-map operation since
 *  it is impossible to translate bitmaps to vectors.
 *
 *     All the Gpi and Gre functions, other than the above, which are used in
 *  implementing this testcase, are assumed to be fully tested in other
 *  testcases.
 *
 *
 *\\end
****************************************************************************/
/****************************************************************************
 *\\ddd
 * Routine Name: InitTest()
 *
 * Purpose:  Initialize function name and address array for ptt.
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               02/03/91, pdvt, Mike Abuzant
 *               - Entry point names and address are now
 *               - put in an array.
 * Inputs:
 *   sel          // passed through to the InitTestSegVars function
 *   init_info_p  // name and address array used by ptt interface
 *
 * Outputs:
 *   init_info_p  // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the PTT interface
 *
 * Limitations:
 *    None
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   for the number of test functions {
 *       set function name
 *       set function address
 *   }
 *   call init set function
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID Selector, PTESTINITINFO init_info_p)
{
  register USHORT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(Selector);
  return;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitPre1()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi
 *                               precision tests to run.
 *
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               11/13/90 ,PDVT ,Mike Abuzant
 *               -Testcase design and implementation
 *
 *               01/09/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst testcase and modified.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *        SelectionCall   -selection indicator.
 *
 * Outputs:
 *   None.
 * Subroutines Required:
 *       GpiPre1()
 *
 * Limitations:
 *     None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      // Call the precision test subfunction
 *       GpiPre1(HPS hPS,HWND hWndClient)
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitPre1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {

   // Call the precision test subfunction
      GpiPre1(hPS,hWndClient);
  }
  return;
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiPre1()
 *
 * Purpose:  This function will test precision of the Gpi function
 *           GpiWCBitBlt().
 *
 *
 * System Requirements: None
 *
 * Revision Log: 11/13/90, PDVT, Mike Abuzant
 *               -initial creation
 *               01/08/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst test case and modified
 *               -for testing GpiWCBitBlt().
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient     //client window handle
 *
 * Outputs:
 *
 * Subroutines Required:
 *  set_delta().
 *  gpi_grid().
 *
 * Limitations:
 *  None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *    Initialize bitmap information header structure and bitmap information
 *    structure to the size and attributes of bitmap to be created.
 *
 *    Open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context
 *      hDC1=DevOpenDC(hAB,OD_MEMORY,....);
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *      hPS1=GpiCreatePS(hAB,....);
 *
 *    Create the bitmap and obtain a handle to it.
 *     hBM=GpiCreateBitmap(hPS1,....);
 *
 *    Setup condtions to call the function GpiWCBitBlit() with 'ROP_ONE' as
 *    a raster operation to be performed on bitmap. This will set all
 *    bitmap bits to  1's.
 *       GpiWCBitBlt(hPS,hBM,ROP_ONE......);
 *
 *    Setup condtions to call the function GpiWCBitBlit() with 'ROP_SRCCOPY'
 *    as a raster operation to be performed on bitmap. This will copy the
 *    bitmap to the target display device and stretch it to fill a 1" X 1"
 *    grid cell. The bitmap is an image of a CROSS which is 16 X 16 pixels.
 *       GpiWCBitBlt(hPS,hBM,ROP_SRCCOPY...);
 *
 *    Setup condtions to call the function GpiWCBitBlit() with 'ROP_NOTSRCCOPY'
 *    as a raster operation to be performed on bitmap. This will copy the
 *    the  bitmap to the target display device. While copying, the bitmap
 *    is inverted and stretched to fill a 1" X 1" grid cell. The bitmap
 *    dimensions are 2 X 2  pixels.
 *       GpiWCBitBlt(hPS,hBM,ROP_NOTSRCCOPY...);
 *
 *    Delete the bitmap.
 *       GpiDeletetBitmap(hBM);
 *
 *    Destory the presentation space.
 *       GpiDestoryPS(hPS1);
 *
 *    Close the device context
 *        DevCloseDC(hDC1);
 * }
 *\\end
 ***************************************************************************/
INT GpiPre1(HPS hPS,HWND hWndClient)
{
   static  PCHAR EntryName="GpiBitPre1()";
   static SIZEL sizel={0L,0L};          //Size PS to create.
   HBITMAP hBM;                         //Bitmap handle
   HDC   hDC;
   HDC   hDC1;
   HPS   hPS1;
   HAB   hAB;
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure

   POINTL aptl[4];                     //Used as an agrument to GpiWCBitBlt()
   BYTE   Temp_buffer[200];
   CHAR   String[100];

    ENTER_MAIN(EntryName);

    //Get Device Context associated with current PS.
    if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
       CLEANUP("GpiQueryDevice()",EntryName);
       return FALSE;      //Can't continue without this DC.
     }

    //Get Anchore Block. it is used for craeting new PS.
    if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
        CLEANUP("WinQueryAnchorBlock()",EntryName);
        return FALSE;     //Can't continue without this AB.
    }
    // call the grid function to draw 1" X 1" grid cells.
    gpi_grid(hPS,(LONG)INCH);

   // Initalize the Bitmap information structure
   // first we need to  allocate memory to hold RGB array
   // since  BITMAPINFO structure is large enough to hold
   // one RGB structure.

    pBitMapInfo=(PBITMAPINFO) Temp_buffer;
    pBitMapInfo->cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    pBitMapInfo->cx=CROSS_WIDTH;                 //Width
    pBitMapInfo->cy=CROSS_HEIGHT;                 //height
    pBitMapInfo->cPlanes=1;                      // one color plane
    pBitMapInfo->cBitCount=1;                    // 1-bit /pixel
    pBitMapInfo->argbColor[0].bBlue=
    pBitMapInfo->argbColor[0].bGreen=
    pBitMapInfo->argbColor[0].bRed=0;
    pBitMapInfo->argbColor[1].bBlue=
    pBitMapInfo->argbColor[1].bGreen=
    pBitMapInfo->argbColor[1].bRed=0xFF;

    BitMapHeader.cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    BitMapHeader.cx=CROSS_WIDTH;                 //Width
    BitMapHeader.cy=CROSS_HEIGHT;                //height
    BitMapHeader.cPlanes=1;                      // one color plane
    BitMapHeader.cBitCount=1;                    // 1-bit /pixel


    /***********************************************************
    * This code segment is intended to create new Presentation *
    * Space  and associate it with memory Device Context. The  *
    * The need for a new PS and a new DC stem from the fact    *
    * that bitmaps belongs to DCs of OD_MEMORY type.           *
    ***********************************************************/
    // Open a Memory device context  to use for bitmap operations.
    if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                        (HDC)hDC))==DEV_ERROR){
       CLEANUP("DevOpenDC()",EntryName);
       return FALSE;
    }

    // Create a presentation space to associate with the
    // memory Device Context
    if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS|
                          GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
       CLEANUP("GpiCreatePS()",EntryName);
       return FALSE;
    }

    // Create and obtain a bitmap handle to use with GpiWCBitBlt();
    if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                               CBM_INIT,abCross,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
       CLEANUP("GpiCreateBitmap()",EntryName);
       return FALSE;
    }

    /***********************************************************************
    * Perform a GpiWCBitBlt()  operation that will set all bits (ROP_ONE)  *
    * within the bitmaps to all ONE'S and copy the bit map to the display  *
    * device passed to us by PTT.EXE                                       *
    ***********************************************************************/
    //Set the dimensions and location of the target rectangle.

    aptl[0].x=MapX(5*delta_x);
    aptl[0].y=MapY(5*delta_y);
    aptl[1].x=MapX(6*delta_x)+1;
    aptl[1].y=MapY(6*delta_y)+1;

    if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_ONE,BBO_AND)==GPI_ERROR){
        CLEANUP("GpiWCBitBlt()",EntryName);
        return FALSE;
    }
    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
    strcpy(String,"GpiWCBitBlt() with ROP_ONE On Square Box 1\" X 1\""
                   "Located @ (5\", 5\")");

    MapAndWriteString(2*delta_x,9*delta_y/2,String);

    /****************************************************************
    * Perform a GpiWCBitBlt()  operation that will copy and stretch *
    * 16 X 16 pixel CROSS  bitmap to fill  1" X 1" grid cell.       *
    *****************************************************************/
    //Set the dimensions and location of the target rectangle to copy to.
    aptl[0].x=MapX(5*delta_x);
    aptl[0].y=MapY(3*delta_y);
    aptl[1].x=aptl[0].x+MapX(delta_x)+1;
    aptl[1].y=aptl[0].y+MapY(delta_y)+1;

    //Set the dimensions and location of the source rectangle to copy from.
    aptl[2].x=0;
    aptl[2].y=0;
    aptl[3].x=CROSS_WIDTH;
    aptl[3].y=CROSS_HEIGHT;

    if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR){
        CLEANUP("GpiWCBitBlt()",EntryName);
        return FALSE;
    }

    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
    strcpy(String,"Stretching 16 X 16 pixel bitmap to fill");
    MapAndWriteString(9*delta_x/2,8L*delta_y/3L,String);

    strcpy(String,"1\" X 1\"  Box Located @ (5\", 3\")");
    MapAndWriteString(9*delta_x/2,7*delta_y/3,String);

    /****************************************************************
    * Perform a GpiWCBitBlt()  operation that will copy an stretch  *
    * a 1 X 2 pixel bitmap to fill  1" X 1" grid cell.              *
    *****************************************************************/
    //Set the dimensions and location of the target rectangle to copy to.
     aptl[0].x=MapX(2*delta_x);
     aptl[0].y=MapY(3*delta_y);
     aptl[1].x=aptl[0].x+MapX(delta_x)+1;
     aptl[1].y=aptl[0].y+MapY(delta_y)+1;

    //Set the dimensions and location of the source rectangle to copy from.
     aptl[2].x=
     aptl[2].y=0L;
     aptl[3].x=
     aptl[3].y=2L;

     if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_NOTSRCCOPY,BBO_AND)==GPI_ERROR){
         CLEANUP("GpiWCBitBlt()",EntryName);
         return FALSE;
     }
    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
     if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR)
          REPORTSETUPERROR("GpiSetColor()");

     strcpy(String,"Stretching 2 X 1 pixel bitmap to fill");
     MapAndWriteString(delta_x/3,8L*delta_y/3L,String);

     strcpy(String,"1\" X 1\"  Box Located @ (2\",3\")" );
     MapAndWriteString(delta_x/3,7L*delta_y/3L,String);

    // Delete the bitmap handle.
    // device context
    if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return FALSE;
    }

    // dispose of presentation space. No longer needed.
    if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()",EntryName);
         return FALSE;
    }

    //Close the device context
    if (DevCloseDC(hDC1)==DEV_ERROR){
      CLEANUP("DevCloseDC()",EntryName);
      return FALSE;
    }

    EXIT_MAIN(EntryName);

    return TRUE;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitPre2()
 *
 * Purpose:  This is an entry point for the PTT that causes Gpi
 *                               precision tests to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/20/90 ,PDVT ,Mike Abuzant
 *               -initial file.
 *               01/09/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst testcase and modified.
 *
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *        SelectionCall   -selection indicator.
 *
 * Outputs:
 *
 * Subroutines Required:
 *   set_delta().
 *   gpi_grid().
 *
 * Limitations:
 *   None at This time.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *    Initialize bitmap information header structure and bitmap information
 *    structure to the size and attributes of bitmap to be created.
 *
 *    Open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context
 *      hDC1=DevOpenDC(hAB,OD_MEMORY,....);
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *      hPS1=GpiCreatePS(hAB,....);
 *
 *    Create the bitmap and obtain a handle to it.
 *     hBM=GpiCreateBitmap(hPS1,....);
 *
 *    Assign the bitmap to the the newly created device context.
 *     GpiSetBitmap(hPS,hBM ..);
 *
 *    Setup condtions to call the function GpiBitBlit() with 'ROP_ONE' as
 *    a raster operation to be performed on bitmap. This will set all
 *    bitmap bits to  1's.
 *       GpiBitBlt(hPS,hBM,ROP_ONE......);
 *
 *    Setup condtions to call the function GpiBitBlit() with 'ROP_DSINVERT'
 *    as a raster operation to be performed on bitmap. This will invert all
 *    bitmap bits (i.e, 1's become 0's and vice versa).
 *       GpiBitBlt(hPS,hBM,ROP_DSINVERT...);
 *
 *    Setup condtions to call the function GpiBitBlit() with 'ROP_SRCCOPY'
 *    as a raster operation to be performed on bitmap. This will copy the
 *    bitmap to the target display device and stretch it to fill a 1" X 1"
 *    grid cell. The bitmap is an image of a CROSS which is 16 X 16 pixels.
 *       GpiBitBlt(hPS,hBM,ROP_SRCCOPY...);
 *
 *    De-Select the bitmap form the presentation space passing  NULL
 *    as a bitmap handle. This will serve as De-selecting.
 *       GpiSetBitmap(hPS1,NULL....);
 *
 *    Delete the bitmap.
 *       GpiDeletetBitmap(hBM);
 *
 *    Destory the presentation space.
 *       GpiDestoryPS(hPS1);
 *
 *    Close the device context
 *        DevCloseDC(hDC1);
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitPre2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   static  PCHAR EntryName="GpiBitPre2()";
   static SIZEL sizel={0L,0L};          //Size of PS to create.
   HBITMAP hBM;                         //Bitmap handle.
   HDC   hDC1;
   HDC   hDC;
   HPS   hPS1;
   HAB   hAB;
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure

   POINTL aptl[4];                    //Used as an argument to GpiBitBlt().
   BYTE   Temp_buffer[200];
   CHAR   String[100];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(EntryName);

    //Get Device Context associated with crrent prsentation space.
    if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
       CLEANUP("GpiQueryDevice()",EntryName);
       return;    //Nothing can be done without this DC.
    }
    //Get Anchore Block. It used when creating new Presentation Spaces.
    if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
        CLEANUP("WinQueryAnchorBlock()",EntryName);
        return;    //Nothing can be done without this AB.
    }
    // call the grid function to draw 1" X 1" grid cells.
    gpi_grid(hPS,(LONG)INCH);

    // Initalize the Bitmap information structure
    // first we need to  allocate memory to hold RGB array
    // since  BITMAPINFO structure is large enough to hold
    // one RGB structure.

    pBitMapInfo=(PBITMAPINFO) Temp_buffer;
    pBitMapInfo->cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    pBitMapInfo->cx=CROSS_WIDTH;                 //Width
    pBitMapInfo->cy=CROSS_HEIGHT;                 //height
    pBitMapInfo->cPlanes=1;                      // one color plane
    pBitMapInfo->cBitCount=1;                    // 1-bit /pixel
    pBitMapInfo->argbColor[0].bBlue=
    pBitMapInfo->argbColor[0].bGreen=
    pBitMapInfo->argbColor[0].bRed=0;
    pBitMapInfo->argbColor[1].bBlue=
    pBitMapInfo->argbColor[1].bGreen=
    pBitMapInfo->argbColor[1].bRed=0xFF;

    BitMapHeader.cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    BitMapHeader.cx=CROSS_WIDTH;                 //Width
    BitMapHeader.cy=CROSS_HEIGHT;                //height
    BitMapHeader.cPlanes=1;                      // one color plane
    BitMapHeader.cBitCount=1;                    // 1-bit /pixel

    /***********************************************************
    * This code segment is intended to create new Presentation *
    * Space  and associate it with memory Device Context. The  *
    * The need for a new PS and a new DC stem from the fact    *
    * that bitmaps belongs to DCs of OD_MEMORY type.           *
    ***********************************************************/
    // Open a Memory device context  to use for bitmap operations.
    if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                        (HDC)hDC))==DEV_ERROR){
       CLEANUP("DevOpenDC()",EntryName);
       return;
    }

    // Create a presentation space to associate with the
    // memory device context
    if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS |
                          GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
       CLEANUP("GpiCreatePS()",EntryName);
       return;
    }

    // Create and obtain a bitmap handle to use with GpiBitBlt();
    if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                               CBM_INIT,abCross,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
       CLEANUP("GpiCreateBitmap()",EntryName);
       return;
    }

   /*******************************************************************
    * Perform a GpiBitBlt() operation that will invert(ROP_DSTINVERT) *
    * a 1" X 1" grid cell.                                            *
    *******************************************************************/
     //Setup size of the target rectangle to invert.


     aptl[0].x=MapX(delta_x*2);
     aptl[0].y=MapY(delta_y*3);
     aptl[1].x=MapX(delta_x*3)+1;
     aptl[1].y=MapY(delta_y*4)+1;
     if (GpiConvert(hPS,CVTC_WORLD,CVTC_DEVICE,2L,aptl)==FALSE){
         CLEANUP("GpiConvert()",EntryName);
         return;
     }

     if (GpiBitBlt(hPS,hPS1,2L,aptl,ROP_DSTINVERT,BBO_AND) == GPI_ERROR){
         CLEANUP("GpiBitBlt()",EntryName);
         return;
     }
    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
     if (GpiSetColor(hPS,CLR_DEFAULT)==GPI_ERROR)   // Set foreground color to Green
          REPORTSETUPERROR("GpiSetColor()");

     strcpy(String,"Inverted Image Of Square Box ");
     MapAndWriteString(delta_x,8L*delta_y/3L,String);

     strcpy(String,"1\" X 1\"  Located @ (2\",3\")" );
     MapAndWriteString(delta_x,7L*delta_y/3L,String);

   /***************************************************************
    * Perform a GpiBitBlt() operation that will set entire target *
    * rectangle's bits to 1's (ROP_ONE).                          *
    ***************************************************************/
     //Setup size of the target rectangle to copy to.
     aptl[0].x=MapX(delta_x*5);
     aptl[0].y=MapY(delta_y*5);
     aptl[1].x=MapX(delta_x*6)+1;
     aptl[1].y=MapY(delta_y*6)+1;
     if (GpiConvert(hPS,CVTC_WORLD,CVTC_DEVICE,2L,aptl)==FALSE){
         CLEANUP("GpiConvert()",EntryName);
         return;
     }

     if (GpiBitBlt(hPS,hPS1,2L,aptl,ROP_ONE,BBO_AND)==GPI_ERROR){
         CLEANUP("GpiBitBlt()",EntryName);
         return;
     }
    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
     strcpy(String,"GpiBitBlt() with ROP_ONE On Square Box 1\" X 1\""
                   " Located @ (5\", 5\")");
     MapAndWriteString(2*delta_x,9*delta_y/2,String);

    /****************************************************************
    * Perform a GpiBitBlt()  operation that will copy and stretch   *
    * a 16 X 16 pixel bitmap to fill  1" X 1" grid cell.            *
    *****************************************************************/

     //Setup size of the target rectangle to copy to.
     aptl[0].x=MapX(delta_x*5);
     aptl[0].y=MapY(delta_y*3);
     aptl[1].x=MapX(delta_x*6)+1;
     aptl[1].y=MapY(delta_y*4)+1;
     if (GpiConvert(hPS,CVTC_WORLD,CVTC_DEVICE,2L,aptl)==FALSE){
         CLEANUP("GpiConvert()",EntryName);
         return;
     }

     //Source rectangle to copy from.
     aptl[2].x=0;
     aptl[2].y=0;
     aptl[3].x=CROSS_WIDTH;
     aptl[3].y=CROSS_HEIGHT;

     //Select bitmap into presentation space.
     if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
         CLEANUP("GpiSetBitmap()",EntryName);
         return;
     }
     if (GpiBitBlt(hPS,hPS1,4L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR){
         CLEANUP("GpiBitBlt()",EntryName);
         return;
     }
    /*******************************************************************
     * Inform  user of the location of last BitBlt in order for him/her *
     * to verify the correctness of this operation.                     *
     *******************************************************************/
     strcpy(String,"Stretching 16 X 16 pixel bitmap to fill");
     MapAndWriteString(9*delta_x/2,8L*delta_y/3L,String);
     strcpy(String,"1\" X 1\"  Box  Located @ (5\", 3\")");
     MapAndWriteString(9*delta_x/2,7*delta_y/3,String);

    /*=================================================================
      The purpose of next code segment is do some house cleaning
      before exiting this routine. the following is done:
      1. De-select any bitmaps that are selected into memory Device
         Contexts or/and Un-tag any bitmaps that are used as pattern.
      2. Delete any bitmaps created within this function.
      3. Delete any Presentation Spaces created within this function.
      4. Delate any Device Contexts created within this function.

         Note that these steps must be followed as presented above,
         otherwise; most GPIs used here will fail.
    ===================================================================*/
    // De-select the bitmap handle. otherwise we get error when closing
    // device context
     if (GpiSetBitmap(hPS1,NULL)==HBM_ERROR){
         CLEANUP("GpiSetBitmap()",EntryName);
         return;
     }

    // Delete the bitmap handle.
    // device context
    if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return;
     }

    // dispose of presentation space. No longer needed.
    if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()",EntryName);
         return;
    }

    //Close the device context
    if (DevCloseDC(hDC1)==DEV_ERROR){
      CLEANUP("DevCloseDC()",EntryName);
      return;
    }
    EXIT_MAIN(EntryName);
  }
  return;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitApp1()
 *
 * Purpose:  This function tests the basic functionality of the following
 *           Gpi functions:
 *
 *    GpiCreateBitmap()
 *    GpiSetBitmap()
 *    GpiDeleteBitmap()
 *    GpiSetBitmapBits()
 *    GpiBitBlt()
 *    GpiQueryBitmapParameters()
 *    GpiQueryDeviceBitmapFormats()
 *    DevOpenDC()
 *    DevCloseDC()
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               01/23/1991 ,PDVT , Mike Abuzant
 *               - TestCase coding and design
 *
 * Inputs:
 *    hps              // presentation space
 *    hWndClient     // client window
 *    SelectionCall   // selection parameter
 *
 * Outputs:
 *
 * Subroutiynes Required:
 *     GpiApp1()
 *
 * Limitations:
 *
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   // call the functionality  subfunction
 *     GpiApp1( hPS, hWndClient );
 *
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
      GpiApp1(hPS,hWndClient);
  }
    return ;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiApp1()
 *
 * Purpose:  This is an entry point for the PTT.EXE that causes Gpi
 *                               Application tests  to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/24/90 ,PDVT ,Mike Abuzant
 *               -initial file.
 *               01/23/1991 ,PDVT , Mike Abuzant
 *               - TestCase coding and design.
 *               9/04/91, Vish (Boca)
 *               - Incremented the aptl[1].x value
 *                 changed from (xPixels * lIndex) to (xPixels * lIndex) + 1.
 *        Reason : When lIndex1 = 1, the aptl[0].x and aptl[1].x were the same.
 *                 So, all the drivers were skipping the BitBlt for lIndex =1
 *                 and some printer drivers were stuck at that point and hung
 *                 the system.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *
 * Outputs:
 *   None.
 * Subroutines Required:
 *
 *
 * Limitations:
 *    The Gpi function GpiSetBitmapBits() does not use its last parameter.
 *   This parameter tells the function what the  dimensions of the bitmap
 *   are .
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *      allocate memory for the bitmap information structure.
 *
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterisics with the bitmap to be created.
 *
 *    open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context
 *        HDC=DevOpenDC(hAB,OD_MEMORY,....);
 *
 *    Get The first bitmap format that is supported by
 *    current device.
 *        GpiQueryDeviceBitmapFormats(hPS,2L,alFormats)
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *        hPS1=GpiCreatePS(hAB,....);
 *
 *    Create the bitmap and obtain a handle to it.
 *        hBM=GpiCreateBitmap(hPS1,....);
 *
 *    Assign the bitmap to the the newly created device context.
 *        GpiSetBitmap(hPS1,hBM ..);
 *
 *    Setup conditions to begin an area to draw a 1" X 1" Box
 *     and  draw two  triangles within this Box.
 *       GpiBeginArea(hPS,....);
 *
 *    Setup a call to draw a 1" X 1" box
 *       GpiBox(hPS,DRO_OUTLINE,....);
 *
 *    Setup conditions to draw two triangles inside the box and
 *    Close the area we began. This will automatically fills the
 *    polylines with current Pattern .
 *       GpiEndArea(hPS1.....);
 *
 *   Setup condtion to perform a serise of Bitmap manipulations
 *   using the GpiBitBlt() functions.
 *
 *   First Set up the dimensions of the Source bitmap and
 *   and the dimensions of the Target bitmap And then call
 *   GpiBitBlt() with one of the many raster operations performed
 *   on bitmaps. i.e ROP_SRCCOPY, ROP_DSTINVERT,ROP_PATPAINT,
 *   ROP_PATINERT,and ROP_MERGECOPY
 *
 *       GpiBitBlt(hPS,hPs1,ROP_DTSCOPY...);
 *
 *   De-Select the bitmap form the device context passing  NULL as a bitmap
 *   handle. This will serve as De-selecting.
 *       GpiSetBitmap(hPS1,NULL....);
 *
 *   Delete the bitmap.
 *       GpiDeletetBitmap(hBM);
 *
 *   Destory the presentation space.
 *       GpiDestoryPS(hPS1);
 *
 *   Close the device context
 *       DevCloseDC(hDC1);
 *
 *   return to PTT.EXE
 *
 * }
 *\\end
 ***************************************************************************/
INT GpiApp1(HPS hPS,HWND hWndClient)
{
   static PCHAR EntryName="GpiBitApp1()";

   HBITMAP hBM=(HBITMAP)NULL;          //Bitmap Handle.
   BYTE  Temp_buffer[200];
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure
   static           SIZEL  sizel={0L,0L};

   HDC   hDC,
         hDC1;
   HAB   hAB;
   HPS   hPS1;
   double xPixels,                     //Pixels per inch in X-direction
          yPixels;                     //Pixels per inch in Y-direction
   POINTL  ptl,                        //Screen coordinate point
           aptl[4];                    //Used as an argument to GpiBitBlt().
   BOOL    fQuit;
   INT  color_index=0;                  // color index

   LONG lOperation=ROP_SRCCOPY,
        lIndex1,
        lIndex2,
        alFormats[2];                 //Storage for bitmap formats
                                      //supported by current device.
   ENTER_MAIN(EntryName);

   //Get The first bitmap format that is supported by
   //current device.
   if (GpiQueryDeviceBitmapFormats(hPS,2L,alFormats)==FALSE){
       CLEANUP("GpiQueryDeviceBitmapFormats()",EntryName);
       return FALSE ;
   }

    // Calculate the pixels per inch in X-direction
   xPixels=(double)CONVERTTOINCHES(hori_pels_per_m);

    // Calculate the pixels per inch in Y-direction
   yPixels=(double)CONVERTTOINCHES(vert_pels_per_m);

   //Get Anchor Block. It used for creating new presentation spaces.
   if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
         CLEANUP("WinQueryAnchorBlock()",EntryName);
         return FALSE;        // Can't proceed without Anchor block
    }

    //Get Device Context associated with current PS.
   if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
         CLEANUP("GpiQueryDevice()",EntryName);
         return FALSE;       // Can't proceed without hDC
    }

   // Initalize the Bitmap information structure
   // first we need to  allocate memory to hold RGB array
   // since  BITMAPINFO structure is large enough to hold
   // one RGB structure.
    pBitMapInfo=(PBITMAPINFO) Temp_buffer;

    pBitMapInfo->cbFix=sizeof(BitMapHeader);     //This always =12
    pBitMapInfo->cx=CAT_WIDTH;                   //Width
    pBitMapInfo->cy=CAT_HEIGHT;                  //height
    pBitMapInfo->cPlanes=(USHORT)alFormats[0];   //color plane
    pBitMapInfo->cBitCount=(USHORT)alFormats[1]; //bits per pixel

    pBitMapInfo->argbColor[0].bBlue=
    pBitMapInfo->argbColor[0].bGreen=
    pBitMapInfo->argbColor[0].bRed= 0x0;
    pBitMapInfo->argbColor[1].bBlue=
    pBitMapInfo->argbColor[1].bGreen=
    pBitMapInfo->argbColor[1].bRed= 0xFF;

    BitMapHeader.cbFix=sizeof(BitMapHeader);    // This always =12
    BitMapHeader.cx=(SHORT)xPixels+1;           //Width
    BitMapHeader.cy=(SHORT)yPixels+1;           //height
    BitMapHeader.cPlanes=(USHORT)alFormats[0];   //color plane
    BitMapHeader.cBitCount=(USHORT)alFormats[1]; //bits per pixel

    /***********************************************************
    * This code segment is intended to create new Presentation *
    * Space  and associate it with memory Device Context. The  *
    * The need for a new PS and a new DC stem from the fact    *
    * that bitmaps belongs to DCs of OD_MEMORY type.           *
    ***********************************************************/
    // Open a Memory device context  to use for bitmap operations.
    if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                        (HDC)hDC))==DEV_ERROR){
         CLEANUP("DevOpenDC()",EntryName);
         return FALSE;       // Can't proceed without hDC
    }

    // Create a presentation space to associate with the
    // memory device context
    if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS|
                          GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
         CLEANUP("GpiCreatePS()",EntryName);
         return FALSE;       // Can't proceed without hPS
    }

    //Create an empty bitmap. It will be later initialized
    //with data from different bitmaps.
    if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                               0L,NULL,NULL))==GPI_ERROR){
       CLEANUP("GpiCreateBitmap()",EntryName);
       return FALSE;
    }

    /*********************************************************
    *  Select bitmap into memory Device Context. Each bitmap *
    *  created MUST belong to a MEMORY Device Context.       *
    *  Note that in order to use a memory device context,    *
    *  you must select a bitmap into it,otherwise; you get   *
    *  the message PMERR_BITMAP_IS_NOT_SELECTED.             *
    *********************************************************/
    if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
         CLEANUP("GpiSetBitmap()",EntryName);
         return FALSE;
    }

    //Get this PS to a fresh start.
    if (GpiErase(hPS1)==FALSE){
       CLEANUP("GpiErase()",EntryName);
       return FALSE;
    }

    //Make PATSYM_DENSE4 the default filling pattern
    if (GpiSetPattern(hPS1,PATSYM_DENSE4)==GPI_ERROR){
          CLEANUP("GpiSetPattern()",EntryName);
          return FALSE;
    }

    // Define an area that will contains three triangles
    // and a box wich is rotated 90 degrees CW.
    if (GpiBeginArea(hPS1,BA_BOUNDARY |BA_ALTERNATE)==GPI_ERROR){
         CLEANUP("GpiBeginArea()",EntryName);
         return FALSE;
    }
    ptl.x=
    ptl.y=0;
    if (GpiMove(hPS1,&ptl)==GPI_ERROR){  //Move to the first box corner.
         CLEANUP("GpiMove()",EntryName);
         return FALSE;
    }
    //Draw an outlined box.
    ptl.x=(LONG)xPixels;
    ptl.y=(LONG)yPixels;
    if (GpiBox(hPS1,DRO_OUTLINE,&ptl,0L,0L)==GPI_ERROR){
         CLEANUP("GpiBox()",EntryName);
         return FALSE;
    }

    //Set up coordinates to draw the first triangle inside the box.
    aptl[0].x=
    aptl[0].y=0L;
    aptl[1].x=(LONG)(xPixels/2);
    aptl[1].y=(LONG)(yPixels/2);
    aptl[2].x=(LONG)xPixels;
    aptl[2].y=0L;

    if (GpiMove(hPS1,aptl)==GPI_ERROR){
         CLEANUP("GpiMove()",EntryName);
         return FALSE;
    }
    if (GpiPolyLine(hPS1,2L,aptl+1)==GPI_ERROR){
         CLEANUP("GpiPolyLine()",EntryName);
         return FALSE;
    }
    //Set up coordinates to draw the second triangle inside the box.
    aptl[0].x=0L;
    aptl[0].y=(LONG)yPixels;
    aptl[2].x=(LONG)xPixels;
    aptl[2].y=(LONG)yPixels;
    if (GpiMove(hPS1,aptl)==GPI_ERROR){
         CLEANUP("GpiMove()",EntryName);
         return FALSE;
    }
    if (GpiPolyLine(hPS1,2L,aptl+1)==GPI_ERROR){
         CLEANUP("GpiPolyLine()",EntryName);
         return FALSE;
    }

    //Close the area and fill the figure formed with current pattern.
    if (GpiEndArea(hPS1)==GPI_ERROR){
         CLEANUP("GpiEndArea()",EntryName);
         return FALSE;
    }

    /* Setup Conditions to copy and stretch a 1" X 1" bitmap */

    //initial dimensions for the Target rectangle
    aptl[0].x=0L;
    aptl[0].y=(LONG)(yPixels*2/3);
    aptl[1].x=(LONG)xPixels;
    aptl[1].y=(LONG)(yPixels*5/3);

    //Source rectangle to copy from
     aptl[2].x=
     aptl[2].y=0L;
     aptl[3].x=(LONG)xPixels+1;
     aptl[3].y=(LONG)yPixels+1;
     fQuit=FALSE;

     if DeviceIsPrinter() {
       if ((pBitMapInfo->cBitCount) > 1) {
         lOperation = ROP_SRCCOPY;  }   //Current device is a color printer
       else {
          lOperation=ROP_NOTSRCCOPY;  //Current Device is a monochrome printer.
       }
     }

     for (lIndex1=0 ; !fQuit;lIndex1++){
     //Quit if you reached the end of Device Context
       if (aptl[1].x >((LONG)(xPixels*pg_size_x))){
           aptl[1].x =((LONG)(xPixels*pg_size_x));
           fQuit=TRUE;
       }
       if (aptl[1].y >((LONG)(yPixels*pg_size_y))){
           aptl[1].y =((LONG)(yPixels*pg_size_y));
       }

       //Retrieved the bitmap parameters namely, bitmap width and height.
       if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
           CLEANUP("GpiQueryBitmapParameters()",EntryName);
           return FALSE;
       }
       //Setup the dimesions of the bitmap to copy to.
       aptl[3].x=(LONG)BitMapHeader.cx;
       aptl[3].y=(LONG)BitMapHeader.cy;

       if (GpiBitBlt(hPS,hPS1,4L,aptl,lOperation,BBO_AND)==GPI_ERROR){
            CLEANUP("GpiBitBlt()",EntryName);
            return FALSE;
       }
       aptl[0].x=aptl[1].x;
       aptl[1].x+=(LONG)((xPixels*lIndex1)+1);      //fix - Vish
       aptl[1].y+=(LONG)((yPixels/2)*lIndex1);

     }
      /* Setup Conditions to do bitmap manipulation by setting
       * the dimensions for the Target ans Source regtangles
       * and setting the pattern and the foreground color.
       * Then use the GpiBitBlt() function with the above
       * settings.
      */
      //Set the dimensions for the target rectangle.
      aptl[0].x=(LONG)(xPixels/5);
      aptl[1].y=
      aptl[0].y=(LONG)(5L*yPixels/2);


     for (lIndex1=1; lIndex1 < 9;lIndex1++){

       aptl[1].x=aptl[0].x+(LONG)(xPixels*2/(lIndex1+1));
       aptl[1].y=aptl[0].y+(LONG)(yPixels*2/(lIndex1+1));

       if (GpiBitBlt(hPS,hPS1,4L,aptl,lOperation,BBO_AND)==GPI_ERROR){
            CLEANUP("GpiBitBlt()",EntryName);
            return FALSE;
       }
       aptl[0].y+=(LONG)(yPixels*2/(lIndex1+1))+5;
     }

     //Retrieve the bitmap parameters namely, bitmap width and height.
     if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
           CLEANUP("GpiQueryBitmapParameters()",EntryName);
           return FALSE;
     }

     //If the parameters of the currently selected bitmap
     //is not the same as the next bitmap to display, delete
     //the selected bitmap and create an new bitmap with the
     //desired parameters.

     if ((BitMapHeader.cx !=CAT_WIDTH) || (BitMapHeader.cy !=CAT_HEIGHT)
          || (BitMapHeader.cPlanes!=1) || (BitMapHeader.cBitCount!=1)){

           // De-select the bitmap handle. otherwise we get error
           // when closing device context
           if (GpiSetBitmap(hPS1,NULL)==FALSE){
              CLEANUP("GpiSetBitmap()",EntryName);
              return FALSE;
           }
           //Release memory space occupied by this bitmap.
           if (GpiDeleteBitmap(hBM)==FALSE){
                CLEANUP("GpiDeleteBitmap()",EntryName);
                return FALSE;
           }
           //Setup the parameters for the new bitmap
           BitMapHeader.cx=CAT_WIDTH;
           BitMapHeader.cy=CAT_HEIGHT;

           pBitMapInfo->cPlanes=
           BitMapHeader.cPlanes=1;        // one color plane
           pBitMapInfo->cBitCount=
           BitMapHeader.cBitCount=1;     // 1-bit /pixel

           //Create an empty bitmap.
           if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                                     0L,NULL,NULL))==GPI_ERROR){
             CLEANUP("GpiCreateBitmap()",EntryName);
             return FALSE;
           }

          //Set bitmap to use the memory device context .
          // Each bitmap created MUST belong to a device context.
           if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
              CLEANUP("GpiSetBitmap()",EntryName);
              return FALSE;
           }

           //Initialize the selected bitmap with data
           //for the 'CAT'
           if (GpiSetBitmapBits(hPS1,0L,(LONG)CAT_HEIGHT,abCat,
                                (PBITMAPINFO2)pBitMapInfo)==GPI_ALTERROR){
              CLEANUP("GpiSetBitmapBits()",EntryName);
              return FALSE;
           }
     }
     else {
          //Initialize the selected bitmap with data
          //for the 'CAT'
          if (GpiSetBitmapBits(hPS1,0L,(LONG)CAT_HEIGHT,abCat,
                               (PBITMAPINFO2)pBitMapInfo)==GPI_ALTERROR){
             CLEANUP("GpiSetBitmapBits()",EntryName);
             return FALSE;
          }
     }

     //Setup the dimensions of the source rectangle to copy from.
     aptl[2].x=0L;
     aptl[2].y=0L;
     aptl[3].x=BitMapHeader.cx;
     aptl[3].y=BitMapHeader.cy;

     //Copy the selected bitmap to the display until we
     //fill the desired area of the display.

     for (lIndex2=(LONG)(yPixels*pg_size_y);lIndex2>(LONG)(yPixels*4L);lIndex2-=CAT_HEIGHT){
        //readjust the target rectangle.
        aptl[0].y=lIndex2-CAT_HEIGHT;
        aptl[1].y=lIndex2;

        for (lIndex1=(LONG)(xPixels);lIndex1<(LONG)(xPixels*14L/4L) ;lIndex1+=CAT_WIDTH){
           // Set foreground color to a different color than default_color
           if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR){
              CLEANUP("GpiSetColor()",EntryName);
              return FALSE;
           }
           INCROMENTWITHWRAP(color_index,colors);

           aptl[0].x=lIndex1;
           aptl[1].x=lIndex1+CAT_WIDTH;

           //Retrieve the bitmap parameters namely, bitmap width and height.
           if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
               CLEANUP("GpiQueryBitmapParameters()",EntryName);
               return FALSE;
           }
           aptl[3].x=(LONG)BitMapHeader.cx;
           aptl[3].y=(LONG)BitMapHeader.cy;

           if (GpiBitBlt(hPS,hPS1,3L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR){
              CLEANUP("GpiBitBlt()",EntryName);
              return FALSE;
           }
        }
     }

    /*=================================================================
      The purpose of next code segment is do some house cleaning
      before exiting this routine. the following is done:
      1. De-select any bitmaps that are selected into memory Device
         Contexts or/and Un-tag any bitmaps that are used as pattern.
      2. Delete any bitmaps created within this function.
      3. Delete any Presentation Spaces created within this function.
      4. Delate any Device Contexts created within this function.

         Note that these steps must be followed as presented above,
         otherwise; most GPIs used here will fail.
    ===================================================================*/

     // De-select the bitmap handle. otherwise we get error when closing
     // device context
     if (GpiSetBitmap(hPS1,NULL)==FALSE){
        CLEANUP("GpiSetBitmap()",EntryName);
        return FALSE;
     }

     //Release memory space occupied by this bitmap.
     if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return FALSE;
     }

    // dispose of Presentation Space. No longer needed.
    if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()",EntryName);
         return FALSE;
    }

    //Close the device context
    if (DevCloseDC(hDC1)==DEV_ERROR){
      CLEANUP("DevCloseDC()",EntryName);
      return FALSE;
    }
    EXIT_MAIN (EntryName);

    return TRUE;

}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitApp2()
 *
 * Purpose:  This function tests the basic functionality of the following
 *           Gpi functions:
 *
 *     GpiSetPel()
 *     GpiQueryPel()
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/23/1990 ,PDVT , Mike Abuzant
 *               - TestCase coding  and design
 *               01/07/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst testcase and modified
 *                to test GpiSetPel() and GpiQueryPel().
 * Inputs:
 *    hps              // presentation space
 *    hWndClient       // client window
 *    spiral_control   // Controls the apperance of the spiral.
 * Outputs:
 *
 * Subroutiynes Required:
 *
 *  GpiApp2(hPS,hWndClient,spiral_control,EntryName);
 *  set_delta(hPS);
 *
 * Limitations:
 *  None at this time.
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   // Call this subfunction to perform the functionality test
 *   //  for GpiSetPel() and GpiQueryPel().
 *
 *   (VOID)GpiApp2(hPS,hWndClient,spiral_control,EntryName);
 *
 * }
 *\\end
\ ***************************************************************************/
VOID APIENTRY GpiBitApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  static PCHAR EntryName="GpiBitApp2()";

  USHORT spiral_control=50;     // Set it to default since this function
                                // is called somewhere else
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {

    ENTER_MAIN(EntryName);
    if (GpiApp2(hPS,hWndClient,spiral_control,EntryName))
      EXIT_MAIN(EntryName);

  }
    return ;
}


/****************************************************************************
 *\\ddd
 * Routine Name: GpiApp2()
 *
 * Purpose:  This function tests the basic functionality of the following
 *           Gpi functions:
 *
 *           GpiSetPel()
 *           GQueryPel()
 *
 *           NOTE : This function will used by  other functions to
 *                  to draw spirals with different appearance.
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/23/1990 ,PDVT , Mike Abuzant
 *               - TestCase coding  and design
 *               01/07/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst.c testcase and modified
 *                to test GpiSetPel() and GpiQueryPel().
 *
 * Inputs:
 *    hps              // presentation space
 *    hWndClient       // client window
 *    spiral_control   // Controls the apperance of the spiral.
 *    EntryName        //Specify name of entry that called this function.
 * Outputs:
 *
 * Subroutiynes Required:
 *   None at this time.
 *
 * Limitations:
 *   Since the GpiQueryPel() does not preduce any output, it will
 *   be tested by reading the pixel color that is been set by
 *   GpiSetPel().
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   Setup condition to draw a spiral utilizing the entire
 *   current presentation space.
 *
 *    FOR (pointno=0, pointno <NUMBPOINTS...) DO
 *       Generate the X coordinate of pixel in question
 *       Generate the Y cordinate of pixel in question
 *
 *       Change current default foreground color.
 *         GpiSetColor(hPS,&newColorIndex).
 *
 *       Draw the pixel using the current foreground color.
 *         GpiSetPel(hPS...);
 *
 *       Determine if the pixel is VISIBLE
 *        GpiPtVisible(hPS,...);
 *
 *      // If the pixel at the coordinate used for GpiSetPel()
 *      // is visible ,then read the color of the pixel and
 *      // verify that it is the same color as set by GpiSetPel().
 *         GpiQueryPel(hPS,....);
 *    ENDDO.
 * }
 *\\end
\ ***************************************************************************/
INT GpiApp2(HPS hPS, HWND hWndClient, USHORT spiral_control,PCHAR  EntryPoint)
{

  POINTL ptl;                            // Screen coordinates
  INT    color_index = 0;                    // color index
  LONG   lIndex1;                         // Counter
  LONG   height;                         // height of device in pels
  LONG   width;                          // width of device in pels
  double dangle;
  double dscale;
  LONG   currentcolor;
  LONG   visible;
  LONG   ReturnColor;


  width =pg_size_x*delta_x;   //Device width in term of "our" units
  height=pg_size_y*delta_y;   //Device height in term of "our" units

  for (lIndex1=0; lIndex1<NUMBPOINTS;lIndex1++){

       dangle=(double)lIndex1*2.0*PI/(NUMBPOINTS/spiral_control);
       dscale=1.0-(double)lIndex1/(double)NUMBPOINTS;
       ptl.x=(LONG)((double)width/2.0*(1.0+dscale*cos(dangle)));
       ptl.y=(LONG)((double)height/2.0*(1.0+dscale*sin(dangle)));

       MapPt(ptl);

       //Change current foreground color.
       if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR){
           REPORTSETUPERROR("GpiSetColor()");
           ErrorCount++;
       }
       currentcolor=colors[color_index];

       if (lIndex1& 0x8){
         // Change current foreground color
           INCROMENTWITHWRAP(color_index,colors);
       }

       //Turn pixel @ this (x,y) coordinates ON.
       if (GpiSetPel(hPS,&ptl)==GPI_ERROR){
          CLEANUP("GpiSetPel()",EntryPoint);
          return FALSE;
       }
       /****************************************************************
       *This next code segment will verify that the pixel we turned ON *
       * is the correct one. This is done by querying the pixel at the *
       * same coordinates using GpiQueryPel(). But first, we must make *
       * sure that this pixel is VISIBLE,otherwise; GpiQueryPel() will *
       * fail.
       ****************************************************************/
       visible=GpiPtVisible(hPS,&ptl);

       if (visible==PVIS_ERROR){
            CLEANUP("GpiPtVisible()",EntryPoint);
            return FALSE;
       }

       else if (visible==PVIS_VISIBLE){  //Pel is visible ? get it
         if ((ReturnColor=GpiQueryPel(hPS,&ptl))==GPI_ALTERROR){
            CLEANUP("GpiQueryPel()",EntryPoint);
            return FALSE;
        }
         //The pixel color not matching the current foreground color is
         //an indication that something went wrong either with GpiSetPel()
         //or GpiQueryPel().

        else if ((ReturnColor!=currentcolor) && (ReturnColor!=CLR_NEUTRAL) ){
              CWRITELOG(L_DEBUG,0,"GpiQueryPel FAILED\n");
         }
        }
       else {  //Pel is not Visible ? forget it ....
          ;
       }

  }

  if (GpiSetColor(hPS,CLR_DEFAULT)==FALSE){
     CLEANUP("GpiSetColor()",EntryPoint);
     return FALSE;
  }

  MapAndWriteString((delta_x/3L),(3*delta_y/4),
                   "Testing GpiSetPel() and GpiQueryPel Functions.");

  return TRUE;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitApp3()
 *
 *  Purpose :This is an entry point for the PTT.EXE that causes Gpi
 *            Application tests  to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               02/01/1991 ,PDVT , Mike Abuzant
 *               - TestCase coding and design
 *
 * Inputs:
 *    hps              // presentation space
 *    hWndClient     // client window
 *    SelectionCall   // selection parameter
 *
 * Outputs:
 *
 * Subroutiynes Required:
 *     GpiApp3()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   // call the functionality  subfunction
 *     GpiApp3( hPS, hWndClient );
 *
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitApp3(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {

    (VOID)GpiApp3( hPS, hWndClient );

  }
    return ;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiApp3()
 *
 * Purpose: This function tests the basic functionality of the following
 *                    Gpi functions:
 *
 *          GpiSetBitmapId()
 *          GpiQueryBitmapHandle()
 *
 * System Requirements:
 *
 * Revision Log:
 *               02/01/1991 ,PDVT , Mike Abuzant
 *               -initial file.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *
 * Outputs:
 *
 * Subroutines Required:
 *   set_delta().
 *
 * Limitations:
 *   When using GpiSetBitmapId(), the bitmap format must be one of the
 *   bitmap format that is supported by the device. If the bitmap format
 *   is not one of the bitmap formats supported by the device,
 *   a PMERR_INV_HBITMAP is generated by the device. An automatic format
 *   conversion occures only when the bitmap is created and initialized by
 *   GpiCreateBitmap().
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    allocate memory for the bitmap information structure and
 *    the bitmap information header structure. Then,
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterisics with the bitmap to be created.
 *
 *    Setup conditions to draw a finite set of filled boxes. Each box will be
 *    filled with a different pattern. The patterns used here will be bitmaps
 *    that are created using GpiCreateBitmap() and tagged with a pattern ID.
 *    The first box's size will be as large as presentation space and then
 *    its dimensions are shortened by 1/2" from both X-direction and
 *    Y-direction until box's size reaches 1" X 1".
 *
 *    //Set back mix to OVERPAINT .
 *     GpiSetBackMix(hPS,BM_OVERPAINT)
 *
 *    FOR (index1=0; index2 < min(height,width) ;index1++) DO
 *          Create the next bitmap to use as a pattern.
 *            HBM=GpiCreateBitmap(hPS...)
 *
 *          Associate an ID Tag newly created bitmap
 *            GpiSetBitmapId(hPS,hBM,MY_BITMAP_ID).
 *
 *          Make this bitmap the default pattern to be used to fill boxs.
 *            GpiSetPatternSet(hPS,MY_BITMAP_ID).
 *
 *          Setup conditions to draw the next box which is 1/2" shorter
 *          than the previous box .
 *               GpiBox(hPS, &TheOtherCorner);
 *
 *          Set pattern to the default Pattern.
 *            GpiSetPatternSet(hPS,LCID_DEFAULT).
 *
 *          Query the bitmap that is tagged to MY_BITMAP_ID. This
 *          will serve as a test for GpiQueryBitmapHandle().
 *            hBM1=GpiQueryBitmapHandle(MY_BITMAP_ID).
 *
 *          Un-tag the ID associated with current bitmap
 *            GpiDeleteSetId(hBM,MY_BITMAP_ID).
 *
 *          Delete the current bitmap handle.
 *           GpiDeletetBitmap(hBM);
 *        ENDDO
 *
 *\\end
 ***************************************************************************/
INT GpiApp3(HPS hPS,HWND hWndClient)
{
  static MyBitMap  aBitMap[]={
                               {PAT1_HEIGHT,PAT1_WIDTH,abPat1},
                               {SHAPE_HEIGHT,SHAPE_WIDTH,abShape},
                               {PAT2_HEIGHT,PAT2_WIDTH,abPat2}
                             };
  static PCHAR EntryName="GpiBitApp3()";
  BYTE  Temp_buffer[100];
  BITMAPINFOHEADER BitMapHeader;      //bitmap info header
  PBITMAPINFO      pBitMapInfo;       //bitmap info structure
  POINTL           ptl;
  HBITMAP          hBM=(HBITMAP)NULL ;
  HBITMAP          hBM2=(HBITMAP)NULL ;
  static     SIZEL sizel={0L,0L};
  LONG  lIndex1,
        lIndex2;
  INT   ColorIndex=0,
        BitMapCount=0;

  ENTER_MAIN(EntryName);

  // Initalize the Bitmap information structure
  // first we need to  allocate memory to hold RGB array
  // since  BITMAPINFO structure is large enough to hold
  // one RGB structure.

   pBitMapInfo=(PBITMAPINFO) Temp_buffer;
   pBitMapInfo->cbFix=sizeof(BITMAPINFOHEADER); // This always =12
   pBitMapInfo->cPlanes=1;                      // one color plane
   pBitMapInfo->cBitCount=1;                    // 1-bit /pixel
   pBitMapInfo->argbColor[0].bBlue=
   pBitMapInfo->argbColor[0].bGreen=
   pBitMapInfo->argbColor[0].bRed=0;
   pBitMapInfo->argbColor[1].bBlue=
   pBitMapInfo->argbColor[1].bGreen=
   pBitMapInfo->argbColor[1].bRed=0xFF;

   BitMapHeader.cbFix=sizeof(BitMapHeader);    // This always =12
   BitMapHeader.cPlanes=                    // one color plane
   BitMapHeader.cBitCount=1;                  // 1-bit /pixel

   //Set the background mix to OVERPAINT. This is important
   //since each filled box is drawn inside the previously
   //drawn boxes.
   if (GpiSetBackMix(hPS,BM_OVERPAINT)==FALSE){
          CLEANUP("GpiSetBackMix()",EntryName);
          return FALSE ;
   }

   //Make sure that the drawn boxes are squares.
   lIndex2=(LONG)min(pg_size_x,pg_size_y);

 /*************************************************************************
   Setup conditions to draw a finite set of filled boxes. Each box will be
   filled with a different pattern. The patterns used here will be bitmaps
   that are created using GpiCreateBitmap() and tagged with a pattern ID.
   The first box's size will be as large as presentation space and then
   its dimensions are shortened by 1/2" from both X-direction and
   Y-direction until box's size reaches 1" X 1".
 *************************************************************************/

  for (lIndex1=0 ;lIndex1<lIndex2;lIndex1++){
     //Setup the dimensions for the next bitmap to be used
     //as filling pattern.
     pBitMapInfo->cx=
     BitMapHeader.cx=aBitMap[BitMapCount].width;
     pBitMapInfo->cy=
     BitMapHeader.cy=aBitMap[BitMapCount].height;

     //Create bitmap and initialize it with the data stored in the
     //buffer pointed to by 'BitMapBuffer'.
     if ((hBM=GpiCreateBitmap(hPS,(PBITMAPINFOHEADER2)&BitMapHeader,
                             CBM_INIT,aBitMap[BitMapCount].BitMapBuffer
                            ,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
          CLEANUP("GpiCreateBitmap()",EntryName);
          return FALSE ;
     }

     //Tag this bitmap with a pattern ID.
     if (GpiSetBitmapId(hPS,hBM,MY_BITMAP_ID)==FALSE){
         CLEANUP("GpiSetBitmapId()",EntryName);
         return FALSE;
     }

     //Next Box will be filled with a different bitmap pattern.
     INCROMENTWITHWRAP(BitMapCount,aBitMap);

     //Make This Tagged Pattern the defautl one.
     if (GpiSetPatternSet(hPS,MY_BITMAP_ID)==FALSE){
         CLEANUP("GpiSetPatternSet()",EntryName);
         return FALSE;
     }

     // Change default foreground color
     if (GpiSetColor(hPS,colors[ColorIndex])==GPI_ERROR){
        CLEANUP("GpiSetColor()",EntryName);
        return FALSE ;
     }
     //Incroment the color counter
     INCROMENTWITHWRAP(ColorIndex,colors);

     //Setup coordinates for box first corner.
     ptl.x=MapX(lIndex1*(delta_x/2L));
     ptl.y=MapY(lIndex1*(delta_y/2L)+(delta_y*2L/3L));
     if (GpiMove(hPS,&ptl)==GPI_ERROR){
        CLEANUP("GpiMove()",EntryName);
        return FALSE ;
     }

     //Setup coordinates for the other box corner and draw a filled box.
     ptl.x=MapX((LONG)(lIndex2*2 -lIndex1)*delta_x/2);
     ptl.y=MapY((LONG)((lIndex2*2-lIndex1)*delta_y/2)+(delta_y*2L/3L));

     if (GpiBox(hPS,DRO_OUTLINEFILL,&ptl,0L,0L)==GPI_ERROR){
         CLEANUP("GpiBox()",EntryName);
         return FALSE;
     }

     if (GpiSetPatternSet(hPS,LCID_DEFAULT)==FALSE){
         CLEANUP("GpiSetPatternSet()",EntryName);
         return FALSE;
     }

     //Query the bitmap handle tagged with this ID(MY_BITMAP_ID).
     if ((hBM2=GpiQueryBitmapHandle(hPS,MY_BITMAP_ID))==GPI_ERROR){
         CLEANUP("GpiQueryBitmapHandle()",EntryName);
         return FALSE;
     }

     //Un-tag this bitmap ID.
     if (GpiDeleteSetId(hPS,MY_BITMAP_ID)==FALSE){
         CLEANUP("GpiDeleteSetId()",EntryName);
         return FALSE;
     }

    // Delete this bitmap handle.
     if (GpiDeleteBitmap(hBM2)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return FALSE;
     }
  }

  EXIT_MAIN(EntryName);
  return TRUE;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitApp4()
 *
 *  Purpose :This is an entry point for the PTT.EXE that causes Gpi
 *            Application tests  to be run.
 *
 * System Requirements:
 *
 * Revision Log:
 *               02/04/1991 ,PDVT , Mike Abuzant
 *               - TestCase coding and design
 *
 * Inputs:
 *    hps              // presentation space
 *    hWndClient     // client window
 *    SelectionCall   // selection parameter
 *
 * Outputs:
 *
 * Subroutiynes Required:
 *     GpiApp4()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   // call the functionality  subfunction
 *     GpiApp4( hPS, hWndClient );
 *
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitApp4(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {

    (VOID)GpiApp4(hPS,hWndClient);

  }
    return ;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiApp4()
 *
 * Purpose: This function tests the basic functionality of the following
 *                    Gpi functions:
 *          GpiLoadBitmap()
 *          GpiWCBitBlt()
 *          GpiQueryBitmapParameters().
 *
 * System Requirements:
 *
 * Revision Log:
 *               02/04/1991 ,PDVT , Mike Abuzant
 *               -initial file.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *
 * Outputs:
 *
 * Subroutines Required:
 *   set_delta().
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    Setup conditions to load bitmaps by calling the Gpi function
 *    GpiLoadBitmap(). This algorithm will Load two large bitmaps
 *    that are stored in this DLL. Then the function GpiWCBitBlt()
 *    will be used to display each bitmap. Also, GpiWCBitBlt() will
 *    stretch each bitmap to fill the entire width of the presentation
 *    space and fill 1/2 the height of the presentation space.
 *
 *   FOR (index=0 ;index <NumberOfBitmapsToLoad ; index++) DO
 *        Load the next bitmap
 *          hBM=GpiLoadBitmap(hPS,...)
 *
 *        Get the bitmap parameters. These parameters will be used to
 *        determine the loaded bitmap size.
 *           GpiQueryBitmapParameters(hBM,&InfoBuffer..)
 *
 *        Setup the coordinates of the Target rectangle and
 *        Draw the bitmap on current PS using GpiWCBitBlt()
 *          GpiWCBitBlt(hPS,hBM,...,ROP_SRCCOPY)...
 *
 *        Delete the bitmap.
 *           GpiDeletetBitmap(hBM);
 *
 *   ENDFOR
 *
 *\\end
 ***************************************************************************/
INT GpiApp4(HPS hPS,HWND hWndClient)
{
    static USHORT  aBitMapId[]={FOURT_BITMAP_ID,
                               FIFTH_BITMAP_ID
                              };

    static   PCHAR EntryName="GpiApp4()";
    static   CHAR *DllName="Gpibtmp";
    HMODULE  hMOD;
    HBITMAP  hBM=(HBITMAP)NULL ;
    POINTL   aptl[4];
    LONG     lIndex;                           // long Counter
    BITMAPINFOHEADER BitMapHeader;      //bitmap info header

    ENTER_MAIN(EntryName);

    //Ask OS/2 to load resources stored in this DLL.
    if (DosLoadModule(NULL,0,DllName,&hMOD)){
       CLEANUP("DosLoadModule()",EntryName);
       CWRITELOG(L_LOTRACE,0,"GPIBTMP.DLL must be in current directory\n");
       return FALSE;
    }

   /******************************************************************
     Setup conditions to load bitmaps by calling the Gpi function
     GpiLoadBitmap(). This algorithm will Load two large bitmaps
     that are stored in this DLL. Then the function GpiWCBitBlt()
     will be used to display each bitmap. Also, GpiWCBitBlt() will
     stretch each bitmap to fill the entire width of the presentation
     space and fill 1/2 the height of the presentation space.
   ******************************************************************/

   //Setup dimensions for Source rectangle.(only lower left corner)
    aptl[2].x=
    aptl[2].y=0L;

    //Setup dimensions for Target rectangle.
    aptl[0].x=MapX(0L);
    aptl[1].x=MapX(delta_x*pg_size_x);
    aptl[0].y=MapY(0L);
    aptl[1].y=MapY((2L*delta_y/3L));

    for (lIndex=0 ;lIndex<NUMBEROFELEMENTS(aBitMapId); lIndex++){

      //Setup dimensions for the next Target rectangle
       aptl[0].y=aptl[1].y;
       aptl[1].y+=MapY((delta_y*(pg_size_y)/2))-MapY((2L*delta_y/3L));

       //Load,into memory, the next bitmap identified by the Resource ID
       //stored at address pointed to by 'abitMapId[lIndex]'

       if((hBM=GpiLoadBitmap(hPS,hMOD,aBitMapId[lIndex],0L,0L))==GPI_ERROR){
           CLEANUP("GpiLoadBitmap()",EntryName);
           return FALSE ;
       }

       //Retrieve this bitmap's parameters namely,
       // width and height.
       if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
           CLEANUP("GpiQueryBitmapParameters()",EntryName);
           return FALSE;
       }

       aptl[3].x=(LONG)BitMapHeader.cx;
       aptl[3].y=(LONG)BitMapHeader.cy;

       //Now copy bitmap to display. The bitmap will be stretched to fill
       //the entire device width and only 1/2 the device height.

       if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_SRCCOPY,BBO_IGNORE)==GPI_ERROR){
           CLEANUP("GpiWCBitBlt()",EntryName);
           return FALSE ;
       }

       //Release memory space occupied by this bitmap.
       if (GpiDeleteBitmap(hBM)==FALSE){
          CLEANUP("GpiDeleteBitmap()",EntryName);
          return FALSE ;
       }
    }

    //Release memory space occupied by resources.
    if (DosFreeModule(hMOD)){
        CLEANUP("DosFreeModule()",EntryName);
        return FALSE;
    }
    EXIT_MAIN (EntryName);

  return TRUE;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetPelExh()
 *
 * Purpose:  This function c Exhaustively Test  the following
 *           gpi functions:
 *
 *           GpiSetPel()
 *           GpiQureyPel()
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/23/1990 ,PDVT , Mike Abuzant
 *               - TestCase coding  and design
 *               01/07/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst.c testcase and modified
 *                to test GpiSetPel() and GpiQueryPel().
 * Inputs:
 *    hps              // presentation space
 *    hWndClient       // client window
 *    SelectionCall  -selection indicator.
 *
 * Outputs:
 *
 * Subroutiynes Required:
 *   None
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   // Call this subfunction to perform the exhaustive test
 *   //  for  GpiSetPel() and GpiQueryPel()  Gpi functions.
 *
 *   (VOID)GpiApp2(hPS,hWndClient,spiral_control,EntryName);
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetPelExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  static PCHAR EntryName="GpiSetPelExh()";

  USHORT spiral_control=20;     // Set it to default since this function
                                // is called somewhere else
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(EntryName);
    if (GpiApp2(hPS,hWndClient,spiral_control,EntryName))
      EXIT_MAIN(EntryName);
  }
    return ;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiBitBltExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi function  GpiBitBlt().
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               11/08/90, pdvt ,Mike Abuzant
 *                  -Test Case Design.
 *               11/08/90, pdvt ,Mike Abuzant
 *                  -Test Case Implemetation
 *               01/10/91, PDVT Mike Abuzant
 *               -Source is taken from Gretxtst.c testcase and modified
 *                to test GpiBitBlt().
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:
 *    None.
 * Subroutines Required:
 *            GpiBitBlt_test1()   // Test For functionality
 *            set_delta();
 * Limitations:
 *  None at this time.
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   // Call the functionality test routine.
 *   GpiBitBlt_test1(hPS ,  hWndClient )
 *
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiBitBltExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
   // Call the functionality test routine.
    ENTER_MAIN("GpiBitBltExh()");
    (VOID)GpiBitBlt_test1(hPS,hWndClient );
    EXIT_MAIN("GpiBitBltExh()");

  }
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiBitBlt_test1()
 *
 * Purpose:  This function will test the functionality of the
 *           function GpiBitBlt().
 *
 * System Requirements: None
 *
 * Revision Log:
 *               11/13/90, PDVT, Mike Abuzant
 *               -initial creation
 *               01/10/91, PDVT Mike Abuzant
 *               -Test Case Implemention.
 *               01/27/91, PDVT Mike Abuzant
 *               -Test Case Design.
 *
 * Inputs:
 *   hPS            // presentation space
 *   hWndClient     //client window handle
 *
 * Outputs:
 *   None.
 * Subroutines Required:
 *    None.
 * Limitations:
 *   None at this time.
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *    allocate memory for the bitmap information structure and
 *    the bitmap information header structure. Then,
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterics with the bitmap to be created.
 *
 *    open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context  ONLY
 *        HDC1=DevOpenDC(hAB,OD_MEMORY,...);
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *        hPS1=GpiCreatePS(hAB,....);
 *
 *    Obtain the current device context
 *        hDC=DevQueryDevice(hPS....);
 *
 *    Obtain the width and the height of the current device
 *        height=alDevCaps[CAPS_HEIGHT];  //alDevCaps[] is provided by PTT.
 *        width =alDevCaps[CAPS_WIDTH ];
 *
 *    Setup conditions to create a bitmap and initialize it to the
 *    image of the CAT. Also select this new bitmap into the
 *    memory device context.
 *      hBM=GpiCreateBitmap(hPS1,CBM_INIT,abCat...)
 *      GpiSetBitmap(hPS1,hBM).
 *
 *    Setup conditions to do bitmap manipulation by setting
 *    the dimensions for the Target and Source rectangles.
 *    Then use the GpiBitBlt() function with the above
 *    settings. This algorithm will draw a bitmap of a cat
 *    that will be drawn 7 times. Each time it will be
 *    enlarged by one seventh the current PS width and in X-direction
 *    and by on seventh the current PS height in Y-direction.
 *
 *    FOR (index=1 ;index<=8) DO  ..
 *
 *      Setup the coordinates of the Target rectangle
 *      Draw the bitmap on current DC using GpiBitBlt()
 *      GpiBitBlt(hPS,hPS1,...,ROP_NOTSRCCOPY)...
 *
 *      Incroment the height of bitmap by (1/7 of  PS height)
 *      Incroment the width of bitmap by (1/7  of  PS width)
 *
 *    ENDDO
 *
 *
 *    Setup conditions to create a bitmap and initialize it to the
 *    image of the CAT. Also select this new bitmap into the
 *    memory device context.
 *      hBM=GpiCreateBitmap(hPS1,CBM_INIT,abCat...)
 *      fSuccess=GpiSetBitmap(hPS1,hBM).
 *
 *    Setup Conditions to do bitmap manipulation by setting
 *    the dimensions for the Target and Source rectangles.
 *    Then use the GpiBitBlt() function with the above
 *    settings. This algorithm will draw a bitmap of the word 'HELLO"
 *    that will be drawn 7 times. Each time it will be
 *    enlarged by one seventh the current PS width and in X-direction
 *    and by on seventh the current PS height in Y-direction.
 *
 *    FOR (index=1 ;index<=8) DO  ..
 *
 *      Setup the coordinates of the Target rectangle
 *      Draw the bitmap on current PS using GpiBitBlt()
 *        GpiBitBlt(hPs,hPS1,...,ROP_NOTSRCCOPY)...
 *
 *     Incroment the height of bitmap by (1/7 of PS height)
 *     Incroment the width of bitmap  by (1/7 of PS width)
 *
 *    ENDDO
 *
 *    De-Select the bitmap form the presentation space by passing  NULL
 *    as a bitmap handle. This will serve as De-selecting.
 *      GpiSetBitmap(hPS1,NULL....);
 *
 *    Delete the bitmap.
 *       GpiDeletetBitmap(hBM);
 *
 *    Destory the presentation space.
 *       GpiDestoryPS(hPS1);
 *    Close the device context
 *        DevCloseDC(hDC1);
 *
 *\\end
 ***************************************************************************/
INT GpiBitBlt_test1(HPS hPS,HWND hWndClient)
{
   static PCHAR  EntryName="GpiBitBltExh()";
   static SIZEL  sizel={0L,0L};
   LONG lIndex1;                        // used as an index into bitmap array
   HDC   hDC;
   POINTL aptl[4];
   LONG   xPixels,
          yPixels,
          height,
          width;
   HBITMAP hBM=(HBITMAP)NULL ;          //Bitmap handle.
   HDC              hDC1;
   HPS              hPS1;
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure
   BYTE             Temp_buffer[200];
   HAB              hAB;
   LONG             Inc,
                    lOperation=ROP_SRCCOPY;
    //Get  the default device context
    if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
        CLEANUP("GpiQueryDevice()",EntryName);
        return FALSE;   //Can't proceed without it
    }

    // Obtain the width and the height of the current device
    height=alDevCaps[CAPS_HEIGHT];  // Device height in pixels.
    width =alDevCaps[CAPS_WIDTH ];  // Device width  in pixels.

    //xPixels= pixels per inch in X-direction
    xPixels=(LONG)CONVERTTOINCHES(hori_pels_per_m);

    //yPixels= pixels per inch in Y-direction
    yPixels=(LONG)CONVERTTOINCHES(vert_pels_per_m);

    //Query anchor Block. This is used when creating new Presentation Space.
    if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
        CLEANUP("WinQueryAnchorBlock()",EntryName);
        return FALSE;
    }
    /*=========================================================
     Initalize the Bitmap information structure
     first we need to  allocate memory to hold RGB array
     since  BITMAPINFO structure is large enough to hold
     one RGB structure.
    ==========================================================*/
    pBitMapInfo=(PBITMAPINFO) Temp_buffer;
    pBitMapInfo->cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    pBitMapInfo->cx=CAT_WIDTH;                   //Width
    pBitMapInfo->cy=CAT_HEIGHT;                  //height
    pBitMapInfo->cPlanes=1;                      // one color plane
    pBitMapInfo->cBitCount=1;                    // 1-bit /pixel
    pBitMapInfo->argbColor[0].bBlue=
    pBitMapInfo->argbColor[0].bGreen=
    pBitMapInfo->argbColor[0].bRed=0;
    pBitMapInfo->argbColor[1].bBlue=
    pBitMapInfo->argbColor[1].bGreen=
    pBitMapInfo->argbColor[1].bRed=0xFF;

    BitMapHeader.cbFix=sizeof(BITMAPINFOHEADER); // This always =12
    BitMapHeader.cx=CAT_WIDTH;                   //Width
    BitMapHeader.cy=CAT_HEIGHT;                  //height
    BitMapHeader.cPlanes=1;                      // one color plane
    BitMapHeader.cBitCount=1;                    // 1-bit /pixel

    /***********************************************************
    * This code segment is intended to create new Presentation *
    * Space  and associate it with memory Device Context. The  *
    * The need for a new PS and a new DC stems from the fact   *
    * that bitmaps belongs to DCs of OD_MEMORY type.           *
    ***********************************************************/
    // Open a Memory device context  to use for bitmap operations.
    if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                        (HDC)hDC))==DEV_ERROR){
       CLEANUP("DevOpenDC()",EntryName);
       return FALSE;
    }
    // Create a presentation space to associate with the
    // memory device context
    if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS |
                          GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
       CLEANUP("GpiCreatePS()",EntryName);
       return FALSE;
    }

    // Create and obtain a bitmap handle to use with GpiBitBlt();
    if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                               CBM_INIT,abCat,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
       CLEANUP("GpiCreateBitmap()",EntryName);
       return FALSE;
    }

    //Select bitmap into presentation space.
    if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
        CLEANUP("GpiSetBitmap()",EntryName);
        return FALSE;
    }

   /*************************************************************
    Setup Conditions to do bitmap manipulation by setting the
    dimensions for the Target and Source rectangles. Then use
    the Gpi GpiBitBlt() function with the above setting. This
    segment will draw a bitmap of a CAT that will be drawn seven
    times. Each time, the source rectangle is enlarged by 1/7
    the current DC width and by one 1/7 the current DC height .
    *************************************************************/

    // Source regtangle
    aptl[2].x=0L;
    aptl[2].y=0L;
    aptl[3].x=CAT_WIDTH;
    aptl[3].y=CAT_HEIGHT;

    // Target regtangle
    aptl[0].x=0L;
    aptl[0].y=(LONG)((2L*yPixels)/3L);
    aptl[1].x=CAT_WIDTH;
    aptl[1].y=aptl[0].y+aptl[3].y;

    for (lIndex1=0;lIndex1<=pg_size_x;lIndex1++){

       if (GpiBitBlt(hPS,hPS1,4L,aptl,lOperation,BBO_AND)==GPI_ERROR){
          CLEANUP("GpiBitBlt()",EntryName);
          return FALSE;
       }
       aptl[0].x=aptl[1].x;
       aptl[1].x+=xPixels;      //Enlarge the target rectangle in X-dircetion
                                // by 1"
       aptl[1].y+=(yPixels/2L); //Enlarge the target rectangle in Y-direction
                                //by  1/2" .
    }

    /*************************************************************
     Setup Conditions to do bitmap manipulation by setting the
     dimensions for the Target and Source rectangles. Then use
     the Gpi GpiBitBlt() function with the above setting. This
     segment will draw a bitmap of the word 'HELLO' that is drawn
     seven times. Each time, the source rectangle is shrunk by 1/7
     the current DC width and by one 1/7 the current DC height .
     *************************************************************/

    pBitMapInfo->cx=HELLO_WIDTH;
    pBitMapInfo->cy=HELLO_HEIGHT;

    //Initialize bitmap with word's 'HELLO' image data.
    if (GpiSetBitmapBits(hPS1,0L,(LONG)HELLO_HEIGHT,abHello,
                         (PBITMAPINFO2)pBitMapInfo)==GPI_ALTERROR){
       CLEANUP("GpiSetBitmapBits()",EntryName);
       return FALSE;
    }

    // Source regtangle
    aptl[2].x=0L;
    aptl[2].y=0L;
    aptl[3].x=HELLO_WIDTH;
    aptl[3].y=HELLO_HEIGHT;

    // Target regtangle
    aptl[0].x=0L;
    aptl[1].y=yPixels*(pg_size_y)-(LONG)(yPixels/2.0);
    aptl[1].x=xPixels;
    aptl[0].y=(3L*yPixels);


    Inc=(LONG)(((double)(aptl[1].y-aptl[0].y))/(double)pg_size_x);

    for (lIndex1=0;lIndex1<=pg_size_x ;lIndex1++){

       if (GpiBitBlt(hPS,hPS1,4L,aptl,lOperation,BBO_AND)==GPI_ERROR){
           CLEANUP("GpiBitBlt()",EntryName);
           return FALSE;
        }
        aptl[0].x=aptl[1].x;
        aptl[1].x+=(xPixels+10);
        aptl[0].y+=Inc;

        if ((aptl[0].y+HELLO_HEIGHT) >aptl[1].y){
            aptl[0].y= aptl[1].y-HELLO_HEIGHT+(aptl[1].y-
                       (aptl[0].y+HELLO_HEIGHT));
        }
    }
    /*=================================================================
      The purpose of next code segment is do some house cleaning
      before exiting this routine. the following is done:
      1. De-select any bitmaps that are selected into memory Device
         Contexts or/and Un-tag any bitmaps that are used as pattern.
      2. Delete any bitmaps created within this function.
      3. Delete any Presentation Spaces created within this function.
      4. Delate any Device Contexts created within this function.

         Note that these steps must be followed as presented above,
         otherwise; most GPIs used here will fail.
    ===================================================================*/

    // De-select the bitmap handle. otherwise we get error when closing
    // device context
    if (GpiSetBitmap(hPS1,NULL)==HBM_ERROR){
        CLEANUP("GpiSetBitmap()",EntryName);
        return FALSE;
    }

    //Release memory space occupied by this bitmap.
    if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return FALSE;
    }

    //Dispose of presentation space. No longer needed.
    if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()", EntryName);
         return FALSE;
    }

    //Close this memory  Device Context
    if (DevCloseDC(hDC1)==DEV_ERROR){
      CLEANUP("DevCloseDC()",EntryName);
      return FALSE;
    }

    return TRUE;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetBitmapBitsExh()
 *
 * Purpose:  This function will test the functionality of the following
 *           Gpi functions
 *           GpiSetBitmapBits().
 *           GpiQueryBitmapBits().
 *           GpiCreateBitmap().
 *           GpiSetBitmap().
 *           GpiDeleteBitmap().
 *
 * System Requirements:
 *
 * Revision Log:
 *               11/06/90, pdvt ,Mike Abuzant
 *                  -Test Case Design.
 *               01/23/91, pdvt ,Mike Abuzant
 *                  -Test Case Implementation and Design.
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *        SelectionCall   -selection indicator.
 *
 * Outputs:
 *   None.
 * Subroutines Required:
 *   GpiSetBitmap_test1()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *  // Call the functionality test routine
 *     GpiSetBitmap_test1(hPS , hWndClient)
 * }
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiSetBitmapBitsExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    GpiSetBitmap_test1(hPS ,hWndClient);
  }
}

/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetBitmap_test1()
 *
 * Purpose:  This function will test the functionality of the following
 *           Gpi functions
 *           GpiSetBitmapBits().
 *           GpiQueryBitmapBits().
 *           GpiCreateBitmap().
 *           GpiSetBitmap().
 *           GpiDeleteBitmap().
 *
 * System Requirements: None
 *
 * Revision Log: 11/13/90, PDVT, Mike Abuzant
 *               -initial creation
 *               01/23/91, pdvt ,Mike Abuzant
 *                  -Test Case Implementation and Design.
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *
 * Outputs:
 *    None
 * Subroutines Required:
 *      set)delta().
 * Limitations:
 *
 *    To use Bitmap handles with GpiBitBlt(), each number of bits in each row must
 *   be a multiple of 32 bits,otherwise; the bitmap will not
 *   be drawn correctly.
 *   If the bitmap width is not a multiple of 32 bits, the row must be
 *   padded at the right
 *
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *
 *    allocate memory for the bitmap information structure and
 *    the bitmap information header structure. Then,
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterisics with the bitmap to be created.
 *
 *    open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context  ONLY
 *        HDC1=DevOpenDC(hAB,OD_MEMORY,...);
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *        hPS1=GpiCreatePS(hAB,....);
 *
 *    Obtain the current device context
 *        hDC=DevQueryDevice(hPS....);
 *
 *    Obtain the width and the height of the current device
 *        height=alDevCaps[CAPS_HEIGHT];  //alDevCaps[] is provided by PTT.
 *        width =alDevCaps[CAPS_WIDTH ];
 *
 *    FOR (all the bitmaps to Display) DO
 *       Setup conditions to fill a third of the display height
 *       with the next bitmap. First Create an empty Bitmap.
 *          HBM=GpiCreateBitmap(hPS1...)
 *       FOR (index=0 ;index<1/3 Deviceheight ;..... ) DO
 *
 *         FOR (index2=0 ;index2<Devicewidth ;..... ) DO
 *
 *            Initialize The emtpy Bitmap with the bits for the
 *            next bitmap to display.
 *              GpiSetBitmapBits(hPS1,DataBuffer,BitMapHeight...)
 *
 *             Display the bitmap.
 *               GpiBitBlt(hPS,hPS1,ROP_SRCCOPY...);
 *
 *              Verify that the content of bitmap is of the
 *              image of the current bitmap .
 *                GpiQueryBitmapbits(hPS1,abImage....);
 *        ENDDO
 *       ENDDO
 *
 *      De-Select the current bitmap form the device context passing
 *      NULL as a bitmap handle.This will serve as De-selecting.
 *         GpiSetBitmap(hPS1,NULL);
 *
 *      Delete the current bitmap handle.
 *          GpiDeletetBitmap(hBM);
 *    ENDDO
 *
 *   Destory the presentation space.
 *     GpiDestoryPS(hPS1);
 *
 *   Close the device context
 *    DevCloseDC(hDC1);
 *
 *   return to PTT.EXE
 *
 *\\end
 ***************************************************************************/
INT GpiSetBitmap_test1(HPS hPS,HWND hWndClient)
{

   static MyBitMap  aBitMap[]={
                               {CROSS_HEIGHT,CROSS_WIDTH,abCross},
                               {SHAPE_HEIGHT,SHAPE_WIDTH,abShape},
                               {CAT_HEIGHT,CAT_WIDTH,abCat}
                              };

   static PCHAR EntryName="GpiSetBitmapBitsExh()";
   BYTE  abImage[IMAGESIZE];            // used to store bitmap image
   static SIZEL sizel={0L,0L};          // size of bitmap to draw
   HDC   hDC=(HDC)NULL ;
   HAB   hAB=(HAB)NULL;
   HBITMAP hBM=(HBITMAP)NULL ;
   HDC   hDC1=(HDC)NULL;
   HPS   hPS1=(HPS)NULL;
   BYTE  Temp_buffer[100];
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure

   POINTL  aptl[4];
   INT color_index=0;                      // color index
   LONG lIndex1,                           // long Counter
        lIndex2,                           // long Counter
        lIndex3,                           // long Counter
        lIndex4,                           // long Counter
        width,
        height,
        TempVar;

   ENTER_MAIN(EntryName);

    //Get  the default device context
    if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
        CLEANUP("GpiQueryDevice()",EntryName);
        return FALSE;   //Can't proceed without it
    }

    // Obtain the width and the height of the current device
    height=alDevCaps[CAPS_HEIGHT];  // Device height in pixels.
    width =alDevCaps[CAPS_WIDTH ];  // Device width  in pixels.

    //Query anchor Block. This is used when creating new Presentation Space.
    if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
        CLEANUP("WinQueryAnchorBlock()",EntryName);
        return FALSE;
    }

    /*=========================================================
     Initalize the Bitmap information structure
     first we need to  allocate memory to hold RGB array
     since  BITMAPINFO structure is large enough to hold
     one RGB structure.
    ==========================================================*/

    pBitMapInfo=(PBITMAPINFO)Temp_buffer;
    pBitMapInfo->cbFix=sizeof(BitMapHeader);   // This always =12
    pBitMapInfo->cPlanes=                      // one color plane
    pBitMapInfo->cBitCount=1;                  // 1-bit /pixel
    pBitMapInfo->argbColor[0].bBlue=
    pBitMapInfo->argbColor[0].bGreen=
    pBitMapInfo->argbColor[0].bRed=0;
    pBitMapInfo->argbColor[1].bBlue=
    pBitMapInfo->argbColor[1].bGreen=
    pBitMapInfo->argbColor[1].bRed=0xFF;

    BitMapHeader.cbFix=sizeof(BitMapHeader);    // This always =12
    BitMapHeader.cPlanes=                      // one color plane
    BitMapHeader.cBitCount=1;                  // 1-bit /pixel

    /***********************************************************
    * This code segment is intended to create new Presentation *
    * Space  and associate it with memory Device Context. The  *
    * The need for a new PS and a new DC stems from the fact   *
    * that bitmaps belongs to DCs of OD_MEMORY type.           *
    ***********************************************************/
    // Open a Memory device context  to use for bitmap operations.
    if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                        (HDC)hDC))==DEV_ERROR){
       CLEANUP("DevOpenDC()",EntryName);
       return FALSE;
    }
    // Create a presentation space to associate with the
    // memory device context
    if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS |
                          GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
       CLEANUP("GpiCreatePS()",EntryName);
       return FALSE;
    }

    lIndex1=50;           //Avoid the test sigenture printed at bottom
                          //of display.

    for (lIndex4=0 ;lIndex4<NUMBEROFELEMENTS(aBitMap); lIndex4++){

      //Initialize dimensions of the source rectangle.
       aptl[2].x=
       aptl[2].y=0L;
       aptl[3].x=aBitMap[lIndex4].width;
       aptl[3].y=aBitMap[lIndex4].height;

       pBitMapInfo->cx=
       BitMapHeader.cx=aBitMap[lIndex4].width;
       pBitMapInfo->cy=
       BitMapHeader.cy=aBitMap[lIndex4].height;

       //Setup conditions to fill a third of the display height
       //with the next bitmap. First Create an empty Bitmap.
       if ((hBM=GpiCreateBitmap(hPS1,(PBITMAPINFOHEADER2)&BitMapHeader,
                               0L,NULL,NULL))==GPI_ERROR){
           CLEANUP("GpiCreateBitmap()",EntryName);
           return FALSE;
       }

       //Select this bitmap handle into the memory Device Context.
       if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
           CLEANUP("GpiSetBitmap()",EntryName);
           return FALSE;
       }

       TempVar=lIndex1;
       for (lIndex3=0 ;lIndex3<5 ; lIndex3++){
          for (lIndex1=TempVar; lIndex1<((lIndex4+1)*height/3) ;
                        lIndex1+=aBitMap[lIndex4].height){

            // Change current foreground color
            if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR){
                CLEANUP("GpiSetColor()",EntryName);
                return FALSE;
            }
            INCROMENTWITHWRAP(color_index,colors);

            // This next loop will fill the entire width of the display
            // with the current bitmap.
            for (lIndex2=10; lIndex2<(width);lIndex2+=aBitMap[lIndex4].width){

              //Setup the dimensions of the target rectangle. Note that
              //displayed bitmaps are not stretched or compressed.
              aptl[0].x=lIndex2;
              aptl[0].y=lIndex1;
              aptl[1].x=lIndex2+aBitMap[lIndex4].width;
              aptl[1].y=lIndex1+aBitMap[lIndex4].height;

              //Initialize bitmap with data stored at the address
              //pointed to by 'aBitMap[lIndex4].BitMapBuffer'.
              if (GpiSetBitmapBits(hPS1,0L,(LONG)aBitMap[lIndex4].height,
                                   aBitMap[lIndex4].BitMapBuffer,
                                   (PBITMAPINFO2)pBitMapInfo)==GPI_ALTERROR){
                  CLEANUP("GpiSetBitmapBits()",EntryName);
                  return FALSE;
              }

              //Copy this bitmap to the display.
              if (GpiBitBlt(hPS,hPS1,3L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR){
                 CLEANUP("GpiBitBlt()",EntryName);
                 return FALSE;
              }

              //Make sure that this bitmap has been initialized properely !.
              if (GpiQueryBitmapBits(hPS1,0L,(LONG)aBitMap[lIndex4].height,abImage,
                               (PBITMAPINFO2)pBitMapInfo)==GPI_ALTERROR){
                 CLEANUP("GpiQueryBitmapBits()",EntryName);
                 return FALSE;
              }
            }
          }
       }
       lIndex1+=10L;

    /*=================================================================
      The purpose of next code segment is do some house cleaning
      before exiting this routine. the following is done:
      1. De-select any bitmaps that are selected into memory Device
         Contexts or/and Un-tag any bitmaps that are used as pattern.
      2. Delete any bitmaps created within this function.
      3. Delete any Presentation Spaces created within this function.
      4. Delate any Device Contexts created within this function.

         Note that these steps must be followed as presented above,
         otherwise; most GPIs used here will fail.
    ===================================================================*/
       // De-select the bitmap handle. otherwise we get error when closing
       // device context
       if (GpiSetBitmap(hPS1,NULL)==FALSE){
          CLEANUP("GpiSetBitmap()",EntryName);
          return FALSE;
       }
       if (GpiDeleteBitmap(hBM)==FALSE){
          CLEANUP("GpiDeleteBitmap()",EntryName);
          return FALSE;
       }
    }

    // dispose of presentation space. No longer needed.
    if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()",EntryName);
         return FALSE;
    }

    //Close the device context
    if (DevCloseDC(hDC1)==DEV_ERROR){
      CLEANUP("DevCloseDC()",EntryName);
      return FALSE;
    }
    EXIT_MAIN (EntryName);

  return TRUE;
}
/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetBitmapBitsIdExh()
 *
 * Purpose:  This function will test the functionality of the following
 *           Gpi functions
 *           GpiSetBitmapId().
 *           GpiQueryBitmapHandle().
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/25/90, pdvt ,Mike Abuzant
 *                  -Initial file creation
 *                  -Test Case Implementation and Design.
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *        SelectionCall   -selection indicator.
 *
 * Outputs:
 *     None.
 * Subroutines Required:
 *     set_delta()
 *
 * Limitations:
 *   1. The bitmap that is used as a pattern should be 8 X 8 pels, otherwise;
 *   if it is larger than 8 X 8 pels , the first 8 pels will be used as
 *   the pattern.
 *
 *   2. If a bitmap format is not one of the formats supported by the device,
 *      the call GpiSetBitmapId() fails since this bitmap will not be
 *      converted to a bitmap format supported by the device. The only way
 *      to convert a bitmap format to a format supported by the device is
 *      to create the bitmap using GpiCreateBitmap() with the option
 *      CBM_INIT.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    allocate memory for the bitmap information structure and
 *    the bitmap information header structure. Then,
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterisics with the bitmap to be created.
 *
 *    FOR (index1=0; index2 < (display height ;index1+=delta_y) DO
 *      FOR (index2=0; index2 < (display width; index2+=delta_x) DO
 *          Create the next bitmap to use as a pattern .
 *            HBM=GpiCreateBitmap(hPS...)
 *
 *          Associate an ID Tag newly created bitmap
 *            GpiSetBitmapId(hPS,hBM,MY_BITMAP_ID).
 *
 *          Make this bitmap the default pattern to be used
 *          to fill boxs.
 *            GpiSetPatternSet(hPS,MY_BITMAP_ID).
 *
 *          Setup conditions to draw  1" X 1" boxes.these boxes
 *          be filled with current bitmap.
 *
 *          Set pattern to the default Pattern.
 *            GpiSetPatternSet(hPS,LCID_DEFAULT).
 *
 *          Query the bitmap that is tagged to MY_BITMAP_ID. This
 *          will serve as a test for GpiQueryBitmapHandle().
 *            hBM1=GpiQueryBitmapHandle(MY_BITMAP_ID).
 *
 *          Un-tag the ID associated with current bitmap
 *            GpiDeleteSetId(hBM,MY_BITMAP_ID).
 *
 *          De-Select the current bitmap form the device context passing
 *          NULL as a bitmap handle.This will serve as De-selecting.
 *           GpiSetBitmap(hPS,NULL);
 *
 *          Delete the current bitmap handle.
 *           GpiDeletetBitmap(hBM);
 *        ENDDO
 *       ENDDO
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetBitmapIdExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

   static MyBitMap  aBitMap[]={
                               {PAT1_HEIGHT,PAT1_WIDTH,abPat1},
                               {SHAPE_HEIGHT,SHAPE_WIDTH,abShape},
                               {PAT2_HEIGHT,PAT2_WIDTH,abPat2}
                              };
  static PCHAR EntryName="GpiSetBitmapIdExh()";
  BYTE  Temp_buffer[100];
  BITMAPINFOHEADER BitMapHeader;      //bitmap info header
  PBITMAPINFO      pBitMapInfo;       //bitmap info structure

  POINTL   ptl;
  HBITMAP hBM=(HBITMAP)NULL ;
  HBITMAP hBM1=(HBITMAP)NULL ;
  LONG  lIndex1,
        lIndex2;
  INT   ColorIndex=0,
        LastBitMap=0,
        BitMapCount=0;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     ENTER_MAIN(EntryName);

    /*=========================================================
     Initalize the Bitmap information structure
     first we need to  allocate memory to hold RGB array
     since  BITMAPINFO structure is large enough to hold
     one RGB structure.
    ==========================================================*/
      pBitMapInfo=(PBITMAPINFO)Temp_buffer;
      pBitMapInfo->cbFix=sizeof(BitMapHeader);   // This always =12
      pBitMapInfo->cPlanes=                      // one color plane
      pBitMapInfo->cBitCount=1;                  // 1-bit /pixel
      pBitMapInfo->argbColor[0].bBlue=
      pBitMapInfo->argbColor[0].bGreen=
      pBitMapInfo->argbColor[0].bRed=0;
      pBitMapInfo->argbColor[1].bBlue=
      pBitMapInfo->argbColor[1].bGreen=
      pBitMapInfo->argbColor[1].bRed=0xFF;

      BitMapHeader.cbFix=sizeof(BitMapHeader);    // This always =12
      BitMapHeader.cPlanes=                      // one color plane
      BitMapHeader.cBitCount=1;                  // 1-bit /pixel


     lIndex1=(LONG)(delta_y*2L/3L); //Avoid the test sigenture printed
                                    //at bottom of display.

     /*=========================================================
      This next code segment is used to fill the entire display
      surface with rows of 1" X 1" filled boxes. the patterns
      used to fill these boxes are actually bitmaps that are
      tagged to pattern IDs. The following step are taken in
      order to use bitmaps as patterns:

      1.Create the bitmap and initialize it with the desired
        data. Use GpiCreatBitmap().
      2.Tag the bitmap with a pattern ID. Use GpiSetBitmapId().
      3.Activate the tagged pattern ID,i.e bitmap becomes the
        default filling pattern. Use GpiSetPatternSet().
     ==========================================================*/

     for (;lIndex1<=(pg_size_y*delta_y); lIndex1+=delta_y){
        BitMapCount=LastBitMap;
        for (lIndex2=0 ;lIndex2<(pg_size_x*delta_x); lIndex2+=delta_x){

            pBitMapInfo->cx=
            BitMapHeader.cx=aBitMap[BitMapCount].width;
            pBitMapInfo->cy=
            BitMapHeader.cy=aBitMap[BitMapCount].height;

            //Create the next bitmap to be used as pattern.
            if ((hBM=GpiCreateBitmap(hPS,(PBITMAPINFOHEADER2)&BitMapHeader,
                                   CBM_INIT,aBitMap[BitMapCount].BitMapBuffer
                                  ,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
                 CLEANUP("GpiCreateBitmap()",EntryName);
                 return ;
            }

            //Tag this bitmap with a pattern ID.
            if (GpiSetBitmapId(hPS,hBM,MY_BITMAP_ID)==FALSE){
                CLEANUP("GpiSetBitmapId()",EntryName);
                return;
            }
            //Next box is filled with different pattern.
            INCROMENTWITHWRAP(BitMapCount,aBitMap);

            //Activate the bitmap as the default filling pattern.
            if (GpiSetPatternSet(hPS,MY_BITMAP_ID)==FALSE){
                CLEANUP("GpiSetPatternSet()",EntryName);
                return;
            }

            // Set foreground color to a different color than default_color
            if (GpiSetColor(hPS,colors[ColorIndex])==GPI_ERROR){
               CLEANUP("GpiSetColor()",EntryName);
               return ;
            }
            INCROMENTWITHWRAP(ColorIndex,colors);

            //
            // Draw a filled box.
            //
            ptl.x=MapX(lIndex2);
            ptl.y=MapY(lIndex1);
            if (GpiMove(hPS,&ptl)==GPI_ERROR){
               CLEANUP("GpiMove()",EntryName);
               return ;
            }

            ptl.x=MapX(lIndex2+delta_x-5);
            ptl.y=MapY(lIndex1+delta_y-5);
            if (GpiBox(hPS,DRO_OUTLINEFILL,&ptl,0L,0L)==GPI_ERROR){
                 CLEANUP("GpiBox()",EntryName);
                 return ;
            }

            //Prepare to delete the tagged bitmap.
            if (GpiSetPatternSet(hPS,LCID_DEFAULT)==FALSE){
                CLEANUP("GpiSetPatternSet()",EntryName);
                return;
            }

            //Make sure that the pattern ID is tagged with the correct
            //bitmap. This will serve as a test for GpiQueryBitmapHandle().
            if ((hBM1=GpiQueryBitmapHandle(hPS,MY_BITMAP_ID))==GPI_ERROR){
                CLEANUP("GpiQueryBitmapHandle()",EntryName);
                return;
            }
            if (hBM1 != hBM ){
                 CWRITELOG(L_HDR,0,"GpiQueryBitmapHandle() Failed\n");
            }

            //Un-tag the bitmap
            if (GpiDeleteSetId(hPS,MY_BITMAP_ID)==FALSE){
                CLEANUP("GpiDeleteSetId()",EntryName);
                return;
            }

            //Releas the memory space occupied by this bitmap
            if (GpiDeleteBitmap(hBM1)==FALSE){
                CLEANUP("GpiDeleteBitmap()",EntryName);
                return;
            }
        }
        INCROMENTWITHWRAP(ColorIndex,colors);
        INCROMENTWITHWRAP(LastBitMap,aBitMap);
     }
     EXIT_MAIN(EntryName);
  }
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiWCBitBltExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi function  GpiWCBitBlt().
 *
 * System Requirements:
 *
 * Revision Log:
 *               10/24/90, pdvt, mark richardson
 *               - initial file
 *               11/08/90, pdvt ,Mike Abuzant
 *                  -Test Case Design.
 *               01/27/91, PDVT ,Mike Abuzant
 *                  -Test Case Implementation and design.
 *                                        07/14/91, FVT, Hengli Jia
 *                  _Test Case Redesign.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:
 *       None.
 * Subroutines Required:
 *    set_delta();
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/****************************************************************************
 *As of July 20th of 1991, the GpiWcBitBltExh testcase of the GpiBitMap group
 *has been changed.  A new .dll file has been compiled.
 *The old testcase had unnecessory complexities that generated different outputs
 *for different printer drivers.
 *The algorithm of the old version loops a particular bitmap for five times.
 *Each time it's looping, five or more different size bitmaps are displayed to a
 *presentation space.  So a total of more than twentyfive bitmaps is displayed.
 *The problem with this algorithm is that very time it loops, the bitmaps are
 *placed on top of each other to a same presentation space.  As a result, all the
 *printer drivers are totally confused of which bitmap they are suppose to print.
 *
 *The new version solves this problem by transferring and resizing the source
 *bitmap to target bitmaps in a same presentation space.  This archieves the
 *goal of testing GpiWcBitBlt GPI call exhaustively, yet produce neet outputs.
 *
 *
 *
 *
 *                                                                                                                       Hengli Jia
 *                                                                                                                       7/16/91
 ***************************************************************************
 *\\algorithm
 *
 *    allocate memory for the bitmap information structure and
 *    the bitmap information header structure. Then,
 *    initialize bitmap information header structure and bitmap information
 *    structure to the size and characterisics with the bitmap to be created.
 *
 *
 *    Setup conditions to create a bitmap and initialize it to the
 *    image of a particular shape. The size of this bitmap is
 *    16 X 16 Pixels.
 *      hBM=GpiCreateBitmap(hPS1,CBM_INIT,abShape...)
 *
 *      The old algorithm:
 *    Setup conditions to do some bitmap manipulation by using
 *    the Gpi GpiWCBitBlt(). This algorithm will draw a bitmap of a
 *    particular shape that is at first will be as large as persentation
 *    space and then decroment its size by 2" from both X-direction and
 *    and  Y-direction until it reaches 1" X 1" in size. This algorithm
 *    will be repeated for at least five times.
 *
 * The new algorithm:
 *              This algorithm will draw a bitmap of a particular shape.  The size of
 *    the bitmap will be increased by 1/2" in X_direction and 1/4" in Y_direction
 *              until one half of the page_size_x is covered, then the size of the bitmap
 *              is decreamented by the same dimension for the second half of page_size_y.
 *    This loop will be repeated twice, so that the two groups of the bitmaps
 *    are mirror image of each other.
 *
 *
 *   FOR (i=0 ;i<2 ; i++) DO
 *        Setup the coordinates of the Target rectangle
 *     for (lIndex1=0; lIndex1 <= (pg_size_x/2); lIndex1++)
 *        Draw the bitmap on current DC using GpiWCBitBlt()
 *          GpiWCBitBlt(hPS,hBM,...,ROP_SRCCOPY)...
 *
 *        incroment the height of bitmap by 1/4"
 *        Incroment the width of bitmap by  1/2"
 *
 *        Change the current foreground color.
 *          GpiSetcolor(hPS,NewColor);
 *
 *     while (lIndex1 >=0)      DO
 *        Draw the bitmap on current DC using GpiWCBitBlt()
 *          GpiWCBitBlt(hPS,hBM,...,ROP_SRCCOPY)...
 *
 *        decroment the height of bitmap by 1/4"
 *        incroment the width of bitmap by  1/2"
 *
 *        Change the current foreground color.
 *          GpiSetcolor(hPS,NewColor);
 *
 *      ENDWHILE
 *
 *   ENDFOR
 *
 *   De-Select the bitmap form the presentation space by passing  NULL
 *   as a bitmap handle. This will serve as De-selecting.
 *     GpiSetBitmap(hPS1,NULL....);
 *
 *   Delete the bitmap.
 *      GpiDeletetBitmap(hBM);
 *
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiWCBitBltExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   static PCHAR EntryName="GpiWCBitBltExh()";
   HBITMAP hBM=(HBITMAP)NULL ;
   BYTE  Temp_buffer[100];
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   PBITMAPINFO      pBitMapInfo;       //bitmap info structure
   POINTL  aptl[4];
   INT color_index;                      // color index
   LONG i,lIndex1;                           // long Counter

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
      ENTER_MAIN(EntryName);



    /*=========================================================
     Initalize the Bitmap information structure
     first we need to  allocate memory to hold RGB array
     since  BITMAPINFO structure is large enough to hold
     one RGB structure.
    ==========================================================*/
      pBitMapInfo=(PBITMAPINFO)Temp_buffer;
      pBitMapInfo->cbFix=sizeof(BitMapHeader);   // This always =12
      pBitMapInfo->cx=SHAPE_WIDTH;
      pBitMapInfo->cy=SHAPE_HEIGHT;
      pBitMapInfo->cPlanes=                      // one color plane
      pBitMapInfo->cBitCount=1;                  // 1-bit /pixel
      pBitMapInfo->argbColor[0].bBlue=
      pBitMapInfo->argbColor[0].bGreen=
      pBitMapInfo->argbColor[0].bRed=0;
      pBitMapInfo->argbColor[1].bBlue=
      pBitMapInfo->argbColor[1].bGreen=
      pBitMapInfo->argbColor[1].bRed=0xFF;

      BitMapHeader.cbFix=sizeof(BitMapHeader);    // This always =12
      BitMapHeader.cPlanes=                      // one color plane
      BitMapHeader.cBitCount=1;                  // 1-bit /pixel
      BitMapHeader.cx=SHAPE_WIDTH;
      BitMapHeader.cy=SHAPE_HEIGHT;

      //Create a bitmap and initialize it with data
      //for bitmap to display.
      if ((hBM=GpiCreateBitmap(hPS,(PBITMAPINFOHEADER2)&BitMapHeader,
                              CBM_INIT,abShape,(PBITMAPINFO2)pBitMapInfo))==GPI_ERROR){
          CLEANUP("GpiCreateBitmap()",EntryName);
          return ;
      }

     /*=================================================================
                This algorithm will draw a bitmap of a particular shape.  The size of
      the bitmap will be increased by 1/2" in X_direction and 1/4" in Y_direction
                until one half of the page_size_x is covered, then the size of the bitmap
                is decreamented by the same dimension for the second half of page_size_y.
      This loop will be repeated twice, so that the two groups of the bitmaps
      are mirror image of each other.
     ==================================================================*/
      //Source rectangle
      aptl[2].x=0;
      aptl[2].y=0;
      aptl[3].x=SHAPE_WIDTH;
      aptl[3].y=SHAPE_HEIGHT;

        for (i=0; i<2; i++)                     //have two groups of bitmaps
        {
                color_index=0;

        //Target rectangle
         aptl[0].x=(LONG)(1L*delta_x);
         aptl[0].y=(LONG)(5L*delta_y-i*delta_y);
         aptl[1].x=(LONG)(3L*delta_x/2L);
         aptl[1].y=(LONG)(11L*delta_y/2L-i*delta_y);
         MapPt(aptl[0]);
         MapPt(aptl[1]);

      for (lIndex1=0; lIndex1 <= (pg_size_x/2); lIndex1++)
                {

           // Change current foreground color
           if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR)
                          {
               CLEANUP("GpiSetColor()",EntryName);
               return ;
           }
           INCROMENTWITHWRAP(color_index,colors);

           if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR)
                          {
               SHOWERROR("GpiWCBitBlt()",EntryName);
           }

           aptl[0].x=aptl[1].x;
           aptl[1].x+=MapX(1L*delta_x/2L);
                          if (i==0)             //first group bitmaps, size is incromented upward
                          {
           aptl[1].y+=MapY(1L*delta_y/4L);
                          }
                          else                  //second group bitmaps, size is incromented downward
                          {
                          aptl[0].y-=MapY(1L*delta_y/4L);
                          }
       }


      while (lIndex1 >=0)
                 {
           // Change current foreground color
           if (GpiSetColor(hPS,colors[color_index])==GPI_ERROR)
                          {
               CLEANUP("GpiSetColor()",EntryName);
               return ;
           }
                                 --color_index; //decrease the color_index to have symetric
                                                                                //colors on both side.
           if (GpiWCBitBlt(hPS,hBM,4L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR)
                          {
               SHOWERROR("GpiWCBitBlt()",EntryName);
               return ;
           }

           aptl[0].x=aptl[1].x;
           aptl[1].x+=MapX(1L*delta_x/2L);
                          if (i==0)                     //first group bitmaps, size is decromented downward
                          {
           aptl[1].y-=MapY(1L*delta_y/4L);
                          }
                          else                    //second group bitmaps, size is decromented upward
                          {
                          aptl[0].y+=MapY(1L*delta_y/4L);
                          }
                 --lIndex1;
            }

         }


      //Release memory space occupied by this bitmap.
      if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return ;
   }

       EXIT_MAIN (EntryName);
 }
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetBitmapDimensionExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi functions,
 *            GpiSetBitmapDimension()
 *            GpiQueryBitmapDimension()
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/23/91, PDVT ,Mike Abuzant
 *               - initial file
 *               01/27/91, PDVT ,Mike Abuzant
 *                  -Test Case Implementation and design.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:
 *       None.
 * Subroutines Required:
 *     set_delta();
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Obtain a bitmap handle to one of the system bitmap.
 *      hBM=WinGetSysBitmap(HWND_DESKTOP,SBMP_SYSMENU)
 *
 *   Initialize  Bitmap dimensions.
 *      sizel.cx=10;
 *      sizel.cy=10;
 *
 *   WHILE ( Top of display is not reached ) DO
 *
 *      Set the bitmap dimensions .
 *        GpiSetBitmapDimension(hBM,&sizel...)
 *
 *      Print a message informing the user that the bitmap's dimensions
 *      have been set to some values .
 *       GpiCharStringAt(hPS,Message,...);
 *
 *      Advance to next line position .
 *        ptl.y+=syPosition
 *
 *      Query the bitmap dimensions .
 *        GpiQueryBitmapDimension(hBM,&sizel1...)
 *
 *      Print a message informing the user that the bitmap's dimensions
 *      have been queried using the function GpiQueryBitmapDimension().
 *        GpiCharStringAt(hPS,Message,...);
 *
 *      Advance to next line position.
 *        ptl.y+=(3*syPosition/2);
 *
 *      Incroment the bitmap dimensions.
 *        sizel.cx+=20;
 *        sizel.cx+=10;
 *
 *   ENDWHILE
 *
 *   Delete the bitmap.
 *      GpiDeletetBitmap(hBM);
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetBitmapDimensionExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
   static PCHAR EntryName="GpiSetBitmapDimensionExh()";
   POINTL  ptl;
   CHAR   Message[120];
   HBITMAP hBM=(HBITMAP)NULL ;
   SIZEL sizel;
   SIZEL sizel1;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
      ENTER_MAIN(EntryName);

      //Obtain  a handle of on of the system bitmaps.
      if ((hBM=WinGetSysBitmap(HWND_DESKTOP,SBMP_SYSMENU))==NULL){
          CLEANUP("WinGetSysBitmap()",EntryName);
          return;
      }
      ptl.x=MapX(delta_x/5);
      ptl.y=MapY(delta_y);

      //Set the initial bitmap dimensions in mm.
      sizel.cx=20;
      sizel.cy=10;

      while ( (LONG)UnMapY(ptl.y) < (LONG)(delta_y*pg_size_y)) {

        //Set the bitmap dimensions.
        if (GpiSetBitmapDimension(hBM,&sizel)==FALSE){
            CLEANUP("GpiSetBitmapDimension",EntryName);
            return;
        }

        sprintf(Message,"Setting Bitmap Dimensions to (%03ld mm, %03ld mm) Using GpiSetBitmapDimension()",
                            sizel.cx,sizel.cy);
        WorldWriteString(ptl.x,ptl.y,Message);

        ptl.y += syPosition; //Advance to next line position.

        //Query the bitmap dimensions.
        if (GpiQueryBitmapDimension(hBM,&sizel1)==FALSE){
            CLEANUP("GpiQueryBitmapDimension",EntryName);
            return;
        }
        sprintf(Message,"GpiQueryBitmapDimension() says  Bitmap Dimensions are (%03ld mm, %03ld mm)",
                            sizel1.cx,sizel1.cy);

        WorldWriteString(ptl.x,ptl.y,Message);

        ptl.y +=(LONG)(3*syPosition/2); //Advance to next line position.
        sizel.cx+=20L;
        sizel.cy+=10L;

      }
      //Release memory space occupied by this bitmap.
      if (GpiDeleteBitmap(hBM)==FALSE){
         CLEANUP("GpiDeleteBitmap()",EntryName);
         return ;
      }

      EXIT_MAIN (EntryName);
  }
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiQueryDeviceBitmapFormatsExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi functions,
 *            GpiQueryDeviceBitmapFormats()
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/23/91, PDVT ,Mike Abuzant
 *               - initial file
 *               01/29/91, PDVT ,Mike Abuzant
 *                  -Test Case Design and Implementation.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:
 *       None.
 * Subroutines Required:
 *     set_delta();
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   Determine the number of bitmap formats that are supported by the
 *   current device. This count can be retrieved by a call to
 *   the function DevQueryDeviceCAPS().
 *
 *     FormatCount=alDevCaps[CAPS_BITMAP_FORMATS] //alDevCaps is initialized
 *                                                // by PTT.EXE
 *
 *   Query all bitmaps formats and store them at the address
 *   pointed to by 'alFormats[]'.
 *     GpiQueryDeviceBitmapFormats(hPS,FormatCount*2L,alFormats)..
 *
 *   FOR (all the formats supported by current device) DO
 *      display  Format number,
 *      display  bits per pixel count, and
 *      display  color planes count.
 *   ENDFOR
 *
 *\\end
 ***************************************************************************/
VOID  APIENTRY GpiQueryDeviceBitmapFormatsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{

   static PCHAR EntryName="GpiQueryDeviceBitmapFormatsExh";
   POINTL ptl;
   CHAR   Message[120];
   LONG   lIndex;                           // long Counter
   LONG   FormatCount,FormatCnt;
   LONG   alFormats[100];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
      ENTER_MAIN(EntryName);

      ptl.x=MapX(delta_x/5);
      ptl.y=MapY(delta_y*(pg_size_y-1));

      //32 FormatCount=alDevCaps[CAPS_BITMAP_FORMATS]; //Number of bitmap formats
                                                    //supported by the device.

      FormatCount = 2L; //Hardcode the number of bitmap formats (temp. fix).
      //Ask OS/2 to store all bitmap formats at address
      //pointed to by 'alFormats'.
      if (GpiQueryDeviceBitmapFormats(hPS,FormatCount*2L,alFormats)==FALSE){
          CLEANUP("GpiQueryDeviceBitmapFormats()",EntryName);
          return ;
      }
      sprintf(Message,"\t Number of bitmap formats supported by current device = %02ld \t",FormatCount);

      WorldWriteString(ptl.x,ptl.y,Message);

      ptl.y -=4*syPosition; // Advance to next line.

      /*================================================
       For all the bitmap formats supported by current
       device do :
        1. display  bitmap Format number,
        2. display  bits per pixel count, and
        3. display  color planes count.
      =================================================*/
      for(lIndex=0 ;lIndex<(FormatCount*2); lIndex+=2){
         sprintf(Message,"\t Format #%ld :  Bits per pixel=%03ld     "
                         "Color Planes=%03ld",(LONG)(lIndex/2+1),
                         alFormats[lIndex],alFormats[lIndex+1]);

          WorldWriteString(ptl.x,ptl.y,Message);

         ptl.y-=2*syPosition; //Advance to next line.
      }
      EXIT_MAIN (EntryName);
  }
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiQueryBitmapParametersExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi function GpiQueryBitmapParameters().
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/23/91, PDVT ,Mike Abuzant
 *               - initial file
 *               01/29/91, PDVT ,Mike Abuzant
 *                  -Test Case Design and Implementation.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient    -client window handle
 *        SelectionCall  -selection indicator.
 *
 * Outputs:
 *       None.
 * Subroutines Required:
 *     set_delta();
 *
 * Limitations:
 *    None at this time.
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *
 *   WHILE ( Top of display is not reached ) DO
 *
 *      Incroment the bitmap parameters(BitCount,ColorPlanes,Width ,etc...)
 *      and Create a bitmap .
 *         GpiCreateBitmap(hPS,&NewParameters,...);
 *      Print a message informing the user that a bitmap has
 *      been created with these parameters.
 *         GpiCharStringAt(hPS,Message,...);
 *
 *      Advance to next line.
 *         ptl.y+=syPosition
 *
 *      Query the bitmap Parameters.
 *        GpiQueryBitmapParameters(hBM,&Parameter.)
 *
 *      Print a message informing the user that the following
 *      parameters have been retrieved using  GpiQueryBitmapParameters().
 *         GpiCharStringAt(hPS,Message,...);
 *
 *      Advance to next line .
 *          ptl.y+=(3*syPosition/2);
 *
 *   ENDWHILE
 *
 *   Delete the bitmap.
 *      GpiDeletetBitmap(hBM);
 *
 *\\end
 ***************************************************************************/
VOID  APIENTRY GpiQueryBitmapParametersExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
   static PCHAR EntryName="GpiQueryBitmapParametersExh()";
   POINTL      ptl;
   CHAR        Message[120];
   HBITMAP hBM=(HBITMAP)NULL ;
   BITMAPINFOHEADER BitMapHeader;      //bitmap info header
   SIZEL       sizel;
   USHORT      Planes=0,
               BitCount=0;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
      ENTER_MAIN(EntryName);

      ptl.x=MapX(delta_x/5);
      ptl.y=MapY(delta_y);

      sizel.cx=30;              //Initial bitmap height and width
      sizel.cy=0L;

      while ( (LONG)UnMapY(ptl.y) < (LONG)(delta_y*pg_size_y)) {
        sizel.cx+=13;       //Incroment the bitmap width
        sizel.cy+=11;       //Incroment the bitmap height.
        Planes++;           //Incorment color planes.
        BitCount++;         //Incorment bits per pixel.

        // Initalize the Bitmap Header structure
        BitMapHeader.cbFix=sizeof(BITMAPINFOHEADER);   // This always =12
        BitMapHeader.cPlanes=Planes;
        BitMapHeader.cBitCount=BitCount;
        BitMapHeader.cx=(USHORT)sizel.cx;
        BitMapHeader.cy=(USHORT)sizel.cy;

        // Create and obtain a bitmap handle to use in testing
        // GpiQueryBitmapParameters().
        if ((hBM=GpiCreateBitmap(hPS,(PBITMAPINFOHEADER2)&BitMapHeader,
                                 0L,NULL,NULL))==GPI_ERROR){
            CLEANUP("GpiCreateBitmap()",EntryName);
            return ;
        }

        //Print a message informing the user that a bitmap has
       // been created with these parameters.
        sprintf(Message,"Setting Bitmap Parameters: Width=%03d  Height=%03d "
                        "BitCount=%02d ColorPlanes=%02d",
                         BitMapHeader.cx,BitMapHeader.cy,
                         BitMapHeader.cBitCount,BitMapHeader.cPlanes);

        WorldWriteString(ptl.x,ptl.y,Message);

        ptl.y+=syPosition; // Advance to the next line

        //Retrieve the bitmap parameters.
        if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
            CLEANUP("GpiQueryBitmapParameters()",EntryName);
            return;
        }

        //Print a message informing the user that the following
        //parameters have been retrieved using GpiQueryBitmapParameters().
        sprintf(Message,"GpiQueryBitmapParameters(): Width=%03d  Height=%03d "
                        "BitCount=%02d ColorPlanes=%02d",
                         BitMapHeader.cx,BitMapHeader.cy,
                         BitMapHeader.cBitCount,BitMapHeader.cPlanes);

        WorldWriteString(ptl.x,ptl.y,Message);

        ptl.y+=(LONG)(3*syPosition/2); //Advance to next line position.

        //Release memory space occupied by this bitmap.
        if (GpiDeleteBitmap(hBM)==FALSE){
            CLEANUP("GpiDeleteBitmap()",EntryName);
            return ;
        }
      }
      EXIT_MAIN (EntryName);
  }
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiLoadBitmapExh()
 *
 * Purpose:  This function exhaustively tests the functionality of
 *            The Gpi function  GpiLoadBitmap().
 *
 * System Requirements:
 *
 * Revision Log:
 *               01/29/91, PDVT ,Mike Abuzant
 *                  -Test Case Implementation and design.
 *
 * Inputs:
 *        hPS             -presentation space.
 *        hWndClient      -client window handle
 *        SelectionCall   -selection indicator.
 *
 * Outputs:
 *       None.
 * Subroutines Required:
 *    set_delta();
 *
 * Limitations:
 *
 *   Stretching the bitmap while loading  will not work when
 *   using  printer device drivers.
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *    Obtain the width and the height of the current device
 *        height=alDevCaps[CAPS_HEIGHT];  //alDevCaps[] is provided by PTT.
 *        width =alDevCaps[CAPS_WIDTH ];
 *
 *    Open a memory device context since bitmaps belongs to 'OD_MEMORY'
 *    device context
 *      hDC1=DevOpenDC(hAB,OD_MEMORY,....);
 *
 *    Create a new presentation space and associate it with the newly
 *    created device context.
 *      hPS1=GpiCreatePS(hAB,....);
 *
 *    Setup conditions to do bitmap Loading by using the Gpi function
 *    GpiLoadBitmap(). This algorithm will Load three  bitmaps  that are
 *    stored in this DLL. Then the function GpiBitBlt() will be used to
 *    display each loaded bitmap several times until the width of the
 *    device is filled.
 *
 *   FOR (index=0 ;index <NumberOfBitmapsToLoad ; index++) DO
 *      FOR(Index1=0 ;lIndex<7 ;lIndex1++) DO
 *        Load the next bitmap
 *          hBM=GpiLoadBitmap(hPS,...)
 *
 *        Get the bitmap parameters. These parameters will be used to
 *        determine the loaded bitmap size.
 *           GpiQueryBitmapParameters(hBM,&InfoBuffer..)
 *
 *        Setup the coordinates of the Target rectangle
 *        Draw the bitmap on current DC using GpiBitBlt()
 *          GpiBitBlt(hPS,hPS1,...,ROP_SRCCOPY)...
 *
 *        De-Select the bitmap form the presentation space by passing  NULL
 *        as a bitmap handle. This will serve as De-selecting.
 *          GpiSetBitmap(hPS1,NULL....);
 *
 *        Delete the bitmap.
 *           GpiDeletetBitmap(hBM);
 *
 *      ENDFOR
 *
 *   ENDFOR
 *
 *   Destory the presentation space.
 *     GpiDestoryPS(hPS1);
 *
 *   Close the device context
 *    DevCloseDC(hDC1);
 *
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiLoadBitmapExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

static USHORT  aBitMapId[]={THIRD_BITMAP_ID,
                            SECOND_BITMAP_ID,
                            FIRST_BITMAP_ID
                           };
 static PCHAR EntryName="GpiLoadBitmapExh()";
 static SIZEL sizel={0L,0L};          // size of bitmap to draw
 static PCHAR DllName="Gpibtmp";
 HMODULE  hMOD;
 HBITMAP hBM=(HBITMAP)NULL ;
 HDC    hDC;
 HDC    hDC1;
 HAB    hAB;
 HPS    hPS1;
 POINTL  aptl[4];
 LONG lIndex1,                           // long Counter
      lIndex4,                           // long Counter
      width,
      height,
      Xinc,
      Yinc;

 BITMAPINFOHEADER BitMapHeader;      //bitmap info header

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     ENTER_MAIN(EntryName);

     //Ask OS/2 to load resources stored in this DLL.
     if (DosLoadModule(NULL,0,DllName,&hMOD)){
        CLEANUP("DosLoadModule()",EntryName);
        CWRITELOG(L_LOTRACE,0,"GPIBTMP.DLL must be in current directory\n");
        return;
     }

     height=alDevCaps[CAPS_HEIGHT];  // Device height in pixels.
     width =alDevCaps[CAPS_WIDTH ];  // Device width  in pixels.
     //Chop 1" from the top since widow title takes some pels from
     // The screen height.
     height-=(LONG)CONVERTTOINCHES(hori_pels_per_m);

     //Get Anchor Block. It used for creating new presentation spaces.
     if ((hAB=WinQueryAnchorBlock(hWndClient))==NULL){
           CLEANUP("WinQueryAnchorBlock()",EntryName);
           return;        // Can't proceed without Anchor block
      }

      //Get Device Context associated with current PS.
     if ((hDC=GpiQueryDevice(hPS))==HDC_ERROR){
           CLEANUP("GpiQueryDevice()",EntryName);
           return;       // Can't proceed without hDC
      }

     /***********************************************************
     * This code segment is intended to create new Presentation *
     * Space  and associate it with memory Device Context. The  *
     * The need for a new PS and a new DC stem from the fact    *
     * that bitmaps belongs to DCs of OD_MEMORY type.           *
     ***********************************************************/
     // Open a Memory device context  to use for bitmap operations.
     if ((hDC1=DevOpenDC(hAB,OD_MEMORY,"*",0L,(PDEVOPENDATA)NULL,
                         (HDC)hDC))==DEV_ERROR){
          CLEANUP("DevOpenDC()",EntryName);
          return ;       // Can't proceed without hDC
     }

     // Create a presentation space to associate with the
     // memory device context
     if ((hPS1=GpiCreatePS(hAB,hDC1,&sizel,PU_PELS|
                           GPIA_ASSOC|GPIT_MICRO))==GPI_ERROR){
          CLEANUP("GpiCreatePS()",EntryName);
          return ;       // Can't proceed without hPS
     }

     //Set the coordinates of the lower left corner of source rectangle
       aptl[2].x=
       aptl[2].y=0L;

     /*=================================================================
      Setup conditions to do bitmap Loading by using the Gpi function
      GpiLoadBitmap(). This algorithm will Load three  bitmaps  that are
      stored in this DLL. Then the function GpiBitBlt() will be used to
      display each loaded bitmap several times until the width of the
      device is filled.
     =================================================================*/

     for (lIndex4=0 ;lIndex4<NUMBEROFELEMENTS(aBitMapId); lIndex4++){
       //Target rectangle
        aptl[0].x=0L;
        aptl[0].y=50L+(lIndex4*(height/3));
        aptl[1].x=(LONG)(width/7);
        aptl[1].y=((lIndex4==0L)? 50L: 0L)+((lIndex4+1)*(height/3));

        for (lIndex1=0 ;lIndex1< 7 ;lIndex1++){
           //Loadthe next bitmap from this DLL.
           if((hBM=GpiLoadBitmap(hPS,hMOD,aBitMapId[lIndex4],
                                 0L,0L))==GPI_ERROR){
               CLEANUP("GpiLoadBitmap()",EntryName);
               return ;
           }

           //Retrieve bitmap parameters namely, bits/pixel,with,height,
           //and color planes.
           if (GpiQueryBitmapParameters(hBM,&BitMapHeader)==FALSE){
               CLEANUP("GpiQueryBitmapParameters()",EntryName);
               return;
           }

           //Set the coordinates of the upper right corner of
           //source rectangle
           aptl[3].x=(LONG)BitMapHeader.cx;
           aptl[3].y=(LONG)BitMapHeader.cy;
           if (lIndex1==0){
             Xinc=(LONG)(((width/7)-aptl[3].x)/14);
             Yinc=(LONG)(((height/3)-aptl[3].y)/14);
           }

           //Select bitmap into a memory Device Context.
           if (GpiSetBitmap(hPS1,hBM)==HBM_ERROR){
               CLEANUP("GpiSetBitmap()",EntryName);
               return ;
           }

           //Copy bitmap to display.GpiBitBlt() will  compress
           // or/and stretch bitmap to fit into the target rectangle.
           if (GpiBitBlt(hPS,hPS1,4L,aptl,ROP_SRCCOPY,BBO_AND)==GPI_ERROR){
               CLEANUP("GpiBitBlt()",EntryName);
               return ;
           }

           //Target rectangle will become smaller each time through
           //the loop by a factor stored in 'Xinc' and 'Yinc.
           aptl[0].x=aptl[1].x+Xinc;
           aptl[1].x=aptl[0].x-2*Xinc+(width/7);
           aptl[0].y+=Yinc;
           aptl[1].y-=Yinc;

        }
        // De-select the bitmap handle. otherwise we get error when closing
        // device context
        if (GpiSetBitmap(hPS1,NULL)==FALSE){
           CLEANUP("GpiSetBitmap()",EntryName);
           return ;
        }

        //Release memory space occupied by this bitmap.
        if (GpiDeleteBitmap(hBM)==FALSE){
           CLEANUP("GpiDeleteBitmap()",EntryName);
           return ;
        }
     }

    /*=================================================================
      The purpose of next code segment is do some house cleaning
      before exiting this routine. the following is done:
      1. De-select any bitmaps that are selected into memory Device
         Contexts or/and Un-tag any bitmaps that are used as pattern.
      2. Delete any bitmaps created within this function.
      3. Delete any Presentation Spaces created within this function.
      4. Delate any Device Contexts created within this function.

         Note that these steps must be followed as presented above,
         otherwise; most GPIs used here will fail.
    ===================================================================*/

     // dispose of presentation space. No longer needed.
     if (GpiDestroyPS(hPS1)==FALSE){
         CLEANUP("GpiDestroyPS()",EntryName);
         return ;
     }

     //Close the device context
     if (DevCloseDC(hDC1)==DEV_ERROR){
         CLEANUP("DevCloseDC()",EntryName);
         return ;
     }

     //Release memory space occupied by resources.(or unload resources)
     if (DosFreeModule(hMOD)!= 0){
         CLEANUP("DosFreeModule()",EntryName);
         return;
     }
     EXIT_MAIN (EntryName);
  }
  return ;
}

