#define INCL_DEV                    //Include all DEV definitions
#define INCL_WIN                    //Include all WIN definitions
#define INCL_GPI                    //Include all Gpi definitions
#define INCL_ERRORS                 //Include all error definitions
#define INCL_DOSMODULEMGR
#define MAINSOURCEFILE              //This main source code.
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common.h"
#include "gpiarea.h"                // Area dll header file

/****************************************************************************
 *\\ddd
 * Subtask Name: GpiArea.dll
 *
 * Module name: Gpiarea.c
 *
 * Purpose: Area DLL test functions
 *
 * Revision Log:  10/3/91
 *               Vish Thyagarajan (Boca System Test)
 *
 *
 * SAD References:
 *
 * SRS References: Printer Driver Verification Tool
 *
 * Contents:
 *
 * Design Overview:
 *   This TestCase is designed to test Area manipulation functions.Functions
 *   tested are listed below :
 *
 *   1. GpiBeginArea
 *   2. GpiEndArea
 *   3. GpiSetPattern
 *   4. GpiSetPatternSet
 *   5. GpiSetPatternRefPoint
 *   6. GpiQueryPattern
 *   7. GpiQueryPatternSet
 *   8. GpiQueryPatternRefPoint
 *   9. GpiPaintRegion
 *
 *     All tests include  a basic functionality test and an exhaustive
 *   (test all return codes at the lowest level) test.
 *
 *\\end
****************************************************************************/
/****************************************************************************
 *\\ddd
 * Routine Name: InitTest()
 *
 * Purpose:  Initialize function name and address array for ptt.
 *
 * Inputs:
 *   sel          // passed through to the InitTestSegVars function
 *   init_info_p  // name and address array used by ptt interface
 *
 * Outputs:
 *   init_info_p  // returned initialized with names and addresses
 *
 * Subroutines Required:
 *   InitTestSegVars()    // used by the PTT interface
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 * {
 *   for the number of test functions {
 *       set function name
 *       set function address
 *   }
 *   call init set function
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID Selector, PTESTINITINFO init_info_p)
{
  //register USHORT usTestCounter;
  INT usTestCounter;

  init_info_p->ntests = NTESTS;
  strcpy(init_info_p->group_name,TestCaseName); //Testcase Name

  for (usTestCounter=0 ;usTestCounter< NTESTS; ++usTestCounter){

     init_info_p->test_addrs[usTestCounter]=
                               EntryPointList[usTestCounter].TestAddress;
     strcpy(init_info_p->test_names[usTestCounter],
                               EntryPointList[usTestCounter].TestName);
  }

  InitTestSegVars(Selector);
  return;
}


/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an application test of some of the Area calls
 ************************************************************************
 ************************************************************************
 ************************************************************************/


VOID APIENTRY GpiAreaApp (HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL ptl ;
  POINTL ptlUnit;
  POINTL ptltemp ;
  static  PCHAR EntryName="GpiAreaApp()";
  static LONG lgraph[] = {7, 5, 3, 2, 4, 6, 8, 6, 5, 3, 1, 2, 3, 5, 8, 7} ;
  static LONG lSymbol[] =         {
                                   PATSYM_DENSE1,
                                   PATSYM_DENSE2,
                                   PATSYM_DENSE3,
                                   PATSYM_DENSE4,
                                   PATSYM_DENSE5,
                                   PATSYM_DENSE6,
                                   PATSYM_DENSE7,
                                   PATSYM_DENSE8,
                                   PATSYM_VERT,
                                   PATSYM_HORIZ,
                                   PATSYM_DIAG1,
                                   PATSYM_DIAG2,
                                   PATSYM_DIAG3,
                                   PATSYM_DIAG4,
                                   PATSYM_NOSHADE,
                                   PATSYM_SOLID } ;
  int i ;

  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else{

    ENTER_MAIN(EntryName);
    ptlUnit.x = ptl.x = 45L;
    ptlUnit.y = ptl.y = 65L ;
    MapPt(ptl) ;
    GpiMove(hPS, &ptl) ;
    ptl.x = ptlUnit.x * (NPOINTS + 1) ;
    ptl.y = ptlUnit.y * 10 ;
    MapPt(ptl) ;

    // draw outline for the bar chart

    if (GpiBox(hPS, DRO_OUTLINE, &ptl, 0L, 0L) == GPI_ERROR) {
       CLEANUP("GpiBox()",EntryName);
       return;
    }
    ptl.x = ptlUnit.x ;

    // draw 16 bars with different fill patterns

    for (i= 0; i < NPOINTS ; i++){
      ptl.x += ptlUnit.x ;
      ptltemp.x = ptl.x ;
      ptl.y = lgraph[i] * ptlUnit.y + ptlUnit.y ;
      MapPt(ptl) ;
      if (GpiSetPattern (hPS, lSymbol[i]) == FALSE) {
        CLEANUP("GpiSetPattern()",EntryName);
        return;
      }
      if (GpiBox(hPS, DRO_OUTLINEFILL, &ptl, 0L, 0L) == GPI_ERROR) {
        CLEANUP("GpiBox()",EntryName);
        return;
      }
      ptl.y = ptlUnit.y ;
      ptl.x = ptltemp.x ;
      MapPt(ptl) ;
      GpiMove(hPS, &ptl) ;
      ptl.y = ptlUnit.y ;
      ptl.x = ptltemp.x ;
    }

    MapAndWriteString(80L, 600L,"A BAR CHART USING GPISETPATTERN");
    EXIT_MAIN (EntryName);
  }
    return ;
}



/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an exhaustive print test of the GpiBeginArea API.
 ************************************************************************
 ************************************************************************
 ************************************************************************/

VOID APIENTRY GpiBeginAreaExh (HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  static  PSZ EntryName="GpiBeginAreaExh()";
  static POINTL aptlStar[5] = { -60, -40, 0, 50, 60, -40, -90, 15, 90, 15 } ;
  static POINTL aptlFigure[10] = {10,110, 50,110, 50,170, 90,170, 90,130,
                                  30,130, 30,90, 70,90, 70,150, 10,150} ;

  POINTL aptl[5] ;
  POINTL bptl[10] ;
  SHORT sIndex ;

  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(EntryName);


    if ( GpiSetPattern (hPS, PATSYM_HALFTONE) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
    }

// check the alternate/winding modes with BA_NOBOUNDARY option

    for (sIndex = 0 ; sIndex < 5 ; sIndex ++) {

     aptl[sIndex].x = XMULT / 4 + XMULT * aptlStar[sIndex].x / 400 ;
     aptl[sIndex].y = YMULT / 2 + YMULT * aptlStar[sIndex].y / 200 ;
     MapPt(aptl[sIndex]) ;
    }

    if (GpiBeginArea(hPS, BA_NOBOUNDARY | BA_ALTERNATE) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
    }

    if (GpiMove(hPS, aptl) == FALSE){
       CLEANUP("GpiMove()",EntryName);
       return;
    }

    if (GpiPolyLine(hPS, 4L, aptl + 1) == GPI_ERROR){
       CLEANUP("GpiPolyLine()",EntryName);
       return;
    }
    if (GpiEndArea(hPS) == FALSE) {
       CLEANUP("GpiEndArea()",EntryName);
       return;
    }
    MapAndWriteString(10L, 80L,"BA_NOBOUNDARY | BA_ALTERNATE");

    if ( GpiSetPattern (hPS, PATSYM_HALFTONE) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
    }
    for (sIndex = 0 ; sIndex < 5 ; sIndex ++){
     aptl[sIndex].x = XMULT / 4 + XMULT * aptlStar[sIndex].x / 400 ;
     aptl[sIndex].x +=  XMULT  ;
     aptl[sIndex].y  = YMULT /2 + YMULT * aptlStar[sIndex].y / 200 ;
     MapPt(aptl[sIndex]) ;
    }

    if (GpiBeginArea(hPS, BA_NOBOUNDARY | BA_WINDING) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
    }

    if (GpiMove(hPS, aptl) == FALSE){
       CLEANUP("GpiMove()",EntryName);
       return;
    }
    if (GpiPolyLine(hPS, 4L, aptl + 1) == GPI_ERROR){
       CLEANUP("GpiPolyLine()",EntryName);
       return;
    }
    if (GpiEndArea(hPS) == FALSE) {
       CLEANUP("GpiEndArea()",EntryName);
       return;
    }
    MapAndWriteString(500L, 80L,"BA_NOBOUNDARY | BA_WINDING");



// Now check the alternate/winding modes with BA_BOUNDARY option
    if ( GpiSetPattern (hPS, PATSYM_HALFTONE) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
    }

    for (sIndex = 0 ; sIndex < 10 ; sIndex ++){
     bptl[sIndex].x = XMULT * aptlFigure[sIndex].x / 200 ;
     bptl[sIndex].y = YMULT * aptlFigure[sIndex].y / 100 ;
     MapPt(bptl[sIndex]) ;
    }

    if (GpiBeginArea(hPS, BA_BOUNDARY | BA_ALTERNATE) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
    }

    if (GpiMove(hPS, bptl) == FALSE){
       CLEANUP("GpiMove()",EntryName);
       return;
    }
    if (GpiPolyLine(hPS, 9L, bptl + 1) == GPI_ERROR){
       CLEANUP("GpiPolyLine()",EntryName);
       return;
    }
    if (GpiEndArea(hPS) == FALSE) {
       CLEANUP("GpiEndArea()",EntryName);
       return;
    }
    MapAndWriteString(10L, 280L,"BA_BOUNDARY | BA_ALTERNATE");

    if ( GpiSetPattern (hPS, PATSYM_HALFTONE) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
    }
    for (sIndex = 0 ; sIndex < 10 ; sIndex ++){
     bptl[sIndex].x = XMULT * aptlFigure[sIndex].x / 200 ;
     bptl[sIndex].x +=  XMULT  ;
     bptl[sIndex].y = YMULT * aptlFigure[sIndex].y / 100 ;
     MapPt(bptl[sIndex]) ;
    }

    if (GpiBeginArea(hPS, BA_BOUNDARY | BA_WINDING) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
    }

    if (GpiMove(hPS, bptl) == FALSE){
       CLEANUP("GpiMove()",EntryName);
       return;
    }
    if (GpiPolyLine(hPS, 9L, bptl + 1) == GPI_ERROR){
       CLEANUP("GpiPolyLine()",EntryName);
       return;
    }
    if (GpiEndArea(hPS) == FALSE) {
       CLEANUP("GpiEndArea()",EntryName);
       return;
    }
    MapAndWriteString(500L, 280L,"BA_BOUNDARY | BA_WINDING");

    EXIT_MAIN (EntryName);

  }
    return ;
}



/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an exhaustive print test of the GpiSetPattern API.
 ************************************************************************
 ************************************************************************
 ************************************************************************/

VOID APIENTRY GpiSetAndQryPatternExh (HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL ptlTitle;
  POINTL ptlFullArcCenter;
  POINTL ptlBox1,ptlBox2;
  POINTL ptlPoly[5];
  ARCPARAMS arcparams;
  INT i;
  static  PCHAR EntryName="GpiSetAndQryPatternExh()";

  static LONG alPatternSymbol[] = {PATSYM_DEFAULT,
                                   PATSYM_DENSE1,
                                   PATSYM_DENSE2,
                                   PATSYM_DENSE3,
                                   PATSYM_DENSE4,
                                   PATSYM_DENSE5,
                                   PATSYM_DENSE6,
                                   PATSYM_DENSE7,
                                   PATSYM_DENSE8,
                                   PATSYM_DIAG1,
                                   PATSYM_DIAG2,
                                   PATSYM_DIAG3,
                                   PATSYM_DIAG4,
                                   PATSYM_NOSHADE,
                                   PATSYM_SOLID,
                                   PATSYM_HALFTONE,
                                   PATSYM_BLANK};


  static CHAR *achPatternName[] = {"PATSYM_DEFAULT",
                                  "PATSYM_DENSE1",
                                  "PATSYM_DENSE2",
                                  "PATSYM_DENSE3",
                                  "PATSYM_DENSE4",
                                  "PATSYM_DENSE5",
                                  "PATSYM_DENSE6",
                                  "PATSYM_DENSE7",
                                  "PATSYM_DENSE8",
                                  "PATSYM_DIAG1",
                                  "PATSYM_DIAG2",
                                  "PATSYM_DIAG3",
                                  "PATSYM_DIAG4",
                                  "PATSYM_NOSHADE",
                                  "PATSYM_SOLID",
                                  "PATSYM_HALFTONE",
                                  "PATSYM_BLANK"};
  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else{

    ENTER_MAIN(EntryName);

    /********************************************************************
       The presentation space will be divided into 16 rows, one for each
       of the valid fill patterns. In each row we will draw various
       objects that will fill with the chosen fill pattern.
     ********************************************************************/

    for (i = 0; i < 16 ; i++ ){


      // Set the pattern to be used for this row.

      if ( GpiSetPattern (hPS, alPatternSymbol[i]) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
      }


      // In the first column, label each row with the name of the pattern
      // that will be used.

      ptlTitle.x = 10L;
      ptlTitle.y = (i*50) + 100L;
      MapPt(ptlTitle);
      if (GpiQueryPattern(hPS) == alPatternSymbol[i]){
       if ( GpiCharStringAt (hPS,
                            &ptlTitle,
                            (LONG) strlen(achPatternName[i]),
                            achPatternName[i] ) == GPI_ERROR){
        CLEANUP("GpiCharStringAt()",EntryName);
        return;
       }
      }
      else {
        CLEANUP("GpiQueryPattern()",EntryName);
        return;
      }




      // Draw a full arc in the second column.

      arcparams.lP = 80L;
      arcparams.lS = 0L;
      arcparams.lR = 0L;
      arcparams.lQ = 20L;
      MapArc(arcparams);

      if ( GpiSetArcParams (hPS, &arcparams) == FALSE ){
       CLEANUP("GpiSetArcParams()",EntryName);
       return;
      }

      ptlFullArcCenter.x = 375L;
      ptlFullArcCenter.y = (i*50)+100L;
      MapPt(ptlFullArcCenter);

      if ( GpiMove (hPS, &ptlFullArcCenter) == FALSE ){
       CLEANUP("GpiMove()",EntryName);
       return;
      }

      if ( GpiFullArc(hPS, DRO_FILL, MAKEFIXED(1,0)) == GPI_ERROR){
       CLEANUP("GpiFullArc()",EntryName);
       return;
      }


      // Draw a box in the third column.

      ptlBox1.x = 510;
      ptlBox1.y = (i*50) + 80;
      ptlBox2.x = 650;
      ptlBox2.y = ptlBox1.y + 40;
      MapPt(ptlBox1);
      MapPt(ptlBox2);

      if ( GpiMove (hPS, &ptlBox1) == FALSE ){
       CLEANUP("GpiMove()",EntryName);
       return;
      }

      if ( GpiBox (hPS, DRO_FILL, &ptlBox2, 0L, 0L) == GPI_ERROR ){
       CLEANUP("GpiBox()",EntryName);
       return;
      }


      // Draw a polyline with in area in the fourth column.

      ptlPoly[0].x = 680 ;
      ptlPoly[0].y = (i*50) + 80 ;
      ptlPoly[1].x = 660;
      ptlPoly[1].y = (i*50) + 120 ;
      ptlPoly[2].x = 780;
      ptlPoly[2].y = (i*50) + 120 ;
      ptlPoly[3].x = 790;
      ptlPoly[3].y = (i*50) + 80 ;
      MapPt(ptlPoly[0]);
      MapPt(ptlPoly[1]);
      MapPt(ptlPoly[2]);
      MapPt(ptlPoly[3]);

      if ( GpiBeginArea(hPS,BA_NOBOUNDARY) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
      }
      else{
        if ( GpiMove(hPS, &ptlPoly[0]) == FALSE){
         CLEANUP("GpiMove()",EntryName);
         return;
        }
        if ( GpiPolyLine(hPS, 3L, &ptlPoly[1]) == GPI_ERROR){
         CLEANUP("GpiPolyLine()",EntryName);
         return;
        }
        else{
           if ( GpiEndArea (hPS) == GPI_ERROR){
            CLEANUP("GpiMove()",EntryName);
            return;
           }
        }
      }


    }  /* endfor */


    EXIT_MAIN (EntryName);

  }

    return ;
}




/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an exhaustive print test of the GpiSetPatternRefPoint API.
 ************************************************************************
 ************************************************************************
 ************************************************************************/

VOID APIENTRY GpiSetAndQryPatternRefPointExh (HPS hPS,HWND hWndClient,
                                                       BOOL SelectionCall)
  {
  static  PCHAR EntryName="GpiSetAndQryPatternRefPointExh()";
  POINTL pptlRef ;
  POINTL ref1, ref2 ;
  POINTL ptlStart  ;
  POINTL ptlTriangle[3] ;
  POINTL aptlBox1 ;
  POINTL aptlBox2 ;
  POINTL ptlFullArcCenter;
  ARCPARAMS arcparams;

  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else{
      ENTER_MAIN(EntryName);


      GpiSetAttrMode(hPS, AM_PRESERVE) ;
      if ( GpiSetPattern (hPS, PATSYM_DIAG2) == FALSE ){
       CLEANUP("GpiSetPattern()",EntryName);
       return;
      }

      // Set the Pattern Ref Point to default (0,0)
      pptlRef.x = 0 ;
      pptlRef.y = 0 ;
      MapPt(pptlRef) ;

      if ( GpiSetPatternRefPoint(hPS,&pptlRef) == GPI_ERROR){
       CLEANUP("GpiSetPatternRefPoint()",EntryName);
       return;
      }

      //Draw a rectangular box
      aptlBox1.x = 100 ;
      aptlBox1.y = 100 ;
      aptlBox2.x = 300 ;
      aptlBox2.y = 200 ;
      MapPt(aptlBox1) ;
      MapPt(aptlBox2) ;
      GpiMove(hPS, &aptlBox1) ;

      if ( GpiBox (hPS, DRO_FILL, &aptlBox2, 0L, 0L) == GPI_ERROR ){
       CLEANUP("GpiBox()",EntryName);
       return;
      }



      // Draw a Triangle
      ptlStart.x = 100 ;
      ptlStart.y = 300 ;
      MapPt(ptlStart) ;
      ptlTriangle[0].x = 200 ;
      ptlTriangle[0].y = 400 ;
      ptlTriangle[1].x = 300 ;
      ptlTriangle[1].y = 300 ;
      ptlTriangle[2].x = 100 ;
      ptlTriangle[2].y = 300 ;
      MapPt(ptlTriangle[0]) ;
      MapPt(ptlTriangle[1]) ;
      MapPt(ptlTriangle[2]) ;
      GpiBeginArea(hPS, BA_BOUNDARY) ;
      GpiMove (hPS, &ptlStart) ;
      GpiPolyLine( hPS, 3L, ptlTriangle);
      GpiEndArea(hPS) ;


      //Draw a circle
      arcparams.lP = 50L;
      arcparams.lS = 0L;
      arcparams.lR = 0L;
      arcparams.lQ = 50L;
      MapArc(arcparams);

      if ( GpiSetArcParams (hPS, &arcparams) == FALSE ){
       CLEANUP("GpiSetArcParams()",EntryName);
       return;
      }

      ptlFullArcCenter.x = 200L;
      ptlFullArcCenter.y = 500L;
      MapPt(ptlFullArcCenter);

      if ( GpiMove (hPS, &ptlFullArcCenter) == FALSE ){
       CLEANUP("GpiMove()",EntryName);
       return;
      }

      if ( GpiFullArc(hPS, DRO_FILL, MAKEFIXED(1,0)) == GPI_ERROR){
       CLEANUP("GpiFullArc()",EntryName);
       return;
      }


      GpiQueryPatternRefPoint (hPS, &ref1) ;
//      UnMapX(ref1.x) ; BSC
//      UnMapY(ref1.y) ; BSC
      if ((ref1.x == 0) && (ref1.y == 0)){
       MapAndWriteString( 10L, 630L,"Pattern Reference Point");
       MapAndWriteString( 10L, 600L,"for this column is (0,0)") ;
      }
      else{
       CLEANUP("GpiQueryPatternRefPoint()",EntryName);
       return;
      }




      // Now change the pattern Reference Point to 0,100
      // and keep drawing the box, triangle and circle

      pptlRef.x= 0  ;
      pptlRef.y= 100  ;
      MapPt(pptlRef) ;
      if   ( GpiSetPatternRefPoint(hPS,&pptlRef) == GPI_ERROR){
       CLEANUP("GpiSetPatternRefPoint()",EntryName);
       return;
      }

      GpiQueryPatternRefPoint (hPS, &ref2) ;
//      UnMapX(ref2.x) ;  BSC
//      UnMapY(ref2.y) ;  BSC

       MapAndWriteString( 350L, 630L,"Pattern Reference Point");
       MapAndWriteString( 350L, 600L,"for this column is (0,100)") ;

      if ((ref2.x != 0) && (ref2.y != 100)){
       CLEANUP("GpiQueryPatternRefPoint()",EntryName);
       return;
      }


      if ( GpiSetPattern (hPS, PATSYM_DIAG2) == FALSE ){
        CLEANUP("GpiSetPattern()",EntryName);
        return;
      }
      aptlBox1.x = 350 ;
      aptlBox1.y = 100 ;
      aptlBox2.x = 550 ;
      aptlBox2.y = 200 ;
      MapPt(aptlBox1) ;
      MapPt(aptlBox2) ;
      GpiMove(hPS, &aptlBox1) ;

      if ( GpiBox (hPS, DRO_FILL, &aptlBox2, 0L, 0L) == GPI_ERROR ){
       CLEANUP("GpiBox()",EntryName);
       return;
      }


      ptlStart.x = 350 ;
      ptlStart.y = 300 ;
      MapPt(ptlStart) ;
      ptlTriangle[0].x = 450 ;
      ptlTriangle[0].y = 400 ;
      ptlTriangle[1].x = 550 ;
      ptlTriangle[1].y = 300 ;
      ptlTriangle[2].x = 350 ;
      ptlTriangle[2].y = 300 ;
      MapPt(ptlTriangle[0]) ;
      MapPt(ptlTriangle[1]) ;
      MapPt(ptlTriangle[2]) ;
      GpiBeginArea(hPS, BA_BOUNDARY) ;
      GpiMove (hPS, &ptlStart) ;
      GpiPolyLine( hPS, 3L, ptlTriangle);
      GpiEndArea(hPS) ;




      arcparams.lP = 50L;
      arcparams.lS = 0L;
      arcparams.lR = 0L;
      arcparams.lQ = 50L;
      MapArc(arcparams);

      if ( GpiSetArcParams (hPS, &arcparams) == FALSE ){
       CLEANUP("GpiSetArcParams()",EntryName);
       return;
      }

      ptlFullArcCenter.x = 450L;
      ptlFullArcCenter.y = 500L;
      MapPt(ptlFullArcCenter);

      if ( GpiMove (hPS, &ptlFullArcCenter) == FALSE ){
       CLEANUP("GpiMove()",EntryName);
       return;
      }

      if ( GpiFullArc(hPS, DRO_FILL, MAKEFIXED(1,0)) == GPI_ERROR){
       CLEANUP("GpiFullArc()",EntryName);
       return;
      }



    EXIT_MAIN (EntryName);

   }
    return ;
}




/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an exhaustive test of the GpiSetPatternSet API.
 ************************************************************************
 ************************************************************************
 ************************************************************************/


VOID APIENTRY GpiSetAndQryPatternSetExh(HPS hPS,HWND hWndClient,BOOL SelectionCall)
  {
  static  PCHAR EntryName="GpiSetAndQryPatternSetExh()";
  HMODULE RCHandle ;
  LONG lNumberRequested = 0 ;
  LONG lNumberReturned ;
  HBITMAP hbmp1, hbmp2, hbmp3, hbmp4, hbmp5;
  BITMAPINFOHEADER  bmp ;
  BITMAPINFOHEADER  BitMapHeader;      //bitmap info header
  PBITMAPINFO       pbmi ;
  CHAR cBuffer[80] ;
  CHAR sOut[256];
  POINTL boxptl ;
  POINTL lineptl[5] ;
  POINTL ptlTriangle[3] ;
  POINTL ptlFigure[4] ;
  LONG    lMaxBaselineExtent=0;
  INT  i;
  LONG  lFontOK=0;


//  PFONTMETRICS pfm ;      TSS...Insufficient for more than 1 seg. of fonts.

  FONTMETRICS  *pfm;
//  PVOID         pmem; BSC...unused


  HDC  hDC;
  LONG lHorzRes, lVertRes;
  LONG    lReturned=0;
  static FATTRS fat;
  POINTL ptl;
  static BYTE abPattern5[] = { 0xFF, 0xFF,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00,
                               0x80, 0x00  } ;
  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else{
    ENTER_MAIN(EntryName);
    if (DosLoadModule (NULL, 0, "gpiarea",&RCHandle)){
       CLEANUP("DosLoadModule()",EntryName);
       return;
    }
    MapAndWriteString( 10L, 600L,"CUSTOM FILL PATTERNS USING BITMAPS AND CHARACTERS");

    /************************************************************************
     * Load up some bitmaps and assign them IDs to use with the
     * GpiSetPatternSet command.
     ************************************************************************/

    // This bitmap contains the brick pattern.

    if (( hbmp1= GpiLoadBitmap ( hPS,RCHandle, IDBITMAP_BRICKS, 0L, 0L )) == GPI_ERROR){
       CLEANUP("GpiLoadBitmap()",EntryName);
       return;
    }

//TSS...debug purposes
    if (GpiQueryBitmapParameters(hbmp1,&BitMapHeader)==FALSE){
        CLEANUP("GpiQueryBitmapParameters()",EntryName);
        return;
    }
    sprintf(sOut,"BITMAP_BRICKS Width=%d Height=%d BitCount=%d",BitMapHeader.cx,BitMapHeader.cy,BitMapHeader.cBitCount);
    CWRITELOG(L_LOTRACE,0,sOut);


    if (GpiSetBitmapId ( hPS, hbmp1, 1L) == FALSE){
       CLEANUP("GpiSetBitmapId()",EntryName);
       return;
    }

    // Draw a parallelogram filled with the brick pattern.

    if ( GpiSetPatternSet (hPS, 1L) == FALSE ){
      CLEANUP("GpiSetPatternSet()",EntryName);
      return;
    }
    else{
      ptl.x = 50;
      ptl.y = 100;
      MapPt(ptl) ;
      ptlFigure[0].x = 150 ;
      ptlFigure[0].y = 300 ;
      ptlFigure[1].x = 300 ;
      ptlFigure[1].y = 300 ;
      ptlFigure[2].x = 200 ;
      ptlFigure[2].y = 100 ;
      ptlFigure[3].x = 50  ;
      ptlFigure[3].y = 100 ;
      for (i= 0 ; i < 4 ; i++){
       MapPt(ptlFigure[i]) ;
      }
      if ( GpiBeginArea(hPS,BA_BOUNDARY) == FALSE){
       CLEANUP("GpiBeginArea()",EntryName);
       return;
      }
      else{
        if ( GpiMove(hPS, &ptl) == FALSE){
         CLEANUP("GpiMove()",EntryName);
         return;
        }
        if ( GpiPolyLine(hPS, 4L, ptlFigure) == GPI_ERROR){
         CLEANUP("GpiPolyLine()",EntryName);
         return;
        }
        else{
           if ( GpiEndArea (hPS) == GPI_ERROR){
            CLEANUP("GpiEndArea()",EntryName);
            return;
           }
        }
      }

      if ( GpiQueryPatternSet (hPS) == 1L) {
       MapAndWriteString( 50L, 80L,"IDBITMAP_BRICKS");
      }
      else{
       CLEANUP("GpiQueryPatternSet()",EntryName);
       return;
      }
      GpiDeleteSetId (hPS, 1L);
    }



    // This bitmap contains the squares.
    if (( hbmp2 = GpiLoadBitmap (hPS,RCHandle, IDBITMAP_SQUARES, 0L, 0L)) == GPI_ERROR){
       CLEANUP("GpiLoadBitmap()",EntryName);
       return;
    }

//TSS...debug purposes
    if (GpiQueryBitmapParameters(hbmp2,&BitMapHeader)==FALSE){
        CLEANUP("GpiQueryBitmapParameters()",EntryName);
        return;
    }
    sprintf(sOut,"BITMAP_SQUARES Width=%d Height=%d BitCount=%d",BitMapHeader.cx,BitMapHeader.cy,BitMapHeader.cBitCount);
    CWRITELOG(L_LOTRACE,0,sOut);



    if (GpiSetBitmapId ( hPS, hbmp2, IDBITMAP_SQUARES ) == FALSE){
      CLEANUP("GpiSetBitmapId()",EntryName);
      return;
    }
    if ( GpiSetPatternSet (hPS, 2L) == FALSE ){
       CLEANUP("GpiSetPatternSet()",EntryName);
       return;
    }
    else{
      ptl.x = 450;
      ptl.y = 200;
      MapPt(ptl) ;
      DrawCircle ( hPS, &ptl);
      if ( GpiQueryPatternSet (hPS) == 2L) {
       MapAndWriteString( 350L, 80L,"IDBITMAP_SQUARES");
      }
      else{
       CLEANUP("GpiQueryPatternSet()",EntryName);
       return;
      }
      GpiDeleteSetId (hPS, 2L);
    }




    // This bitmap contains the check marks.
    if (( hbmp3 = GpiLoadBitmap ( hPS,RCHandle, IDBITMAP_CHECKS, 0L, 0L )) == GPI_ERROR){
       CLEANUP("GpiLoadBitmap()",EntryName);
       return;
    }


//TSS...debug purposes
    if (GpiQueryBitmapParameters(hbmp3,&BitMapHeader)==FALSE){
        CLEANUP("GpiQueryBitmapParameters()",EntryName);
        return;
    }
    sprintf(sOut,"BITMAP_CHECKS Width=%d Height=%d BitCount=%d",BitMapHeader.cx,BitMapHeader.cy,BitMapHeader.cBitCount);
    CWRITELOG(L_LOTRACE,0,sOut);

    if  (GpiSetBitmapId ( hPS, hbmp3, IDBITMAP_CHECKS ) == FALSE){
      CLEANUP("GpiSetBitmapId()",EntryName);
      return;
    }
    if ( GpiSetPatternSet (hPS, 3L) == FALSE ){
       CLEANUP("GpiSetPatternSet()",EntryName);
       return;
    }
    else{
      ptl.x = 150;
      ptl.y = 400;
      lineptl[0].x = 50  ;
      lineptl[0].y = 500 ;
      lineptl[1].x = 200 ;
      lineptl[1].y = 550 ;
      lineptl[2].x = 300 ;
      lineptl[2].y = 500 ;
      lineptl[3].x = 250 ;
      lineptl[3].y = 400 ;
      lineptl[4].x = ptl.x ;
      lineptl[4].y = ptl.y ;
      for (i = 0; i < 5; i++) {
         MapPt(lineptl[i]);
      }
      MapPt(ptl) ;
      GpiBeginArea(hPS, BA_BOUNDARY) ;
      GpiMove(hPS, &ptl) ;
      if (GpiPolyLine (hPS, 5L, lineptl) == FALSE) {
         CLEANUP("GpiPolyLine()",EntryName);
         return;
      }
      GpiEndArea(hPS) ;
      if ( GpiQueryPatternSet (hPS) == 3L) {
      MapAndWriteString( 50L, 350L,"IDBITMAP_CHECKS");
      }
      else{
       CLEANUP("GpiQueryPatternSet()",EntryName);
       return;
      }
      GpiDeleteSetId (hPS, 3L);
    }


    // This bitmap contains the crosses marks.
    if ((hbmp4 = GpiLoadBitmap ( hPS,RCHandle, IDBITMAP_CROSSES, 0L, 0L )) == GPI_ERROR){
       CLEANUP("GpiLoadBitmap()",EntryName);
       return;
    }

//TSS...debug purposes
    if (GpiQueryBitmapParameters(hbmp4,&BitMapHeader)==FALSE){
        CLEANUP("GpiQueryBitmapParameters()",EntryName);
        return;
    }
    sprintf(sOut,"BITMAP_CROSSES Width=%d Height=%d BitCount=%d",BitMapHeader.cx,BitMapHeader.cy,BitMapHeader.cBitCount);
    CWRITELOG(L_LOTRACE,0,sOut);


    if (GpiSetBitmapId ( hPS, hbmp4, IDBITMAP_CROSSES ) == FALSE){
      CLEANUP("GpiSetBitmapId()",EntryName);
      return;
    }

    if ( GpiSetPatternSet (hPS, 4L) == FALSE ){
       CLEANUP("GpiSetPatternSet()",EntryName);
       return;
    }
    else{
      ptl.x = 580;           //was 600
      ptl.y = 100;
      MapPt(ptl) ;
      GpiMove(hPS, &ptl) ;
      boxptl.x = 780 ;       //was 800
      boxptl.y = 300 ;
      MapPt(boxptl) ;
      if (GpiBox(hPS, DRO_OUTLINEFILL, &boxptl, 0L, 0L) == GPI_ERROR) {
        CLEANUP("GpiBox()",EntryName);
        return;
      }
      if ( GpiQueryPatternSet (hPS) == 4L) {
       MapAndWriteString( 600L, 80L,"IDBITMAP_CROSSES");
      }
      else{
       CLEANUP("GpiQueryPatternSet()",EntryName);
       return;
      }
      GpiDeleteSetId (hPS, 4L);
    }




    // This bitmap contains the pattern specified in abPattern

    bmp.cbFix = 12 ;
    bmp.cx = 8 ;
    bmp.cy = 8 ;
    bmp.cPlanes = 1 ;
    bmp.cBitCount = 1 ;

    pbmi = (PBITMAPINFO) cBuffer ;
    pbmi -> cbFix = 12 ;
    pbmi -> cx = 8 ;
    pbmi -> cy = 8 ;
    pbmi -> cPlanes = 1 ;
    pbmi -> cBitCount = 1 ;

    pbmi -> argbColor[0].bRed = 0 ;
    pbmi -> argbColor[0].bGreen = 0 ;
    pbmi -> argbColor[0].bBlue = 0 ;
    pbmi -> argbColor[1].bRed = 255 ;
    pbmi -> argbColor[1].bGreen = 255 ;
    pbmi -> argbColor[1].bBlue = 255 ;

    if ( ( hbmp5 = GpiCreateBitmap (hPS, (PBITMAPINFOHEADER2)&(bmp), CBM_INIT,
                                    (PBYTE) abPattern5,
                                   (PBITMAPINFO2)pbmi)) == FALSE){
       CLEANUP("GpiCreateBitmap()",EntryName);
       return;
    }
    if (GpiSetBitmapId(hPS, hbmp5, 5L) == FALSE){
       CLEANUP("GpiSetBitmapId()",EntryName);
       return;
    }

    // Draw a circle with abPattern5 as the pattern-set
    if ( GpiSetPatternSet (hPS, 5L) == FALSE ){
      CLEANUP("GpiSetPatternSet()",EntryName);
      return;
    }
    else{
     ptl.x = 450;
     ptl.y = 500;
     MapPt(ptl) ;
     DrawCircle ( hPS, &ptl);
     if ( GpiQueryPatternSet (hPS) == 5L) {
      MapAndWriteString( 350L, 350L,"CUSTOMIZED BITMAP");
     }
     else{
      CLEANUP("GpiQueryPatternSet()",EntryName);
      return;
     }
     GpiDeleteSetId (hPS, 5L);
    }


     // Set the PatternSet back to DEFAULT

     if (GpiSetPatternSet(hPS,LCID_DEFAULT)==FALSE){
         CLEANUP("GpiSetPatternSet()",EntryName);
         return ;
     }


     // Free the Module Moved later because of MetaWare compiler

    /*if (DosFreeModule(RCHandle)){   */
   /*   CLEANUP("DosFreeModule()",EntryName); */
   /*   return;                               */
   /*  }                                      */


    /************************************************************************
     * Find an 8 point Courier image (bitmap) font to use as a fill pattern.
     * The fill pattern will be the letter "a".  Assign font to selector
     * to LCID_FONT.
     ************************************************************************/


     hDC = GpiQueryDevice (hPS) ;
     if ( (DevQueryCaps (hDC,CAPS_HORIZONTAL_FONT_RES,1L,&lHorzRes) == FALSE)
        ||(DevQueryCaps (hDC,CAPS_VERTICAL_FONT_RES,1L,&lVertRes) == FALSE) ){
         CLEANUP("DevQueryCaps()",EntryName);
         return ;
     }


     // To query fonts, you first request no fonts so that the system will
     // tell you how many are available.  Once you know that, you allocate
     // memory for the font metrics returned.

     lNumberRequested = 0 ;
     lNumberReturned = GpiQueryFonts (hPS, QF_PUBLIC, NULL,
                                           &lNumberRequested,0L,NULL);




    if ((pfm=(PFONTMETRICS)malloc((SHORT)lNumberReturned*sizeof(FONTMETRICS)))==NULL){
       CLEANUP("malloc()", EntryName);
       return ;
    }

     // Call GpiQueryFonts again to request "Number" fonts and their
     // metrics to be returned in the space pointed to by "pfm"
     if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,NULL,
                                 &lNumberReturned,
                                 (LONG)sizeof(FONTMETRICS),
                                 pfm)) == GPI_ALTERROR){
          CLEANUP("GpiQueryFonts()", EntryName);

          free(pfm);
          return ;
     }
     else{

    sprintf(sOut,"expected number of fonts %ld actual number %ldn",
                  lNumberReturned, lReturned );
    CWRITELOG(L_LOTRACE,0,sOut);

        for (i = 0 ; i < (SHORT) lNumberReturned ; i++){
              fat.usRecordLength = sizeof(fat) ;
              fat.lMatch         = pfm[i].lMatch;
              fat.usCodePage     = pfm[i].usCodePage ;
              strcpy (fat.szFacename, pfm[i].szFacename) ;

    // Source change by Vish Thyagarajan 3-20-92, but these comments
    // made by L.M. Ruffing.
    // The following condition was changed to fix the CHAR FILL PATTERN
    // figure problem. It used to be displayed as solid black, now
    // it is filled with "a"s. Some LEXMARK changes had to be backed out
    // on 3-20-92 in order to get the CHAR FILL PATTERN to work properly.
              if ((fat.lMatch > 2) && (!pfm[i].fsDefn & FM_DEFN_OUTLINE)){
                if ( GpiCreateLogFont (hPS, (PSTR8) "Vish", LCID_FONT, &fat) == FONT_MATCH){
                  lMaxBaselineExtent = pfm->lMaxBaselineExt;
                  break ;
                }
              }
        }

     }


     if (GpiSetCharSet (hPS, LCID_FONT) == GPI_ERROR){
         CLEANUP("GpiSetCharSet()", EntryName);
         return ;
     }

     // Draw a triangle filled with Courier 'a's.

     if ( GpiSetPatternSet (hPS,LCID_FONT) == FALSE ){
         CLEANUP("GpiSetPatternSet()",EntryName);
         return ;
     }
     else{
       if ( GpiSetPattern (hPS, 97L) == FALSE ){
           CLEANUP("GpiSetPattern()", EntryName);
           return ;
       }
       else{
          ptl.x = 600;
          ptl.y = 400;
          MapPt(ptl) ;
          ptlTriangle[0].x = 600 ;
          ptlTriangle[0].y = 600 ;
          ptlTriangle[1].x = 800 ;
          ptlTriangle[1].y = 400 ;
          ptlTriangle[2].x = 600 ;
          ptlTriangle[2].y = 400 ;
          for (i = 0; i < 3; i++) {
             MapPt(ptlTriangle[i]);
          }
          if ( GpiBeginArea(hPS,BA_BOUNDARY) == FALSE){
           CLEANUP("GpiBeginArea()",EntryName);
           return;
          }
          else{
            if ( GpiMove(hPS, &ptl) == FALSE){
             CLEANUP("GpiMove()",EntryName);
             return;
            }
            if ( GpiPolyLine(hPS, 3L, ptlTriangle) == GPI_ERROR){
             CLEANUP("GpiPolyLine()",EntryName);
             return;
            }
            else{
               if ( GpiEndArea (hPS) == GPI_ERROR){
                CLEANUP("GpiEndArea()",EntryName);
                return;
               }
            }
          }
          if ( GpiQueryPatternSet (hPS) == LCID_FONT) {
            MapAndWriteString( 600L, 350L,"CHAR FILL PATTERN");
          }
          else{
            CLEANUP("GpiQueryPatternSet()",EntryName);
            return;
          }
          GpiSetCharSet (hPS, LCID_DEFAULT) ;

          free(pfm);
          GpiDeleteSetId (hPS, LCID_FONT);
       }
     }

     // Set the PatternSet back to DEFAULT

     if (GpiSetPatternSet(hPS,LCID_DEFAULT)==FALSE){
        CLEANUP("GpiSetPatternSet()",EntryName);
        return ;
     }


     // Free the Module Moved for MetaWare compiler from line 1144

      if (DosFreeModule(RCHandle)){
        CLEANUP("DosFreeModule()",EntryName);
        return;
       }



    EXIT_MAIN (EntryName);

  }
    return ;
}


//********************************************************
//  DrawCircle: draws a circle
//******************************************************** */
static VOID DrawCircle ( HPS hps, PPOINTL pptl )
  {
    ARCPARAMS   arcparams ;

      arcparams.lP = 100L;
      arcparams.lS = 0L;
      arcparams.lR = 0L;
      arcparams.lQ = 100L;
      MapArc(arcparams);

      GpiSetArcParams (hps, &arcparams) ;

      GpiMove (hps, pptl) ;

      GpiFullArc(hps, DRO_FILL, MAKEFIXED(1,0)) ;
  }



/************************************************************************
 ************************************************************************
 ************************************************************************
 * This is an exhaustive test of the GpiPaintRegion API.
 ************************************************************************
 ************************************************************************
 ************************************************************************/


VOID APIENTRY GpiPaintRegionExh (HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  static  PCHAR EntryName="GpiPaintRegionExh()";
  HRGN hrgna;
  HRGN hrgnb;
  HRGN hrgnc;
  RECTL arectl[3];
  RECTL brectl[1];
  RECTL crectl[2];
  POINTL  ptl, ptlShape[2];
  POINTL poly[7]  ;

  if (SelectionCall){
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
    ENTER_MAIN(EntryName);
       MapAndWriteString( 10L, 600L,"RUN THE TEST ONLY IN PELS");

       arectl[0].xLeft   = 50;          // REGION A
       arectl[0].yBottom = 100;
       arectl[0].xRight  = 250;
       arectl[0].yTop    = 150;
       arectl[1].xLeft   = 50;
       arectl[1].yBottom = 500;
       arectl[1].xRight  = 250;
       arectl[1].yTop    = 550;
       arectl[2].xLeft   = 125;
       arectl[2].yBottom = 100;
       arectl[2].xRight  = 175;
       arectl[2].yTop    = 500;



       brectl[0].xLeft   = 300;          // REGION B
       brectl[0].yBottom = 100;
       brectl[0].xRight  = 350;
       brectl[0].yTop    = 550;

       crectl[0].xLeft   = 550;         // REGION C
       crectl[0].yBottom = 100;
       crectl[0].xRight  = 600;
       crectl[0].yTop    = 550;
       crectl[1].xLeft   = 700;
       crectl[1].yBottom = 100;
       crectl[1].xRight  = 750;
       crectl[1].yTop    = 550;

       MapRect(arectl[0]);                // MAP REGION COORD. TO COORD. SP.
       MapRect(arectl[1]);
       MapRect(arectl[2]);
       hrgna = GpiCreateRegion( hPS,
                                3L,
                               arectl);


       GpiSetColor(hPS, CLR_BLUE);
       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       if (GpiPaintRegion(hPS, hrgna) == GPI_ERROR) {
         CLEANUP("GpiPaintRegion()", EntryName) ;
         return ;
       }
       MapAndWriteString( 50L, 580L,"REGION A");


       GpiDestroyRegion(hPS, hrgna);            // DESTROY REGION


       MapRect(brectl[0]);               // MAP REGION COORD. TO COORD. SP.
       hrgnb = GpiCreateRegion( hPS,
                                1L,
                               brectl);

       MapRect(crectl[0]);               // MAP REGION COORD. TO COORD. SP.
       MapRect(crectl[1]);
       hrgnc = GpiCreateRegion( hPS,
                               2L,
                               crectl);

       GpiSetColor(hPS, CLR_BLUE);
       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       if (GpiPaintRegion(hPS, hrgnb)  == GPI_ERROR) {
         CLEANUP("GpiPaintRegion()", EntryName) ;
         return ;
       }
       MapAndWriteString( 300L, 580L,"REGION B");


       GpiSetColor(hPS, CLR_BLUE);
       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       if (GpiPaintRegion(hPS, hrgnc) ==  GPI_ERROR) {
         CLEANUP("GpiPaintRegion()", EntryName) ;
         return ;
       }
       MapAndWriteString( 550L, 580L,"REGION C");

       GpiDestroyRegion (hPS, hrgnb) ;
       GpiDestroyRegion (hPS, hrgnc) ;


       ptl.x = 350L ;
       ptl.y = 540L ;
       MapPt(ptl) ;
       GpiMove(hPS, &ptl) ;

       poly[0].x  = 350L ;
       poly[0].y  = 540L ;
       poly[1].x  = 450L ;
       poly[1].y  = 375L ;
       poly[2].x  = 350L ;
       poly[2].y  = 355L ;
       poly[3].x  = 350L ;
       poly[3].y  = 330L ;
       poly[4].x  = 450L ;
       poly[4].y  = 260L ;
       poly[5].x  = 350L ;
       poly[5].y  = 130L ;
       poly[6].x  = 350L ;
       poly[6].y  = 110L ;

       MapPt(poly[0]) ;
       MapPt(poly[1]) ;
       MapPt(poly[2]) ;
       MapPt(poly[3]) ;
       MapPt(poly[4]) ;
       MapPt(poly[5]) ;
       MapPt(poly[6]) ;

       if (GpiSetLineWidthGeom(hPS, 30L) == FALSE){
          CLEANUP("GpiSetLineWidthGeom", EntryName) ;
          return ;
       }
       GpiSetColor(hPS, CLR_BLUE);
       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       if (GpiBeginPath(hPS, 1L) == FALSE){
          CLEANUP("GpiBeginPath", EntryName) ;
          return ;
       }
       GpiPolyFillet(hPS, 7L, (PPOINTL)poly) ;
       if (GpiEndPath(hPS) == FALSE){
          CLEANUP("GpiEndPath", EntryName) ;
          return ;
       }
       if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR){
          CLEANUP("GpiStrokePath", EntryName) ;
          return ;
       }



       ptl.x = 600;
       ptl.y = 540;
       MapPt(ptl);
       GpiMove (hPS, &ptl);

       ptlShape[0].x = 650;
       ptlShape[0].y = 275;
       MapPt(ptlShape[0]);
       ptlShape[1].x = 700;
       ptlShape[1].y = 540 ;
       MapPt(ptlShape[1]);

       if (GpiSetLineWidthGeom(hPS, 30L) == FALSE){
          CLEANUP("GpiSetLineWidthGeom", EntryName) ;
          return ;
       }
       GpiSetColor(hPS, CLR_BLUE);
       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       if (GpiBeginPath(hPS, 1L) == FALSE){
          CLEANUP("GpiBeginPath", EntryName) ;
          return ;
       }
       GpiPolyLine(hPS, 2L, ptlShape);
       if (GpiEndPath(hPS) == FALSE){
          CLEANUP("GpiEndPath", EntryName) ;
          return ;
       }
       if (GpiStrokePath(hPS, 1L, 0L) == GPI_ERROR){
          CLEANUP("GpiStrokePath", EntryName) ;
          return ;
       }

    EXIT_MAIN (EntryName);

  }
    return ;
}


