#ifndef GPIARC_H
#define GPIARC_H
/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module name:  GPIARC
 *
 * Purpose:  Include file for GpiArc DLL.
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *
 * SRS References: Section 5.3
 *
 * Contents: This file contains the following definitions:
 *
 *           - function prototypes
 *           - defines specific to GpiArc
 *           - includes specific to GpiArc
 *
 * Limitations: none
 *
 *\\end
****************************************************************************/

VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);
VOID  APIENTRY gpi_arc_all(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY gpi_arc_pre1(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY gpi_arc_pre2(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY gpi_arc_app(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiSetArcParamsExh1(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiSetArcParamsExh2(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiSetDefArcParamsExh1(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiSetDefArcParamsExh2(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiQueryCurrentLinePosExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiFullArcExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiPartialArcExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiPointArcExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiPolyFilletExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiPolyFilletSharpExh(HPS hps, HWND wnd_client_h, BOOL selection_call);
VOID  APIENTRY GpiPolySplineExh(HPS hps, HWND wnd_client_h, BOOL selection_call);

#define NUMARCTESTS  13

#define FIXEDTOLONG 65536

#endif
