/***************************************************************************
 *\\ddd
 * Subtask Name:  PDVT
 *
 * Module name:  arc_grid.c
 * RCB 10/29/91:  NOTE: THIS FILE IS BASICALLY GPI_GRID.C WITH MINOR CHANGES
 *                MADE IN ORDER TO ALLOW LIMITED INTEGRATED USE OF PHASE I AND
 *                PHASE II FUNCTIONS FOR GPIARC.DLL.  GPIARC IS A PHASE I DLL,
 *                BUT IT WAS BENEFICIAL TO WRITE THE RETURN CODE TESTS UTILIZING
 *                PHASE II FUNCTIONS.  PHASE I AND PHASE II ARE NORMALLY
 *                INCOMPATIBLE.
 *
 * Purpose:  Standard Grid functions for use in GPI precision tests
 *
 * Revision Log:  10/20/90, PDVT, Kim Cairns
 *                - Initial creation
 *                12/05/90, PDVT, Kim Cairns
 *                - Code completion
 *                02/04/91, PDVT, Kim Cairns
 *                - Added logic to ensure borders on every grid
 *                02/11/91, PDVT, Kim Cairns
 *                - Made consistent with gre_grid.c
 *
 * Contents:
 *            arc_grid()          - draw grid with gpi calls
 *
 * Design Overview:
 *            This module is designed to be linked with any GPI DLL requiring
 *            the drawing of a standard grid to measure precision.
 *
 * Limitations:
 *            None
 *
 *\\end
 ***************************************************************************/

#define INCL_WIN      // win function definitions
#define INCL_GPI      // gpi definitions
#define INCL_DEV      // device definitions

#include <string.h>
#include <stdio.h>
#include <os2.h>
#include "PTTDLLDF.h" // test case defines
#include "arc_grid.h" // gpi grid function header file
#include "arc_util.h"

 /***************************************************************************
 *\\ddd
 * Routine name:  arc_grid()
 *
 * Purpose:
 *            This is the generic grid creation routine that is called with a
 *            parameter for scale of grid.
 *
 * System Requirements:  None
 *
 * Revision Log:  11/09/90, PDVT, Kim Cairns
 *                   - initial module completion
 *
 * Inputs:
 *            hPS                 - presentation space handle
 *            scale               - scale of grid, suggested values:
 *                                  HALFINCH - 1/2 inch squares
 *                                  INCH     - 1 inch squares
 *                                  TWOINCH  - 2 inch squares
 *                                  (These are defined in arc_grid.h)
 *
 * Outputs:
 *            None
 *
 * Subroutines Required:
 *            None
 *
 * Limitations:
 *            None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  call set_delta function to set current pels per inch and page size
 *  for vertical lines:
 *    Map starting point of line
 *    Use GpiSetCurrentPosition to set starting point of line
 *    Map ending point of line
 *    Draw line using GpiLine
 *  for horizontal lines:
 *    Map starting point of line
 *    Use GpiSetCurrentPosition to set starting point of line
 *    Map ending point of line
 *    Draw line using GpiLine
 *
 *\\end
 ***************************************************************************/

VOID EXPENTRY arc_grid (HPS hPS, LONG scale)
{
  POINTL ptPoint1, ptPoint2;

  /***********************************************************************
   *  This draws the grid used by most of the GPI Precision tests.
   ***********************************************************************/

  // This function sets delta_x, delta_y, pg_size_x, pg_size_y
  set_delta1(hPS);

  // Draw first vertical line on left of page
  ptPoint1.x = 0L;
  ptPoint1.y = 0L;                               // starting point at (0,0)
  MapPt(ptPoint1);
  GpiSetCurrentPosition (hPS, &ptPoint1);

  ptPoint2.x = 0L;
  ptPoint2.y = pg_size_y*delta_y;                // vertical pels per page
  MapPt(ptPoint2);
  GpiLine (hPS, &ptPoint2);

  if (scale == TWOINCH)                          // make even page width for
  {                                              // grid with two inch squares
     if ((pg_size_y % 2) != 0)
        pg_size_y = pg_size_y - 1;
     if ((pg_size_x % 2) != 0)
        pg_size_x = pg_size_x - 1;
  }

  // Draw the rest of the vertical lines.
  for (ptPoint1.x  = delta_x * scale / 2;
       ptPoint1.x <= (pg_size_x*delta_x);
       ptPoint1.x += delta_x * scale / 2)
  {
     ptPoint2.x = ptPoint1.x;
     ptPoint2.y = 0L;
     MapPt(ptPoint2);
     GpiSetCurrentPosition(hPS, &ptPoint2);
     ptPoint2.y = MapY(pg_size_y*delta_y);
     GpiLine(hPS, &ptPoint2);
  } /* End the FOR */


  // Draw first horizontal line at bottom of page
  ptPoint1.x = 0L;
  ptPoint1.y = 0L;                               // starting at (0,0)
  MapPt(ptPoint1);
  GpiSetCurrentPosition (hPS, &ptPoint1);

  ptPoint2.x = pg_size_x*delta_x;                // horizontal pels per page
  ptPoint2.y = 0L;
  MapPt(ptPoint2);
  GpiLine (hPS, &ptPoint2);


  // Draw the rest of the horizontal lines
  for (ptPoint1.y  = delta_y * scale / 2;
       ptPoint1.y <= (pg_size_y*delta_y);
       ptPoint1.y += delta_y * scale / 2)
  {
     ptPoint2.x = 0L;
     ptPoint2.y = ptPoint1.y;
     MapPt(ptPoint2);
     GpiSetCurrentPosition(hPS, &ptPoint2);
     ptPoint2.x = MapX(pg_size_x*delta_x);
     GpiLine(hPS, &ptPoint2);
  } /* End the FOR */

}  /* End arc_grid */

