/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************\
**
** SOURCE FILE NAME = Surface.c
**
** DESCRIPTIVE NAME = Contains support for new 2.2 raster engine
**
**
** VERSION = V1.0
**
** DATE        06/27/94
**
** DESCRIPTION This module contains routines that the new 2.2 raster engine
**             uses.
**
**
** FUNCTIONS   DevicePalette
**             LockDevice
**             QueryDeviceSurface
**
** NOTES
**
**
** STRUCTURES
**
** EXTERNAL REFERENCES
**
** EXTERNAL FUNCTIONS
**
*/
#pragma pack(1)
#define INCL_DOS
#define INCL_GPI
#define INCL_DEV
#define INCL_SPL
#define INCL_SPLDOSPRINT
#define INCL_GPIPRIMITIVES
#include <os2.h>


#define  PASCAL
#define  FAR
#define INCL_VMANDDI
#define INCL_DDIBUNDLES
#include <ddi.h>

#define INCL_PM
#define INCL_GREALL
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_GRE_DEVICESURFACE
#define  INCL_GPILOGCOLORTABLE

#define INCL_GENPLIB_PATTERNS          /* genplib pattern create/del        */
#define INCL_GENPLIB_WATERMARKS
#define INCL_GENPLIB_LAYOUT
#include <genplib.h>

#include <pmddi.h>
#include "inc\prdtypet.h"
#include "inc\prdptypt.h"
#include "inc\prdttypt.h"
#include "inc\prddct.h"
#include "inc\prdcextf.h"

extern ULONG aulStdColors[N_STDCOLORS];

// @V3.1140397
extern ULONG prdq_QueryDeviceCaps( HDC, LONG, ULONG *, LONG, PDDC, ULONG );

/*
** The follow palettes were taken from the engine.
** We will use the 256 hardware palette as a default.
*/
ULONG ulDefaultPalette256[256] =
{
  /**************************************************************/
  /* start off with the first half of the colors                */
  /**************************************************************/
  0x80000000, 0x80000055, 0x800000AA, 0x800000FF, 0x80002400, 0x80002455,
  0x800024AA, 0x800024FF, 0x80004900, 0x80004955, 0x800049AA, 0x800049FF,
  0x80006D00, 0x80006D55, 0x80006DAA, 0x80006DFF, 0x80009200, 0x80009255,
  0x800092AA, 0x800092FF, 0x8000B600, 0x8000B655, 0x8000B6AA, 0x8000B6FF,
  0x8000DB00, 0x8000DB55, 0x8000DBAA, 0x8000DBFF, 0x8000FF00, 0x8000FF55,
  0x8000FFAA, 0x8000FFFF, 0x802B0000, 0x802B0055, 0x802B00AA, 0x802B00FF,
  0x802B2400, 0x802B2455, 0x802B24AA, 0x802B24FF, 0x802B4900, 0x802B4955,
  0x802B49AA, 0x802B49FF, 0x802B6D00, 0x802B6D55, 0x802B6DAA, 0x802B6DFF,
  0x802B9200, 0x802B9255, 0x802B92AA, 0x802B92FF, 0x802BB600, 0x802BB655,
  0x802BB6AA, 0x802BB6FF, 0x802BDB00, 0x802BDB55, 0x802BDBAA, 0x802BDBFF,
  0x802BFF00, 0x802BFF55, 0x802BFFAA, 0x802BFFFF, 0x80550000, 0x80550055,
  0x805500AA, 0x805500FF, 0x80552400, 0x80552455, 0x805524AA, 0x805524FF,
  0x80554900, 0x80554955, 0x805549AA, 0x805549FF, 0x80556D00, 0x80556D55,
  0x80556DAA, 0x80556DFF, 0x80559200, 0x80559255, 0x805592AA, 0x805592FF,
  0x8055B600, 0x8055B655, 0x8055B6AA, 0x8055B6FF, 0x8055DB00, 0x8055DB55,
  0x8055DBAA, 0x8055DBFF, 0x8055FF00, 0x8055FF55, 0x8055FFAA, 0x8055FFFF,
  0x80800000, 0x80800055, 0x808000AA, 0x808000FF, 0x80802400, 0x80802455,
  0x808024AA, 0x808024FF, 0x80804900, 0x80804955, 0x808049AA, 0x808049FF,
  0x80806D00, 0x80806D55, 0x80806DAA, 0x80806DFF,

  /**************************************************************/
  /* now come the group of 32 greys                             */
  /**************************************************************/
  0x80080808, 0x800F0F0F, 0x80171717, 0x801F1F1F, 0x80272727, 0x802E2E2E,
  0x80363636, 0x803E3E3E, 0x80464646, 0x804D4D4D, 0x80555555, 0x805D5D5D,
  0x80646464, 0x806C6C6C, 0x80747474, 0x807C7C7C, 0x80838383, 0x808B8B8B,
  0x80939393, 0x809B9B9B, 0x80A2A2A2, 0x80AAAAAA, 0x80B2B2B2, 0x80B9B9B9,
  0x80C1C1C1, 0x80C9C9C9, 0x80D1D1D1, 0x80D8D8D8, 0x80E0E0E0, 0x80E8E8E8,
  0x80F0F0F0, 0x80F7F7F7,

  /**************************************************************/
  /* now back to the colours again                              */
  /**************************************************************/
  0x80809200, 0x80809255, 0x808092AA, 0x808092FF, 0x8080B600, 0x8080B655,
  0x8080B6AA, 0x8080B6FF, 0x8080DB00, 0x8080DB55, 0x8080DBAA, 0x8080DBFF,
  0x8080FF00, 0x8080FF55, 0x8080FFAA, 0x8080FFFF, 0x80AA0000, 0x80AA0055,
  0x80AA00AA, 0x80AA00FF, 0x80AA2400, 0x80AA2455, 0x80AA24AA, 0x80AA24FF,
  0x80AA4900, 0x80AA4955, 0x80AA49AA, 0x80AA49FF, 0x80AA6D00, 0x80AA6D55,
  0x80AA6DAA, 0x80AA6DFF, 0x80AA9200, 0x80AA9255, 0x80AA92AA, 0x80AA92FF,
  0x80AAB600, 0x80AAB655, 0x80AAB6AA, 0x80AAB6FF, 0x80AADB00, 0x80AADB55,
  0x80AADBAA, 0x80AADBFF, 0x80AAFF00, 0x80AAFF55, 0x80AAFFAA, 0x80AAFFFF,
  0x80D50000, 0x80D50055, 0x80D500AA, 0x80D500FF, 0x80D52400, 0x80D52455,
  0x80D524AA, 0x80D524FF, 0x80D54900, 0x80D54955, 0x80D549AA, 0x80D549FF,
  0x80D56D00, 0x80D56D55, 0x80D56DAA, 0x80D56DFF, 0x80D59200, 0x80D59255,
  0x80D592AA, 0x80D592FF, 0x80D5B600, 0x80D5B655, 0x80D5B6AA, 0x80D5B6FF,
  0x80D5DB00, 0x80D5DB55, 0x80D5DBAA, 0x80D5DBFF, 0x80D5FF00, 0x80D5FF55,
  0x80D5FFAA, 0x80D5FFFF, 0x80FF0000, 0x80FF0055, 0x80FF00AA, 0x80FF00FF,
  0x80FF2400, 0x80FF2455, 0x80FF24AA, 0x80FF24FF, 0x80FF4900, 0x80FF4955,
  0x80FF49AA, 0x80FF49FF, 0x80FF6D00, 0x80FF6D55, 0x80FF6DAA, 0x80FF6DFF,
  0x80FF9200, 0x80FF9255, 0x80FF92AA, 0x80FF92FF, 0x80FFB600, 0x80FFB655,
  0x80FFB6AA, 0x80FFB6FF, 0x80FFDB00, 0x80FFDB55, 0x80FFDBAA, 0x80FFDBFF,
  0x80FFFF00, 0x80FFFF55, 0x80FFFFAA, 0x80FFFFFF

};

// -------------------------------------------------------------------------------------------------------------------------
// mandatory in GRE22 model
// -----------------------------------------------------------------------------

LONG APIENTRY DevicePalette( HDC hdc, PDEVICESURFACE pds, PDDC pddc, ULONG ulFunction )
{
  return TRUE;
}



LONG APIENTRY LockDevice( )
{
  return 0;
}




LONG APIENTRY QueryDeviceSurface( PDDC pddc, PDEVICESURFACE pDS )
{
  static struct 
  {
    ULONG lMaxRes;
    ULONG lBMPSize;
  } 
  PatSize[] =  {  768,  64,
                 1536, 128,
                 3072, 256,
                 6144, 512,
                    0,   0 };

  INT iType;
  ULONG ulRC;
  ULONG CapValue;                                                 //@V3.1141288
  ULONG ulPatBMPSize, n;

  /*
  ** Store the pointer in PostScript's DDC.  The DS contains the surface
  ** device structure.
  */
  pddc->pDeviceSurface = pDS;

  /*
  ** These fields are required.
  */
  pDS->ulLength = sizeof( DEVICESURFACE );
  pDS->ulDSFlgs  = DS_TOPBOTTOM | DS_BYTEALIGN | DS_KEEP_EXTFORMAT;

  // put my lock/unlock pfn in here -- now NOP's
  pDS->pfnLockPhysDev   = (PFN)LockDevice;
  pDS->pfnUnLockPhysDev = (PFN)LockDevice;

  /*
  ** Default PostScript style ratio is 1:1.
  */
  pDS->ulStyleRatio = 1;

//pDS->pHWPalette = aulStdColors;
  pDS->pHWPalette = (PVOID)ulDefaultPalette256;

  /*
  ** Set the caps.  This is done in prdq_QueryDeviceCaps.  The only problem
  ** is that the function was designed to work with OD_MEMORY.  For this case,
  ** temporarily set the type to 0, call the function, then set it back to
  ** the original ID.
  */
  iType = pddc->iType;
  pddc->iType = OD_DIRECT;
  pDS->ulCapsCnt = CAPS_MAX_CAPS;
  ulRC = prdq_QueryDeviceCaps( (HDC) 0, 0, pDS->DevCaps, CAPS_MAX_CAPS, pddc,
                                0 );
  pddc->iType = iType;

  //Some temp corrections
  pDS->DevCaps[CAPS_COLOR_BITCOUNT] = 8;
  pDS->DevCaps[CAPS_COLORS ] = 256;
/*pDS->DevCaps[CAPS_PHYS_COLORS] = 256; Remove at request of Lotus */
  pDS->DevCaps[CAPS_COLOR_INDEX] = 255;

//if ( pddc->iType == OD_MEMORY        &&                         //@V3.1141288
  if ( pddc->iType == OD_MEMORY )
  {
    if ( ! pddc->pdv->fAllocatedPatterns  )
    {
      /*      ** Patterns bitmap size depends on resolution
      ** There are Pel sizes for resolutions in GENPLIB 
      **   Resolution PelSize               Bitmap size
      **    385,  768, 8,        600 dpi =>  8*8 = 64
      **    769, 1536, 16,      1200 dpi => 16*8 = 128L 
      **   1537, 3072, 32,      2400 dpi => 32*8 = 256L
      */
      ulPatBMPSize = 64L;
      for ( n = 0; PatSize[n].lMaxRes ; n++ )
      {
        if ( pddc->pdv->canvas.Res.x <= PatSize[n].lMaxRes
          && pddc->pdv->canvas.Res.y <= PatSize[n].lMaxRes )                      
        {
          ulPatBMPSize = PatSize[n].lBMPSize;
          break;
        }
      }
      
    
      if ( GplPatternCreateBitmaps( pddc->pdv->pDCHeap,
////////////////////////////        pddc->pdv->canvas.iRes,        //@V3.1147608
                                    pddc->pdv->canvas.Res.x,       //@V3.1147608
////////////////////////////        pddc->pdv->canvas.iRes,        //@V3.1147608
                                    pddc->pdv->canvas.Res.y,       //@V3.1147608
                                    ulPatBMPSize, ulPatBMPSize,    
                                  
                                    (PBMAPINFO)&pDS->abmapinfoDefPattern,
                                    DEFAULT_PATTERNS_NUMBER
                                    , FALSE
                                    ) )
      {
        pddc->pdv->fAllocatedPatterns = TRUE;
      }
    }

    CapValue = pDS->DevCaps[CAPS_ADDITIONAL_GRAPHICS]             //@V3.1141288
               &~CAPS_FONT_OUTLINE_DEFAULT
               &~CAPS_FONT_IMAGE_DEFAULT
               &~CAPS_FONT_OUTLINE_MANAGE
               &~CAPS_FONT_IMAGE_MANAGE
               &~CAPS_ENHANCED_FONTMETRICS
               | CAPS_CLIP_FILLS ;         /* turn on the pre-clip */
   pDS->DevCaps[CAPS_ADDITIONAL_GRAPHICS] = CapValue;             //@V3.1141288
  }

  if ( ulRC == SUCCESS )
    return 0;
  else
    return -1;
}

