/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************\
**
** SOURCE FILE NAME = PSDJP.C
**
** DESCRIPTIVE NAME = Contains Dynamic Job Properies related routines.
**
**
**
**
*/

#pragma pack(1)
#define INCL_PM
#define INCL_DEV
#define INCL_DEVDJP
#define INCL_GRE_DCS
#define INCL_GRE_DEVICESURFACE
#define INCL_DOSMODULEMGR
#include <stdio.h>
#include <string.h>
#include <os2.h>
//Next includes are for pddc... in prddct.h
#define INCL_DDIBUNDLES
#define INCL_VMANDDI
#include <ddi.h>
#include <pmddi.h>

//#define  INCL_GENPLIB_ASSERT
#define  INCL_GENPLIB_ERROR
#define  INCL_GENPLIB_MEMORY
#define  INCL_GENPLIB_PATTERNS          /* genplib pattern create/del        */
#define  INCL_GENPLIB_LAYOUT
#include <genplib.h>

#include "inc\prdttypt.h"
#include "inc\prdtypet.h"
#include "inc\prdptypt.h"
#include "inc\prddct.h"
#include "inc\ppdialog.h"
#include "inc\init.h"
#include "inc\utl.h"
#include "inc\uinames.h"
#include "inc\dlg.h"
#include "inc\config.h"
#include "inc\psdjp.h"
#include "inc\profile.h"

#define SIMPLESIZE( count ) ( DJP_HEADER_SIZE + sizeof( ULONG ) * count )

#define FORM_NAMES 0x0001
#define FORM_SIZES 0x0002
#define FORM_COUNT 0x0004

#define TRAY_COUNT 0x0001
#define TRAY_NAMES 0x0002

#define RES_COUNT  0x0001
#define RES_LIST   0x0002

#define DJPFORMNAMESIZE 32
#define DJPTRAYNAMESIZE 32
#define HCINFONAMESIZE  32
#define BUFFER_SIZE     2048
#define DJP_PROPS_SAME  0                                         //@V4.1193787

typedef struct _IMAGEAREA {
  SHORT LLx;
  SHORT LLy;
  SHORT URx;
  SHORT URy;
} IMAGEAREA, *PIMAGEAREA;

typedef struct _PAPERDIM {
  SHORT Width;
  SHORT Height;
} PAPERDIM, *PPAPERDIM;



typedef struct _FORMINFO {   //For each form
  CHAR       szFormName[MAX_PSIZE];    //Real -or- User defined
  CHAR       szXLTFormName[MAX_PSIZE]; //Translated name if any
  CHAR       szRealName[MAX_PSIZE];    //If not empty real name of user form
  CHAR       szOldSuffix[MAX_PSIZE];   //The old style name
  IMAGEAREA  ImageableArea;
  PAPERDIM   PaperDim;
  HCINFO     HCInfo;
  BOOL       fProcessed;               //Mark if processed
  DJPT_PAPERSIZE lPaperSize;
} FORMINFO, *PFORMINFO;

typedef struct _FORMLIST {
  LONG      lFormCount;
  FORMINFO  aForms[ 1 ];
} FORMLIST, *PFORMLIST;

typedef struct _TRAYINFO {
  CHAR szTrayName[MAX_PSIZE];       //Tray name
  CHAR szXLTTrayName[MAX_PSIZE];    //Translated tray name
  CHAR szFormName[MAX_PSIZE];       //Form name
  BOOL fProcessed;                  //Mark if processed
  DJPT_TRAYTYPE lTrayType;          //Tray type if known
} TRAYINFO, * PTRAYINFO;

typedef struct _TRAYLIST {
  LONG      lTrayCount;
  LONG      lDupCount;
  TRAYINFO  aTrays[ 1 ];
} TRAYLIST, * PTRAYLIST;

#define MAXRESCOUNT 8
typedef struct _RESINFO {
  RESOLUTION        Res;
  DJPT_PRINTQUALITY Quality;
  PSZ               pszResStr;
} RESINFO, * PRESINFO;

typedef struct _DJPRESLIST {
  LONG    lResCount;
  RESINFO aRes[ MAXRESCOUNT ];
} DJPRESLIST, * PDJPRESLIST;


//TEMP
/* -----------------------------------------------------------------
** DJP_C_TRAY
**
** Setting the tray has the side effect of setting the form.  Therefore,
** the currently selected form will be returned alongside the tray name.
**
*/
typedef struct _djpTray   /* dt */
{
   CHAR            szTrayname[32];        /* Tray name                    */
   /*   -= Informational only =-   */
   DJPT_PAPERSIZE  djppsFormID;           /* Simple form id (if > 0)      */
   CHAR            szFormname[32];        /* System Form name             */
}  DJPT_TRAY, *PDJPT_TRAY;

/* This is an eXtended djp item typedef.  Use it to define an item with
** a type so you dont have to "allocate" memory for it.  Just add the
** type to the Itype UNION
*/
typedef struct _XDJPITEM {
  ULONG       cb;             /* I/O - sizeof DJP_ITEM structure   */
  ULONG       ulProperty;     /* I   - Which property              */
  LONG        lType;          /* I/O - DJP_ALL or DJP_CURRENT.     */
                              /*       DJP_ERROR_XXX if error.     */
  ULONG       ulNumReturned;  /* O   - How many elements have been */
                              /*       returned                    */
  union
  {
    ULONG       ulValue;        /* O   - Variably sized based on     */
                                /*       ulProperty.  The smallest   */
                                /*       is a ULONG in size          */
    /* Add the item types here */
    DJPT_RESOLUTION Res;
    DJPT_FORM       Form;

  } Itype;

} XDJPITEM, * PXDJPITEM;

/* Points to Millimeters */
#define PTS2MM( x ) ( ((LONG)x *254L) / 720L )
/* Points to Millimeters up */                                    //@V3.1154783
#define PTS2MMU( x ) ( (((LONG)x * 254L) + 71) / 720L )
/* Points to Millimeters Rounded */
#define PTS2MMR( x ) (((((LONG)x * 254L) / 72L) + 5L) / 10L)

extern PVOID pProcessHeap;
extern ULONG ULGreVersion;
extern PFN   pfnSetDeviceSurface;
extern PBYTE StringTable[MAX_STRINGS]; /* devmode.c                         */
extern HMODULE pscript_module;               // memory.c

/* External Functions */
extern INT NewUserForms( PCNFDATA, INT, PSZ, PSZ );   //Query.c
extern INT  _Optlink CompareRealNames( PSZ, PSZ );
extern PFORMSTRUCT GetImageableArea( SHORT, PFORMSTRUCT, PDESPPD, PBYTE );
extern BOOL ReadFormINIData( PSZ, PBYTE, INT );
extern BOOL QueryNextSubkey( PSZ *, PSZ, INT );
extern PSZ GetDefaultPageSize( PDESPPD, PBYTE );
extern PBYTE TerminateTranslationString( PBYTE );
extern PDESPPD LoadPPBResource( PDV, PSZ );
extern VOID FreePPBResource( PDESPPD );
extern LONG APIENTRY QueryDeviceSurface( PDDC, PDEVICESURFACE );
extern VOID PSDocSetUp( PDDC, BOOL );
extern PBYTE QueryUIOptionString( PDESPPD, PUI_SEL, PBYTE, PINT, PUI_BLOCK * );
extern INT  SetUIOption( PDESPPD, PUI_SEL, PBYTE, PBYTE );
extern VOID GetCurrentResolution( PRESOLUTION, PDESPPD, PCNFDATA );      //@V3.1147608
extern VOID ResStrToBin( PSZ, PRESOLUTION );                             //@V3.1147608
extern ULONG GetCountryCode( VOID );
extern PUI_ENTRY QueryEntryFromOption( PBYTE, PUI_BLOCK, PBYTE, PINT );
extern VOID NupSetUp( PDDC );                                            //Nup
extern VOID PSNup( PDDC );                                               //Nup
extern PGLCB QueryLayoutCBFromCNFDATA( PCNFDATA );

/* Local Functions */
LONG LoadTrayList( PDESPPD, PCNFDATA, LONG, PTRAYLIST * );
VOID FreeTrayList( PTRAYLIST );
PFORMINFO SearchFormList( PFORMLIST, PSZ );

#define STL_TRAYNAME 0x1                             // Search for Tray in TrayList
#define STL_FORMNAME 0x2                             // Search for Form in TrayList
PTRAYINFO SearchTrayList( PTRAYLIST, PSZ, ULONG );   // @DRV_AUTO

// @V4.0158787
DJPT_TRAYTYPE MapTrayNametoID( PTRAYINFO );
VOID FillFormStruc( PDJPT_FORM, PFORMINFO, PTRAYINFO, PDESPPD );

LONG NewHardCopyCaps( LONG, LONG, PHCINFO, PDDC );
ULONG CompareDJPProps( PDDC, PREFDATA, PCNFDATA );

static SHORT asDefaultSize[ 2 ] = { 612, 792 };
static IMAGEAREA asDefaultImg   = { 1, 1, 600, 790 };

typedef struct _MAPPAIR {
  PSZ            pszFormName;
  DJPT_PAPERSIZE lPaperSize;
} MAPPAIR, *PMAPPAIR;

//Keep this list sorted by lPaperSize (FormID )
static MAPPAIR MapPairs[] = {
{"10X14"             , DJP_PSI_10X14            },
{"11X17"             , DJP_PSI_11X17            },
{"ISOA0"             , DJP_PSI_A0               },
{"ISOA1"             , DJP_PSI_A1               },
{"ISOA2"             , DJP_PSI_A2               },
{"A3"                , DJP_PSI_A3               },
{"ISOA3"             , DJP_PSI_A3               },
{"A4"                , DJP_PSI_A4               },
{"A4Small"           , DJP_PSI_A4_SMALL         },
{"ISOA4"             , DJP_PSI_A4               },
{"A5"                , DJP_PSI_A5               },
{"ARCHB"             , DJP_PSI_ARCHITECT_BSHEET },
{"ARCHC"             , DJP_PSI_ARCHITECT_CSHEET },
{"ARCHD"             , DJP_PSI_ARCHITECT_DSHEET },
{"ARCHE"             , DJP_PSI_ARCHITECT_ESHEET },
{"B4"                , DJP_PSI_B4               },
{"B5"                , DJP_PSI_B5               },
{"EnvB5"             , DJP_PSI_ENV_B5           },
{"Envelope.516.729"  , DJP_PSI_ENV_B5           },                //@V4.0183321
{"COM10"             , DJP_PSI_ENV_C10          },
{"Com10"             , DJP_PSI_ENV_C10          },
{"Comm10"            , DJP_PSI_ENV_C10          },
{"Envelope.com10"    , DJP_PSI_ENV_C10          },
{"Envelope.297.684"  , DJP_PSI_ENV_C10          },                //@V4.0183321
{"C5Envelope"        , DJP_PSI_ENV_C5           },
{"Envelope.c5"       , DJP_PSI_ENV_C5           },
{"Envelope.459.649"  , DJP_PSI_ENV_C5           },                //@V4.0183321
{"Comm6Envelope"     , DJP_PSI_ENV_C6           },
{"Com9"              , DJP_PSI_ENV_C9           },
{"Comm9"             , DJP_PSI_ENV_C9           },
{"Comm9Envelope"     , DJP_PSI_ENV_C9           },
{"DL"                , DJP_PSI_ENV_DL           },
{"DLEnvelope"        , DJP_PSI_ENV_DL           },
{"EnvDL"             , DJP_PSI_ENV_DL           },
{"Envelope.dl"       , DJP_PSI_ENV_DL           },
{"Envelope.312.624"  , DJP_PSI_ENV_DL           },                //@V4.0183321
{"Envelope.monarch"  , DJP_PSI_ENV_MONARCH      },
{"Envelope.279.540"  , DJP_PSI_ENV_MONARCH      },                //@V4.0183321
{"EnvMonarch"        , DJP_PSI_ENV_MONARCH      },                //@V4.0183321
{"Monarch"           , DJP_PSI_ENV_MONARCH      },                //@V4.0183321
{"Executive"         , DJP_PSI_EXECUTIVE        },
{"Folio"             , DJP_PSI_FOLIO            },
{"Ledger"            , DJP_PSI_LEDGER           },
{"Legal"             , DJP_PSI_LEGAL            },
{"Letter"            , DJP_PSI_LETTER           },
{"LetterSmall"       , DJP_PSI_LETTERSMALL      },
{"Note"              , DJP_PSI_NOTE             },
{"Quarto"            , DJP_PSI_QUATRO           },
{"Statement"         , DJP_PSI_STATEMENT        },
{"Tabloid"           , DJP_PSI_TABLOID          },
{ NULL               , 0                        }
};

typedef struct _MAPTRAY {
  PSZ           pszTrayName;
  DJPT_TRAYTYPE lTrayType;
} MAPTRAY, *PMAPTRAY;

//Keep this list sorted by lTrayType (TrayID )
static MAPTRAY MapTrays[] = {
{AUTOTRAY_STRING     , DJP_TRY_AUTO             },
{MANUALFEED_STRING   , DJP_TRY_MANUAL           },
{"AUTOSELECT"        , DJP_TRY_AUTO             },
{"Auto"              , DJP_TRY_AUTO             },
{"AutoSelect"        , DJP_TRY_AUTO             },
{"Cassette"          , DJP_TRY_CASSETTE         },
{"Envelope"          , DJP_TRY_ENVELOPE         },
{"EnvelopeManual"    , DJP_TRY_ENVMANUAL        },
{"LargeCapacity"     , DJP_TRY_LARGECAPACITY    },
{"Lower"             , DJP_TRY_LOWER            },
{"Manual"            , DJP_TRY_MANUAL           },
{"ManualFeed"        , DJP_TRY_MANUAL           },
{"Middle"            , DJP_TRY_MIDDLE           },
{"Upper"             , DJP_TRY_UPPER            },  /* Find this first */
{"OnlyOne"           , DJP_TRY_ONLYONE          },
{ NULL               , 0                        }
};


#define QUALITYCOUNT 4
static DJPT_PRINTQUALITY QualityList[ QUALITYCOUNT ] = {
  DJP_PQL_HIGH,
  DJP_PQL_MEDIUM,
  DJP_PQL_LOW,
  DJP_PQL_DRAFT };



/*****************************************************************************\
**
** FUNCTION: djp_s_orientation
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_s_orientation(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction   //Action to perform
     )
{
  ULONG ulSize;
  PDJPT_ORIENTATION pDJPOri;

  //Only support portrait and landscape
  ulSize = DJP_HEADER_SIZE + ( ( pDJP->lType == DJP_CURRENT ) ?
           sizeof( DJPT_ORIENTATION )  : sizeof( DJPT_ORIENTATION ) * 2 );

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )  //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;
  pDJPOri = (PDJPT_ORIENTATION)&pDJP->ulValue;

  if ( ulAction == SET_PROP )
  {
    if ( *pDJPOri == DJP_ORI_PORTRAIT )
    {
      pCNFData->jobProperties.iOrient = PORTRAIT;
    }
    else
    if ( *pDJPOri == DJP_ORI_LANDSCAPE )
    {
      pCNFData->jobProperties.iOrient = LANDSCAPE;
    }
    else
    {
      //ERRORORORORORORORO
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      return DEV_WARNING;
    }
  }
  else  //GET_PROP......
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      if ( pCNFData->jobProperties.iOrient == PORTRAIT )
      {
        *pDJPOri = DJP_ORI_PORTRAIT;
      }
      else
      {
        *pDJPOri = DJP_ORI_LANDSCAPE;
      }
    }
    else    //DJP_ALL
    {
      pDJP->ulNumReturned = 2;
      *pDJPOri++ = DJP_ORI_PORTRAIT;
      *pDJPOri = DJP_ORI_LANDSCAPE;
    }
  }

  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: LoadResList
**
** DESCRIPTION:
**
\*****************************************************************************/

BOOL LoadResList( PDJPRESLIST pResList ,
                  PDESPPD     pdesPPD  , //Ptr to DESPPD
                  PCNFDATA    pCNFData , //Ptr to CnfData
                  LONG        lRequest )
{
  BOOL             fUI;
  INT              i, j;
  INT              iCount;
  INT              iIndexFound    = -1;
  PRESINFO         pResInfo;
  PSZ              pResStr;
  PUI_BLOCK        pUIBlock;
  RESINFO          TmpResInfo;

  if ( (pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                          pdesPPD->pPSStringBuff,
                                          UINAME_RESOLUTION,
                                          &iIndexFound ) )
       != NULL)
  {
    iCount = (INT)pUIBlock->usNumOfEntries;
    /* Make sure we don't overflow */
    if ( iCount > MAXRESCOUNT )
    {
      iCount = MAXRESCOUNT;
    }
    fUI = TRUE;
  }
  else  /* Does not multiple resolutions */
  {
    iCount = 1;
    fUI = FALSE;
  }

  pResList->lResCount = iCount;

  if ( lRequest == RES_COUNT )  /* Just want count so leave now */
  {
    return fUI;
  }

  pResInfo = pResList->aRes;    /* Point to array */

  if ( pUIBlock == NULL )   /* No UI resolutions */
  { /* Use the resolution listed in the PPD */
    pResInfo->Res.x = pResInfo->Res.y = (USHORT)pdesPPD->desItems.iResDpi;
  }
  else  /* Get all resolutions from system */
  {
    for ( i = 0 ; i < iCount ; i ++ )
    {
      pResStr = (PCHAR)( pdesPPD->pPSStringBuff +
                                         pUIBlock->uiEntry[ i ].ofsOption );
      ResStrToBin( pResStr, &pResInfo->Res ); /* Convert string to binary */
      pResInfo->pszResStr = pResStr;  /* Save string for setting */

      pResInfo++;
    }
  }

  /* Now sort list from High to low */
  /* Don't bother if only one       */
  if ( iCount > 1 )
  {
    for ( i = 0; i < iCount - 1; i++ )
    {
      for ( j = i + 1; j < iCount; j++ )
      {
        if ( ( pResList->aRes[ i ].Res.x * pResList->aRes[ i ].Res.y ) <
             ( pResList->aRes[ j ].Res.x * pResList->aRes[ j ].Res.y ) )
        {
          TmpResInfo = pResList->aRes[ i ];
          pResList->aRes[ i ] = pResList->aRes[ j ];
          pResList->aRes[ j ] = TmpResInfo;
        }
      }
    }
  }

  /* Set up Quality info */
  pResInfo = pResList->aRes;    /* Point to array */
  for ( i = 0; i < iCount && i < QUALITYCOUNT; i++ )
  {
    pResInfo->Quality = QualityList[ i ];
    pResInfo++;
  }

  return fUI;
}


/*****************************************************************************\
**
** FUNCTION: djp_c_resolution
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_c_resolution( PDESPPD   pdesPPD    , //Ptr to DESPPD
                       PDJP_ITEM pDJP       , //Ptr DJP
                       PCNFDATA  pCNFData   , //Ptr to CnfData
                       ULONG     ulAction   , //Action to perform
                       LONG      ulProperty ) //Resolution or quality
{
  RESOLUTION         Res;
  BOOL               fSetIsOK = FALSE;
  BOOL               fUIRes;
  INT                iCount;
  INT                iEleSize;
  INT                iRC;
  PDJPT_RESOLUTION   pDJPRes;
  PDJPT_PRINTQUALITY pPrintQuality;
  UINT               uiLoop;
  ULONG              ulSize;
  DJPRESLIST         ResList;
  PRESINFO           pResInfo;
  INT                i;

  fUIRes = LoadResList( &ResList, pdesPPD, pCNFData, (ulAction == GET_SIZE) ?
                                                     RES_COUNT : RES_LIST );
  iCount = ResList.lResCount;

  /* Can only have up to 4 if in quality mode */
  if ( ulProperty == DJP_SJ_PRINTQUALITY &&
       iCount > QUALITYCOUNT              )
  {
    iCount = ResList.lResCount = QUALITYCOUNT;
  }

  iEleSize = ( ulProperty == DJP_CJ_RESOLUTION ) ? sizeof( DJPT_RESOLUTION ) :
                                                   sizeof( DJPT_PRINTQUALITY );

  //Number of resolutions in reslist
  ulSize = DJP_HEADER_SIZE + ( ( pDJP->lType == DJP_CURRENT ) ? iEleSize :
                                  iEleSize * iCount );

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;
  pDJPRes       = (PDJPT_RESOLUTION)&pDJP->ulValue;
  pPrintQuality = (PDJPT_PRINTQUALITY)&pDJP->ulValue;

  //Getting current prop is easy.....
  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      GetCurrentResolution( &Res, pdesPPD, pCNFData );       //@V3.1147608
      /* Need to switch res if landscape */                  //@V3.1154783
      if ( pCNFData->jobProperties.iOrient != PORTRAIT )     //@V3.1154783
      {                                                      //@V3.1154783
        i = Res.x;                                           //@V3.1154783
        Res.x = Res.y;                                       //@V3.1154783
        Res.y = i;                                           //@V3.1154783
      }                                                      //@V3.1154783
      if ( ulProperty == DJP_CJ_RESOLUTION )
      {
        pDJPRes->usXResolution = Res.x;
        pDJPRes->usYResolution = Res.y;
        return DEV_OK;  //We're done, return..
      }
      else  /* DJP_SJ_PRINTQUALITY */
      {
        pResInfo = ResList.aRes;
        for ( i = 0; i < iCount; i ++ )
        {
          if ( pResInfo->Res.x == Res.x &&
               pResInfo->Res.y == Res.y  )
          {
            *pPrintQuality = pResInfo->Quality;
            return DEV_OK;  /*We're done, return..*/
          }
          pResInfo++;
        }
        /* If we got here didn't find the resolution */
        pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
        return DEV_WARNING;
      }
    }
    else //DJP_ALL...
    {
      //Set number returned and keep going
      pDJP->ulNumReturned = iCount;
    }
  }

  /*
  ** This does the SET_PROP and GET_PROP for DJP_ALL
  **
  ** In order to list all DPIs or verify a SET we must loop through list
  */
  pResInfo = &ResList.aRes[ 0 ];
  for (uiLoop = 0 ; uiLoop < iCount ; uiLoop++)
  {
    if ( ulAction == SET_PROP )
    {
      if ( ( ulProperty == DJP_CJ_RESOLUTION           &&
             pDJPRes->usXResolution == pResInfo->Res.x &&
             pDJPRes->usYResolution == pResInfo->Res.y  ) ||
           ( ulProperty == DJP_SJ_PRINTQUALITY         &&
             *pPrintQuality == pResInfo->Quality        )  )
      { //Good value
        pCNFData->uResolution = pDJPRes->usXResolution;
        if ( fUIRes == TRUE )
        {
          iRC = SetUIOption( pdesPPD,
                             ASSIGN_UISELLIST_PTR( pCNFData ),
                             UINAME_RESOLUTION,
                             (PBYTE)pResInfo->pszResStr );
        }
        else  /* No UI so just one res */
        {
          iRC = 1;  /* Good */
        }
        if ( iRC != -1 )    /* If rc is NOT bad */
        {
          fSetIsOK = TRUE;  /* Set flag to good */
        }
        break;
      }
    }
    else
    { //GET_PROP and DJP_ALL....
      if ( ulProperty == DJP_CJ_RESOLUTION  )
      {
        pDJPRes->usXResolution = pResInfo->Res.x;
        pDJPRes->usYResolution = pResInfo->Res.y;
        pDJPRes++;
      }
      else  /* DJP_SJ_PRINTQUALITY */
      {
        *pPrintQuality = pResInfo->Quality;
        pPrintQuality++;
      }
    }
    pResInfo++;
  }

  if ( ulAction == SET_PROP &&
       fSetIsOK == FALSE     )
  {
    pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
    return DEV_WARNING;
  }
  else
  {
    return DEV_OK;
  }
}


/*****************************************************************************\
**
** FUNCTION: djp_s_color
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_s_color(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction   //Action to perform
     )
{
  ULONG   ulSize;
  BOOL    fIsColorDevice;
  INT     iMode;
  PDJPT_COLOR pDJPColor;

  //TRUE if device can suport color
  fIsColorDevice = ( pdesPPD->desItems.fIsColorDevice != NONE );

  if ( fIsColorDevice )
  {
    iMode = 2;
  }
  else  //B&W
  {
    iMode = 1;
  }

  //Color or B/W
  ulSize = DJP_HEADER_SIZE + ( ( pDJP->lType == DJP_CURRENT ) ?
           sizeof( DJPT_COLOR )  : sizeof( DJPT_COLOR ) * iMode ) ;

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;
  pDJPColor = (PDJPT_COLOR)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      if ( fIsColorDevice && pCNFData->jobProperties.fIsColorDevice )
      {
        *pDJPColor = DJP_CLR_COLOR;
      }
      else
      {
        *pDJPColor = DJP_CLR_MONOCHROME;
      }
    }
    else  //DJP_ALL
    {
      *pDJPColor = DJP_CLR_MONOCHROME;

      if ( fIsColorDevice )
      {
        pDJP->ulNumReturned++;  //Two modes
        pDJPColor++;
        *pDJPColor = DJP_CLR_COLOR;
      }
    }
  }
  else  //SET_PROP
  {
    if ( ! fIsColorDevice )   //If B&W, can only set B&W
    {
      if ( *pDJPColor != DJP_CLR_MONOCHROME )
      {
        pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
        return DEV_WARNING;
      }
      //Only Mono is already mono..
    }
    else  //Color
    {
      //Color Model???????????????????????????????????????????????????????????
      if ( *pDJPColor == DJP_CLR_MONOCHROME )
      {
        pCNFData->jobProperties.fIsColorDevice = FALSE;
      }
      else
      if ( *pDJPColor == DJP_CLR_COLOR )  //Set color on

      {
        pCNFData->jobProperties.fIsColorDevice = TRUE;
      }
      else  //Error
      {
        pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
        return DEV_WARNING;
      }
    }
  }
  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: djp_s_duplex
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_s_duplex(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction   //Action to perform
     )
{
  BOOL          fSupportDuplex = TRUE;
  INT           i;
  INT           iCount;
  INT           iIndexFound    = -1;
  PDJPT_DUPLEX  pDJPDuplex;
  PUI_BLOCK     pUIBlock;
  PCHAR         pValue;
  ULONG         ulSize;

  //Only support simple size
  ulSize = DJP_HEADER_SIZE + sizeof( DJPT_DUPLEX );

  /* Look up duplex info in ppd */
  if ( (pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                          pdesPPD->pPSStringBuff,
                                          UINAME_DUPLEX,
                                          &iIndexFound ) )
       != NULL)
  {
    iCount = (INT)pUIBlock->usNumOfEntries;
  }
  else  /* Does not support duplex */
  {
    iCount = 1;
    fSupportDuplex = FALSE;
  }

  ulSize = DJP_HEADER_SIZE + ( ( pDJP->lType == DJP_CURRENT ) ?
           sizeof( DJPT_DUPLEX )  : sizeof( DJPT_DUPLEX ) * iCount ) ;

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )  //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;
  pDJPDuplex = (PDJPT_DUPLEX)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( ! fSupportDuplex )
    {
      *pDJPDuplex = DJP_DUP_NONE;
    }
    else /* Supported */
    {
      if ( pDJP->lType == DJP_CURRENT )
      {
        if ( ( pValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                                    ASSIGN_UISELLIST_PTR( pCNFData ),
                                                    UINAME_DUPLEX,
                                                    NULL,
                                                    NULL ) )
             == NULL)
        { /* Just set to none upon failure */
          pValue = UINAME_DUPLEXNONE;
        }
        iCount = 1; /* Only one needed for CURRENT */
      }
      else  /* DJP_ALL */
      {
        pDJP->ulNumReturned = iCount;
        pValue = (PCHAR)(pdesPPD->pPSStringBuff +
                                             pUIBlock->uiEntry[ 0 ].ofsOption);
      }

      for ( i = 0; i < iCount; i++ )
      {
        if ( ! strcmp( pValue, UINAME_DUPLEXTUMBLE ) )
        {
          *pDJPDuplex = DJP_DUP_FLIP;
        }
        else
        if ( ! strcmp( pValue, UINAME_DUPLEXNOTUMBLE ) )
        {
          *pDJPDuplex = DJP_DUP_BOOK;
        }
        else
        {
          *pDJPDuplex = DJP_DUP_OFF;
        }
        if ( i < ( iCount - 1 ) ) /* On to next in list */
        {
          pValue = (PCHAR)(pdesPPD->pPSStringBuff +
                                         pUIBlock->uiEntry[ i + 1 ].ofsOption);
          pDJPDuplex++;
        }
      }
    }
  }
  else  //SET_PROP......
  {
    /* Find out what to set */
    if ( ! fSupportDuplex           &&
         *pDJPDuplex == DJP_DUP_NONE )
    {
      /* Don't need to do anything as printer does not support duplex */
      /* This is just a syntax check */
      pValue = NULL;
    }
    else
    if ( *pDJPDuplex == DJP_DUP_BOOK )
    {
      pValue = UINAME_DUPLEXNOTUMBLE;
    }
    else
    if ( *pDJPDuplex == DJP_DUP_FLIP )
    {
      pValue = UINAME_DUPLEXTUMBLE;
    }
    else
    if ( *pDJPDuplex == DJP_DUP_OFF  ||
         *pDJPDuplex == DJP_DUP_NONE  )
    {
      pValue = UINAME_DUPLEXNONE;
    }
    else
    {
      //ERRORORORORORORORO
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      return DEV_WARNING;
    }

    if ( pValue )
    {
      SetUIOption( pdesPPD,
                   ASSIGN_UISELLIST_PTR( pCNFData ),
                   UINAME_DUPLEX,
                   (PBYTE)pValue );
    }
  }

  return DEV_OK;
}
/*****************************************************************************\
**
** FUNCTION: LoadFormList
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG LoadFormList(
       PDESPPD   pdesPPD,    //Ptr to DESPPD
       PCNFDATA  pCNFData,   //Ptr to CnfData
       LONG      lRequest,   //What to do.
       PFORMLIST *ppFormList //Address of form list - can be null;
     )
{
  FORMSTRUCT FormStruct;
//PBYTE      apResources[IMAXRES + 1];
  INT        i;
  INT        iCount;
  INT        iMemSize;
  INT        iRealFormCount;
  PFORMINFO  pFIReal;
  PFORMINFO  pFormInfo;
  PFORMLIST  pFormList;
  PUI_BLOCK  pUIBlock;
  PSHORT     psDim;

  //Get count of real and user defined forms
  /* Look up Form info in ppd */
  pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                     pdesPPD->pPSStringBuff,
                                     UINAME_PAGESIZE,
                                     NULL );
//iRealFormCount = pdesPPD->desPage.iImgpgpairs;
  iRealFormCount = (INT)pUIBlock->usNumOfEntries;

  iCount =  iRealFormCount +
            NewUserForms( pCNFData, QUERY_NUM_OF_USER_FORMS, NULL, NULL );

  if ( lRequest == FORM_COUNT  )
  {
    (*ppFormList)->lFormCount = iCount;
    return iCount;
  }

  //Allocate buffer for forms
  iMemSize = sizeof( FORMLIST ) + ( ( iCount - 1 ) * sizeof( FORMINFO ) );
  if ( ( pFormList = (PFORMLIST)GplMemoryAlloc( pProcessHeap, iMemSize ) )
        == NULL )
  {
    return 0;
  }

  *ppFormList = pFormList;          //Set passed ptr
  pFormList->lFormCount = iCount;   //Set count
  pFormInfo = pFormList->aForms;    //Set to form list

  //For each form
  for ( i = 0; i < iCount; i++ )
  {
    if ( i < iRealFormCount )
    {
      GetImageableArea( i, (PFORMSTRUCT)&FormStruct, pdesPPD,
                        pdesPPD->pPSStringBuff );
      strcpy( pFormInfo->szFormName, FormStruct.FormName );
      strcpy( pFormInfo->szRealName, FormStruct.FormName );
      if ( FormStruct.XlateName[ 0 ] != '\0' )
      {
        strcpy( pFormInfo->szXLTFormName, FormStruct.XlateName );
      }
      else
      {
        strcpy( pFormInfo->szXLTFormName, FormStruct.FormName );
      }
      strcpy( pFormInfo->szOldSuffix, FormStruct.OldSuffix );
      if ( CHECKFLAG( lRequest, FORM_SIZES ) )
      {
        /* Save the imageable area while we have it */
        psDim = (PSHORT)FormStruct.Data;
        pFormInfo->ImageableArea.LLx = *psDim++;
        pFormInfo->ImageableArea.LLy = *psDim++;
        pFormInfo->ImageableArea.URx = *psDim++;
        pFormInfo->ImageableArea.URy = *psDim;
      }
    }
    else  //USERFORM
    {
      NewUserForms( pCNFData, i - iRealFormCount,
                    (PSZ)pFormInfo->szFormName,
                    (PSZ)pFormInfo->szRealName );
      strcpy( pFormInfo->szXLTFormName, pFormInfo->szFormName );
      *(pFormInfo->szOldSuffix) = '\0';
    }

    /* Store the unique id for future use now - see LoadTrayList for more
    ** info
    */
    pFormInfo->lPaperSize = UNIQUE_BASE_ID + i;

    pFormInfo++;
  }

  //Don't need sizes so return
  if ( CHECKFLAG( lRequest, FORM_SIZES ) == 0 )
  {
    return iCount;
  }

  pFormInfo = pFormList->aForms;    //Set to form list

  for ( i = 0; i < iCount; i++ )
  {
    psDim = PaperDimensions( pFormInfo->szRealName, pdesPPD );
    //If cant find size point to default letter size
    if ( psDim == NULL )
    {
      psDim = asDefaultSize;
    }
    pFormInfo->PaperDim.Width  = *psDim++;
    pFormInfo->PaperDim.Height = *psDim;

    /* find the imageable areas for the user form entrys */
    if ( i >= iRealFormCount )
    {
      pFIReal = SearchFormList( pFormList, pFormInfo->szRealName );
      if ( pFIReal )
      {
         pFormInfo->ImageableArea = pFIReal->ImageableArea;
      }
      else
      {
        pFormInfo->ImageableArea = asDefaultImg;
      }
    }

    pFormInfo++;
  }

  return iCount;
}


/*****************************************************************************\
**
** FUNCTION: FreeFormList
**
** DESCRIPTION:
**
\*****************************************************************************/

VOID FreeFormList(
       PFORMLIST pFormList  //Form list loaded by LoadFormList
     )
{
  if ( pFormList )
    GplMemoryFree( pFormList );
}


/*****************************************************************************\
**
** FUNCTION: SearchFormList
**
** DESCRIPTION:
**
\*****************************************************************************/

PFORMINFO SearchFormList(
            PFORMLIST pFormList,  //Form list loaded by LoadFormList
            PSZ pszFormName       //The form to look for
          )
{
  INT       i;
  INT       iCount;
  PFORMINFO pFormInfo;

  iCount = pFormList->lFormCount;   //Set count
  pFormInfo = pFormList->aForms;    //Set to form list

  //Look thru forms to find the key

  for ( i = 0; i < iCount; i++ )
  {
////if ( CompareRealNames( pszFormName, pFormInfo->szFormName ) == 0 )
    if ( strcmp( pszFormName, pFormInfo->szFormName ) == 0 )
    {
      return pFormInfo;
    }
    pFormInfo++;
  }

  return NULL;    //No form matched
}


/*****************************************************************************\
**
** FUNCTION: MapFormNametoID
**
** DESCRIPTION:
**
\*****************************************************************************/

DJPT_PAPERSIZE MapFormNametoID(
                 PFORMINFO pFormInfo
               )
{
  PCHAR          pchSlash;
  PMAPPAIR       pMapPair;
  DJPT_PAPERSIZE id = 0;
  PSZ pszFormName = pFormInfo->szFormName;

  //Only interested in formal PS names so if there is a xlat slash temp
  //replace with NULL char
  if ( pchSlash = strchr( pszFormName, '/' ) )
  {
    *pchSlash = '\0';
  }

  pMapPair = MapPairs;

  //See if name of form matches any in the mapping list
  while ( pMapPair->pszFormName )
  {
    if ( strcmp( pszFormName, pMapPair->pszFormName ) == 0 )
    {
      id = pMapPair->lPaperSize;
      break;
    }
    pMapPair++;
  }

  /* If no predefined form found the use the unique id assigned in loadformlist */
  if ( id == 0 )
  {
    id = pFormInfo->lPaperSize;
  }

  //If there was an xlat slash put it back
  if ( pchSlash )
  {
    *pchSlash = '/';
  }

  return id;
}


/*****************************************************************************\
**
** FUNCTION: MapIDtoFormName
**
** DESCRIPTION:
**
\*****************************************************************************/

PFORMINFO MapIDtoFormName(
            PFORMLIST pFormList,  //List of supported forms
            DJPT_PAPERSIZE FormID //Form ID to find
          )
{
  PMAPPAIR  pMapPair;
  PFORMINFO pFormInfo = NULL;
  INT       i;

  //Form ID 0 is no form
  if ( FormID == 0 )
  {
    return NULL;
  }

  /* Look in tray list for given ID if unique */
  if ( FormID >= UNIQUE_BASE_ID )
  {
    pFormInfo = pFormList->aForms; // were not initializing pFormInfo... ugh //@248710
    for ( i = 0; i < pFormList->lFormCount; i++ )
    {
      if ( pFormInfo->lPaperSize == FormID )
      {
        /* Found it ! */
        return pFormInfo;
      }
      pFormInfo++;
    }
  }

  //Find the form ID in list
  pMapPair = MapPairs;

  //Since different PS formnames map to same ID need to search PS list
  //to find which name this printer supports
  while ( pMapPair->lPaperSize )
  {
    if ( pMapPair->lPaperSize == FormID )
    {
      pFormInfo = SearchFormList( pFormList, pMapPair->pszFormName );
      if ( pFormInfo )
      {
        break;
      }
    }
    pMapPair++;
  }

  return pFormInfo;
}


/* Not needed anymore */
#if 0
/*****************************************************************************\
**
** FUNCTION: CountDupTrayNames
**
** DESCRIPTION:
**
\*****************************************************************************/

INT CountDupTrayNames(
      PTRAYLIST  pTrayList    /* Pointer tray list */
    )
{
  PTRAYINFO pTrayInfo  = pTrayList->aTrays;
  PTRAYINFO pTray;
  LONG      lTrayCount = pTrayList->lTrayCount;
  BOOL      fLooking   = TRUE;
  INT       i          = 0;
  INT       j;
  INT       iDupCount  = 0;

  while ( fLooking )  /* Main loop to process list  keeps going till done */
  {
    /* Find unprocessed tray */
    pTray = NULL;
    while ( i < lTrayCount )
    {
      if ( (pTrayInfo+i)->fProcessed == FALSE )
      {
        pTray = pTrayInfo+i;
        break;
      }
      i++;
    }

    if ( pTray == NULL )
    {
      /* All trays processes - get out */
      break;
    }
    else
    {
      pTray->fProcessed = TRUE; /* current tray done */
      j = i + 1;  /* Start at next tray */
      /* Look at rest of upprocessed trays */
      while ( j < lTrayCount )
      {
        if ( (pTrayInfo+j)->fProcessed == FALSE                         &&
             strcmp( pTray->szFormName, (pTrayInfo+j)->szFormName ) == 0 )
        { /* Dup found */
          iDupCount ++;
          (pTrayInfo+j)->fProcessed = TRUE;
        }

        j++;
      }
    }
  }
  pTrayList->lDupCount = iDupCount;
  return iDupCount;
}
#endif


/*****************************************************************************\
**
** FUNCTION: FillFormStruc
**
** DESCRIPTION:
**
\*****************************************************************************/

VOID FillFormStruc(
       PDJPT_FORM  pDJPForm,
       PFORMINFO   pFormInfo,
       PTRAYINFO   pTrayInfo,
       PDESPPD     pdesPPD
     )
{
  //Since the driver uses form names upto 64 while DJP uses 32
  //Copy over 31 bytes and put 0 as term.  If names is shorter then 31
  //no problem. This is faster then strncpy
  memcpy( pDJPForm->szFormname, pFormInfo->szFormName,
          sizeof( pDJPForm->szFormname ) );
    if ( *(pFormInfo->szOldSuffix) )
    {
      strcat( pDJPForm->szFormname, "/" );
      strcat( pDJPForm->szFormname, pFormInfo->szOldSuffix );
    }
  pDJPForm->szFormname[ sizeof( pDJPForm->szFormname ) - 1 ] = '\0';
  memcpy( pDJPForm->szDisplayFormname, pFormInfo->szXLTFormName,
          sizeof( pDJPForm->szDisplayFormname ) );
  pDJPForm->szDisplayFormname[ sizeof( pDJPForm->szDisplayFormname ) - 1 ] = '\0';
  pDJPForm->djppsFormID =  MapFormNametoID( pFormInfo );

  if ( pTrayInfo )
  {
    memcpy( pDJPForm->szTrayname, pTrayInfo->szTrayName,
            sizeof( pDJPForm->szTrayname ) );
    pDJPForm->szTrayname[ sizeof( pDJPForm->szTrayname ) - 1 ] = '\0';
    memcpy( pDJPForm->szDisplayTrayname, pTrayInfo->szXLTTrayName,
            sizeof( pDJPForm->szDisplayTrayname ) );
    pDJPForm->szDisplayTrayname[ sizeof( pDJPForm->szDisplayTrayname ) -1 ] =
      '\0';
    pDJPForm->djpttTrayID = MapTrayNametoID( pTrayInfo );
  }
  else  /* No tray for this form */
  {
    pDJPForm->szTrayname[ 0 ]        = '\0';
    pDJPForm->szDisplayTrayname[ 0 ] = '\0';
    pDJPForm->djpttTrayID            = DJP_TRY_NONE;
  }

  pDJPForm->szMedianame[ 0 ]        = '\0';   /* No media for now */
  pDJPForm->szDisplayMedianame[ 0 ] = '\0';   /* No media for now */
  pDJPForm->djpmdMediaID            = DJP_MED_NONE;

  /* Copy over HCINFO */
  pDJPForm->hcInfo = pFormInfo->HCInfo;

  return;
}


/*****************************************************************************\
**
** FUNCTION: FillHCInfoStruc
**
** DESCRIPTION: Fills in HCINFO strct in FormInfo
**
\*****************************************************************************/

VOID FillHCInfoStruc( PDESPPD      pdesPPD,    //Ptr to DESPPD
                      PCNFDATA     pCNFData,   //Ptr to CnfData
                      PFORMLIST    pFormList,
                      PTRAYLIST    pTrayList,
                      PRESOLUTION  pRes
     )
{
  PFORMINFO  pFormInfo;
  PTRAYINFO  pTrayInfo;
  PHCINFO    pHCInfo;
  INT        i;
  INT        j;
  LONG       lScale;
  LONG       lTemp;
//ULONG      ulCC;
  PSZ        pszDefForm;
  BOOL       fAllSelectable = FALSE;



  lScale = pCNFData->jobProperties.uScale;    /* Set Scale var */

  /* Lets set up the default form which is used to set the HCAPS_CURRENT
  ** bit in attribute field
  */
  if ((PSZ) pCNFData->jobProperties.szFormName == '\0')
  {
/// ulCC = GetCountryCode();
/// switch ( ulCC )
/// {
/// case  1:
/// case  2:
/// case 55:
///   pszDefForm = (PSZ)StringTable[IDS_Letter-STRING_BASE];
///   break;
/// default:
///   pszDefForm = (PSZ)StringTable[IDS_A4-STRING_BASE];
/// }
    pszDefForm = (PSZ) GetDefaultPageSize( pdesPPD, pdesPPD->pPSStringBuff );
  }
  /* @V4.0158676
  ** If the JP for this DC didn't have a form in it don't set the CURRENT bit
  ** By the time we get here form name will have bin filled in.  If we have to
  ** go back to having a current at all times just change this to use above
  ** code instead of setting it to null string
  */
  else if ( pCNFData->ulFlags & NO_FORM_IN_JP )
  {
    pszDefForm = "";
  }
  else
  {
    pszDefForm = pCNFData->jobProperties.szFormName ;
  }

  /*
  ** If manual feed turned on OR autotray all forms are selectable
  */
  if ( ( strcmp ( pCNFData->u.iv.aTraySelected, MANUALFEED_STRING ) == 0 ) ||
       ( strcmp ( pCNFData->u.iv.aTraySelected, AUTOTRAY_STRING   ) == 0 )  )
  {
    fAllSelectable = TRUE;
  }

  pFormInfo = pFormList->aForms;      //Set to form list

  for ( i = 0; i < pFormList->lFormCount; i++ )
  {
    /* Fill in HCINFO struct */
    pHCInfo = &pFormInfo->HCInfo;   /* Set shorthand */
    /* Copy name over choping at sizof name (32) */
    memcpy( pHCInfo->szFormname, pFormInfo->szFormName, HCINFONAMESIZE );
    if ( *(pFormInfo->szOldSuffix) )
    {
      strcat( pHCInfo->szFormname, "/" );
      strcat( pHCInfo->szFormname, pFormInfo->szOldSuffix );
    }
    pHCInfo->szFormname[ HCINFONAMESIZE - 1 ] = '\0';

    /* If imageable area is larger than paper dim set imagable area to
    ** paper dim
    */
    if ( pFormInfo->ImageableArea.URx > pFormInfo->PaperDim.Height )
    {
      pFormInfo->ImageableArea.URx = pFormInfo->PaperDim.Height;
    }
    if ( pFormInfo->ImageableArea.URy > pFormInfo->PaperDim.Height )
    {
      pFormInfo->ImageableArea.URy = pFormInfo->PaperDim.Height;
    }

    pHCInfo->cx = PTS2MMR( pFormInfo->PaperDim.Width );
    pHCInfo->cy = PTS2MMR( pFormInfo->PaperDim.Height );
    pHCInfo->xLeftClip   = PTS2MMU( pFormInfo->ImageableArea.LLx );   //@V3.1154783
    pHCInfo->yBottomClip = PTS2MMU( pFormInfo->ImageableArea.LLy );   //@V3.1154783
    pHCInfo->xRightClip  = PTS2MM( pFormInfo->ImageableArea.URx );
    pHCInfo->yTopClip    = PTS2MM( pFormInfo->ImageableArea.URy );

    pHCInfo->xPels = ((LONG)( pFormInfo->ImageableArea.URx -
                         pFormInfo->ImageableArea.LLx ) * (LONG)pRes->x ) / 72L;

    pHCInfo->yPels = ((LONG)( pFormInfo->ImageableArea.URy -
                         pFormInfo->ImageableArea.LLy ) * (LONG)pRes->y ) / 72L;

    /*
    ** Scaling
    **
    ** the following change done at the request of excel who want
    ** the imageable area to be scaled as per the inverse of scaling
    ** factor specified by user.
    */
    if ( lScale != 100 )
    {
      pHCInfo->cx          = pHCInfo->cx          * 100L / lScale;
      pHCInfo->cy          = pHCInfo->cy          * 100L / lScale;
      pHCInfo->xLeftClip   = pHCInfo->xLeftClip   * 100L / lScale;
      pHCInfo->yBottomClip = pHCInfo->yBottomClip * 100L / lScale;
      pHCInfo->xRightClip  = pHCInfo->xRightClip  * 100L / lScale;
      pHCInfo->yTopClip    = pHCInfo->yTopClip    * 100L / lScale;
      pHCInfo->xPels       = pHCInfo->xPels       * 100L / lScale;
      pHCInfo->yPels       = pHCInfo->yPels       * 100L / lScale;
    }

    /*
    ** If LANDSCAPE orientation is in effect then rotate
    ** the coordinates by 90 degrees.
    */
    if ( pCNFData->jobProperties.iOrient != PORTRAIT )
    {
      lTemp       = pHCInfo->cx;
      pHCInfo->cx = pHCInfo->cy;
      pHCInfo->cy = lTemp;

      lTemp                = pHCInfo->xLeftClip;
      pHCInfo->xLeftClip   = pHCInfo->yBottomClip;
      pHCInfo->yBottomClip = lTemp;

      lTemp               = pHCInfo->xRightClip;
      pHCInfo->xRightClip = pHCInfo->yTopClip;
      pHCInfo->yTopClip   = lTemp;

      lTemp          = pHCInfo->xPels;
      pHCInfo->xPels = pHCInfo->yPels;
      pHCInfo->yPels = lTemp;
    }

    /*
    ** Set the Attribute bits
    */
    /* If this form name matches the JP form name it is current */
    if ( strcmp( pFormInfo->szFormName, pszDefForm ) == 0 )
    {
      pHCInfo->flAttributes = HCAPS_CURRENT;
    }

    if ( fAllSelectable )
    {
      pHCInfo->flAttributes |= HCAPS_SELECTABLE;
    }
    else
    { /* Scan the tray list to see if form is loaded */
      pTrayInfo = pTrayList->aTrays;

      for ( j = 0; j < pTrayList->lTrayCount; j++ )
      {
        if ( strcmp( pFormInfo->szFormName, pTrayInfo->szFormName ) == 0 )
        {
          pHCInfo->flAttributes |= HCAPS_SELECTABLE;
        }

        pTrayInfo++;
      }
    }

    pFormInfo++;
  }
}


/*****************************************************************************\
**
** FUNCTION: djp_x_form
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_x_form(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction,  //Action to perform
       LONG      ulProperty //Simple or complex
     )
{
  ULONG           ulSize;
  FORMLIST        FormList;
  PFORMLIST       pFormList;
  PFORMINFO       pFormInfo;
  PTRAYLIST       pTrayList = 0;
  PTRAYINFO       pTrayInfo;
  PDJPT_FORM      pDJPForm;
  DJPT_PAPERSIZE  FormID;
  PDJPT_PAPERSIZE pDJPPaperSize;
  INT             iFormCount;
  INT             iTrayCount = 0;
  INT             i, j;
  INT             iStructSize;
  INT             iDupTrays;
  LONG            lRC;
  RESOLUTION      Res;


  //Set up size of structure
  if ( ulProperty == DJP_SJ_PAPERSIZE )
  {
    iStructSize = sizeof( DJPT_PAPERSIZE );
  }
  else  //DJP_CJ_FORM
  {
    iStructSize = sizeof( DJPT_FORM );
  }

  ulSize = DJP_HEADER_SIZE + iStructSize;   //For ONE unit

  //Lots of work to do if you need a list so handle an single things first
  if ( ulAction == GET_SIZE   )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      pDJP->ulValue = ulSize;
    }
    else  //Would be DJP_ALL
    {
      pFormList = &FormList;
      iFormCount = LoadFormList( pdesPPD, pCNFData, (LONG)FORM_COUNT, &pFormList );
      if ( ulProperty == DJP_CJ_FORM )
      {
        iTrayCount = LoadTrayList( pdesPPD, pCNFData, (LONG)TRAY_NAMES,
                                   &pTrayList ) - 2;
/*****  iDupTrays  = CountDupTrayNames( pTrayList ); ****/
        /* For complex count is number of forms times 2 ( auto and manual )
        ** plus the corrected tray count.
        ** For simple it is just number of forms
        */
        iDupTrays  = iFormCount + iTrayCount;  /* The dups are manual */
        FreeTrayList( pTrayList );
      }
      else
      {
        iDupTrays = 0;
      }
      /* Count is number of forms plus trays with same form names */
      /* New  see above */
      pDJP->ulValue = DJP_HEADER_SIZE + iStructSize * ( iFormCount + iDupTrays );
    }
    return DEV_OK;
  }

  /* Need the function to allocate the form buffer */
  iFormCount = LoadFormList( pdesPPD, pCNFData, (LONG)(FORM_NAMES | FORM_SIZES),
                              &pFormList );
  iTrayCount = LoadTrayList( pdesPPD, pCNFData, (LONG)TRAY_NAMES, &pTrayList );
  if ( ulProperty == DJP_CJ_FORM )
  {
/** iDupTrays  = CountDupTrayNames( pTrayList ); **/
    iDupTrays  =  iFormCount  + ( iTrayCount - 2 );

    /* Need the current res for HCINFO stuff */
    GetCurrentResolution( &Res, pdesPPD, pCNFData );       //@V3.1147608

    FillHCInfoStruc( pdesPPD, pCNFData, pFormList, pTrayList, &Res );
  }
  else
  {
    iDupTrays = 0;
  }

  //Set the size and return count
  if ( pDJP->lType == DJP_ALL )
  {
    ulSize = DJP_HEADER_SIZE + iStructSize * ( iFormCount + iDupTrays );
    pDJP->ulNumReturned = iFormCount + iDupTrays;
  }
  else  //DJP_CURRENT
  {
    //ulSize set to 1 unit - see above
    pDJP->ulNumReturned = 1;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    FreeFormList( pFormList );
    FreeTrayList( pTrayList );
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  //Point to data area.  It's simpler to set up both pointers then to decide
  //which to use
  pDJPForm      = (PDJPT_FORM)&pDJP->ulValue;
  pDJPPaperSize = (PDJPT_PAPERSIZE)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_CURRENT )
    { //Set ptr to entry matching current form
      pFormInfo = SearchFormList( pFormList,
                                  pCNFData->jobProperties.szFormName );
      if ( ulProperty == DJP_SJ_PAPERSIZE )
      { //For simple case map name to ID
        pTrayInfo = (PTRAYINFO)1;   //Set to non zero for test farther down
        if ( pFormInfo )  //Found form?
        {                 //Map to ID
          FormID = MapFormNametoID( pFormInfo );
          if ( FormID == 0 )   //No id for name
          {
            pFormInfo = NULL;  //Set error condition
          }
        }
      }
      else  //DJP_CJ_FORM
      {
        pTrayInfo = SearchTrayList( pTrayList, pCNFData->u.iv.aTraySelected, STL_TRAYNAME );
      }

      if ( pFormInfo == NULL ||
           pTrayInfo == NULL  )
      {
        pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
        lRC = DEV_WARNING;
      }
      else
      {
        pDJP->ulNumReturned = 1;   //Set to one for current
        if ( ulProperty == DJP_SJ_PAPERSIZE )
        {
          *pDJPPaperSize = FormID;
        }
        else
        {
          FillFormStruc( pDJPForm, pFormInfo, pTrayInfo, pdesPPD );
        }
        lRC = DEV_OK;
      }

      FreeFormList( pFormList );
      FreeTrayList( pTrayList );
      return lRC;
    }

    /* DJP_ALL */
    //Copy forms into structure
    if ( ulProperty == DJP_SJ_PAPERSIZE )
    {
      pFormInfo = pFormList->aForms;    //Set to form list

      for ( i = 0; i < iFormCount; i++ )
      {
        //Look up ID
        FormID = MapFormNametoID( pFormInfo );
        if ( FormID ) //Form name mapped to ID
        {
          *pDJPPaperSize = FormID;
          pDJPPaperSize++;
        }
        else  //No Mapping found
        {
          //Decrement forms returned;
          pDJP->ulNumReturned--;
        }
        pFormInfo++;
      }
    }
    else  //DJP_CJ_FORM
    {
      /* Do all the trays and form in them... */
      pTrayInfo = &(pTrayList->aTrays[ 2 ]);   /* Set to First reg tray */
      for ( j = 2; j < iTrayCount; j++ )
      { /* get info on form in tray */
        pFormInfo = SearchFormList( pFormList, pTrayInfo->szFormName );
        if ( pFormInfo )
        {
          FillFormStruc( pDJPForm, pFormInfo, pTrayInfo, pdesPPD );
          pDJPForm++;
        }
        pTrayInfo++;  /* To Next tray */
      }

      pFormInfo = pFormList->aForms;    /* Set to top of form list */
      for ( j = 0; j < iFormCount; j++ )
      {
        // AutoTray
        FillFormStruc( pDJPForm, pFormInfo, &(pTrayList->aTrays[ 0 ]),
                       pdesPPD );
        pDJPForm++;

        // ManualFeed
        FillFormStruc( pDJPForm, pFormInfo, &(pTrayList->aTrays[ 1 ]),
                       pdesPPD );
        pDJPForm++;
        
        pFormInfo++;
      }
    }
  }
  else  //SET_PROP
  {
    //If we're give simple format map it to name
    if ( ulProperty == DJP_SJ_PAPERSIZE )
    {
      pFormInfo = MapIDtoFormName( pFormList, *pDJPPaperSize );

      // @DRV_AUTO Begin
      if ( !strcmp( pCNFData->jobProperties.szFormName, pFormInfo->szFormName ) )
      {
        // if formName matchs default form name, set for default tray instead of AUTOSELECT
        pTrayInfo = SearchTrayList( pTrayList, pCNFData->u.iv.aTraySelected, STL_TRAYNAME );
      }
      else
      {
        // tray search for tray with spec form instead of AUTOSELECT!
        pTrayInfo = SearchTrayList( pTrayList, pFormInfo->szFormName, STL_FORMNAME );
      }
      if ( pTrayInfo == NULL )  /* No tray found above */
      {
        pTrayInfo = SearchTrayList( pTrayList, AUTOTRAY_STRING, STL_TRAYNAME );
      }
      // @DRV_AUTO End
    }
    else  //DJP_CJ_FORM
    {
      /*
      ** Try the tray first.  If found then set form to what tray has in it
      ** If no tray specifed then use form.  Set tray to autoselect.
      */
      pFormInfo = NULL;
      pTrayInfo = NULL;
      /* Try tray first */
      if ( pDJPForm->szTrayname[ 0 ] )
      {
        if ( ( pTrayInfo = SearchTrayList( pTrayList, pDJPForm->szTrayname, STL_TRAYNAME ) )
             != NULL )
        {
          /* If not autotray or manual */
          if ( pTrayInfo->lTrayType != DJP_TRY_AUTO  &&
               pTrayInfo->lTrayType != DJP_TRY_MANUAL )
          {
            pFormInfo = SearchFormList( pFormList, pTrayInfo->szFormName );
          }
        }
      }
      if ( pFormInfo == NULL        &&  /* If no form found AND */
           pDJPForm->szFormname[ 0 ] )  /* Form is given        */
      {
        PSZ pszSlash;
        CHAR szFormname[65];

        memcpy( szFormname, pDJPForm->szFormname, 65 ); /*copy name to buffer */
        if ( pszSlash = strchr( szFormname, '/' ) )
        {
          *pszSlash = '\0';
        }
        //Try the name
        pFormInfo = SearchFormList( pFormList, szFormname );

        // @DRV_AUTO Begin
        if ( pFormInfo &&
             ( !pTrayInfo ||
               pTrayInfo->lTrayType == DJP_TRY_AUTO ) )
        {
          if ( !strcmp( pCNFData->jobProperties.szFormName, pFormInfo->szFormName ) )
          {
            // if formName matchs default form name, set for default tray instead of AUTOSELECT
            pTrayInfo = SearchTrayList( pTrayList, pCNFData->u.iv.aTraySelected, STL_TRAYNAME );
          }
          else
          {
            // tray search for tray with spec form instead of AUTOSELECT!
            pTrayInfo = SearchTrayList( pTrayList, pFormInfo->szFormName, STL_FORMNAME );
          }
        }
        // @DRV_AUTO End
        if ( pTrayInfo == NULL )  /* No tray found above */
        {
          pTrayInfo = SearchTrayList( pTrayList, AUTOTRAY_STRING, STL_TRAYNAME );
        }
      }
    }

    if ( pFormInfo == NULL ||
         pTrayInfo == NULL  )
    {
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      FreeFormList( pFormList );
      FreeTrayList( pTrayList );
      return DEV_WARNING;
    }
    strcpy( pCNFData->jobProperties.szFormName, pFormInfo->szFormName );
    strcpy( pCNFData->jobProperties.szFormSize, pFormInfo->szRealName );
    strcpy( pCNFData->u.iv.aTraySelected, pTrayInfo->szTrayName );
    /* Need to do some more for man feed */
    if ( strcmp( pCNFData->u.iv.aTraySelected, MANUALFEED_STRING ) == 0 )
    {
      PUI_BLOCK  pUIBlock;
      if ( pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                               pdesPPD->pPSStringBuff,
                                               UINAME_MANUALFEED,
                                               NULL )                  )
      {
        SetUIOption( pdesPPD,
                     ASSIGN_UISELLIST_PTR( pCNFData ),
                     UINAME_MANUALFEED,
                     (PBYTE)"True" );
      }
    }
  }

  //Free buf allocated in LoadFormList
  FreeFormList( pFormList );
  FreeTrayList( pTrayList );
  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: LoadTrayList
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG LoadTrayList(
       PDESPPD   pdesPPD,    //Ptr to DESPPD
       PCNFDATA  pCNFData,   //Ptr to CnfData
       LONG      lRequest,   //What to do.
       PTRAYLIST *ppTrayList //Address of tray list - can be null;
     )
{
  PUI_BLOCK pTrayBlock;
  LONG      lIndex;
  LONG      lCount;
  PSZ       pName;
  PTRAYLIST pTrayList;
  PTRAYINFO pTrayInfo;
  PSOURCE   pSource = pCNFData->u.iv.pSourcePaper;

  /*
  ** Read the INI data and count the number of form/tray mappings.
  */
  ReadTrayPageMapINI( pdesPPD, pCNFData );
  lCount = CountPSourceList( pCNFData );

  /*
  ** For TRAY_COUNT, return the number of supported trays.  Do not copy
  ** any data.
  */
  if ( lRequest != TRAY_COUNT && ppTrayList != NULL)
  {
    /*
    ** Remember to include AUTOTRAY and MANUALFEED in with the count.
    ** (lCount + 1)
    */
    lIndex = sizeof( TRAYLIST ) + ( ( lCount + 1 ) * sizeof( TRAYINFO ) );
    if ( ( pTrayList = (PTRAYLIST) GplMemoryAlloc( pProcessHeap, lIndex ) )
           != NULL )
    {
      lCount += 2;

      *ppTrayList           = pTrayList;            // Set passed ptr
      pTrayList->lTrayCount = lCount;               // Set count
      pTrayInfo             = pTrayList->aTrays;    // Set to tray list

      /* Add in Autotray */
      strcpy( pTrayInfo->szTrayName, AUTOTRAY_STRING );
      WinLoadString( (HAB) 0, pscript_module, JPF_AUTOTRAYSELECT, MAX_PSIZE,
                     pTrayInfo->szXLTTrayName );
      pTrayInfo->szFormName[ 0 ] = '\0';
      pTrayInfo->lTrayType = DJP_TRY_AUTO;
      pTrayInfo++;

      /* Add in MANUAL */
      strcpy( pTrayInfo->szTrayName, MANUALFEED_STRING );
      WinLoadString( (HAB) 0, pscript_module, JPF_MANUALFEED, MAX_PSIZE,
                     pTrayInfo->szXLTTrayName );
      pTrayInfo->szFormName[ 0 ] = '\0';
      pTrayInfo->lTrayType = DJP_TRY_MANUAL;
      pTrayInfo++;

      /*
      ** Query the list of trays.
      */
      if ((pTrayBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                               pdesPPD->pPSStringBuff,
                                               UINAME_INPUTSLOT,
                                               NULL )) != NULL)
      {
        /*
        ** Run through the list of supported trays.  usNumOfEntries contains
        ** the total number of trays.
        */
        for (lIndex = 0 ; lIndex < (LONG) pTrayBlock->usNumOfEntries ;
             lIndex++)
        {
          if (pSource->szPaperName[ lIndex ][ 0 ] != 0)
          {
            /*
            ** Copy the real tray name.
            */
            pName = (PSZ) (pdesPPD->pPSStringBuff +
                           pTrayBlock->uiEntry[ lIndex ].ofsOption);
            strcpy( pTrayInfo->szTrayName, pName );

            /*
            ** Copy the tray's translation string.
            */
            pName = (PSZ) (pdesPPD->pPSStringBuff +
                           pTrayBlock->uiEntry[ lIndex ].ofsTransString);
            strcpy( pTrayInfo->szXLTTrayName, pName );

            /*
            ** Copy the form name.
            */
            strcpy( pTrayInfo->szFormName, pSource->szPaperName[ lIndex ] );

            /* @V4.0158787a
            ** The tray ID falls under one of two categories:  -
            ** Predefined tray ID - This is an ID that is defined by DJP
            ** (DJP_TRY_...).  All predefined ID's are listed in the MapTrays
            ** array at the beginning of this file.
            ** - Unique tray ID - This is a unique tray ID that is NOT defined
            ** by DJP.  The value of the ID is the block index plus
            ** UNIQUE_BASE_ID.
            ** For now put the unique id in.  If this is a predefined tray
            ** it will be replaced by the proper id when needed.
            */
            pTrayInfo->lTrayType = UNIQUE_BASE_ID + lIndex;

            pTrayInfo++;
          }
        }
      }
      else                 // pTrayBlock == NULL - no trays exist
      {
        (*ppTrayList)->lTrayCount = lCount;
      }
    }
    else                   // Alloc failed for pTrayList
    {
      lCount = 0;
    }
  }
  else                  // lRequest == TRAY_COUNT
  {
    lCount += 2;             // Add for MANUAL FEED and AUTO TRAY SELECT
  }

  return( lCount );
}


/*****************************************************************************\
**
** FUNCTION: FreeTrayList
**
** DESCRIPTION:
**
\*****************************************************************************/

VOID FreeTrayList(
       PTRAYLIST pTrayList  //Tray list loaded by LoadTrayList
     )
{
  if ( pTrayList )
    GplMemoryFree( pTrayList );
}


/*****************************************************************************\
**
** FUNCTION: SearchTrayList
**
** DESCRIPTION:
** SearchFlags:
**               STL_TRAYNAME 0x1 // Search for Tray in TrayList
**               STL_FORMNAME 0x2 // Search for Form in TrayList
**
\*****************************************************************************/

PTRAYINFO SearchTrayList( PTRAYLIST pTrayList,  //Tray list loaded by LoadTrayList
                          PSZ pszName,      //The String to look for
                          ULONG ulSearchFlag    //Flag to what search for
                        )
{
  INT       i;
  INT       iCount;
  PTRAYINFO pTrayInfo;

  iCount = pTrayList->lTrayCount;   //Set count
  pTrayInfo = pTrayList->aTrays;    //Set to tray list

  //Look thru trays to find the key

  for ( i = 0; i < iCount; i++ )
  {
    ////if ( CompareRealNames( pszTrayName, pTrayInfo->szTrayName ) == 0 )
    switch ( ulSearchFlag)
    {
      case STL_TRAYNAME:
        if ( strcmp( pszName, pTrayInfo->szTrayName ) == 0 )
        {
          return pTrayInfo;
        }
        break;
      case STL_FORMNAME:
        if ( strcmp( pszName, pTrayInfo->szFormName ) == 0 )
        {
          return pTrayInfo;
        }
        break;
    }
    pTrayInfo++;
  }

  return NULL;    //No tray matched
}


/*****************************************************************************\
**
** FUNCTION: MapTrayNametoID
**
** DESCRIPTION: Given a tray name will search the list of pre defined names
**              in MapTrays
**
\*****************************************************************************/

DJPT_TRAYTYPE MapTrayNametoID(
                PTRAYINFO pTrayInfo
              )
{
  PCHAR          pchSlash;
  PMAPTRAY       pMapTray;
  DJPT_TRAYTYPE  id = 0;
  PSZ            pszTrayName = pTrayInfo->szTrayName;

  //Only interested in formal PS names so if there is a xlat slash temp
  //replace with NULL char
  if ( pchSlash = strchr( pszTrayName, '/' ) )
  {
    *pchSlash = '\0';
  }

  pMapTray = MapTrays;

  //See if name of tray matches any in the mapping list
  while ( pMapTray->pszTrayName )
  {
    if ( strcmp( pszTrayName, pMapTray->pszTrayName ) == 0 )
    {
      id = pMapTray->lTrayType;
      break;
    }
    pMapTray++;
  }

  /* If no predefined tray found the use the unique id assigned in loadtraylist */
  if ( id == 0 )
  {
    id = pTrayInfo->lTrayType;
  }

  //If there was an xlat slash put it back
  if ( pchSlash )
  {
    *pchSlash = '/';
  }

  return id;
}


/*****************************************************************************\
**
** FUNCTION: MapIDtoTrayName
**
** DESCRIPTION:
**
\*****************************************************************************/

PTRAYINFO MapIDtoTrayName(
            PTRAYLIST pTrayList,  //List of supported trays
            DJPT_TRAYTYPE  TrayID //Tray ID to find
          )
{
  PMAPTRAY  pMapTray;
  PTRAYINFO pTrayInfo = pTrayList->aTrays;
  INT       i;

  //Tray ID 0 is no tray
  if ( TrayID == 0 )
  {
    return NULL;
  }

  /* Look in tray list for given ID if unique */
  if ( TrayID >= UNIQUE_BASE_ID )
  {
    for ( i = 0; i < pTrayList->lTrayCount; i++ )
    {
      if ( pTrayInfo->lTrayType == TrayID )
      {
        /* Found it ! */
        return pTrayInfo;
      }
      pTrayInfo++;
    }
  }

  /* Could not find the tray so keep looking in predefined list */
  pTrayInfo = NULL;

  //Find the tray ID in list
  pMapTray = MapTrays;

  //Since different PS traynames map to same ID need to search PS list
  //to find which name this printer supports
  while ( pMapTray->lTrayType )
  {
    if ( pMapTray->lTrayType == TrayID )
    {
      pTrayInfo = SearchTrayList( pTrayList, pMapTray->pszTrayName, STL_TRAYNAME );
      if ( pTrayInfo )
      {
        break;
      }
    }
    pMapTray++;
  }

  return pTrayInfo;
}


/*****************************************************************************\
**
** FUNCTION: djp_x_tray
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_x_tray(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction,  //Action to perform
       LONG      ulProperty //Simple or complex
     )
{
  ULONG           ulSize;
  INT             iStructSize;
  INT             iTrayCount;
  INT             i;
  TRAYLIST        TrayList;
  PTRAYLIST       pTrayList;
  PTRAYINFO       pTrayInfo;
  PDJPT_TRAYNAME  pDJPTrayName;
  PDJPT_TRAYTYPE  pDJPTrayType;
  DJPT_TRAYTYPE   TrayID;
  PFORMLIST       pFormList;
  PFORMINFO       pFormInfo;

  //Set up size of structure
  if ( ulProperty == DJP_SJ_TRAYTYPE )
  {
    iStructSize = sizeof( DJPT_TRAYTYPE );
  }
  else  //DJP_CJ_TRAYNAME
  {
    iStructSize = sizeof( DJPT_TRAYNAME );
  }

  ulSize = DJP_HEADER_SIZE + iStructSize;   //For ONE unit

  //Lots of work to do if you need a list so handle an single things first
  if ( ulAction == GET_SIZE   )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      pDJP->ulValue = ulSize;
    }
    else  //Would be DJP_ALL
    {
      pTrayList = &TrayList;
      iTrayCount = LoadTrayList( pdesPPD, pCNFData, (LONG)TRAY_COUNT,
                                 &pTrayList );
      pDJP->ulValue = DJP_HEADER_SIZE + iStructSize * iTrayCount;
    }
    return DEV_OK;
  }

  iTrayCount = LoadTrayList( pdesPPD, pCNFData, TRAY_NAMES, &pTrayList );

  //Set the size and return count
  if ( pDJP->lType == DJP_ALL )
  {
    ulSize = DJP_HEADER_SIZE + iStructSize * iTrayCount;
    pDJP->ulNumReturned = iTrayCount;
  }
  else  //DJP_CURRENT
  {
    //ulSize set to 1 unit - see above
    pDJP->ulNumReturned = 1;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    FreeTrayList( pTrayList );
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  //Point to data area.  It"s simpler to set up both pointers then to decide
  //which to use
  pDJPTrayName = (PDJPT_TRAYNAME)&pDJP->ulValue;
  pDJPTrayType = (PDJPT_TRAYTYPE)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_ALL )
    {
      pTrayInfo = pTrayList->aTrays;    //Set to tray list
    }
    else  //DJP_CURRENT
    { //Set ptr to entry matching current tray
      pTrayInfo = SearchTrayList( pTrayList, pCNFData->u.iv.aTraySelected, STL_TRAYNAME );
      if ( pTrayInfo == NULL )
      {
        pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
        FreeTrayList( pTrayList );
        return DEV_WARNING;
      }
      iTrayCount = 1;   //Set to one for current
    }

    //Copy trays into structure
    for ( i = 0; i < iTrayCount; i++ )
    {
      //Look up ID
      TrayID = MapTrayNametoID( pTrayInfo );
      if ( ulProperty == DJP_SJ_TRAYTYPE )
      {
        if ( TrayID ) //Tray name mapped to ID
        {
          *pDJPTrayType = TrayID;
          pDJPTrayType++;
        }
        else  //No Mapping found
        {
          //Decrement trays returned;
          pDJP->ulNumReturned--;
        }
      }
      else  //DJP_CJ_TRAYNAME
      {
        //Since the driver uses tray names upto 64 while DJP uses 32
        //Copy over 31 bytes and put 0 as term.  If names is shorter then 31
        //no problem. This is faster then strncpy
        memcpy( pDJPTrayName->szTrayname, pTrayInfo->szTrayName,
                sizeof( pDJPTrayName->szTrayname )  );
        pDJPTrayName->szTrayname[ sizeof( pDJPTrayName->szTrayname ) - 1 ] = '\0';

        memcpy( pDJPTrayName->szDisplayTrayname, pTrayInfo->szXLTTrayName,
                                    sizeof( pDJPTrayName->szDisplayTrayname ) );
        pDJPTrayName->szDisplayTrayname[ sizeof(
                                 pDJPTrayName->szDisplayTrayname ) - 1 ] = '\0';
        pDJPTrayName->djpttTrayID = MapTrayNametoID( pTrayInfo );
        pDJPTrayName++;
      }
      pTrayInfo++;
    }
  }
  else  //SET_PROP
  {
    //If we're give simple format map it to name
    if ( ulProperty == DJP_SJ_TRAYTYPE )
    {
      pTrayInfo = MapIDtoTrayName( pTrayList, *pDJPTrayType );
    }
    else  //DJP_CJ_TRAYNAME
    {
      pTrayInfo = SearchTrayList( pTrayList, pDJPTrayName->szTrayname, STL_TRAYNAME );
    }

    if ( pTrayInfo == NULL )
    {
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      FreeTrayList( pTrayList );
      return DEV_WARNING;
    }
    /*
    ** Look up form name to set for selected tray
    */

    /* Load up forms */
    LoadFormList( pdesPPD, pCNFData, FORM_NAMES, &pFormList );
    /* If autotray or manual then use provided form */
    if ( pTrayInfo->lTrayType == DJP_TRY_AUTO  ||
         pTrayInfo->lTrayType == DJP_TRY_MANUAL )
    {
      pFormInfo = SearchFormList( pFormList,
                                  pCNFData->jobProperties.szFormName );
    }
    else  /* Use form associated with tray */
    {
      pFormInfo = SearchFormList( pFormList, pTrayInfo->szFormName );
    }
    /* No form found for that tray return warning */
    if ( pFormInfo == NULL )
    {
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      FreeFormList( pFormList );
      FreeTrayList( pTrayList );
      return DEV_WARNING;
    }
    strcpy( pCNFData->u.iv.aTraySelected, pTrayInfo->szTrayName );
    SetUIOption( pdesPPD,
                 ASSIGN_UISELLIST_PTR( pCNFData ),
                 UINAME_INPUTSLOT,
                 (PBYTE)pTrayInfo->szTrayName );

    strcpy( pCNFData->jobProperties.szFormName, pFormInfo->szFormName );
    strcpy( pCNFData->jobProperties.szFormSize, pFormInfo->szRealName );
    SetUIOption( pdesPPD,
                 ASSIGN_UISELLIST_PTR( pCNFData ),
                 UINAME_PAGESIZE,
                 (PBYTE)pFormInfo->szRealName );

    /* Need to do some more for man feed */
    if ( strcmp( pCNFData->u.iv.aTraySelected, MANUALFEED_STRING ) == 0 )
    {
///// PUI_BLOCK  pUIBlock;
///// if ( pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
/////                                          pdesPPD->pPSStringBuff,
/////                                          UINAME_MANUALFEED,
/////                                          NULL )                  )
///// {
        SetUIOption( pdesPPD,
                     ASSIGN_UISELLIST_PTR( pCNFData ),
                     UINAME_MANUALFEED,
                     (PBYTE)"True" );
///// }
    }
    FreeFormList( pFormList );
  }

  //Free buf allocated in LoadTrayList
  FreeTrayList( pTrayList );
  return DEV_OK;

}


/*****************************************************************************\
**
** FUNCTION: djp_s_CopyScale
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG djp_s_CopyScale(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction,  //Action to perform
       LONG      ulProperty //Copies or scale
     )
{
  ULONG         ulSize;
  PDJPT_COPIES  pDJPCopies;
  PDJPT_SCALING pDJPScale;

  /* Size is just one unit */
  ulSize = DJP_HEADER_SIZE + ( ( ulProperty == DJP_SJ_COPIES ) ?
           sizeof( DJPT_COPIES )  : sizeof( DJPT_SCALING ) ) ;

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;

  /* Since the props are not enumerable DJP_CURRENT is only acceptable */
  if ( pDJP->lType != DJP_CURRENT )
  {
    pDJP->lType = DJP_ERROR_NOT_ENUM;
    return DEV_WARNING;
  }

  /* More efficient to just set both */
  pDJPCopies = (PDJPT_COPIES)&pDJP->ulValue;
  pDJPScale  = (PDJPT_SCALING)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( ulProperty ==  DJP_SJ_COPIES )
    {
      *pDJPCopies = pCNFData->iCntCopies;
    }
    else //DJP_SJ_SCALING
    {
      *pDJPScale = pCNFData->jobProperties.uScale;
    }
  }
  else  //SET_PROP
  {
    if ( ulProperty ==  DJP_SJ_COPIES )
    {
      pCNFData->iCntCopies = *pDJPCopies;

      if ( pCNFData->iCntCopies > 999 ||    // Do some error checking @V4.1192074
           pCNFData->iCntCopies < 1    )
      {
        pCNFData->iCntCopies = 1;
      }
    }
    else //DJP_SJ_SCALING
    {
      pCNFData->jobProperties.uScale = *pDJPScale;

      if ( pCNFData->jobProperties.uScale == 0 ||   // Do some error checking @V4.1192074
           pCNFData->jobProperties.uScale > 999 )
      {
        pCNFData->jobProperties.uScale = 100;
      }
    }
  }

  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: djp_c_OutputBin
**
** DESCRIPTION: Sets up output bin
**
\*****************************************************************************/

LONG djp_c_OutputBin(
       PDESPPD   pdesPPD,   //Ptr to DESPPD
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction   //Action to perform
     )
{
  INT              i;
  INT              iCount;
  INT              iIndexFound    = -1;
  LONG             lRC;
  PCHAR            pValue;
  PDJPT_OUTPUTBIN  pDJPOutputBin;
  PUI_BLOCK        pUIBlock;
  ULONG            ulSize;

  /* Look up bin info in ppd */
  if ( (pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                          pdesPPD->pPSStringBuff,
                                          UINAME_OUTPUTBIN,
                                          &iIndexFound ) )
       != NULL)
  {
    iCount = (INT)pUIBlock->usNumOfEntries;
  }
  else  /* Does not support OutputBins */
  {
    if ( ulAction == GET_SIZE )
    {
      pDJP->ulValue = SIMPLESIZE( 1 );
      lRC = DEV_OK;
    }
    else  //GET_PROP or SET_PROP
    {
      pDJP->ulNumReturned = 0;
      pDJP->cb = sizeof( DJP_ITEM );
      pDJP->lType = DJP_ERROR_NOT_SUPPORTED;
      lRC = DEV_WARNING;
    }

    return lRC;
  }

  ulSize = DJP_HEADER_SIZE + ( ( pDJP->lType == DJP_CURRENT ) ?
           sizeof( DJPT_OUTPUTBIN )  : sizeof( DJPT_OUTPUTBIN ) * iCount ) ;

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )  //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;
  pDJPOutputBin = ( PDJPT_OUTPUTBIN )&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
///   pDJPOutputBin->szDisplayBinname[0] = 0;
      pDJPOutputBin->lBinId = -1;

      if ( ( pValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                                  ASSIGN_UISELLIST_PTR( pCNFData ),
                                                  UINAME_OUTPUTBIN,
                                                  NULL,
                                                  NULL ) )
           == NULL)
      { /* Just set to NULL upon failure */
        pDJPOutputBin->szBinname[0] = 0;
      }
      else
      {
        strcpy( pDJPOutputBin->szBinname, pValue );
        strcpy( pDJPOutputBin->szDisplayBinname, pValue );
      }
    }
    else  /* DJP_ALL */
    {
      pDJP->ulNumReturned = iCount;
      for ( i = 0; i < iCount; i++ )
      {
        pValue = (PCHAR)(pdesPPD->pPSStringBuff +
                                           pUIBlock->uiEntry[ i ].ofsOption);
        strcpy( pDJPOutputBin->szBinname, pValue );
        strcpy( pDJPOutputBin->szDisplayBinname, pValue );
///     pDJPOutputBin->szDisplayBinname[0] = 0;
        pDJPOutputBin->lBinId = -1;
        pDJPOutputBin++;
      }
    }
  }
  else  /* SET_PROP */
  {
    i = SetUIOption( pdesPPD,
                     ASSIGN_UISELLIST_PTR( pCNFData ),
                     UINAME_OUTPUTBIN,
                     (PBYTE)pValue );
    if ( i == -1 )    /* An error */
    {
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      return DEV_WARNING;
    }
  }

  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: djp_s_nup
**
** DESCRIPTION: Sets up NUP
**
\*****************************************************************************/

LONG djp_s_nup( PDESPPD   pdesPPD  , //Ptr to DESPPD
                PDJP_ITEM pDJP     , //Ptr DJP
                PCNFDATA  pCNFData , //Ptr to CnfData
                ULONG     ulAction ) //Action to perform
{
  INT        i;
  PDJPT_NUP  pDJPNup;
  BOOL       fSetOK;
  ULONG      ulSize;
  // LMMOORE
//  PGLCB      pLCB = QueryLayoutCBFromCNFDATA( pCNFData );

  /* Possible Nup vlaues are 1,2,4,6,8,9,16 */
  #define NUPVALUES 7
  static DJPT_NUP NupTable[ NUPVALUES ] = { 1, 2, 4, 6, 8, 9, 16 };

  ulSize = DJP_HEADER_SIZE + sizeof( DJPT_NUP ) *
                           ( ( pDJP->lType == DJP_CURRENT ) ? 1 : NUPVALUES ) ;

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;

  pDJPNup = (PDJPT_NUP)&pDJP->ulValue;

  if ( ulAction == GET_PROP )
  {
    if ( pDJP->lType == DJP_CURRENT )
    {
      // LMMOORE
      *pDJPNup = pCNFData->gjfncb.ulNumPgSheet;
    }
    else  //DJP_ALL
    {
      pDJP->ulNumReturned = NUPVALUES;

      for ( i = 0; i < NUPVALUES; i++ )
      {
        *pDJPNup = NupTable[ i ];
        pDJPNup++;
      }
    }
  }
  else  /* SET_PROP */
  {
    fSetOK = FALSE;
    /* Verify data */
    for ( i = 0; i < NUPVALUES; i++ )
    {
      if ( *pDJPNup == NupTable[ i ] )
      { /* Good value */
        // LMMOORE
        pCNFData->gjfncb.ulNumPgSheet = *pDJPNup;
//        pLCB->layout.nUP.ulNumPgSheet = *pDJPNup;
        fSetOK = TRUE;
        break;
      }
    }
    if ( fSetOK != TRUE )
    {
      /* If you got here no match so bad parm */
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      return DEV_WARNING;
    }
  }

  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: djp_c_MixedForms
**
** DESCRIPTION: Does the mixed forms.  At the time of this writing we only
**              support one form per job.
**
\*****************************************************************************/

LONG djp_c_MixedForms( PDESPPD   pdesPPD  , //Ptr to DESPPD
                       PDJP_ITEM pDJP     , //Ptr DJP
                       PCNFDATA  pCNFData , //Ptr to CnfData
                       ULONG     ulAction ) //Action to perform
{
  ULONG             ulSize;
  PDJPT_MIXEDFORMS  pDJPMixedForm;
  XDJPITEM          xDJP;
  LONG              lRC;

  ulSize = DJP_HEADER_SIZE + sizeof( DJPT_MIXEDFORMS );

  if ( ulAction == GET_SIZE )
  {
    pDJP->ulValue = ulSize;
    return DEV_OK;
  }

  if ( pDJP->cb < ulSize )   //For set itype will be DJP_CURRENT
  {
    return DEV_ITEM_BUF_TOO_SMALL;
  }
  else  //Set the right size
  {
    pDJP->cb = ulSize;
  }

  pDJP->ulNumReturned = 1;

  pDJPMixedForm = (PDJPT_MIXEDFORMS)&pDJP->ulValue;

  /* We'll use the form calls to get or set the value */
  xDJP.cb         = sizeof( xDJP );
  xDJP.ulProperty = DJP_CJ_FORM;
  xDJP.lType      = DJP_CURRENT;

  if ( ulAction == GET_PROP )
  {
    /* both current and all are same for now */
    lRC = djp_x_form( pdesPPD, (PDJP_ITEM)&xDJP, pCNFData, GET_PROP,
                      DJP_CJ_FORM );

    if ( lRC == DEV_OK )
    {
      pDJPMixedForm->lStartRange = DJP_MXF_INFINITY;
      pDJPMixedForm->lEndRange   = DJP_MXF_INFINITY;
      pDJPMixedForm->djpfmForm   = xDJP.Itype.Form;
    }
  }
  else  /* SET_PROP */
  {
    /* Check range */
    if ( ( pDJPMixedForm->lStartRange != DJP_MXF_INFINITY &&
           pDJPMixedForm->lStartRange != 1                 ) ||
         pDJPMixedForm->lEndRange != DJP_MXF_INFINITY         )
    { /* This is bad */
      pDJP->lType = DJP_ERROR_OUT_OF_RANGE;
      lRC = DEV_WARNING;
    }
    else /* Do the Set Prop */
    {
      xDJP.Itype.Form = pDJPMixedForm->djpfmForm; /* Copy data over */
      lRC = djp_x_form( pdesPPD, (PDJP_ITEM)&xDJP, pCNFData, SET_PROP,
                        DJP_CJ_FORM );
    }
  }

  return  lRC;
}


/*****************************************************************************\
**
** FUNCTION: ps_DJP
**
** DESCRIPTION: Main
**
\*****************************************************************************/

LONG ps_DJP(
       PREFDATA  pRefData,
       PDJP_ITEM pDJP,      //Ptr DJP
       PCNFDATA  pCNFData,  //Ptr to CnfData
       ULONG     ulAction   //Action to perform
     )
{
  PDESPPD  pdesPPD;
  LONG     lRC = DEV_OK;

  pdesPPD = pRefData->pdesPPD;

  //Can only set the CURRENT property!!
  if ( ulAction == SET_PROP      &&
       pDJP->lType != DJP_CURRENT )
  {
    pDJP->lType = DJP_ERROR_INV_PARMS;
    return DEV_BAD_PARAMETERS;
  }

  switch( pDJP->ulProperty )
  {
  case DJP_SJ_ORIENTATION:
    lRC = djp_s_orientation( pdesPPD, pDJP, pCNFData, ulAction );
    break;

  case DJP_CJ_RESOLUTION:
    lRC = djp_c_resolution( pdesPPD, pDJP, pCNFData, ulAction, DJP_CJ_RESOLUTION );
    break;

  case DJP_SJ_COLOR:
    lRC = djp_s_color( pdesPPD, pDJP, pCNFData, ulAction );
    break;

  case DJP_SJ_PRINTQUALITY:
    lRC = djp_c_resolution( pdesPPD, pDJP, pCNFData, ulAction, DJP_SJ_PRINTQUALITY );
    break;

  case DJP_CJ_FORM:
    lRC = djp_x_form( pdesPPD, pDJP, pCNFData, ulAction, DJP_CJ_FORM );
    break;

  case DJP_SJ_PAPERSIZE:
    lRC = djp_x_form( pdesPPD, pDJP, pCNFData, ulAction, DJP_SJ_PAPERSIZE );
    break;

//case DJP_CJ_TRAY:
//  lRC = djp_x_tray( pdesPPD, pDJP, pCNFData, ulAction, DJP_C_TRAY );
//  break;

  case DJP_SJ_TRAYTYPE:
    lRC = djp_x_tray( pdesPPD, pDJP, pCNFData, ulAction, DJP_SJ_TRAYTYPE );
    break;

  case DJP_SJ_DUPLEX:
    lRC = djp_s_duplex( pdesPPD, pDJP, pCNFData, ulAction );
    break;

  case DJP_SJ_COPIES:
    lRC = djp_s_CopyScale( pdesPPD, pDJP, pCNFData, ulAction, DJP_SJ_COPIES );
    break;

  case DJP_SJ_SCALING:
    lRC = djp_s_CopyScale( pdesPPD, pDJP, pCNFData, ulAction, DJP_SJ_SCALING );
    break;

  case DJP_CJ_OUTPUTBIN:
    lRC = djp_c_OutputBin( pdesPPD, pDJP, pCNFData, ulAction );
    break;

  case DJP_CJ_TRAYNAME:
    lRC = djp_x_tray( pdesPPD, pDJP, pCNFData, ulAction, DJP_CJ_TRAYNAME );
    break;

  case DJP_SJ_N_UP:
    lRC = djp_s_nup( pdesPPD, pDJP, pCNFData, ulAction );
    break;

  case DJP_CJ_MIXEDFORMS:
    lRC = djp_c_MixedForms( pdesPPD, pDJP, pCNFData, ulAction );

    break;

  case DJP_SJ_MEDIA:
  case DJP_SJ_FONTDOWNLOADING:

  //Properties below this line are not supported ( yet! )
  case DJP_SJ_BITSPERPEL:
  case DJP_SJ_FORMFEEDCONTROL:
  case DJP_SJ_MEDIA_COLOR:
  case DJP_SJ_COLLATE:
  case DJP_SJ_FEED:
  default:
    if ( ulAction == GET_SIZE )
    {
      pDJP->ulValue = SIMPLESIZE( 1 );
      break;
    }
    else  //GET_PROP or SET_PROP
    {
      pDJP->cb = sizeof( DJP_ITEM );
      pDJP->lType = DJP_ERROR_NOT_SUPPORTED;
      lRC = DEV_WARNING;
    }
  }

  return lRC;
}

/*****************************************************************************\
**
** FUNCTION: CheckDriverData
**
** DESCRIPTION:
**
\*****************************************************************************/

PCNFDATA CheckDriverData(
           PREFDATA   pRefData,
           PDRIVDATA  pDriveData
         )
{
  /********************************************/
  /* Note - this will make a COPY of the data */
  /********************************************/

  if ((pRefData->pLocalDD = InitializeLocalDRIVDATA( pDriveData,
                                                     pRefData->pdesPPD,
                                                     pRefData->achQueueName,
                                                     pRefData->pszDeviceName,
                                                     pRefData->pdv,
                                                     &pRefData->pCNFData ))
    == NULL)
  {
    return NULL;
  }

  return pRefData->pCNFData;
}


/*****************************************************************************\
**
** FUNCTION: pDJPQuerySize
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG psDJPQuerySize(
       PREFDATA pRefData,
       ULONG    ulInSize,    //Size of input list
       PULONG   pulInData,   //Ptr to list
       PULONG   pulOutSize,  //Ptr to Size of DriveData
       PULONG   pulOutData   //Ptr to DriveData
     )
{
  INT iPropCount;
  INT i = 0;
  LONG ulSizeNeeded = 0;
  PQUERYSIZE  pQS;
  PQUERYTUPLE pQT;
  DJP_ITEM djp;
  PCNFDATA  pCNFData;  //Ptr to CnfData

  //Parm check - ulInSize must be even multiple of 2 longs
  if ( ( ulInSize % ( 2 * sizeof( LONG ) ) ) != 0 )
  {
    GplErrSetError( PMERR_INVALID_PARAMETER );
    return DEV_ERROR;
  }

  //Check the Validity of Driver
  pCNFData = CheckDriverData( pRefData, (PDRIVDATA)pulOutData );
  if ( pCNFData == NULL )
  {
    GplErrSetError( PMERR_INVALID_PARAMETER );
    return DEV_ERROR;
  }

  iPropCount =  ulInSize / ( 2 * sizeof( LONG ) );
  pQS = (PQUERYSIZE)pulInData;   //Set up pointer to data
  pQT = (PQUERYTUPLE)&pQS->aTuples;

  while( pQT->lType != DJP_NONE && i < iPropCount )
  {
    // Set up structure
    djp.ulProperty = pQT->ulProperty;
    djp.lType = pQT->lType;

    //Make call
    ps_DJP( pRefData, &djp, pCNFData, GET_SIZE ) ;
    ulSizeNeeded += djp.ulValue;

    //Bump pointers
    pQT++;
    i++;
  }

  pQS->ulSizeNeeded = ulSizeNeeded + sizeof( DJP_ITEM );  /* Add in NONE too */

  /* Copy the data back to users buffer */
  CopyDRIVDATA( (PDRIVDATA)pulOutData, pRefData->pLocalDD );

  if ( pRefData->pLocalDD )
  {
    FreeLocalDRIVDATA( pRefData->pLocalDD );
  }

  return DEV_OK;
}


/*****************************************************************************\
**
** FUNCTION: psDJPQuerySetJobProperties
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG psDJPQuerySetJobProperties(
       PREFDATA pRefData,
       ULONG    ulInSize,    //Size of input list
       PULONG   pulInData,   //Ptr to list
       PULONG   pulOutSize,  //Ptr to Size of DriveData
       PULONG   pulOutData,  //Ptr to DriveData
       LONG     lAction      //Query or Set JP
     )
{
  ULONG        ulBytesRemaining;
  PDJP_ITEM    pDJP;
  PCNFDATA     pCNFData;  //Ptr to CnfData
  LONG         rc;
  BOOL         fWarningIssued = FALSE;
  INT          iItemCount = 0;
  PQUERYTUPLE  pTupleBase;
  PQUERYTUPLE  pTuple;

  //Need room for at least ONE item
  if ( ulInSize < sizeof( DJP_ITEM ) )
  {
    GplErrSetError( PMERR_INSUFFICIENT_MEMORY );
    return DEV_ERROR;
  }

  //Check the Validity of Driver
  pCNFData = CheckDriverData( pRefData, (PDRIVDATA)pulOutData );
  if ( pCNFData == NULL )
  {
    GplErrSetError( PMERR_INVALID_PARAMETER );
    return DEV_ERROR;
  }

  ulBytesRemaining = ulInSize;
  pDJP = (PDJP_ITEM)pulInData;

  /* Count the number of items */
  while( pDJP->lType != DJP_NONE && ulBytesRemaining >= sizeof( DJP_ITEM ) )
  {
    iItemCount++;
    ulBytesRemaining -= pDJP->cb;
    //On to next item
    pDJP = DJP_NEXT_STRUCTP( pDJP );
  }

  /* Allocate buffer for reference tuple */
  if ( ( pTupleBase = (PQUERYTUPLE)GplMemoryAlloc( pProcessHeap,
                             (iItemCount+1) * sizeof(QUERYTUPLE ) ) ) == NULL )
  {
    return DEV_ERROR;
  }

  /* Set up reference tuples */
  ulBytesRemaining = ulInSize;
  pDJP = (PDJP_ITEM)pulInData;
  pTuple = pTupleBase;
  while( pDJP->lType != DJP_NONE && ulBytesRemaining >= sizeof( DJP_ITEM ) )
  {
    pTuple->ulProperty = pDJP->ulProperty;
    pTuple->lType      = pDJP->lType;
    pTuple++;
    ulBytesRemaining -= pDJP->cb;
    //On to next item
    pDJP = DJP_NEXT_STRUCTP( pDJP );

  }

  /* Set the end marker */
  pTuple->ulProperty = pTuple->lType = DJP_NONE;

  ulBytesRemaining = ulInSize;
  pDJP = (PDJP_ITEM)pulInData;
  pTuple = pTupleBase;

  while( pTuple->lType != DJP_NONE && ulBytesRemaining >= sizeof( DJP_ITEM ) )
  {
    //Set byte count to whats left of buffer
    pDJP->cb         = ulBytesRemaining;
    /* Copy from reference tuples */
    pDJP->ulProperty = pTuple->ulProperty;
    pDJP->lType      = pTuple->lType;

    //Make call
    rc = ps_DJP( pRefData, pDJP, pCNFData, lAction ) ;
    if ( rc != DEV_OK )
    {
      if ( rc == DEV_ITEM_BUF_TOO_SMALL )
      { //Set this item to end of list;
        pDJP->cb         = sizeof( DJP_ITEM );
        pDJP->lType      = DJP_NONE;
        pDJP->ulProperty = DJP_NONE;
        pDJP->ulValue    = DJP_NONE;
        fWarningIssued = TRUE;
        break;
      }
      else
      if ( rc == DEV_WARNING )
      {
        fWarningIssued = TRUE;
      }
    }
    ulBytesRemaining -= pDJP->cb;

    //On to next item
    pDJP = DJP_NEXT_STRUCTP( pDJP );
    pTuple++;
  }

  /* Copy the data back to users buffer */
  CopyDRIVDATA( (PDRIVDATA)pulOutData, pRefData->pLocalDD );

  if ( pRefData->pLocalDD )
  {
    FreeLocalDRIVDATA( pRefData->pLocalDD );
  }

  GplMemoryFree( pTupleBase );

  if ( fWarningIssued )
  {
    rc = DEV_WARNING;
  }
  else
  {
    rc = DEV_OK;
  }
  return rc;
}


/*****************************************************************************\
**
** FUNCTION: psDJPDefaultJobProperties
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG psDJPDefaultJobProperties(
       PREFDATA pRefData,
       ULONG    ulInSize,    //Size of input list
       PULONG   pulInData,   //Ptr to list
       PULONG   pulOutSize,  //Ptr to Size of DriveData
       PULONG   pulOutData   //Ptr to DriveData
     )
{
  BOOL      fWarningIssued = FALSE;
  PCNFDATA  pCNFDataDef;   //Ptr to Default CnfData
  PCNFDATA  pCNFDataUser;  //Ptr to User CnfData
  PDJP_ITEM pDJP;
  PDRIVDATA pLocalDD;
  PUI_BLOCK pUIBlock;
  PUI_SEL   pUISelDef;
  PUI_SEL   pUISelUser;
  PDESPPD   pdesPPD;
  LONG      rc;
  ULONG     ulBytesRemaining;
  USHORT    usOrder;
  PGLCB     pLCBUser;
  PGLCB     pLCBDef;

  //Need room for at least ONE item
  if ( ulInSize < sizeof( DJP_ITEM ) )
  {
    GplErrSetError( PMERR_INSUFFICIENT_MEMORY );
  }
  pLCBUser = QueryLayoutCBFromCNFDATA( pCNFDataUser );

  //Check the Validity of Driver
  pCNFDataUser = CheckDriverData( pRefData, (PDRIVDATA)pulOutData );
  if ( pCNFDataUser == NULL )
  {
    GplErrSetError( PMERR_INVALID_PARAMETER );
    return DEV_ERROR;
  }
  /* Get a default set of properties */
  if ((pLocalDD = InitializeLocalDRIVDATA( NULL,
                                           pRefData->pdesPPD,
                                           pRefData->achQueueName,
                                           pRefData->pszDeviceName,
                                           pRefData->pdv,
                                           &pCNFDataDef ))
    == NULL)
  {
    return DEV_ERROR;
  }

  ulBytesRemaining = ulInSize;
  pDJP = (PDJP_ITEM)pulInData;

  pdesPPD = pRefData->pdesPPD;
  pUISelUser = ASSIGN_UISELLIST_PTR( pCNFDataUser );     /* User   */
  pUISelDef  = ASSIGN_UISELLIST_PTR( pCNFDataDef );      /* Defaut */

  while( pDJP->lType != DJP_NONE && ulBytesRemaining >= sizeof( DJP_ITEM ) )
  {
    switch( pDJP->ulProperty )
    {
    case DJP_SJ_ORIENTATION:
      pCNFDataUser->jobProperties.iOrient = pCNFDataDef->jobProperties.iOrient;
      break;

    case DJP_CJ_RESOLUTION:
    case DJP_SJ_PRINTQUALITY:
      pCNFDataUser->uResolution = pCNFDataDef->uResolution;
      break;

    case DJP_SJ_COLOR:
      pCNFDataUser->jobProperties.fIsColorDevice =
                                     pCNFDataDef->jobProperties.fIsColorDevice;
      break;

    /* For forms default the tray as well */
    case DJP_CJ_FORM:
    case DJP_SJ_PAPERSIZE:
    case DJP_CJ_MIXEDFORMS:
      strcpy( pCNFDataUser->jobProperties.szFormName,
                                       pCNFDataDef->jobProperties.szFormName );
      strcpy( pCNFDataUser->jobProperties.szFormSize,
                                       pCNFDataDef->jobProperties.szFormSize );
      strcpy( pCNFDataUser->u.iv.aTraySelected, pCNFDataDef->u.iv.aTraySelected );
      break;

    case DJP_SJ_TRAYTYPE:
    case DJP_CJ_TRAYNAME:
      strcpy( pCNFDataUser->u.iv.aTraySelected, pCNFDataDef->u.iv.aTraySelected );
      break;

    case DJP_SJ_DUPLEX:
      pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                        pdesPPD->pPSStringBuff,
                                        UINAME_DUPLEX,
                                        NULL );
      if ( pUIBlock )
      {
        usOrder = pUIBlock->usOrderDep;
        *( pUISelUser + usOrder ) = *( pUISelDef + usOrder );
      }
      break;

    case DJP_SJ_COPIES:
      pCNFDataUser->iCntCopies = 1;
      break;

    case DJP_SJ_SCALING:
      pCNFDataUser->jobProperties.uScale = 100;
      break;

    case DJP_CJ_OUTPUTBIN:
      pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                        pdesPPD->pPSStringBuff,
                                        UINAME_OUTPUTBIN,
                                        NULL );
      if ( pUIBlock )
      {
        usOrder = pUIBlock->usOrderDep;
        *( pUISelUser + usOrder ) = *( pUISelDef + usOrder );
      }
      break;

    case DJP_SJ_N_UP:
      pLCBUser->layout.nUP.ulNumPgSheet = pLCBDef->layout.nUP.ulNumPgSheet;
      break;

    case DJP_SJ_MEDIA:
    case DJP_SJ_FONTDOWNLOADING:
    case DJP_SJ_COLLATE:
    case DJP_SJ_FEED:

    //Properties below this line are not supported ( yet! )
    case DJP_SJ_BITSPERPEL:
    case DJP_SJ_FORMFEEDCONTROL:
    case DJP_SJ_MEDIA_COLOR:
    default:
      break;
    }


    ulBytesRemaining -= sizeof( DJP_ITEM );

    //On to next item
    pDJP = DJP_NEXT_STRUCTP( pDJP );
  }

  /* Copy the data back to users buffer */
  CopyDRIVDATA( (PDRIVDATA)pulOutData, pRefData->pLocalDD );

  if ( pRefData->pLocalDD )
  {
    FreeLocalDRIVDATA( pRefData->pLocalDD );
  }
  if ( pLocalDD )
  {
    FreeLocalDRIVDATA( pLocalDD );
  }

  if ( fWarningIssued )
  {
    rc = DEV_WARNING;
  }
  else
  {
    rc = DEV_OK;
  }
  return rc;
}


/*****************************************************************************\
**
** FUNCTION: OS2_PM_DRV_POSTESCAPE
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG  APIENTRY OS2_PM_DRV_POSTESCAPE(
                 PSZ pszDriverName,
                 PSZ pszDeviceName,
                 PSZ pszQueueName,
                 PSZ pszSplPrinterName,
                 ULONG ulFuncNum,
                 ULONG cbParm1,
                 PBYTE pbParm1,
                 ULONG cbParm2,
                 PBYTE pbParm2
               )
{
  PDESPPD   pdesPPD;                     // PPD description buffer
  REFDATA   RefData;
  LONG      lRC;

#ifdef DISABLE_DJP_SUPPORT
  return DEVPE_NOTIMPLEMENTED;
#endif

  if ( ULGreVersion == 0 )
  {
    ULGreVersion = GreQueryEngineVersion();
  }

  if ( ULGreVersion < GRE_234 )
  {
      return DEVPE_NOTIMPLEMENTED;
  }

  // Validate driver name
  // @V4.0169885
  if ( strcmp( pszDriverName, PSCRIPT_DRV_NAME ) != 0 )
  {
    return DEVPE_ERROR;
  }

  //Get PPB data for device
  if ((pdesPPD = LoadPPBResource( NULL, pszDeviceName )) == NULL)
  {
    return DEVPE_ERROR;
  }

  /* Set up the reference data */
  RefData.pdesPPD = pdesPPD;
  RefData.pszDeviceName = pszDeviceName;
  RefData.pdv = NULL;
//ASSERTT( strlen( pszQueueName ) >= sizeof( RefData.achQueueName ) );
  strcpy( RefData.achQueueName, pszQueueName );

  switch( ulFuncNum )
  {
  case DEVPE_QUERYSUPPORT:

    switch ( *pbParm1 )
    {
    case DEVPE_QUERYSUPPORT:
    case DEVPE_QUERYSIZE:
    case DEVPE_QUERYJOBPROPERTIES:
    case DEVPE_SETJOBPROPERTIES:
    case DEVPE_DEFAULTJOBPROPERTIES:
      lRC = DEV_OK;
      break;

    default:
      lRC = DEVPE_NOTSUPPORTED;
    }
    break;

  case DEVPE_QUERYSIZE:
    lRC = psDJPQuerySize( &RefData, cbParm1, (PULONG)pbParm1, (PULONG)&cbParm2,
                          (PULONG)pbParm2 );
    break;

  case DEVPE_QUERYJOBPROPERTIES:
    lRC = psDJPQuerySetJobProperties( &RefData, cbParm1, (PULONG)pbParm1,
                                 (PULONG)&cbParm2, (PULONG)pbParm2, GET_PROP );
    break;

  case DEVPE_SETJOBPROPERTIES:
    lRC = psDJPQuerySetJobProperties( &RefData, cbParm1, (PULONG)pbParm1,
                                 (PULONG)&cbParm2, (PULONG)pbParm2, SET_PROP );
    break;

  case DEVPE_DEFAULTJOBPROPERTIES:
    lRC = psDJPDefaultJobProperties(&RefData, cbParm1, (PULONG)pbParm1,
                                 (PULONG)&cbParm2, (PULONG)pbParm2 );
    break;

  default:
    lRC = DEVPE_NOTSUPPORTED;
  }

  if ( pdesPPD )
  {
    FreePPBResource( pdesPPD );
  }

  return lRC;
}


/*****************************************************************************\
**
** FUNCTION: DJPSetUpRefData
**
** DESCRIPTION:
**
\*****************************************************************************/

LONG DJPSetUpRefData(
       PDDC pddc,
       PREFDATA pRefData
     )
{
  PDESPPD pdesPPD = pddc->pdv->pdesPPD;
  CHAR    achKeyName[128];
  PCHAR   pchComma;

  pRefData->pdesPPD = pdesPPD;
  pRefData->pszDeviceName = pdesPPD->pPSStringBuff +
                                                   pdesPPD->desItems.ofsPrName;

  pRefData->pdv = pddc->pdv;
  //Get the Queuename form the PM_DD_ name
  strcpy( achKeyName, pddc->pdv->pCNFData->szKeyApp + 6 );
  if ( pchComma = strchr( achKeyName, ',' ) )
  {
    *pchComma = '\0';
  }
  strcpy( pRefData->achQueueName, achKeyName );

  return 0;
}


/*****************************************************************************\
**
** FUNCTION: DJPResetStartDoc
**
** DESCRIPTION:
**
\*****************************************************************************/
LONG DJPResetStartDoc(
       PDDC      pddc,
       PREFDATA  pRefData,
       PULONG    pDrivData,
       ULONG     ulEscCode
     )
{
  PCNFDATA  pCNFData;  //Ptr to CnfData
  PDV       pdv = pddc->pdv;
  CHAR      achObjectName[50];
  HMODULE   hModuleGre;
//PBYTE     pValue;
  PBYTE     pOldValue;
  PBYTE     pNewValue;
  BOOL      fRestrictions = FALSE;
  BOOL      fNoDuplexChange = FALSE;

  /* Check the new JOB Props */
  pCNFData = CheckDriverData( pRefData, (PDRIVDATA)pDrivData );

  if ( pCNFData == NULL )
  { /* return error if needed */
    return DEV_ERROR;
  }

  // @V4.1193787
  // First do a blatant check - see if buffers are same
  // If so then free new data and return
  if ( pdv->dop.pdriv != NULL                    &&
       pRefData->pLocalDD != NULL                &&
       pdv->dop.pdriv->cb == pRefData->pLocalDD->cb )
  {
    if ( memcmp( (PBYTE)pdv->dop.pdriv,
                 (PBYTE)pRefData->pLocalDD,
                  pRefData->pLocalDD->cb ) == 0       ||
         CompareDJPProps( pddc,
                          pRefData,
                          pCNFData ) == DJP_PROPS_SAME )
    {
      FreeLocalDRIVDATA( pRefData->pLocalDD );
      return DEV_OK;
    }
  }

  /* Copy flags over from old to new */
  pCNFData->ulFlags = pdv->pCNFData->ulFlags;
  pCNFData->lFontCount = pdv->pCNFData->lFontCount;   //defect 229766

  /* IF duplex has not changed don't reissue in header */
   pOldValue = (PCHAR)QueryUIOptionString( pdv->pdesPPD,
                                           ASSIGN_UISELLIST_PTR( pdv->pCNFData ),
                                           UINAME_DUPLEX,
                                           NULL,
                                           NULL );
   pNewValue = (PCHAR)QueryUIOptionString( pdv->pdesPPD,
                                           ASSIGN_UISELLIST_PTR( pCNFData ),
                                           UINAME_DUPLEX,
                                           NULL,
                                           NULL );
  if ( pOldValue != NULL && pNewValue != NULL )
  {
    if ( strcmp( pOldValue, pNewValue ) == 0 )  //The same - no change
    {
      fNoDuplexChange = TRUE;
      ClearUISelection( pdv->pdesPPD, pCNFData, (PSZ) UINAME_PAGESIZE );
    }
    else  //Hey there's a change so activate change
    {
      SETFLAG( pCNFData->ulFlags, DUPLEX_CHANGED );
    }
  }

  /*
  ** Some things can't be changed after a startdoc such as Nup and duplex
  ** Take care of that here by copping the old data to new struct
  */
  if ( ulEscCode == DEVESC_NEWFRAME_WPROP )
  {
/// /* If there is duplex  then change restrictions apply */
/// if ( ( pValue = (PCHAR)QueryUIOptionString( pddc->pdv->pdesPPD,
///                                             ASSIGN_UISELLIST_PTR( pdv->pCNFData ),
///                                             UINAME_DUPLEX,
///                                             NULL,
///                                             NULL ) ) != NULL )
/// {
///   if ( strcmp( pValue, UINAME_DUPLEXNONE ) )
///   {
///     fRestrictions = TRUE;
///   }
/// }
/// /* If Nup is on restictions apply */
/// if ( pdv->pCNFData->gjfncb.ulNumPgSheet > 1 )
    if ( pddc->pdv->sNupPage )
    {
      fRestrictions = TRUE;
    }
/// else
/// {
///   pCNFData->gjfncb.ulNumPgSheet = 1;  /* Can't change in middle */
///   /* If doing NUP don't change except to turn off */
///   if ( pdv->pCNFData->gjfncb.ulNumPgSheet > 1  )
///   {
///     /* Keep the same */
///     if ( pCNFData->gjfncb.ulNumPgSheet != 1 )
///     {
///       pCNFData->gjfncb.ulNumPgSheet = pdv->pCNFData->gjfncb.ulNumPgSheet;
///       fRestrictions = TRUE;
///     }
///     else  /* Turning off */
///     {
///       pddc->pdv->sNupPage = 0;
///       fRestrictions = FALSE;
///     }
///   }
/// }
  }

  /* If there are restrictions then copy the OK new stuff to the old and free
  ** the new data
  */
  if ( fRestrictions )
  {
    /* use new orientation */
/// pdv->pCNFData->jobProperties.iOrient = pCNFData->jobProperties.iOrient;

    /* Free the NEW data */
    FreeLocalDRIVDATA( pRefData->pLocalDD );
    pCNFData = pdv->pCNFData;
  }
  else
  {
    /* Free old data */
    if ( pdv->pCNFData != NULL )
    {
      FreeLocalDRIVDATA( pdv->dop.pdriv );
    }
    pdv->pCNFData = pCNFData;
    pdv->dop.pdriv = pRefData->pLocalDD;
  }

  /* Free pattern stuff */
  if (pddc->iType == OD_MEMORY)
  {
    if ( pdv->fAllocatedPatterns )
    {
      pdv->fAllocatedPatterns = (BOOL) !
                     GplPatternDeleteBitmaps( pdv->pDCHeap,
                     (PBMAPINFO)pddc->pDeviceSurface->abmapinfoDefPattern,
                     DEFAULT_PATTERNS_NUMBER );
    }
  }

  SetCanvasMetrics( &pdv->canvas, pRefData->pdesPPD, pCNFData );

  /* Lets resync the engine */
  if( pfnSetDeviceSurface == NULL )
  {
           DosLoadModule( achObjectName,
                          sizeof (achObjectName),
                          "PMGRE",
                          &hModuleGre );

           DosQueryProcAddr( hModuleGre,
                             0,
                             "SETDEVICESURFACE",
                             &pfnSetDeviceSurface );
  }

  QueryDeviceSurface(  pddc, pddc->pDeviceSurface );

  pfnSetDeviceSurface( pddc->hdc, pddc->pDeviceSurface );

  GreResetDC2 (pddc->hdc, 0);

  /* @V4.0161544
  ** This block has been moved to after the reset dc since the
  ** PS header needs some data from the engine such as the correct
  ** initial transform
  */
  if ( fRestrictions == FALSE             &&
       pddc->pdv->fDocStarted              )  /* Do only if already started */
  {
    if ( pdv->pUISelectList != NULL )
    {
      GplMemoryFree( pdv->pUISelectList );
    }
    // @V4.0167773
    pdv->pUISelectList = ConvertUIBitsToStrings( pddc->pdv, pCNFData );

    PrintChannel( pddc, "SavedState0 restore\n" ); /* Clean off saved states */

    
    if ( ( ulEscCode == DEVESC_STARTDOC_WPROP )                      &&
       ( pddc->pdv->pCNFData->gjfncb.ulFlags & GNDF_BOOKLETENABLED ) &&  
       GplBookletEnabled( pddc->pdv->hThread ))
    {
      FlushChannel( pddc );
      GplBookletSetOutput( pddc->pdv->hThread, BOOKLET_OUTPUT_SETUP );   
    }
    

    PrintChannel( pddc, "mDef sm\n" );  /* Must go back to default matrix */
    PSDocSetUp( pddc, FALSE );
/// if ( ulEscCode == DEVESC_STARTDOC_WPROP )
/// {
    if ( !CHECKFLAG( pddc->pdv->pCNFData->ulFlags, NOT_NUP_1ST ) )
    {
      /* output nup stuff */
      NupSetUp( pddc );                                                  //Nup
      /* For Nup setup the first page */
      PSNup( pddc );
    }
/// }
    PrintChannel( pddc, "/SavedState0 save def\n" );
  }

  /* If we turned off duplex for header reset back now */
  if ( fNoDuplexChange == TRUE )
  {
      SetUIOption( pdv->pdesPPD, ASSIGN_UISELLIST_PTR( pCNFData ),
                   UINAME_DUPLEX, pNewValue );
  }

  
  if ( ( ulEscCode == DEVESC_STARTDOC_WPROP )                        &&
       ( pddc->pdv->pCNFData->gjfncb.ulFlags & GNDF_BOOKLETENABLED ) &&   
       GplBookletEnabled( pddc->pdv->hThread ) )
  {
    FlushChannel( pddc );
    GplBookletResetOutput( pddc->pdv->hThread );    
  }
  

  return DEV_OK;
}

#if 0
///*****************************************************************************\
//**
//** FUNCTION: DJPNewFrame
//**
//** DESCRIPTION:
//**
//\*****************************************************************************/
//LONG DJPNewFrame(
//       PDDC      pddc,
//       PREFDATA  pRefData,
//       PULONG    pDrivData
//     )
//{
//  PCNFDATA  pCNFData;  //Ptr to CnfData
//  PDV       pdv = pddc->pdv;
//  ULONG     ulRC;
//
//  PSDocSetUp( pddc, FALSE );
//
//  /* Reset the DC */
//  ulRC = DJPResetStartDoc( pddc, pRefData, pDrivData, DEVESC_NEWFRAME_WPROP );
//  if ( ulRC != DEV_OK )
//  {
//    return ulRC;
//  }
//
//  return DEV_OK;
//}
#endif


/*****************************************************************************\
**
** FUNCTION: NewHardCopyCaps
**
** DESCRIPTION: Worker for prdq_QueryHardcopyCaps
**
\*****************************************************************************/

LONG NewHardCopyCaps( LONG    lStart, //Index.
                      LONG    cCount, //Number of forms.
                      PHCINFO pInfo,  //Pointer to buffer for returned form data.
                      PDDC    pddc    //Pointer to instance data.
                    )
{
  PDESPPD     pdesPPD;   //Ptr to DESPPD
  PCNFDATA    pCNFData;  //Ptr to CnfData
  PRESOLUTION pRes;
  FORMLIST    FormList;
  PFORMLIST   pFormList;
  PFORMINFO   pFormInfo;
  PTRAYLIST   pTrayList;
  INT         iFormCount;
  INT         iTrayCount;
  INT         i;
  RESOLUTION  Res;

  pdesPPD  = pddc->pdv->pdesPPD;
  pCNFData = pddc->pdv->pCNFData;
  pRes     = &pddc->pdv->canvas.Res;

  /* The resolutions have been reversed for landscape. Put them back for
  ** FillHCInfoStruc
  */
  if ( pCNFData->jobProperties.iOrient == PORTRAIT )              //@V3.1154783
  { /* Portrait */                                                //@V3.1154783
    Res.x = pRes->x;                                              //@V3.1154783
    Res.y = pRes->y;                                              //@V3.1154783
  }                                                               //@V3.1154783
  else                                                            //@V3.1154783
  {                                                               //@V3.1154783
    Res.x = pRes->y;                                              //@V3.1154783
    Res.y = pRes->x;                                              //@V3.1154783
  }                                                               //@V3.1154783
  pRes = &Res;                                                    //@V3.1154783

  /* If caller just wants count, return count of all forms */
  if ( cCount == 0 )
  {
    pFormList = &FormList;
    iFormCount = LoadFormList( pdesPPD, pCNFData, (LONG)FORM_COUNT, &pFormList );

    /* since used flag of count no need to free list */
    return iFormCount;
  }

  /* Load up lists */
  iFormCount = LoadFormList( pdesPPD, pCNFData, (LONG)(FORM_NAMES | FORM_SIZES),
                              &pFormList );
  iTrayCount = LoadTrayList( pdesPPD, pCNFData, (LONG)TRAY_NAMES, &pTrayList );

  FillHCInfoStruc( pdesPPD, pCNFData, pFormList, pTrayList, pRes );

  /*
  ** If the app requested an index that is higher than the number of forms,
  ** return an error.
  */
  if (lStart >= iFormCount)
  {
    return( DQHC_ERROR );
  }

  /* If count to big reset to total number of forms */
  if ( cCount > iFormCount )
  {
    cCount = iFormCount;
  }

  pFormInfo = pFormList->aForms;  /* Set to start of list */

  /*
  ** Hop over forms to get to lStart
  */
  for ( i = 0; i < lStart; i++ )
  {
    pFormInfo++;
  }

  /*
  ** @V3.1155191
  ** Copy structures over
  */
  for ( i = lStart; i < ( lStart + cCount ); i++ )
  {
    *pInfo = pFormInfo->HCInfo;
    pInfo++;
    pFormInfo++;
  }

  /*
  ** Clean up
  */
  FreeFormList( pFormList );
  FreeTrayList( pTrayList );

  return i;
}


/*****************************************************************************\
**
** FUNCTION NAME = GetOldFormName
**
** DESCRIPTION
** Given an form name will return the old style name - the imageable area
** name w translation string attached
**
** pszNewName is the current form name.
** pszOldName is the old name with translation string that is returned.
**
\*****************************************************************************/

BOOL GetOldFormName( PDESPPD  pdesPPD    ,
                     PSZ      pszNewName ,
                     PSZ      pszOldName )
{
  PUI_BLOCK  pUIBlock;
  INT        iFormCount;
  INT        i;
  FORMSTRUCT FormStruct;

  /* set up access */
  pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                     pdesPPD->pPSStringBuff,
                                     UINAME_PAGESIZE,
                                     NULL );
  iFormCount = (INT)pUIBlock->usNumOfEntries; /* set count */

  strcpy( pszOldName, pszNewName );           /* copy over name */

  for ( i = 0; i < iFormCount; i++ )          /* Search list */
  {
    GetImageableArea( i, (PFORMSTRUCT)&FormStruct, pdesPPD,
                      pdesPPD->pPSStringBuff );
    if ( strcmp( pszNewName, FormStruct.FormName ) == 0 )
    {                                         /* a match */
      if ( FormStruct.OldSuffix[ 0 ] )
      {                                       /* there is a translation name */
        strcat( pszOldName, "/" );            /* Add slash */
        strcat( pszOldName, FormStruct.OldSuffix );
        return TRUE;
      }
      break;
    }
  }

  return FALSE;
}


/*****************************************************************************\
**
** FUNCTION NAME = ConvertOldJpToNew
**
** DESCRIPTION
** Converts the old Job Properties ( pre UI/Constraints ) to new format
** Changes to be done: Remove translation string from form name
**
**
\*****************************************************************************/

VOID ConvertOldJpToNew( PDRIVDATA pLocalDrivData,
                        PDESPPD  pdesPPD        )
{
  PCNFDATA   pCNFData;
  PSZ        pszSlash;
  PCHAR      pValue;
  PUI_BLOCK  pUIBlock;
  XDJPITEM   xDJP;


  /* Remove any translation strings */
  pCNFData = (PCNFDATA) pLocalDrivData->abGeneralData;

  if ( pszSlash = strchr( pCNFData->jobProperties.szFormName, '/' ) )
  {
    *pszSlash = '\0';
  }

  /* If no tray then set to default */
  if ( pCNFData->u.iv.aTraySelected[ 0 ] == '\0' )
  {
    pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                       pdesPPD->pPSStringBuff,
                                       UINAME_INPUTSLOT,
                                       NULL );
    if ( pUIBlock ) /* Some strings? */
    { /* Copy the default tray into var */
      pValue = (pdesPPD->pPSStringBuff +
                    pUIBlock->uiEntry[ pUIBlock->usDefaultEntry ].ofsOption);
      strcpy( pCNFData->u.iv.aTraySelected, pValue );
    }
    else  /* Can't find default, use autotray */
    {
      strcpy( pCNFData->u.iv.aTraySelected, AUTOTRAY_STRING );
    }
  }
/* @V4.0167159
** Look at the pCNFData which can be older since it comes from JP
*/
//if ( pLocalDrivData->lVersion < DRIVERSION_3_11 )
  if ( pCNFData->lVersion < DRIVERSION_3_11 )
  {
    pValue = NULL;

    //@V4.0167159 since it's converted bump number
    pCNFData->lVersion = pLocalDrivData->lVersion;

    /*
    ** Convert the old duplex
    */
    switch ( pCNFData->sDuplexMode )
    {
    case DUPLEX_NONE: /* Nothing to do no duplex */
      break;

    case DUPLEX_FALSE:
      pValue = UINAME_DUPLEXNONE;
      break;

    case DUPLEX_DUPLEXNOTUMBLE:
      pValue = UINAME_DUPLEXNOTUMBLE;
      break;

    case DUPLEX_DUPLEXTUMBLE:
      pValue = UINAME_DUPLEXTUMBLE;
      break;

    default:
      break;
    }
    if ( pValue                                                    &&
         ( pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                             pdesPPD->pPSStringBuff,
                                             UINAME_DUPLEX,
                                             NULL ) )                )
    {
      SetUIOption( pdesPPD,
                   ASSIGN_UISELLIST_PTR( pCNFData ),
                   UINAME_DUPLEX,
                   (PBYTE)pValue );
    }

    /*
    ** Convert maunual feed
    */
    if ( pCNFData->jobProperties.iManualfeed == TRUE )
    {
      strcpy( pCNFData->u.iv.aTraySelected, MANUALFEED_STRING );
      if ( pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                               pdesPPD->pPSStringBuff,
                                               UINAME_MANUALFEED,
                                               NULL )                  )
      {
        SetUIOption( pdesPPD,
                     ASSIGN_UISELLIST_PTR( pCNFData ),
                     UINAME_MANUALFEED,
                     (PBYTE)"True" );
      }
    }

    /*
    ** Convert the resolution
    */

    if (pCNFData->uResolution == 0)
    {
      pCNFData->uResolution = pdesPPD->desItems.iResDpi;
    }

    /* Call djp_c_resolution to set the resolution */
    xDJP.cb         = sizeof( xDJP );
    xDJP.ulProperty = DJP_CJ_RESOLUTION;
    xDJP.lType      = DJP_CURRENT;
    xDJP.Itype.Res.usXResolution = pCNFData->uResolution;
    xDJP.Itype.Res.usYResolution = pCNFData->uResolution;

    djp_c_resolution( pdesPPD, (PDJP_ITEM)&xDJP, pCNFData, SET_PROP,
                      DJP_CJ_RESOLUTION );

  }

  return;
}


/*****************************************************************************\
**
** FUNCTION NAME = ConvertNewJpToOld
**
** DESCRIPTION
** Converts the new Job Properties ( post UI/Constraints ) to old format
** Changes to be done: Add translation string to form name
**
**
\*****************************************************************************/

VOID ConvertNewJpToOld( PDRIVDATA pLocalDrivData,
                        PDESPPD  pdesPPD        )
{
  PCNFDATA   pCNFData;
  PCHAR      pValue;
  XDJPITEM   xDJP;

  /* Remove any translation strings */
  pCNFData = (PCNFDATA) pLocalDrivData->abGeneralData;

  GetOldFormName( pdesPPD, pCNFData->jobProperties.szFormName,
                           pCNFData->jobProperties.szFormName );

  /* Make sure old duplex is set for older drivers */
  pCNFData->sDuplexMode = DUPLEX_FALSE;
    if ( ( pValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                                ASSIGN_UISELLIST_PTR( pCNFData ),
                                                UINAME_DUPLEX,
                                                NULL,
                                                NULL ) )  != NULL )
  {
    if ( ! strcmp( pValue, UINAME_DUPLEXTUMBLE ) )
    {
      pCNFData->sDuplexMode = DUPLEX_DUPLEXTUMBLE;
    }
    else
    if ( ! strcmp( pValue, UINAME_DUPLEXNOTUMBLE ) )
    {
      pCNFData->sDuplexMode = DUPLEX_DUPLEXNOTUMBLE;
    }
  }

  /* Set manaual feed*/
  pCNFData->jobProperties.iManualfeed = FALSE;
  if ( ( pValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                              ASSIGN_UISELLIST_PTR( pCNFData ),
                                              UINAME_MANUALFEED,
                                              NULL,
                                              NULL ) )  != NULL )
  {
    if ( strcmp( pValue, UINAME_MANUALFEED_ON ) == 0 )
    {
      pCNFData->jobProperties.iManualfeed = TRUE;
    }
  }

  /* Set the resolution */
  /* Call djp_c_resolution to get the resolution */
  xDJP.cb         = sizeof( xDJP );
  xDJP.ulProperty = DJP_CJ_RESOLUTION;
  xDJP.lType      = DJP_CURRENT;
  djp_c_resolution( pdesPPD, (PDJP_ITEM)&xDJP, pCNFData, GET_PROP,
                    DJP_CJ_RESOLUTION );
  pCNFData->uResolution = xDJP.Itype.Res.usXResolution;

  return;
}


/*****************************************************************************\
**
** FUNCTION NAME = SetNewFormName
**
** DESCRIPTION
** Given a new formname will set the JPs to it
**
\*****************************************************************************/

LONG SetNewFormName( PSZ       pszFormName  , //Form Name
                     PDESPPD   pdesPPD      , //Ptr to DESPPD
                     PCNFDATA  pCNFData     ) //Ptr to CnfData
{
  XDJPITEM          xDJP;
  LONG              lRC;

  memset( &xDJP, sizeof( XDJPITEM ), 0 ); /* wipe item */

  xDJP.cb         = sizeof( xDJP );
  xDJP.ulProperty = DJP_CJ_FORM;
  xDJP.lType      = DJP_CURRENT;
  strcpy( xDJP.Itype.Form.szFormname, pszFormName );

  lRC = djp_x_form( pdesPPD, (PDJP_ITEM)&xDJP, pCNFData, SET_PROP, DJP_CJ_FORM );

  return lRC;
}

/*
** @V4.0146711
*/
/*****************************************************************************\
**
** FUNCTION NAME = GetMaxRes
**
** DESCRIPTION
** Will return the highest res of a printer
**
\*****************************************************************************/

INT GetMaxRes( PDESPPD     pdesPPD  , //Ptr to DESPPD
               PCNFDATA    pCNFData ) //Ptr to CnfData
{
  DJPRESLIST         ResList;

  LoadResList( &ResList, pdesPPD, pCNFData,  RES_LIST );

  return ( ResList.aRes[0].Res.x );
}


//@V4.1193787
/*****************************************************************************\
**
** FUNCTION NAME: CompareDJPProps
**
** DESCRIPTION: Given two Job Props will see if different in a DJP sense
**
\*****************************************************************************/

ULONG CompareDJPProps( PDDC     pddc,
                       PREFDATA pRefData,
                       PCNFDATA pCNFDataNew )
{
  ULONG     ulMisMatch = DJP_PROPS_SAME;
  PCNFDATA  pCNFDataOld;
  PDESPPD   pdesPPD;
  PDV       pdv = pddc->pdv;
  PSZ       pNewValue;
  PSZ       pOldValue;

  pCNFDataOld = pdv->pCNFData;

  pdesPPD = pRefData->pdesPPD;


  // DJP_SJ_ORIENTATION:
  if ( pCNFDataNew->jobProperties.iOrient !=
                                           pCNFDataOld->jobProperties.iOrient )
  {
    ulMisMatch = DJP_SJ_ORIENTATION;
  }
  else
  // DJP_CJ_RESOLUTION:
  // DJP_SJ_PRINTQUALITY:
  if ( pCNFDataNew->uResolution != pCNFDataOld->uResolution )
  {
  }
  else
  // DJP_SJ_COLOR:
  if ( pCNFDataNew->jobProperties.fIsColorDevice !=
                                    pCNFDataOld->jobProperties.fIsColorDevice )
  {
    ulMisMatch = DJP_SJ_COLOR;
  }
  else
  // DJP_CJ_FORM:
  // DJP_SJ_PAPERSIZE:
  // DJP_CJ_MIXEDFORMS:
  if ( strcmp( pCNFDataNew->jobProperties.szFormName,
               pCNFDataOld->jobProperties.szFormName ) != 0 ||
       strcmp( pCNFDataNew->jobProperties.szFormSize,
               pCNFDataOld->jobProperties.szFormSize ) != 0 ||
       strcmp( pCNFDataNew->u.iv.aTraySelected,
               pCNFDataOld->u.iv.aTraySelected ) != 0        )
  {
    ulMisMatch = DJP_CJ_FORM;
  }
  else
  // DJP_SJ_TRAYTYPE:
  // DJP_CJ_TRAYNAME:
  if ( strcmp( pCNFDataNew->u.iv.aTraySelected,
               pCNFDataOld->u.iv.aTraySelected ) != 0 )
  {
    ulMisMatch = DJP_SJ_TRAYTYPE;
  }
  else
  //DJP_SJ_COPIES:
  if ( pCNFDataNew->iCntCopies != pCNFDataOld->iCntCopies )
  {
    ulMisMatch = DJP_SJ_COPIES;
  }
  else
  // DJP_SJ_SCALING:
  if ( pCNFDataNew->jobProperties.uScale !=
                                           pCNFDataOld->jobProperties.uScale )
  {
    ulMisMatch = DJP_SJ_SCALING;
  }
  else
  // DJP_SJ_N_UP:
  if ( pCNFDataNew->gjfncb.ulNumPgSheet != pCNFDataOld->gjfncb.ulNumPgSheet )
  {
    ulMisMatch = DJP_SJ_N_UP;
  }
  else
  {
    // DJP_SJ_DUPLEX:
    pOldValue = (PCHAR)QueryUIOptionString( pdv->pdesPPD,
                                            ASSIGN_UISELLIST_PTR( pCNFDataOld ),
                                            UINAME_DUPLEX,
                                            NULL,
                                            NULL );
    pNewValue = (PCHAR)QueryUIOptionString( pdv->pdesPPD,
                                            ASSIGN_UISELLIST_PTR( pCNFDataNew ),
                                            UINAME_DUPLEX,
                                            NULL,
                                            NULL );
    if (  pNewValue == NULL || pOldValue == NULL )
    {
      if ( pNewValue != pOldValue )
      {
        ulMisMatch = DJP_SJ_DUPLEX;
      }
    }
    else
    if ( strcmp( pNewValue, pOldValue ) != 0 )
    {
      ulMisMatch = DJP_SJ_DUPLEX;
    }
  }

  if ( ulMisMatch == 0 )
  {
    // DJP_CJ_OUTPUTBIN:
    pOldValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                            ASSIGN_UISELLIST_PTR( pCNFDataOld ),
                                            UINAME_OUTPUTBIN,
                                            NULL,
                                            NULL );

    pNewValue = (PCHAR)QueryUIOptionString( pdesPPD,
                                            ASSIGN_UISELLIST_PTR( pCNFDataNew ),
                                            UINAME_OUTPUTBIN,
                                            NULL,
                                            NULL );
    if (  pNewValue == NULL || pOldValue == NULL )
    {
      if ( pNewValue != pOldValue )
      {
        ulMisMatch = DJP_CJ_OUTPUTBIN;
      }
    }
    else
    if ( strcmp( pNewValue, pOldValue ) != 0 )
    {
      ulMisMatch = DJP_CJ_OUTPUTBIN;
    }
  }

  return ulMisMatch;
}

