/******************************************************************************/
/******************************************************************************/
/* PKGPS.CMD    - this procedure packages the POSCRIPT print driver so that   */
/*                it is installable.                                          */
/* Parameter:                                                                 */
/*    version   - version to attach to drv                                    */
/*    drvname   - the driver file (path & file )                              */
/*    drvdevlst - output filename for the prdesc list file for this driver    */
/***********************Change History*****************************************/
/* Date:    Change:                                 Dev.    Tag:      DCR/PTR */
/* 6/01/95  created this program                    rakesh                    */
/******************************************************************************/


parse arg  version drvname ppbfile drvdevlst basename

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

                                                           /* init variables */
/*
//rdrvfiles ='PSCRIPT.DRV,PSCRIPT.HLP'
//odrvfiles ='PSCRIPT.SYM,PSHLP.SYM,*.PFA,*.PFM'
//vendor    ='PSCRIPT'
*/


  rdrvfiles = basename'.DRV,'basename'.HLP'
  odrvfiles = basename'.SYM,PSHLP.SYM,*.PFA,*.PFM'
  vendor    = basename
  devnames  = GetPscriptDevNames( ppbfile )

                                                          /* write EA to drv */
  rc=SysPutEA(drvname,"REQUIREDDRIVERFILES",EAFormat( rdrvfiles ) )
  rc=SysPutEA(drvname,"OPTIONALDRIVERFILES",EAFormat( odrvfiles ) )
  rc=SysPutEA(drvname,"VENDORNAME",         EAFormat( vendor    ) )
  rc=SysPutEA(drvname,".VERSION",           EAFormat( version   ) )
  rc=SysPutEA(drvname,".EXPAND",            EAFormat( devnames  ) )
  rc=SysSetIcon(drvname,"LASER.ICO")

                                                          /* generate prdesc */
  rc = GenDrvDevLst(strip(drvdevlst),drvname,devnames)

return 0


/***********************************************/
/* GetPscriptDevNames - returns devnames list  */
/*   that will be attach as EA to the driver   */
/* format: dev0dev0...dev00                    */
/***********************************************/
GetPscriptDevNames: PROCEDURE
  parse arg DirFile
  devnames = ''
  do i=0 to 9999
    devstr=CHARIN(DirFile,,48)
    devstr=strip( substr(devstr,1,40),'B',X2C('0') )
    if devstr = "" then leave
    devnames = devnames || devstr ||  X2C('00')
  end
  say 'Found' i 'PSCRIPT devices in' DirFile
return devnames ||  X2C('00')




/***********************************************/
/* GenDrvDevLst - generates a prdesc list file */
/*  given the devnames (case dev = desc     )  */
/***********************************************/
GenDrvDevLst: PROCEDURE

  parse arg LstFile, driver, devnames

  driver = translate( filespec("name",driver) )

  dlimit = X2C('00')
  rc = SysFileDelete(LstFile);
  do forever
    parse value devnames with device (dlimit) devnames
    if device = "" then leave
    call lineout LstFile, device || ':' device '('||driver || ')'
  end
return 0


/***********************************************/
/* EAFormat  - return standard ea header for   */
/*   format <type><length>(ea_value)           */
/* EAT_ASCII(0xFFFD) -length preceeded ASCII   */
/***********************************************/
EAFormat: PROCEDURE
 parse arg eavalue
 len =  D2X(length(eavalue),4)
 header  = X2C('FDFF') || X2C(substr(len,3,2)) || X2C(substr(len,1,2))
return header || eavalue
