/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = OEM.C
 *
 * DESCRIPTIVE NAME = OEM common functions
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * AUTHORS      Debbie Cook
 *
 * DESCRIPTION  Contains common functions for dynamic device support.
 *
 * FUNCTIONS
 *            LoadDrvrString -- load keyword string given an id
 *            FindOEMPrntr -- find number of OEM dialog pages
 *            InitOEMPrntr -- load OEM dialog page into notebook
 *            KeywordListGetCurrentOption -- set UI options for OEM dialog
 *            KeywordListSetCurrentOptionDialog -- set UI options for OEM dialog
 *            KeywordListSetCurrentOption -- set UI options for OEM dialog
 *
 *
 * ORDER OF FUNCTIONS
 *              - LoadDrvrString
 *              - FindOEMPrntr
 *              - InitOEMPrntr
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#define  INCL_WINHELP
#define  INCL_DOSPROCESS
#define  INCL_WINHOOKS
#define  INCL_DOSMODULEMGR
#define  INCL_WIN
#define  INCL_PM
#define  INCL_DOS
#define  INCL_SPLFSE
#define  INCL_DEV
#define  INCL_GPIPRIMITIVES
#define  INCL_GENPLIB_MEMORY
#define  INCL_GENPLIB_LAYOUT

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <genplib.h>
#include "inc\pspagtun.h"
#include "inc\config.h"                        // TAKE OUT LATER!!!!!!!!
#include "inc\ppdialog.h"                      // TAKE OUT LATER!!!!!!!!
#include "inc\dlg.h"
#include "inc\oem.h"
#include "inc\os2_oem.h"

OEM_PRINTERS OEMPrinterTable[ OEM_PRINTER_MAX ] =
{
  "HP__CLJ5.PPD", JPNB_DLG_COLORFEAT, (PFNWP) ColorFeaturePageDlgProc, JPCO_TAB,
};

typedef PDLGHDR PJPINFO;

/*****************************************************************************
*
*  FUNCTION:    LoadDrvrString
*
*  PURPOSE:     A LoadString shell; given a keyword ID and access to
*               an anchor block, this function loads the corresponding
*               string into a buffer.
*
*  PARAMETERS:
*     LPPDEVICE lppd -   pointer to current PPDEVICE structure
*     WORD   wId -       INTeger identifier of the string to be loaded
*     LPSTR  lpBuffer -  PoINTs to the buffer that recieves the string
*     INT    nBufferMax -max number of chars that may be loaded INTo lpBuffer
*
*  RETURNS:
*     NON-ZERO - String  Loaded and return value is the number of chars copied
*     ZERO -     Error loading the string
*
*****************************************************************************/
INT LoadDrvrString( LPPDEVICE lppd, WORD wId, LPSTR lpBuffer, INT nBufferMax )
{
  INT       iCharsCopied = 0;
  HAB       hab = WinQueryAnchorBlock( lppd->hDlg );
                                    // Anchor block handle
  iCharsCopied = WinLoadString( hab,
                                pscript_module,
                                wId,
                                nBufferMax,
                                lpBuffer);

  return( iCharsCopied );
}



/*****************************************************************************
*
*  FUNCTION:    FindOEMPrntr
*
*  PURPOSE:     Find out if there are any OEM dialogs by matching the
*               PCFileName found in the input apResources with a PCFileName
*               in the OEMPrinterTable (at the top of this file).  If no
*               match is found, there will be no OEM dialog.  It is possible
*               to find the PCFileName multiple times in the table, as there
*               will be an entry for each dialog that is to be a notebook page.
*
*  PARAMETERS:
*     HWND hDlg -- dialog handle for job properties dialog
*     PB   *apResources -- pointer to resources
*     PGPTMPL pOEMPrinters -- pointer to pOEMPrinters structure
*
*  RETURNS:
*     NON-ZERO - Number of OEM dialog pages found
*     ZERO -     No OEM dialog pages found
*
*****************************************************************************/
INT FindOEMPrntr( HWND hDlg, PB *apResources, PGDPTMPL pOEMPrinters )
{
  PUI_BLOCK pUIBlock;
  INT       iOEMLoop;
  INT       iPageIncrement = 0;
  INT       iPCFileNameOffset;
  CHAR      pszPCFileName [ MAX_FNAMESIZE ];
  UINT      uiBufferSize;                   // Size of dialog header buffer
  PBYTE     pItemsBuff;
  PDESPPD   pdesPPD;
  HAB       hAB = WinQueryAnchorBlock( hDlg );

  uiBufferSize = sizeof( DLGHDR ) + (sizeof( GDPPI ) * (MAX_OEM_PAGES));

  pdesPPD = (PDESPPD) apResources[ PPDRES ];
  pItemsBuff = (PCHAR) pdesPPD->pPSStringBuff;
  iPCFileNameOffset = pdesPPD->desItems.ofsPCFileName;
  //@V3.1137578
  if (iPCFileNameOffset != -1)
  {
    strcpy ( pszPCFileName, pItemsBuff + iPCFileNameOffset );
  }

  /**************************************************************************/
  // Find the PCFileName in the table . . . it may be there more than once
  /**************************************************************************/
  for ( iOEMLoop = 0 ; iOEMLoop < OEM_PRINTER_MAX ; iOEMLoop++ )
  {
    if ( strcmp ( OEMPrinterTable[iOEMLoop].pszPCFileName, pszPCFileName )
                  == 0)
    {
      /**********************************************************************/
      // We found one -- fill in the temporary GPTMPL structure
      /**********************************************************************/
      pOEMPrinters->ulDlgID   = (ULONG) OEMPrinterTable[ iOEMLoop ].uiDialogID;
      pOEMPrinters->pfnDlgProc = OEMPrinterTable[ iOEMLoop ].pfnDlgProc;
      pOEMPrinters->ulTabString = (ULONG) OEMPrinterTable[ iOEMLoop ].usTabID;
      pOEMPrinters->ulFlag    = GTAB_ID;

      iPageIncrement++;
    }
  }

  return( iPageIncrement );
}





VOID InitOEMData( PDLGHDR pDlgHdr )
{
  PUI_BLOCK pUIBlock;

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_COLORSMART, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_COLORMODEL, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_PANTONE, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_PCCTEXT, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_PCCGRAF, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_PCCIMAG, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_TEXTHIGHHALFTONE, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_GRAFHIGHHALFTONE, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_IMAGHIGHHALFTONE, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }

  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff,
                                         ID_PPDSTR_KEY_APPHALFTONING, NULL ))
      != NULL)
  {
    pUIBlock->ucPanelID |= UIP_OEM_FEATURE;
  }
}





/*****************************************************************************
*
*  FUNCTION:    InitOEMPrntr
*
*  PURPOSE:     Initialize OEM dialog functions
*
*  PARAMETERS:
*     HAB    hAB -- Job Properties anchor block
*     HWND   hNotebook -- notebook handle
*     ULONG  ulPageID -- current page number for OEM dialog page
*     PDLG_TMPL pOEMPrinters -- pointer to pOEMPrinters structure
*
*  RETURNS:
*     NON-ZERO - handle of OEM dialog page
*     ZERO -     OEM dialog could not be loaded
*
*****************************************************************************/
HWND InitOEMPrntr( HAB hAB, HWND hNotebook, ULONG ulPageID,
                   PGDPTMPL pOEMPrinters )
{
  HWND      hOEMDlg;
  CHAR      aStatusLineText[ 255 ];   // Buffer for the page's status text
  ERRORID   erridErrorCode;

  WinLoadString( hAB, pscript_module, pOEMPrinters->ulDlgID,
                 255, aStatusLineText );
  WinSendMsg( hNotebook, BKM_SETSTATUSLINETEXT, MPFROMLONG( ulPageID ),
              MPFROMP( aStatusLineText ) );

  hOEMDlg = WinLoadDlg( HWND_DESKTOP,               /* Place anywhere on desktop  */
                        HWND_DESKTOP,               /* Owned by frame             */
                        pOEMPrinters->pfnDlgProc,   /* Address of dlg proc        */
                        (HMODULE)pscript_module,    /* Module handle              */
                        pOEMPrinters->ulDlgID,      /* Dlg ID in resource         */
                        NULL);                      /* Initialization data        */

  if (!hOEMDlg)
    erridErrorCode = WinGetLastError (hAB);

  return( hOEMDlg );
}



/*****************************************************************************
*
*  FUNCTION:    KeywordListSetCurrentOptionDialog
*
*  PURPOSE:     Call function to set the current UI option from the OEM
*               dialog.
*
*  PARAMETERS:
*     LPPDEVICE lppd -- pointer to lppd structure
*     LPKEYWORDLISTREC KeywordList -- list of keywords (currently always NULL)
*     LPSTR keyword -- current keyword
*     LPSTR option -- current option string
*     INT optindex -- option index (currently always set to 0)
*
*  RETURNS:
*     TRUE -- in all cases
*
*****************************************************************************/
INT KeywordListSetCurrentOptionDialog( LPPDEVICE lppd, LPKEYWORDLISTREC KeywordList,
                                       LPSTR keyword, LPSTR option, INT optindex )
{
  PDLGHDR pDlgHdr = (PJPINFO) lppd;
  INT     iRC = (INT) TRUE;

  SetUIOption( pDlgHdr->pdesPPD, pDlgHdr->pCurrUISelList, keyword, option );

  return( iRC );
}



/*****************************************************************************
*
*  FUNCTION:    KeywordListSetCurrentOption
*
*  PURPOSE:     Call function to set the current UI option from the non-OEM
*               dialog.
*
*  PARAMETERS:
*     LPPDEVICE lppd -- pointer to lppd structure
*     LPKEYWORDLISTREC KeywordList -- list of keywords (currently always NULL)
*     LPSTR keyword -- current keyword
*     LPSTR option -- current option string
*     INT optindex -- option index (currently always set to 0)
*
*  RETURNS:
*     TRUE -- in all cases
*
*****************************************************************************/
INT KeywordListSetCurrentOption( LPPDEVICE lppd, LPKEYWORDLISTREC KeywordList,
                                 LPSTR keyword, LPSTR option, INT optindex )
{
  PDLGHDR pDlgHdr = (PJPINFO) lppd;
  INT     iRC = (INT) TRUE;

  SetUIOption( pDlgHdr->pdesPPD, pDlgHdr->pCurrUISelList, keyword, option );

  return( iRC );
}



/*****************************************************************************
*
*  FUNCTION:    KeywordListGetCurrentOption
*
*  PURPOSE:     Call function to get the current UI option for the job
*               properties dialogs.
*
*  PARAMETERS:
*     LPPDEVICE lppd -- pointer to lppd structure
*     LPKEYWORDLISTREC KeywordList -- list of keywords (currently always NULL)
*     LPSTR keyword -- current keyword
*     LPSTR option -- current option string
*     WORD max_opt_len -- maximum size of option string (currently not used)
*     INT *optdexptr -- (currently not used)
*
*  RETURNS:
*     TRUE  -- option string for keyword was found
*     FALSE -- option string for keyword was not found
*
*****************************************************************************/
INT KeywordListGetCurrentOption( LPPDEVICE lppd, LPKEYWORDLISTREC KeywordList,
                                 LPSTR keyword, LPSTR option,
                                 WORD max_opt_len, INT *optdexptr )
{
  INT       ofsSelBit = 0;
  PJPINFO   pJPInfo = (PJPINFO) lppd;
  PBYTE     pOption;
  PUI_BLOCK pUIBlock = pJPInfo->pdesPPD->stUIList.pBlockList;

  if (pOption = QueryUIOptionString( pJPInfo->pdesPPD, pJPInfo->pCurrUISelList,
                                keyword, &ofsSelBit, &pUIBlock ))
  {
    strcpy(option,pOption);
    pUIBlock->ucPanelID = UIP_OEM_FEATURE;
    return( (INT) TRUE );
  }
  else
    return( (INT) FALSE );
}


//@V3.130814
/*****************************************************************************
*
*  FUNCTION:    OEMSetStatus
*
*  PURPOSE:     Lets the OEM function set the status bar.  This is necessary
*               in cases where a UI is set on an OEM dialog instead of on
*               the standard dialogs.  Currently, Color is set on the OEM color
*               dialog, so this dialog needs to set the status bar accordingly.
*
*  PARAMETERS:
*
*  RETURNS:
*
*****************************************************************************/
VOID OEMSetStatus( HWND hDlg, MPARAM mpColorFlag )
{
  HWND    hPage;
  PJPINFO pJPInfo;                        // Job prop. info structure pointer
  INT     iIcon;

  pJPInfo = (PJPINFO) WinQueryWindowULong( hDlg, QWL_USER );

  if ( mpColorFlag == (MPARAM) TRUE  )
  {
    iIcon = ICON_COLOR;
  }
  else
  {
    iIcon = ICON_MONOCHROME;
  }

  /*
  ** Query the effects page.  This is the third page.
  */
  hPage = pJPInfo->stPage[ 2 ].hPage;

  UpdateIcon( pJPInfo->hDlg, hPage, JPSB_MONOCHROME, iIcon );

  return;
}
