/*  MAKEIT.CMD
**
**  Options to makeit are
**    /UseCSet   - use C Set/2
**    /UseVacpp  - use Visual Age
*/
szCSetVer  = "csd11"
szVacppVer = "v308"
/* szVacppVer = "v36" */
fUseCSet   = 0           /* Change to 0 if you want to default to Visual Age */
rc         = 1
SIGNAL ON HALT NAME fHalt

'@setlocal'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

szOpt      = "dbgos2c"
szFamily   = "OS2C"
szVersion  = "DEBUG"
fDepFound  = 0
szDep      = "nodep"
szOptions  = ""
szUnknown  = ""
fNoTargets = 1

parse arg szRestOri             /* Original case */
arg szRestUpr                   /* Uppercase     */

if szRestUpr \= "" then
do while words( szRestUpr ) > 0

   parse var szRestUpr szParmUpr szRestUpr
   parse var szRestOri szParmOri szRestOri

   select
      when substr( szParmOri, 1, 1 ) = "-" then
         szOptions = szOptions szParmOri

      when szParmUpr = "DEP" then
      do
         fDepFound = 1
         szDep     = "dep"

         if length( szUnknown ) > 0 then
            /* Keep the unknown stuff in the original case */
            szUnknown = szUnknown szParmOri
      end

      when szParmUpr = "NODEP" then
      do
         szDep = "nodep"

         if length( szUnknown ) > 0 then
            /* Keep the unknown stuff in the original case */
            szUnknown = szUnknown szParmOri
      end

      when szParmUpr = "DBGOS2C" | szParmUpr = "DEBUG" then
      do
         szOpt     = "dbgos2c"
         szFamily  = "OS2C"
         szVersion = "DEBUG"
      end

      when szParmUpr = "RETOS2C" | szParmUpr = "RETAIL" then
      do
         szOpt     = "retos2c"
         szFamily  = "OS2C"
         szVersion = "RETAIL"
      end

      when szParmUpr = "DBGPPC" then
      do
         szOpt     = "dbgppc"
         szFamily  = "PPC"
         szVersion = "DEBUG"
      end

      when szParmUpr = "RETPPC" then
      do
         szOpt     = "retppc"
         szFamily  = "PPC"
         szVersion = "RETAIL"
      end

      when szParmUpr = "DDK" |,
           szParmUpr = "DDKBLD" then
      do
         szUnknown = szUnknown "ddkbld=1"
      end

      when szParmUpr = "/USECSET" then
      do
         fUseCSet  = 1
      end

      when szParmUpr = "/USEVACPP" then
      do
         fUseCSet  = 0
      end

      otherwise
      do
         if pos( "=", szParmOri ) = 0 then
         do
            /* found a target */
            fNoTargets = 0
         end
         else
         do
            iPosEq = pos( "=", szParmOri )
            if substr( szParmOri, 1, iPosEq - 1 ) = "NLV" then
            do
               /* Setting NLV!
               */
               szNewNLV = substr( szParmOri, iPosEq + 1, )
               szNLV = value( 'NLV', szNewNLV, 'OS2ENVIRONMENT' )
               '@set NLV='szNewNLV
            end
         end

         /* Keep the unknown stuff in the original case */
         szUnknown = szUnknown szParmOri
      end
   end
end

if fUseCSet then
do
   call value 'USE_IBMCPP', '1', 'OS2ENVIRONMENT'
   '@set USE_IBMCPP=1'
end
else
do
   '@set USE_IBMCPP='
   '@set VACPP_VER='szVacppVer
end

/* Grab the program's path */
parse source . . szSrc
szSrcPath = filespec( 'drive', szSrc )
szSrcPath = szSrcPath || filespec( 'path', szSrc )
szSrcPath = translate( szSrcPath )
if substr( szSrcPath, length( szSrcPath ), 1 ) = "\" then
   szSrcPath = substr( szSrcPath, 1, length( szSrcPath ) - 1 )

szOldPath = value( 'PATH',       , 'OS2ENVIRONMENT' )
szUseCSet = value( 'USE_IBMCPP', , 'OS2ENVIRONMENT' )

szBootDrive = substr( szOldPath, pos( '\OS2\', szOldPath ) - 2, 2 )

szRoot = filespec( 'drive', szSrcPath )
szRoot = szRoot'\'word( translate( filespec( 'path', szSrcPath ), ' ', '\' ), 1 )

szToolsPath  = szRoot'\tools\os2.386\bin'
szToolsPath  = szToolsPath';'szRoot'\src\osdd\common\tools'
szToolsPath  = szToolsPath';'szBootDrive'\OS2;.'

if szUseCSet = "1" then
   szDLLPath = szRoot'\tools\os2.386\lx.386\bin\ibmcpp\'szCSetVer'\dll;'
else
   szDLLPath = szRoot'\tools\os2.386\lx.386\bin\vacpp\'szVacppVer'\dll;'
if szVacppVer = "v36" then
   szDLLPath = szDLLPath||szRoot'\tools\os2.386\lx.386\bin\vacpp\'szVacppVer'\runtime;'

szDLLPath    = szDLLPath||szRoot'\tools\os2.386\bin;'

if szUseCSet = "1" then
   szHelpPath = szRoot'\tools\os2.386\lx.386\bin\ibmcpp\'szVacppVer'\help;'
else
   szHelpPath = szRoot'\tools\os2.386\lx.386\bin\vacpp\'szVacppVer'\help;'
if szVacppVer = "v36" then
   szHelpPath = szHelpPath||szRoot'\tools\os2.386\lx.386\bin\vacpp\'szVacppVer'\runtime;'

szOldPATH         = value( 'PATH',         szToolsPath, 'OS2ENVIRONMENT' )
szOldBEGINLIBPATH = value( 'BEGINLIBPATH', szDLLPath,   'OS2ENVIRONMENT' )

'@set PATH='szToolsPath
'@set BEGINLIBPATH='szDLLPath
'@set DPATH='szHelpPath
'@set HELP='szHelpPath

if szVacppVer = "v36" then
do
   '@SET CPP_DBG_LANG=CPP'
   '@SET NLSPATHTEMP='szRoot'\tools\os2.386\lx.386\bin\vacpp\'szVacppVer'\HELP\%%N'
   '@SET NLSPATH=%NLSPATHTEMP%;%NLSPATH%'
   '@SET NLSPATHTEMP='
end

/* Get rid of a special environment-variable-flag so that PATH will be
** set up correctly!
*/
call value 'TOOLSFLAG', '', 'OS2ENVIRONMENT'

szCurDir = directory( )
szNewDir = directory( szSrcPath )

szSrcPath = szSrcPath"\"

szNLV = value( 'NLV', , 'OS2ENVIRONMENT' )
if szNLV = "" then
   szNLV = 'en'

/* Build the object tree path
*/
szSearch = '\SRC\'
iLeft  = pos( szSearch, szSrcPath ) - 1
iRight = length( szSrcPath ) - iLeft - length( szSearch )
szObjPath = left( szSrcPath, iLeft )
szObjPath = szObjPath || '\OBJ\' || szFamily || '\' || szVersion || '\'
szObjPath = szObjPath || right( szSrcPath, iRight )

/* Find the depend.mak file in the object tree
*/
szDepend = szObjPath'DEPEND.MAK'
rc = SysFileTree( szDepend, 'aFiles', 'F' )

/* OK is the list of all the *.c and *.h files different? */
bSame = fSameFiles( szSrc )

/* Did it exist? */
if \fDepFound & (aFiles.0 = 0 | \bSame) then
do
   if aFiles.0 = 0 then
      /* Not found... default to dep */
      say szDepend "was not found... defaulting to dependcy building!"

   if \bSame then
      say szDepend "The list of files is different... defaulting to dependcy building!"

   'nmake -f makefile OPT='szOpt' 'szUnknown' dep'
end

if fNoTargets then
do
   if szDep = "nodep" then
      szUnknown = szUnknown "nodep"
   else
      szUnknown = szUnknown "all"
end

if szDep = "dep" then
do
   'tee2 nmake.exe "'szOptions' -f makefile OPT='szOpt' 'szUnknown'" errors'
    say "root rc = " rc
end
else
do
/*
   'nmake -f makefile OPT='szOpt' 'szUnknown' 2>&1 | tee errors'
*/
   'tee2 nmake.exe "'szOptions' -f makefile OPT='szOpt' 'szUnknown'" errors'
    say "root rc = " rc
end

szNewDir = directory( szCurDir )

exit rc

/***************************************************************************/
fSameFiles: procedure
arg szSrc

fRet = 0

/* Open the source file (this .CMD file) for reading/writing */
if "READY:" \= stream( szSrc, 'c', 'open' ) then
   return 0

/* Find the end of file marker */
fFound = 0
szSearch = "/*"||copies( "8<-----", 10 )||"*/"
do while lines( szSrc )
   szLine = linein( szSrc )
   if szSearch = szLine then
   do
      fFound = 1
      leave
   end
end

/* Save the current stream position */
szStreamPos = stream( szSrc, 'c', 'seek' )

/* Read in the source files into an array */
i = 0
if fFound = 1 then
do while lines( szSrc )
   szLine = strip( linein( szSrc ) )
   if szLine \= "" then
   do
      i = i + 1
      aFilesCmd.i = szLine
   end
end
aFilesCmd.0 = i

/* Read in the source files in the current directory */
aFilesDrive.0 = 0
call fDirFiles "*.c"       /* C           */
call fDirFiles "*.h"
call fDirFiles "*.cpp"     /* C plus plus */
call fDirFiles "*.hpp"
call fDirFiles "*.asm"     /* Assembly    */
call fDirFiles "*.inc"

/* now compare the two lists... they must be the same! */
if aFilesCmd.0 = aFilesDrive.0 then
do
   fRet = 1
   do i = 1 to aFilesCmd.0
      if aFilesCmd.i \= aFilesDrive.i then
      do
         fFound = 0
         do k = 1 to aFilesDrive.0
            if aFilesCmd.i \= aFilesDrive.k then
               fFound = 1
         end

         if \fFound then
         do
            fRet = 0
            leave
         end
      end
   end
end
else
   fRet = 0

/* Add the new file list to the end of this file!
** But first set the write position after the marker.
*/
call stream szSrc, 'c', 'seek' szStreamPos
do i = 1 to aFilesDrive.0
   call lineout szSrc, aFilesDrive.i
end

/* Ok.  Its possible that we are adding fewer files to this file.
** I dont know of a way to chop off the file at this point.  So,
** just replace all the remaining chars with whitespace.
*/
call lineout szSrc, copies( ' ', chars( szSrc ) )

if "READY:" \= stream( szSrc, 'c', 'close' ) then
   return 0

return fRet

/***************************************************************************/
/* Append the list of files matching szFileMask to the array aFilesDrive   */
fDirFiles: procedure expose aFilesDrive.
arg szFileMask

j = aFilesDrive.0
rc = SysFileTree( szFileMask, 'aFiles', 'FO' )
do i = 1 to aFiles.0
   j = j + 1
   aFilesDrive.j = filespec( 'name', aFiles.i )
end
aFilesDrive.0 = j

return

/* DONT ADD ANYTHING AFTER THE FOLLOWING LINE!                          */
/* IT WILL BE NUKED!                                                    */
/* YOU HAVE BEEN WARNED!                                                */
/*8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----8<-----*/
afmtopfm.c
arcs.c
asm2c.c
attrs.c
bitmaps.c
bounds.c
box.c
charstr.c
charstr2.c
colortab.c
config.c
devblock.c
devesc.c
devmode.c
dlg.c
download.c
effects.c
enable.c
enumpage.c
flchkdlg.c
fonts.c
hp.c
img2bin.c
init.c
jpdlg.c
makevect.c
mandfunc.c
memory.c
noinstal.c
oem.c
patfill.c
path.c
path2.c
polystuf.c
ppdlg.c
prdevect.c
profile.c
psdjp.c
psource.c
pstuner.c
query.c
querybox.c
querychr.c
softfont.c
surface.c
utlchnl.c
utllog.c
utlprint.c
utlps.c
xforms.c
stub.asm
      
