/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = UTL.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1)


#if XDEBUG
extern VOID LogCall(PSZ, PB);
extern VOID PrintLog(PSZ,...);
extern VOID LogReturn(PSZ, LONG);
extern VOID CloseLogFile(PDV);
extern VOID OpenLogFile(PDV);
#else
#define LogCall
#define PrintLog
#define LogReturn
#define CloseLogFile
#define OpenLogFile
#endif

#define ENABLE_LDB            1   /* OS2_PM_DRV_ENABLE subfunctions*/
#define ENABLE_PDB            2
#define DISABLE_PDB           4
#define ENABLE_DC             5
#define DISABLE_DC            6
#define SAVE_DC_STATE         7
#define RESTORE_DC_STATE      8
#define RESET_DC              9
#define COMPLETE_OPEN_DC     10
#define BEGIN_CLOSE_DC       11
#define QUERY_DEVICE_SURFACE 14

/*
**  from prdpbseg.c
*/
extern BOOL init_path_buf(PDDC);
extern BOOL discard_path_buf(PDDC);
extern BOOL grow_path_buf(PDDC);
extern BOOL play_path_buf(PDDC,BOOL);

/*
*/
extern BOOL init_clip_path_buf(PDDC);
extern BOOL discard_clip_path_buf(PDDC);
extern BOOL play_clip_path_buf(PDDC);

extern VOID  sync_graphic_states(PDDC,short,short,FIXED,LONG);
extern FIXED prdc_RgbToGray(PDDC, LONG);

extern BOOL OpenChannel(PDDC);
extern BOOL CloseChannel(HDC, PDDC);
extern VOID HexToChannel(PDDC, PB, short);
/*
*/
extern VOID WriteModeString(PDDC, PB, short);

/*
** Change SHORT to USHORT to correct DRAG-DROP bug.
*/
extern VOID WriteChannel( PDDC, PB, USHORT );

extern VOID FlushChannel(PDDC);
extern VOID PrintChannel(PDDC, PSZ,...);


extern ULONG  kprintf(BOOL, PB, int, PSZ, ULONG *);
extern VOID Int3();

extern VOID ps_movetoCP(PDDC);

/*
**  extern VOID ps_movetoCPx(PDDC,PPOINTL);
*/

#define ps_movetoCPx(pddc,ppointl) { ps_moveto(pddc,ppointl);\
                                     ps_movetoCP(pddc); }

extern VOID  ps_strokecurrentpath(PDDC);
extern VOID  ps_clearpath(PDDC);

extern VOID  ps_scalefont(PDDC, FIXED, FIXED);
extern VOID  ps_shearfont(PDDC, LONG, LONG);
extern VOID  ps_rotatefont(PDDC, LONG, LONG);
extern VOID  ps_setlinewidth(PDDC, FIXED, BOOL);
extern VOID  ps_setrgbcolor(PDDC, LONG);
extern VOID  ps_lineto(PDDC, PPOINTL);
extern VOID  ps_stroke(PDDC);
extern VOID  ps_setfont(PDDC, PSZ);
//extern VOID  ps_show(PDDC, LONG, short) ;                             //@DBCS
extern VOID  ps_show(PDDC, LONG, short, BOOL);                          //@DBCS
extern VOID  ps_SetDownloadedFont (PDDC) ;
extern BOOL  ps_DownloadFont (PDDC) ;
extern VOID  ps_moveto(PDDC, PPOINTL) ;
extern VOID  ps_sync_cp(PDDC, PPOINTL, BOOL) ;
extern VOID  ps_setposition (PDDC) ;
extern VOID  ps_showpage(PDDC);
extern SHORT ps_enddoc(HDC, PDDC);
extern VOID  ps_startdoc(PDDC);
extern VOID  ps_curveto(PDDC, PPOINTL);
extern VOID  ps_arc(PDDC, PPOINTL, FIXED, FIXED, FIXED);
extern VOID  ps_arcn(PDDC, PPOINTL, FIXED, FIXED, FIXED);
extern VOID  ps_concat(PDDC, PXFORM);

extern VOID  ps_newpath(PDDC);
extern VOID  ps_closepath(PDDC);
extern VOID  ps_strokepath(PDDC);
extern VOID  ps_eofill(PDDC);
extern VOID  ps_fill(PDDC);
extern VOID  ps_setlinejoin(PDDC, short);
extern VOID  ps_setlinecap(PDDC, short);

extern BOOL  ps_status(PDDC);
extern VOID  ps_gsave(PDDC);
extern VOID  ps_grestore(PDDC);
extern VOID  ps_setmatrix(PDDC, FIXED *);
extern VOID  ps_translate(PDDC, PPOINTL);
extern VOID  ps_rotate(PDDC, LONG, LONG);
extern VOID  ps_clip(PDDC);
extern VOID  ps_eoclip(PDDC);
extern VOID  ps_initclip(PDDC);
extern VOID  ps_imagedata(PDDC, BOOL, LONG, LONG, LONG, PB);
extern VOID  ps_imagemask(PDDC, LONG, LONG, LONG, LONG, PB);
extern VOID  ps_setdash(PDDC, short);
extern VOID  ps_setdashnow(PDDC);
extern VOID  ps_savematrix(PDDC);
extern VOID  ps_restorematrix(PDDC);
extern VOID  ps_saveclipmatrix(PDDC);
extern VOID  ps_restoreclipmatrix(PDDC);
extern BOOL  ps_bitblt(PDDC, PRECTL, PRECTL, ULONG, LONG, LONG);
extern VOID  ps_init(PDDC);
extern VOID  UpdateGraphicsState(PDDC);
extern VOID  ps_selectfont(PDDC);

extern VOID  _System utl_memcopy(PB, PB, short int);
extern VOID  szCopy(PSZ, PSZ, int);
extern BOOL  _System szIsEqual(PSZ, PSZ);
extern BOOL  GenQueryAppName(PSZ, PSZ, short,BOOL);

//SHORT *PaperDimensions(CHAR *,PB *);                           // @V3.1140757
SHORT *PaperDimensions( CHAR *, PDESPPD );                       // @V3.1140757
//SHORT *ImageCoords (CHAR *,PB *);                              // @V3.1140757
SHORT *ImageCoords ( CHAR *, PDESPPD );                          // @V3.1140757
SHORT  Resread( CHAR * ,short ,PB *);
BOOL   Openppb(short , SEL *);
VOID   FreeMemory(PB *);

/*
*/
BOOL CmndPaper( PSZ * ,PB *, PSZ, BOOL, PDDC );  //@V3.1137565

/*
** Add/change parameters.
*/
BOOL   CmndInpTray(PSZ *, PB *, SHORT, PDDC);

VOID   PageAtPaper(PCNFDATA ,PSZ ,SHORT * );
// @V3.1140757
//VOID   SetCanvasMetrics(PCANVAS, PB * );
VOID   SetCanvasMetrics( PCANVAS, PDESPPD, PCNFDATA );
VOID   ReadProfile(PB *);
/*
** Changed some parameters to double pointers.
*/
/*
** @V3.011571
** Added last three parameters.
*/
BOOL   LoadTrayCommand( PDDC, PSZ *, PSZ *, BOOL *, PSZ *, PBOOL, PSZ *,
                        PBOOL, PBYTE );

#define CB_DDC_HEAP     4096
#define HEAP_GROWTH     4096

// 172997 - Ensure that text line length is within DSC limits.
extern LONG WriteDSCLengthLine( PDDC, PBYTE, ULONG, BOOL );
