/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************\
**
** SOURCE FILE NAME = PSDJP.H
**
** DESCRIPTIVE NAME = Dynamic Job Properties Header
**
**
** VERSION = V1.0
**
** DATE
**
** DESCRIPTION
** Contains the definitions for djp
**
** FUNCTIONS
**
** NOTES
**
** STRUCTURES
**
** EXTERNAL REFERENCES
**
** EXTERNAL FUNCTIONS
**
*/

#define GRE_234   0x0234                               // INTEL (even) DAX @DJP
//#define GRE_234   0x0232   //DEBUG DEBUG DEBUG         // INTEL (even) DAX @DJP

//Actions
#define GET_SIZE  1
#define GET_PROP  2
#define SET_PROP  3

/*
** @V4.0158787
** This is the base value for all unique tray ID's.  Each time a unique tray
** is encountered, the ID for that tray is based on this value, plus
** incremented for each subsequent unique tray found.
*/
#define UNIQUE_BASE_ID      0x00000300

typedef struct _REFDATA {
  PDESPPD   pdesPPD;
  PSZ       pszDeviceName;
  PDRIVDATA pLocalDD;
  PCNFDATA  pCNFData;
  PDV       pdv;
  CHAR      achQueueName[32];
} REFDATA, * PREFDATA;

extern LONG psDJPQuerySize( PREFDATA, ULONG, PULONG, PULONG, PULONG );
extern LONG psDJPQuerySetJobProperties( PREFDATA, ULONG, PULONG, PULONG, PULONG,
                                        LONG );
extern LONG psDJPDefaultJobProperties( PREFDATA, ULONG, PULONG, PULONG, PULONG );
extern LONG DJPSetUpRefData( PDDC, PREFDATA );
extern LONG DJPResetStartDoc( PDDC, PREFDATA, PULONG, ULONG );
extern LONG DJPNewFrame( PDDC, PREFDATA, PULONG );
//@V4.0172646
extern BOOL GetOldFormName( PDESPPD, PSZ, PSZ );
