/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
#ifndef prdptypt_h_
  #define prdptypt_h_

/****************************************************************************
 *
 * SOURCE FILE NAME = PRDPTYPT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        : --/--/--
 *
 * DESCRIPTION : Physical device instance data.
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Winthorn Functional Specification
 *                         - Device Driver Interface Specification
 *                         - Printer Device Driver Design Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#pragma pack(1)

#ifndef INCL_GENPLIB_THREAD
  #define  INCL_GENPLIB_THREAD
  #include <genplib.h>
#endif
#include <gpledc.h>
#include <fontmgr.h>


/*
*/
#include "ppdialog.h"

#ifndef prdttypt_h_
  #include "prdttypt.h"
#endif
#ifndef pmdev_h_
  #include <pmdev.h>
#endif

#pragma pack(1)

/********************+------------------------------------+********************/
/********************| Start of support for Pages Spooled |********************/
/********************|            @V3.1147985             |********************/
/********************+------------------------------------+********************/
/* New Structures for BIDI */
#ifndef PMSPLB_INCLUDED

/*
** structure returned by SplQmGetJobID
*/
typedef struct _QMJOBINFO
{
  ULONG ulJobID;
  PSZ   pszComputerName;
  PSZ   pszQueueName;
} QMJOBINFO, *PQMJOBINFO;

#define PRJ_PAGESSPOOLED_PARMNUM     20

typedef struct _PRJINFO4      /* prj4 */
{
  USHORT uJobId;
  USHORT uPriority;
  PSZ    pszUserName;
  USHORT uPosition;
  USHORT fsStatus;
  ULONG  ulSubmitted;
  ULONG  ulSize;
  PSZ    pszComment;
  PSZ    pszDocument;
  PSZ    pszSpoolFileName;
  PSZ    pszPortName;
  PSZ    pszStatus;
  ULONG  ulPagesSpooled;
  ULONG  ulPagesSent;
  ULONG  ulPagesPrinted;
  ULONG  ulTimePrinted;
  ULONG  ulExtendJobStatus;
  ULONG  ulStartPage;
  ULONG  ulEndPage;
} PRJINFO4, *PPRJINFO4;
#endif

/*
** MACROS to use on flags
*/
#define SETFLAG( flag, bit )   ((flag) |= (ULONG)(bit))
#define CLEARFLAG( flag, bit ) ((flag) &= ~((ULONG)(bit)))
#define CHECKFLAG( flag, bit ) ((flag) & (ULONG)(bit))

/*
** The size of the text buffer that holds strings being prepared for
** a PostScript show() command.
*/

#define SHOW_BUFFER_SIZE  768L

/*
** The output channel descriptor.
*/
typedef struct _CN
    {
    ULONG fh;               /* The output file handle */
    BOOL  fChannelOpen;     /* TRUE if output channel has been opened. */
    BOOL  fChannelIsValid;  /* TRUE if the output channel is valid */
    BOOL  fChannelError ;   /* TRUE if error occurred writing to channel */
    BOOL  fUsed;            /* TRUE if no data has been written to channel */
    int   nbBuf;            /* The number of bytes in the buffer */
    char  abPrintf[200];    /* Temporary buffer for printf */
/*  char  abBuf[1024];      +* The output buffer */
#define ABBUF_SIZE 4096
    PCHAR abBuf;            /* Pointer to The output buffer */
    PCHAR pbBin2Hex;        /* Pointer for scratch buf      */    //@V4.0174400
#define   BIN2HEXSIZE 1024                                        //@V4.0174400
    PQMJOBINFO  pQMJobInfo; /* Ptr to Job Info @V3.1147985  */
    }CN,  *PCN;



#define     MAX_LOGADDRESS  256L
#define     SIZEOF_PSCRIPT  10L
#define     SIZEOF_PM_Q_RAW 11L
#define     MAX_COMMENT     80L
#define     MAX_QPROCNAME   32L
#define     MAX_QPROCPARM   128L
#define     MAX_SPOOLERPARM 50L
#define     MAX_NETWORKPARM 256L
#define     MAX_ESC_STR_LEN 256L                

/*
** this structure is included in the device structure.  it will
** hold the strings pointed to by the DEVOPENSTRUC.
*/
typedef struct _DV_DOP
    {
    CHAR        LogAddress[MAX_LOGADDRESS];
    CHAR        DriverName[SIZEOF_PSCRIPT];
    // @V3.0UI
    PLDRIVDATA  pDriveData;
    CHAR        DataType[SIZEOF_PM_Q_RAW];
    CHAR        Comment[MAX_COMMENT];
    CHAR        QueueProcName[MAX_QPROCNAME];
    CHAR        QueueProcParams[MAX_QPROCPARM];
    CHAR        SpoolerParams[MAX_SPOOLERPARM];
    CHAR        NetworkParams[MAX_NETWORKPARM];
} DV_DOP,  *PDV_DOP;


/*
** PostScript Fonts structure.  Should contain all we need to know
** about each font currently in the printer, whether hardware or
** downloaded.
*/

#define MAX_FONTS   255

/*
**  The names in the structure follow Adobe practice; the "Full Name" is
**  the normal title of the font (eg, "Stone Informal Bold Italic"), while
**  the "Font Name" is a PostScript object, all one word which must be sent
**  to the printer preceded by '/' ("/StoneInformal-BoldItalic").  We use the
**  Full Name exclusively from here 'upward' to the user and application: ie,
**  we display it in the installation dialog and the app uses it to select
**  a font.  However, the PS printer recognizes only the "Font Name" for
**  selecting a font, so the 'Font Name' is used exclusively 'downward' from
**  here to the printer.
*/

typedef _Packed struct _FNT
{
    PSZ     pszFullName ;       /* for display and user selection          */
    PSZ     pszFontName ;       /* command for printer                     */
    SHORT   usResource ;        /* resource # or 0 for soft font           */
    BOOL    bLoaded ;           /* if soft, already loaded?                */
      #define  LOCKED        0x80
      #define  DYNFNT        0x40
    PSZ     pszOFM ;            /* file name, with path; 0L for hw font    */
    PSZ     pszPFB ;            /* file name, with path; 0L for hw font    */
    ULONG   ulFlags;            // Set of general flags for fonts
    #define FNT_FONTCOUNTED     0x00000001  // Set when font count decremented
    PDYNFNT_LIST   prDynFnt;    // Dynamic Font record
} FNT, *PFNT;

typedef FNT  AFNT[];
typedef AFNT *PAFNT;

/* DBCS enabling start */                                               //@DBCS
typedef struct
{
    CHAR    szFontName[MAX_FNAMESIZE];      /* Full Name                   */
    CHAR    szH2ByteName[MAX_FNAMESIZE];    /* Horizontal face name        */
    CHAR    szV2ByteName[MAX_FNAMESIZE];    /* Vertical face name          */
    SHORT   sItalicFont[2];                 /* Italic font flag            */
}DBCSFNT, *PDBCSFNT;

typedef DBCSFNT  ADBCSFNT[];
typedef ADBCSFNT *PADBCSFNT;
/* DBCS enabling end   */                                               //@DBCS

typedef _Packed struct _CACHEDFONT
{
  LONG     lIndex;
  LONG     lUsageCount;
  PFONTDEF pFontDef;
} CACHEDFONT, * PCACHEDFONT;

#define NUMCACHEDFONTS 4

/*
** These are the global structures need for the global font memory
*/

typedef struct _GLOBALFONT
{
  LONG lCount;        /* How many ofm files            */
  PSZ  pszFontFiles;  /* List of all font files in ini */
  PFNT pFNTList;      /* Global list of FNT structs    */

} GLOBALFONT, *PGLOBALFONT;

typedef struct _GLOBALDATA
{
  ULONG      cInstances;
  HMTX       hSem;
  HMCB       hMCB;
  GLOBALFONT FontData;
  LONG       BootDrive;

} GLOBALDATA, *PGLOBALDATA;


/*
** The DV (device) structure is allocated in the Fill_PDevice_Routine.
** One such DV structure will be allocated for each DC.  While a DC
** may have several DDC structures (due to saved DCs), there will
** always only be one DV for the DC.  Therefore, we want to put in
** the DV only those pieces of information about the DC for which we
** don't want to make duplicate copies when a DC is saved.
*/

typedef struct _DV
    {
    DEVOPENSTRUC dop;                 /* Device information struc        */
    // @V3.1140757
//    CHAR         szSegName[MAX_FNAMESIZE];/* Info segment name               */
    /*
    **  name of the paper selected for various trays
    */
    // @V3.1140757
//    SOURCE       sourcePaper;
//    CHAR         szDefFont[32];       /* Name of printer's default font  */
    PB           szzFontsList ;       /* List of fonts printer offers    */
    PAFNT        paFonts ;            /* Ptr to array of PS Font strucs */
    SHORT        cFonts ;             /* Count of fonts */
    /*
    **  a structure to contain various print effect parameters
    */
//    EFFECTS      effOutput ;                                   // @V3.1140757
    /*
    **  Job properties set under job property dialog box
    */
//    JOBPROP      jobProperties ;                               // @V3.1140757
    CN           cn;                  /* The output channel              */
    CANVAS       canvas;              /* The current media state         */
    BOOL         fDocStarted ;        /* 1 = Document has been started   */
    BOOL         fQMStartDocIssued ;  /* 1 = SplQMStartDoc issued        */
    CHAR         szDocName[256] ;     /* Name of document in progress    */
    /*
    **  A buffer for outputting strings
    */
    CHAR         chText[SHOW_BUFFER_SIZE] ;
    SHORT        shPageno ;           /*page sequence no for a multi page document*/
    SHORT        sNupPage;            /* For Nup */               //@V4.0160760
    SHORT        sLPW;                /* For Nup */
    SHORT        sLPH;                /* For Nup */
    // @V3.1140757
//    SHORT        iCntCopies;          /*no of output copies to be produced*/
    /*
    **  type of destination : 0-System(LPT1 or COM1),1-Raw mode file,
    **                        2-Encapsulated postscript file
    */
/// SHORT        iDestnType;  in CNFDATA structure
    CHAR         szDestnFile[MAX_FNAMESIZE]; /* Name of output file */
    /*
    */
//    CHAR         szKeyApp[MAX_KEYAPPSIZE];                     // @V3.1140757
    /*
    */
    CHAR         szInitString[MAX_ESC_STR_LEN];
    /*
    */
    CHAR         szTermString[MAX_ESC_STR_LEN];
    /*
    */
    SHORT        usInitLength;
    /*
    */
    SHORT        usTermLength;
    /*
    */
//    SHORT        sDuplexMode;                                  // @V3.1140757
    DV_DOP       dev_dop;
    /*
    */
    SHORT        usDataType;
    #define      PM_Q_STD        1
    #define      PM_Q_RAW        2

    BOOL         fInitStringSent;                        
    XFORM        xformPageState;                         /* DEF 51530  */
    /*    ** The total count of fonts that can be downloaded
    */
//    LONG lFontCount;                                           // @V3.1140757
    PVOID pDCHeap;            /* The base pointer for DC heap */
//    SHORT sUsePDFonts;                                         // @V3.1140757

    /*
    ** ulGenFlags are a group of flags for BOOLEAN vars.
    ** Feel free to use them up.
    ** See top of file for handy macros
    */
    ULONG ulGenFlags;

      #define IS_DIRECT_PORT  0x00000001
      #define IS_OUR_BITMAP   0x00000002
      #define PRINT_TO_FILE   0x00000004                          //@V3.0116308
      #define MODESWITCH_OK   0x00000008                          //@V3.0116308
      #define NO_CTL_D        0x00000010                          //@V3.0116308
      #define SEPARATOR_PAGE  0x00000020                          //@V4.0160760
      #define DATATYPE_RAW    0x00000040                          //@V4.0160760
      #define DID_RAWDATA     0x00000080                          //@V4.0160389
      #define DID_RESETDC     0x00000100
      #define FLUSH_NUP       0x00000200
      #define SEND_JCL2PS     0x00000400                      
      #define MIXED_PAPER     0x00000800                      //@MIXED_FEED
      #define RESET_MATRIX    0x00001000                      //@SEP

    /***** use them up...
    * #define bit2     0x00000004
    * #define bit3     0x00000008
    * #define bit4     0x00000010
    * #define bit5     0x00000020
    *  .
    *  .
    * #define bit31    0x10000000
    ****************************/

    /*
    ** D74609 Three uses of usLanguageLevel
    ** (1) Read from ppd to set usLanguageLevel to 2 for Level 2 support for
    **     printer.  This is done in prde_fillpdb().  If the printer does not
    **     support level 2 this flag is set to 0.
    ** (2) If Level 2 is supported this flag which is stored in
    **     pddc->pdv->usLanguageLevel is set to 3 to turn on Ascii85Encode()
    **     from within FlushBuffer().
    ** (3) Again if Level 2 is supported this flag is set to 4 from within
    **     FlushBuffer() if the termination byte has been sent for
    **     RunLengthEncode().
    */
    USHORT       usLanguageLevel;
    PB           Compress85;  /* D74609 Buffer pointer for Ascii85Encode() */
//    USHORT usPSLevel1;        /* D74609 True for L1 compat */  // @V3.1140757
    BOOL   fAllocatedPatterns;

    
    HTHREAD hThread;          /* Second output thread handle for GENPLIB   */
    CACHEDFONT FontCache[ NUMCACHEDFONTS ];

    /* @V3.0GAMMA1
    ** The gamma correction table pointer
    */
    PBYTE pbGammaTable;

    /* @V3.1109317
    ** Scratch DC for bitmaps
    */
    HDC hdcScratch;
    BYTE bLastByteWritten;  //Last byte written fm prev write     //@V3.0116308

    /*
    ** @V3.0UI
    */
//    PCHAR   pUIPSCmds;                                         // @V3.1140757
//    UI_LIST stUIList;                                          // @V3.1140757
    PBYTE   pUISelectList;
//    CHAR aTraySelected[ MAX_PSIZE ];                           // @V3.1140757

    PDESPPD  pdesPPD;   //Pointer to PPB data loaded in fillpdb

    PCNFDATA pCNFData;  // Pointer to user selections

/* DBCS enabling start */                                               //@DBCS
    PADBCSFNT paDBCSFonts;
    USHORT    cDBCSFonts;
    BOOL      bMakeBold;
/* DBCS enabling end   */                                               //@DBCS

    BOOL fIsDestnLAN;         // TRUE if output to LAN.
    SETABORTPROC  SetAbortProc;                                          //@SAP
    MASTERRESOURCECONTROLBLOCK  MRCB; //Holds pointers to resources        @RES

    HGJOI hLayout;
    LONG  lNumPgSheet;
    EDCGENDATA EDCGeneralData;    // EDCGPL General EDC data

/* Dynamic fonts begin */
    PVOID  pDynFntList;
/* Dynamic fonts end */
    PEXTRA_DV pExtraDV;           // Pointer to Extra device information
    } DV,  *PDV;

#endif
