/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDMATH.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 

#define FX_ZERO 	   0L
#define FX_ONE		   0x10000L
#define FX_TWO		   0x20000L
#define FX_FOURTHIRDS	   0x15555L
#define FX_ROOTHALF	   0X0B504l	/* sqrt(1/2)  */
#define FX_255		   0x0ff0000L

/*
**  Bounds are limited to 28 bits
*/

#define FX_MAX		   0x07ffffffL
#define FX_MIN		   0xf8000000L

/*
**  some FIXED constants which are used for font transformations
*/

#define FX_1000 	   0x3e80000L
#define FX_72		   0x480000L




/*
**  Definitions for commonly used bit masks
*/
#define BIT0 (1)
#define BIT1 (1<<1)
#define BIT2 (1<<2)
#define BIT3 (1<<3)
#define BIT4 (1<<4)
#define BIT5 (1<<5)
#define BIT6 (1<<6)
#define BIT7 (1<<7)
#define BIT8 (1<<8)
#define BIT9 (1<<9)
#define BIT10 (1<<10)
#define BIT11 (1<<11)
#define BIT12 (1<<12)
#define BIT13 (1<<13)
#define BIT14 (1<<14)
#define BIT15 (1<<15)

#define LongToFx(long) (long << 16)
#define FxToLong(fixed) (LONG)(((LONG)fixed + 0x08000L) >> 16)

typedef struct _QUAD {
   LONG lDWlo,
        lDWhi;
} QUAD;
typedef QUAD *PQUAD;

typedef struct _UQUAD {
   ULONG ulDWlo,
         ulDWhi;
} UQUAD;
typedef UQUAD *PUQUAD;

typedef struct _FXQUAD {
   USHORT uspad;
   USHORT usFrac;
   ULONG  ulInt;
} FXQUAD;
typedef FXQUAD *PFXQUAD;

//
//           32________________________ 32_______________________
//           |                         |                         |
// FXQUAD    |         integer         |         fraction        |
//           |____________|____________|____________|____________|
//
//                               ^           ^
//  FXToFXQuad                   |           |
//                        32________________________
//                        |                         |
// FIXED                  |  integer   |  fraction  |
//                        |____________|____________|
//
//  LongToFXQuad    ^           ^
//                  |           |
//           32________________________
//           |                         |
// [U]LONG   |  hi word   |  lo word   |
//           |____________|____________|
//
//
//           32________________________ 32_______________________
//           |                         |                         |
// FXFLOAT   |        mantissa         |         exponent        |
//           |____________|____________|____________|____________|
//
// ------------------------------------------------------------------
//
//           32________________________ 32_______________________
//           |                         |                         |
// QUAD      |    sign    |  integer   |  fraction  |     0      |
//           |____________|____________|____________|____________|
//
//           32________________________ 32_______________________
//           |                         |                         |
// UQUAD     |      0        integer   |  fraction  |     0      |
//           |____________|____________|____________|____________|
//
//
//           32________________________ 32_______________________
//           |                         |                         |
// [U]QUAD   |          integer        |         fraction        |
//           |____________|____________|____________|____________|
//
//                        ^                         ^
//                        |                         |
// [using    EDX_______________________ EAX______________________
//  EDX:EAX, |                         |                         |
//  for      |            |            |            |            |
//  example] |____________|____________|____________|____________|
//
//
// A [U]QUAD can be treated as an FXQUAD: the only thing that will happen
//  is that the lowest 16 bits of the [U]QUAD will be ignored in the
//  FXQUAD.
//
// LONGs and ULONGs must first be converted to FIXED before they are
//  inserted into a [U]QUAD.  There are routines supplied to accomplish
//  this.
//

extern FIXED _System frmul(FIXED, FIXED);
extern FIXED _System frdiv(FIXED, FIXED);
extern FIXED _System frsqrt(FIXED);
extern LONG  _System BigMulDiv(LONG, LONG, LONG);
extern LONG  _System LongMulFixed(LONG, FIXED, LONG  *);
extern FIXED _System frVectLength(FIXED, FIXED);
extern FIXED _System fxmultiply(PQUAD,FIXED,FIXED,PULONG);

