/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDEEXTF.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver external files for Enable routines
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 

/*
 *  -------------------- end of PRDETYPT.H incorporation ----------------
*/

SHORT  prde_Initialize();			      /* KH SEA6 */
SHORT  prde_StartUp();				      /* KH SEA6 */
ULONG	_prde_Enable (ULONG, PBYTE, PBYTE);

typedef ULONG HDDC;

typedef struct
    {
    ULONG      ulVersion;
    ULONG      cTableSize;
    } FLParamsLst;

typedef struct
    {
    UBYTE cArgs;
    char  ErrRet;
    } ARGERRRET;

typedef struct
    {
    SHORT    *pFlags; /* we return info here				*/
    PFNL      *apfn;   /* the dispatch table				 */
    ARGERRRET *aAER;   /* the number of args and errorRet (future) table */
    } FLReturnsLst;

SHORT InstallDispatchVectors (PFNL *, FLParamsLst *) ;
SHORT prde_FillLdb (FLParamsLst *, FLReturnsLst *);
ULONG  prde_FillPdb (PDEVOPENSTRUC, ULONG);
SHORT prde_DisablePdb (PDV, PBYTE);

typedef struct
    {
    PDV 	    pdv;       /* Ptr to the device instance data */
    LONG	    DcType;
    HDC 	    hdc;	/* The display context handle */
    } EDCParamsLst;

ULONG  prde_EnableDC (EDCParamsLst *, ULONG);
SHORT prde_DisableDC (PDDC);
SHORT prde_SaveDC (PDDC, ULONG) ;
SHORT prde_RestoreDC (PDDC, LONG) ;
SHORT prde_ResetDC (PDDC, ULONG) ;
void   prde_SetDDCDefaults (PDDC) ;
SHORT prde_CreateThread (SHORT);
void   prde_Termination( SHORT );
void   prde_CloseDisplay (PDDC) ;
void   prde_DeleteSavedDCs (PDDC) ;
extern BOOL fWriteLogFile;

extern PFNL apfnlDisplay [] ;
extern PFNL pfnlPMDispEnable ;

#if DEBUG
extern BOOL fRipOnEnter;
#endif /* DEBUG */
