/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDBEXTF.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver external files for Bit routines
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 

/*
** Minor Functions
*/
ULONG prdb_PolyMarker(
	     HDC,
	     PPOINTL,
	     LONG,
	     PDDC,
	     ULONG);						/* KH SEA5 */

ULONG prdb_DeviceCreateBitmap  (
	    HDC,
	    lpBitmap,
	    InfoTableType *,
	    ULONG,
	    ULONG,
	    ULONG,
	    ULONG,
	    ULONG,
	    PDDC,
	    ULONG);						 /* KH SEA2 */

ULONG prdb_DeviceDeleteBitmap (
	    HDC,
	    lpBitmap,
	    DeleteReturns *,
	    ULONG,
	    PDDC,
	    ULONG);						 /* KH SEA2 */

ULONG	prdb_DeviceSelectBitmap (
	     HDC,
	     lpBitmap,
	     PDDC,
	     ULONG);						 /* KH SEA2 */

ULONG	prdb_GetBitmapParameters (
	     HDC,
	     BitmapParms  *,
	     PDDC,
	     ULONG);						 /* KH SEA2 */

ULONG	prdb_GetBitmapBits (
				     HDC,
				     ULONG,
				     ULONG,
				     Dptr,
				     InfoTableType  *,
				     PDDC,
				     ULONG);			 /* KH SEA2 */

ULONG	prdb_SetBitmapBits (
				     HDC,
				     ULONG,
				     ULONG,
				     Dptr,
				     InfoTableType  *,
				     PDDC,
				     ULONG);			 /* KH SEA2 */

ULONG	prdb_SetPel (
	     HDC,
	     ULONG  *,
	     PDDC,
	     ULONG);						 /* KH SEA2 */

ULONG	prdb_GetPel (
	    HDC,
	    WcsPoint  *,
	    PDDC,
	    ULONG);						 /* KH SEA2 */

ULONG	prdb_ImageData (
	    HDC,
	    Dptr,
	    ULONG,
	    ULONG,
	    PDDC,
	    ULONG);						/* KH SEA2 */

ULONG	prdb_BitBlt (
	    HDC,						/* KH SEA2 */
	    Dptr,
	    ULONG,
	    ULONG  *,
	    ULONG,
	    ULONG,
	    BitBltAttrsType  *, 			     /* KH SEA2 */
	    PDDC,						/* KH SEA2 */
	    ULONG);

/*
** Internal Routines
*/
ULONG  SetPel (PDDC, DevPoint, BitmapListEntry	*);	/* KH SEA5 */


short  prdb_CreateBitmap (
	    pDDTType,
	    LONG,
	    LONG,
	    LONG,
	    LONG,
	    PB,
	    SHORT  *);

SHORT  prdb_AddBitmap (
	    pDDTType,
	    lpBitmap,
	    BitmapParms  *,
	    SHORT,
	    SHORT);

SHORT  prdb_DeleteBitmap (
	    lpBitmap,
	    SHORT);

BitmapListEntry  *  prdb_FindBitmap (
	    lpBitmap);

SHORT  prdb_FreeBitmap (
	    lpBitmap);




LONG   prdb_GetScanLine(PDDC, PB);
