/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OS2_OEM.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V3.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#define MAX_OEM_PAGES   2

// these are defined in dlg.h, but OEMs won't be using that file;
// eventually, we'll have our own structures here . . .
#ifndef oem_h_
  extern HMODULE pscript_module;             // memory.c
  #define MAX_KEYWORD_LEN 41

  typedef struct
  {
    HWND  hPage;            // Page handle
    ULONG ulPageID;         // Page ID
    UCHAR ucPanelID;        // Identifies owner of feature
  } PAGE_DATA, *PPAGE_DATA;


  typedef struct
  {
    UINT       uiPropertyType;             // Either DLG_PSPRINTERPROP or
                                           // DLG_PSJOBPROP
    HWND       hDlg;                       // Main dialog handle
    HWND       hBook;                      // Notebook dialog handle
    PCNFDATA   pCNFData;                   // Contains stored data for dialog
    PDESPPD    pdesPPD;                    // Pointer to PPD data
    PCHAR      pItemsBuff;                 // Items Buffer pointer
    PUI_SEL    pCurrUISelList;             // Temp list of current UI selections
    PVOID      pUserData;                  // User defined buffer
    PAGE_DATA  stPage[ 1 ];                // Variable length page data struct.
  } DLGHDR, *PDLGHDR;
#endif

//@V3.0130814 -- MOVE FROM HP.H AND POSTSCR.RC
/*****************************************************************************/
// STRING DEFINES . . .
/*****************************************************************************/
#define ID_PPDSTR_KEY_COLORSMART       "ColorSmart"
#define ID_PPDSTR_KEY_COLORMODEL       "ColorModel"
#define ID_PPDSTR_KEY_PANTONE          "HPPantone"
#define ID_PPDSTR_KEY_PCCTEXT          "ColorSmartText"
#define ID_PPDSTR_KEY_PCCGRAF          "ColorSmartGraf"
#define ID_PPDSTR_KEY_PCCIMAG          "ColorSmartImag"
#define ID_PPDSTR_KEY_TEXTHIGHHALFTONE "ColorSmartTextHalftone"
#define ID_PPDSTR_KEY_GRAFHIGHHALFTONE "ColorSmartGrafHalftone"
#define ID_PPDSTR_KEY_IMAGHIGHHALFTONE "ColorSmartImagHalftone"
#define ID_PPDSTR_KEY_APPHALFTONING    "AppHalftoning"
//@V3.0130814 end

/*****************************************************************************/
// TYPEDEFS . . .
/*****************************************************************************/
typedef PDLGHDR LPPDEVICE;
typedef UINT    LPKEYWORDLISTREC;
typedef PSZ     LPSTR;
typedef UINT    LPDRVSTATE;
typedef USHORT  WORD;

/*****************************************************************************/
// UTILITY FUNCTION PROTOTYPES . . .
/*****************************************************************************/
extern INT LoadDrvrString( LPPDEVICE, WORD, LPSTR, INT );

extern INT KeywordListGetCurrentOption( LPPDEVICE, LPKEYWORDLISTREC,
                                        LPSTR, LPSTR, WORD, INT * );
extern INT KeywordListSetCurrentOption( LPPDEVICE, LPKEYWORDLISTREC,
                                        LPSTR, LPSTR, INT );
extern INT KeywordListSetCurrentOptionDialog( LPPDEVICE, LPKEYWORDLISTREC,
                                              LPSTR, LPSTR, INT );

extern PBYTE QueryUIOptionString( PDESPPD, PUI_SEL, PBYTE, PINT, PUI_BLOCK *);
// @V3.1UICLMM
extern INT SetUIOption( PDESPPD, PUI_SEL, PBYTE, PBYTE );

//@V3.130814
extern VOID OEMSetStatus( HWND, MPARAM );
