/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/****************************** Module Header ******************************\
*
* Module Name: MANDVECT.H
*
* POSTSCRIPT PRINTER DRIVER MANDATOTY FUNCTIONS
*
*
* ===========================================================================
* INCLUDED IN PRDEVECT.C
*
* ===========================================================================
* od_memory_vect IS USED TO STORE ALL THE MANDATORY FUNCTIONS THAT ARE TO BE
* SUPPORTED BY PRESENTAION DRIVERS (HARD COPY).
* LATER IN DEVBLOCK.C IN THE FUNCTION installvectortables WE WILL COPY THE
* FUNCTION ADDRESSES SUPLIED IN DISPATCH TABLE IN TO OUR od_memory_vect SO
* THAT IN CASE OF OD_MEMORY, WE CAN COPY THIS ENTIRE TABLE INTO DISPATCH TABLE.
*
* 02/16/93             :CREATED
*                       Kranthi Ravi
\***************************************************************************/
#pragma pack(1)

#pragma data_seg( global )
ULONG  prdm_DisjointLines();
ULONG  prdm_PolyShortLine();
ULONG  prdm_PolyScanline();
ULONG  prdm_DrawBits();
ULONG  prdm_DrawBorder();
ULONG  prdm_QueryDevResource();

VCTD od_memory_vect[NGREMAX+1] =
    {
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 7},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 5},
        {NULL, 6},
        {NULL, 5},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 3},
        {NULL, 5},
        {NULL, 4},
        {NULL, 0},
        {prdm_DisjointLines, 5},
        {prdl_GetCurrentPosition, 4},
        {prdl_SetCurrentPosition, 4},
        {prdl_PolyLine, 5},
        {prdl_DrawLinesInPath, 6},
        {prdm_PolyShortLine, 4},
        {prdm_PolyScanline, 4},
        {NULL, 7},
        {NULL, 6},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {prdm_DrawBits, 9},
        {prdb_DeviceCreateBitmap, 7},
        {prdb_DeviceDeleteBitmap, 6},
        {prdb_DeviceSelectBitmap, 4},
        {prdb_Bitblt, 9},
        {prdb_GetPel, 4},
        {prdb_SetPel, 4},
        {prdb_ImageData, 6},
        {NULL, 8},
        {NULL, 5},
        {NULL, 4},
        {NULL, 6},
        {prdm_DrawBorder, 9},
        {NULL, 5},
        {prdb_GetBitmapBits, 8},
        {prdb_SetBitmapBits, 8},
        {NULL, 4},
        {NULL, 0},
        {NULL, 0},
        {prdt_CharString, 5},
        {prdt_CharStringPos, 10},
        {prdt_QueryTextBox, 7},
        {prdt_QueryCharPositions, 9},
        {prda_QueryWidthTable, 6},
        {prdb_PolyMarker, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 3},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 4},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 7},
        {NULL, 7},
        {NULL, 5},
        {NULL, 4},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 5},
        {NULL, 7},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 6},
        {NULL, 7},
        {NULL, 7},
        {NULL, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 5},
        {NULL, 5},
        {NULL, 0},
        {NULL, 0},
        {NULL, 4},
        {NULL, 6},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 3},
        {NULL, 5},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 4},
        {NULL, 4},
        {NULL, 0},
        {NULL, 4},
        {NULL, 4},
        {NULL, 6},
        {NULL, 8},
        {NULL, 0},
        {NULL, 4},
        {NULL, 6},
        {NULL, 4},
        {NULL, 5},
        {NULL, 4},
        {NULL, 5},
        {NULL, 4},
        {NULL, 5},
        {NULL, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 5},
        {NULL, 0},
        {NULL, 0},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 4},
        {NULL, 6},
        {NULL, 7},
        {NULL, 0},
        {NULL, 4},
        {NULL, 4},
        {NULL, 6},
        {NULL, 6},
        {NULL, 0},
        {prda_DeviceGetAttributes, 6},
        {NULL, 6},
        {NULL, 0},
        {prda_GetPairKerningTable, 5},
        {NULL, 5},
        {prda_DeviceSetAttributes, 7},
        {prda_DeviceSetGlobalAttribute, 6},
        {prdl_NotifyClipChange, 6},
        {prdg_NotifyTransformChange, 5},
        {prda_RealizeFont, 6},
        {prdg_ErasePS, 3},
        {NULL, 4},
        {prda_DeviceQueryFontAttributes, 5},
        {prda_DeviceQueryFonts, 8},
        {NULL, 5},
        {NULL, 4},
        {NULL, 4},
        {prdg_ResetBounds, 4},
        {prdg_GetBoundsData, 5},
        {prdg_AccumulateBounds, 4},
        {NULL, 3},
        {NULL, 4},
        {prda_GetCodePage, 3},
        {prda_SetCodePage, 4},
        {prdg_LockDevice, 3},
        {prdg_UnlockDevice, 3},
        {NULL, 3},
        {NULL, 5},
        {NULL, 0},
        {prdg_GetDCOrigin, 4},
        {prdg_DeviceSetDCOrigin, 4},
        {prdl_GetLineOrigin, 4},
        {prdl_SetLineOrigin, 5},
        {prdd_GetStyleRatio, 4}, // Not a mandatory function, but GRE simulated path/area functions need it.
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {prdc_QueryColorData, 5},
        {prdc_QueryLogColorTable, 7},
        {prdc_CreateLogColorTable, 8},
        {prdc_RealizeColorTable, 3},
        {prdc_UnrealizeColorTable, 3},
        {prdc_QueryRealColors, 7},
        {prdc_QueryNearestColor, 5},
        {prdc_QueryColorIndex, 5},
        {prdc_QueryRGBColor, 5},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {NULL, 0},
        {prdq_QueryDeviceBitmaps, 5},
        {prdq_QueryDeviceCaps, 6},
        {prdq_Escape, 8},
        {prdq_QueryHardcopyCaps, 6},
        {prdm_QueryDevResource, 5},
        {NULL, 5},
        {NULL, 4},
        {NULL, 8},
        {NULL, 8},
        {NULL, 5},
        {NULL, 5},
        {NULL, 6},
        {NULL, 3},
        {NULL, 6},
        {NULL, 6}
    };
#pragma data_seg( )
/**************************** end of file **********************************/
