/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DLG.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V3.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)

#define MAX_KEYWORD_LEN 41

#define _DLG_H

/*
** WMJP_SAVESETTINGS - This is sent to all dialog pages from the Job
** Properties dialog box to indicate to save all settings pertaining to that
** dialog page.  This is sent only if "OK" is selected.
**
** WMJP_VERIFYSETTINGS - This is sent to all pages before the data is saved.
** When received, the pages must verify that their data is correct.  If all
** is OK (or if no verification is needed), the page must return TRUE.  If
** the data is not correct, the page must return FALSE.  Each page is
** responsible for handling its own error recovery.
**
** WMPS_CONSTRAINTS - This is sent every time a UI control is modified.  It
** is used to verify if any constraints exists with other UI features.
*/
#define WMPS_SAVESETTINGS   WM_USER
#define WMPS_VERIFYSETTINGS (WMPS_SAVESETTINGS + 1)
#define WMPS_CONSTRAINTS    (WMPS_SAVESETTINGS + 2)

#define WMPS_USER           (WMPS_SAVESETTINGS + 3)

/*
** These messages deal with the UI controls.
*/
#define UCM_INITIALIZE      WM_USER
#define UCM_LISTITEMS       (UCM_INITIALIZE + 1)
#define UCM_MODIFYHANDLE    (UCM_INITIALIZE + 2)
#define UCM_SETDEFAULT      (UCM_INITIALIZE + 3)
#define UCM_UNDO            (UCM_INITIALIZE + 4)
#define UCM_QUERYSELECTION  (UCM_INITIALIZE + 5)

/*
** These return code are sent to the dialog box from each page.
** PSDRC_VERIFY_SUCCESS is returned if successful to a WMPS_VERIFYSETTINGS
** message.
** PSDRC_SAVE_SUCCESSED is returned if successfult to a WMPS_SAVESETTINGS
** message.
** Both macros must contain the same value.
*/
//#define PSDRC_VERIFY_SUCCESS      0   // Page verification succesful
//#define PSDRC_SAVE_SUCCESS        0   // Page save successful

/*
** These are pre-defined handles for the dialog box.
*/
#define AUTOTRAY_HANDLE           -1              // AUTO TRAY SELECT handle
#define MANUALFEED_HANDLE         -2              // MANUAL FEED handle
#define NOFORMS_HANDLE            -3              // NO FORMS SELECTED handle
#define CUSTOMFORM_HANDLE         -4
/*
** This handle is used in computations only and should be the lowest value of
** all the values listed above.
*/
#define UNQ_FORM_HANDLE_BASE      -5

#define NO_VERSION_NAME            "???.???"

#define CONV_UNQID_TO_LBID( h )    (UNQ_FORM_HANDLE_BASE - h)
#define CONV_LBID_TO_UNQID( h )    (UNQ_FORM_HANDLE_BASE - h)
#define IS_UNQ_FORMID( h )         ((h - UNQ_FORM_HANDLE_BASE) <= 0)


/*
** Reserved flags for QueryFTOffsetFromString() in DLG.C.
*/
#define QUERY_FORM_LIST      1   // Query form list string
#define QUERY_TRAY_LIST      2   // Query tray list string
#define QUERY_CUSTOM_LIST    3   // Query custom form list string

#define CONVERT_OFS_TO_UISEL( o )    ((UI_SEL) (1 << o))

#define UCD_INITIALIZEPAGE        0
#define UCD_UNDOPAGE              1

#define QUERY_TRAY_HANDLE( h )  ((SHORT) (h >> 16))
#define QUERY_FORM_HANDLE( h )  ((SHORT) (h & 0xFFFF))

#define SET_TRAY_HANDLE( h, v ) (h = (INT) (h & 0x0000FFFF) | ((INT) v << 16))
#define SET_FORM_HANDLE( h, v ) (h = (INT) ((h & 0xFFFF0000) | \
                                            ((SHORT) v & 0xFFFF)))

#define SELECT_ITEM         TRUE
#define IGNORE_ITEM         FALSE

#define BLOCK_SEARCH_ALL    0
#define BLOCK_SEARCH_AND    1
#define BLOCK_SEARCH_NOT    2

#define IGNORE_CONSTRAINTS    ((PUI_BLOCK) 0)
#define QUERY_ALL_GROUPS      ((PUI_BLOCK) -1)
#define QUERY_INST_OPT_GROUP  ((PUI_BLOCK) -2)

// Used in ListUIItems(), lItemDisplay parameter.
#define DO_NOT_OVERWRITE   -1

/*
** These are pre-defined handles for Collate list box.
*/
#define NONE_COLLATE_HANDLE         -1      
#define SIM_COLLATE_HANDLE          -2




/*****************************************************************************\
* TYPEDEF DEFINITIONS                                                         *
\*****************************************************************************/
/*
** A unique form is either: a custom form (a form that has a unique size), or
** a user-defined form (a form that maps to a printer-defined form).
** The driver identifies an "empty" structure elememnt if aFormName[ 0 ] = 0,
** so, to reset a structure in the list, set aFormName[ 0 ] to 0.
*/
#define NUM_OF_UNQ_FORMS  INPBINS
typedef struct
{
  CHAR aFormName[ MAX_PSIZE ];    // Unique form name

  USHORT usCustWidth;             // Custom form width (pixels)
  USHORT usCustHeight;            // Custom form height (pixels)

  SHORT  sPrtHndlMap;             // Printer-defined form handle
  SHORT  sFlag;                   // Standard flags

    // Form marked for deletion
    #define UNQ_FORM_DELETE       1
    // New form created
    #define UNQ_FORM_NEW          2
} UNQFRM, *PUNQFRM;

/*
** This structure identifies a tray with other specific features, such as
** forms.  This structure makes up a list of TMENTRY structures in a buffer,
** each structure referencing a relavent tray (i.e. the first structure
** references the first tray, etc.)
** The number of TMENTRY structures allocates is the number of trays in
** the device.
*/
typedef struct _TMENTRY
{
  LONG  lFormID;              // Form offset in UI block or UNQFRM struct
} TMENTRY, *PTMENTRY;

/*
** The Dialog Header Structure contains information needed to maintain
** the dialog box.  This includes page data.
*/
typedef struct
{
  UINT       uiPropertyType;             // Either DLG_PSPRINTERPROP or
                                         // DLG_PSJOBPROP
  HWND       hDlg;                       // Main dialog handle
  PCNFDATA   pCNFData;                   // Contains stored data for dialog
  PDESPPD    pdesPPD;                    // Pointer to PPD data
  PEXTRA_DV  pExtraDV;                   // Pointer to Extra device information
  PCHAR      pItemsBuff;                 // Items Buffer pointer
  PUI_SEL    pCurrUISelList;             // Temp list of current UI selections
  UNQFRM     stUnqFrmLst[ NUM_OF_UNQ_FORMS ];   // Unique form structure
  USHORT     usFlags;                    // General Flags
              // Is color a UI control?
             #define IS_COLOR_UI      1
             // Display selected forms only
             #define DISP_SEL_FORMS   2
             // constraints - do no update controls
             #define UIC_NO_UPDATE    4
             // Override forms mismatch
             #define OVERRIDE_MM      8
             // OEM pages included
             #define INCLUDE_OEM      16
             // If set, then the INI data does not exist
             #define NO_INI_EXISTS    32
             // If set automatic unconstraining should excecute whithout  //@243371
             // asking no questions                                       //@243371
             #define UIC_NO_ASK       64

  PSZ        pCHBuffer;                  // Buffer containing help text
             #define CHBUFF_SIZE   256
  USHORT     usCHCtrl;                   // Contains current ctrl ID for C.S.
                                         // help - prevents ctrl flicker.

  USHORT     usNumTMEntries;             // # of tray map entries

  PVOID      pPtr;                       // Dialog-specific pointer

  HGJNI      hFontMgrPgInst;             // Font Manager notebook page instance //@FNTMGR
  HGJNI      hWebPagePgInst;             
  HGJNI      hNBInstance;
  HGJPI      hLayoutInstance;
  PGLCB      pLayoutCB;

  USHORT     usNumOfPages;               // Number of dialog pages
  GDPPI      stPage[ 1 ];                // Variable length page data struct.
} DLGHDR, *PDLGHDR;

extern HMODULE pscript_module;               // memory.c
extern PVOID   pProcessHeap;                 // memory.c
extern VOID  _System utl_memcopy( PB, PB, short int );





/*****************************************************************************\
* FUNCTION PROTOTYPES                                                         *
\*****************************************************************************/
extern HWND InitializeNotebookParams( HWND, USHORT, USHORT );
extern PDLGHDR InitializeDialogHeader( HWND, MPARAM, INT );
extern VOID FreeDialogHeader( PDLGHDR );
extern VOID InitializeDialog( HWND, PDLGHDR, UINT, PGDPTMPL, PGDPTMPL,
                              UINT, UINT, ULONG );
extern INT  FillTrayList( HWND, PDLGHDR, PSZ, PSZ, SHORT, PSHORT );
extern SHORT FillFormList( HWND, PDLGHDR, PSZ, HWND, INT, BOOL );
extern VOID SetSysMenuFields( HWND );
extern INT DisplayMessageBox( HWND, INT, INT, UINT );
extern MRESULT EXPENTRY FeaturePageDlgProc( HWND, ULONG, MPARAM, MPARAM );
extern LONG QueryFeaturePageLoad( PDLGHDR );

extern VOID FeaturePageInitControls( HWND, PDLGHDR );
extern UINT FeaturePageSaveSettings( HWND, PDLGHDR );
extern LONG VerifyAndSaveSettings( PDLGHDR );
extern VOID ClosePSDlg( HWND, PDLGHDR, BOOL );
extern INT  _Optlink CompareRealNames( PSZ, PSZ );
extern PFORMSTRUCT GetImageableArea( SHORT, PFORMSTRUCT, PDESPPD, PBYTE );
extern INT QueryMappedTray( PDLGHDR, PSZ );
extern INT AssignTrayHandle( PDLGHDR, PSZ, UINT, SHORT, HWND );
extern VOID DisplayFeaturesUIEntries( HWND, PUI_BLOCK, PDLGHDR );
extern INT DisplayUIEntries( HWND, PDLGHDR, PUI_BLOCK, INT, INT, BOOL );
extern PUI_BLOCK QueryBlockFromKeyword( PUI_LIST, PBYTE, PBYTE, PINT );
extern PUI_ENTRY QueryEntryFromOption( PBYTE, PUI_BLOCK, PBYTE, PINT );
extern VOID ChangeIconContents( HWND, INT, INT );
extern VOID UpdateIcon( HWND, HWND, INT, INT );
extern PUI_BLOCK InitializeUIControl( HWND, PDLGHDR, PSZ, LONG, LONG );
extern SHORT ListUniqueForms( HWND, PDLGHDR, INT, INT, INT );
extern MRESULT SetContextHelp( HWND, ULONG, MPARAM, MPARAM, PDLGHDR, INT,
                               INT );
extern VOID SetDuplexControls( HWND, PDLGHDR );
extern MRESULT SendConstraintsMessages( PDLGHDR, ULONG, LONG, PUI_BLOCK );
extern BOOL UpdateConstraints( HWND, PDLGHDR, ULONG, MPARAM, MPARAM );
extern VOID InsertExtraTrays( HWND, PDLGHDR, INT );
extern PDLGHDR InitDlgULong( HWND, MPARAM );
extern LONG ListPrtPropFormEntries( HWND, PDLGHDR, PUI_BLOCK, PUI_BLOCK,
                                    LONG );
extern VOID UpdatePrtPropFormSelection( HWND, PDLGHDR, ULONG );
extern VOID UpdateTrayHandle( HWND, PDLGHDR );
extern BOOL _Optlink QueryCnstListBlockList( PDLGHDR, PUI_BLOCK, LONG,
                                             PUI_BLOCK, LONG );
extern BOOL _Optlink QueryCnstListBlock( PDLGHDR, PUI_BLOCK, LONG, PUI_BLOCK,
                                         UI_SEL );
extern LONG _Optlink ListUIItems( HWND, PDLGHDR, PUI_BLOCK, BOOL, PUI_BLOCK,
                                  LONG, LONG );
extern LONG ListJobPropTrayEntries( HWND, PDLGHDR, PUI_BLOCK, HWND, LONG );
extern LONG InsertExtraItem( HWND, ULONG, LONG, PSZ, PSZ, SHORT, PLONG );
extern VOID UpdateJobPropFormSelection( HWND, PDLGHDR, PUI_BLOCK, ULONG );
