/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = AFMTOPFM.H
 *
 * DESCRIPTIVE NAME = AFM formatter
 *
 *
 * VERSION = V2.0
 *
 * DATE        : --/--/88
 *
 * DESCRIPTION :
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 *  Format of the ".pfm" file generated:
 *  ====================================
 *
 *   1. Header (offsets to other sections)
 *   2. Global font information
 *   3. Character metrics
 *   4. Pair Kerning data
 *   5. Comment, Notice, etc. strings
 *   6. Font metrics structure
 *
 *
 *  1. Header
 *  ---------
 *  Offset  Type
 *    0000  word    Version from StartFontMetrics
 *		    (whole portion in high byte, fractional in low)
 *    0002  word    Offset to Global font information
 *    0004  word    Offset to Character metrics
 *    0006  word    Offset to Pair Kerning data
 *    0008  word    Offset to Strings section
 *    000A  word    Offset to font metrics structure
 *    000C  word    Size of the 5 above sections (global, metrics, etc.)
 *
 *  Note:  All sections (char metrics, kerning, etc) start on
 *	   word-alinged boundaries.
 *
 *
 *
 *  2. Global font information
 *  --------------------------
 *  Offset  Type
 *    0000  word    VariablePitch	(ie, 1 for true, 0 for false)
 *    0002  word*4  FontBBox
 *    000A  word    CapHeight
 *
 *
 *
 *  3. Character metrics
 *  --------------------
 *  Offset  Type
 *    0000  byte    Char code to output in a PostScript show command
 *		    in order to display this character.  0=the font
 *		    must be remapped in order to display this char,
 *		    in which case just output the char directly.
 *    0001  word    Character width ("WX" argument)
 *     ......
 *
 *
 *
 *  4. Pair Kerning Data
 *  --------------------
 *  Offset  Type
 *    0000  word    Char code 1
 *    0002  word    Char code 2
 *    0004  word*2  Kerning vector	   ("KP/KPX" arguments)
 *     .....
 *    NOTE:  If this font is codepage 850 (winthorn multi-codepage support)
 *	     then the character codes above are actually the codes as
 *	     remapped by the codepage vector -- presently in the range
 *	     of 1-332.
 *
 *
 *
 *  5. Comment, Notice, Version, Fontname, EncodingString, and Weight strings
 *  -------------------------------------------------------------------------
 *  Offset  Type
 *    0000  asciiz  FontName string	(eg, "Times-RomanBold")
 *	    asciiz  Comment string
 *	    asciiz  Version string
 *	    asciiz  Notice string
 *	    asciiz  EncodingScheme	(eg, "AdobeStandardEncoding")
 *	    asciiz  Weight		(eg, "Bold")
 *
 *
 *
 *  6. Font metrics structure
 *  -------------------------
 *	CHAR	szFamilyname[FACESIZE];
 *	CHAR	szFacename[FACESIZE];
 *	SHORT	idRegistry;		 / We always write as 0 /
 *	SHORT	usCodePage;		 / 850 = Adobe standard encoding
 *						 scheme; this font will
 *						 offer winthorn multi-
 *						 codepage support
 *					     0 = Adobe font-specific
 *						 encoding; no multi-
 *						 codepage support /
 *	LONG	lEmHeight;		 / Height of emSquare (1000) /
 *	LONG	lXHeight;		 / Height of lowercase x /
 *	LONG	lMaxAscender;		 / Top of font bounding box /
 *	LONG	lMaxDescender;		 / Bottom of font bounding box /
 *	LONG	lLowerCaseAscent;	 / Top of tallest lowercase char /
 *	LONG	lLowerCaseDescent;	 / Bottom of lowest lowercase descender /
 *	LONG	lInternalLeading;	 / lMaxBaselineExt minus lEmHeight /
 *	LONG	lExternalLeading;	 / Always zero /
 *	LONG	lAveCharWidth;		 / Weighted average of char widths /
 *	LONG	lMaxCharInc;		 / Widest character /
 *	LONG	lEmInc; 		 / Width of emSquare (1000) /
 *	LONG	lMaxBaselineExt;	 / lMaxAscender + lMaxDescender /
 *	SHORT	sCharSlope;		 / ItalicAngle field from afm file /
 *	SHORT	sInlineDir;		 / 0 Degrees = left to right /
 *	SHORT	sCharRot;		 / We always write as 0 /
 *	SHORT  usWeightClass;		/ Font weight 1-9 /
 *	SHORT  usWidthClass;		/ We always write as 5 (normal) /
 *	SHORT	sXDeviceRes;		 / We always write as 1000 /  !!CR
 *	SHORT	sYDeviceRes;		 / We always write as 1000 /  !!CR
 *	SHORT	sFirstChar;		 / We always write as 1 /
 *	SHORT	sLastChar;		 / For codepage 850, this is 332
 *					 / For codepage 0, this is 255	 /
 *	SHORT	sDefaultChar;		 / We always write as 31 /
 *	SHORT	sBreakChar;		 / We always write as 31 /
 *	SHORT	sNominalPointSize;	 / We always write as 120 (12 pt.) /
 *	SHORT	sMinimumPointSize;	 / We always write as 10 /
 *	SHORT	sMaximumPointSize;	 / We always write as 7200 /
 *	SHORT  fsType;			/ 0 = proportional, 1 = fixed /
 *	SHORT  fsDefn;			/ 1 = outline /
 *	SHORT  fsSelection;		/ We always write as 0 /  !!CR
 *	SHORT  fsCapabilities;		/ 0 = Can mix text and graphics /
 *	LONG	lSubscriptXSize;	 / We always write as 0 /
 *	LONG	lSubscriptYSize;	 / We always write as 0 /
 *	LONG	lSubscriptXOffset;	 / We always write as 0 /
 *	LONG	lSubscriptYOffset;	 / We always write as 0 /
 *	LONG	lSuperscriptXSize;	 / We always write as 0 /
 *	LONG	lSuperscriptYSize;	 / We always write as 0 /
 *	LONG	lSuperscriptXOffset;	 / We always write as 0 /
 *	LONG	lSuperscriptYOffset;	 / We always write as 0 /
 *	LONG	lUnderscoreSize;	 / From afm file /
 *	LONG	lUnderscorePosition;	 / From afm file /
 *	LONG	lStrikeoutSize; 	 / Based on hyphen character /
 *	LONG	lStrikeoutPosition;	 / Based on hyphen character /
 *	SHORT	sKerningPairs;		 / From afm file
 *	SHORT	sFamilyClass;		 / Based on DCR 24415 /
 *	LONG	lMatch; 		 / We always write as 0 /
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1) 




#define FACESIZE	32

/*
**  values of sFamilyClass as defined by DCR24415
*/
/*
**  values of sFamilyClass as defined by
*/

#define     FATTR_FAM_NO_CLASSIFICATION   0
#define     FATTR_FAM_OLD_STYLE_SERIF	  1
#define     FATTR_FAM_TRANSITIONAL_SERIF  2
#define     FATTR_FAM_MODERN_SERIF	  3
#define     FATTR_FAM_CLARENDON_SERIF	  4
#define     FATTR_FAM_SLAB_SERIF	  5
#define     FATTR_FAM_RESERVED1 	  6
#define     FATTR_FAM_FREEFORM_SERIF	  7
#define     FATTR_FAM_SANS_SERIF	  8
#define     FATTR_FAM_ORNAMENTAL	  9
#define     FATTR_FAM_SCRIPT		 10
#define     FATTR_FAM_RESERVED2 	 11
#define     FATTR_FAM_SYMBOLIC		 12
#define     FATTR_FAM_IDEOGRAPHIC	 13
#define     FATTR_FAM_SYLLABIC		 14
#define     FATTR_FAM_MISCELLANEOUS	 15


/*
**  weight classes
*/

#define FW_LIGHT	 3
#define FW_SEMILIGHT	 4
#define FW_NORMAL	 5
#define FW_SEMIBOLD	 6
#define FW_BOLD 	 7
#define FW_EXTRABOLD	 8
#define FW_ULTRABOLD	 9

#define FIRST_CHAR	1
#define LAST_CHAR	322
#define CODE_PAGE	850

#define MAX_STR 	80
#define MAX_CHARS	512
#define MAX_KPAIRS	1800
#define MAX_KTRACKS	10
#define MAX_COMPOSITES	64
#define MAX_COMP_PARTS	4

#define MAX_LINESIZE	256
#define MAX_OBUFFSIZE	12288

#define ULTRACONDENSED	1
#define EXTRACONDENSED	2
#define CONDENSED	3
#define SEMICONDENSED	4
#define MEDIUM		5
#define SEMIEXPANDED	6
#define EXPANDED	7
#define EXTRAEXPANDED	8
#define ULTRAEXPANDED	9

typedef unsigned char Byte;
typedef unsigned Word;
typedef unsigned WORD;
typedef unsigned long Dword;

typedef struct {
    PSZ     pszName;
    SHORT   iCP850Code,
	    ipscriptCode;
} CharData;		       /* cd   */

typedef CharData  *PCD;

typedef struct {
    int     left;
    int     bottom;
    int     right;
    int     top;
} Rect;

typedef Rect  *PRECT;

typedef struct {
    int     x;
    int     y;
} Vector;


typedef struct {	    /* metric info for a single char */
    int     ipscriptCode ;	/* char code to use in postscript show */
    Rect    rc; 		/* bounding box */
    Vector  cvec;		/* vector */
} CMData;

typedef struct {	    /* info for a single kern pair */
    int     iKey1, iKey2 ;	/* Code page 850 words of the two chars */
    SHORT   sAmount;		/* kerning amount for pair */
} KPair;

typedef struct {	    /* info for a single AFM file */

/*
**  global info
*/
    Word    version;
    int     iMaxWidth;
    int     iCapHeight;
    BOOL    fVariablePitch;
    Rect    rcBBox;
    char    szFontName[MAX_STR];
    char    szEncodingScheme[MAX_STR];
    char    szComment[MAX_STR];
    char    szWeight[MAX_STR];
    char    szVersion[MAX_STR];
    char    szNotice[MAX_STR];

    CMData  rgcm[MAX_CHARS];	/* the character metrics */
    int     cKPairs;		/* the number of kerning pairs */
    KPair   rgKPairs[MAX_KPAIRS];
} AfmData;

/*
**  weighting factors for computing lAveWidth
*/

int iWeightFactor[] = { 64,		/* a */
			14,		/* b */
			27,		/* c */
			35,		/* d */
		       100,		/* e */
			20,		/* f */
			14,		/* g */
			42,		/* h */
			63,		/* i */
			 3,		/* j */
			 6,		/* k */
			35,		/* l */
			20,		/* m */
			56,		/* n */
			56,		/* o */
			17,		/* p */
			 4,		/* q */
			49,		/* r */
			56,		/* s */
			71,		/* t */
			31,		/* u */
			10,		/* v */
			18,		/* w */
			 3,		/* x */
			18,		/* y */
			 2,		/* z */
		       166 };		/* space */

enum toktype {
	tok_fontname,	     /* added: FullName, EncodingScheme, FamilyName */
	tok_fullname,
	tok_encodingscheme,
	tok_familyname,
	tok_comment,
	tok_weight,
	tok_italicangle,
	tok_isfixedpitch,
	tok_fontbox,
	tok_underlineposition,
	tok_underlinethickness,
	tok_version,
	tok_notice,
	tok_capheight,
	tok_xheight,
	tok_ascender,
	tok_descender,
	tok_startcharmetrics,
	tok_c,
	tok_wx,
	tok_w,
	tok_n,
	tok_b,
	tok_l,
	tok_endcharmetrics,
	tok_startkerndata,
	tok_startkernpairs,
	tok_kp,
	tok_kpx,
	tok_endkernpairs,
	tok_starttrackkern,
	tok_trackkern,
	tok_endtrackkern,
	tok_endkerndata,
	tok_startfontmetrics,
	tok_endfontmetrics,
	tok_startcomposites,
	tok_cc,
	tok_pcc,
	tok_endcomposites,

	tok_max,
	tok_unknown
};
typedef enum toktype TokType;

char *tokens[tok_max] = {
	"FontName",
	"FullName",
	"EncodingScheme",
	"FamilyName",
	"Comment",
	"Weight",
	"ItalicAngle",
	"IsFixedPitch",
	"FontBBox",
	"UnderlinePosition",
	"UnderlineThickness",
	"Version",
	"Notice",
	"CapHeight",
	"XHeight",
	"Ascender",
	"Descender",
	"StartCharMetrics",
	"C",
	"WX",
	"W",
	"N",
	"B",
	"L",
	"EndCharMetrics",
	"StartKernData",
	"StartKernPairs",
	"KP",
	"KPX",
	"EndKernPairs",
	"StartTrackKern",
	"TrackKern",
	"EndTrackKern",
	"EndKernData",
	"StartFontMetrics",
	"EndFontMetrics",
	"StartComposites",
	"CC",
	"PCC",
	"EndComposites",
};



