/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  IMG2BIN.C
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS : GetLine              SkipWhite               szIsEqual
 *             GetName              MarkProcedure           IsBeginProc
 *             IsEndProc            GetProc                 CopyFile
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1) 
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <stdio.h>
#include <io.h>

#include "inc\image.h"


#define TRUE   1
#define FALSE  0

typedef int BOOL;

IMAGE_PROCS hdr;


/***************************************************************************
 *
 * FUNCTION NAME =  GetLine
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

int GetLine (FILE *stm, char *pbBuf, int nbBuf)
{
  int iStatus;

  iStatus = fgets (pbBuf, nbBuf, stm) != 0;
  return (iStatus);
}


/***************************************************************************
 *
 * FUNCTION NAME =  SkipWhite
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

char *SkipWhite (char *psz)
{
  while (*psz == ' ')
  {
    ++psz;
  }
  return (psz);
}


/***************************************************************************
 *
 * FUNCTION NAME =  szIsEqual
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

int szIsEqual (register char *psz1, register char *psz2)
{
  register char b;

  while ((b = *psz1++) == *psz2++)
  {
    if (!b)
    {
      return (TRUE);
    }
  }
  return (FALSE);
}


/***************************************************************************
 *
 * FUNCTION NAME =  GetName
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

char *GetName (char *szLine, char *szName, int cbBuf)
{
  int iCh;

  while ((iCh = *szLine++) && (--cbBuf > 0))
  {
      if (!(iCh=='_' ||
            (iCh >='A' && iCh<='Z')  ||
            (iCh >='a' && iCh<='z')  ||
            (iCh >= '0' && iCh <='9')))
      {
          break;
      }

      *szName++ = iCh;
  }
  *szName = 0;

  return (--szLine);
}


/***************************************************************************
 *
 * FUNCTION NAME =  MarkProcedure
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

void MarkProcedure (char *szProcName, int ofsProc, int cbProc)
{
  LOCATOR *plc;

  if (szIsEqual(szProcName, "read_1_mono"))
  {
    plc = &hdr.lcMono1;
  }
  else if (szIsEqual(szProcName, "read_4_mono"))
  {
    plc = &hdr.lcMono4;
  }
  else if (szIsEqual(szProcName, "read_8_mono"))
  {
    plc = &hdr.lcMono8;
  }
  else if (szIsEqual(szProcName, "read_1_color"))
  {
    plc = &hdr.lcColor1;
  }
  else if (szIsEqual(szProcName, "read_4_color"))
  {
    plc = &hdr.lcColor4;
  }
  else if (szIsEqual(szProcName, "read_8_color"))
  {
    plc = &hdr.lcColor8;
  }
  else if (szIsEqual(szProcName, "read_24_color"))
  {
    plc = &hdr.lcColor24;
  }

  plc->cb  = cbProc;
  plc->ofs = ofsProc;
}


/***************************************************************************
 *
 * FUNCTION NAME =  IsBeginProc
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

BOOL IsBeginProc (char *pszLine, char *pszName, int cbBuf)
{
  pszLine = SkipWhite (pszLine);

  if (*pszLine++!='%')
  {
    return (FALSE);
  }
  pszLine = SkipWhite (pszLine);

  pszLine = GetName (pszLine, pszName, cbBuf);
  if (szIsEqual ("begin", pszName))
  {
    pszLine = SkipWhite (pszLine);
    pszLine = GetName (pszLine, pszName, cbBuf);
    return (TRUE);
  }
  return (FALSE);
}


/***************************************************************************
 *
 * FUNCTION NAME =  IsEndProc
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

BOOL IsEndProc (char *pszLine)
{
  char szName[64];

  pszLine = SkipWhite (pszLine);
  if (*pszLine++!='%')
  {
    return(FALSE);
  }
  pszLine = SkipWhite (pszLine);

  pszLine = GetName (pszLine, szName, sizeof (szName));
  if (szIsEqual ("end", szName))
  {
    return(TRUE);
  }
  else
  {
    return(FALSE);
  }
}


/***************************************************************************
 *
 * FUNCTION NAME =  GetProc
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

int GetProc (FILE *stmIn, char *pszProcName, int cbNameBuf, char *pbProcBuf)
{
  char  szLine[256];
  char *pszLine;
  int   cbProc = 0;
  int   iStatus;

  while (iStatus = GetLine(stmIn, szLine, sizeof(szLine)))
  {
    if (IsBeginProc (szLine, pszProcName, cbNameBuf))
    {
      break;
    }
  }

  if (!iStatus)
  {
      goto END_OF_FILE;
  }

  cbProc = 0;
  while (GetLine (stmIn, szLine, sizeof (szLine)))
  {
    if (IsEndProc (szLine))
    {
      break;
    }

    pszLine = SkipWhite (szLine);
    if (*pszLine != '%')
    {
      while (*pszLine)
      {
        *pbProcBuf++ = *pszLine++;
        ++cbProc;
      }
    }
  }

END_OF_FILE:

  return (cbProc);
}


/***************************************************************************
 *
 * FUNCTION NAME =  CopyFile
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

void CopyFile (FILE *fOut, FILE *stmIn)
{
  static char pbProcBuf[2048];

  char  szProcName[64];
  char  szBuffer[256];
  char *pb;
  int   cbProc;
  int   ofsFile = sizeof (hdr);

  hdr.lVersion = 0x01000L;

  if (fOut)
  {
    fwrite (&hdr, 1, sizeof (hdr), fOut);
  }

  while (cbProc = GetProc (stmIn, szProcName, sizeof (szProcName), pbProcBuf))
  {
    if (fOut)
    {
        fwrite (pbProcBuf, 1, cbProc, fOut);
    }
    else
    {
        MarkProcedure (szProcName, ofsFile, cbProc);
    }
    ofsFile += cbProc;
  }
}


/***************************************************************************
 *
 * FUNCTION NAME =  main
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 **************************************************************************/

main (int argc, char **argv)
{
  FILE *stmIn;
  FILE *fOut;

  if (argc!=3)
  {
    printf ("Argument error: expected <input file> <output file>\n");
    exit (1);
  }
  stmIn = fopen (argv[1], "r");
  if (!stmIn)
  {
    printf ("Can't open input file: %s\n", argv[1]);
    exit (1);
  }
  fOut = fopen (argv[2], "w+b");

  if (!fOut)
  {
    printf ("Can't open output file: %s\n", argv[2]);
    fclose (stmIn);
    exit (1);
  }

  /*
  ** Pss 1 calculates the offsets.
  */
  CopyFile (0, stmIn);
  fseek (stmIn, 0L, SEEK_SET);

  /*
  ** Pass 2 generates output file.
  */
  CopyFile (fOut, stmIn);

  fclose (stmIn);
  fclose (fOut);
}
