/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
** @v3.0129238 This function is no longer needed.
*/
#if 0
///**************************************************************************
// *
// * SOURCE FILE NAME = EFFECTS.C
// *
// * DESCRIPTIVE NAME = PRINTER DRIVER SOURCE
// *
// *
// * VERSION = V2.0
// *
// * DATE        04/01/89
// *
// * DESCRIPTION  Contains routines related to displaying the
// *              options dialog box.
// *
// * FUNCTIONS
// *
// * FUNCTION NAME  OptionsDialog   This routine accompanies the PostScript
// *                                Printer Properities dialog box.
// *            OptionDialogSetup   This routine sets up various items in the
// *                                options dialog box.
// *
// *
// * NOTES
// *
// *
// * STRUCTURES
// *
// * EXTERNAL REFERENCES
// *
// * EXTERNAL FUNCTIONS
// *
// * CHANGE ACTIVITY =
// *   DATE      FLAG        APAR   CHANGE DESCRIPTION
// *   --------  ----------  -----  --------------------------------------
// *   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
// *
// *
// *
// *
// *                                OptionsDialog
// *                                OptionDialogSetup
// *
// *
// *                                Wed Dec 13, 1989  17:01:00  -by-  Kent Settle
// *                                [kentse]
// *                                General clean-up and added comments.
// *                                OptionDialogSetup -re-wrote it.
// *
// *                                Thu Oct 19, 1990  04:05:00  -by-    Darrem Miclette [miclette@pc1]
// *                                added restore of config data upon ESC from dlg, and added enable/disable
// *                                of dialog around the OK verification code, since it is so slow we
// *                                could be re-entered with another OK before it was done.
// *
// *                                EDIT_FILE entryfield to maximum allowable.
// *
// *                                -Lee Tartak-
// *
// *   01/05/95  @V3.0GAMMA1        Add gamma correction support.
// *
// *   07/13/95  @V3.129238         Add new Postscript level 2 User Interface (UI)
// *
// ***********************************************************************/
//#define  INCL_WIN
//#define  INCL_PM
//#include <os2.h>
//#include <bseerr.h>
//// @V3.0GAMMA1
//#include <stdlib.h>
//#include <string.h>
//
//#include "inc\ppdialog.h"
//#include "inc\fileext.h"
//#include "inc\config.h"
//#include "inc\dlgproc.h"
//#include "inc\pspagtun.h"              /* V2.174057   Page Tuning */
//
//ULONG PostMsgBox(HMODULE,SHORT,SHORT,SHORT);
//VOID OptionDialogSetup(HWND,PB  *);
//
//#ifdef   YEAH_RIGHT_DUDES
//  extern BOOL EXPENTRY InternalInit(HWND,SHORT,SHORT);
//#endif
//
//
///*
//** @V3.0GAMMA1       START
//*/
///*
//** This function displays the gamma value retrieved from the slider on
//** a text control.
//*/
//VOID DisplayGammaValue( HWND, ULONG, LONG );
//
///*
//** These defines make up the tick information for the Gamma Correction slide
//** bar.  For more information on ticks, refer to the Programming Guide, vol 2.
//** GC_SLIDE_HOME_VAL is the value of the home position.
//** GC_SLIDE_INCREMENT_VALUE is the increment value from one tick to another.
//**   For example, if this is 2 and GC_SLIDE_MIN_VAL is -10, then the next tick
//**   mark to the right of GC_SLIDE_MIN_VALUE is -8.  Fractional values are
//**   allowed, but limited from 0.1 to 0.9.
//** GC_SLIDE_NUM_OF_TICKS is ((GC_SLIDE_MAX_VAL - GC_SLIDE_MIN_VAL) *
//**   GC_SLIDE_INCREMENT_VALUE) + 1 (the '+ 1' is to include 0).  This must
//**   be hard coded because the resource compiler can't handle math.
//** GC_SLIDE_MAJOR_TICK_PIXEL_LEN and GC_SLIDE_MINOR_TICK_PIXEL_LEN
//**   deterine the pixel length of the ticks.  The pixel length is from the bar
//**   to the numeric value above the tick.  The major tick is always twice as
//**   long as the minor tick.
//** GC_SLIDE_MAJOR_TICK_PLACE determines the pattern for placing major ticks.
//**   If the value is 1, every tick is major.  If 2, every second tick is major.
//**   If 3, every third tick is major, etc.  The pattern algorithm is to use
//**   modular division.  If the result is 0, a major tick is inserted.
//**   Otherwise, a minor tick is inserted.
//**   ** This must be an integer value. **
//**   ** No error checking is performed on these values. **
//*/
//#define GC_SLIDE_HOME_VAL              1
//#define GC_SLIDE_INCREMENT_VALUE       1   // Increment value of ticks
//#define GC_SLIDE_NUM_OF_TICKS          50
//#define GC_SLIDE_MAJOR_TICK_PIXEL_LEN  6   // Length of tick mark from bar to #
//#define GC_SLIDE_MINOR_TICK_PIXEL_LEN  (INT) (GC_SLIDE_MAJOR_TICK_PIXEL_LEN / 2)
//#define GC_SLIDE_MAJOR_TICK_PLACE      10  // Pattern where maj. ticks are used
///*
//** @V3.0GAMMA1    END
//*/
//
//
//
//
///***************************************************************************
// *
// * FUNCTION NAME = OptionsDialog
// *
// * DESCRIPTION   = This routine accompanies the PostScript Printer Properities
// *                 dialog box.  This routine displays list boxes with the
// *                 printer models, paper trays, and form types.  It also allows
// *                 access to the job properties dialog box.
// *
// * INPUT         = (hWnd,uMsg,mp1,mp2)
// *
// * OUTPUT        = NONE
// *
// * RETURN-NORMAL = 0L, 1L, (ULONG)IDH_KEYS,
// *                 (ULONG)WinDefDlgProc(hWnd, uMsg, mp1, mp2))
// *
// * RETURN-ERROR  = NONE
// *
// **************************************************************************/
//
//ULONG EXPENTRY OptionsDialog( HWND hWnd, SHORT uMsg, MPARAM mp1, MPARAM mp2 )
//{
//  SHORT     i, iNumCopies;
//  PB       *apResources;           /* list of pointers to printer resources. */
//  PCNFDATA  pcnfData;              /* pointer to printer configuration.      */
//  HWND      hWnd1;                 /* A temp child window handle.            */
//  MRESULT   mi;
//  PCNFDATA  pcnfLocal;             /* a local copy of configuration data.    */
//  CHAR      szBuffer[MAX_PSIZE];   /* a scratch buffer to read edit fields.  */
//  PSZ       pszb;
//
//  switch (uMsg)
//  {
//  case WM_COMMAND:
//       /*
//       ** retrieve the address of our resources, so we can get
//       ** access to our configuration data.
//       */
//
//      apResources = (PB *) WinQueryWindowULong( hWnd, QWL_USER );
//
//      /*
//      ** Pointer to printer icon data.
//      */
//      pcnfData = (PCNFDATA) apResources[CNFRES];
//
//      /*
//      ** Pointer to local printer data.
//      */
//      pcnfLocal = (PCNFDATA) apResources[LCLRES];
//
//      /*
//      ** mp1 tells what option the user selected in the printer
//      ** properties dialog box.
//      */
//      switch (LOUSHORT(mp1))
//      {
//      case MBID_OK:
//           /*
//           **      ALERT:  THIS CAN BE REMOVED AFTER TRUE STACK SWITCH
//           **      ALERT:  IS PUT IN THE DRIVER
//           ** We need to disable the dialog while we verify the contents
//           ** of the dialog so we don't nest so deep that we walk on the
//           ** applications stack.  If we don't disable the dialog here it
//           ** will be re-enabled before the verification is complete, or
//           ** before any error message dialogs appear.
//           ** NOTE: the re-enables come after PostMsgBox is called.
//           ** DO NOT CHANGE THIS!!  It can lead to a funny series of
//           ** events if the user clicks twice in quick succession on the
//           ** OK button, !BUT! this verify code is so SLOW that the
//           ** successive OK clicks WILL make it back in here before the
//           ** WinDlgBox if the enable happens just before the PostMsgBox
//           ** call.  This will tread deeper in the users stack, possibly
//           ** wasting him.  This may let us get away by the skin on our
//           ** teeth, before the stack switch is implemented.
//           ** The funny effect has to do with the focus chain getting
//           ** messed up by the window manager.  Another window may get
//           ** temporary focus when the error dlg's get canceled.
//           */
//          WinEnableWindow( hWnd, FALSE );
//
//          /*
//          ** the user has selected the OK button.  so we will be
//          ** leaving the options dialog box.  but first we want to
//          ** verify that the copies, job timeout, wait timeout, and
//          ** destination fields are all valid.
//          ** read the copies field into szBuffer.  make sure
//          ** it is a valid number of copies.
//          */
//          WinQueryDlgItemText( hWnd, EDIT_COPIES, sizeof( szBuffer ),
//                               (PSZ) szBuffer );
//
//          /*
//          ** here we will check to make sure the uncollated copies
//          ** value is > 0, if so the value ends up in
//          ** pcnfData->iCntCopies
//          */
//          pszb = szBuffer;
//
//          /*
//          ** @V3.0GAMMA1
//          ** Retrieve the gamma value from the slider.  Multiply it by 10
//          ** and store it in the structure.  The reason for this is because
//          ** the gamma function divides the value by 10 to get the real
//          ** value.  This is so that the gamma value can be stored as an
//          ** integer and not as a floating point value.
//          */
//          i = (USHORT) WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE,
//                       SLM_QUERYSLIDERINFO,
//                       MPFROM2SHORT( SMA_SLIDERARMPOSITION,
//                                     SMA_INCREMENTVALUE ),
//                       (MPARAM) 0 );
//          pcnfData->lGammaValue = (LONG) (i + 1);
//
//          if (!CheckNumeric( hWnd, (PSZ) szBuffer) || ((iNumCopies =
//              cvi( (PB *)&pszb )) <= 0))
//          {
//            /*
//            ** let the user know the copies field is invalid.
//            */
//            PostMsgBox( (HMODULE) pcnfData->hmod, (SHORT) 0, IDM_BadNumCopies,
//                        MB_OK | MB_ICONEXCLAMATION );
//
//            /*
//            ** tell the dialog box to select the entire edit field.
//            */
//            WinSendDlgItemMsg( hWnd, EDIT_COPIES, EM_SETSEL, (MPARAM)
//                               MPFROM2SHORT( (SHORT) 0, (SHORT) 3 ), (MPARAM) 0L );
//
//            /*
//            ** put the cursor on the copies edit box.
//            */
//            WinEnableWindow( hWnd, TRUE );
//            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_COPIES) );
//            break;
//          }
//
//          /*
//          ** Store number of copies, after it's valid
//          */
//          pcnfData->iCntCopies = iNumCopies;
//
//          /*
//          ** read the job timeout field into szBuffer.  make sure
//          ** it is a valid timeout.
//          */
//          WinQueryDlgItemText( hWnd, EDIT_JOB, sizeof(szBuffer), (PSZ)szBuffer);
//
//          if (!CheckNumeric( hWnd, (PSZ) szBuffer) || szBuffer[0] == '-')
//          {
//            /*
//            ** let the user know the job timeout is invalid.
//            */
//            PostMsgBox( (HMODULE) pcnfData->hmod, (SHORT) 0, IDM_BadJobTimeout,
//                        MB_OK | MB_ICONEXCLAMATION );
//
//            /*
//            ** tell the dialog box to select the entire edit field.
//            */
//            WinSendDlgItemMsg(hWnd, EDIT_JOB, EM_SETSEL, (MPARAM) MPFROM2SHORT
//               ((SHORT) 0, (SHORT) 3), (MPARAM) 0L );
//
//            /*
//            ** put the cursor on the job timeout edit box.
//            */
//            WinEnableWindow( hWnd, TRUE );
//            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_JOB) );
//            break;
//          }
//
//          /*
//          ** store the job timeout value.
//          */
//          pszb = szBuffer;
//          pcnfData->effOutput.iJobTimeout = cvi( (PB *) &pszb );
//
//          /*
//          ** read the wait timeout field into szBuffer.  make sure
//          ** it is a valid timeout.
//          */
//          WinQueryDlgItemText( hWnd, EDIT_WAIT, sizeof(szBuffer), (PSZ) szBuffer );
//
//          if (!CheckNumeric( hWnd, (PSZ) szBuffer) || szBuffer[0] == '-')
//          {
//            /*
//            ** let the user know the wait timeout is invalid.
//            */
//            PostMsgBox( (HMODULE) pcnfData->hmod, (SHORT) 0, IDM_BadWaitTimeout,
//                        MB_OK | MB_ICONEXCLAMATION );
//
//            /*
//            ** tell the dialog box to select the entire edit field.
//            */
//            WinSendDlgItemMsg( hWnd, EDIT_WAIT, EM_SETSEL, (MPARAM) MPFROM2SHORT
//               ((SHORT) 0, (SHORT) 3), (MPARAM) 0L );
//
//            /*
//            ** put the cursor on the wait timeout edit box.
//            */
//            WinEnableWindow( hWnd, TRUE );
//            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_WAIT) );
//            break;
//          }
//
//          /*
//          ** store the wait timeout value.
//          */
//          pszb = szBuffer;
//          pcnfData->effOutput.iWaitTimeout = cvi( (PB *) &pszb );
//
//          /*
//          ** it is invalid to have a job timeout < wait timeout.
//          */
//
//          if (pcnfData->effOutput.iJobTimeout <
//             pcnfData->effOutput.iWaitTimeout)
//          {
//            /*
//            ** let the user know the job timeout is invalid.
//            */
//            PostMsgBox( (HMODULE) pcnfData->hmod, (SHORT) 0, IDM_JobLTWait,
//                        MB_OK | MB_ICONEXCLAMATION );
//
//            /*
//            ** tell the dialog box to select the entire edit field.
//            */
//            WinSendDlgItemMsg( hWnd, EDIT_JOB, EM_SETSEL, (MPARAM) MPFROM2SHORT
//               ((SHORT) 0, (SHORT) 3), (MPARAM) 0L );
//
//            /*
//            ** put the cursor on the job timeout edit box.
//            */
//            WinEnableWindow( hWnd, TRUE );
//            WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_JOB) );
//            break;
//          }
//
//          /*
//          ** if the destination is a RAW or ENCAPS postscript file,
//          ** validate the filename.
//          */
//          if (pcnfData->iDestnType == RAW || pcnfData->iDestnType == ENCAPS)
//          {
//            /*
//            ** read the destination file name.
//            */
//
//            WinQueryDlgItemText( hWnd, EDIT_FILE, sizeof(szBuffer), (PSZ)
//               pcnfData->szDestnFile );
//
//            if (!ValidFilename((PSZ) pcnfData->szDestnFile))
//            {
//
//              /*
//              ** let the user know the filename is invalid.
//              */
//              PostMsgBox( (HMODULE) pcnfData->hmod, (SHORT) 0, IDM_BadFileName,
//                 MB_OK | MB_ICONEXCLAMATION );
//
//              /*
//              ** tell the dialog box to select the entire edit field.
//              */
//              WinSendDlgItemMsg( hWnd, EDIT_FILE, EM_SETSEL, (MPARAM)
//                 MPFROM2SHORT((SHORT) 0, (SHORT) 3), (MPARAM) 0L );
//
//              /*
//              ** put the cursor on the file edit field.
//              */
//              WinEnableWindow( hWnd, TRUE );
//              WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_FILE) );
//              break;
//            }
//          }
//          WinEnableWindow( hWnd, TRUE );
//          WinDismissDlg( hWnd, TRUE );
//          break;
//
//      case MBID_CANCEL:
//           /*
//           ** the user has selected Cancel.  dismiss the dialog
//           ** box without saving anything.
//           ** transfer to local copy.
//           */
//           *pcnfData = *(PCNFDATA) pcnfLocal;
//           WinDismissDlg( hWnd, TRUE );
//           break;
//
//      default:
//           break;
//      }
//      break;                           /* WM_COMMAND. */
//
//  case WM_CONTROL:
//       /*
//       ** retrieve the address of our resources, so we can get
//       ** access to our configuration data.
//       */
//       apResources = (PB *) WinQueryWindowULong( hWnd, QWL_USER );
//       pcnfData = (PCNFDATA) apResources[CNFRES];/* pointer to printer
//                                           configuration data                */
//       pcnfLocal = (PCNFDATA) apResources[LCLRES];/* pointer to printer
//                                           configuration data                */
//
//       /*
//       ** mp1 tells what option the user selected in the printer
//       ** properties dialog box.
//       */
//       switch (LOUSHORT (mp1))
//       {
//       /*
//       ** check the appropriate printing effects check box
//       ** according to how the user defines it.
//       */
//       case CHECK_TOPBOTTOM:
//            /*
//            ** toggle the flag, then set the state of the check box.
//            */
//            pcnfData->effOutput.fIsFliptb = !pcnfData->effOutput.fIsFliptb;
//            WinSendDlgItemMsg( hWnd, CHECK_TOPBOTTOM, BM_SETCHECK, (MPARAM)
//                               pcnfData->effOutput.fIsFliptb, (MPARAM) 0L );
//            break;
//
//       case CHECK_INVERT:
//            /*
//            ** toggle the flag, then set the state of the check box.
//            */
//            pcnfData->effOutput.fIsDrawInverted =
//               !pcnfData->effOutput.fIsDrawInverted;
//            WinSendDlgItemMsg( hWnd, CHECK_INVERT, BM_SETCHECK, (MPARAM)
//                               pcnfData->effOutput.fIsDrawInverted, (MPARAM) 0L );
//            break;
//
//       case CHECK_LEFTRIGHT:
//            /*
//            ** toggle the flag, then set the state of the check box.
//            */
//            pcnfData->effOutput.fIsFliplr = !pcnfData->effOutput.fIsFliplr;
//            WinSendDlgItemMsg( hWnd, CHECK_LEFTRIGHT, BM_SETCHECK, (MPARAM)
//                               pcnfData->effOutput.fIsFliplr, (MPARAM) 0L );
//            break;
//       case RADIO_PRINTER:
//       case RADIO_RAW:
//       case RADIO_ENCAPS:
//            switch (pcnfData->iDestnType)
//            {
//            case SYSTEM:
//                 WinSendDlgItemMsg( hWnd, RADIO_PRINTER, BM_SETCHECK, (MPARAM) 0L,
//                                    (MPARAM) 0L );
//                 WinSetDlgItemText( hWnd, DSPTXT_PRINTER, (PSZ) " " );
//                 break;
//
//            case RAW:
//                 WinSendDlgItemMsg( hWnd, RADIO_RAW, BM_SETCHECK, (MPARAM) 0L,
//                                    (MPARAM) 0L );
//                 WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) " " );
//                 break;
//
//            case ENCAPS:
//                 WinSendDlgItemMsg( hWnd, RADIO_ENCAPS, BM_SETCHECK, (MPARAM) 0L,
//                                    (MPARAM) 0L );
//                 WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) " " );
//                 break;
//            }
//
//           switch (LOUSHORT (mp1))
//           {
//           case RADIO_PRINTER:
//                WinSendDlgItemMsg( hWnd, RADIO_PRINTER, BM_SETCHECK, (MPARAM) 1L,
//                                   (MPARAM) 0L );
//                pcnfData->iDestnType = SYSTEM;
//                WinEnableWindow( WinWindowFromID( hWnd, EDIT_FILE), FALSE );
//                WinEnableWindow( WinWindowFromID( hWnd, TEXT_FILE), FALSE );
//                WinSetDlgItemText( hWnd, DSPTXT_PRINTER, (PSZ) pcnfData->szSegName );
//                break;
//
//           case RADIO_RAW:
//                WinSendDlgItemMsg( hWnd, RADIO_RAW, BM_SETCHECK, (MPARAM) 1L,
//                                   (MPARAM) 0L );
//                pcnfData->iDestnType = RAW;
//                WinEnableWindow( WinWindowFromID( hWnd, EDIT_FILE), TRUE );
//                WinEnableWindow( WinWindowFromID( hWnd, TEXT_FILE), TRUE );
//                WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) pcnfData->szDestnFile );
//                break;
//
//           case RADIO_ENCAPS:
//                WinSendDlgItemMsg( hWnd, RADIO_ENCAPS, BM_SETCHECK, (MPARAM) 1L,
//                                   (MPARAM) 0L );
//                pcnfData->iDestnType = ENCAPS;
//                WinEnableWindow( WinWindowFromID( hWnd, EDIT_FILE), TRUE );
//                WinEnableWindow( WinWindowFromID( hWnd, TEXT_FILE), TRUE );
//                WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) pcnfData->szDestnFile );
//                break;
//           }
//           break;
//
//       case JPO_CB_REPDLFONTS:
//            ** Call PM to get state of check box
//            ** 0 = Unchecked, 1 = checked;
//            */
//            pcnfData->sUseDLFonts = (SHORT)WinSendDlgItemMsg( hWnd,
//                    JPO_CB_REPDLFONTS, BM_QUERYCHECK, (MPARAM) 0, (MPARAM) 0 );
//           break;
//
//       case JPO_CB_PSLVL1:
//            /*
//            ** D74609
//            ** 0 = unchecked, 1 = checked.
//            */
//            pcnfData->usPSLevel1 = (SHORT) WinSendDlgItemMsg( hWnd,
//              JPO_CB_PSLVL1, BM_QUERYCHECK, (MPARAM) 0, (MPARAM) 0 );
//            break;
//
//       /*
//       ** @V3.0GAMMA1
//       ** This message is received when the slider is modified.  SLN_CHANGE
//       ** indicates that the slider was moved.
//       */
//       case OPT_GAMMASLIDE:
//            if (SHORT2FROMMP( mp1 ) == SLN_CHANGE)
//            {
//              /*
//              ** SLM_QUERYSLIDERINFO will return a zero-based offset of the
//              ** current position of the slider from its home position.
//              ** The home position is the left end of the slide bar.
//              */
//              i = (USHORT) WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE,
//                           SLM_QUERYSLIDERINFO,
//                           MPFROM2SHORT( SMA_SLIDERARMPOSITION,
//                                         SMA_INCREMENTVALUE ),
//                           (MPARAM) 0 );
//
//              /*
//              ** Display the gamma value, based on the offset from the
//              ** slider.
//              */
//              DisplayGammaValue( hWnd, OPT_GAMMANUM, (LONG) i + 1 );
//            }
//            break;
//
//       default:
//           break;
//       }
//       break;
//
//#ifdef   YEAH_RIGHT_DUDES
//**  case WM_SYSCOMMAND:
//**       if (InternalInit(hWnd, 2, (SHORT) SHORT1FROMMP(mp1)))
//**       {
//**         return( 0L );
//**       }
//**    break;
//#endif
//
//  case HM_QUERY_KEYS_HELP :
//       return( ( ULONG )IDH_KEYS );
//
//  case WM_INITDLG:
//
//#ifdef   YEAH_RIGHT_DUDES
//**       InternalInit(hWnd, 1, 0 );     /* initialze internal                */
//#endif
//
//      apResources = (PB *) mp2;
//      pcnfData = (PCNFDATA) apResources[CNFRES];
//      pcnfLocal = (PCNFDATA) apResources[LCLRES];
//
//      /*
//      ** store this data address so that it can be retrieved elsewhere
//      */
//      if (!WinSetWindowULong( hWnd, QWL_USER, (ULONG)(PB *) apResources))
//      {
//        break;
//      }
//
//      /*
//      ** Transfer to local copy
//      */
//      *pcnfLocal = *(PCNFDATA) pcnfData;
//
//      /*
//      ** Control comes to this routine before the dialog box is loaded
//      ** so that dialog box initialisations can be carried out
//      ** Disable the menu item Close and Task_Manager
//      */
//      hWnd1 = WinWindowFromID( hWnd, FID_SYSMENU );
//      WinSendMsg( hWnd1, MM_SETITEMATTR, MPFROM2SHORT(SC_CLOSE, TRUE),
//                  MPFROM2SHORT(MIA_DISABLED, MIA_DISABLED) );
//      WinSendMsg( hWnd1, MM_SETITEMATTR, MPFROM2SHORT(SC_TASKMANAGER, TRUE),
//                  MPFROM2SHORT(MIA_DISABLED, MIA_DISABLED) );
//      OptionDialogSetup(hWnd, (PB *) apResources );
//      return 1L;                       /* to retain the window focus        */
//      break;
//
//  /*
//  ** The action as recommended by PM
//  */
//  default:
//      return( (ULONG) WinDefDlgProc( hWnd, uMsg, mp1, mp2) );
//  }
//  return 0L;
//}
//
///***************************************************************************
// *
// * FUNCTION NAME = OptionDialogSetup
// *
// * DESCRIPTION   = This routine sets up various items in the options dialog box.
// *
// * INPUT         = (hWnd,apResources)
// *
// * OUTPUT        = NONE
// *
// * RETURN-NORMAL = NONE
// *
// * RETURN-ERROR  = NONE
// *
// **************************************************************************/
//
//VOID OptionDialogSetup( HWND hWnd,  PB *apResources )
//  /* HWND hWnd;                            handle of the dialog box          */
//{
//  PCNFDATA pcnfData;                   /* pointer to printer configuration
//                                          data                              */
//  PDESPPD  pdesPpd;                    /* pointer to printer descriptor
//                                          segment                           */
//  // @V3.0GAMMA1
//  UINT     uiLoop;                     // Local loop counter
//  INT      iTick;                      // Tick mark variable for slider
//
//  /*
//  ** get pointer to configuration data and printer segment information.
//  */
//  pcnfData = (PCNFDATA) apResources[CNFRES];
//  pdesPpd = (PDESPPD) apResources[PPDRES];
//
//  /*
//  ** set the printing effects check boxes according to how they
//  ** are set in our configuration data.
//  */
//  WinSendDlgItemMsg( hWnd, CHECK_TOPBOTTOM, BM_SETCHECK, (MPARAM) (LONG)
//                     pcnfData->effOutput.fIsFliptb, (MPARAM) 0L );
//  WinSendDlgItemMsg( hWnd, CHECK_INVERT, BM_SETCHECK, (MPARAM) (LONG)
//                     pcnfData->effOutput.fIsDrawInverted, (MPARAM) 0L );
//  WinSendDlgItemMsg( hWnd, CHECK_LEFTRIGHT, BM_SETCHECK, (MPARAM) (LONG)
//                     pcnfData->effOutput.fIsFliplr, (MPARAM) 0L );
//  WinSendDlgItemMsg( hWnd, JPO_CB_REPDLFONTS, BM_SETCHECK, (MPARAM) (LONG)
//                     pcnfData->sUseDLFonts, (MPARAM) 0L );
//
//  /* D74609 */
//  if (pdesPpd->desItems.usLanguageLevel == 1)
//  {
//    WinSendDlgItemMsg( hWnd, JPO_CB_PSLVL1, BM_SETCHECK, (MPARAM) 0,
//                       (MPARAM) 0 );
//    WinEnableWindow( WinWindowFromID( hWnd, JPO_CB_PSLVL1 ), FALSE );
//  }
//  else
//  {
//    WinSendDlgItemMsg( hWnd, JPO_CB_PSLVL1, BM_SETCHECK,
//                       (MPARAM) pcnfData->usPSLevel1, (MPARAM) 0 );
//  }
//
//
//  /*
//  ** initialize the copies, job timeout and wait timeout fields from
//  ** the configuration data.
//  */
//  WinSetDlgItemShort( hWnd, EDIT_COPIES, pcnfData->iCntCopies, (BOOL)FALSE );
//  WinSetDlgItemShort( hWnd, EDIT_JOB, pcnfData->effOutput.iJobTimeout, (BOOL)
//                      FALSE );
//  WinSetDlgItemShort( hWnd, EDIT_WAIT, pcnfData->effOutput.iWaitTimeout, (BOOL)
//                      FALSE );
//
//  /*
//  ** set the maximum characters for each of these fields to 3.
//  */
//  WinSendMsg( WinWindowFromID( hWnd, EDIT_COPIES ), EM_SETTEXTLIMIT, (MPARAM) 3L,
//              (MPARAM) 0L );
//  WinSendMsg( WinWindowFromID( hWnd, EDIT_JOB ), EM_SETTEXTLIMIT, (MPARAM) 3L,
//              (MPARAM) 0L );
//  WinSendMsg( WinWindowFromID( hWnd, EDIT_WAIT ), EM_SETTEXTLIMIT, (MPARAM) 3L,
//              (MPARAM) 0L );
//
//  /*
//  ** MFR : increase file name length to maximum
//  */
//  WinSendMsg( WinWindowFromID( hWnd, EDIT_FILE ), EM_SETTEXTLIMIT, MPFROM2SHORT
//     (MAX_FNAMESIZE - 1, 0 ), (MPARAM) 0L );
//
//  /*
//  ** if mode Landscape, disable the encaps button.
//  */
//  if (pcnfData->jobProperties.iOrient == LANDSCAPE)
//  {
//    /*
//    ** Disable this particular button.
//    */
//    WinEnableWindow( WinWindowFromID( hWnd, RADIO_ENCAPS ), FALSE );
//  }
//
//  /*
//  ** set the radio buttons to OFF for RADIO_PRINTER, RADIO_RAW and
//  ** RADIO_ENCAPS.  The appropriate button will be turned on shortly.
//  */
//  WinSendDlgItemMsg( hWnd, RADIO_PRINTER, BM_SETCHECK, (MPARAM) 0L, (MPARAM) 0L );
//  WinSendDlgItemMsg( hWnd, RADIO_RAW, BM_SETCHECK, (MPARAM) 0L, (MPARAM) 0L );
//  WinSendDlgItemMsg( hWnd, RADIO_ENCAPS, BM_SETCHECK, (MPARAM) 0L, (MPARAM) 0L );
//
//  /*
//  ** depending on the destination type, system, raw, or encapsulated,
//  ** turn on the appropriate radio button, grey out any necessary items,
//  ** and set the focus on the appropriate item.
//  */
//  switch (pcnfData->iDestnType)
//  {
//  case SYSTEM:
//       /*
//       ** turn on the RADIO_PRINTER button.
//       */
//       WinSendDlgItemMsg( hWnd, RADIO_PRINTER, BM_SETCHECK, (MPARAM) 1L, (MPARAM)
//          0L );
//
//       /*
//       ** fill in the printer field.
//       */
//       WinSetDlgItemText( hWnd, DSPTXT_PRINTER, (PSZ) pcnfData->szSegName );
//
//       /*
//       ** put the cursor on the copies edit box.
//       */
//       WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_COPIES) );
//
//       /*
//       ** grey out the file edit box, and disable the text box.
//       */
//       WinEnableWindow( WinWindowFromID( hWnd, EDIT_FILE ), FALSE );
//       WinEnableWindow( WinWindowFromID( hWnd, TEXT_FILE ), FALSE );
//       break;
//
//  case RAW:
//       /*
//       ** turn on the RADIO_RAW button.
//       */
//       WinSendDlgItemMsg( hWnd, RADIO_RAW, BM_SETCHECK, (MPARAM) 1L, (MPARAM) 0L );
//
//       /*
//       ** fill in the file name, and put the cursor there.
//       */
//       WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) pcnfData->szDestnFile );
//       WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_FILE) );
//       break;
//
//  case ENCAPS:
//       /*
//       ** turn on the RADIO_ENCAPS button.
//       */
//       WinSendDlgItemMsg( hWnd, RADIO_ENCAPS, BM_SETCHECK, (MPARAM) 1L, (MPARAM)
//          0L );
//
//       /*
//       ** fill in the file name, and put the cursor there.
//       */
//       WinSetDlgItemText( hWnd, EDIT_FILE, (PSZ) pcnfData->szDestnFile );
//       WinSetFocus( HWND_DESKTOP, WinWindowFromID( hWnd, EDIT_FILE ) );
//       break;
//  }
//
//  /********************\
//  ** GAMMA CORRECTION **
//  \********************/
//  /*
//  ** @V3.0GAMMA1    START
//  */
//  /*
//  ** The loop inserts tick marks on the slider.  A major tick mark
//  ** is GC_SLIDE_MAJOR_TICK_PIXEL_LEN long and a minor tick is
//  ** GC_SLIDE_MINOR_TICK_PIXEL_LEN long.  The value that determines
//  ** which tick to use is GC_SLIDE_MAJOR_TICK_PLACE.
//  */
//  for (uiLoop = GC_SLIDE_HOME_VAL ; uiLoop <= GC_SLIDE_NUM_OF_TICKS ; uiLoop++)
//  {
//    /*
//    ** Insert a major tick if the value (modular) equals
//    ** GC_SLIDE_MAJOR_TICK_PLACE or if we're at the first tick mark
//    ** (GC_SLIDE_HOME_VAL).
//    */
//    if (uiLoop % GC_SLIDE_MAJOR_TICK_PLACE == 0 || uiLoop == GC_SLIDE_HOME_VAL)
//    {
//      iTick = GC_SLIDE_MAJOR_TICK_PIXEL_LEN;
//    }
//    else
//    {
//      iTick = GC_SLIDE_MINOR_TICK_PIXEL_LEN;
//    }
//    WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE, SLM_SETTICKSIZE,
//                       MPFROM2SHORT( uiLoop - 1, iTick ), (MPARAM) 0 );
//  }
//
//  /*
//  ** Insert the minimum, maximum, and default gamma value for the slider.
//  ** These values are hard-coded, so if the above format changes, these
//  ** values may also need to be changed.  The default gamma value is the
//  ** value where, although gamma correction is applied, the output is not
//  ** changed.
//  */
//  WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE, SLM_SETSCALETEXT,
//                     MPFROMLONG( 0 ), MPFROMP( "0.1" ) );
//  WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE, SLM_SETSCALETEXT,
//                     MPFROMLONG( 9 ), MPFROMP( "1.0" ) );
//  WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE, SLM_SETSCALETEXT,
//                     MPFROMLONG( GC_SLIDE_NUM_OF_TICKS - 1 ),
//                     MPFROMP( "5.0" ) );
//
//  /*
//  ** lGammaValue should not be 0.  If it is, it may be due to that it has
//  ** not yet been initialized.  In that case, set the default gamma value here.
//  */
//  if (pcnfData->lGammaValue == 0)
//  {
//    pcnfData->lGammaValue = NO_GAMMA;
//  }
//
//  /*
//  ** Now, its time to move the slider to the current initial value.
//  */
//  WinSendDlgItemMsg( hWnd, OPT_GAMMASLIDE, SLM_SETSLIDERINFO,
//                     MPFROM2SHORT( SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE ),
//                     MPFROMSHORT( pcnfData->lGammaValue - 1 ) );
//  /*
//  ** @V3.0GAMMA1    END
//  */
//}
//
//
//
//
//
///*
//** @V3.0GAMMA1
//*/
///******************************************************************************
// *
// * FUNCTION NAME = DisplayGammaValue
// *
// * DESCRIPTION
// * Displays a gamma value in a control field.  The gamma field contains the
// * gamma value times 10, since the GENPLIB function converts the value to
// * fraction.  The value is displayed as in decimal format.  If the variable
// * contains 1, the value is displayed as .1.  If 90 is provided, the value
// * is displayed as 9.0.  The only restriction here is that the value must
// * always be positive.
// *
// * INPUT
// * hParent - Handle of the parent to the slider.
// * ulControlID - Control ID where fixed value is to be displayed.
// * lValue - Value to be displayed in text control.
// *
// * OUTPUT
// * None.
// *
// * RETURN-NORMAL - None
// * RETURN-ERROR  - None
// *
// *****************************************************************************/
//VOID DisplayGammaValue( HWND hParent, ULONG ulControlID, LONG lValue )
//{
//  UINT uiStrLen;          // String length
//  CHAR aSVStr[ 4 ];       // Slider value string buffer
//
//  /*
//  ** For the integer value, divide by 10 and truncate the fraction.  For
//  ** the fraction, use modular divsion by 10.
//  */
//  aSVStr[ 0 ] = (CHAR) (lValue / 10) + '0';
//  aSVStr[ 1 ] = '.';
//  aSVStr[ 2 ] = (CHAR) (lValue % 10) + '0';
//  aSVStr[ 3 ] = 0;
//
//  /*
//  ** Display the value string in the control.
//  */
//  WinSetDlgItemText( hParent, ulControlID, aSVStr );
//}
///*---------------------------------------------------------------------------*\
//* DisplayGammaValue End                                                       *
//\*---------------------------------------------------------------------------*/
#endif
