/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DLG.C
 *
 * DESCRIPTIVE NAME = Dialog code.
 *
 *
 * VERSION = V3.0
 *
 * DATE      07/xx/95
 *
 * DESCRIPTION  This file contains the PostScript dialog code.
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)

#define INCL_PM
#define INCL_DEV
#define INCL_GENPLIB_ERROR
#define INCL_GENPLIB_MEMORY
#define INCL_GENPLIB_LAYOUT
#define INCL_GENPLIB_ASSERT
#define INCL_DOSSEMAPHORES
#define INCL_DOSMISC

#include <string.h>
#include <os2.h>
#include <genplib.h>
#include "inc\config.h"
#include "inc\ppdialog.h"
#include "inc\pspagtun.h"
#include "inc\dlg.h"
#include "inc\profile.h"
#include "inc\uinames.h"
#ifndef DDKBLD
  #include "inc\oem.h"
#endif

//@CONSTRAINT
typedef PSZ     *PPSZ;                          // Pointer to PSZ

/*
** MACROS to use on flags
*/
#define SETFLAG( flag, bit )   ((flag) |= (ULONG)(bit))
#define CLEARFLAG( flag, bit ) ((flag) &= ~((ULONG)(bit)))
#define CHECKFLAG( flag, bit ) ((flag) & (ULONG)(bit))
//@CONSTRAINT




/****************************************************************************\
** DEFINES START                                                            **
\****************************************************************************/
#if IPMD_DISPLAY_UI
  #define DEBUGQueryUIBlock( a, b, z )                   z = DebugQueryUIBlock( a, b )
  #define DEBUGQueryBlockName( a, b, z )                 z = DebugQueryBlockName( a, b )
  #define DEBUGQueryConstraintEntry( a, b, z )           z = DebugQueryConstraintEntry( a, b )
  #define DEBUGQueryCurrentBlockEntryName( a, b, c, z )  z = DebugQueryCurrentBlockEntryName( a, b, c )
#else
  #define DEBUGQueryUIBlock( a, b, z )
  #define DEBUGQueryBlockName( a, b, z )
  #define DEBUGQueryConstraintEntry( a, b, z )
  #define DEBUGQueryCurrentBlockEntryName( a, b, c, z )
#endif

#define STRING_ALREADY_LOADED   -1

#define SEND_CONSTRAINT_MSG      TRUE
#define IGNORE_CONSTRAINT_MSG    FALSE
/****************************************************************************\
** DEFINES END                                                              **
\****************************************************************************/





/****************************************************************************\
** TYPEDEFS START                                                           **
\****************************************************************************/
/****************************************************************************\
** TYPEDEFS END                                                             **
\****************************************************************************/





/****************************************************************************\
** FUNCTION PROTOTYPES START                                                **
\****************************************************************************/
VOID SetTabTextSize( HPS, PBYTE, UINT, PUSHORT, PUSHORT );
// LMMOORE
#if 0
BOOL InsertPageInNotebook( HAB, HPS, PGDPTMPL, PDLGHDR, UINT,
                           PUSHORT, PUSHORT, INT, UINT );
#endif
MRESULT EXPENTRY UIControlDlgProc( HWND, ULONG, MPARAM, MPARAM );
VOID ModifyInstOptConstraints( PDLGHDR );
VOID DisplayJPForms( HWND, PDLGHDR );
LONG UpdateSelection( HWND, PDLGHDR, ULONG, BOOL );
INT SetDuplexContextHelp( HWND, INT, PDLGHDR );
VOID ReadINIData( PDLGHDR );
BOOL _Optlink QueryConstraintBlock( PUIC_BLOCK, LONG, UI_SEL, LONG, UI_SEL );
BOOL _Optlink QueryCurrentConstraint( PUIC_BLOCK, LONG, UI_SEL, LONG, UI_SEL );
BOOL InitializeUIInstOpt( PDLGHDR );
UI_SEL ModifyUIInstOpt( PDLGHDR, PUI_BLOCK, PUI_BLOCK, UI_SEL );
VOID RemoveConstraints( HWND hCtrl, PDLGHDR pDlgHdr); //@CONSTRAINT

/*
** These functions are used in debugging only.
*/
#if IPMD_DISPLAY_UI
PUI_BLOCK DebugQueryUIBlock( PDLGHDR, LONG );
PSZ DebugQueryBlockName( PDLGHDR, PUI_BLOCK );
PSZ DebugQueryConstraintEntry( PDLGHDR, PUIC_ENTRY );
PSZ DebugQueryCurrentBlockEntryName( PDLGHDR, PUI_BLOCK, LONG );
#endif
/****************************************************************************\
** FUNCTION PROTOTYPES END                                                  **
\****************************************************************************/





/****************************************************************************\
** EXTERNAL DEFINITIONS START                                               **
\****************************************************************************/
extern void ListUserForms( HWND, PCNFDATA );
extern PSZ GetDefaultPageSize( PDESPPD, PBYTE );
extern UINT DisplayTranslationString( HWND, PSZ, INT );
extern SHORT szDlmCopy( PSZ, PSZ, SHORT );
extern INT  _Optlink CompareRealNames( PSZ, PSZ );
extern BOOL EXPENTRY SetHelpStubHook( VOID );
extern VOID EXPENTRY ReleaseHelpStubHook(VOID);
extern VOID EXPENTRY CleanUpHelpStubHook(SHORT);
extern INT  EXPENTRY HelpStubHook(HAB,SHORT,SHORT,SHORT,PRECTL);
extern BOOL _System szIsEqual( PSZ, PSZ );

extern BOOL HelpStubHookIsSet;
extern HWND hwndHelp;
// @V3.130814
extern BOOL HelpAlreadyInitialized;

extern VOID EA_GetVersion( PSZ );
extern VOID SaveCurrentUISelections( PDESPPD, PCNFDATA );
extern PBYTE QueryUIOptionString( PDESPPD, PUI_SEL, PBYTE, PINT, PUI_BLOCK * );
extern LONG ListJobPropFormEntries( HWND, PDLGHDR, PUI_BLOCK );

extern PEXTRA_DV SearchExtraDV( PSZ szDeviceName );
/****************************************************************************\
** EXTERNAL DEFINITIONS END                                                 **
\****************************************************************************/





/******************************************************************************
 *
 * FUNCTION NAME = InitializeDialog
 *
 * DESCRIPTION
 * Initializes the Job/Printer Properties dialog box.  Initializion includes
 * adding the dialog to the pages, setting the dialog title, and setting the
 * tab size for the dialog.
 *
 * INPUT
 * hDlg - Dialog box handle.
 * pDlgHdr - Dialog box header structure.
 * uiPropertyType - Set to either DPDM_CHANGEPROP for Printer Properties, or
 *   DPDM_POSTJOBPROP for Job Properties.
 * pDlgTemplateLst - A pointer to the dialog template list.  This dialog
 *   template contains information for each page in the dialog.
 * pOEMPrinters - Pointer to a list of OEM printers that have unique pages to
 *   insert in the dialog.
 * uiNumOfPages - Number of pages for each dialog.
 * uiOEMPages - Number of OEM pages for the dialog.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID InitializeDialog( HWND hDlg, PDLGHDR pDlgHdr, UINT uiPropertyType,
                       PGDPTMPL pDlgTemplateLst, PGDPTMPL pOEMPrinters,
                       UINT uiNumOfPages, UINT uiOEMPages,
                       ULONG ulFeaturePageNum)
{
  UINT  ofsChar;               // Offset of buffer for string append
  CHAR  aDialogTitle[ 350 ];   // Title string for JP dialog box
  CHAR  szBuffer[128];
  CHAR  szVersion[25];
  PSZ   pTempStr;
  BOOL  fInitialize;
  HAB   hAB = WinQueryAnchorBlock( hDlg );  // Anchor block handle

  /*
  ** With the DC data in hand (in the JP info structure), create a
  ** title that will be displayed in this dialog's title bar.  The
  ** format is "Job Properties - [printer name]", where [printer name]
  ** is taken from the DC buffer.
  */
  ofsChar = (UINT) WinLoadString( hAB, pscript_module, uiPropertyType, 255,
                                  aDialogTitle );
  /*
  ** Retrieve the printer name and insert it at the end of the title
  ** string.
  */
  strcpy( &aDialogTitle[ ofsChar ], pDlgHdr->pItemsBuff +
          pDlgHdr->pdesPPD->desItems.ofsPrName );

  /*
  ** append the version number to the end of the title string
  */
  EA_GetVersion( &szBuffer[0] );

//@V3.0130814
  if ((strcmp( szBuffer, NO_VERSION_NAME ) != 0) &&
      (szBuffer[0] != 0))
  {
    WinLoadString( hAB, pscript_module, DLG_VERSION,
                   sizeof (szVersion), szVersion );
    strcat( aDialogTitle, szVersion );

    pTempStr = (PSZ) szBuffer;
    while (((*pTempStr >= '0' && *pTempStr <= '9') ||
           *pTempStr == '.') && *pTempStr != 0)
    {
      pTempStr++;
    }
    *pTempStr = 0;

    strcat( aDialogTitle, szBuffer );
  }

  /*
  ** Set the titlebar color to red (Job) or blue (Printer).  Also, remove
  ** all non-used system menu items and display the title string in the
  ** titlebar.
  */
  GplPageSetDlgParams( hDlg, PS_NOTEBOOK_GROUP, uiPropertyType,
                       (PSZ) aDialogTitle );

  pDlgHdr->uiPropertyType = uiPropertyType;

#ifndef DDKBLD
  if (uiOEMPages > 0)
  {
    InitOEMData( pDlgHdr );
  }
#endif

  /*
  ** Initialize all installable options for first-time installation or for
  ** installing over an older driver.
  */
  fInitialize = InitializeUIInstOpt( pDlgHdr );

  pDlgTemplateLst[ ulFeaturePageNum ].ulDlgID =
    QueryFeaturePageLoad( pDlgHdr );

  /*
  ** Set this flag so that constraints messages are not sent while the
  ** pages are being initialized.
  */
  pDlgHdr->usFlags |= UIC_NO_UPDATE;

  pDlgHdr->hNBInstance = GplJFCreateNotebookInstance( hDlg,
                         PS_NOTEBOOK_GROUP,
                         WinWindowFromID( hDlg, PS_CONTEXTHELP ), 0,
                         pscript_module, pDlgHdr->pCNFData->szKeyApp,
                         pProcessHeap );

  pDlgHdr->usNumOfPages =
    (USHORT) GplPageInsert( hDlg, PS_NOTEBOOK_GROUP, pDlgTemplateLst,
                            (LONG) uiNumOfPages, pscript_module, pDlgHdr,
                            pDlgHdr->stPage );

  // @V3.141419
#ifndef DDKBLD
  /*
  ** Find out if there are any OEM printers . . .
  */
  if (( uiOEMPages > 0 ) && ( pDlgHdr->uiPropertyType == DPDM_POSTJOBPROP ))
  {
    pDlgHdr->usNumOfPages +=
      (USHORT) GplPageInsert( hDlg, PS_NOTEBOOK_GROUP, pOEMPrinters,
                              (LONG) uiOEMPages, pscript_module, pDlgHdr,
                              &pDlgHdr->stPage[ pDlgHdr->usNumOfPages ] );

    pDlgHdr->stPage[ pDlgHdr->usNumOfPages - 1 ].ulArg1 |= INCLUDE_OEM;

    /*
    ** Disable the color control.
    */
    WinEnableWindow( WinWindowFromID( pDlgHdr->stPage[ 2 ].hPage,
                                      JPE_COLOR_GROUP ), FALSE );
    WinEnableWindow( WinWindowFromID( pDlgHdr->stPage[ 2 ].hPage,
                                      JPE_COLOR_LIST ), FALSE );
  }
#endif

  /*
  ** For Printer Properties only (DPDM_CHANGEPROP).
  ** If initializing for the first time (fInitialize) and if the number of
  ** pages includes the "Features" page (usNumOfPages > 2) then display the
  ** "Features" page first so that the user knows to make hardware selections.
  ** The "Features" page should displayed first, only for the first time.
  */
  if (fInitialize == TRUE &&
           pDlgHdr->uiPropertyType == DPDM_CHANGEPROP &&
           pDlgHdr->usNumOfPages > 2)
  {
    WinSendDlgItemMsg( hDlg, PS_NOTEBOOK_GROUP, BKM_TURNTOPAGE,
                       (MPARAM) pDlgHdr->stPage[ 2 ].ulPageID,
                       (MPARAM) 0 );
  }

  pDlgHdr->usFlags &= ~UIC_NO_UPDATE;

  /*
  ** Initialize help dummy hook - avoid doing WinCreateHelpInstance
  ** until the user presses F1, clicks on a help button or uses our
  ** help menu...
  */
  if (HelpStubHookIsSet == FALSE)
  {
    SetHelpStubHook( );
  }
}
/*---------------------------------------------------------------------------*\
* InitializeDialog End                                                       *
\*---------------------------------------------------------------------------*/




/******************************************************************************
 *
 * FUNCTION NAME = InitializeDialogHeader
 *
 * DESCRIPTION
 * Initializes the Dialog header structure.  This structure (defined in
 * PPDLG.H) contains information needed for the display of the Printer/
 * Job Properties dialog box.
 *
 * INPUT
 * hDlg - Dialog box handle.
 * mp - Parameter passed in to the Job/Printer Properties dialog procedure as
 *   mp2.
 * iNumOfPages - Number of pages to be inserted in the dialog box.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - PDLGHDR with all fields initialized.
 * RETURN-ERROR  - NULL
 *
 *****************************************************************************/
PDLGHDR InitializeDialogHeader( HWND hDlg, MPARAM mp, INT iNumOfPages )
{
  PUI_SEL   pUISelList;                     // Pointer to UI selection list
  PB       *apResources;                    // Poiner to printer resources
  UINT      uiBufferSize;                   // Size of dialog header buffer
  PUI_BLOCK pTrayBlock;                     // Tray block pointer
  PDLGHDR   pDlgHdr;                        // Dialog header structure
  BOOL      fINI;                           // INI return code
  BOOL      fAllocSucceed = FALSE;          // Buffer allocation flag

  /*
  ** Query the size of the DLGHDR buffer.
  */
  uiBufferSize = sizeof( DLGHDR ) + (sizeof( GDPPI ) * iNumOfPages);

  /*
  ** For now, allocate a new page.  It seems that GplMemoryAlloc does not
  ** return the amount of memory requested.
  ** Replace (HMCB) 0 with pProcessHeap.
  */
  if ((pDlgHdr = (PDLGHDR) GplMemoryAlloc( (HMCB) pProcessHeap, uiBufferSize ))
      != NULL)
  {
    /*
    ** Set the user-defined reserved doubleword with the dialog header
    ** buffer.
    */
    WinSetWindowULong( hDlg, QWL_USER, (ULONG) pDlgHdr );

    /*
    ** Set general data.
    */
    apResources         = (PB *) mp;
    pDlgHdr->hDlg       = hDlg;
    pDlgHdr->pCNFData   = (PCNFDATA) apResources[ CNFRES ];
    pDlgHdr->pdesPPD    = (PDESPPD) apResources[ PPDRES ];
    pDlgHdr->pItemsBuff = (PCHAR) pDlgHdr->pdesPPD->pPSStringBuff;
    pDlgHdr->pExtraDV   = SearchExtraDV( pDlgHdr->pCNFData->szPrtName );

    /*
    ** Allocate memory for the UI Selection List.  The UI selection list
    ** is a buffer that contains the current UI selected data that exists
    ** for the length of the dialog box.  The data is copied from the CNFDATA
    ** and is copied back if SAVE is selected.
    */
    if ((pDlgHdr->pCurrUISelList = (PULONG) GplMemoryAlloc( pProcessHeap,
         pDlgHdr->pCNFData->stUISelList.usCurrUIListSize )) != NULL)
    {
      pUISelList = ASSIGN_UISELLIST_PTR( pDlgHdr->pCNFData );
      utl_memcopy( (PBYTE) pDlgHdr->pCurrUISelList, (PBYTE) pUISelList,
                   pDlgHdr->pCNFData->stUISelList.usCurrUIListSize );
    }
    else
    {
      goto alloc_failed;
    }

    /*
    ** Allocate memory for the context-sensitive help buffer.
    */
    if ((pDlgHdr->pCHBuffer = (PSZ) GplMemoryAlloc( pProcessHeap,
                                                    CHBUFF_SIZE + 1 )) == NULL)
    {
      goto alloc_failed;
    }

    LoadUserForms( pDlgHdr );

    /*
    ** The selected forms flag indicates if only mapped forms is to be
    ** displayed for Job Properties or not.
    */
    if (ReadPrtPropOptionsINI( pDlgHdr->pCNFData->szKeyApp,
                               INISUBKEY_DISPFORMS, &fINI ) == FALSE)
    {
      /*
      ** The INI does not exist, so set the appropriate flag.
      */
      pDlgHdr->usFlags |= NO_INI_EXISTS;
    }

    if (fINI == TRUE)
    {
      pDlgHdr->usFlags |= DISP_SEL_FORMS;
    }
    else
    {
      pDlgHdr->usFlags &= ~DISP_SEL_FORMS;
    }

    /*
    ** Read the boolean value that determines if forms mismatch should be
    ** overridden or not.
    */
    ReadPrtPropOptionsINI( pDlgHdr->pCNFData->szKeyApp, INISUBKEY_OVERRIDEMM,
                           &fINI );

    if (fINI == TRUE)
    {
      pDlgHdr->usFlags |= OVERRIDE_MM;
    }
    else
    {
      pDlgHdr->usFlags &= ~OVERRIDE_MM;
    }

    fAllocSucceed = TRUE;
  }

alloc_failed:

  /*
  ** If the allocation failed, free any remaining data.
  */
  if (fAllocSucceed != TRUE)
  {
    FreeDialogHeader( pDlgHdr );
    pDlgHdr = NULL;
  }

  return( pDlgHdr );
}
/*---------------------------------------------------------------------------*\
* InitializeDialogHeader End                                                 *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = FreeDialogHeader
 *
 * DESCRIPTION
 * Frees the buffer allocated for the dialog header and frees any pointers
 * within the dialog header that were allocated.  This includes the UI
 * selection list buffer.
 *
 * INPUT
 * pDlgHdr - Dialog header pointer.
 *
 * OUTPUT
 *
 * RETURN-NORMAL - TRUE
 * RETURN-ERROR  - FALSE
 *
 *****************************************************************************/
VOID FreeDialogHeader( PDLGHDR pDlgHdr )
{
  if (pDlgHdr != NULL)
  {
    if (pDlgHdr->pCHBuffer != NULL)
    {
      GplMemoryFree( pDlgHdr->pCHBuffer );
      pDlgHdr->pCHBuffer = NULL;
    }

    /*
    ** Free the UI Selection List Buffer.
    */
    if (pDlgHdr->pCurrUISelList != NULL)
    {
      GplMemoryFree( pDlgHdr->pCurrUISelList );
      pDlgHdr->pCurrUISelList = NULL;
    }

    if (pDlgHdr->pPtr != NULL)
    {
      GplMemoryFree( pDlgHdr->pPtr );
      pDlgHdr->pPtr = NULL;
    }

    /*
    ** Free the dialog header.
    */
    GplMemoryFree( pDlgHdr );
  }
}
/*---------------------------------------------------------------------------*\
* FreeDialogHeader End                                                       *
\*---------------------------------------------------------------------------*/





VOID ReadINIData( PDLGHDR pDlgHdr )
{
  PUI_BLOCK pFormBlock;
  BOOL      fINI;
  LONG      lLoop;
  INT       ofsFormEntry;
  LONG      lUnqLoop;
  PTMENTRY  pTMEntry = (PTMENTRY) pDlgHdr->pPtr;
  PSOURCE   pSource = pDlgHdr->pCNFData->u.iv.pSourcePaper;
  PUNQFRM   pUniqueForm = pDlgHdr->stUnqFrmLst;

  for (lLoop = 0 ; lLoop < (LONG) pDlgHdr->usNumTMEntries ; lLoop++)
  {
    (pTMEntry++)->lFormID = NOFORMS_HANDLE;
  }

  pFormBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                      pDlgHdr->pItemsBuff, UINAME_PAGESIZE,
                                      NULL );

  pTMEntry = (PTMENTRY) pDlgHdr->pPtr;
  for (lLoop = 0 ; lLoop < (LONG) pDlgHdr->usNumTMEntries ; lLoop++)
  {
    if (pSource->szPaperName[ lLoop ][ 0 ] != 0)
    {
      if (QueryEntryFromOption( pDlgHdr->pItemsBuff, pFormBlock,
                                pSource->szPaperName[ lLoop ], &ofsFormEntry )
          != NULL)
      {
        pTMEntry->lFormID = (LONG) ofsFormEntry;
      }
      else
      {
        for (lUnqLoop = 0 ; lUnqLoop < NUM_OF_UNQ_FORMS ; lUnqLoop++)
        {
          if (!strcmp( pUniqueForm[ lUnqLoop ].aFormName,
                       pSource->szPaperName[ lLoop ] ))
          {
            pTMEntry->lFormID = (LONG) CONV_UNQID_TO_LBID( lUnqLoop );
          }
        }
      }
    }
    pTMEntry++;
  }
}





/******************************************************************************
 *
 * FUNCTION NAME = DisplayMessageBox
 *
 * DESCRIPTION
 * Displays a message box using WinMessageBox().  This function also retrieves
 * a title string and a message string from the string table, providing that
 * a non-zero title string ID is provided.  If the title string ID is zero,
 * this indicates an error.  In this case, a string is retrieved from a
 * message table and a NULL title ID is passed in, which displays "Error" in
 * the message box.
 *
 * INPUT
 * hDlg - Dialog handle.  If this is 0, then HWND_DESKTOP is used.
 * iMessageID - Non-zero message id.
 * iTitleID - Title string ID.  If 0, then the default title is used.
 * uiFlags - Flags that are passed in to WinMessageBox() as message box flags.
 *   Use the MB_... flags as used for WinMessageBox().
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Same return code from WinMessageBox().
 * RETURN-ERROR  - Same return code from WinMessageBox().
 *
 *****************************************************************************/
INT DisplayMessageBox( HWND hDlg, INT iMessageID, INT iTitleID, UINT uiFlags )
{
         #define MAX_MSG_STR_SIZE  255
  CHAR   aMessageString[ MAX_MSG_STR_SIZE ];   // Message string buffer
  HMQ    hMQ;
  MQINFO mQinfo;
  CHAR   aTitleString[ MAX_PSIZE ];            // Title string buffer
  PSZ    pTitleString;                         // Pointer to the title string
  HAB    hAB;                                  // Anchor block handle
  INT    iRC;                                  // Function/message return code

  if (hDlg == (HWND) 0)
  {
    hDlg = HWND_DESKTOP;
  }

  /*
  ** Make sure we have a message queue.
  */
  if ( WinQueryQueueInfo( HMQ_CURRENT, &mQinfo, sizeof( MQINFO ) ) == FALSE )
  {
    if ( (hAB = WinInitialize( 0 )) != NULL )
    {
       hMQ = WinCreateMsgQueue( hAB, 0 );
       WinCancelShutdown( hMQ, TRUE );
    }
  }
  else
  {
    hAB = WinQueryAnchorBlock( hDlg );    // Anchor block handle
  }

  DosBeep( 1200, 80 );
  DosBeep( 700, 80 );

  /*
  ** If a title ID is provided, then load a string from the string table.
  ** If a title ID is not provided, then it is an error, so load a string
  ** from the message table.
  */
  if (iTitleID != 0)
  {
    pTitleString = (PSZ) aTitleString;
    WinLoadString( hAB, pscript_module, iTitleID, MAX_PSIZE, pTitleString );

    WinLoadString( hAB, pscript_module, iMessageID, MAX_MSG_STR_SIZE,
                   (PSZ) aMessageString );
  }
  else
  {
    pTitleString = NULL;
    WinLoadMessage( hAB, pscript_module, iMessageID, MAX_PSIZE,
                    (PSZ) aMessageString );
  }

  /*
  ** Display the message box.
  */
  iRC = (INT) WinMessageBox( HWND_DESKTOP, hDlg, aMessageString,
                             pTitleString, 0, uiFlags );

  /*
  ** If we needed to create a msg queue then remove it
  */
  if ( hAB )
  {
    WinDestroyMsgQueue (hMQ) ;
    WinTerminate (hAB) ;
  }

  return( iRC );
}
/*---------------------------------------------------------------------------*\
* DisplayMessageBox End                                                      *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = VerifyAndSaveSettings
 *
 * DESCRIPTION
 * This sends two messages to each non-OEM page of the Properties dialog box:
 * - WMPS_VERIFYSETTINGS - Requests each page to return a code, verifying if
 *   they have valid data or not:
 *   - PSDRC_VERIFY_SUCCESS - Returned by each page, indicating that the data
 *     is valid.
 *   - Other - Data is not valid.
 * If all pages return SUCCESS, then this function sends WMPS_SAVESETTINGS to
 * each page, indicating that each page should save its settings.  If a page
 * successfully saved its data, then it returns PSDRC_SAVE_SUCCESS.  For a
 * failure, any other value is returned.
 *
 * INPUT
 * pDlgHdr - Dialog box header structure.
 * uiNumOfPages - Number of pages for the current dialog box.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - PMERR_OK
 * RETURN-ERROR  - Any other value
 *
 *****************************************************************************/
LONG VerifyAndSaveSettings( PDLGHDR pDlgHdr )
{
  PBYTE  pDest = (PBYTE) ASSIGN_UISELLIST_PTR( pDlgHdr->pCNFData );

  /*
  ** If all is OK, then we need to transfer the UI data from the temporary
  ** buffer to the permanent buffer.  It is done here because, although the
  ** UI data is normally found on the "Features" page, other UI data can
  ** be modified on other pages (like "MediaType" for the "Forms" page).
  ** Therefore, modify the data here.
  */
  if (pDlgHdr->uiPropertyType == DPDM_CHANGEPROP)
  {
    ModifyInstOptConstraints( pDlgHdr );
  }

  /*
  ** Copy the temporary UI current selections into the the permant
  ** array.
  */
  utl_memcopy( pDest, (PBYTE) pDlgHdr->pCurrUISelList,
               pDlgHdr->pCNFData->stUISelList.usCurrUIListSize );

  if (pDlgHdr->uiPropertyType == DPDM_CHANGEPROP)
  {
    SaveCurrentUISelections( pDlgHdr->pdesPPD, pDlgHdr->pCNFData );
  }

  return( PMERR_OK );
}
/*---------------------------------------------------------------------------*\
* VerifyAndSaveSettings End                                                   *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = ClosePSDlg
 *
 * DESCRIPTION
 * This handles the termination of a Priner/Job Properties dialog box.  This
 * includes terminating help and dismissing the dialog box.
 *
 * INPUT
 * hDlg - Dialog box handle.
 * pDlgHdr - Dialog box header structure.
 * bExitCode - Exit code that is used as the second parameter for
 *   WinDismissDlg().
 * sHandle - Handle to be given to the string.
 * sInsertIndex - Zero-based offset where the string is to be inserted.  This
 *   may contain one of the LIT_... arguments that are used in inserting data
 *   into a listbox.  This arugment is passed into a WinSendMsg() as mp1 when
 *   inserting a string into a listbox.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - Listbox index where the string was inserted.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID ClosePSDlg( HWND hDlg, PDLGHDR pDlgHdr, BOOL bExitCode )
{
  LONG lLoop;

  if (pDlgHdr->hNBInstance == 0 ||
      GplJFDestroyNotebookInstance( pDlgHdr->hNBInstance ) == PMERR_OK)
  {
    for (lLoop = 0 ; lLoop < (LONG) pDlgHdr->usNumOfPages ; lLoop++)
    {
      GplPageRemove( pDlgHdr->stPage[ lLoop ].hPage );
    }

    /*
    ** if we have a help instance destroy it.  DCR 1476
    */
    WinAssociateHelpInstance( (HWND) NULL,
                              WinQueryActiveWindow( HWND_DESKTOP ));

    ReleaseHelpStubHook( );   /* Release hook */
    if (HelpAlreadyInitialized)
    {
      WinDestroyHelpInstance( hwndHelp );
      hwndHelp = (HWND) NULL;
      HelpAlreadyInitialized = FALSE;
    }

    FreeDialogHeader( pDlgHdr );

    WinDismissDlg( hDlg, bExitCode );
  }
}
/*---------------------------------------------------------------------------*\
* ClosePSDlg End                                                              *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = DisplayFeaturesUIEntries
 *
 * DESCRIPTION
 * With a given UI selection, displays a drop down listbox if the current UI
 * is a single-selection UI, and displays a dialog box for a multiple-selected
 * UI.  The selections for the highlighted UI are displayed in the relavent
 * listbox.  The selection text (displayed below the selection listbox) is
 * updated to display instructions on how the listbox can be selected.
 * This function is used for the "Features" page only.
 *
 * INPUT
 * hDlg - Job Properties dialog box handle.
 * uiListIndex - Zero-based offset of the highlighed UI in the options
 *   listbox.  This can be any value if pOptionName is NULL.
 * pDlgHdr - Properties header structure.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID DisplayFeaturesUIEntries( HWND hDlg, PUI_BLOCK pUIBlock, PDLGHDR pDlgHdr )
{
  HWND  hPickOneCtrl;    // Win handle for single sel listbox
  HWND  hPickManyCtrl;   // Win handle for multiple sel listbox
  HWND  hDisplayCtrl;    // Win handle for control to be displayed
  CHAR  aString[ 255 ];  // Buffer to store various text
  UINT  uiLoop;          // Loop counter
  UINT  uiCurrSel;       // Current user selected UI entries
  INT   iCtrlID;         // Control ID
  PCHAR pBuffer;         // Local buffer pointer

  /*
  ** Retrieve window handles for both controls.
  */
  hPickOneCtrl = WinWindowFromID( hDlg, JPUI_PICKONE );
  hPickManyCtrl = WinWindowFromID( hDlg, JPUI_PICKMANY );

  /*
  ** Hide all controls.
  */
  WinShowWindow( hPickOneCtrl, FALSE );
  WinShowWindow( hPickManyCtrl, FALSE );

  /*
  ** Determine which control is to be displayed and which one is to be
  ** hidden.
  */
  switch( pUIBlock->usSelectType )
  {
  case UI_SELECT_PICKMANY:
       hDisplayCtrl = hPickManyCtrl;
       iCtrlID = JPUI_PICKMANY;
       break;

  default:
       hDisplayCtrl = hPickOneCtrl;
       iCtrlID = JPUI_PICKONE;
  }

  /*
  ** Display the appropriate control.
  */
  WinShowWindow( hDisplayCtrl, TRUE );

  /*
  ** List all available entries in the control.
  */
  InitializeUIControl( hDlg, pDlgHdr, pDlgHdr->pItemsBuff +
                       pUIBlock->ofsUIName, iCtrlID, 0 );
}
/*---------------------------------------------------------------------------*\
* DisplayFeaturesUIEntries End                                                *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = UpdateIcon
 *
 * DESCRIPTION
 * Updates (redraws) an icon control.  If an icon ID is provided, the function
 * redraws the icon control with the given icon and stores that icon ID in the
 * icon control's reserved doubleword (QWL_USER).  If an icon ID is *NOT*
 * provided (0) (which usually happens during a WM_PAINT), the ID is retrieved
 * from the reserved doubleword and that ID is used to query the icon, which
 * is then redrawn.
 *
 * This icon works for both the icons in a page as well as the icons in the
 * Status Bar.  Two window handles are provided:
 *
 * - The page handle (hPageDlg).
 * - The dialog handle (hDlg).
 *
 * If either of the above handles is 0, then the icon control that corresponds
 * to that handle is not affected.  For example, if hDlg is 0, then the icons
 * for the Status Bar are not updated.
 *
 * Each icon control contains a reserved doubleword.  For example, the
 * orientation icon in both the Status Bar and the FORMS page each has a
 * reserved doubleword containing the same icon ID.
 *
 * INPUT
 * hPageDlg - Page dialog handle.  If this is 0, then no icon controls in any
 *   pages are updated.
 * hDlg - Dialog handle.  This handle is for the Status Bar.  If this is 0,
 *   no icons in the Status Bar are updated.
 * iCtrlID - Icon control ID found within the page/Status Bar.  This is *NOT*
 *   the icon ID (found in the RC file).  If this is 0, nothing is updated.
 * iIconID - Icon ID, found in the RC file.  If this is 0, then the icon ID
 *   that is in the reserved doubleword is used as the ID.  This is the ID to
 *   the icon that is to be displayed.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 * RESTRICTION
 * If an icon is to be displayed in BOTH the Status Bar and in an icon control
 * for a given page (i.e. the Orientation icon in the FORMS page), then the
 * icon control ID *MUST* match in the Status Bar as well as the page icon
 * control.  For example, the icon control ID for the Orientation icon for
 * both the Status Bar and in the FORMS page is JPSB_ORIENTATION.  If they
 * are not the same, then only one icon will be updated.
 * However, this function can be used to update an icon for the page or
 * Status Bar only.  Simply provide the correct page/dialog ID and the control
 * ID.
 *
 *****************************************************************************/
VOID UpdateIcon( HWND hPageDlg, HWND hDlg, INT iCtrlID, INT iIconID )
{
  /*
  ** Updte the icon for the page, if provided.
  */
  if (hPageDlg != 0)
  {
    ChangeIconContents( hPageDlg, iCtrlID, iIconID );
  }

  /*
  ** Update the icon for the Status bar, if provided.
  */
  if (hDlg != 0)
  {
    ChangeIconContents( hDlg, iCtrlID, iIconID );
  }
}
/*---------------------------------------------------------------------------*\
* UpdateIcon End                                                              *
\*---------------------------------------------------------------------------*/






/******************************************************************************
 *
 * FUNCTION NAME = ChangeIconContents
 *
 * DESCRIPTION
 * Updates (redraws) an icon control.  If an icon ID is provided, the function
 * redraws the icon control with the given icon and stores that icon ID in the
 * icon control's reserved doubleword (QWL_USER).  If an icon ID is *NOT*
 * provided (0) (which usually happens during a WM_PAINT), the ID is retrieved
 * from the reserved doubleword and that ID is used to query the icon, which
 * is then redrawn.
 *
 * This function queries the rectangle for the icon control, redraws the icon
 * control to the dialog's color, loads an icon, then redraws the control with
 * the given icon.
 *
 * INPUT
 * hDlg - Dialog handle.
 * iCtrlID - Icon control ID found within the page/Status Bar.  This is *NOT*
 *   the icon ID (found in the RC file).  If this is 0, nothing is updated.
 * iIconID - Icon ID, found in the RC file.  If this is 0, then the icon ID
 *   that is in the reserved doubleword is used as the ID.  This is the ID to
 *   the icon that is to be displayed.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - None
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
VOID ChangeIconContents( HWND hDlg, INT iCtrlID, INT iIconID )
{
  RECTL    rectl;               // Rectangle structure
  HPS      hPS;                 // PS handle
  HPOINTER hIcon;               // Icon contents handle
  HWND     hIconFrame = WinWindowFromID( hDlg, iCtrlID );  // Icon frame hndl

  hPS = WinGetPS( hIconFrame );

  /*
  ** If an icon ID is provided, store that ID as a reserved window doubleword.
  ** If an icon ID is not provided, then it usually means that a WM_PAINT was
  ** sent, so query for the ID.  This ID will load the pointer, which will
  ** re-draw the icon.
  */
  if (iIconID != 0)
  {
    WinSetWindowULong( hIconFrame, QWL_USER, (ULONG) iIconID );

    /*
    ** Query the window rectangle for the icon window.
    */
    WinQueryWindowRect( hIconFrame, &rectl );

    /*
    ** Paint the PS with the dialog background color.  Otherwise, the new
    ** icon will look like it is plastered above the old one.
    */
    WinFillRect( hPS, &rectl, SYSCLR_DIALOGBACKGROUND );
  }
  else
  {
    iIconID = (INT) WinQueryWindowULong( hIconFrame, QWL_USER );
  }

  /*
  ** Load the pointer.
  */
  hIcon = WinLoadPointer( HWND_DESKTOP, pscript_module, iIconID );

  /*
  ** By setting a new handle, the new pointer will be drawn.
  */
  WinSendMsg( hIconFrame, SM_SETHANDLE, MPFROMLONG( hIcon ), (MPARAM) 0 );

  WinDestroyPointer( hIcon );

  WinReleasePS( hPS );
}
/*---------------------------------------------------------------------------*\
* ChangeIconContents End                                                      *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = InitializeUIControl
 *
 * DESCRIPTION
 * Initializes a combo or list box as a UI control.  A UI control is a control
 * that allows selections from a UI Block provied by a PPD.
 *
 * The initialization includes:
 * - Enabling a control and (optionally) a matching dialog text.
 * - Transferring procedure control to a procedure called UIControlDlgProc().
 *   This procedure will handle all messages sent to a UI control.
 * - Sends an initialization message to UIControlDlgProc().
 *
 * INPUT
 * hParent - Dialog page handle.
 * pDlgHdr - Dialog header structure.
 * pUIKeyword - UI keyword.  This is the keyword that is searched in the UI
 *   list to find the specific block.
 * lCtrlID - ID of the control as it is found in CONFIG.DLG.  This ID is used
 *   to subclass the control to UIControlDlgProc() and enables the control.
 * lTextCtrl - Other text/control that is to be enabled.  If no other control
 *   is to be enabled, this should be set to 0.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - Pointer to the UI block.
 * RETURN-ERROR  - NULL
 *
 *****************************************************************************/
PUI_BLOCK InitializeUIControl( HWND hParent, PDLGHDR pDlgHdr, PSZ pUIKeyword,
                               LONG lCtrlID, LONG lTextCtrl )
{
  INT       ofsBlock;                        // Block offset
  HWND      hCtrl;                           // UI control handle
  PUI_BLOCK pUIBlock = NULL;                 // Block pointer

  /*
  ** With a given UI keyword, query the block data.
  */
  if ((pUIBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                         pDlgHdr->pItemsBuff, pUIKeyword,
                                         &ofsBlock )) != NULL)
  {
    if ((hCtrl = WinWindowFromID( hParent, lCtrlID )) != (HWND) 0)
    {
      /*
      ** Enable the window and matching text (if provided).
      ** Also, clear out the listbox.
      */
      WinEnableWindow( hCtrl, TRUE );
      WinEnableWindow( WinWindowFromID( hParent, lTextCtrl ), TRUE );

      if (WinSubclassWindow( hCtrl, (PFNWP) UIControlDlgProc ) != (PFNWP) 0)
      {
         WinSendMsg( hCtrl, UCM_INITIALIZE, (MPARAM) pUIBlock,
                     (MPARAM) lCtrlID );
      }
    }
    else
    {
      pUIBlock = NULL;
    }
  }

  return( pUIBlock );
}
/*---------------------------------------------------------------------------*\
* InitializeUIControl End                                                     *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = UIControlDlgProc
 *
 * DESCRIPTION
 * This is the procedure for processing all messages for all UI controls,
 * whether they are standard window or "UCM_" messages.
 *
 * UCM messages:
 * - UCM_INITIALIZE - Initializes the UI control:
 *   - Sets the control's doubleword to the address of the respective UI block.
 *   - Sends a UCM_LISTITEMS message.
 * - UCM_LISTITEMS - List all UI entries in the control.
 * - UCM_MODIFYHANDLE - All reserved doublewords for all controls is the
 *   address of the respective UI block.  This allows the handle to be changed
 *   to another value.
 * - UCM_SETDEFAULT - Sets the control to the default entry.
 * - UCM_UNDO - Resets control to the original selection when dialog box was
 *   first brought up.
 *
 * INPUT
 * hDlg - Dialog handle
 * ulMsg - Message ID
 * mp1, mp2 - General message parameters.  mp2 contains the DC structure
 *  passed in from the driver.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE
 *                 FALSE
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
MRESULT EXPENTRY UIControlDlgProc( HWND hCtrl, ULONG ulMsg, MPARAM mp1,
                                   MPARAM mp2 )
{
  PUI_BLOCK pUIBlock;                  // Current block pointer
  PDLGHDR   pDlgHdr;                   // Dialog header
  INT       iIndex;                    // Loop counter
  PSZ       pDefString;                // Default string
  PSZ       pString;                   // String to be displayed
  SHORT     sItemIndex;                // Index of item inserted
  INT       iNumOfItems;               // Num of items in listbox
  PUI_SEL   pUISelection;              // Current UI Selection(s)
  ULONG     ulCtrlID;                  // Control ID
  UI_SEL    uiNewSelect = (UI_SEL) 0;  // If not 0, then update selection
  BOOL      fItemSelected = FALSE;     // TRUE if item is selected
  MRESULT   mRC = (MRESULT) FALSE;     // Function return code
  LONG      lIndex;
  
  /*
  ** The parent of the control is the page dialog.  The reserved
  ** doubleword for the page dialog is the dialog header.
  */
  pDlgHdr = (PDLGHDR) WinQueryWindowULong( WinQueryWindow( hCtrl,
                                                           QW_PARENT ),
                                           QWL_USER );

  switch( ulMsg )
  {
  /*
  ** This message is sent by InitializeUIControl().  The doubleword stored
  ** is the address of the current UI block.
  ** Don't send a message, post it instead to let all other previous messages
  ** run their course.
  */
  case UCM_INITIALIZE:
       pUIBlock = (PUI_BLOCK) MPFROMP( mp1 );

       switch ((ULONG) mp2)
       {
       /*
       ** The Printer Properties tray list needs a buffer to store the matching
       ** form.  Allocate that buffer now.  The buffer will be freed in
       ** FreeDialogHeader().
       */
       case PPF_TRAYLIST:
            /*
            ** Query the size needed for the buffer.
            */
            pDlgHdr->usNumTMEntries = pUIBlock->usNumOfEntries;
            iIndex = sizeof( TMENTRY ) * pDlgHdr->usNumTMEntries;
            if ((pDlgHdr->pPtr = (PVOID) GplMemoryAlloc( (HMCB) pProcessHeap,
                                                         iIndex )) != NULL)
            {
              ReadINIData( pDlgHdr );
            }
            else
            {
              pDlgHdr->pPtr = NULL;
              PMAssert( -1, (HAB) 0,
                        "Memory for Prt. Properties tray list failed.\n" );
            }

            *(pDlgHdr->pCurrUISelList + pUIBlock->usOrderDep) =
              CONVERT_OFS_TO_UISEL( pUIBlock->usDefaultEntry );
            break;

       /*
       ** For Job Properties trays, we do not rely on the trays for Constraints
       ** so erase all tray selections.
       */
       case JPF_TRAYNAMELIST:
       case JPF_TRAYNAMELIST_1:                                   // @MIXED_FEED
            *(pDlgHdr->pCurrUISelList + pUIBlock->usOrderDep) = 0;
            break;
       }

       WinSetWindowULong( hCtrl, QWL_USER, (ULONG) pUIBlock );
       WinSendMsg( hCtrl, UCM_LISTITEMS, (MPARAM) 0, (MPARAM) 0 );
       break;

  case UCM_LISTITEMS:
       pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );

       /*
       ** The doubleword for the control is the UI block pointer.
       */
       if (pUIBlock != NULL)
       {
         switch (WinQueryWindowUShort( hCtrl, QWS_ID ))
         {
         case JPF_FORMNAMELIST:
         case JPF_FORMNAMELIST_1:                                 // @MIXED_FEED
              ListJobPropFormEntries( hCtrl, pDlgHdr, pUIBlock );
              break;

         case JPF_TRAYNAMELIST:
         case JPF_TRAYNAMELIST_1:                                 // @MIXED_FEED
              /*
              ** mp1 is required to list the forms.  mp1 -> form UI block.
              */
              if (mp1 != NULL)
              {
                ListJobPropTrayEntries( hCtrl, pDlgHdr, pUIBlock, (HWND) mp1,
                                        (LONG) mp2 );
              }
              break;

         case PPF_FORMLIST:
              /*
              ** mp1 is required to list the forms.  mp1 -> tray UI block.
              */
              if (mp1 != NULL)
              {
                ListPrtPropFormEntries( hCtrl, pDlgHdr, pUIBlock,
                                        (PUI_BLOCK) mp1, (LONG) mp2 );
              }
              break;

         case PPF_TRAYLIST:
              /*
              ** The reason     we don't want to highlight the current tray
              ** in ListUIItems is that if it is done in the function, then
              ** right after the highlight, the message to list all forms is
              ** sent.  Rather, we want to list all trays first, then
              ** highlight.  This is to prevent the form UI_SEL bit from being
              ** set and, possibly, apply constraints against the tray.  The
              ** only constraints that should be applied against the tray are
              ** the installable options.
              */
              ListUIItems( hCtrl, pDlgHdr, pUIBlock, FALSE,
                           QUERY_INST_OPT_GROUP, BLOCK_SEARCH_ALL,
                           DO_NOT_OVERWRITE);

              // Select the default tray.
              GplPageSelectListItem( hCtrl, 0,
                                     (ULONG) pUIBlock->usDefaultEntry,
                                     GDPI_HANDLE );
              break;

         default:
              ListUIItems( hCtrl, pDlgHdr, pUIBlock, TRUE,
                           QUERY_ALL_GROUPS, BLOCK_SEARCH_ALL,
                           DO_NOT_OVERWRITE );
         }
       }
       break;

  case UCM_QUERYSELECTION:
       pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );
       iIndex = (INT) WinSendMsg( hCtrl, LM_QUERYSELECTION,
                                  MPFROMLONG( LIT_FIRST ), (MPARAM) 0 );
       iIndex = (INT) WinSendMsg( hCtrl, LM_QUERYITEMHANDLE,
                                  MPFROMLONG( iIndex ), (MPARAM) 0 );
       mRC = (MRESULT) iIndex;
       break;

  case UCM_MODIFYHANDLE:
       pUIBlock = (PUI_BLOCK) MPFROMP( mp1 );
       WinSetWindowULong( hCtrl, QWL_USER, (ULONG) pUIBlock );
       break;

  case UCM_SETDEFAULT:
       pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );
       iIndex = (INT) WinQueryWindowUShort( hCtrl, QWS_ID );

       /*
       ** @V4.0168335
       ** For countries with A4 default page size, do not get the default
       ** from the PPD, but from GetDefaultPageSize().
       ** Do not use PPF_FORMLIST since that is affected directly from
       ** the tray list (PPF_TRAYLIST).
       */
       switch (iIndex)
       {
       case JPF_FORMNAMELIST:
       case JPF_FORMNAMELIST_1:                                   // @MIXED_FEED
            pDefString = GetDefaultPageSize( pDlgHdr->pdesPPD,
                                             pDlgHdr->pItemsBuff );

            QueryEntryFromOption( pDlgHdr->pItemsBuff, pUIBlock,
                                  (PBYTE) pDefString, &iIndex );
            break;

       default:
            iIndex = (INT) pUIBlock->usDefaultEntry;
       }

       uiNewSelect = 1 << iIndex;
       break;

  case UCM_UNDO:
       pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );
       pUISelection = (PUI_SEL) (ASSIGN_UISELLIST_PTR( pDlgHdr->pCNFData ) +
                                 pUIBlock->usOrderDep);
       uiNewSelect = *pUISelection;
       break;

  case WM_CONTROL:
       iIndex = -1;
       ulCtrlID = (ULONG) WinQueryWindowUShort( hCtrl, QWS_ID );
       pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );

       /*
       ** We want to apply constraints *AFTER* the item has been selected
       ** and the listbox portion of the combo box was closed.  Otherwise,
       ** after the selection is made, the listbox will appear 'frozen'
       ** while the constraints are being applied, and then close.
       ** CBN_LBSELECT indicates that an item was selected and CBID_EDIT
       ** applies to the entry field portion of the combo box.
       */
       if (SHORT2FROMMP( mp1 ) == CBN_LBSELECT &&
           SHORT1FROMMP( mp1 ) == CBID_EDIT )
       {
         switch( ulCtrlID )
         {
         case PPF_TRAYLIST:
              iIndex = (INT) UpdateSelection( hCtrl, pDlgHdr, ulCtrlID,
                                              SEND_CONSTRAINT_MSG );
              WinSendDlgItemMsg( WinQueryWindow( hCtrl, QW_PARENT ),
                                 PPF_FORMLIST, UCM_LISTITEMS,
                                 (MPARAM) pUIBlock, (MPARAM) iIndex );
              break;

         case PPF_FORMLIST:
              UpdatePrtPropFormSelection( hCtrl, pDlgHdr, ulCtrlID );
              break;

         case JPF_FORMNAMELIST:
         case JPF_FORMNAMELIST_1:                                 // @MIXED_FEED
              UpdateJobPropFormSelection( hCtrl, pDlgHdr, pUIBlock, ulCtrlID );
              break;

         
         // If MEDIATYPE is relisted, it will cause CONSTRAINT_MSG anyway
         // If CONSTRAINT_MSG is sent, MEDIATYPE is relisted. Should be OK.
         case JPF_TRAYNAMELIST:
         case JPF_TRAYNAMELIST_1:                                 // @MIXED_FEED
              lIndex = UpdateSelection( hCtrl, pDlgHdr, ulCtrlID,
                                        IGNORE_CONSTRAINT_MSG );
              
              if(!(pDlgHdr->usFlags & UIC_NO_UPDATE))
              {
                SendConstraintsMessages( pDlgHdr, ulCtrlID, lIndex, pUIBlock );
              }
         //     WinSendDlgItemMsg( WinQueryWindow( hCtrl, QW_PARENT ),
         //                        (ulCtrlID==JPF_TRAYNAMELIST)?JPF_MEDIATYPELIST:
         //                                                     JPF_MEDIATYPELIST_1,
         //                        UCM_LISTITEMS,
         //                        (MPARAM) 0, (MPARAM) 0 );*/
              break;
         case JPF_MEDIATYPELIST_1:                                // @MIXED_FEED
              //Don't Update UI Selection
              break;

         default:

              //@CONSTRAINT
              // before committing selection of that item we call this function 
              // if item is constrained, user gets asked if he wants to unconstrain
              // that item, if 'yes' item gets unconstrained, and if 'no', then
              // old selection gets reselected
              RemoveConstraints(hCtrl,pDlgHdr);
              //@CONSTRAINT

              lIndex = UpdateSelection( hCtrl, pDlgHdr, ulCtrlID, SEND_CONSTRAINT_MSG );
         }

         switch( ulCtrlID )
         {
         case JPE_COLOR_LIST:
              if (lIndex == 0)
              {
                iIndex = ICON_COLOR;
              }
              else
              {
                iIndex = ICON_MONOCHROME;
              }
              sItemIndex = JPSB_MONOCHROME;
              break;
         }

         if (iIndex != -1)
         {
           UpdateIcon( WinQueryWindow( hCtrl, QW_PARENT ), pDlgHdr->hDlg,
                       sItemIndex, iIndex );
         }
       }
       mRC = WinDefDlgProc( hCtrl, ulMsg, mp1, mp2 );
       break;

  case WM_CONTROLPOINTER:
       mRC = SetContextHelp( hCtrl, ulMsg, mp1, mp2, pDlgHdr,
                             (INT) WinQueryWindowUShort( hCtrl, QWS_ID ), 0 );
       break;

  default:
       mRC = WinDefDlgProc( hCtrl, ulMsg, mp1, mp2 );
  }

  /*
  ** The system updated the current selection.  Therefore, update the contents
  ** in the listbox, on the condition that one is provided.
  */
  if (uiNewSelect != (UI_SEL) 0)
  {
    /*
    ** Query the number of items in the listbox.
    */
    iNumOfItems = (INT) WinSendMsg( hCtrl, LM_QUERYITEMCOUNT, (MPARAM) 0,
                                    (MPARAM) 0 );

    /*
    ** This loop will run through each item and highlight any selected ones.
    */
    for (iIndex = 0 ; iIndex < iNumOfItems ; iIndex++)
    {
      sItemIndex = (SHORT) WinSendMsg( hCtrl, LM_QUERYITEMHANDLE,
                                       MPFROMLONG( iIndex ), (MPARAM) 0 );

      /*
      ** If the appropriate bit is set, then highlight the item.
      */
      if ((UI_SEL) (1 << sItemIndex) == uiNewSelect)
      {
        WinSendMsg( hCtrl, LM_SELECTITEM, MPFROMLONG( iIndex ),
                    MPFROMLONG( TRUE ) );
      }
    }
  }

  return( mRC );
}
/*---------------------------------------------------------------------------*\
* UIControlDlgProc End                                                        *
\*---------------------------------------------------------------------------*/






VOID ModifyInstOptConstraints( PDLGHDR pDlgHdr )
{
  PUI_BLOCK pIOBlock;
  PUI_BLOCK pNonIOBlock;
  INT       iIOIndex;
  INT       iNonIOIndex;
  UI_SEL    uisEntry;
  INT       ofsEntry;
  PUI_LIST  pUIList = &pDlgHdr->pdesPPD->stUIList;

#if IPMD_DISPLAY_UI
  PSZ pIOString;
  PSZ pNonIOString;
#endif

  pIOBlock  = pUIList->pBlockList;

  for (iIOIndex = 0 ; iIOIndex < (INT) pUIList->usNumOfBlocks ;
       iIOIndex++)
  {
    if (pIOBlock->ucGroupType == (UCHAR) UIGT_INSTALLABLEOPTION)
    {
      DEBUGQueryBlockName( pDlgHdr, pIOBlock, pIOString );

      pNonIOBlock = pUIList->pBlockList;

      for (iNonIOIndex = 0 ; iNonIOIndex < (INT) pUIList->usNumOfBlocks ;
           iNonIOIndex++)
      {
        if (pNonIOBlock->ucGroupType == UIGT_DEFAULTOPTION)
        {

          DEBUGQueryBlockName( pDlgHdr, pNonIOBlock, pNonIOString );

          uisEntry = *(pDlgHdr->pCurrUISelList + iNonIOIndex);

          ofsEntry = 0;
          while (uisEntry != 0)
          {
            while (!(uisEntry & 1))
            {
              uisEntry >>= 1;
              ofsEntry++;
            }

            uisEntry >>= 1;
          }
        }

        INCREMENT_BLOCK_PTR( pNonIOBlock );
      }
    }

    INCREMENT_BLOCK_PTR( pIOBlock );
  }
}





VOID SetDuplexControls( HWND hDlg, PDLGHDR pDlgHdr )
{
  INT       iLoop;                                  // Local loop counter
  INT       iButtonID;                              // Dialog button ID
  BOOL      fEnableButton;                          // TRUE if to enable btn.
  PSZ       pSelectedDuplex;                        // Current duplex sel.
  PSZ       pCurrDuplex;                            // Curr. duplex to check
  PUI_BLOCK pUIBlock;                               // Duplex block pointer
  INT       ofsEntry = 0;                           // Curr duplex entry
  INT       iButtonToSet = JPF_DUPLEXNONE;          // ID for button to set
  PUI_LIST  pUIList = &pDlgHdr->pdesPPD->stUIList;  // UI list pointer

  if ((pSelectedDuplex = (PSZ) QueryUIOptionString( pDlgHdr->pdesPPD,
                                                    pDlgHdr->pCurrUISelList,
                                                    UINAME_DUPLEX, &ofsEntry,
                                                    &pUIBlock )) != NULL)
  {
    if (!strcmp( pSelectedDuplex, UINAME_DUPLEXTUMBLE ))
    {
      iButtonToSet = JPF_DUPLEXTUMBLE;
    }
    else if (!strcmp( pSelectedDuplex, UINAME_DUPLEXNOTUMBLE ))
    {
      iButtonToSet = JPF_DUPLEXNOTUMBLE;
    }
    else
    {
      iButtonToSet = JPF_DUPLEXNONE;
    }

    iButtonID   = JPF_DUPLEXTUMBLE;
    pCurrDuplex = UINAME_DUPLEXTUMBLE;

    for (iLoop = 0 ; iLoop < 2 ; iLoop++)
    {
      QueryEntryFromOption( pDlgHdr->pItemsBuff, pUIBlock, (PBYTE) pCurrDuplex,
                            &ofsEntry );

      if (QueryCnstListBlockList( pDlgHdr, pUIBlock, (LONG) ofsEntry,
                                  QUERY_ALL_GROUPS, BLOCK_SEARCH_ALL )
          == TRUE)
      {
        fEnableButton = FALSE;

        if (iButtonID == iButtonToSet)
        {
          iButtonToSet = JPF_DUPLEXNONE;
        }
      }
      else
      {
        fEnableButton = TRUE;
      }

      WinEnableWindow( WinWindowFromID( hDlg, iButtonID ), fEnableButton );

      iButtonID   = JPF_DUPLEXNOTUMBLE;
      pCurrDuplex = UINAME_DUPLEXNOTUMBLE;
    }
  }

  WinSendDlgItemMsg( hDlg, iButtonToSet, BM_SETCHECK, MPFROMSHORT( 1 ),
                     (MPARAM) 0 );

  /*
  ** This forces the status icon to be updated.
  */
  WinSendMsg( hDlg, WM_CONTROL, MPFROMLONG( iButtonToSet ), (MPARAM) 0 );
}

//@CONSTRAINT (large code block begin)
//
// Abstract flow goes like this:
//
// RemoveConstraints() is called everytime user
// selects item. It then calls IdentifyConstraint() to identify
// if item is constrained, and to see how to unconstrain that item
// (and if it is possible to do it automatically)
// Then user is asked if he will accept that choice and item
// get unconstrained by setting corresponding flags in UISelection.
//
// The most interesting things are done in IdentifyConstraint(),
// other functions are fairly trivial.
//

/******************************************************************************
 *
 * FUNCTION NAME = AskUnconstrain
 *
 * DESCRIPTION
 *   Shows a message box to user, if he wil accept automatic unconstraining 
 *   and asks for 'ok' or 'cancel'
 *
 * INPUT
 * pszConstrUI - Name of UI that constraining item is in.
 * pszConstrEntry - Name of current (constraining) choice.
 * pszPossibleEntry - Name of possible choice that would be not constraining,
 *   when selected.
 *
 * OUTPUT
 * A message box.
 *
 * RETURN:
 *   TRUE - user selected 'ok', caller should proceed with unconstraining
 *   FALSE - user cancelled, abort unconstraining
 *
 *****************************************************************************/

BOOL AskUnconstrain( HWND hDlg, PSZ pszConstrUI, PSZ pszConstrEntry, PSZ pszPossibleEntry)
{

   char szTitle[MAX_MESSAGE_SIZE];
   char szBuffer[MAX_MESSAGE_SIZE];
   char szMessage[MAX_MESSAGE_SIZE];
   // for filling in message
   PCHAR pTable[3] = { pszConstrUI, pszConstrEntry, pszPossibleEntry };
   LONG  cTable = 3;
   LONG  lBufLen;
   ULONG ulMsgLen;

   HAB  hab = WinQueryAnchorBlock( hDlg);
   
   // retrieve string for message box title
   //    "Constrained item selected"
   WinLoadString(hab,
              pscript_module, // magic global variable
              IDS_ConstrItemTitle,
              MAX_MESSAGE_SIZE,
              szTitle
             );

   // retrieve message text "template" from resources
   //     "This option is constrained because the %1 option is set to '%2'.
   //     Press OK, to remove constraint and set the %1 option to '%3'."
   lBufLen = WinLoadString(hab,
              pscript_module,
              IDS_ConstrItemMsg,
              MAX_MESSAGE_SIZE,
              szBuffer
             );

   // fill in the variables
   DosInsertMessage(pTable,cTable,szBuffer,lBufLen,szMessage,MAX_MESSAGE_SIZE,&ulMsgLen);
   szMessage[ulMsgLen] = 0;

   // show the message

   if(WinMessageBox(HWND_DESKTOP, WinQueryActiveWindow(HWND_DESKTOP), szMessage, szTitle,
               0, MB_ICONEXCLAMATION | MB_OKCANCEL | MB_APPLMODAL) == MBID_OK)
   {
      return TRUE;
   }

   return FALSE;
}

/******************************************************************************
 *
 * FUNCTION NAME = UnconstrainFailed
 *
 * DESCRIPTION
 *   Tell user that automatic unconstraining is not possible, because
 *   all other choices in constraining UI are constrained (and we 
 *   don't want to go into recursion)
 *
 * INPUT
 * pszConstrUI - Name of UI that constraining item is in.
 * pszConstrEntry - Name of current (constraining) choice.
 *
 * OUTPUT
 * A message box.
 *
 * RETURN:
 *   TRUE - dummy value, actually
 *
 *****************************************************************************/

BOOL UnconstrainFailed( HWND hDlg, PSZ pszConstrUI, PSZ pszConstrEntry )
{
   CHAR szTitle[MAX_MESSAGE_SIZE];
   CHAR szMessage[MAX_MESSAGE_SIZE];
   CHAR szBuffer[MAX_MESSAGE_SIZE];
   // for filling in message
   PCHAR pTable[2] = { pszConstrUI, pszConstrEntry };
   LONG  cTable = 2;
   LONG  lBufLen;
   ULONG  ulMsgLen;

   HAB  hab = WinQueryAnchorBlock( hDlg);
   
   // retrieve string for message box title
   //    "Constrained item selected"
   WinLoadString(hab,
              pscript_module, // magic global variable
              IDS_ConstrFailTitle,
              MAX_MESSAGE_SIZE,
              szTitle
             );

   // retrieve message text "template" from resources
   //     "This option is constrained by %1 selection '%2'.
   //     There is no unconstrained value to set automatically. Please set %1 to non-constraining value manually."
   lBufLen = WinLoadString(hab,
              pscript_module,
              IDS_ConstrFailMsg,
              MAX_MESSAGE_SIZE,
              szBuffer
             );

   // fill in the variables
   DosInsertMessage(pTable,cTable,szBuffer,lBufLen,szMessage,MAX_MESSAGE_SIZE,&ulMsgLen);
   szMessage[ulMsgLen] = 0;

   // show the message

   WinMessageBox(HWND_DESKTOP, WinQueryActiveWindow(HWND_DESKTOP), szMessage, szTitle,
               0, MB_ERROR | MB_OK | MB_APPLMODAL);

   return TRUE;
}

/******************************************************************************
 *
 * FUNCTION NAME = QueryConstraintType
 *
 * DESCRIPTION
 *   Query what type of item is constraining the item. Used for identifying
 *   installable option constrained items, which should not be visible in 
 *   any case.
 *
 * INPUT
 * pDlgHdr - Dialog box header structure.
 * pUIBlock - UIBlock for the current control.
 * lIndex - item's index in listbox
 *
 * OUTPUT
 *   None
 *
 * RETURN:
 *   0 if item should be hidden completely
 *   1 if shown as constrained
 *
 *****************************************************************************/

UCHAR QueryConstraintType(
   PDLGHDR pDlgHdr,
   PUI_BLOCK pUIBlock,
   LONG lIndex )
{

   LONG      lBlockList;
   LONG      lNumOfBlocks = (LONG) pDlgHdr->pdesPPD->stUIList.usNumOfBlocks;
   PUI_BLOCK pUIBlockList = pDlgHdr->pdesPPD->stUIList.pBlockList;
   PUI_SEL   pUISel = pDlgHdr->pCurrUISelList; // selections in UIs

   LONG      lGroupType = UIGT_DEFAULTOPTION;

   
   // Hide constrained items in certain UI listboxes //@VV.241649 
      
   if( // do not show Page Sizes constrained by tray (in Printer Properties)
       !strcmp((PSZ) (pDlgHdr->pItemsBuff + pUIBlock->ofsUIName),UINAME_PAGESIZE) ||
       // do not show constrained Media Types (in Job Properties)
       !strcmp((PSZ) (pDlgHdr->pItemsBuff + pUIBlock->ofsUIName),UINAME_MEDIATYPE)
     )
   {
     // hide it
     return(0);
   }

   // This for loop spoofs QueryCnstListBlockList to some extent.

   for (lBlockList = 0 ; lBlockList < lNumOfBlocks ; 
        lBlockList++)
   {
 
     if (pUIBlockList != pUIBlock
         // we are not PICKMANY aware! this would be a problem,
         // but currently there is quite a few other places that will
         // break on PICKMANY. And it will be a bit tricky to implement.
         // No available testcases, too.
         && pUIBlock->usSelectType != UI_SELECT_PICKMANY 

         // er.. i don't know what really this does! should investigated.
         // taken from QueryCnstListBlockList intact for now.
         && pUIBlockList->ucGroupType >= (UCHAR) lGroupType 
        )
     {
        if( QueryCnstListBlock( pDlgHdr, pUIBlock, lIndex,
                                  pUIBlockList, *pUISel ))
        {
           // if constrained by INSTALLABLEOPTION //@VV.241649
           if(pUIBlockList->ucGroupType == (CHAR) UIGT_INSTALLABLEOPTION)
           {  
              // hide it
              return (0);
           }

           // should be shown
           return(1);
        }
     }
     INCREMENT_BLOCK_PTR( pUIBlockList );
     pUISel++;
  }

  // strange - did not find constraint on it, so hide it.
  // (we don't want to mess with it)
  return(0);
}


/******************************************************************************
 *
 * FUNCTION NAME = IdentifyConstraint
 *
 * DESCRIPTION
 * This function is called when RemoveConstraints() has decided that 
 * currently selected item is constrained and we should now query
 * user if he wants to unconstrain the selection. if no, return. 
 * If yes, go through UI structures and find (and set) values that 
 * will not constrain this newly selected item.
 *
 * INPUT
 * pDlgHdr - Dialog box header structure.
 * pUIBlock - UIBlock for the current control.
 * lIndex - item's index in listbox
 * 
 *   pointers to PSZ which will be set to:
 * ppszConstrUI -  name of constraining UI
 * ppszConstrEntry - name of constraining entry
 * ppszPossibleEntry - name of possible entry
 *
 * pUIConstr - pointer to UI_SEL for that constraining UI
 * pUISelConstr - bit to unset 
 * pUISelPossible - bit to set
 *
 * OUTPUT
 *   See above.
 *
 * RETURN:
 *   TRUE - constraint found
 *   FALSE - constraint not found OR
 *   FALSE and ppszConstrUI, ppszConstrEntry NOT NULL
 *         and ppszPossibleEntry == NULL - constraint found, but
 *         we can't do anything about it. See UnconstrainFailed() &
 *         end of while{} loop in RemoveConstraints() for more insight.
 *
 *****************************************************************************/

// 1) see if this new selection is constrained
//    see by whom
//    see which option will be selected to unconstrain it

BOOL IdentifyConstraint(
   PDLGHDR pDlgHdr,
   PUI_BLOCK pUIBlock,
   LONG lIndex,
   PPSZ ppszConstrUI, PPSZ ppszConstrEntry, PPSZ ppszPossibleEntry,
   PUI_SEL *pUIConstr, PUI_SEL pUISelConstr, PUI_SEL pUISelPossible
   )
{
   LONG      lBlockList;
   LONG      lNumOfBlocks = (LONG) pDlgHdr->pdesPPD->stUIList.usNumOfBlocks;
   PUI_BLOCK pUIBlockList = pDlgHdr->pdesPPD->stUIList.pBlockList;
   PUI_SEL   pUISel = pDlgHdr->pCurrUISelList; // selections in UIs

   LONG      lGroupType = UIGT_DEFAULTOPTION;
 
   LONG      lItem;
 
   BOOL fConstrFound;
   BOOL fPossibleUIFound;
 
   PUI_ENTRY pUIEntry;
   
   UI_SEL UISelTemp;
   UI_SEL UISelConstr = 0;
   UI_SEL UISelPossible = 0;
 
#if IPMD_DISPLAY_UI
  PSZ pCurrUIString;
  PSZ pEntryString;
#endif

  *ppszConstrUI = "(NULL)";
  *ppszConstrEntry = "(NULL)";
  *ppszPossibleEntry = "(NULL)";


   // This for loop spoofs QueryCnstListBlockList to some extent.

   for (lBlockList = 0 ; lBlockList < lNumOfBlocks ; 
        lBlockList++)
   {
 
     if (pUIBlockList != pUIBlock
         // we are not PICKMANY aware! this would be a problem,
         // but currently there is quite a few other places that will
         // break on PICKMANY. And it will be a bit tricky to implement.
         // No available testcases, too.
         && pUIBlock->usSelectType != UI_SELECT_PICKMANY 

         // er.. i don't know what really this does! should investigated.
         // taken from QueryCnstListBlockList intact for now.
         && pUIBlockList->ucGroupType >= (UCHAR) lGroupType 
        )
     {
        fConstrFound = FALSE;
        fPossibleUIFound = FALSE;

        if( QueryCnstListBlock( pDlgHdr, pUIBlock, lIndex,
                                  pUIBlockList, *pUISel ))
        {

           // ok, this pUIBlockList is constraining us. Find out
           // exactly which bit does it.

           *ppszConstrUI = (PSZ) (pDlgHdr->pItemsBuff + pUIBlockList->ofsUITransString);

           pUIEntry  = pUIBlockList->uiEntry;
           for(lItem = 0; lItem < lItem < pUIBlockList->usNumOfEntries; lItem++)
           {
              UISelTemp = CONVERT_OFS_TO_UISEL(lItem);

#if IPMD_DISPLAY_UI
              DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock, lItem,
                                               pEntryString );
#endif
              // see if this bit actually is one of currently in pUISel
              // (item currently selected). We don't want to go looking
              // for constraining bits of choices that are not currently
              // selected.

              if(UISelTemp & *pUISel) // this IS bitwise and
              {
                 if( QueryCnstListBlock( pDlgHdr, pUIBlock, lIndex,
                                           pUIBlockList, UISelTemp ))
                 {
                    // yeah... that's it... that's the constraint
                    *ppszConstrEntry = (PSZ) (pDlgHdr->pItemsBuff + pUIEntry->ofsTransString);
                    UISelConstr = UISelTemp;
                    fConstrFound = TRUE;
                    break; // search is over
                 }
              }
 
              pUIEntry++;
           }
 

           // now find out which choice should be selected for constraint
           // to go away.

           pUIEntry  = pUIBlockList->uiEntry;
           for(lItem = 0; lItem < pUIBlockList->usNumOfEntries; lItem++)
           {
              UISelTemp = CONVERT_OFS_TO_UISEL(lItem);

#if IPMD_DISPLAY_UI
              DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock, lItem,
                                               pEntryString );
#endif

              // we want to find entry that will NOT constrain
              if( !QueryCnstListBlock( pDlgHdr, pUIBlock, lIndex,
                                        pUIBlockList, UISelTemp )
                 // should check if this option is not constrained already!
                  && !QueryCnstListBlockList( pDlgHdr, pUIBlockList, lItem,
                             QUERY_ALL_GROUPS, BLOCK_SEARCH_ALL )
                  )
              {
                 // found one

                 *ppszPossibleEntry = (PSZ) (pDlgHdr->pItemsBuff + pUIEntry->ofsTransString);
                 UISelPossible = UISelTemp;
                 fPossibleUIFound = TRUE;
                 break; // search is over
              }
           
              pUIEntry++;
           }
    
           // are both entries found?
           if(fConstrFound && fPossibleUIFound)
           {
              *pUIConstr = pUISel;
              *pUISelConstr = UISelConstr;
              *pUISelPossible = UISelPossible;

              return TRUE; // bail out
           }
        }

        // constrain found but no non-constraining entry?
        if(fConstrFound && !fPossibleUIFound)
        {
            // Possible UI selection not found! Tell user.
            *ppszPossibleEntry = NULL;
            return FALSE; // bail out
        }
     }
 
     INCREMENT_BLOCK_PTR( pUIBlockList );
     pUISel++;
  }
 
  return FALSE;
}


/******************************************************************************
 *
 * FUNCTION NAME = RemoveConstraints
 *
 * DESCRIPTION
 * Mother function of automatical unconstraining. Gets called before 
 * UpdateSelection (actually borrows significant part of UpdateSelection()
 * functionality code, compare) to unconstrain selected item (if constrained).
 * or to restore previous selection, if selected item cannot be unconstrained.
 *
 * INPUT
 * hCtrl - handle of current control
 * pDlgHdr - Dialog box header structure.
 *
 * OUTPUT
 * None.
 *
 * RETURN: VOID
 *
 *****************************************************************************/
VOID RemoveConstraints( HWND hCtrl, PDLGHDR pDlgHdr)
{
  PUI_BLOCK pUIBlock;
  PUI_SEL   pUISelection;
  UI_SEL    tempUISel;
  LONG      lIndex;
  LONG      lOldIndex;

#if IPMD_DISPLAY_UI
  PSZ pCurrUIString;
  PSZ pEntryString;
#endif

  BOOL fSuccess;

  PSZ  pszConstrUI = NULL;
  PSZ  pszConstrEntry = NULL;
  PSZ  pszPossibleEntry = NULL;

  UI_SEL UISelConstraining;
  UI_SEL UISelPossible;
  PUI_SEL pUIConstr;

   //@VV.241649 
   // if massive operation is undergoing ('Default', 'Undo') and we should be quiet
   if(pDlgHdr->usFlags & UIC_NO_UPDATE)  
   {
      // do nothing
      return;
   }

   /*
   ** The doubleword for the control is the UI block pointer.
   */
   pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );

#if IPMD_DISPLAY_UI
  DEBUGQueryBlockName( pDlgHdr, pUIBlock, pCurrUIString );
#endif

   //@VV.241649
   // installable options are never considered constrained,
   // though they might seem so. for example, if TRAY2 is currently selected on
   // Paper notebook page and you want to uninstall it, 'Not installed' option 
   // is kinda constrained, but not really. 
   if(pUIBlock->ucGroupType == (CHAR)UIGT_INSTALLABLEOPTION) 
   {
      // do nothing
      return;
   }


   // pUISelection is current (old) UI selection and clear it.
   // we will obtain new selection from QueryLBSelection later
   pUISelection = pDlgHdr->pCurrUISelList + pUIBlock->usOrderDep;

   // save old selection
   tempUISel = *pUISelection; 
   // and find out old selection index (we will use it
   // to undo new selection that is in progress)
   lOldIndex=0;
   while(lOldIndex<32 && !(tempUISel & 1))
   {
      lOldIndex++;
      tempUISel>>=1;
   }

   //
   // now, get new selection from listbox, and update pUISelection
   // accordingly
   //
   *pUISelection = 0;

   do
   {
     /*
     ** Query the selection index.
     */
     GplPageQueryLBSelection( hCtrl, 0, &lIndex, NULL);
     if (lIndex >= 0)
     {
 
       /*
       ** From the index, set the appropriate UI selection bit.
       */
       *pUISelection |= 1 << lIndex;
 
#if IPMD_DISPLAY_UI
       DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock, lIndex,
                                        pEntryString );
#endif
 
   
       fSuccess = FALSE; // assume nothing is done
   
       // pUIConstr address is going to be modified. so it is pointer to pointer
       while(IdentifyConstraint(pDlgHdr,pUIBlock,lIndex,
                                &pszConstrUI,&pszConstrEntry,&pszPossibleEntry,
                                &pUIConstr, &UISelConstraining, &UISelPossible
                               ) == TRUE)
       {
          // a-ha! the item currently is constrained
          //@243371
          // If UIC_NO_ASK is set, unconstrain without asking. 

          BOOL fDoUnconstrain = FALSE;
   
          // see what we should do:
          if( pDlgHdr->usFlags & UIC_NO_ASK ) 
             fDoUnconstrain = TRUE; // remove constraint without question
          else  // ask user if it is OK to remove that constraint
             fDoUnconstrain = AskUnconstrain(pDlgHdr->hDlg, pszConstrUI, pszConstrEntry, pszPossibleEntry);
          //@243371
     
          if( fDoUnconstrain )
          {
             // answer was YES
    
             CLEARFLAG(*pUIConstr,UISelConstraining);
             SETFLAG(*pUIConstr,UISelPossible);
             fSuccess = TRUE;
          }
          else
          {
             // user cancelled. it will not be beautiful when
             // done halfway through... but what I can do
   
             // reset original selection in listbox
             GplPageSelectListItem( hCtrl, 0, lOldIndex, GDPI_INDEX);
             fSuccess = FALSE;
             break; // bail out
          }
   
          // and again, until all constraints removed
       }
   
   
       // if IdentifyConstraint() returns FALSE and pszConstrUI & ConstrEntry are
       // not null (some constraint has been identified) but pszPossibleEntry is NULL
       // (no possible entry identified) we got constrained by feature that
       // does not have any other selectable value!
       //                                           
       if (pszConstrUI != NULL && pszConstrEntry != NULL && pszPossibleEntry == NULL)
       {
          // tell user that.
          UnconstrainFailed(pDlgHdr->hDlg, pszConstrUI, pszConstrEntry );
          // and re-set original selection in listbox
          GplPageSelectListItem( hCtrl, 0, lOldIndex, GDPI_INDEX);
          fSuccess = FALSE;
       }
   
       if( fSuccess )
       {
          // unconstraining completed fine (something got changed)
   
          // relist items in that listbox, so currently selected
          // item is shown as unconstrained now
          WinSendMsg( hCtrl, UCM_LISTITEMS, (MPARAM) 0, (MPARAM) 0 );
       }
     }
   } while (pUIBlock->usSelectType == UI_SELECT_PICKMANY);


   // now it is time for UpdateSelection() to send out constraint 
   // messages so new world order takes effect.
}

//@CONSTRAINT large code block end


/******************************************************************************
 *
 * FUNCTION NAME = UpdateSelection
 *
 * DESCRIPTION
 * Updates the current UI selection, from the selection taken from a listbox.
 * The listbox is queried and, the UI selection bit is updated.  The value
 * is taken from the item handle in the listbox.
 *
 * This function also sends a WMPS_CONSTRAINTS message to all the pages in
 * the dialog.  This indicates that a UI item has been selected and to apply
 * constraints to other items.  This is providing that a UI item is not being
 * updated by a prior WMPS_CONSTRAINTS message.  In this case, the flag
 * UIC_NO_UPDATE is set, which prevents WMPS_CONSTRAINTS message from being
 * continously sent.
 *
 * NOTE:  If you do *NOT* wish to send a WMPS_CONSTRAINTS message, set
 * the UIC_NO_UPDATE flag in the dialog header (DLGHDR) prior to calling this
 * function.  Remember to reset the flag after calling this function.
 *
 * INPUT
 * hCtrl - Control handle.
 * pDlgHdr - Dialog header.
 * ulCtrlID - Control ID.  This ID is to the same control as hCtrl.
 * fSendCnstMsg - Contains one of the following:
 * - SEND_CONSTRAINT_MSG - Send a WMPS_CONSTRAINTS message to all other UI
 *   controls to update their displays.
 * - IGNORE_CONSTRAINT_MSG - Do NOT send a WMPS_CONSTRAINTS message to all
 *   other UI controls.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL - Index handle.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
LONG UpdateSelection( HWND hCtrl, PDLGHDR pDlgHdr, ULONG ulCtrlID,
                      BOOL fSendCnstMsg )
{
  PUI_BLOCK pUIBlock;
  PUI_SEL   pUISelection;
  LONG      lIndex;

#if IPMD_DISPLAY_UI
  PSZ pCurrUIString;
  PSZ pEntryString;
#endif

  /*
  ** The doubleword for the control is the UI block pointer.
  */
  pUIBlock = (PUI_BLOCK) WinQueryWindowULong( hCtrl, QWL_USER );
  if( pUIBlock == NULL ) return(0);                                  //@V1.0VV06

#if IPMD_DISPLAY_UI
  DEBUGQueryBlockName( pDlgHdr, pUIBlock, pCurrUIString );
#endif

  /*
  ** Query the current UI selection and clear it.
  */
  pUISelection = pDlgHdr->pCurrUISelList + pUIBlock->usOrderDep;
  *pUISelection = 0;

  do
  {
    /*
    ** Query the selection index.
    */
    GplPageQueryLBSelection( hCtrl, 0, &lIndex, NULL);
    if (lIndex >= 0)
    {
      /*
      ** From the index, set the appropriate UI selection bit.
      */
      *pUISelection |= 1 << lIndex;

      DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock, lIndex,
                                       pEntryString );

      /*
      ** An update to a UI control has been made.  If this update is to the
      ** original control, then send a WMPS_CONSTRAINTS message to the other
      ** controls, telling them to update themselves as a result.
      ** UIC_NO_UPDATE is set/reset in SendConstraintsMessages().
      */
      if (fSendCnstMsg == SEND_CONSTRAINT_MSG &&
          !(pDlgHdr->usFlags & UIC_NO_UPDATE))
      {
        SendConstraintsMessages( pDlgHdr, ulCtrlID, lIndex, pUIBlock );
      }
    }
    else
    {
      *pUISelection = 0;
    }
  } while (pUIBlock->usSelectType == UI_SELECT_PICKMANY);

  return( lIndex );
}
/*---------------------------------------------------------------------------*\
* UpdateSelection End                                                         *
\*---------------------------------------------------------------------------*/





/******************************************************************************
 *
 * FUNCTION NAME = SendConstraintsMessages
 *
 * DESCRIPTION
 * This function should be called when the user makes a selection in a UI
 * control (called the original control).  This function sends a
 * WMPS_CONSTRAINTS message to all dialog pages in the notebook.
 *
 * Each dialog page, when it receives the WMPS_CONSTRAINTS message, should
 * call UpdateConstraints() for each UI control listbox that it has.
 *
 * Prior to sending the WMPS_CONSTRAINTS message, this function set a
 * UIC_NO_UPDATE flag.  When the other UI controls are updated as a result
 * of the WMPS_CONSTRAINTS message they will, in turn, call this function,
 * as a result of the update.  The UIC_NO_UPDATE flag is used to ensure that
 * the WMPS_CONSTRAINTS message is sent by the original control only.  If all
 * controls sent this message, then it would generate an infinite loop.
 *
 * A WMPS_CONSTRAINTS message is a message that indicates that a UI control
 * selection has been made and that the other controls must re-display their
 * selections so that constraints are not applied to either control.
 * The format of the WMPS_CONSTRAINTS message is:
 *
 * - mp1
 *   - ID of the control where the selection was made (ulOrgCtrlID).
 *   - Zero-based item in the listbox that was selected (lOrgSelection).
 * - mp2 - UI block that corresponds to the UI control that was selected.
 *
 * INPUT
 * pDlgHdr - Dialog box header structure.
 * ulOrgCtrlID - Original control ID that was selected.
 * lOrgSelection - Original zero-based selection from the listbox.  For
 *  example, if the first item in the listbox was selected, this value is 0.
 * pUIBlock - Matching block buffer for the current control.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - Return code from WinSendMsg().
 * RETURN-ERROR  - Return code from WinSendMsg().
 *
 *****************************************************************************/
MRESULT SendConstraintsMessages( PDLGHDR pDlgHdr, ULONG ulOrgCtrlID,
                                 LONG lOrgSelection, PUI_BLOCK pUIBlock )
{
  USHORT  usLoop;
  PGDPPI  pGPInfo;
  MRESULT mRC = (MRESULT) 0;

  // A UI block is needed.
  if (pUIBlock != NULL)
  {
    /*
    ** Set the recursion flag, prior to sending the WMPS_CONSTRAINTS message,
    ** so that other controls will not send the same message and cause an
    ** infinite loop.
    */
    pDlgHdr->usFlags |= UIC_NO_UPDATE;

    /*
    ** This loop sends a WMPS_CONSTRAINTS message to each dialog page in the
    ** notebook.
    */
    pGPInfo = pDlgHdr->stPage;
    for (usLoop = 0 ; usLoop < pDlgHdr->usNumOfPages ; usLoop++)
    {
      /*
      ** Send a WMPS_CONSTRAINTS message to all dialog pages.  Each dialog
      ** page, in turn, must relay the message to their appropriate UI
      ** control.
      */
      mRC = (MRESULT) WinSendMsg( (pGPInfo++)->hPage, WMPS_CONSTRAINTS,
                                  MPFROM2SHORT( ulOrgCtrlID, lOrgSelection ),
                                  MPFROMP( pUIBlock ) );
    }

    /*
    ** All message processing is finished.  Reset the flag.
    */
    pDlgHdr->usFlags &= ~UIC_NO_UPDATE;
  }

  return( mRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = UpdateConstraints
 *
 * DESCRIPTION
 * This function is to be called from any dialog pages that has a UI control
 * The dialog page is to make this call for each UI control it has.  This
 * function should be called in a response to a WMPS_CONSTRAINTS message.
 *
 * This function uses two UI controls as a basis for processing:  the original
 * control (the control the user selected which generated a WMPS_CONSTRAINTS
 * message, and a current control (the control the dialog page called this
 * function in response to the WMPS_CONSTRAINTS message generated by the
 * original control).  In other words, there will be only one original control,
 * but many current controls, with each current control processed by this
 * function, one at a time.
 *
 * If a possible constraint exists between the current control and the original
 * control, then the selections of the current control are re-displayed.
 * Prior to displaying each selection, the selection queries the list of
 * available constraints to see if there is a constraint between the current
 * selection, and the selection made in the original control.  If a constraint
 * does not exist, then the selection is displayed in the listbox.  If a
 * constraint does exist, then the selection is not displayed.
 *
 * INPUT
 * hDlg - Dialog page handle.
 * pDlgHdr - Dialog box header structure.
 * ulCtrlID - Current control ID to verify against original control.
 * mp1 - Provided from WMPS_CONSTRAINTS message.  Contains the ID of the
 *  original control and offset of the selection made.
 * mp2 - Provided from WMPS_CONSTRAINTS message.  Contains the pointer to the
 *  UI_BLOCK that corresponds to the original control.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE  - Constraints apply - control updated.
 *                 FALSE - Constraints do not apply - control not updated.
 * RETURN-ERROR  - None.
 *
 *****************************************************************************/
BOOL UpdateConstraints( HWND    hDlg,
                        PDLGHDR pDlgHdr,
                        ULONG   ulCtrlID,
                        MPARAM  mp1,
                        MPARAM  mp2
                      )
{
  PUI_BLOCK pOrgUIBlock;
  PUI_BLOCK pCurrUIBlock;
  ULONG     ulOrgCtrlID = (LONG) SHORT1FROMMP( mp1 );
  BOOL      fRC = FALSE;

#if IPMD_DISPLAY_UI
  PSZ pOrgBlockString;
  PSZ pCurrBlockString;
#endif

  /*
  ** The current control should not be the original control that sent
  ** the WMPS_CONSTRAINTS message.
  */
  if (ulOrgCtrlID != ulCtrlID)
  {
    /*
    ** Query the original selections from the other control.
    */
    pOrgUIBlock = (PUI_BLOCK) mp2;

    /*
    ** Query the current block.
    */
    if ((pCurrUIBlock = (PUI_BLOCK) WinQueryWindowULong( WinWindowFromID( hDlg,
                                                                    ulCtrlID ),
                                                         QWL_USER )) != NULL)
    {

      DEBUGQueryBlockName( pDlgHdr, pCurrUIBlock, pCurrBlockString );
      DEBUGQueryBlockName( pDlgHdr, pOrgUIBlock, pOrgBlockString );

      /*
      ** By using a '-1', we are querying all possible selections between the
      ** two blocks.  If TRUE is returned, redisplay the entries in the list.
      */
      if ((fRC = QueryCnstListBlock( pDlgHdr, pCurrUIBlock, -1,
                                     pOrgUIBlock, (UI_SEL) -1 )) == TRUE)
      {
        WinSendDlgItemMsg( hDlg, ulCtrlID, UCM_LISTITEMS, (MPARAM) 0,
                           (MPARAM) 0 );
      }
    }
  }

  return( fRC );
}





MRESULT SetContextHelp( HWND hDlg, ULONG ulMsg, MPARAM mp1, MPARAM mp2,
                        PDLGHDR pDlgHdr, INT iCtrlID, INT iCHCtrlID )
{
  HWND hLocal;

  if (pDlgHdr == NULL)
  {
    pDlgHdr = (PDLGHDR) WinQueryWindowULong( hDlg, QWL_USER );
  }

  if (iCHCtrlID == 0)
  {
    iCHCtrlID = PS_CONTEXTHELP;
    hLocal = pDlgHdr->hDlg;
  }
  else
  {
    hLocal = hDlg;
  }

  if (iCtrlID == 0)
  {
    iCtrlID = (INT) SHORT1FROMMP( mp1 );
  }

  switch (iCtrlID )
  {
  case JPF_LANDSCAPE:
  case JPF_PORTRAIT:
       iCtrlID = JPF_ORIENTGROUP;
       break;

  case JPF_DUPLEXTUMBLE:
  case JPF_DUPLEXNOTUMBLE:
       if (WinIsWindowEnabled( WinWindowFromID( hDlg, iCtrlID ) ) == FALSE)
       {
         iCtrlID = SetDuplexContextHelp( hDlg, iCtrlID, pDlgHdr );
       }
       break;
  }

  if (iCtrlID != (INT) pDlgHdr->usCHCtrl)
  {
    if (iCtrlID != STRING_ALREADY_LOADED)
    {
      WinLoadString( (HAB) 0, pscript_module, iCtrlID, CHBUFF_SIZE,
                     pDlgHdr->pCHBuffer );
    }

    WinSetDlgItemText( hLocal, iCHCtrlID, pDlgHdr->pCHBuffer );

    pDlgHdr->usCHCtrl = (USHORT) iCtrlID;
  }

  return( WinDefDlgProc( hDlg, ulMsg, mp1, mp2 ) );
}





INT SetDuplexContextHelp( HWND hDlg, INT iCtrlID, PDLGHDR pDlgHdr )
{
  PUI_BLOCK pDuplexBlock;
  PUI_BLOCK pScanBlock;
  INT       iReturnCtrlID;
  INT       ofsDuplexEntry;
  PSZ       pDuplex;
  INT       iUILoop;
  PSZ       pScanBlockStr;
  PSZ       pScanEntryStr;
  INT       iNumCharsRead;
  INT       ofsEntry = 0;
  PUI_SEL   puiScanSel;
#if IPMD_DISPLAY_UI
  PSZ pScanString;
#endif

  if ((pDuplexBlock = QueryBlockFromKeyword( &pDlgHdr->pdesPPD->stUIList,
                                             pDlgHdr->pItemsBuff,
                                             UINAME_DUPLEX,
                                             NULL )) != NULL)
  {
    switch (iCtrlID)
    {
    case JPF_DUPLEXTUMBLE:
         pDuplex = (PSZ) UINAME_DUPLEXTUMBLE;
         break;

    default:
         pDuplex = (PSZ) UINAME_DUPLEXNOTUMBLE;
    }

    if (iCtrlID != (INT) pDlgHdr->usCHCtrl)
    {
      QueryEntryFromOption( pDlgHdr->pItemsBuff, pDuplexBlock, (PBYTE) pDuplex,
                            &ofsDuplexEntry );

      /*
      ** Run through the list of UI blocks in the list until the first
      ** constraint match is found.
      */
      pScanBlock = pDlgHdr->pdesPPD->stUIList.pBlockList;
      puiScanSel = pDlgHdr->pCurrUISelList;
      for (iUILoop = 0 ; iUILoop < (INT) pDlgHdr->pdesPPD->stUIList.
           usNumOfBlocks ; iUILoop++)
      {
        DEBUGQueryBlockName( pDlgHdr, pScanBlock, pScanString );

        if (QueryCnstListBlock( pDlgHdr, pDuplexBlock, ofsDuplexEntry,
                                pScanBlock, *puiScanSel ) == TRUE)
        {
          /*
          ** The first order of business is to query the block keyword.
          ** This will be needed to query the current selection.
          */
          pScanBlockStr = (PSZ) (pDlgHdr->pItemsBuff +
                                 pScanBlock->ofsUIName);

          /*
          ** With keyword in hand, query the current selection keyword.  This
          ** keyword is needed to get the current entry.
          */
          pScanEntryStr = (PSZ) QueryUIOptionString( pDlgHdr->pdesPPD,
                                                     pDlgHdr->pCurrUISelList,
                                                     (PBYTE) pScanBlockStr,
                                                     &ofsEntry, NULL );

          /*
          ** Take that current entry keyword and query the offset where that
          ** entry is found in the block.  The offset is needed so that we
          ** know which UI_ENTRY to get the translation string.
          */
          QueryEntryFromOption( pDlgHdr->pItemsBuff, pScanBlock,
                                (PBYTE) pScanEntryStr, &ofsEntry );

          /*
          ** From the entry offset, query the entry's translation string.
          */
          pScanEntryStr = (PSZ) (pScanBlock->uiEntry[ ofsEntry ].ofsTransString +
                                 pDlgHdr->pItemsBuff);

          /*
          ** Now, query the block's translation string.
          */
          pScanBlockStr = (PSZ) (pScanBlock->ofsUITransString +
                                 pDlgHdr->pItemsBuff );

          /*
          ** We now have the T.S of both the block and entry selection.  Now,
          ** we need to put them in a string for display.
          */
          /*
          ** Start off with the string:
          ** "Duplex is not supported because"
          */
          iNumCharsRead = WinLoadString( (HAB) 0, pscript_module,
                                         IDS_DNSCONST1, CHBUFF_SIZE,
                                         pDlgHdr->pCHBuffer );

          /*
          ** Insert the UI block translation string.
          */
          strcat( pDlgHdr->pCHBuffer, pScanBlockStr );
          iNumCharsRead = strlen( pDlgHdr->pCHBuffer );

          /*
          ** If the block is an insallable option, indicate that it is found
          ** in Printer Properties.  Otherwise, it is found in Job Properties.
          ** Reads as follows:
          ** ", located in [Printer/Job] Properties,"
          */
          if (pScanBlock->ucGroupType == UIGT_DEFAULTOPTION)
          {
            ofsDuplexEntry = IDS_DNSCONSTJP;
          }
          else
          {
            ofsDuplexEntry = IDS_DNSCONSTPP;
          }
          iNumCharsRead += WinLoadString( (HAB) 0, pscript_module,
                                          ofsDuplexEntry,
                                          CHBUFF_SIZE - iNumCharsRead,
                                          pDlgHdr->pCHBuffer + iNumCharsRead);

          /*
          ** Insert: "is set to"
          */
          iNumCharsRead += WinLoadString( (HAB) 0, pscript_module,
                                          IDS_DNSCONST2,
                                          CHBUFF_SIZE - iNumCharsRead,
                                          pDlgHdr->pCHBuffer + iNumCharsRead);

          /*
          ** Before entering the option string, make sure that there is enough
          ** room in the buffer for the string.  Otherwise, truncate the
          ** option string.  In the truncation, add two extra bytes for the
          ** ending single quote (') and the period.
          */
          if (strlen( pScanEntryStr ) > CHBUFF_SIZE - iNumCharsRead)
          {
            *(pScanEntryStr + CHBUFF_SIZE - iNumCharsRead - 2) = 0;
          }
          strcat( pDlgHdr->pCHBuffer, pScanEntryStr );
          strcat( pDlgHdr->pCHBuffer, "'." );

          /*
          ** Indicate that the string is already loaded.
          */
          iReturnCtrlID = STRING_ALREADY_LOADED;
          break;
        }
        else
        {
          INCREMENT_BLOCK_PTR( pScanBlock );
          puiScanSel++;
        }
      }
    }
  }
  else
  {
    /*
    ** Duplex is simply not supported, so report it as such.
    */
    iReturnCtrlID = IDS_DNS;
  }

  return( iReturnCtrlID );
}





/******************************************************************************
 *
 * FUNCTION NAME = ListUIItems
 *
 * DESCRIPTION
 * Lists all Translation String entries from a UI_BLOCK in a listbox.  If
 * requested, before the item is selected, the item is compared to other
 * current selections in a Constraint List.  If a constraint exists, then the
 * item is not displayed, otherwise, it is displayed.
 *
 * For Installable Options (displayed in 'Features' in Printer Properties)
 * constraints are not applied, so all items are listed.
 *
 * INPUT
 * hCtrl - Control listbox handle.
 *
 * pDlgHdr - Dialog header structure.
 *
 * pUIBlock - Matching UI_BLOCK to control.
 *
 * fDisplayItem - If TRUE, then the currently selected item is highlighted.
 *   If FALSE, then no item is highlighted.
 *
 * pUIBlock2 - Contains one of the following:
 * - IGNORE_CONSTRAINTS - Do not query the constraint list, display all items.
 * - QUERY_INST_OPT_GROUP - Query other selections only if they are in the
 *   Installable Options group.  Ignore all other selections.  The only
 *   installable options are in the Printer Properties "Features" page.
 * - QUERY_ALL_GROUPS - Query all other selections.
 * - A specific block.  If a specific UI block is provided, then this block
 *   is a catalyst in the search.
 * This is passed into QueryCnstListBlockList().
 *
 * lSearchParam - If pUIBlock2 points to a specific UI_BLOCK, then this should
 *   be one of the following:
 * - BLOCK_SEARCH_AND - Search the constraint list to see if a constraint
 *   exists between pUIBlock AND the specific block (pUIBlock2).
 * - BLOCK_SEARCH_NOT - Search the UI list and constraint list.  Verify if a
 *   constraint exists between pUIBlock and any other block, but NOT the
 *   specific block provided (pUIBlock2).
 * - BLOCK_SEARCH_ALL - Search the entire UI constraint list.
 * This is passed into QueryCnstListBlockList().  If pUIBlock2 is any of the
 * items listed above, or if NULL, this argument is ignored.
 *
 * lItemDisplay - Contains the UI offset to any item that is to be displayed,
 *   whether constraints are applied to it or not.  If you wish to apply
 *   constraints to all items, use DO_NOT_OVERWRITE.
 *
 * For Installable Options, no matter what the value of pUIBlock2 is, it is
 * automatically set to IGNORE_CONSTRAINTS and lSearchParam is ignored.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - Number of items inserted.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
LONG _Optlink ListUIItems( HWND      hCtrl,
                           PDLGHDR   pDlgHdr,
                           PUI_BLOCK pUIBlock,
                           BOOL      fDisplayItem,
                           PUI_BLOCK pUIBlock2,
                           LONG      lSearchParam,
                           LONG      lItemDisplay
                         )
{
  #define SIZE_OF_ITEMS    (sizeof( UI_SEL ) * 8)
  #define STR_BUF_LEN      120

// reduce stack usage (we were running out of netscape's puny stack) by using
// dynamically allocated memory instead of claiming ~4kb of stack here  //@243679
  PGLBITEM   plbItems = NULL;
  PSZ        pstr[ SIZE_OF_ITEMS ];

  PUI_ENTRY pUIEntry;
  UI_SEL    uiSelection;
  LONG      lBlockIndex;
  USHORT    usNumEntries;
  LONG      lItemIndex = 0;
  USHORT    usDefEntry = pUIBlock->usDefaultEntry;    // Default entry
  LONG      lIndexSelected = (LONG) usDefEntry;

  LONG      i;

  // Debugging only.  Display the current block name.
#if IPMD_DISPLAY_UI
  PSZ pBlockName;
  PSZ pEntryName;

  DEBUGQueryBlockName( pDlgHdr, pUIBlock, pBlockName );
#endif

//@243679
// allocate the memory for variables

  // init pstr's to NULL
  for(i=0; i<SIZE_OF_ITEMS; i++)
  {
     pstr[i] = NULL;
  }

  // allocate them
  for(i=0; i<SIZE_OF_ITEMS; i++)
  {
     if((pstr[i] = (PSZ) GplMemoryAlloc( pProcessHeap,
                                                  STR_BUF_LEN )) == NULL)
     {
        // failed... go free those we already allocated
        goto DEALLOC_MEM;
     }
  }

  // allocate for listbox items
  if ((plbItems = (PGLBITEM) GplMemoryAlloc( pProcessHeap,
                                                  sizeof(GLBITEM) * SIZE_OF_ITEMS )) == NULL)
  {
      // failed... go free those we already allocated
      goto DEALLOC_MEM;
  }
//@243679

  /*
  ** For Installable Options, do not query the constraint list.  Installable
  ** Options should have all items displayed so override the caller's
  ** option.
  */
  if (pUIBlock->ucGroupType == UIGT_INSTALLABLEOPTION)
  {
    pUIBlock2 = IGNORE_CONSTRAINTS;
  }

  // Assign a pointer to the starting entry and query the current selection.
  pUIEntry    = pUIBlock->uiEntry;
  uiSelection = (UI_SEL) *(pDlgHdr->pCurrUISelList + pUIBlock->usOrderDep);

  // Remove all current list items.
  WinSendMsg( hCtrl, LM_DELETEALL, NULL, NULL );

  if ((usNumEntries = pUIBlock->usNumOfEntries) > 32)
  {
    usNumEntries = 32;
  }

  // This loop will insert each string in the block.
  for (lBlockIndex = 0 ; lBlockIndex < (LONG) usNumEntries ;
       lBlockIndex++)
  {
    // Debugging - query the current entry string.
    DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock, lBlockIndex,
                                     pEntryName );

    /*
    ** Display the string if the following conditions apply:
    ** 1) If the item is a default item.  Constraints should never be applied
    **    to default items.
    ** ** @CONSTRAINT
    ** ** this no longer is true. Now that automatic constraint
    ** ** removal is in place, we can will still show item constrained if it
    ** ** is default
    ** **
    ** 2) If the calling routing specified this item to be displayed
    **    (lItemDisplay != DO_NOT_OVERWRITE).
    ** 3) For items that do not fall under (1) or (2), then query the
    **    Constraint list.  If a constraint does not apply, display the item.
    */
    if (//lBlockIndex == (LONG) usDefEntry || //@CONSTRAINT remove case (1)
        lBlockIndex == lItemDisplay ||
        QueryCnstListBlockList( pDlgHdr, pUIBlock, lBlockIndex, pUIBlock2,
                                lSearchParam ) == FALSE)
    {
      plbItems[ lItemIndex ].pItem      = (PSZ) (pDlgHdr->pItemsBuff +
                                                pUIEntry->ofsTransString);
      plbItems[ lItemIndex++ ].mpHandle = (MPARAM) lBlockIndex;

      /*
      ** If the caller requested to select an item and the current selection
      ** bit is 1, then select that item.
      */
      if (fDisplayItem == SELECT_ITEM &&
          (uiSelection & 1) != 0)
      {
        lIndexSelected = lBlockIndex;
      }                                       // IF fDisplayItem
    }                                         // IF lBlockIndex
    else
    {
      //@CONSTRAINT
      // Else item is constrained and should be displayed in square brackets

      // add only entries that are "ok" to be shown - some really are meant to be hid. //@VV.241496
      if(QueryConstraintType(pDlgHdr,pUIBlock,lBlockIndex )) //@VV.240744
      {
         strcpy(pstr[lItemIndex],"[");
         strcat(pstr[lItemIndex],(PSZ) (pDlgHdr->pItemsBuff + pUIEntry->ofsTransString));
         strcat(pstr[lItemIndex],"]");
   
         plbItems[ lItemIndex ].pItem      = pstr[lItemIndex];
         plbItems[ lItemIndex++ ].mpHandle = (MPARAM) lBlockIndex;
      }
      //@CONSTRAINT
    }

    // Go to the next entry.
    pUIEntry++;

    // Shift the bits in the selection.
    uiSelection >>= 1;
  }                                           // FOR lBlockIndex

  // Insert the items in the listbox.
  GplCtrlLBInsertItems( hCtrl, 0, plbItems, lItemIndex, LIT_END,
                        pscript_module, 0 );

  /*
  ** Highlight the current item.  If none is highlighted, the default item
  ** will be highlighted.
  */
  if (fDisplayItem == SELECT_ITEM)
  {
    GplCtrlLBSelectItem( hCtrl, 0, (MPARAM) lIndexSelected,
                         GLF_SELECTHANDLE );
  }

DEALLOC_MEM:
// free allocated memory //@243679
   for(i=0; i<SIZE_OF_ITEMS; i++)
   {
      if(pstr[i]) GplMemoryFree(pstr[i]);
   }

   if(plbItems) GplMemoryFree(plbItems);

  return( lItemIndex );
}





/******************************************************************************
 *
 * FUNCTION NAME = QueryCnstListBlockList
 *
 * DESCRIPTION
 * With a given UI block, this function compares the current block against all
 * the other blocks in the UI list to see if a constraint exists.
 *
 * INPUT
 * pDlgHdr - Dialog header.
 * pUIBlock1 - First UI_BLOCK to compare.
 * lBlockSel - Zero-based offset of the current UI_ENTRY selected in the
 *   block.
 * pUIBlock2 - Contains one of the following:
 * - IGNORE_CONSTRAINTS - Do not query the constraint list, display all items.
 * - QUERY_INST_OPT_GROUP - Query other selections only if they are in the
 *   Installable Options group.  Ignore all other selections.  The only
 *   installable options are in the Printer Properties "Features" page.
 * - QUERY_ALL_GROUPS - Query all other selections.
 * - A specific block.  If a specific UI block is provided, then this block
 *   is a catalyst in the search.
 * lSearchParam - If a specific block is provided, then it should be one of
 *   the following:
 * - BLOCK_SEARCH_AND - Search the constraint list to see if a constraint
 *   exists between pUIBlock AND the specific block.
 * - BLOCK_SEARCH_NOT - Search the UI list and constraint list.  Verify if a
 *   constraint exists between pUIBlock and any other block, but NOT the
 *   specific block provided.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE - Constraint exists.
 *                 FALSE - No constraint exists.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
BOOL _Optlink QueryCnstListBlockList( PDLGHDR   pDlgHdr,
                                      PUI_BLOCK pUIBlock1,
                                      LONG      lBlock1Sel,
                                      PUI_BLOCK pUIBlock2,
                                      LONG      lSearchParam
                                     )
{
  LONG      lBlockList;
  LONG      lGroupType = UIGT_DEFAULTOPTION;
  PUI_BLOCK pBlockNOT = NULL;
  PUI_BLOCK pUIBlockList = pDlgHdr->pdesPPD->stUIList.pBlockList;
  LONG      lNumOfBlocks = (LONG) pDlgHdr->pdesPPD->stUIList.usNumOfBlocks;
  PUI_SEL   pUISel = pDlgHdr->pCurrUISelList;
  BOOL      fRC = FALSE;

#if IPMD_DISPLAY_UI
  PSZ pBlock1Str;
  PSZ pBlockListStr;
  PSZ pBlockNOTStr;
  PSZ pEntryStr;

  DEBUGQueryBlockName( pDlgHdr, pUIBlock1, pBlock1Str );
  DEBUGQueryCurrentBlockEntryName( pDlgHdr, pUIBlock1, lBlock1Sel, pEntryStr );
#endif

  if (pUIBlock2 == QUERY_INST_OPT_GROUP)
  {
    lGroupType = UIGT_INSTALLABLEOPTION;
    lSearchParam = BLOCK_SEARCH_ALL;
  }
  else if (pUIBlock2 == QUERY_ALL_GROUPS)
  {
    lSearchParam = BLOCK_SEARCH_ALL;
  }
  else if (pUIBlock2 == IGNORE_CONSTRAINTS)
  {
    return( FALSE );
  }

  if (lSearchParam == BLOCK_SEARCH_AND)
  {
    lNumOfBlocks = 1;
    pUIBlockList = pUIBlock2;
    pBlockNOT    = pUIBlock1;
    pUISel       = pDlgHdr->pCurrUISelList + pUIBlock2->usOrderDep;
  }
  else if (lSearchParam == BLOCK_SEARCH_NOT)
  {
    pBlockNOT = pUIBlock2;
  }

  DEBUGQueryBlockName( pDlgHdr, pBlockNOT, pBlockNOTStr );

  for (lBlockList = 0 ; lBlockList < lNumOfBlocks && fRC == FALSE ;
       lBlockList++)
  {

    DEBUGQueryBlockName( pDlgHdr, pUIBlockList, pBlockListStr );

    if (pUIBlockList != pUIBlock1 && pUIBlockList != pBlockNOT &&
        pUIBlockList->ucGroupType >= (UCHAR) lGroupType)
    {
      fRC = QueryCnstListBlock( pDlgHdr, pUIBlock1, lBlock1Sel,
                                pUIBlockList, *pUISel );
    }                                   // IF pUIBlockList != pUIBlock1

    INCREMENT_BLOCK_PTR( pUIBlockList );
    pUISel++;
  }                                     // FOR lBlockList

  return( fRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = QueryCnstListBlock
 *
 * DESCRIPTION
 * With two given UI_BLOCK offsets, compares them to see if a constraint
 * exists between the two.  This is determined by comparing them against the
 * list of constraints (UIC_BLOCK).  If a constraint exists between the two,
 * then TRUE is returned.
 *
 * INPUT
 * pDlgHdr - Dialog header.
 * pUIBlock1 - First UI_BLOCK to compare.
 * lSelect1 - Zero-based offset of the current UI_ENTRY selected in the
 *   block.  If lBlockSelect == -1, then query for all possible UI_ENTRY
 *   selections for pUIBlock1.  This does *NOT* contain the UI_SEL value, but,
 *   rather, an offset.  For example, if the first item was selected, 0 would
 *   be this value.  If the second item was selected, 1 would be the value,
 *   etc.
 * pUIBlock2 - Second UI_BLOCK to compare.
 * uiSelect2 - Current UI_SEL value of the second block.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE - Constraint exists.
 *                 FALSE - No constraint exists.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
BOOL _Optlink QueryCnstListBlock( PDLGHDR   pDlgHdr,
                                  PUI_BLOCK pUIBlock1,
                                  LONG      lSelect1,
                                  PUI_BLOCK pUIBlock2,
                                  UI_SEL    uiSelect2
                                )
{
  LONG       lCnstIndex;
  UI_SEL     uiSelect1;
  LONG       lNumOfCnsts = (LONG) pDlgHdr->pdesPPD->stUICList.usNumOfUICs;
  PUIC_BLOCK pUICCurr = pDlgHdr->pdesPPD->stUICList.puicBlockList;
  LONG       ofsBlock1 = (LONG) pUIBlock1->usOrderDep;
  LONG       ofsBlock2 = (LONG) pUIBlock2->usOrderDep;
  BOOL       fRC = FALSE;

#if IPMD_DISPLAY_UI
  PSZ pszBlock1String;
  PSZ pszBlock2String;
  PSZ pUICCurr1String;
  PSZ pUICCurr2String;

  DEBUGQueryBlockName( pDlgHdr, pUIBlock1, pszBlock1String );
  DEBUGQueryBlockName( pDlgHdr, pUIBlock2, pszBlock2String );
#endif

  /*
  ** If lSelect1 is greater than or zero, then a specific selection was set
  ** and to query all constraints for that selection.  Otherwise, set all
  ** UI Selector bits to 1 to query all possible selections.
  */
  if (lSelect1 >= 0)
  {
    uiSelect1 = CONVERT_OFS_TO_UISEL( lSelect1 );
  }
  else
  {
    uiSelect1 = (UI_SEL) -1;
  }

  for (lCnstIndex = 0 ; lCnstIndex < lNumOfCnsts && fRC == FALSE ;
       lCnstIndex++)
  {
    DEBUGQueryConstraintEntry( pDlgHdr, &pUICCurr->uicEntry1, pUICCurr1String );
    DEBUGQueryConstraintEntry( pDlgHdr, &pUICCurr->uicEntry2, pUICCurr2String );

    /*
    ** If a constraint exists, fRC will be TRUE.
    */
    fRC = QueryConstraintBlock( pUICCurr, ofsBlock1, uiSelect1, ofsBlock2,
                                uiSelect2 );

    // Go to the next constraint entry.
    pUICCurr++;
  }                                    // FOR lCnstIndex

  return( fRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = QueryConstraintBlock
 *
 * DESCRIPTION
 * A constraint in the PPD is in the following format:
 *
 *  *UIConstraint  keyword11 [option1] keyword2 [option2]
 *
 * This means that if keyword1-option1 is selected, do not display
 * keyword2-option2 and visa versa.
 *
 * This function compares two UIC_ENTRYs to see if a constraint exists.  Each
 * UIC_ENTRY represents a keyword-option combination.
 *
 * Since constraints can be valid for keyword1-keyword2 as well as keyword2-
 * keyword1, the function cqQueryCurrentConstraint is called with the keywords
 * reversed to verify if a constraint exists.
 *
 * If a constraint exists, the function returns TRUE.  Otherwise, FALSE is
 * returned.
 *
 * INPUT
 * pUICBlock - Current query constraint block.
 * ofsBlock1 - Offset of first UI_BLOCK, in reference to the entire UI list.
 *   If you have the UI_BLOCK pointer, you can use 'PUI_BLOCK->usOrderDep' for
 *   'usOrderDep' contains this value.
 * uiSel1 - Doubleword containing possible constraint entries.  Each bit in
 *   this argument represents a UI entry.  If set, then the entry contains a
 *   constraint from the PPD.
 * ofsBlock2 - Offset of second UI_BLOCK, in reference to the entire UI list.
 *   The same applies here as with 'ofsBlock1'.
 * uiSel2 - Doubleword containing possible constraint entries.  Each bit in
 *   this argument represents a UI entry.  If set, then the entry contains a
 *   constraint from the PPD.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE - Constraint exists.
 *                 FALSE - No constraint exists.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
BOOL _Optlink QueryConstraintBlock( PUIC_BLOCK pUICBlock,
                                    LONG       ofsBlock1,
                                    UI_SEL     uiSel1,
                                    LONG       ofsBlock2,
                                    UI_SEL     uiSel2
                                  )
{
  BOOL fRC;

  if ((fRC = QueryCurrentConstraint( pUICBlock,
                                     ofsBlock1,
                                     uiSel1,
                                     ofsBlock2,
                                     uiSel2)) == FALSE)
  {
    fRC = QueryCurrentConstraint( pUICBlock,
                                  ofsBlock2,
                                  uiSel2,
                                  ofsBlock1,
                                  uiSel1);
  }

  return( fRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = QueryCurrentConstraint
 *
 * DESCRIPTION
 * Compares both UIC_ENTRYs in a given UIC_BLOCK.  If a constraint exits, the
 * function returns TRUE, otherwise, FALSE is returned.
 *
 * INPUT
 * pUICBlock - Current query constraint block.
 * ofsBlock1 - Offset of first UI_BLOCK, in reference to the entire UI list.
 * uiSel1 - Doubleword containing possible constraint entries.  Each bit in
 *   this argument represents a UI entry.  If set, then the entry contains a
 *   constraint from the PPD.
 * ofsBlock2 - Offset of second UI_BLOCK, in reference to the entire UI list.
 * uiSel2 - Doubleword containing possible constraint entries.  Each bit in
 *   this argument represents a UI entry.  If set, then the entry contains a
 *   constraint from the PPD.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE - Constraint exists.
 *                 FALSE - No constraint exists.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
BOOL _Optlink QueryCurrentConstraint( PUIC_BLOCK pUICBlock,
                                      LONG       ofsBlock1,
                                      UI_SEL     uiSel1,
                                      LONG       ofsBlock2,
                                      UI_SEL     uiSel2
                                    )
{
  PUIC_ENTRY pUICEntry1 = &pUICBlock->uicEntry1;
  PUIC_ENTRY pUICEntry2 = &pUICBlock->uicEntry2;
  BOOL       fRC = FALSE;

  if (pUICEntry1->ofsUIBlock == (USHORT) ofsBlock1 &&
      (pUICEntry1->bOption & uiSel1))
  {
    if (pUICEntry2->ofsUIBlock == (USHORT) ofsBlock2 &&
        (pUICEntry2->bOption & uiSel2))
    {
      fRC = TRUE;
    }
  }

  return( fRC );
}





PDLGHDR InitDlgULong( HWND hDlg, MPARAM mp2 )
{
  PDLGHDR pDlgHdr = (PDLGHDR) mp2;

  WinSetWindowULong( hDlg, QWL_USER, (ULONG) pDlgHdr );

  return( pDlgHdr );
}





/******************************************************************************
 *
 * FUNCTION NAME = InitializeUIInstOpt
 *
 * DESCRIPTION
 * Each UI_BLOCK structure contains two fields that are important to this
 * function:
 * PUI_BLOCK->ucGroupType - This contains ONE of the following:
 * - UIGT_INSTALLABLEOPTION - This means that the UI is an installable option.
 *   An installable option is displayed in the Printer Properties "Features"
 *   page.  An installable option contains optional hardware settings for the
 *   device.  This option overrides all other related options.  For example,
 *   if a device supports optional duplex and duplex is set to "2 page flip",
 *   if duplex is turned off in Printer Properties - Features, then duplex
 *   is disabled in Job Properties.  This way of enabling/disabling features
 *   is called constraints.
 * - UIGT_DEFAULTOPTION - This is the standard option and these UI's are
 *   displayed everywhere else except in Printer Properties "Features" page.
 *   These contain unique device settings.  These are also called standard
 *   options.
 * PUI_BLOCK->ucPanelID - For this function, we will concentrate on
 * UIP_PREDEF_FEATURE.  This flag means that the UI is a predefined feature.
 * A predefined feature is:
 * - A feature that is NOT displayed in any "Features" page (Job or Printer
 *   Prop).  This UI will be displayed in another page.  Three examples of
 *   predefined features are duplex, form name, and resolution.  Notice that
 *   they are not listed in the "Features" page.
 * - A predefined feature was included in the old driver.  This is the reason
 *       they are not in "Features".  For backward compatibility, they were
 *   kept in the same format that existed in the old driver.  Therefore, any
 *   UI listed in "Features" was not included in the original driver.
 *
 * The old driver did not support installable options.  Therefore, the new
 * driver should initialize assumming that all hardware settings are enabled
 * so that, from the user's point of view, all predefined feature settings
 * will be enabled, just like in the old driver.
 *
 * In order to do this, if installing over an old driver, or initializing a
 * new one, all installable option features must be initialized to enable all
 * settings.  Since most (if not all) installable options are set to a default
 * value of DISABLE, this function must manually enable all inst. opt.
 *
 * This function runs through the list of UI_BLOCK's.  Every time it comes
 * across an installable option (UIGT_INSTALLABLEOPTION), another pointer
 * starts at the top of the UI list and searches for any standard options
 * (UIGT_DEFAULTOPTION).  A compare is made against an installable option
 * and a default option that is also a predefined feature.  The compare
 * verifies if a constraint exist between the two UI's (via
 * QueryCnstListBlock( )).  If a constraint exists, then that means that if
 * the inst. opt. is disabled, than the standard option cannot be selected.
 * Therefore, the inst. opt. is set so that there is NO constraint between
 * the two.  This means that the std. option may be enabled (see
 * ModifyUIInstOpt()).
 *
 *     include predefined features?  As mentioned before, predefined features
 * were included in the old driver.  Any options listed in "Features" were
 * not in the old driver.  Predefined features were the only ones compared
 * to reduce any possibility of conflicts that may arise between multiple
 * standard options and a single installable option.  Example:  Suppose you
 * have an installable option (called I) and two standard options (called S1
 * and S2).  Suppose that the first selection in I disables S1 and the second
 * selection in I disables S2.  This causes a conflict.  However, if S1 is
 * a predefined feature, then it doesn't matter what happens to S2.  As long
 * as S1 is enabled, it's fine.  Conflicts are unlikely to arise between two
 * predefined features.
 *
 * This function verifies the existance of an old driver or no driver by
 * searching for the "UI" key in the INI file.  If this key does not exist,
 * then one of two possibilities exist:
 * - This driver is being initialized for the first time.  In this case, it is
 *   still wise to enable all options and let the user turn them off later.
 * - The current driver is being installed over an old version.  The old
 *   version did not use the "UI" key in the INI.
 *
 * INPUT
 * pDlgHdr - Dialog header structure.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - TRUE - The INI does not exist.
 *                 FALSE - The INI exists.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
BOOL InitializeUIInstOpt( PDLGHDR pDlgHdr
                        )
{
  PUI_BLOCK pCurrInstOptBlock;
  PUI_BLOCK pCurrStdBlock;
  ULONG     ulInstOptLoop;
  ULONG     ulDefOptLoop;
  PCNFDATA  pCNFData = pDlgHdr->pCNFData;
  PDESPPD   pdesPPD = pDlgHdr->pdesPPD;
  ULONG     ulNumOfBlocks = (ULONG) pdesPPD->stUIList.usNumOfBlocks;
  PUI_SEL   pUISelList = pDlgHdr->pCurrUISelList;
  BOOL      fRC = FALSE;

#if IPMD_DISPLAY_UI
  PSZ pszInstOptBlockStr;
  PSZ pszCurrStdBlockStr;
#endif

  /*
  ** In order to initialize all installable options, the "UI" key in the INI
  ** file must NOT exist.  This will happen if an older driver is being used,
  ** or if no INI data exists.  If the "UI" key exists, then all is up-to-date,
  ** so do not update.
  */
  if (!PrfQueryProfileSize( HINI_SYSTEMPROFILE, (PSZ) pCNFData->szKeyApp,
                            INI_KEY_UI, &ulInstOptLoop ))
  {
    pCurrInstOptBlock = pdesPPD->stUIList.pBlockList;

    /*
    ** This loop will run through all UI blocks in the list.  At this point,
    ** we are looking for all installable options (UIGT_INSTALLABLEOPTION).
    */
    for (ulInstOptLoop = 0 ; ulInstOptLoop < ulNumOfBlocks ; ulInstOptLoop++)
    {
      // Installable option?
      if (pCurrInstOptBlock->ucGroupType == UIGT_INSTALLABLEOPTION)
      {

#if IPMD_DISPLAY_UI
        DEBUGQueryBlockName( pDlgHdr, pCurrInstOptBlock, pszInstOptBlockStr );
#endif

        pCurrStdBlock = pdesPPD->stUIList.pBlockList;

        /*
        ** This loop will run through the block list just like ulInstOptLoop.
        ** However, here we are looking for non-installable options/predefined
        ** features.  The pointer in this loop will be compared against
        ** pCurrInstOptBlock.
        */
        for (ulDefOptLoop = 0 ; ulDefOptLoop < ulNumOfBlocks ; ulDefOptLoop++)
        {
          /*
          ** Is this block standard, predefined option?
          */
          if (pCurrStdBlock->ucGroupType == UIGT_DEFAULTOPTION &&
              pCurrStdBlock->ucPanelID == UIP_PREDEF_FEATURE)
          {

#if IPMD_DISPLAY_UI
            DEBUGQueryBlockName( pDlgHdr, pCurrStdBlock, pszCurrStdBlockStr );
#endif

            /*
            ** Compare the installable option (pCurrInstOptBlock) with the
            ** standard block (pCurrStdBlock).  If a constraint exists (TRUE),
            ** then we need to modify the installable option until a constraint
            ** does NOT exist.  -1 means to compare all possible selections
            ** in pCurrStdBlock.
            */
            if (QueryCnstListBlock( pDlgHdr,
                                    pCurrStdBlock, (UI_SEL) -1,
                                    pCurrInstOptBlock,
                                    (UI_SEL) *(pUISelList +
                                      pCurrInstOptBlock->usOrderDep) )
                == TRUE)
            {
              *(pUISelList + pCurrInstOptBlock->usOrderDep) =
                ModifyUIInstOpt( pDlgHdr, pCurrInstOptBlock, pCurrStdBlock,
                                 *(pUISelList + pCurrStdBlock->usOrderDep) );
            }
          }                                // IF UIGT_DEFAULTOPTION

          INCREMENT_BLOCK_PTR( pCurrStdBlock );
        }                                  // FOR ulDefOptLoop
      }                                    // IF UIGT_INSTALLABLEOPTION

      INCREMENT_BLOCK_PTR( pCurrInstOptBlock );
    }                                      // FOR ulInstOptLoop

    fRC = TRUE;
  }                                        // IF PrfQueryProfileSize()

  return( fRC );
}





/******************************************************************************
 *
 * FUNCTION NAME = ModifyUIInstOpt
 *
 * DESCRIPTION
 * This function compares the current selection of the standard UI with all
 * possible selections in the Installable Option UI.  If a constraint does not
 * exist, then the selection for the Installable option is returned.
 *
 * INPUT
 * pDlgHdr - Dialog header structure.
 * pInstOptBlock - Pointer to the current Installable option UI block.
 * pStdBlock - Pointer to the standard option UI block.
 * uiStdSel - UI_SEL value containing the current selection for pStdBlock.
 *
 * OUTPUT
 * None.
 *
 * RETURN-NORMAL - The Installable Option value that does not constrain the
 *                 current standard block selection, in UI_SEL format.
 * RETURN-ERROR  - None
 *
 *****************************************************************************/
UI_SEL ModifyUIInstOpt( PDLGHDR   pDlgHdr,
                        PUI_BLOCK pInstOptBlock,
                        PUI_BLOCK pStdBlock,
                        UI_SEL    uiStdSel
                      )
{
  LONG   lInstOptLoop;
  UI_SEL uiSelRC = 1;

  /*
  ** We need to run through each entry in the Installable Option block
  ** (pInstOptBlock).  We need to compare each entry against the current
  ** standard entry until a constraint is not encountered.
  */
  for (lInstOptLoop = 0 ; lInstOptLoop < (LONG) pInstOptBlock->usNumOfEntries ;
       lInstOptLoop++)
  {
    /*
    ** Query the constraint against the current standard selection (uiStdSel)
    ** and the temporary installable option selection (uiSelRC).  If a
    ** constraint does not exist (FALSE) , break out of the loop and return
    ** the value.  If a constraint exists (TRUE), then increment the selection
    ** bit and try again.
    */
    if (QueryCnstListBlock( pDlgHdr, pStdBlock, -1, pInstOptBlock,
                            uiSelRC ) == FALSE)
    {
      break;
    }
    else                    // Constraint exists
    {
      uiSelRC <<= 1;
    }
  }

  /*
  ** At this point, if a constraint exists for all selections, then set the
  ** value to the default and return it.  If this case happens, then there is
  ** an error in the PPD since the PPD MUST provide at least on scenerio in
  ** which a constraint does not exist.
  */
  if (lInstOptLoop >= (LONG) pInstOptBlock->usNumOfEntries)
  {
    uiSelRC = (UI_SEL) (1 << pInstOptBlock->usDefaultEntry);
  }

  return( uiSelRC );
}





LONG APIENTRY QueryFeaturePageLoad( PDLGHDR pDlgHdr )
{
  LONG      lLoop;
  LONG      lUIGroupType;
  PUI_BLOCK pUIBlock = pDlgHdr->pdesPPD->stUIList.pBlockList;
  LONG      lNumOfBlocks = (LONG) pDlgHdr->pdesPPD->stUIList.usNumOfBlocks;
  LONG      lRC = GDPF_DO_NOT_INSERT;

  /*
  ** First, set the group type ID that is to be queried.  For Printer
  ** Properties (DPDM_CHANGEPROP), the group type is UIGT_INSTALLABLEOPTION.
  ** For Job Properties, the group type is UIGT_DEFAULTOPTION.
  */
  if (pDlgHdr->uiPropertyType == DPDM_CHANGEPROP)
  {
    lUIGroupType = UIGT_INSTALLABLEOPTION;
  }
  else                       // DPDM_POSTJOBPROP - Job Properties
  {
    lUIGroupType = UIGT_DEFAULTOPTION;
  }

  /*
  ** This loop runs through the entire list of blocks, comparing group ID's.
  ** If an ID match is found, break out of the loop and return TRUE.  This
  ** means that at least one block exists that needs to be displayed in the
  ** "Features" page, so display that page.
  ** This only includes standard UI blocks (UIP_OS2_FEATURE).  OEM blocks
  ** (UIP_OEM_FEATURE) are to be displayed on an OEM page and
  ** UIP_PREDEF_FEATURE blocks are to be displayed on other pages.
  */
  for (lLoop = 0 ; lLoop < lNumOfBlocks ; lLoop++)
  {
    /*
    ** Match?  Then set the return code to TRUE and break out.
    */
    if (pUIBlock->ucGroupType == (UCHAR) lUIGroupType &&
        pUIBlock->ucPanelID == UIP_OS2_FEATURE)
    {
      lRC = JPNB_DLG_UI;
      break;
    }

    INCREMENT_BLOCK_PTR( pUIBlock );
  }

  return( lRC );
}
/*---------------------------------------------------------------------------*\
* QueryFeaturePageLoad End                                                    *
\*---------------------------------------------------------------------------*/





/*****************************************************************************\
** The following code is used only for debugging.                            **
** If you wish to disable this code during debugging, IPMD_DISPLAY_UI is     **
** located in PPDIALOG.H.  Remove it to disable all debug code.              **
\*****************************************************************************/
#if IPMD_DISPLAY_UI
PSZ DebugQueryConstraintEntry( PDLGHDR    pDlgHdr,
                               PUIC_ENTRY pUICEntry
                             )
{
  PUI_BLOCK pBlock;
  UI_SEL    uiSel;
  LONG      ofsEntry;
  LONG      lNumFound;
  PSZ       pCnstTSName;
  PSZ       pCnstName = NULL;
  PSZ       pCnstEntryName = NULL;

  if (pDlgHdr != NULL && pUICEntry != NULL)
  {
    /*
    ** With the given UIC entry, query the matching block name.
    */
    if (( pBlock = DebugQueryUIBlock( pDlgHdr, (LONG) pUICEntry->ofsUIBlock ))
        != NULL)
    {
      /*
      ** Query the matching block string.  Also, assign the UI selector of the
      ** given block to a local variable.
      */
      pCnstName   = DebugQueryBlockName( pDlgHdr, pBlock );
      pCnstTSName = (PSZ) (pDlgHdr->pItemsBuff + pBlock->ofsUITransString);
      uiSel       = *(pDlgHdr->pCurrUISelList + pBlock->usOrderDep);

      /*
      ** Each bit in the UI selector (uiSel) corresponds to an entry in the
      ** UI block.  Bit 0 represents the first UI entry.  If the bit is set,
      ** then the entry has been selected.  In the case of constraints, if a
      ** bit is set, then a constraint exists between this entry and another
      ** (not given here).  Run through each bit in the selector in the UI
      ** selector.  If a bit is set, then display the appropriate entry
      ** string.
      */
      ofsEntry = 0;
      lNumFound = 0;
      while (uiSel > 0)
      {
        if (uiSel & 1)
        {
          pCnstEntryName = (PSZ) (pDlgHdr->pItemsBuff +
                                  pBlock->uiEntry[ ofsEntry ].ofsOption);
          lNumFound++;
        }
        ofsEntry++;
        uiSel >>= 1;
      }
    }
  }

  return( pCnstName );
}





PSZ DebugQueryBlockName( PDLGHDR   pDlgHdr,
                         PUI_BLOCK pUIBlock
                       )
{
  PSZ pTransString;
  PSZ pRC;

  if (pDlgHdr != NULL && pUIBlock != NULL)
  {
    pRC          = (PSZ) (pDlgHdr->pItemsBuff + pUIBlock->ofsUIName);
    pTransString = (PSZ) (pDlgHdr->pItemsBuff + pUIBlock->ofsUITransString);
  }
  else
  {
    pRC = NULL;
  }

  return( pRC );
}





PUI_BLOCK DebugQueryUIBlock( PDLGHDR pDlgHdr,
                             LONG    ofsBlock
                           )
{
  PUI_BLOCK pRC = NULL;

  /*
  ** Do not continue if an invalid offset was provided or if pDlgHdr is NULL.
  */
  if (ofsBlock < (LONG) pDlgHdr->pdesPPD->stUIList.usNumOfBlocks &&
      pDlgHdr != NULL)
  {
    /*
    ** Assign the return pointer to the beginning of the block list.
    */
    pRC = pDlgHdr->pdesPPD->stUIList.pBlockList;

    /*
    ** This loop will increment pRC a number of offset values.
    */
    while (ofsBlock > 0)
    {
      INCREMENT_BLOCK_PTR( pRC );
      ofsBlock--;
    }
  }

  return( pRC );
}





PSZ DebugQueryCurrentBlockEntryName( PDLGHDR pDlgHdr,
                                     PUI_BLOCK pUIBlock,
                                     LONG lBlockSelected
                                   )
{
  PSZ pRC = NULL;

  if (pDlgHdr != NULL && pUIBlock != NULL)
  {
    if (lBlockSelected < (LONG) pUIBlock->usNumOfEntries)
    {
      pRC = (PSZ) (pDlgHdr->pItemsBuff +
                   pUIBlock->uiEntry[ lBlockSelected ].ofsOption);
    }
    else
    {
      GplErrSetError( -1 );
    }
  }
  return( pRC );
}
#endif
/*****************************************************************************\
** END DEBUG CODE                                                            **
\*****************************************************************************/

