/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DEVESC.C
 *
 * DESCRIPTIVE NAME = This file contains DEVESC functions and support routines.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION Contains driver escape routines.
 *
 *
 * FUNCTIONS
 *
 * FUNCTION NAME = prdq_Escape  This routine dispatches off to the appropriate
 *                                escape function.
 *
 *                 prdq_QueryEscSupport This routine returns TRUE or FALSE
 *                                telling whether the given escape routine is
 *                                supported by the driver.
 *
 *                 prdq_StartDoc  This routine starts a document.
 *
 *                 prdq_EndDoc    This routine ends a document.
 *
 *                 prdq_AbortDoc  This routine aborts a document.
 *
 *                 prdq_NewFrame  Handles the DEVESC_NEWFRAME call;
 *
 *                 prdq_CharExtra Handles the DEVESC_CHAREXTRA call.  Sets extra
 *                                spacing for non-break characters.
 *
 *                 prdq_BreakExtra Handles the DEVESC_BREAKEXTRA call.  Sets
 *                                extra spacing for break characters.
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#pragma pack(1)
#define  INCL_SPLERRORS
#define  INCL_DOSMODULEMGR                                         //@V3.1147985
#define  INCL_PMSPL
#include "inc\prdinclt.h"
#include "inc\prdmath.h"
#define  INCL_DEV
#define  INCL_SPLFSE
#include <pmdev.h>
#include "inc\prdgextf.h"
#include "inc\prdqextf.h"
#include "inc\prdtextf.h"
#include "inc\utl.h"
#include <pmspl.h>
#include "inc\pspagtun.h"              /* V2.174057   Page Tuning */
#include "inc\usermacr.h"                                               //@DBCS
#include "inc\psdjp.h"                                                  //@DJP
#define  INCL_GENPLIB_ERROR
#define  INCL_GENPLIB_MEMORY
#define  INCL_GENPLIB_FONTSUB
#include <genplib.h>
#include "inc\init.h"                                            // @V3.1142031
#include <stdio.h>
#include <string.h>
#include "inc\uinames.h"                                         // @MIXED_FEED

/* @V3.1137972 start */
#define CCITT_G4_COMPRESSION  0x0500
#define  FIXED_255            0x00ff0000
#define  FIXED_9              0x00090000
#define  FIXED_1              0x00010000
#define  FIXED_40             0x00280000
#define  FIXED_NINETENTH      0x0000E666
#define  FIXED_TENTH          0x00001999
#define  COMPRESS_RLL_MODE    0x8000
#define  INQUIRE_ON_ONE_MODE  -1
#include "inc\prdcextf.h"   /* for prdc_GetColor   */
SHORT prdq_QueryEscSupport( ULONG, PDDC );
SHORT DevEscQueryRaster( PDDC, ULONG, PULONG, PULONG, PULONG );
SHORT DevEscBeginBITBLT( PDDC, ULONG, PULONG, PULONG, PULONG );
SHORT DevEscEndBITBLT( PDDC, ULONG, PULONG, PULONG, PULONG );
extern INT PalGray( RGB *, PBYTE);
/* @V3.1137972 end   */

extern VOID play_clip_rects(HDC,PDDC );

extern BOOL   RemapCodePage(PDDC,SHORT,SHORT,PSZ ); /* fonts.c */
extern VOID   ps_patfill_common(PDDC ); /* patfill.c */
extern VOID   ps_patfill_base(PDDC ); /* patfill.c */
extern VOID   ps_patfill_font( PDDC ); /* patfill.c */
extern VOID   SFDownload(PDDC,PSZ ); /* download.c */
extern BOOL   utl_MemIsEqual(PB,PB,int );
extern BOOL   IsDBCSChar(PDDC, UCHAR); /* utlps.c */                    //@DBCS
extern PBYTE  QueryUIOptionString( PDESPPD, PUI_SEL, PBYTE, PINT, PUI_BLOCK * );
extern INT    SetUIOption( PDESPPD, PUI_SEL, PBYTE, PBYTE );
extern VOID   PSDocSetUp( PDDC, BOOL );
extern VOID   NupSetUp( PDDC );                                         //Nup

USHORT perform_std_spooling( HDC, PDDC );

extern PDDC EnterDriver(PDDC );
extern VOID ExitDriver(PDDC );
#define  DEVESC_INTCHARWIDTH 16997
#define  DEVESC_DEBUG  17000
#define  FX_100        6553600L
#define  OD_MEMORY  8L

extern CHAR achEOF[];   

extern ULONG ULGreVersion;                                               //@DJP
VOID   IncPagesSpooled( PDDC );                                   //@V3.1147985
VOID   IncPagesPrinted( PDDC );                                   //@V3.1147985
SHORT  DevEscGetJobID( PDDC, ULONG, PULONG, PULONG, PULONG );
SHORT  DataOut( PDDC, ULONG, PULONG );                                   //@DEM

/* @V3.1147985
** These addresses should be in per process space
** >>>>>>They are defined in memory.c<<<<<<
**
** Put the Vars with the new spooler entry points here
** Use LoadNewSpoolerCalls to load them
*/
extern PFN pfnSplQmGetJobID;   /* Function Address to SplQmGetJobID */
extern PFN pfnPrtNewPage;
extern VOID PSNup( PDDC );     //Nup printing
extern VOID FontResourceDownload( PDDC, ULONG );                         //@RES
extern VOID ResProcessEndPage( PDDC );                                   //@RES
extern BOOL OpenQueueChannel( PDDC pddc );

extern PVOID pProcessHeap;


#define EOFSIZE 3;      /* Do not include the trailing zero */
/***************************************************************************
 *
 * FUNCTION NAME = prdq_Escape
 *
 *
 * DESCRIPTION   = This routine dispatches off to the appropriate escape function.
 *
 * INPUT         = NONE
 *
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = NONE
 *
 *
 * RETURN-ERROR  = NONE
 *
 *
 *
 **************************************************************************/

ULONG prdq_Escape( HDC hdc, ULONG ulEscCode, ULONG InCount, ULONG *pInData,
                   ULONG *pOutCount, ULONG *pOutData, PDDC pddc, ULONG FunN)

  /* HDC hdc;                              The DC handle                     */
  /* PDDC pddc;                            Ptr to the DC instance data       */
{
  SHORT    Result;                        /* Subfunction Result              */
  FIXED    fxScale;                       /* FIXED scale factor.             */
  ULONG    ulRet;
  PDV      pdv = pddc->pdv;
  PCNFDATA pCNFData = pdv->pCNFData;                             // @V3.1142031
  REFDATA  RefData;                                                      //@DJP


  EnterDriver( pddc );

  #if      DEBUG
    LogCall( "prdq_Escape(%08lx, %ld, %ld, %lp, %lp, %lp, %lp, %ld)", ((PB)&hdc)+
             sizeof(hdc) );
  #endif                                 /* DEBUG */

  if (pddc->iType == OD_MEMORY)
  {
    ulRet = InnerGreEscape (pddc->hdcMemory, ulEscCode, InCount,
                            pInData, pOutCount, pOutData, FunN );
    ExitDriver( pddc );
    return( ulRet );
  }

  /*
  ** Select function according to ArgEscape.
  */
//switch ((SHORT) ulEscCode)                                             //@DJP
  switch ( ulEscCode )                                                   //@DJP
  {
  case DEVESC_STARTDOC:
       Result = prdq_StartDoc( hdc, pddc, (PSZ) pInData, (LONG) InCount );
       break;

  case DEVESC_ENDDOC:
       Result = prdq_EndDoc( hdc, pddc, (PSHORT) pOutData, (PLONG) pOutCount );
       break;

  case DEVESC_NEWFRAME:
       Result = prdq_NewFrame( hdc, pddc );
       break;

  case DEVESC_ABORTDOC:
       Result = prdq_AbortDoc( hdc, pddc );
       break;

  case DEVESC_SETABORTPROC:                                              //@SAP
       // Records the address to call back to the windows driver when the
       // driver is going to be busy for long time ex bitblt

       if ( InCount != sizeof( SETABORTPROC ) )   // Verify size
       {
         Result = ERROR_INVALID_PARAMETER;        // Error
       }
       else
       {
         pddc->pdv->SetAbortProc = *((PSETABORTPROC)pInData);
         Result = DEV_OK;
       }
       break;

  case DEVESC_FLUSHOUTPUT:
       /*
       ** Flushing the channel is now handled by GENPLIB.
       */
#if 0
//     FlushChannel( pddc );
#endif
       if (pdv->hThread)
       {
         GplThreadFlushBuffer( pdv->hThread, TRUE );
       }
       Result = ps_status( pddc );
       break;

  case DEVESC_DEBUG:
#if 0
//     FlushChannel( pddc );
#endif
       if (pdv->hThread)
       {
         GplThreadFlushBuffer( pdv->hThread, TRUE );
       }
       PrintChannel( pddc, (PSZ)"\n%% %ls\n", pInData );
       PrintLog((PSZ)"\n%ls\n", pInData );
       break;

  case DEVESC_RAWDATA:
       pddc->pdv->pCNFData->gjfncb.ulFlags &= ~GNDF_BOOKLETENABLED;    
       pddc->pdv->pCNFData->ulFlags &= ~SIM_COLLATE;                   
       pddc->pdv->pCNFData->iCntCopies = 1;                            

       if ( CHECKFLAG( pdv->ulGenFlags, RESET_MATRIX) != 0)                //@SEP
       {                                                                   //@SEP
#if DEBUG                                                                  //@SEP
         PrintChannel( pddc, "%% RESET_MATRIX\n");                         //@SEP
#endif                                                                     //@SEP
         // Transform matrix was changed in job prolog.                    //@SEP
         // After sending separator page, if RAW data                      //@SEP
         // is being processed, it needs to have default, unchanged        //@SEP 
         // matrix. So, restore it.                                        //@SEP

         // Default matrix is conveniently saved in mDef.                  //@SEP
         PrintChannel( pddc, "mDef sm\n" );                                //@SEP
         CLEARFLAG( pdv->ulGenFlags, RESET_MATRIX);  // and we're done     //@SEP
       }                                                                   //@SEP

       Result = DataOut( pddc, InCount, pInData );
       break;

  case DEVESC_MACRO:
     {
       PESCMACRO pEscMacro =  (PESCMACRO)pInData;

       // Can't do before startdoc
       if ( pdv->fDocStarted != TRUE )
       {
         ExitDriver( pddc );
         return( DEVESC_ERROR );
       }

       if ( ((LONG)InCount) < sizeof( ESCMACRO ) )
       {
         Result = ERROR_INVALID_PARAMETER;        // Error
         break;
       }
       else
       {  // Enough to look at
          // If ulPDL is not zero or don't care then check it out
         if ( pEscMacro->sPDL.ulPDL != PDL_DONTCARE )   // If the user cares
         {
           if ( pEscMacro->sPDL.ulPDL != PDL_PS  ||     // PDL must be PS and
                pEscMacro->sPDL.ulPDLLevel >            // level <= current
                ( pdv->usLanguageLevel & 0x00FF ) )
           {
             Result = ERROR_INVALID_PARAMETER;        // Error
             break;
           }
         }
       }

       // Do a gsave to rember graphics state
       PrintChannel( pddc, "gs\n" );

       Result = DataOut( pddc, pEscMacro->ulMacroLength,
                               (PULONG)(pEscMacro->abMacro) );

       // Restore the printers graphic state
       PrintChannel( pddc, "gr\n" );
     }
       break;

  case DEVESC_QUERYPDL:
    {
      USHORT usMajor = pdv->usLanguageLevel & 0x00FF;
      PIQUERYPDL pRequestPDL = (PIQUERYPDL)pInData;
      POQUERYPDL pQueryPDL = (POQUERYPDL)pOutData;
      PPDL pPDL;
      INT              i, iIndex, iLast;
      INT              iSize;

      Result = DEVESC_ERROR; // Set bad till proven OK

      // Error checking
      if ( pRequestPDL == NULL          ||
           pQueryPDL == NULL            ||
           pOutCount == NULL            ||
           InCount < sizeof( IQUERYPDL ) )
      {
        break;
      }


      if ( pRequestPDL->lCmd == QUERYPDL_CMD_QUERY_SIZE )
      {
        // lStart and lCount are ignored for query size

        // Since Lx can do all below ( ex L2 can do L1 ) just return level
        // Note - there is already one PDL in QUERYPDL
        // so we sub off one int the count
        pQueryPDL->lBufSize = sizeof( OQUERYPDL ) +
                              ( ( usMajor - 1 ) * sizeof( PDL ) );
        pQueryPDL->lMaxCount = usMajor;
        pQueryPDL->lCount = 0;
        Result = DEV_OK;
      }
      else
      if ( pRequestPDL->lCmd == QUERYPDL_CMD_QUERY_PDL )
      {
        // Init counts, size
        pQueryPDL->lBufSize = sizeof( OQUERYPDL ) - sizeof( PDL );
        pQueryPDL->lMaxCount = usMajor;
        pQueryPDL->lCount = 0;

        // This is the size left. First take off the size and count fields
        iSize = *pOutCount - pQueryPDL->lBufSize;

        // A little error checking
        if ( pRequestPDL->lCount <= 0             ||
             pRequestPDL->lCount > usMajor        ||
             pRequestPDL->lStart < 0              ||
             pRequestPDL->lStart > ( usMajor - 1 ) )
        {
          // Requester specifed data out of range so return none
          Result = DEV_OK;
          *pOutCount = pQueryPDL->lBufSize;  // Update return value
          break;
        }

        iLast = pRequestPDL->lCount - pRequestPDL->lStart - 1;  // Zero based

        // This is the size left. First take off the size and count fields
        iSize = *pOutCount - pQueryPDL->lBufSize;

        pPDL = pQueryPDL->aPDL;
        iIndex = 0;

        for ( i = usMajor; i > 0; i-- )
        {
          if ( iIndex >= pRequestPDL->lStart &&
               iIndex <= iLast                )
          {
            memset( (PBYTE)pPDL, 0, sizeof( PDL ) ); // Set to nulls
            pPDL->ulPDL = PDL_PS;
            pPDL->ulPDLLevel = i;
            pPDL->ulMajorPDLVersion = PDL_DONTCARE;
            pPDL->ulMinorPDLVersion = PDL_DONTCARE;
            pPDL->ulFlags = PDLCAPS_MACROSUPPORT | PDLCAPS_SELECTABLE;
            if ( i == usMajor )
            {
              pPDL->ulFlags |= PDLCAPS_CURRENT;
            }

            // Update count, size
            pQueryPDL->lCount++;
            pQueryPDL->lBufSize += sizeof( PDL );

            iSize -= sizeof( PDL );

            // If enough room update pointer else break;
            if ( iSize >= sizeof( PDL ) )
            {
              pPDL++;  // Bump pointer
            }
            else
            {
              break;
            }
          }
          iIndex++;
        }
        Result = DEV_OK;
      }
      else  // Unknown lCmd
      {
        break;
      }
    }
    break;

  case DEVESC_SEP:      /* New for DEVESC_SEP */
       /*
       ** This call differs from raw data in that the headers and device
       ** set needs to be done. Also it is assumed that there is no
       ** Mode switching in the data - our initiall data should set it up
       */

       /* DEVESC_RAWDATA is illegal if no DEVESC_STARTDOC has been done. */
       if ( ! pdv->fDocStarted )
       {
         ExitDriver( pddc );
         return( DEVESC_ERROR );
       }

       /* Test to see if need to send header and setup block(s) */
       if ( ! pddc->fHeaderSent )
       {
         /* Call PrintChannel - this should do all the work for setup */
//////// PrintChannel( pddc, "%c", *((PSZ)pInData) );
//////// pInData = (PULONG)(((PCHAR)pInData) + 1);  /* On to next char   */
//////// InCount--;                                 /* Drop count by one */
         /* @V4.0160760
         ** By the time we get here the header has set the printer in DPI
         ** or what ever.  We need to set the printer back to default units
         ** which are points.  Do this once and set the flag.
         ** Note:  we will not eject this page when we get the next NewFrame
         ** it is the separators job to do that.  This was done since all the
         ** existing sep pages do that up to the introduction of this function.
         */
         PrintChannel( pddc, "mDef SM\n" );
         SETFLAG( pdv->ulGenFlags, SEPARATOR_PAGE );

         /* If we are just passing thru raw data we won't need these
         ** either
         */
         if ( CHECKFLAG( pdv->ulGenFlags, DATATYPE_RAW ) )
         {
           SETFLAG( pdv->ulGenFlags, NO_CTL_D); /* No CTL_D */
           pdv->fInitStringSent = FALSE;        /* No term strings */
           SETFLAG( pdv->ulGenFlags, RESET_MATRIX); // Will need a reset in case RAW gets printed //@SEP
                                                    // We are saving this flag for DEVESC_RAWDATA //@SEP
         }
       }

       WriteChannel( pddc, (PB)pInData, (USHORT) InCount );
       Result = ps_status( pddc );
       break;

  case DEVESC_GETSCALINGFACTOR:
       /*
       ** check to see if we are being called with our own format.
       ** if not, pretend we aren't here.
       */
       if ((ULONG) *pOutCount != (ULONG)( sizeof(POINTL) + sizeof( POINTFX )))
       {
         ExitDriver( pddc );
         return( DEVESC_NOTIMPLEMENTED );
       }

       /*
       ** get the scaling factor in FIXED format.  ie 1.0 = 100%
       */
       // @V3.1142031
//       fxScale = frdiv( LongToFx( (LONG)pdv->jobProperties.uScale), FX_100 );
       fxScale = frdiv( LongToFx( (LONG) pCNFData->jobProperties.uScale),
                        FX_100 );

       /*
       ** jump past the two LONGS which are worthless to us.
       */
       pOutData += 2;

       /*
       ** return the FIXED scaling factors in the PPOINTFX passed in.
       */
       *pOutData = fxScale;      /* the x and y scaling factors are */
       pOutData += 1;                   /* the same. */
       *pOutData = fxScale;
       Result = DEV_OK;
       break;

  case DEVESC_QUERYESCSUPPORT:
       /*
       ** Since there are three possible return codes for the
       ** escape function, we handle QueryEscSupport specially
       ** so that the error status for the rest of the
       ** subfunctions can be mapped convieniently.
       */

       ExitDriver( pddc );
////// return( (ULONG)prdq_QueryEscSupport( (SHORT) *pInData) );         //@DJP
       return( (ULONG)prdq_QueryEscSupport( *pInData, pddc ) );          //@DJP

  case DEVESC_INTCHARWIDTH:
       /*
       ** this escape function simply sets a flag to tell whether
       ** integer character width is turned on or not.  the default
       ** if OFF.
       ** make sure we are being sent the correct information.
       */
       if (InCount != sizeof( BOOL ))
       {
         RIP( "DEVESC_INTCHARWIDTH: invalid parameter count." );
         ExitDriver( pddc );
         return( DEVESC_ERROR );
       }
       pddc->fIntCharWidth = (BOOL) *pInData;
       Result = DEV_OK;
       break;

       /* @DJP
       ** The next  escapes are for for DYNAMIC JOB PROPs
       */
  case DEVESC_QUERYSIZE:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       else
       {
         DJPSetUpRefData( pddc, &RefData );
         Result =  (SHORT)psDJPQuerySize( &RefData, InCount, pInData, pOutCount,
                                          pOutData );
       }
#endif
       break;

  case DEVESC_QUERYJOBPROPERTIES:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       else
       {
         DJPSetUpRefData( pddc, &RefData );
         Result =  (SHORT)psDJPQuerySetJobProperties( &RefData, InCount,
                                      pInData, pOutCount, pOutData, GET_PROP );
       }
#endif
       break;

  case DEVESC_SETJOBPROPERTIES:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       else
       {
         DJPSetUpRefData( pddc, &RefData );
         Result =  (SHORT)psDJPQuerySetJobProperties( &RefData, InCount,
                                      pInData, pOutCount, pOutData, SET_PROP );
       }
#endif
       break;

  case DEVESC_DEFAULTJOBPROPERTIES:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       else
       {
         DJPSetUpRefData( pddc, &RefData );
         Result =  (SHORT)psDJPDefaultJobProperties( &RefData, InCount, pInData,
                                                     pOutCount, pOutData );
       }
#endif
       break;

  case DEVESC_STARTDOC_WPROP:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       else
       {
//////// /* Ignore any "extra" start docs */
//////// if ( pddc->pdv->fDocStarted )
//////// {
////////   Result = DEV_OK;
////////   break;
//////// }

         DJPSetUpRefData( pddc, &RefData );
         ulRet = DJPResetStartDoc( pddc, &RefData, pOutData,
                                                      DEVESC_STARTDOC_WPROP  );
         if ( ulRet != DEV_OK )
         {
           Result = (SHORT)ulRet;
           break;
         }

         Result = prdq_StartDoc( hdc, pddc, (PSZ) pInData, (LONG) InCount );
       }
#endif
       break;

  case DEVESC_NEWFRAME_WPROP:
#ifdef DISABLE_DJP_SUPPORT
       Result = DEVESC_NOTIMPLEMENTED;
#else
       if ( ULGreVersion < GRE_234 )
       {
         Result = DEVESC_NOTIMPLEMENTED;
       }
       /* Can't change JP on newframe if in middle on NUP */
////// @V3.4155490 Yes you can...
////// else if ( pddc->pdv->pCNFData->gjfncb.ulNumPgSheet != 1 )
////// {
//////   Result =  DEVESC_ERROR;
//////   break;
////// }
       else
       {
         /* Do a new frame */
         Result = prdq_NewFrame( hdc, pddc );
         if ( Result == 0 )
         {
           break;
         }

         DJPSetUpRefData( pddc, &RefData );
//////// Result = (SHORT)DJPNewFrame( pddc, &RefData, pOutData );
         ulRet = DJPResetStartDoc( pddc, &RefData, pOutData,
                                                       DEVESC_NEWFRAME_WPROP );
       }
#endif
       break;
       /* END DJP */

  case DEVESC_SEND_COMPDATA:   /* Start of @V3.1137972 */
       /*
       ** Error if not a level 2 postscript printer or set Level 1 locally by dialog
       */
       // @V3.1142031
       if ((pddc->pdv->usLanguageLevel & 0x00FF == 1) ||
//           (pddc->pdv->usPSLevel1 == 1))
           (pCNFData->usPSLevel1 == 1))
       {
         GplErrSetError(  PMERR_DEV_FUNC_NOT_INSTALLED );
         ExitDriver( pddc );
//////// return (GPI_ERROR);
         return DEVESC_NOTIMPLEMENTED;
       }

       WriteChannel( pddc, (PB)pInData, (USHORT) InCount );
       Result = DEV_OK;
       break;

  case DEVESC_QUERY_RASTER:
       Result = DevEscQueryRaster( pddc, InCount, pInData, pOutCount, pOutData );
       break;

  case DEVESC_BEGIN_BITBLT:
       Result = DevEscBeginBITBLT( pddc, InCount, pInData, pOutCount, pOutData );
       break;

  case DEVESC_END_BITBLT:
       Result = DevEscEndBITBLT( pddc, InCount, pInData, pOutCount, pOutData );
       break;                  /* End of @V3.1137972   */

  case DEVESC_GETJOBID:
       Result = DevEscGetJobID( pddc, InCount, pInData, pOutCount, pOutData );
       break;

  default:
    ExitDriver( pddc );
    return( (ULONG) DEVESC_NOTIMPLEMENTED );
  }

  /*
  ** On the return, success is mapped to 1 and failure is
  ** mapped to -1.
  */
  ExitDriver( pddc );
//return( (ULONG)(long) (Result ? 1 : -1) );                             //@DJP
  //@DJP Since Result is either SUCCESS ( 1 := DEV_OK ) or FAILURE ( 0 :=
  //@DJP DEV_ERR ) just return Result. -1 has no meaning
  return( (ULONG)(long) (Result ? Result : DEV_ERROR ) );                //@DJP
}

/***************************************************************************
 *
 * FUNCTION NAME = prdq_QueryEscSupport
 *
 *
 * DESCRIPTION   = This routine returns TRUE or FALSE telling whether the given
 *                 escape routine is supported by the driver.
 *
 *
 * INPUT         = (usEscCode)
 *
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = (1), (0)
 *
 *
 * RETURN-ERROR  = NONE
 *
 *
 *
 **************************************************************************/

///SHORT prdq_QueryEscSupport( SHORT usEscCode )                         //@DJP
SHORT prdq_QueryEscSupport( ULONG ulEscCode,                             //@DJP
                            PDDC  pddc      )
{
  #if      DEBUG
    LogCall( "prdq_QueryEscSupport(%d)", ((PB)&ulEscCode)+sizeof(ulEscCode) );
  #endif                                 /* DEBUG */

  /*
  ** The desired escape function is indicated by ArgInData.
  ** Returns:     -1     Error
  **               0     Not Implemented
  **               1     OK
  */
//switch (usEscCode)                                                     //@DJP
  switch (ulEscCode)                                                     //@DJP
  {
  case DEVESC_SEND_COMPDATA:                                       /*@V3.1137972*/
  /* Note - this is only supported for level 2 printers */
    if ( ( pddc->pdv->usLanguageLevel & 0x00FF == 1) ||
         ( pddc->pdv->pCNFData->usPSLevel1 == 1 ) )
    {
      return DEVESC_NOTIMPLEMENTED;
    }
  case DEVESC_QUERYESCSUPPORT:
  case DEVESC_STARTDOC:
  case DEVESC_ENDDOC:
  case DEVESC_NEWFRAME:
  case DEVESC_ABORTDOC:
  case DEVESC_FLUSHOUTPUT:
  case DEVESC_RAWDATA:
  case DEVESC_INTCHARWIDTH:
  case DEVESC_QUERY_RASTER:                                        /*@V3.1137972*/
  case DEVESC_BEGIN_BITBLT:                                        /*@V3.1137972*/
  case DEVESC_END_BITBLT:                                          /*@V3.1137972*/
  case DEVESC_GETJOBID:
  case DEVESC_SETABORTPROC:                                              //@SAP
  case DEVESC_QUERYPDL:                                                  //@DEM
  case DEVESC_MACRO:
    return( DEV_OK );                                                    //@DJP

  case DEVESC_QUERYSIZE:                                                 //@DJP
  case DEVESC_QUERYJOBPROPERTIES:                                        //@DJP
  case DEVESC_SETJOBPROPERTIES:                                          //@DJP
  case DEVESC_DEFAULTJOBPROPERTIES:                                      //@DJP
  case DEVESC_STARTDOC_WPROP:                                            //@DJP
  case DEVESC_NEWFRAME_WPROP:                                            //@DJP
  case DEVESC_SEP:      /* New for DEVESC_SEP */
#ifdef DISABLE_DJP_SUPPORT                                               //@DJP
      return( DEVESC_NOTIMPLEMENTED );                                   //@DJP
#else                                                                    //@DJP
    /* Dynamic Job properties not supported on pre DAX engines */        //@DJP
    if ( ULGreVersion < GRE_234 )                                        //@DJP
    {                                                                    //@DJP
      return( DEVESC_NOTIMPLEMENTED );                                   //@DJP
    }                                                                    //@DJP
    else                                                                 //@DJP
    {                                                                    //@DJP
      return( DEV_OK );                                                  //@DJP
    }                                                                    //@DJP
#endif                                                                   //@DJP

  default:
    return( DEV_ERROR );                                                 //@DJP
  }
}


/***************************************************************************
 *
 * FUNCTION NAME =  prdq_StartDoc
 *
 * DESCRIPTION   =  This routine starts a document.  It is only supported if we have
 *                  an OD_QUEUED dc.  In otherwords, this routine is used to establish
 *                  the start of a new spooler print job.
 *
 * INPUT         = (hdc,pddc,pszDocName,nbName)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = (SUCCESS) , ps_status( pddc)
 *
 * RETURN-ERROR  = (DEVESC_ERROR)
 *
 **************************************************************************/

SHORT  prdq_StartDoc( HDC hdc, PDDC pddc, PSZ pszDocName, LONG nbName )
  /*  PDDC pddc;                            Ptr to the DC instance data       */
  /*  PSZ pszDocName;                       Ptr to the document name          */
  /*  LONG nbName;                          The length of the document name   */
{
  static char szNoName[] = "";
  SHORT       i;
  GLCB        layoutCB;

  #if      DEBUG
    LogCall( "prdq_StartDoc(%lp, %lp, %lp, %ld)", ((PB)&pddc)+sizeof(pddc) );
  #endif                                 /* DEBUG */

#if 0
//  pCB = (PVOID) QueryLayoutCBFromCNFDATA( pddc->pdv->pCNFData );
//  pddc->pdv->hLayout = GplLayoutCreateInstance( hdc, (PGLCB) pCB,
//                                                pProcessHeap );
//
//  pddc->pdv->lNumPgSheet = 0;
//  GplLayoutQueryParameters( pddc->pdv->hLayout,
//                            (PULONG) &pddc->pdv->lNumPgSheet,
//                            GJFN_QUERY_NUP_SELECTED, 1 );
#endif
  GplLayoutInitCB( &layoutCB, GL_SET_DEFAULT_LAYOUT, 0 );
  layoutCB.layout.nUP.ulNumPgSheet = pddc->pdv->pCNFData->gjfncb.ulNumPgSheet;
  pddc->pdv->lNumPgSheet           = pddc->pdv->pCNFData->gjfncb.ulNumPgSheet;
  layoutCB.layout.nUP.ulFlags      = pddc->pdv->pCNFData->gjfncb.ulFlags;
  pddc->pdv->hLayout = GplLayoutCreateInstance( hdc, &layoutCB,
                                                pProcessHeap );
//@FS
//pddc->pdv->hFS = GplFontsubCreateInstance( pProcessHeap,
//                                           pddc->pdv->pCNFData->szKeyApp );

  /*
  ** if the abort flag is set, it means that this startdoc call is
  ** coming immediately after an abortdoc call, with no output
  ** in between.  if there was no output in between the previous
  ** startdoc and the abortdoc, ie the channel was never opened,
  ** just set some flags.  If the channel had been opened, and we have
  ** a direct DC, output the end of job marker to kill the aborted job.
  */
  pddc->fDocWasAborted = FALSE;

  /*
  ** If the document has already been started then ignore any
  ** extra startdocs that occur.
  */
  if (pddc->pdv->fDocStarted)
  {
    return( SUCCESS );
  }

  /*
  ** @V3.1142031
  ** Convert the internal UI format to string, in case of LAN output.
  */
  /*
  ** @V3.1146873
  ** Moved to VerifyAndSetJobContents() (below).
  */

  /*  ** moved this to before ps_startdoc so it has a name
  --
  ** check for a document name.  if we are not given one, point
  ** to a null name, instead of random garbage.
  */
  if (!pszDocName)
  {
    pszDocName = (PSZ) szNoName;
  }
  szCopy((PSZ)pddc->pdv->szDocName, pszDocName, sizeof(pddc->pdv->szDocName) );

  // @V3.1142031
  VerifyAndSetJobContents( pddc->pdv );


  /*
  */
/*if ( pddc->pdv->usDataType == PM_Q_STD  && ****/
  /*
  ** Need to open the actual channel for queued jobs so GetJobID works
  */
  /* @V4.0181337
  ** If we are now queued but not iDestnType == SYSTEM then OpenChannel will
  ** change type to OD_DIRECT. In this case we should prceede as if direct here.
  */
  if ( ( pddc->iType == OD_QUEUED )                 &&
       ( pddc->pdv->pCNFData->iDestnType == SYSTEM ) )
  {

    if ( pddc->pdv->usDataType == PM_Q_STD )
    {
      SplStdStart( hdc );
      pddc->pdv->fDocStarted = TRUE ;
      ps_startdoc( pddc );
    }

    // @V4.1192857 Check return code
    if ( pddc->pdv->cn.fChannelIsValid == FALSE )
    {
      if ( OpenQueueChannel( pddc ) == FALSE )
      {
        return FAILURE;
      }
    }
  }


  /*
  */

  /*
  ** mark that the header has not yet been sent to the printer.  it
  ** will be sent at the time the first output is ready to go out.
  */
  pddc->pdv->fDocStarted = TRUE;
  pddc->fHeaderSent = FALSE;
  pddc->fEOJSent = FALSE;

  /*
  ** we are starting a new document.  as far as the printer is concerned,
  ** it is starting over fresh, and has no codepages or remapped fonts
  ** defined.  we must, therefore, reset our driver internal tables for
  ** downloaded codepages and remapped fonts.
  */
  for (i = 0; i <= MAX_FONT_LCID; i++)
  {
    ClearFontRemap( i );
  }

  for (i = 0; i < CP_LIMIT; i++)
  {
    pddc->pddcb->cgs.CPTable[i].usCP = 0;
  }

  pddc->pddcb->cgs.cCodePagesRemapped = 0;
  pddc->pddcb->cgs.usNewCPs = 0;       
  return( ps_status( pddc ) );
}

/***************************************************************************
 *
 * FUNCTION NAME = prdq_EndDoc
 *
 * DESCRIPTION   = This routine ends a document.  It is only supported if we
 *                 have  an OD_QUEUED dc.  In otherwords, this routine is used
 *                 to establish  the end of a spooler print job.
 *
 * INPUT         = (hdc,pddc,pusJobID,pnbBuf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = (ps_status( pddc))
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

SHORT prdq_EndDoc( HDC hdc, PDDC pddc, PSHORT pusJobID, PLONG pnbBuf )

  /* HDC hdc;                              handle to device context           */
  /* PDDC pddc;                            Ptr to the DC instance data        */
  /* PSHORT pusJobID;                     Ptr to the place to return the     */
  /*                                       spool job id                       */
  /*                                                                          */
  /*                                       defined to be a short in DevEscape!*/
  /*                                                                          */
  /* PLONG pnbBuf;                         The size of the buffer for         */
  /*                                       returning the job id               */
{
  SHORT usJobID;
  PDV   pdv = pddc->pdv;

  #if      DEBUG
    LogCall( "prdq_EndDoc(%lp, %lp, %ld)", ((PB)&pddc)+sizeof(pddc) );
  #endif                                 /* DEBUG */

  /*
  ** For an abort, simply reset the flag and exit.  Nothing else is needed.
  */
  if (pddc->fDocWasAborted == TRUE && pdv->hThread != (HTHREAD) 0)
  {
    pddc->fDocWasAborted = FALSE;
    return( SUCCESS );
  }
  
  if ( GplBookletEnabled( pddc->pdv->hThread ) )
  {
    
    FlushChannel( pddc );
    GplBookletSetOutput( pddc->pdv->hThread, BOOKLET_OUTPUT_ENDDOC );    
  }
  

  ResProcessEndPage( pddc ); // Do any endpage processing of resources   //@RES

  /*
  ** if no document has been started and we are not outputting
  ** an encapsulated postscript file, then we don't want to do
  ** anything.  just return success.
  */
  // @V3.1146873
//  if ((pdv->fDocStarted == FALSE) && (pdv->iDestnType != ENCAPS))
  if ((pdv->fDocStarted == FALSE) &&
      (pdv->pCNFData->iDestnType != ENCAPS))
  {
    return( SUCCESS );
  }

  /* @V3.1147985
  ** Update number of pages printed/spooled
  */

  if ( CHECKFLAG( pdv->ulGenFlags, DID_RAWDATA ) == 0 )           //@V4.0160389
  {
    if ( pddc->iType == OD_DIRECT )
    {
      IncPagesPrinted( pddc );
    }
    else
    if ( pddc->iType == OD_QUEUED   &&
         pdv->usDataType == PM_Q_RAW )
    {
      IncPagesSpooled( pddc );
    }
  }

  GplLayoutDeleteInstance( pddc->pdv->hLayout );
//GplFontsubDeleteInstance( pddc->pdv->hFS ); //@FS

  /*
  */
  if ( pdv->usDataType == PM_Q_STD )
  {
    perform_std_spooling( hdc, pddc );
  }
  usJobID = ps_enddoc( hdc, pddc );
  GplBookletReplayOutput( pddc->pdv->hThread );       

  pdv->fDocStarted = FALSE;

  // @V4.0190872
  if (pdv->pUISelectList != NULL)
  {
    GplMemoryFree( pdv->pUISelectList );
    pdv->pUISelectList = NULL;
  }

  /*  ** Moved the check to bottom to finish the enddoc before checking as
  ** not to hang up job...
  --
  ** Check parms, Initialize the spool file handle to null
  */
  if (pusJobID)
  {
    if ( pnbBuf == NULL ||
         *pnbBuf < sizeof(SHORT))
    {
      GplErrSetError( PMERR_INV_ESCAPE_DATA );
      return( FAILURE );
    }
  }

  /*
  ** tell the spooler the document has ended if we are queued.
  */
  if (pddc->iType == OD_QUEUED)
  {
    if (pusJobID)
    {
      *pusJobID = usJobID;
      *pnbBuf = (ULONG) sizeof( usJobID );
    }
  }
  return( ps_status( pddc ) );
}

/***************************************************************************
 *
 * FUNCTION NAME = prdq_AbortDoc
 *
 *
 * DESCRIPTION   = This routine aborts a document.  This allows the user to end
 *                 a print job in a "nice" way.
 *
 *
 * INPUT         = (hdc,pddc)
 *
 *
 * OUTPUT        = NONE
 *
 *
 *
 *
 * RETURN-NORMAL = (SplQmAbortDoc( (HSPL)pddc->pdv->cn.fh))
 *
 *
 * RETURN-ERROR  = NONE
 *
 *
 *
 **************************************************************************/

SHORT prdq_AbortDoc( HDC hdc,  PDDC pddc )
  /* HDC hdc;                              handle to device context          */
{
  
  /* The number of bytes actually written */
  

  #if      DEBUG
    LogCall( "prdq_AbortDoc( %lp)", ((PB)&pddc)+sizeof(pddc) );
  #endif                                 /* DEBUG */

  /*
  ** set a flag to say we no longer have a document started.
  */
  pddc->pdv->fDocStarted = FALSE;
  pddc->fHeaderSent = FALSE;

  /*
  ** Abort can be called more than once.
  */
  if (pddc->fDocWasAborted == FALSE)
  {
    if (pddc->iType == OD_QUEUED)
    {
      if (pddc->pdv->usDataType == PM_Q_RAW)
      {
        GplThreadAbortDoc( pddc->pdv->hThread );
        pddc->fDocWasAborted = TRUE;
      }

      ps_init( pddc );
      SplQmAbortDoc( (HSPL) pddc->pdv->cn.fh );
      SplStdDelete( SplStdStop( hdc ) );
    }
    else if (pddc->iType == OD_DIRECT)
    {
      if (pddc->pdv->usDataType == PM_Q_RAW)
      {
        GplThreadAbortDoc( pddc->pdv->hThread );
      }
      pddc->fDocWasAborted = TRUE;
    }

    GplBookletDestroy(pddc->pdv->hThread);  

  }

  return( SUCCESS );
}

/***************************************************************************
 *
 * FUNCTION NAME = prdq_NewFrame
 *
 * DESCRIPTION   = Handles the DEVESC_NEWFRAME call; basically a form feed.
 *
 * INPUT         = (hdc,pddc)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = (ps_status( pddc))
 *
 * RETURN-ERROR  = (FAILURE)
 *
 **************************************************************************/

SHORT prdq_NewFrame( HDC hdc,  PDDC pddc )
  /* HDC hdc;                              handle to device context          */
  /* PDDC pddc;                            Ptr to the DC instance data       */
{
  SHORT          CPNum, CurCPs;
  register SHORT x;
  SHORT          NewCPTable[CP_LIMIT];               
  PFNT           pFnt;                         
  SHORT          i, j;                                                  //@DBCS
  PDV            pdv = pddc->pdv;

  #if      DEBUG
    LogCall( "prdq_NewFrame(%lp)\n", ((PB)&pddc)+sizeof(pddc) );
  #endif                                 /* DEBUG */

  if (! pdv->fDocStarted)
  {
    RIP( "DEVESC_NEWFRAME called before DEVESC_STARTDOC.  NEWFRAME returning F\
AILURE" );
    return( FAILURE );
  }
  else
  {
    /* @V3.1147985
    ** Update number of pages printed/spooled
    */
    if ( pddc->iType == OD_DIRECT )
    {
      IncPagesPrinted( pddc );
    }
    else
    if ( pddc->iType == OD_QUEUED   &&
         pdv->usDataType == PM_Q_RAW )
    {
      IncPagesSpooled( pddc );
    }

    /*
    ** Flush out the old data.
    */
    if ( pdv->hThread )
    {
      GplThreadFlushBuffer( pdv->hThread, TRUE );
    }

    // @V3.1146873
//    if (pddc->iType == OD_DIRECT && pdv->iDestnType == ENCAPS)
    if (pddc->iType == OD_DIRECT && pdv->pCNFData->iDestnType == ENCAPS)
    {
      /*
      ** EPS files consist of one page only so if its
      ** an EPS file, terminate the document and close
      ** the output channel.
      */
      ps_enddoc( hdc, pddc );
      CloseChannel( hdc, pddc );
    }
  }

  
  /*
  ** To keep a good VM clean up we'll be doing a save and restore per page.
  ** The only way to reclaim VM space on level 1 is with the use of save and
  ** restore.
  */
  
#if 0
* if (pddc->usSavedDCs <= 1)         /* Don't restore in middle of saved DC */
* {
*   PrintChannel( pddc, (PSZ)"PageState restore\n" );
* }
#endif
  PrintChannel (pddc, (PSZ) "SavedState%d restore\n", pddc->usSavedDCs );

  /*
  ** Generate a PostScript page eject command
  */
  ps_showpage( pddc );

  
  FlushChannel( pddc );
  GplBookletNewPage( pddc->pdv->hThread );
  

  ResProcessEndPage( pddc ); // Do any endpage processing of resources   //@RES

  /*
  ** A new page might be started now. Recompute input tray no ,paper
  ** name  ,output tray no and reissue the needed commands .
  */

  /*
  ** Issuing commands to select paper,input and output trays.
  */
  pdv->shPageno += 1;            
  if ( pdv->lNumPgSheet > 1 )
  {
    pdv->sNupPage++;               /* Bump "page no" */
  }

  PrintChannel( pddc, (PSZ)"%%%%Page: %d %d\n", pdv->shPageno,
                pdv->shPageno );

  /*
  ** @MIXED_FEED Begin
  ** If MIXED_FEED selected, set form, tray, media for subsequent pages.
  ** Do it for page #2 only if First page is not NUPed and not Duplexed.
  ** If 1st page is NUPed, count all pages on sheet.
  ** If 1st page is duplexed, multiple by 2.
  */
  if ( ( pddc->iType == OD_DIRECT ||
         ( pddc->iType == OD_QUEUED &&
           pdv->usDataType == PM_Q_RAW ) ) )
  {
    if ( ( pdv->pCNFData->ulFlags & MIXED_FEED ) &&
         ( pdv->shPageno == 1 + (( pdv->lNumPgSheet>1 && !CHECKFLAG( pdv->pCNFData->ulFlags, NOT_NUP_1ST ) )?pdv->lNumPgSheet:1) *
           (( pdv->pCNFData->sDuplexMode && !CHECKFLAG( pdv->pCNFData->ulFlags, NOT_DUP_1ST ))? 2:1 ) )
       )
    {
      BOOL    bMixed = FALSE;
      PSZ     pMediaStr;

      if ( CHECKFLAG( pdv->ulGenFlags, MIXED_PAPER ) ) //see if paper was mixed in startdoc
      {
        if ( strcmp( pdv->pCNFData->jobProperties.szFormName, pdv->pCNFData->szFormName_1 ) )
        {
          bMixed = TRUE;
          strcpy( pdv->pCNFData->jobProperties.szFormName, pdv->pCNFData->szFormName_1 );
        }
        if ( strcmp( pdv->pCNFData->u.iv.aTraySelected, pdv->pCNFData->aTraySelected_1 ) )
        {
          bMixed = TRUE;
          strcpy( pdv->pCNFData->u.iv.aTraySelected, pdv->pCNFData->aTraySelected_1);
        }
        pMediaStr = QueryUIOptionString( pdv->pdesPPD, ASSIGN_UISELLIST_PTR( pdv->pCNFData ),
                                         UINAME_MEDIATYPE, NULL, NULL );
        if ( pMediaStr != NULL &&
             *pMediaStr != 0   &&
             strcmp( pMediaStr, pdv->pCNFData->szMediaType_1 ) )
        {
          bMixed = TRUE;
          SetUIOption( pdv->pdesPPD, ASSIGN_UISELLIST_PTR( pdv->pCNFData ),
                       UINAME_MEDIATYPE, pdv->pCNFData->szMediaType_1 );
        }
      }

      // Enable duplex for rest pages
      //if ( pdv->pCNFData->sDuplexMode && CHECKFLAG( pdv->pCNFData->ulFlags, NOT_DUP_1ST ) )
      //{
      //  SetUIOption( pdv->pdesPPD, ASSIGN_UISELLIST_PTR( pdv->pCNFData ),
      //               UINAME_DUPLEX, pdv->pCNFData->sDuplexMode );
      //}

      if ( bMixed )
      {
        if ( pdv->pUISelectList != NULL )
          GplMemoryFree( pdv->pUISelectList );

        pdv->pUISelectList = ConvertUIBitsToStrings( pdv,
                                                     pdv->pCNFData );
        PrintChannel( pddc, "mDef SM\n" );  /* Must go back to default matrix */
        pddc->pddcb->cgs.xformCTM = pddc->pddcb->xformCTM;
        PSDocSetUp( pddc, FALSE );
      }

      // Enable or reset NUP for rest pages
      if ( CHECKFLAG( pdv->pCNFData->ulFlags, NOT_NUP_1ST ) ||
           bMixed )
      {
        /* output nup stuff */
        NupSetUp( pddc );
      }

      //PrintChannel (pddc, (PSZ) "/SavedState%d save def\n", pddc->usSavedDCs );
    }
    else
    {
      // if 1st page wasn't NUPed, start NUPing from page #2
      // This is for fututre. Currently never get in because
      // this works only if MIXED_FEED is off & NOT_NUP_1ST is on
      if ( CHECKFLAG( pdv->pCNFData->ulFlags, NOT_NUP_1ST ) &&
           pdv->shPageno == 2 )
      {
        /* output nup stuff */
        NupSetUp( pddc );
      }
    }
  }
  // @MIXED_FEED End

  PSNup( pddc );   /* Do any Nup processing */

  pdv->xformPageState = pddc->pddcb->xformCTM;
  pddc->pddcb->cgs.xformCTM.fxM11 = FX_ZERO;
  ps_setmatrix( pddc, (FIXED  *) &pdv->xformPageState );

 
 if ((pddc->pdv->pCNFData->gjfncb.ulFlags & GNDF_BOOKLETENABLED ) &&     
    GplBookletEnabled( pddc->pdv->hThread ))
 {
    //
    // We clear all information about remapped fonts
    //
    for (x = 0; x <= MAX_FONT_LCID; x++)
    {
      ClearFontRemap( x );
    }

    for (x = 0; x < CP_LIMIT; x++)
    {
      pddc->pddcb->cgs.CPTable[x].usCP = 0;
    }

    pddc->pddcb->cgs.cCodePagesRemapped = 0;
    pddc->pddcb->cgs.usNewCPs = 0;

    // Store fonts directly to Booklet buffer

    // Download any multpage fonts now
//    FontResourceDownload( pddc, MULTI_PAGE );

    for (x = 0; x < pdv->cFonts; x++)
    {
      pFnt = (PFNT) &(*pdv->paFonts)[x];

      if ((SHORT)pFnt->usResource <= 0 &&    /* If soft font and */
         pFnt->bLoaded == TRUE)              /* downloaded but not locked */
      {
        pFnt->bLoaded = TRUE | LOCKED;         /* Mark it as locked */
      }
    }

    pddc->pddcb->pat.usfFontLoaded &= ~BASEPATLOADED;
    ps_patfill_base(pddc );
    pddc->pddcb->pat.usfFontLoaded |= BASEPATSAVED;

    pddc->pddcb->pat.usfFontLoaded &= ~FILLFONTLOADED;
    ps_patfill_common( pddc );
    pddc->pddcb->pat.usfFontLoaded |= FILLFONTSAVED;

    pddc->pddcb->pat.usfFontLoaded &= ~LOGFONTLOADED;
    ps_patfill_font( pddc );
    pddc->pddcb->pat.usfFontLoaded |= LOGFONTSAVED;

 }
 else
 {
 
  /*
  ** Def 51530 - Check if the PageState CTM is different then the current
  ** matrix.  If it is reissue the CTM since the restore has reset the CTM to
  ** what is was at last pagesave - any changes made to middle of page are
  ** gone.
  */
  //Moved Up !!!
  //if (!utl_MemIsEqual((PB)&pddc->pddcb->xformCTM,
  //    (PB) &pdv->xformPageState, sizeof(pddc->pddcb->xformCTM)))
  //{
  //  pdv->xformPageState = pddc->pddcb->xformCTM;
  //  pddc->pddcb->cgs.xformCTM.fxM11 = FX_ZERO; /* Mess up CTM */
  //                                                  /* Reissue the latest CTM */
  //  ps_setmatrix( pddc, (FIXED  *) &pdv->xformPageState );
  //}

  // @RES
  // Download any multpage fonts now
  FontResourceDownload( pddc, MULTI_PAGE );

  
  /*
  ** Look for any downloaded fonts.  If any found re-download them so they
  ** are part of the pagestate
  */
  for (x = 0; x < pdv->cFonts; x++)
  {
    pFnt = (PFNT) &(*pdv->paFonts)[x];

    if ((SHORT)pFnt->usResource <= 0 &&    /* If soft font and */
       pFnt->bLoaded == TRUE)              /* downloaded but not locked */
    {
      SFDownload( pddc, (PSZ)pFnt->pszPFB ); /* Redownload the font */
      pFnt->bLoaded = TRUE | LOCKED;         /* Mark it as locked */
    }
  }

  
  /*
  ** Any remapping done in the middle of a page has being removed by the
  ** restore at the end of the page.  Now we must place this remap at the
  ** bottom of our setup to keep VM as clean as possible. Before we do our
  ** save at the begining of the next page. This will store all new character
  ** set were we can access them later without remaping.
  */
  if (pddc->pddcb->cgs.usNewCPs != 0)
  {
    CurCPs = pddc->pddcb->cgs.cCodePagesRemapped;
    CPNum = CurCPs;

    for (x = 0; x <= pddc->pddcb->cgs.usNewCPs; ++x)
    {
      NewCPTable[CurCPs-CPNum] = pddc->pddcb->cgs.CPTable[CPNum].usCP;
      pddc->pddcb->cgs.CPTable[CPNum].usCP = 0;
      --CPNum;
    }
    pddc->pddcb->cgs.cCodePagesRemapped = (pddc->pddcb->cgs.cCodePagesRemapped
       -pddc->pddcb->cgs.usNewCPs );

    for (x = 0; x <= pddc->pddcb->cgs.usNewCPs; ++x)
    {
      RemapCodePage(pddc, NewCPTable[x], pddc->pddcb->text.bLogFontEntry,
         pddc->pddcb->text.szFont );
      NewCPTable[x] = 0;
    }

    /*        PrintChannel( pddc, (PSZ) "CP 0 = %D \n",pddc->pddcb->cgs.usCPTable[0] ); */
    /*        PrintChannel( pddc, (PSZ) "CP 1 = %D \n",pddc->pddcb->cgs.usCPTable[1] ); */
    /*        PrintChannel( pddc, (PSZ) "CP 2 = %D \n",pddc->pddcb->cgs.usCPTable[2] ); */

    pddc->pddcb->cgs.usNewCPs = 0;
  }

  /*
  ** Reset any patterns that may've being deleted with restore
  */
  if ((pddc->pddcb->pat.usfFontLoaded&BASEPATLOADED) &&
     !(pddc->pddcb->pat.usfFontLoaded&BASEPATSAVED))
  {
    pddc->pddcb->pat.usfFontLoaded &= ~BASEPATLOADED;
    ps_patfill_base(pddc );
    pddc->pddcb->pat.usfFontLoaded |= BASEPATSAVED;
  }

  if ((pddc->pddcb->pat.usfFontLoaded & FILLFONTLOADED) &&
     !(pddc->pddcb->pat.usfFontLoaded & FILLFONTSAVED))
  {
    pddc->pddcb->pat.usfFontLoaded &= ~FILLFONTLOADED;
    ps_patfill_common( pddc );
    pddc->pddcb->pat.usfFontLoaded |= FILLFONTSAVED;
  }

  
  if ((pddc->pddcb->pat.usfFontLoaded & LOGFONTLOADED) &&
     !(pddc->pddcb->pat.usfFontLoaded & LOGFONTSAVED))
  {
    pddc->pddcb->pat.usfFontLoaded &= ~LOGFONTLOADED;
    
    ps_patfill_font( pddc );                               
    pddc->pddcb->pat.usfFontLoaded |= LOGFONTSAVED;
  }
 }  // Booklet doesn't enabled

  /*
  ** for every page we will save at the begining and restore at the end
  ** to do our own garbage collection and keep VM as clean as possible.
  */
#if 0
* if (pddc->usSavedDCs <= 1)           /* Don't save in middle of saved DC */
* {
*   PrintChannel( pddc, (PSZ)"/PageState save def \n" );
* }
#endif
  PrintChannel (pddc, (PSZ) "/SavedState%d save def\n", pddc->usSavedDCs );

  // @RES
  // Download top ofpage fonts now
  FontResourceDownload( pddc, TOP_OF_PAGE );

  /*
  ** restore the clipping rectangle, since it was blown away in the
  ** printer.  The showpage does an initgraphics, which returns
  ** the clipping to the full page.
  */
  play_clip_rects( hdc, pddc );

  /*
  ** Flush the channel so that all the commands get written out
  ** and then mark the channel as "unused" so that the driver
  ** can avoid emitting an extra page eject.
  */
  FlushChannel( pddc );
/* DBCS enabling start */                                               //@DBCS
  /*
  ** Initialize the setting check area for Bold character width and
  ** Italic font.
  */
  pddc->pddcb->text.lBold = 0L;

  for (i = 0; i < pdv->cDBCSFonts; i++)
    for (j = 0; j < 2; j++)
      (*pdv->paDBCSFonts)[i].sItalicFont[j] = FALSE;
/* DBCS enabling end   */                                               //@DBCS
  pdv->cn.fUsed = FALSE;
  return( ps_status( pddc ) );
}

#if 0
///***************************************************************************
// *
// * FUNCTION NAME = prdq_CharExtra
// *
// * DESCRIPTION   = Handles the DEVESC_CHAREXTRA call.  Sets extra spacing for
// *                 non-break characters.
// *
// * INPUT         = (pddc,plParameters,ulByteCount)
// *
// * OUTPUT        = NONE
// *
// * RETURN-NORMAL = (SUCCESS)
// *
// * RETURN-ERROR  = (FAILURE)
// *
// **************************************************************************/
//
//SHORT prdq_CharExtra( PDDC pddc, PLONG plParameters, ULONG ulByteCount )
//  /* PDDC pddc;                            Pointer to display context        */
//  /*                                       instance data                     */
//  /* PLONG plParameters;                   Extra spacing desired             */
//  /* ULONG ulByteCount;                    The size of the parameter buffer  */
//  /*                                       in bytes                          */
//{
//  /*
//  ** If the caller gave us no input data, then we set the extra spacing
//  ** for non-break characters to zero.
//  */
//  if (!ulByteCount)
//  {
//    pddc->pddcb->text.fxCharExtra = FX_ZERO;
//    return( SUCCESS );
//  }
//  else
//  {
//    /*
//    ** Otherwise the caller must give us one FIXED value. This is the
//    ** amount of extra spacing desired, in world coordinates, to be added
//    ** to each non-break character.
//    */
//    if (ulByteCount == sizeof(FIXED))
//    {
//      pddc->pddcb->text.fxCharExtra = *plParameters;
//      return( SUCCESS );
//    }
//    else
//    /*
//    ** Otherwise they gave us a bad byte count.
//    */
//    {
//      GplErrSetError(  PMERR_INV_ESCAPE_DATA );
//      return( FAILURE );
//    }
//  }
//}
//
///***************************************************************************
// *
// * FUNCTION NAME = prdq_BreakExtra
// * DESCRIPTION   = Handles the DEVESC_BREAKEXTRA call.  Sets extra spacing for
// *                 break characters.
// * INPUT         = (pddc,plParameters,ulByteCount)
// * OUTPUT        = NONE
// * RETURN-NORMAL = (SUCCESS)
// * RETURN-ERROR  = (FAILURE)
// **************************************************************************/
//
//SHORT prdq_BreakExtra( PDDC pddc, PLONG plParameters, ULONG ulByteCount )
//  /* PDDC pddc;                            Pointer to display context        */
//  /*                                       instance data                     */
//  /* PLONG plParameters;                   Extra spacing desired             */
//  /* ULONG ulByteCount;                    The size of the parameter buffer  */
//  /*                                       in bytes                          */
//{
//  /*
//  ** If the caller gave us no input data, then we set the extra spacing
//  ** for break characters to zero.
//  */
//  if (!ulByteCount)
//  {
//    pddc->pddcb->text.fxBreakExtra = FX_ZERO;
//    return( SUCCESS );
//  }
//  else
//  {
//    /*
//    ** Otherwise the caller must give us one FIXED value. This is the
//    ** amount of extra spacing desired, in world coordinates, to be added
//    ** to each break character.
//    */
//    if (ulByteCount == sizeof(FIXED))
//    {
//      pddc->pddcb->text.fxBreakExtra = *plParameters;
//      return( SUCCESS );
//    }
//    else
//    /*
//    ** Otherwise they gave us a bad byte count.
//    */
//    {
//      GplErrSetError(  PMERR_INV_ESCAPE_DATA );
//      return( FAILURE );
//    }
//  }
//}
#endif

/*
*/
/***************************************************************************
 *
 * FUNCTION NAME = perform_std_spooling
 *
 * DESCRIPTION   = writedata to the spooler.
 *                 End of spooling activities -
 *                 write the metafile data to the spooler.
 *
 * INPUT         = hdc pddc
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = The job ID,  as returned from the spooler
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

USHORT perform_std_spooling( HDC hdc, PDDC pddc )
{
  USHORT JobID = 0;
  USHORT usBufSize;
  HSTD   hJob;
  HSPL   hSpoolFile;
  LONG   lBytesLeft = 0;
  LONG   lBytesToRead = 0;
  LONG   lBytesRead = 0;
  PVOID  pBuf;
  BYTE   StackBuf[ 64 ];  /* A little buf if out of mem */

  hJob = SplStdStop( hdc );  /* Stop recording get handle */

  if ( ( lBytesLeft = SplStdQueryLength( hJob ) ) != 0 )
  {
    /*
    ** Set up buf length MAX 64K -1
    */
    if ( lBytesLeft > 0xFFFF )
    {
      usBufSize = 0xFFFF;
    }
    else
    {
      usBufSize = (USHORT) lBytesLeft;
    }

    /*
    ** Get buffer (use stack if alloc fails)
    */
    if ( !(pBuf = GplMemoryAlloc ( pddc->pdv->pDCHeap, usBufSize )))
    { /* Failure */
      pBuf = (PVOID) StackBuf;
      usBufSize = sizeof( StackBuf );
    }

    hSpoolFile = (HSPL)pddc->pdv->cn.fh;

    /*
    ** Loop geting the metafile bits from buffer to spool file
    */
    while ( lBytesLeft )
    {
      lBytesToRead = lBytesLeft;

      if ( lBytesToRead > usBufSize )
      {
        lBytesToRead = usBufSize;
      }

      if ( SplStdGetBits( hJob, lBytesRead, lBytesToRead, (PCH)pBuf ) == FALSE )
      {
        SplQmClose( hSpoolFile );
        break;                          /* Break the loop */
      }

      /*
      ** Adjust the counts and offsets
      */
      lBytesLeft -= lBytesToRead;
      lBytesRead += lBytesToRead;

      /*
      ** Write it to the spooler - if there is an error then close the file
      */
      if ( SplQmWrite( hSpoolFile, lBytesToRead, (PCH)pBuf ) == FALSE )
      {
        SplQmClose( hSpoolFile );
        break;                          /* Break the loop */
      }
    }
  }

/*JobID = SplQmEndDoc( hSpoolFile ); */

  SplStdDelete( hJob );                 /* Delete our record of it           */

  if ( pBuf != (PVOID)StackBuf )
  {
    GplMemoryFree( pBuf );
  }

  return( JobID );
}

/****************************+-------------------+****************************/
/****************************| @V3.1137972 start |****************************/
/****************************+-------------------+****************************/

/*****************************************************************************\
**
**
**
\*****************************************************************************/

SHORT DevEscQueryRaster( PDDC pddc, ULONG InCount, PULONG pInData,
                         PULONG pOutCount, PULONG pOutData )
{
  PDV                pdv = pddc->pdv;
  PQUERY_RASTER      pqueryraster;
  PQUERY_ONE_RASTER  pqueryoneraster;
  PCOMP_BITMAPTYPES  pcompbitmap;
  PCNFDATA           pCNFData = pddc->pdv->pCNFData;             // @V3.1142031

  // caller asking for count of COMP_BITMAPTYPES supported

  if (*pOutCount == 0)
  {
    // @V3.1142031
    if (((pdv->usLanguageLevel & 0x00FF) == 1) ||
         (pCNFData->usPSLevel1 == 1))
    {
      pqueryraster = (PQUERY_RASTER) pOutData;      // Level 1 printer
      pqueryraster->cCount = 0;
      pqueryraster->ulCaps = 0;
    }
    else
    {
      pqueryraster = (PQUERY_RASTER) pOutData;      // Level 2 printer
      pqueryraster->cCount = 7;
      pqueryraster->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                               BITMAP_ROTATION;

      // @V3.1142031
      if (pCNFData->jobProperties.fIsColorDevice)
      {
        pqueryraster->ulCaps |= BITMAP_COLOR;
      }
    }
  }
  else if (*pOutCount == INQUIRE_ON_ONE_MODE)     // asking if a mode is supported by
  {                                               // this device
    // @V3.1142031
    if ((pdv->usLanguageLevel & 0x00FF == 1) ||
        (pCNFData->usPSLevel1 == 1))
    {
      pqueryoneraster = (PQUERY_ONE_RASTER) pOutData;      // Level 1 printer
      pqueryoneraster->bSupported = FALSE;
      pqueryoneraster->ulCaps = 0;
    }
    else
    {
      if ((COMP_G3_MH == *pInData) || (COMP_G3_MR == *pInData ) ||
          (COMP_G4_MMR == *pInData) || (COMP_JPEG == *pInData) ||
          (COMP_PACKBITS == *pInData))
      {
        pqueryoneraster = (PQUERY_ONE_RASTER) pOutData;      // Level 2 printer
        pqueryoneraster->bSupported = TRUE;

        pqueryoneraster->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                               BITMAP_ROTATION;
        // @V3.1142031
        if (pCNFData->jobProperties.fIsColorDevice)
        {
          pqueryoneraster->ulCaps |= BITMAP_COLOR;
        }
      }
      else
      {
        pqueryoneraster = (PQUERY_ONE_RASTER) pOutData;      // Level 2 printer
        pqueryoneraster->bSupported = FALSE;
        pqueryoneraster->ulCaps = 0;
      }
    }
  }
  else
  {
    pcompbitmap = (PCOMP_BITMAPTYPES) pOutData;

    if (InCount == 0 )
    {
      *pOutCount = 0;
      return (GPI_OK);
    }

    // @V3.142031
    if ((pddc->pdv->usLanguageLevel & 0x00FF == 1) ||
        (pCNFData->usPSLevel1 == 1))
    {
      *pOutCount = 0;
      return (GPI_OK);
    }

    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 1;
    pcompbitmap->ulCompressionType = COMP_G4_MMR;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;
    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 1;        // number of COMP_BITMAPTYPES struct returned
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 1;
    pcompbitmap->ulCompressionType = COMP_G3_MH;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 2;
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 1;
    pcompbitmap->ulCompressionType = COMP_G3_MR;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 3;
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 1;
    pcompbitmap->ulCompressionType = COMP_PACKBITS;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 4;
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 8;
    pcompbitmap->ulCompressionType = COMP_JPEG;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 5;
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 24;
    pcompbitmap->ulCompressionType = COMP_JPEG;
    *pOutCount = 6;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }

    if (--InCount == 0)
    {
      *pOutCount = 6;
      return (GPI_OK);
    }

    ++pcompbitmap;
    pcompbitmap->cPlanes = 1;
    pcompbitmap->cBitCount = 32;
    pcompbitmap->ulCompressionType = COMP_JPEG;
    *pOutCount = 7;

    pcompbitmap->ulCaps = BITMAP_WITH_GPI | BITMAP_STRETCHING |
                          BITMAP_ROTATION;

    // @V3.1142031
    if (pCNFData->jobProperties.fIsColorDevice)
    {
      pcompbitmap->ulCaps |= BITMAP_COLOR;
    }
  }

  return(GPI_OK);

}


/*****************************************************************************\
**
**
**
\*****************************************************************************/

SHORT DevEscBeginBITBLT( PDDC pddc, ULONG InCount, PULONG pInData,
                         PULONG pOutCount, PULONG pOutData )
{
  RGB         rgb[2];
  ULONG       ulTmpColor;
  FIXED       fxTmp, fxTmp1, fxTmp2, fxTmp3, fxTmp4;
  PRGBGAMMA   pGammaValues;
  LONG        lgamma;
  PCNFDATA    pCNFData = pddc->pdv->pCNFData;                    // @V3.1142031

  /*
  ** Do nothing if this is an InfoContext DC.
  */
  if ( (pddc->iType == OD_INFO) ||
      (pddc->pdv->usDataType == PM_Q_STD) )
  {
   return DEV_OK;
  }

  /*
  ** Error if not a level 2 postscript printer or set Level 1 locally by dialog
  */
  // @V3.1142031
  if ((pddc->pdv->usLanguageLevel & 0x00FF == 1) ||
      (pCNFData->usPSLevel1 == 1))
  {
    GplErrSetError(  PMERR_DEV_FUNC_NOT_INSTALLED );
    ExitDriver( pddc );
    return (GPI_ERROR);
  }


  if ((((PCOMPBITBLT)pInData)->ultype != COMP_G4_MMR)   &&
      (((PCOMPBITBLT)pInData)->ultype != COMP_G3_MH)     &&
      (((PCOMPBITBLT)pInData)->ultype != COMP_G3_MR)     &&
      (((PCOMPBITBLT)pInData)->ultype != COMP_PACKBITS) &&
      (((PCOMPBITBLT)pInData)->ultype != COMP_JPEG))

  {
    GplErrSetError(  PMERR_DEV_FUNC_NOT_INSTALLED );
    ExitDriver( pddc );
    return (GPI_ERROR);
  }

  if (pddc->pddcb->path.fPathIsOpen)
  {
    GplErrSetError(  PMERR_INV_IN_PATH );
    ExitDriver( pddc );
    return (GPI_ERROR);
  }

  if (pddc->pddcb->path.fAreaIsOpen)
  {
    GplErrSetError(  PMERR_INV_IN_AREA );
    ExitDriver( pddc );
    return (GPI_ERROR);
  }

  pddc->pdv->usLanguageLevel |= CCITT_G4_COMPRESSION; /* use high byte for compression type */

  PrintChannel (pddc, (PSZ)"\nsave\n");

  ulTmpColor = prdc_GetColor( pddc, pddc->pddcb->image.ulBgColor );
  rgb[0].bBlue = (BYTE)( ulTmpColor & 0xFF );
  rgb[0].bGreen = (BYTE)( (ulTmpColor >> 8) & 0xFF );
  rgb[0].bRed = (BYTE)( (ulTmpColor >> 16) & 0xFF );


  ulTmpColor = prdc_GetColor( pddc, pddc->pddcb->image.ulFgColor );
  rgb[1].bBlue = (BYTE) ( ulTmpColor & 0xFF );
  rgb[1].bGreen = (BYTE)( (ulTmpColor >> 8) & 0xFF );
  rgb[1].bRed = (BYTE)( (ulTmpColor >> 16) & 0xFF );


  /*
  ** output the gray shades for the foreground, then
  ** the background colors.
  */
  /*
  ** @V3.1142412
  ** Change source of gamma values.
  */
//  pGammaValues = &(pddc->pdv->dev_dop.pDriveData->cnfData.sGammaValues);
  pGammaValues = (PRGBGAMMA) &(pCNFData->sGammaValues);

  if ( pGammaValues->lRed   == NO_GAMMA &&
       pGammaValues->lGreen == NO_GAMMA &&
       pGammaValues->lBlue  == NO_GAMMA  )
  {
    lgamma = NO_GAMMA;
  }
  else
  { /* Take average for this case */
    lgamma = ( pGammaValues->lRed + pGammaValues->lGreen + pGammaValues->lBlue )
                     / 3 ;
  }

  if (lgamma != NO_GAMMA)
  {
    fxTmp = (LONG) PalGray( &rgb[1], NULL ) << 16;
    fxTmp = frdiv( fxTmp, FIXED_255 );

    if (lgamma < NO_GAMMA)     // lighten foreground
    {
      if ( fxTmp < FIXED_NINETENTH)
      {
        fxTmp1 = FIXED_NINETENTH - fxTmp;
        fxTmp2 = frdiv( fxTmp1, FIXED_9);
        fxTmp3 = (lgamma - 1) << 16;
        fxTmp4 = frmul( fxTmp2, fxTmp3);
        fxTmp = FIXED_NINETENTH - fxTmp4;
      }
    }
    else                       // darken foreground
    {
      if ( fxTmp > FIXED_TENTH)
      {
        fxTmp1 = (50 - lgamma) << 16;
        fxTmp2 = fxTmp - FIXED_TENTH;
        fxTmp3 = frdiv( fxTmp2, FIXED_40);
        fxTmp4 = frmul( fxTmp1, fxTmp3);
        fxTmp  = fxTmp4 + FIXED_TENTH;
      }
    }

    PrintChannel( pddc, (PSZ)"%f ", fxTmp );

    fxTmp = (LONG) PalGray( &rgb[0], NULL ) << 16;
    fxTmp = frdiv( fxTmp, FIXED_255 );

    if (lgamma < NO_GAMMA)     // lighten background
    {
      if ( fxTmp < FIXED_NINETENTH)
      {
        fxTmp1 = FIXED_NINETENTH - fxTmp;
        fxTmp2 = frdiv( fxTmp1, FIXED_9);
        fxTmp3 = (lgamma - 1) << 16;
        fxTmp4 = frmul( fxTmp2, fxTmp3);
        fxTmp = FIXED_NINETENTH - fxTmp4;
      }
    }
    else                       // darken background
    {
      if ( fxTmp > FIXED_TENTH)
      {
        fxTmp1 = (50 - lgamma) << 16;
        fxTmp2 = fxTmp - FIXED_TENTH;
        fxTmp3 = frdiv( fxTmp2, FIXED_40);
        fxTmp4 = frmul( fxTmp1, fxTmp3);
        fxTmp  = fxTmp4 + FIXED_TENTH;
      }
    }

    PrintChannel( pddc, (PSZ)"%f ", fxTmp );
  }
  else
  {
    fxTmp = (LONG) PalGray( &rgb[1], NULL ) << 16;
    fxTmp = frdiv( fxTmp, FIXED_255 );
    PrintChannel( pddc, (PSZ)"%f ", fxTmp );

    fxTmp = (LONG) PalGray( &rgb[0], NULL ) << 16;
    fxTmp = frdiv( fxTmp, FIXED_255 );
    PrintChannel( pddc, (PSZ)"%f ", fxTmp );
  }

  /*
  ** fill the rectangle behind the image with the
  ** background color.
  */
  ps_newpath (pddc);
  PrintChannel (pddc, (PSZ)"%ld %ld %ld %ld box\n", ((PCOMPBITBLT)pInData)->rclDst.xLeft,
   ((PCOMPBITBLT)pInData)->rclDst.yBottom, ((PCOMPBITBLT)pInData)->rclDst.xRight - 1,
   ((PCOMPBITBLT)pInData)->rclDst.yTop - 1 );

  PrintChannel (pddc, (PSZ)"g f g\n" );

  /*
  ** Set the device coordinate system.
  */
  PrintChannel (pddc, (PSZ)"md sm\n" );

  /*
  ** position the image on the page.
  */
  PrintChannel (pddc, (PSZ)"%d %d translate ", ((PCOMPBITBLT)pInData)->rclDst.xLeft,
     ((PCOMPBITBLT)pInData)->rclDst.yBottom);

  /*
  ** do to the fact that area fills and imagemasks seem to fill
  ** the same rectangle differently, we need to shift the bitmap
  ** to the left one pixel.
  */
/*PrintChannel( pddc, (PSZ)"-1 0 _snap translate " );           **@V4.0158729*/
/** See bitmaps.c for explanation **/
  PrintChannel( pddc, (PSZ)"0 -1 _snap translate " );           /*@V4.0158729*/

  /*
  ** scale the image.
  */
  PrintChannel (pddc, (PSZ)"%d %d scale\n", ((PCOMPBITBLT)pInData)->rclDst.xRight - ((PCOMPBITBLT)pInData)->rclDst.xLeft,
     ((PCOMPBITBLT)pInData)->rclDst.yTop - ((PCOMPBITBLT)pInData)->rclDst.yBottom);

  PrintChannel (pddc, (PSZ)"%d %d ", ((PCOMPBITBLT)pInData)->ulColumns, ((PCOMPBITBLT)pInData)->ulRows );

  PrintChannel (pddc, (PSZ) "true ");    // changed from 1 for image to true for imagemask

  /*
  ** The bitmap has been read from bottom to top.
  ** PrintChannel( pddc, (PSZ) "[%d 0 0 %d 0 %d] ", ulColumns, ulRows );
  */
  PrintChannel (pddc, (PSZ)"[%d 0 0 %d 0 0] ", ((PCOMPBITBLT)pInData)->ulColumns, ((PCOMPBITBLT)pInData)->ulRows);

  PrintChannel (pddc, (PSZ)"\ncurrentfile\n/ASCII85Decode filter");

  if ((((PCOMPBITBLT)pInData)->ultype == COMP_G4_MMR)  ||
      (((PCOMPBITBLT)pInData)->ultype == COMP_G3_MH)    ||
      (((PCOMPBITBLT)pInData)->ultype == COMP_G3_MR))
  {
    PrintChannel (pddc, (PSZ)"\n<<");

    switch (((PCOMPBITBLT)pInData)->ultype)
    {
      case COMP_G4_MMR:
        PrintChannel (pddc, (PSZ)"\n/K -1");
        break;
      case COMP_G3_MH:
        PrintChannel (pddc, (PSZ)"\n/K 0");
        break;
      case COMP_G3_MR:
        PrintChannel (pddc, (PSZ)"\n/K 2");
        break;
    }

    PrintChannel (pddc, (PSZ)"\n/Columns %d" , ((PCOMPBITBLT)pInData)->ulColumns);

    if (((PCOMPBITBLT)pInData)->bitblt.ccitt.bEndOfLine)
      PrintChannel (pddc, (PSZ)"\n/EndOfLine true");
    else
      PrintChannel (pddc, (PSZ)"\n/EndOfLine false");

    if (((PCOMPBITBLT)pInData)->bitblt.ccitt.bEncodedByteAlign)
      PrintChannel (pddc, (PSZ)"\n/EncodedByteAlign true");
    else
      PrintChannel (pddc, (PSZ)"\n/EncodedByteAlign false");

    if (((PCOMPBITBLT)pInData)->bitblt.ccitt.bEndOfBlock)
      PrintChannel (pddc, (PSZ)"\n/EndOfBlock true");
    else
      PrintChannel (pddc, (PSZ)"\n/EndOfBlock false");

    if (((PCOMPBITBLT)pInData)->bitblt.ccitt.bBlackIs1)
      PrintChannel (pddc, (PSZ)"\n/BlackIs1 true");
    else
      PrintChannel (pddc, (PSZ)"\n/BlackIs1 false");

    PrintChannel (pddc, (PSZ)"\n>>");
    PrintChannel (pddc, (PSZ)"\n/CCITTFaxDecode filter imagemask\n");

  }
  else if (((PCOMPBITBLT)pInData)->ultype == COMP_PACKBITS)
  {
    PrintChannel (pddc, (PSZ)"\n/RunLengthDecode filter image\n");
    pddc->pdv->usLanguageLevel |= COMPRESS_RLL_MODE;
  }
  else if (((PCOMPBITBLT)pInData)->ultype == COMP_JPEG)
  {
    // The other parameters from the dct structure need to be added.  For now
    // this will work, as the other parameters are encoded in the JPEG file.
    // They should be added to allow overriding the JPEG file values for these
    // parameters.
    PrintChannel (pddc, (PSZ)"\n<<");
    PrintChannel (pddc, (PSZ)"\n/Columns %d" , ((PCOMPBITBLT)pInData)->ulColumns);
    PrintChannel (pddc, (PSZ)"\n/Rows %d" , ((PCOMPBITBLT)pInData)->ulRows);

    if ((((PCOMPBITBLT)pInData)->bitblt.dct.ulColors >= 1) &&
         (((PCOMPBITBLT)pInData)->bitblt.dct.ulColors <= 4 ))
    {
      PrintChannel (pddc, (PSZ)"\n/Colors %d" , ((PCOMPBITBLT)pInData)->bitblt.dct.ulColors);
    }
    else
    {
      GplErrSetError(  PMERR_DEV_FUNC_NOT_INSTALLED );
      ExitDriver( pddc );
      return (GPI_ERROR);
    }
    PrintChannel (pddc, (PSZ)"\n>>");
    PrintChannel (pddc, (PSZ)"\n/DCTDecode filter image\n");
  }

  FlushChannel( pddc );   /* Clear buffer first - get data out start with */
                          /* a clear channel buffer that is a multiple of */
                          /* 4.  This is needed because CompressAscii85   */
                          /* expands 4 inputs in to 5 bytes out.          */
                          /* Add extra long for flag                      */

  if (!(pddc->pdv->Compress85 = GplMemoryAlloc( pddc->pdv->pDCHeap,
                                        (5*ABBUF_SIZE/4)+sizeof(LONG))))
  {
    return( GPI_ERROR );
  }
  else
  {
    pddc->pdv->Compress85 += sizeof(LONG); /* First long is a flag for CompressAscii85 */
  }

  return DEV_OK;
}


/*****************************************************************************\
**
**
**
\*****************************************************************************/

SHORT DevEscEndBITBLT( PDDC pddc, ULONG InCount, PULONG pInData,
                       PULONG pOutCount, PULONG pOutData )
{
  UCHAR    cEndOfRLL = 128;
  PCNFDATA pCNFData = pddc->pdv->pCNFData;                       // @V3.1142031

  /*
  ** Error if not a level 2 postscript printer or set Level 1 locally by dialog
  */
  // @V3.1142031
  if ((pddc->pdv->usLanguageLevel & 0x00FF == 1) ||
      (pCNFData->usPSLevel1 == 1))
  {
    GplErrSetError(  PMERR_DEV_FUNC_NOT_INSTALLED );
    ExitDriver( pddc );
    return (GPI_ERROR);
  }

  if (pddc->pdv->usLanguageLevel & COMPRESS_RLL_MODE)
  {
    WriteChannel( pddc, (PSZ)&cEndOfRLL, 1 );  /*  send end of transmit */
    pddc->pdv->usLanguageLevel &= ~COMPRESS_RLL_MODE;  // get rid of rll flag
  }

  FlushChannel (pddc);  /* Flush any remaining encoded bytes out. */

  if (pddc->pdv->Compress85)
  {
    pddc->pdv->Compress85 -= sizeof(LONG);
    GplMemoryFree((PB)pddc->pdv->Compress85);
  }
  pddc->pdv->Compress85 = NULL;

  PrintChannel ( pddc, (PSZ) "\n~>restore\n");  /* Termination code sent */
                        /* for CompressMode2Out so just send ~> which is */
                        /* termination for CompressAscii85().            */
  return DEV_OK;
}

/*****************************+-----------------+*****************************/
/*****************************| @V3.1137972 End |*****************************/
/*****************************+-----------------+*****************************/

/********************+------------------------------------+********************/
/********************| Start of support for Pages Spooled |********************/
/********************|            @V3.1147985             |********************/
/********************+------------------------------------+********************/

/* New for BIDI */
#ifndef PMSPLB_INCLUDED

ULONG APIENTRY SplQmGetJobID( HSPL   hspl,
                              ULONG  ulLevel,
                              PVOID  pvBuf,
                              ULONG  cbBuf,
                              PULONG pcbNeeded );

ULONG APIENTRY PrtNewPage( HFILE  hDevice,
                           ULONG  ulPageNumber );
#endif

/******************************************************************************\
**
** FUNCTION: LoadNewSpoolerCalls
**
** DESCRIPTION: Loads up the New BIDI Spooler Call addresses
**
\******************************************************************************/

VOID LoadNewSpoolerCalls ( VOID )
{
  HMODULE   hmod;
  APIRET    ulRC;
//CHAR      achObjectName[64];

  pfnSplQmGetJobID = NULL;  /* Default to zero */
  pfnPrtNewPage    = NULL;


  ulRC = DosQueryModuleHandle( "PMSPL", &hmod);
//ulRC = DosLoadModule( achObjectName,
//                      sizeof( achObjectName ),
//                     "PMSPL",
//                      &hmod );

  if ( ulRC != NO_ERROR )
  {
    return;   /* This is Bad */
  }

  ulRC = DosQueryProcAddr( hmod,
                           608,
                           NULL,                           /* "SPLQMGETJOBID" */
                           &pfnSplQmGetJobID );

  if ( ulRC != NO_ERROR )
  {
    pfnSplQmGetJobID = NULL;  /* Default to zero */
  }

  ulRC = DosQueryProcAddr( hmod,
                           602,
                           NULL,                           /* "PRTNEWPAGE" */
                           &pfnPrtNewPage );

  if ( ulRC != NO_ERROR )
  {
    pfnPrtNewPage = NULL;  /* Default to zero */
  }

//DosFreeModule( hmod );

  return;
}


/******************************************************************************\
**
** FUNCTION: GetJobInfo
**
** DESCRIPTION: Fills in GetJobID info
**
\******************************************************************************/

BOOL GetJobInfo( PDDC pddc )
{
  QMJOBINFO   QMJobInfo;
  PQMJOBINFO  pQMJobInfo;
  ULONG       ulSizeNeeded;
  APIRET      ulRC;
  PCN         pcn;


  /*
  ** If the entry point is null there is nothing to do
  */
  if ( pfnSplQmGetJobID == NULL )
  {
    return FALSE;
  }

  pcn = &pddc->pdv->cn;
  pcn->pQMJobInfo = NULL;  /* Make sure null until OK */

  ulSizeNeeded = sizeof( QMJOBINFO );

  /* This call will set the size */
  ulRC = pfnSplQmGetJobID( pcn->fh,            // Spooler handle
                           0,                  // Level 0
                           (PVOID)&QMJobInfo,  // buffer
                           ulSizeNeeded,
                           &ulSizeNeeded );
  // @V4.0183775
  // This is network case strings are in another buffer
  // We need to allocate the sting buffer ourselves and copy the whole
  // thing over
  if ( ulRC == NO_ERROR )
  {
    PBYTE p;
    INT iNameSize = 0;
    INT iQueSize = 0;


    if ( QMJobInfo.pszComputerName != NULL )
    {
      iNameSize = strlen( QMJobInfo.pszComputerName ) + 1;
    }

    if ( QMJobInfo.pszQueueName != NULL )
    {
      iQueSize = strlen( QMJobInfo.pszQueueName ) + 1;
    }

    ulSizeNeeded = sizeof( QMJOBINFO ) + iNameSize + iQueSize;


    pQMJobInfo = GplMemoryAlloc( pddc->pdv->pDCHeap, ulSizeNeeded );
    if ( pQMJobInfo == NULL )
    {
      return FALSE;
    }
    // Copy the struct over - note if there are null ptrs they will be copied
    // too
    *pQMJobInfo = QMJobInfo;
    p = (PBYTE)pQMJobInfo + sizeof( QMJOBINFO );        // Point to string area

    if ( QMJobInfo.pszComputerName != NULL )
    {
      strcpy( p, QMJobInfo.pszComputerName );           // Copy name over
      pQMJobInfo->pszComputerName = (PSZ)p;             // Save ptr to name
      p += iNameSize;                                   // Move ptr
    }
    if ( QMJobInfo.pszQueueName != NULL )
    {
      strcpy( p, QMJobInfo.pszQueueName );              // Copy que over
      pQMJobInfo->pszQueueName = (PSZ)p;                // save ptr to que
    }

    pcn->pQMJobInfo = pQMJobInfo;
    return TRUE;    /* This is what we need */
  }
  else
  if ( ulRC == ERROR_MORE_DATA )
  { /*Retry with the correct size */
    pQMJobInfo = GplMemoryAlloc( pddc->pdv->pDCHeap, ulSizeNeeded );
    if ( pQMJobInfo == NULL )
    {
      return FALSE;
    }

    /* This should get what we need */
    ulRC = pfnSplQmGetJobID( pcn->fh,            // Spooler handle
                             0,                  // Level 0
                             (PVOID)pQMJobInfo,  // buffer
                             ulSizeNeeded,
                             &ulSizeNeeded );
    if ( ulRC != NO_ERROR )
    { /* Error condition */
      GplMemoryFree( pQMJobInfo );
      return FALSE;
    }
    else
    {
      pcn->pQMJobInfo = pQMJobInfo;
      return TRUE;    /* This is what we need */
    }
  }

  return FALSE; /* Must be some other error condition */
}


/******************************************************************************\
**
** FUNCTION: ClearJobInfo
**
** DESCRIPTION: Clears out GetJobID info
**
\******************************************************************************/

VOID ClearJobInfo( PDDC pddc )
{
  PCN pcn = &pddc->pdv->cn;

  if( pcn->pQMJobInfo )
  {
    GplMemoryFree( pcn->pQMJobInfo );
    pcn->pQMJobInfo = NULL;
  }

  return;
}


/******************************************************************************\
**
** FUNCTION: IncPagesSpooled
**
** DESCRIPTION: Bumps the pages spooled number by one
**
\******************************************************************************/

VOID IncPagesSpooled( PDDC pddc )
{
  PQMJOBINFO  pQMJobInfo;
  PRJINFO4    prjInfo4;
  PCN         pcn = &pddc->pdv->cn;
  ULONG       ulSizeNeeded;
  APIRET      ulRC;

  /*
  ** If JobInfo is null there is nothing to do
  */
  if ( pcn->pQMJobInfo == NULL )
  {
    return;
  }

  pQMJobInfo = pcn->pQMJobInfo;

  ulRC = SplQueryJob( pQMJobInfo->pszComputerName,
                      pQMJobInfo->pszQueueName,
                      pQMJobInfo->ulJobID,
                      4,
                      (PVOID)&prjInfo4,
                      sizeof (prjInfo4),
                      &ulSizeNeeded);

  if ( ulRC == NO_ERROR       ||
       ulRC == ERROR_MORE_DATA )
  {
    /* Increment the number of pages spooled */
    prjInfo4.ulPagesSpooled++;

    /* Update the spooler */
    ulRC= SplSetJob( pQMJobInfo->pszComputerName,
                     pQMJobInfo->pszQueueName,
                     pQMJobInfo->ulJobID,
                     4,
                     (PVOID)&(prjInfo4.ulPagesSpooled),
                     sizeof (prjInfo4.ulPagesSpooled),
                     PRJ_PAGESSPOOLED_PARMNUM );
  }

  return;
}


/******************************************************************************\
**
** FUNCTION: IncPagesPrinted
**
** DESCRIPTION: Bumps the pages spooled number by one
**
\******************************************************************************/

VOID IncPagesPrinted( PDDC pddc )
{
  if ( pfnPrtNewPage == NULL )
  {
    return;
  }

  pfnPrtNewPage( pddc->pdv->cn.fh, pddc->pdv->shPageno );

  return;
}


/*****************************+-----------------+*****************************/
/*****************************| @V3.1147985 End |*****************************/
/*****************************+-----------------+*****************************/


/******************************************************************************\
**
** FUNCTION: DevEscGetJobID
**
** DESCRIPTION: Supports the DEVESC_GETJOBID
**
\******************************************************************************/

SHORT DevEscGetJobID( PDDC    pddc,
                      ULONG   InCount,
                      PULONG  pInData,
                      PULONG  pOutCount,
                      PULONG  pOutData  )
{
  PCN  pcn = &pddc->pdv->cn;
  LONG ulDataSize;
  PQMJOBINFO  pQMJobInfo;

  /* Input data is RESERVED */
  if ( InCount != 0 ||
       pInData != 0 )
  {
    return ERROR_INVALID_PARAMETER;
  }

  /* No Job info */
  if ( pcn->pQMJobInfo == NULL )
  {
    return NERR_JobNotFound;
  }

  /* Get size of data needed */
  ulDataSize =  GplMemoryGetObjectSize( pcn->pQMJobInfo );

  /* Need enough room for at least basic data */
  if ( *pOutCount < sizeof( QMJOBINFO ) )
  {
    *pOutCount = ulDataSize;
    if ( ! pOutData )
    {
      return DEV_OK;
    }
    else
    {
      return NERR_BufTooSmall;
    }
  }

  pQMJobInfo = (PQMJOBINFO)pOutData;

  /* Buffer big enough for id at least */
  if ( *pOutCount >= sizeof( QMJOBINFO ) &&
       *pOutCount <  ulDataSize           )
  {
    pQMJobInfo->ulJobID = pcn->pQMJobInfo->ulJobID;
    *pOutCount = ulDataSize;
    if ( ! pOutData )
    {
      return DEV_OK;
    }
    else
    {
      return ERROR_MORE_DATA;
    }
  }
  else  /* plenty big */
  {
    INT iOffset;
    /* The copy will take care of job # and null ptrs */
    memcpy( pQMJobInfo, pcn->pQMJobInfo, ulDataSize );
    if ( pcn->pQMJobInfo->pszComputerName )
    {
      iOffset = (PBYTE)pcn->pQMJobInfo->pszComputerName -
                                                       (PBYTE)pcn->pQMJobInfo;
      pQMJobInfo->pszComputerName = (PSZ)((PBYTE)pQMJobInfo + iOffset);
    }
    if ( pcn->pQMJobInfo->pszQueueName )
    {
      iOffset = (PBYTE)pcn->pQMJobInfo->pszQueueName - (PBYTE)pcn->pQMJobInfo;
      pQMJobInfo->pszQueueName = (PSZ) ((PBYTE)pQMJobInfo + iOffset);
    }

    *pOutCount = ulDataSize;
  }

  return DEV_OK;
}


/*****************************************************************************\
**                                                                        @DEM
** FUNCTION: DataOut
**
** DESCRIPTION:
**  Worker routine for DEVESC_RAWDATA and DEVESC_MACRO.  Will dump data out to
**  the printer
**
** PARAMETERS:
**  See Below
**
** RETURNS:
**  Error code of write
**
\*****************************************************************************/
SHORT
DataOut( PDDC   pddc    ,
         ULONG  InCount ,
         PULONG pInData )
{
  PDV pdv = pddc->pdv;

  /*
  ** DEVESC_RAWDATA is illegal if no DEVESC_STARTDOC has been done.
  */
  if (!pdv->fDocStarted)
  {
    RIP( "DEVESC_RAWDATA was called without DEVESC_STARTDOC." );
    ExitDriver( pddc );
    return( DEVESC_ERROR );
  }

  /*
  ** make sure the output channel is open.  once it is, just
  ** dump the raw data to it.
  */
  if (!pdv->cn.fChannelOpen)
  {
    PBYTE pB = (PBYTE)pInData;
    /*                                                       //@V3.0116308
    ** Need to sniff the raw data to see if we need to add mode strings
    */                                                       //@V3.0116308
    if ( InCount > 2 ) /*If some data */                     //@V3.0116308
    {                                                        //@V3.0116308
       // If first byte is ctl-D bump past it   ///LMT///
       if ( *pB == '\004' )
       {
         pB++;
       }
       /*
       ** @V3.1146873
       ** Add check for '!'.
       */
       if ( ! ( *(pB) == '%' &&                              //@V3.0116308
            *((pB)+1) == '!'  ) )                            //@V3.0116308
       {                                                     //@V3.0116308
         /* Raw Data has some type mode string */            //@V3.0116308
         /* Turn off mode switching            */            //@V3.0116308
         pdv->usInitLength = 0;                              //@V3.0116308
         /* Turn off ctl d - asumed to have one.. */         //@V3.0116308
         SETFLAG( pdv->ulGenFlags, NO_CTL_D );               //@V3.0116308
       }                                                     //@V3.0116308
       else
       {
         /*         ** We need to send JCL2PS command in case of PM_Q_RAW and
         ** there are %!PS-Adobe.. at begining of data
         */
         SETFLAG( pdv->ulGenFlags, SEND_JCL2PS );            
       }
    }                                                        //@V3.0116308

    // @V4.0177048
    // Check RC from openchannel
    if ( OpenChannel( pddc ) != TRUE )
    {
      ExitDriver( pddc );
      return( DEVESC_ERROR );
    }
  }

  /*
  ** This could be an app that is sending us postscript command
  ** via RawData, if no other output has been sent then we need
  ** to tell the spooler to start the document if it is queued.
  ** But only start the document once.
  */
  if (!pdv->fQMStartDocIssued)
  {
    /*
    ** If this is a queued DC, then tell the spooler to start the
    ** document.
    */
    if (pddc->iType == OD_QUEUED)
    {
      if (!SplQmStartDoc( (HSPL) pdv->cn.fh, (PSZ)pdv->szDocName ))
      {
        RIP( "DEVESC_RAWDATA SplQmStartDoc failed." );
        GplErrSetError( PMERR_STARTDOC_NOT_ISSUED );
        ExitDriver( pddc );
        return( DEVESC_ERROR );
      }
      pdv->fQMStartDocIssued = TRUE; /* We've issued a SplQmStartDoc */
    }
  }

  /*
  ** write channel will just write out what is in the buffer.
  ** it will NOT add a header to the output.  this is good.
  */
  /*
  ** Change type-cast for InCount from SHORT to USHORT to
  ** correct DRAG-DROP bug.
  */
  
  WriteChannel( pddc, (PB)pInData, (USHORT) InCount );
  SETFLAG( pdv->ulGenFlags, DID_RAWDATA );                   //@V4.0160389
  return ps_status( pddc );
}

