/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/***************************************************************************
 *
 * SOURCE FILE NAME = DEVBLOCK.C
 *
 * DESCRIPTIVE NAME = Contains Device Block related routines.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : This file contains prde_FillPdb, prde_FillLdb, prde_DisablePdb
 *               and related routines.
 *
 *
 * FUNCTIONS :         ClearMem
 *                     MatchHWFontName
 *                     PaperDimensions
 *                     ImageCoords
 *                     ScanString
 *                     pszStrChr
 *                     szDCopy
 *                     BuildKeyName
 *                     CmndPaper
 *                     CmndInpTray
 *                     LoadInfoSegment
 *                     FreeMemory
 *                     EnableDebug
 *                     SetCanvasMetrics
 *                     PpdDefaults
 *                     prde_FillPdb
 *                     GetFirstPrinterMatch
 *                     prde_FillLdb
 *                     CleanUpDDC
 *                     prde_DisablePdb
 *                     Exitpdd
 *                     ValidateDriveData
 *                     LoadProfile
 *                     CheckSegName
 *                     ProfileAllocStringQuery
 *                     SearchExtraDV
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#pragma pack(1)
/*
** Include GENPLIB error handling.
*/
#define  INCL_ERRORS
#define  INCL_PM
#define  INCL_DOS
#define  INCL_DOSINFOSEG
#define  INCL_DOSDEVICES
#define  INCL_DEV
#include "inc\prdinclt.h"
#include "inc\prdgextf.h"
#include "inc\prdeextf.h"
#include "inc\prdmath.h"
#include "inc\prderre.h"
#include "inc\utl.h"
#include "inc\profile.h"           //@V3.1147743
#define  INCL_WINSHELLDATA
#define  INCL_INCL_WINSHELLDATA
#define  OD_MEMORY     8L
#define  NGREMAX  222
#include <string.h>
#define  INCL_SPL
#define  INCL_SPLDOSPRINT
#define  INCL_SPLERRORS
#include <pmspl.h>
#include <pmerr.h>
#include "inc\config.h"
#include "inc\pspagtun.h"             /* V2.174057  Page Tuning */
#define  INCL_GENPLIB_ERROR
#define  INCL_GENPLIB_MEMORY
#define  INCL_GENPLIB_HANDLER
#define  INCL_GENPLIB_GAMMA  /* @V3.0GAMMA1 */
#define  INCL_GENPLIB_GPLEDC
#define  INCL_GENPLIB_FONTMGR
#include <genplib.h>
// @V3.0129238
#include "inc\dbcsfont.h"                                               //@DBCS
#include "inc\init.h"                                            // @V3.1142031
// @V3.1142031
#include "inc\uinames.h"

/*
** @V3.0129238
** Defines the LDRIVDATA size for OS/2 1.3
*/
#define   PRE_13_BUFFER_SIZE   696

typedef struct
    {                   /* kran */
    PFNL pfnl;
    int nParams;
    } VCTD;
extern VCTD od_memory_vect[NGREMAX+1];
extern PBYTE StringTable[MAX_STRINGS]; /* devmode.c                         */
extern PVOID pProcessHeap;
extern Semaphore lpPCThreadDataSem;
extern DeviceSemaphoreTable lpDevSemTable;
extern DDTType DDT;
extern VOID FillSFonts( PDV, PVOID,SHORT,USHORT );   
extern SHORT SFQueryFonts( PDV );
extern LONG DefaultFontCount( PDESPPD );        
extern PSZ GetDefaultPageSize( PDESPPD, PBYTE );
extern PFORMSTRUCT GetImageableArea( SHORT, PFORMSTRUCT, PDESPPD, PBYTE );
extern INT  _Optlink CompareRealNames( PSZ, PSZ );  
extern enum DDState prd_DDState;
extern HMTX tsemDriver; /* Global Driver semaphore           */
extern HMODULE pscript_module;

ARGERRRET  *aAER = (ARGERRRET  *) -1;


BOOL  ValidateDriveData(PLDRIVDATA,PCNFDATA);
VOID  CheckSegName(PCNFDATA,PB  *);
VOID  LoadProfile(PB  *);
/* extern HMODULE hmodDisplay; */
extern VOID   SetLDBFlag( VOID );
extern PSZ FontFullName[];
extern PSZ FontResourceName[];
extern PDV CreateDCHeap( VOID );
extern VOID SetUpJPResource( PDV, PLDRIVDATA );
/*
*/
typedef struct _xDEVOPENSTRUC {
    DEVOPENSTRUC dos;
    ULONG      ulStateInfo;
    ULONG      ulType;      /* Need this */
    ULONG      ulHDC;
} xDEVOPENSTRUC;
typedef xDEVOPENSTRUC FAR *xPDEVOPENSTRUC;
#define OD_QUEUED 2L
#define OD_DIRECT 5L

/*
** @V3.0129238
*/
PUI_BLOCK QueryBlockFromKeyword( PUI_LIST, PBYTE, PBYTE, PINT );
PUI_ENTRY QueryEntryFromOption( PBYTE, PUI_BLOCK, PBYTE, PINT );
extern VOID SaveINIGroupData( PBYTE, PBYTE );
extern BOOL _System szIsEqual( PSZ, PSZ );
// @V3.1147743 - SetUIOption now returns INT
INT SetUIOption( PDESPPD, PUI_SEL, PBYTE, PBYTE );
PBYTE AllocDesItems( UINT, PBYTE * );
VOID FreePPBResource( PDESPPD );
VOID SaveCurrentUISelections( PDESPPD, PCNFDATA );
VOID LoadCurrentUISelections( PDESPPD, PCNFDATA );
PDESPPD LoadPPBResource( PDV, PSZ );
//BOOL VerifyUISelectionList( PDESPPD, PCNFDATA );               // @V3.1142031
VOID CopyDEVOPENSTRUCData( PDV, PDEVOPENSTRUC );                 // @V3.1142031

// @V3.0130814
VOID QueryDefDrivFromQue( PDEVOPENSTRUC, PPRQINFO6, PDRIVDATA *, PBOOL );
BOOL BuildKeyName( PDEVOPENSTRUC, PSZ, PSZ *, PDV, PDRIVDATA *, PBOOL );   //@V3.1140397
VOID ConvertColorModel( PDESPPD, PCNFDATA, PDV );

PLDRIVDATA AllocateLDRIVDATABuffer( HMCB, PLDRIVDATA, PCNFDATA );
// @V3.1137542 - PDESPPD is no longer needed.
//VOID CopyLDRIVDATAtoCNFDATA( PDESPPD, PCNFDATA, PLDRIVDATA );
VOID CopyLDRIVDATAtoCNFDATA( PCNFDATA, PLDRIVDATA );
PBYTE QueryUIOptionString( PDESPPD, PUI_SEL, PBYTE, PINT, PUI_BLOCK * );
extern PCNFDATA AllocCNFStructure( PDESPPD, BOOL );
extern VOID FreeCNFStructure( PCNFDATA );
extern BOOL VerifyLDDCNFStructure( PDESPPD, PLDRIVDATA );
extern SHORT szDlmCopy( register PSZ, register PSZ pszSrc, register SHORT );
extern BOOL CompareStri( PSZ, PSZ );                              //@V3.1140397
VOID ResStrToBin( PSZ, PRESOLUTION );                             //@V3.1147608
VOID GetCurrentResolution( PRESOLUTION, PDESPPD, PCNFDATA );      //@V3.1147608

PEXTRA_DV SearchExtraDV( PSZ szDeviceName );


/*
** Keywords defined for retrieving information from os2.ini
** and writing information to os2.ini
*/

CHAR szPMSPOOLERP[] = "PM_SPOOLER_PRINTER";/* The segment name under which
                                          device name is stored             */
CHAR szPMSPOOL[] = "PM_SPOOLER";
CHAR szPMPRINTER[] = "PRINTER";        /* The minor key name under which
                                          device name is stored             */

#if      DEBUG
BOOL fRipOnEnter = FALSE;
#endif                                 /* DEBUG                             */
void   szCopy(PSZ,PSZ,int);

/*
** Function to allocate a buffer and store a profile string.
*/
LONG ProfileAllocStringQuery( HINI, PSZ, PSZ, PSZ, PPVOID );

/*
*/
extern INT _Optlink CopyStr( PSZ, PSZ );

extern ULONG ULGreVersion;
VOID   Hook22Calls( PFNL * );

extern GLOBALDATA globals;
extern ULONG APIENTRY ExceptHandler( );
extern USHORT DecompressString( PSZ, PSZ ); //@V3.0CMPS01
extern LONG UsePrinterDeviceFonts( VOID );                        //@V3.0124227
extern BOOL GetOldFormName( PDESPPD, PSZ, PSZ );
extern LONG SetNewFormName( PSZ , PDESPPD, PCNFDATA );            //@V3.2115649
BOOL CheckForPrinterName( PSZ );

SHORT MatchHWFontNameJpn( PSZ );                                        //@DBCS
static BOOL flMin = FALSE, flGot = FALSE;                               //@DBCS

// @V3.1142031 - No longer needed.

/***************************************************************************
 *
 * FUNCTION NAME =  MatchHWFontName
 *
 * DESCRIPTION   =
 *
 * Returns the index number (1-n), in the current printer's list of supported
 * fonts, of the font that has the specified face name, or 0 if not found.
 *
 * Effects: Scans the list of all fonts offered by the current printer until
 *          one is found whose font name is the same as that requested. The
 *          index of this matching font is then returned. If no match is
 *          found, 0 is returned.
 *
 * Warnings: Fonts have two different names.  The FullName is the most
 *           complete; an example is "ITC Avant Garde Gothic Book Oblique".
 *           However, the font names used in the printer font list have an
 *           abbreviated form like "AvantGarde-BookOblique".
 *
 * INPUT         = PSZ     pszFontName
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = Index number of desired font, or 0 if it wasn't found.
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

SHORT MatchHWFontName( PSZ pszFontName )
{
  SHORT i;

  /*
  ** Find the resource number corresponding to this fontfullname
  */
  for (i = 0; FontResourceName[i]; i++)
  {
    if (szIsEqual(pszFontName,
                  (PSZ)FontResourceName[i]) )
    {
      return  i;
    }
  }

  return 0;
}

/***************************************************************************
 *
 * FUNCTION NAME =  PaperDimensions
 *
 * DESCRIPTION   =
 *
 *           Returns pointer to page dimensions in terms of picture cells .
 *
 * INPUT         = 1.Paper name , & 2.array of pointer to printer resources
 *
 *                 CHAR  *szPaperName    pointer to paper name
 *                 PB   * apResources    array of pointer to
 *                                          printer resources
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 *           Returns Null if paper name not found else pointer to array of
 *           paper dimensions.
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/
SHORT *PaperDimensions( CHAR *szPaperName, PDESPPD pdesPpd )
{
  PUI_BLOCK pUIBlock;
  USHORT    usLoop;
  PSZ       pFormName;
  PSHORT    pDimension = NULL;

  if ((pUIBlock = QueryBlockFromKeyword( &pdesPpd->stUIList,
                                         pdesPpd->pPSStringBuff,
                                         UINAME_PAGESIZE, NULL )) != NULL)
  {
    pDimension = (PSHORT) (pdesPpd->pPSStringBuff +
                           pdesPpd->desPage.ofsDimxyPgsz);

    for (usLoop = 0 ; usLoop < pUIBlock->usNumOfEntries ; usLoop++)
    {
      pFormName = (PSZ) (pdesPpd->pPSStringBuff +
                         pUIBlock->uiEntry[ usLoop ].ofsOption);

      if (!CompareRealNames( szPaperName, pFormName ))
      {
        pDimension++;
        break;
      }
      else
      {
        pDimension += 3;
      }
    }
  }

  return( pDimension );
}

/***************************************************************************
 *
 * FUNCTION NAME =  ImageCoords
 *
 * DESCRIPTION   =
 *
 *    Returns pointer to image coordinates in terms of picture cells
 *
 * INPUT         = 1.Paper name , & 2.array of pointer to printer resources
 *
 *                 CHAR  *szPaperName    pointer to paper name for which
 *                                          image coords reqd
 *                 PB    *apResources    array of pointers to printer
 *                                          resources
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 *           Returns Null if paper name not found else pointer to array of
 *           paper imageable coordinates.
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/
// @V3.1142031
SHORT *ImageCoords( CHAR *szPaperName, PDESPPD pdesPpd )
{
  SHORT      i, k;      /* scratch index variables               */
  FORMSTRUCT FormStruct;

  k = pdesPpd->desPage.iImgpgpairs;    /* count of such pairs               */

  /*
  ** Get each Imageable area - if it matches paper name return coords
  */
  for ( i = 0; i < k; i++ )
  {
    GetImageableArea( i, (PFORMSTRUCT)&FormStruct, pdesPpd,
                      pdesPpd->pPSStringBuff );

    /*
    ** @V3.0129238
    ** Change to CompareRealNames.  It is possible that Translation strings
    ** may exists.  Do not compare translation strings.
    */
    if (!CompareRealNames( FormStruct.FormName, szPaperName ))
    {
      return (PSHORT)FormStruct.Data;
    }
  }

  return (NULL);
}


/***************************************************************************
 *
 * FUNCTION NAME =  pszStrChr
 *
 * DESCRIPTION   = Looks for chTarget in pszSource - if found returns
 *                 pointer to location else returns NULL (like runtime strchr
 *
 * INPUT         = PSZ  pszSource
 *                 CHAR chTarget
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = pointer to location chTarget
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

PSZ pszStrChr( PSZ pszSource, CHAR chTarget )
{

  while (*pszSource && *pszSource != chTarget)
  {
    pszSource++;
  }

  if (*pszSource)
  {
    return( pszSource );
  }
  else
  {
    return( NULL );
  }
}

/***************************************************************************
 *
 * FUNCTION NAME =  szDCopy
 *
 * DESCRIPTION   = Duplicates an null terminated or delimiter terminated
 *                 string with bounds
 *                 checking to prevent overflow of the destination buffer.
 *
 * INPUT         = PSZ pszDst     Ptr to the destination buffer
 *                 PSZ pszSrc     Ptr to the source string
 *                 SHORT nbDst    Size of the destination buffer
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

SHORT szDCopy( PSZ pszDst, PSZ pszSrc, SHORT nbDst )
{
  SHORT i;
  i = 0;

  while (*pszDst++ = *pszSrc++)
  {
    i++;

    if (nbDst-- <= 0 || *(pszSrc-1) == ';' || *(pszSrc-1) == ',')
    {
      i--;
      *--pszDst = 0;
      break;
    }
  }
  return( i );
}

/*
** Device Driver Conference in San Jose 7/93
*/
/***************************************************************************
 *
 * FUNCTION NAME = BuildKeyName
 *
 * DESCRIPTION   = Builds the key name in form of:
 *                 PM_DD_<printerName>,<deviceDriver>.<deviceName>
 *                 The informaton is pulled out of ini file under key of
 *                 PM_SPOOLER_PRINTER.  If the information can't be found
 *                 we can use defaults as long as the type of device is known.
 *
 *                 @V3.0129238
 *                 In rare cases, the DRIVDATA passed in does not contain
 *                 valid data.  In this case, we need to query the queue to
 *                 receive the queue data and return it to the calling
 *                 function.
 *
 * INPUT         = PDEVOPENSTRUC   pdop      Pointer to devopen structure
 *                 PSZ             pszKeyApp Application name for printer
 *                 PDV             pdv       Device Structure
 *
 * OUTPUT        = ppDeviceName - Name of device currently in use
 *                 ppTempDriv - Optional - If not NULL, returns DRIVDATA from
 *                   queue.
 *
 *
 * RETURN-NORMAL = BOOL: TRUE if port
 *                       FALSE if not
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/
// VOID BuildKeyName( PDEVOPENSTRUC pdop, PCNFDATA pcnfData, PDV pdv )
/*
** @V3.0129238
** PCNFDATA can no longer be used as an argument becuase it is now variable
** length.  The device name is needed before PCNFDATA can be allocated.
*/
BOOL BuildKeyName( PDEVOPENSTRUC pdop, PSZ pszKeyApp, PSZ *ppDeviceName,
                   PDV pdv, PDRIVDATA *ppTempDriv, PBOOL pIsDestnLAN )
{
  /*
  ** @V3.013084
  ** For querying if printing to the LAN, change qbuf in this function from
  ** PPRQINFO3 to PPRQINFO6.  Change all code that accesses this buffer to the
  ** new format.
  */
  BOOL      fUseDefaultDev = TRUE;
  CHAR      chDriverDevice[ 64 ];
  PPRDINFO3 pbuf = NULL;
  PPRQINFO6 qbuf = NULL;
  PBYTE     MemPbuf = NULL;
  PBYTE     MemQbuf = NULL;
  PSZ       pszComma;
  PSZ       pszDeviceName  = "";
  PSZ       pszPrinterName = NULL;
  SHORT     i;
  ULONG     count = 0;
  ULONG     returned, total, needed;
  BOOL      fFoundDefault = FALSE;                                //@V4.0157269
  PPRQINFO6 pLastPSqbuf = NULL;                                   //@V4.0157269

  /*
  ** @V3.0129238
  ** Initialize *ppTempDrivData to NULL if one is provided.
  */
  if (ppTempDriv != NULL)
  {
    *ppTempDriv = NULL;
  }

  // @V3.0130814
  *pIsDestnLAN = FALSE;

  chDriverDevice[0] = 0;

  /* Check user supplied printer name */
  if ( pdop         &&
       pdop->pdriv  &&
       ( pdop->pdriv->cb >= ( sizeof( DRIVDATA ) - 1 ) ) )
  {
    if ( strlen( pdop->pdriv->szDeviceName ) )
    { /*
      ** Build the Hardcopy_driver.Device_Name part of key
      */
      if ( CheckForPrinterName( pdop->pdriv->szDeviceName ) == FALSE )
      {
        GetPrinterOnLogAddr( pdop->pszLogAddress,
                             pdop->pszDriverName,
                             pdop->pdriv->szDeviceName,
                             "Generic PostScript Printer",
                             sizeof(pdop->pdriv->szDeviceName) );
      }
      i = CopyStr( chDriverDevice, pdop->pszDriverName );
      i += CopyStr( chDriverDevice + i, "." );
      CopyStr( chDriverDevice + i, pdop->pdriv->szDeviceName );
      fUseDefaultDev = FALSE;
    }
  }

  /* Check Logical address */
  if( (! pdop->pszLogAddress) ||
      (! *pdop->pszLogAddress)   )
  { /*
    ** No Destination logical address.  Enumerate the queues and get default
    */
    // @V3.0130814 - Change 3 to 6 for modified qbuf.
    SplEnumQueue( NULL, 6L, qbuf, 0L, &returned, &total, &needed, 0L );
    MemQbuf = GplMemoryAlloc( pProcessHeap, needed ); 
    qbuf = (PPRQINFO6)MemQbuf;
    count = needed;
    SplEnumQueue( NULL, 6L, qbuf, count, &returned, &total, &needed,
                  0L );
    /* Check each Queue for default */
    for ( i = 0; i < returned; i++ )
    {
      /* Is it a PostScript printer? */
      if ( !strncmp( qbuf->pszDriverName, PSCRIPT_DRV_NAME,
                                                 sizeof(PSCRIPT_DRV_NAME)-1 ) )
      {
        pLastPSqbuf = qbuf;                                       //@V4.0157269
        pszPrinterName = qbuf->pszPrinters;
        if ( fUseDefaultDev )
          pszDeviceName  = qbuf->pszDriverName;

        if ( qbuf->fsType & PRQ3_TYPE_APPDEFAULT )  /* Is it the default */
        {
          fFoundDefault = TRUE;                                   //@V4.0157269
          break;
        }
      }
      qbuf++;
    }

    /* @V4.0157269
    ** If no default printer found use the last known postscript printer
    */
    if ( fFoundDefault == FALSE )
    {
      if ( pLastPSqbuf )
      {
        qbuf = pLastPSqbuf;
      }
      else  /* No PS printer found, return error */
      {
        return FALSE;
      }
    }

    /*
    ** @V3.0129238
    ** If a return pointer exists, then copy the queue data to the return
    ** pointer.  This is to fix any invalid DRIVDATA buffers that come in.
    ** This is a temporary solution and should be migrated to another piece
    ** of code later.  Because of the majority of changes made in this code
    ** because of the User Interface, it is preferred that 'simple' changes
    ** be made now and upgraded later.
    */
    QueryDefDrivFromQue( pdop, qbuf, ppTempDriv, pIsDestnLAN );
  }
  else
  /*
  ** Lets check if pszLogAddress is a Queue
  */
  if ( SplQueryQueue( NULL, pdop->pszLogAddress, 6, qbuf, 0L, &needed ) ==
       NERR_BufTooSmall )
  { /* Yes - a queue exists with that name */
    MemQbuf = GplMemoryAlloc( pProcessHeap, needed );  
    qbuf = (PPRQINFO6)MemQbuf;
    count = needed;
    SplQueryQueue( NULL, pdop->pszLogAddress, 6, qbuf, count, &needed );
    pszPrinterName = qbuf->pszPrinters;
    if ( fUseDefaultDev )
      pszDeviceName  = qbuf->pszDriverName;

    /*
    ** @V3.0129238
    ** Query the DRIVDATA from the queue, in the case the current DRIVDATA is
    ** invalid.
    */
    QueryDefDrivFromQue( pdop, qbuf, ppTempDriv, pIsDestnLAN );
  }
  else
  { /*
    ** pszLogAddress is not a queue - must be a port or file name
    --
    ** Get list of all printers
    */
    SplEnumDevice( NULL, 3L, pbuf, 0L, &returned, &total, &needed, 0L );
    MemPbuf = GplMemoryAlloc( pProcessHeap, needed ); 
    pbuf = (PPRDINFO3)MemPbuf;
    count = needed;
    SplEnumDevice( NULL, 3L, pbuf, count, &returned, &total, &needed, 0L );

    /*
    ** Since passed in file names are fully qualified look for ':'
    */
    for ( i = 0; i < returned; i++ )
    {
      if ( ! strcmp( pdop->pszLogAddress, pbuf->pszLogAddr ) )
      {
        pszPrinterName = pbuf->pszPrinterName;
        if ( fUseDefaultDev )
          pszDeviceName  = pbuf->pszDrivers;
        SETFLAG( pdv->ulGenFlags, IS_DIRECT_PORT );               //@V3.0116308
        break;
      }
      else
      if ( ( ! strcmp( pbuf->pszLogAddr, "FILE" ) ) &&
           pdop->pszLogAddress[1] == ':'             )
      { /* File name */
        SETFLAG( pdv->ulGenFlags, PRINT_TO_FILE );                //@V3.0116308
        if ( fUseDefaultDev )
        { /* No device supplied, use the first one */
          pszPrinterName = pbuf->pszPrinterName;
          pszDeviceName  = pbuf->pszDrivers;
          break;
        }
        else
        do
        {
          if ( ( pszComma = strchr( pbuf->pszDrivers, ',' ) ) != 0 )
            *pszComma = 0;    /* break up line */

          if ( ! strcmp ( pbuf->pszDrivers, chDriverDevice ) )
          {
            pszPrinterName = pbuf->pszPrinterName;
            break;
          }
          pbuf->pszDrivers = pszComma+1;

        } while ( pszComma );

        if ( pszPrinterName )
          break;
      }
      pbuf++;
    }
  }

  if ( ! pszPrinterName )
    pszPrinterName = " ";

  if ( (pszComma = strchr( pszPrinterName, ',' )) != 0 )
    *pszComma = 0;

  if ( fUseDefaultDev &&
       ( pszComma = strchr( pszDeviceName, ',' ) ) )
    *pszComma = 0;

  /*
  ** Now build the key
  */
  CopyStr( pszKeyApp, (PSZ) "PM_DD_" );
  strcat( pszKeyApp, pszPrinterName );
  strcat( pszKeyApp, "," );
  if ( fUseDefaultDev )
    strcat( pszKeyApp, pszDeviceName );
  else
    strcat( pszKeyApp, chDriverDevice );

  /*
  ** If no device use generic
  */
  if ( (pszDeviceName = strchr( pszKeyApp, '.' )) != 0 )
    pszDeviceName++;
  else
    pszDeviceName = (PSZ) GetR3String( IDS_Generic );

  /*
  ** Copy just the device name to other Vars
  */
  //@V3.0129238 - pcnfData no longer used

  *ppDeviceName = pszDeviceName;

  /*
  ** Free bufs if allocated
  */
  if ( MemPbuf )
    GplMemoryFree( MemPbuf );
  if ( MemQbuf )
    GplMemoryFree( MemQbuf );

  return TRUE;                                                    //@V4.0157269

}


/***************************************************************************
 *
 * FUNCTION NAME = LoadInfoSegment
 *
 * DESCRIPTION   =
 *
 *    The printer info segname lies in the variable SegName.
 *    This routines locates the segment and loads it into memory
 *    resident tables.If load successful it returns TRUE else FALSE.
 *
 * Input argument : Array of pointer to printer resources.
 *
 * INPUT         =
 *                 PB    * apResources   array of pointer to printer
 *                                          resources
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

BOOL LoadInfoSegment(PB  *apResources, PVOID pHeap )               //@V3.1138185
{
  HMODULE    hmodule;                  /* Scratch variable to get driver
                                          module handle                     */
  PSIGNATURE pSignature;               /* Pointer to signature              */
  SHORT      i, j;
  SHORT      iCntFiles;                /* Stack var                         */
  SHORT      usDirSize;
  PDRENTRY   pdrTable;                 /* pointer to printer segments
                                          directory table                   */
  PCNFDATA   pcnfData;                 /* pointer to printer configuration
                                          data                              */
  PDESPPD    pdesPpd;                  /* pointer to printer descriptor
                                          segment                           */
  BYTE      *pvPtr;                    /* local pointer to resource         */
  BYTE      *pPpd;                     /* local pointer to PPD              */
  PBYTE      pbScratch;
  CHAR      *pc;
  PLONG      plOffsets;                /* Ptr to offsets                    */
  PSZ       *ppFormIndex;              /* Ptr to ptr table                  */
  PSZ        pszCmpFormName;           /* @V3.0CMPS01  */
  PSZ        pszFormName;              /* @V3.0CMPS01  */
  /*
  ** @V3.012938
  ** Pointer to the current UI block.
  */

  pcnfData = (PCNFDATA) apResources[CNFRES];
  hmodule = pscript_module;

  /*
  ** Get the directory of PPBs resource
  */
  if (DosGetResource( hmodule, ALLPPDS,
                      DIRECTORY_PPB, (PPVOID) &pSignature ))
  {
    RIP( "LoadinfoSeg: DosGetResource failed" );
    return( FALSE );
  }

  /*
  **
  ** Copy the number of printers/PPBs
  */
  iCntFiles = pcnfData->iCntFiles = pSignature->cntEntries;

  /*
  ** Make sure there are some printers
  */
  if (iCntFiles == 0)
  {
    DosFreeResource( pSignature );
    return( FALSE );
  }

  /*
  **If pdrTable is null then allocate storage and copy over directory
  **...NOTE... It is the callers job to release the directory memory!!!
  */
  if (apResources[DIRRES] == NULL)
  {
    usDirSize = iCntFiles * sizeof( DRENTRY );

    /*
    ** Allocate storage needed for directory
    */
    if ((apResources[DIRRES] = (PCHAR) GplMemoryAlloc( pHeap,        //@V3.1138185
                                                       usDirSize )) == NULL)
    {
      PrintLog( (PSZ)"Can't allocate DIRECTORY instance\n" );
      DosFreeResource( pSignature );
      return( FALSE );
    }
    pdrTable = (PDRENTRY) apResources[DIRRES];
    pbScratch = (PBYTE) pdrTable;

    /*
    ** Point to directory part
    */
    pvPtr = (BYTE *)((BYTE *)pSignature + sizeof( SIGNATURE ));

    /*
    ** Copy data over
    */
    for (i = 0 ; i < usDirSize ; i++)
    {
      *pbScratch++ = *pvPtr++;
    }
  }

  /*
  ** Got what is needed so free resource
  */
  DosFreeResource( pSignature );
  pdrTable = (PDRENTRY) apResources[DIRRES];

  /*
  ** If lGetPtr is 1 then just return with pcnfData->iCntFiles set and
  ** apResources[DIRRES] loaded with directory
  */
  if (pcnfData->lGetPtr == 1)
  {
    return( TRUE );
  }

  /*
  **  Search for supplied printer name in the directory and if located get
  **  the requisite parameters i.e. length and offset for the printer segment
  **  tobe loaded.
  */
  i = 0;

  while (i < iCntFiles)
  {
    if (szIsEqual( pcnfData->szSegName, (CHAR *)pdrTable ))
    {
      break;
    }
    i++;

    pc = (char *)pdrTable;
    pc += DRENTRYSIZE;
    pdrTable = (DRENTRY *)pc;

    /*
    ** pdrTable++;
    */
    /*
    ** (CHAR *)pdrTable += sizeof( DRENTRY );
    */
  }

  if (i >= pcnfData->iCntFiles)        /* Printer segment name not found    */
  {
    RIP( "LoadInfoSegment: printer name not found" );
    return( FALSE );
  }

  /*
  ** Open resource for individual PPB
  */

  if (DosGetResource( hmodule, ALLPPDS, (SHORT) pdrTable->lResNum,
                      (PPVOID) &pvPtr ))
  {
    PrintLog( (PSZ)"LoadInfoSeg() failed: returning error\n" );
    return( FALSE );
  }

  /*
  ** allocate memory for printer descriptor segment
  */
  if (!(pdesPpd = (PDESPPD)GplMemoryAlloc( pHeap, sizeof(DESPPD))))        //@V3.1138185
  {
    RIP( "LoadInfoSegment: memory allocation failed" );
    DosFreeResource( pvPtr );
    return( FALSE );
  }
  apResources[PPDRES] = (void  *)pdesPpd;

  /*
  ** copy printer descriptor segment from resource file
  */

  pPpd = apResources[PPDRES];

  memcpy( pPpd, pvPtr, sizeof(DESPPD) );
  pvPtr += sizeof(DESPPD);

  /*
  ** @V3.012938 - Allocate memory for UI buffers.
  ** Allocate memory for the list of UI blocks and for the current selection
  ** for each block.
  */
  j = pdesPpd->stUIList.usBlockListSize;
  pdesPpd->stUIList.pBlockList = GplMemoryAlloc( pHeap, j );          //@V3.1138185
  memcpy( (void *) pdesPpd->stUIList.pBlockList, (void *) pvPtr, j );
  pvPtr += j;

  // @V3.1UIC
  j = pdesPpd->stUICList.usNumOfUICs * sizeof( UIC_BLOCK );
  pdesPpd->stUICList.puicBlockList = GplMemoryAlloc( pHeap, j );
  memcpy( (void *) pdesPpd->stUICList.puicBlockList, (void *) pvPtr, j );
  pvPtr += j;

  /*
  ** allocate memory for printer stored items segment
  */
  j = pdesPpd->desItems.iSizeBuffer;

  if (!(apResources[RESBUF] = (void *) GplMemoryAlloc( pHeap, j )))         //@V3.1138185
  {
    RIP( "LoadInfoSegment: RESBUF memory allocation failed" );
    GplMemoryFree( (PB) pdesPpd );
    DosFreeResource( pvPtr );
    return( FALSE );
  }

  /*
  ** Copy over variable part of printer description
  */
  pPpd = (BYTE *)apResources[RESBUF];

  memcpy( pPpd, pvPtr, j );

  DosFreeResource( pvPtr );

  /* @V3.0CMPS01 start */
  /*
  ** Need to decompress some things in the ppb file
  */
  pbScratch = GplMemoryAlloc( pHeap, j );  //Allocate scratch buff         //@V3.1138185
  memcpy( pbScratch, pPpd, j );                   //Copy var data in it

  //Point to compressed form names
  pszCmpFormName = pbScratch + pdesPpd->desForms.ofsFormTable;

  //Point to regular form names
  pszFormName    = pPpd + pdesPpd->desForms.ofsFormTable;
  j = 0;

  //Get offsets of compressed names
  plOffsets = (PLONG)(pbScratch + pdesPpd->desForms.ofsFormIndex);

  //For each compressed name expanded into resbuf
  for ( i = 0; i < pdesPpd->desForms.usFormCount; i++ )
  {

    j = DecompressString( pszCmpFormName, pszFormName ) + 1;
    pszFormName += j;

    plOffsets++;    //To nextOffset

    //Point to next compressed name
    pszCmpFormName = pbScratch + *plOffsets;
  }

  /*
  ** Convert the offsets in Forms index table to pointers
  */
  //FormIndex table is right after names
  ppFormIndex = (PSZ *)pszFormName;

  //Correct offset of table in pdesPpd
  pdesPpd->desForms.ofsFormIndex = (ULONG)pszFormName - (ULONG)pPpd;

  pszFormName = pPpd + pdesPpd->desForms.ofsFormTable;
  for ( i = 0; i < pdesPpd->desForms.usFormCount; i++ )
  {
    ppFormIndex[ i ] =  pszFormName;
    pszFormName += strlen( pszFormName ) + 1;
  }

  GplMemoryFree( pbScratch );
  /* @V3.0CMPS01 end */

  return( TRUE );
}

/***************************************************************************
 *
 * FUNCTION NAME = FreeMemory
 *
 * DESCRIPTION   = To free all the memory allocated from heap.
 *
 * Input argument : Array of pointer to printer resources.
 *
 * INPUT         =
 *                 PB    * apResources   array of pointer to printer
 *                                          resources
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

void FreeMemory( PB *apResources )
{
  SHORT i;

  //Taken care of by FreePPBResource
  apResources[PPDRES] =  apResources[RESBUF] = NULL;
  for (i = 0 ; i < IMAXRES ; i++)
  {
    if (apResources[i] != NULL)
    {
      GplMemoryFree( (PB) apResources[i] );
    }
  }
  return ;
}


/***************************************************************************
 *
 * FUNCTION NAME = SetCanvasMetrics
 *
 * DESCRIPTION   = Set the canvas metrics (size and orientation) for the
 *                 physical device.
 *
 * Input argument :
 *
 * INPUT         = PCANVAS pcan            pointer to canvas structure
 *                 PB  *apResources     array of pointers to printer
 *                                      resources
 *
 * OUTPUT = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR = NONE
 *
 **************************************************************************/
// @V3.1142031
VOID SetCanvasMetrics( PCANVAS pcan, PDESPPD pdesPpd, PCNFDATA pcnfData )
{
  SHORT  i;
  LONG   li, lScale;
  SHORT *piPtr;                    /* pointer to array of integers      */
  CHAR   szPaper[ MAX_PSIZE ];
  int    X;                                                          //@V3.1147608
  int    Y;                                                          //@V3.1147608

  #define  FX_PAPER_WIDTH 0x88000L   /* Paper width = 8.5 inches          */
  #define  FX_PAPER_HEIGHT 0xb0000L  /* Paper height = 11.0 inches        */
  #define  FX_ONEBY72    0x0038DL    /* Multiplier 1/72                   */

  #if      DEBUG
    LogCall( "SetCanvasMetrics(%lp)\n",
            ((PB)&pcan)+sizeof(pcan) );
  #endif                                 /* DEBUG                             */

  /*
  ** store the paper name in array which corresponds to a starting page
  ** no of <= shPageno
  */

  PageAtPaper( (PCNFDATA)  pcnfData, (PSZ)szPaper, (SHORT *)&i );
  lScale = (LONG) pcnfData->jobProperties.uScale;

  /*  ** Assign the currently selected resolution to the print structure.
  ** This is the resolution that will be sent to the print file.
  ** If there are multiple resoulutions use Jop Prop else use ppd
  */
  // @V3.1142031
  GetCurrentResolution( &pcan->Res, pdesPpd, pcnfData );          //@V3.1147608

  if (pcnfData->jobProperties.iOrient != PORTRAIT)                //@V3.1154783
  {                                                               //@V3.1154783
    /* Lets switch resoulution */                                 //@V3.1154783
    i = pcan->Res.x;                                              //@V3.1154783
    pcan->Res.x = pcan->Res.y;                                    //@V3.1154783
    pcan->Res.y = i;                                              //@V3.1154783
  }                                                               //@V3.1154783

  X = (int) ((pcan->Res.x * 100L) / pdesPpd->desItems.lScrFreq );  //@V3.1147608
  Y = (int) ((pcan->Res.y * 100L) / pdesPpd->desItems.lScrFreq );  //@V3.1147608

  /*
  ** noScrFreq was multiplied by 100 at parse time
  */
  /*
  ** total no of pic elements in a rectangle
  */
  pcan->nGrayShades = X * Y + 1;                                   //@V3.1147608

  /*
  ** get array of paper dimension integers
  */
  piPtr = PaperDimensions( szPaper, pdesPpd );


  /* First get numbers then set for orientataion then use resolution */
  if (piPtr == NULL)         //@V3.1154783
  {
    /*
    ** Compute the paper boundary.
    */
    pcan->rclPaper.xLeft  = 0;
    pcan->rclPaper.xRight = 612;
    pcan->rclPaper.yTop   = 792;
    pcan->rclPaper.yBottom = 0;
  }
  else
  {
    pcan->rclPaper.xLeft   = 0;
    pcan->rclPaper.xRight  = *piPtr++;
    pcan->rclPaper.yTop    = *piPtr;
    pcan->rclPaper.yBottom = 0;
  }

  if (pcnfData->jobProperties.iOrient != PORTRAIT)
  {
    li = pcan->rclPaper.yTop;
    pcan->rclPaper.yTop = pcan->rclPaper.xRight;
    pcan->rclPaper.xRight = li;
  }
                             //@V3.1154783
  pcan->rclPaper.xRight = (LONG)pcan->rclPaper.xRight * (LONG)pcan->Res.x / 72L;
  pcan->rclPaper.yTop = (LONG)pcan->rclPaper.yTop * (LONG)pcan->Res.y /72L;

  /*
  ** at the request of excel we are returning the page size as
  ** the actual size * 100/%scale_factor .
  */
  pcan->rclPaper.xRight = 100L * pcan->rclPaper.xRight / lScale;
  pcan->rclPaper.yTop = 100L * pcan->rclPaper.yTop / lScale;
  pcan->nBitPlanes = 1;                /* no of color bit planes            */
/* @V4.0147715 Switch to 8 Our most common */
  pcan->nBitsPerPel = 8;               /* no of bits per picture element    */

  /*
  ** Compute the canvas boundary.
  */

  /*
  ** Set the paper's imageable area.  These values should come
  ** from the PPD files.
  ** area in points as well as pels. Do not scale the points
  */
  piPtr = ImageCoords((CHAR *) szPaper, pdesPpd );

  /*
  **  if no dimensions returned by the routine then
  */
  if (piPtr == NULL)
  {
    /*
    ** These numbers come from generic ppd
    */
    pcan->rclpt.xLeft = 21;
    pcan->rclpt.xRight = 591;
    pcan->rclpt.yTop = 771;
    pcan->rclpt.yBottom = 21;
  }
  /*
  ** Store in LONG form in units of
  ** points
  */
  else
  {
    pcan->rclpt.xLeft = (long)*piPtr++;
    pcan->rclpt.yBottom = (long)*piPtr++;
    pcan->rclpt.xRight = (long)*piPtr++;
    pcan->rclpt.yTop = (long)*piPtr;

    if (pcnfData->jobProperties.iOrient != PORTRAIT)
    {
      li = pcan->rclpt.xLeft;
      pcan->rclpt.xLeft = pcan->rclpt.yBottom;
      pcan->rclpt.yBottom = li;
      li = pcan->rclpt.xRight;
      pcan->rclpt.xRight = pcan->rclpt.yTop;
      pcan->rclpt.yTop = li;
    }
  }

  /*
  ** make sure that imageable area tallies with page dimensions
  */
  if (pcan->rclpt.xRight > pcan->rclPaper.xRight)
  {
    pcan->rclpt.xRight = pcan->rclPaper.xRight;
  }

  if (pcan->rclpt.yTop > pcan->rclPaper.yTop)
  {
    pcan->rclpt.yTop = pcan->rclPaper.yTop;
  }

  /*
  ** Convert to pels
  */
  pcan->rcl.xLeft = pcan->rclpt.xLeft * (long) pcan->Res.x / 72L;     //@V3.1147608
  pcan->rcl.yBottom = pcan->rclpt.yBottom * (long) pcan->Res.y / 72L; //@V3.1147608
  pcan->rcl.xRight = pcan->rclpt.xRight * (long) pcan->Res.x / 72L;   //@V3.1147608
  pcan->rcl.yTop = pcan->rclpt.yTop * (long) pcan->Res.y / 72L;       //@V3.1147608

  /*
  ** At the request of excel we are returning the imageable coords as the
  ** actual size * 100/%scale_factor .
  ** Do not scale left and bottom since it moves printable area over on
  ** scale < 100 and into the unprintable area on >100
  */
  /*
  **  pcan->rcl.xLeft   = 100L * pcan->rcl.xLeft   / lScale;
  **  pcan->rcl.yBottom = 100L * pcan->rcl.yBottom / lScale;
  */
  pcan->rcl.xRight = 100L * pcan->rcl.xRight / lScale;
  pcan->rcl.yTop = 100L * pcan->rcl.yTop / lScale;
  PrintLog( (PSZ) "rclPaper = {%ld, %ld, %ld, %ld}\n",
            pcan->rclPaper.xLeft, pcan->rclPaper.yTop,
            pcan->rclPaper.xRight, pcan->rclPaper.yBottom );
  PrintLog( (PSZ)"pcan->rcl = {%ld, %ld, %ld, %ld}\n",
            pcan->rcl.xLeft, pcan->rcl.yTop,
            pcan->rcl.xRight, pcan->rcl.yBottom );
}


VOID GetFirstPrinterMatch(PSZ pszDestPrinterInfo,SHORT usDestBufSize );

/***************************************************************************
 *
 * FUNCTION NAME = prde_FillPdb
 *
 * Enable : Fill pDeviceBlock subfunction
 *
 * DESCRIPTION   = The information supplied on this call is only required for
 *                 Direct and Indirect DCs, but at this stage the DC Type
 *                 is not known; it is supplied on the Enable DC subfunction.
 *
 *                 So acquire pDeviceBlock Instance Data (from the global
 *                 Device Driver Heap) for all DCs, and (optionally) release
 *                 it when the DC Type is known.
 *
 *
 * Input argument :
 *
 * INPUT         = PDEVOPENSTRUC pdop      pointer to devopen structure
 *                 Dword         param2    DC Type
 *
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

ULONG   prde_FillPdb(PDEVOPENSTRUC pdop,Dword param2)
{
  PDV             pdv;              /* pointer to DV structure to be
                                          allocated                         */
  SHORT           k;
  SHORT           i, j, m;          /* scratch index variables           */
  SHORT           cFnt;             /* font count, hw + soft             */
  PCNFDATA        pcnfData;         /* pointer to printer configuration
                                       data                              */
  PDESPPD         pdesPpd;          /* pointer to printer descriptor
                                       segment                           */
  // @V3.0129238
  PSZ             pDeviceName;
  CHAR            aSegName[ 64 ];
  xPDEVOPENSTRUC  xpdop;
  /*
  ** array of pointer to following resources:-
  ** ppb file header , directory buffer ,
  ** itemsbuffer , configuration buffer , ppd
  ** parameter buffer .
  */
  PLDRIVDATA      plDriv;         /* to point to drivdata
                                       configuration block               */
  USHORT          uHWFonts;
  SHORT           usFunN;         /* index into the engines function table */
  PFNL           *apfnDispatch;
  REGREC          Regrec;
  ULONG           ulException;
  PDRIVDATA       pTempDriv;
  PBYTE           pResbuf;
  PDRIVDATA       pLocalDD;                                      // @V3.1142031

/* DBCS enabling start */                                               //@DBCS
  SHORT           cDBCSFnt;         /* font count, hw                    */
  CHAR            TempBuf[20];      /* DBCS font count                   */
  ULONG           ulReadDataSize;
  SHORT           sShiftJIS_Arrangement;
  ULONG           ulCurrentCP;
  ULONG           arCP[3];
  ULONG           pcCP;
  BOOL            bDBCSDefaultFont = FALSE;                      // @V4.3486J
/* DBCS enabling end   */                                               //@DBCS
  PSZ pQueueName;                                                // @V3.1142031
  PSZ pTermChar;                                                 // @V3.1142031
  USHORT           uDynFonts;
  PDYNFNT_LIST     prDynFnt;

  /*
  ** create the heap for the current DDC.
  */
  /*
  ** CreateDDCHeap( pddc );
  */

// @V3.0129238 - apResource is now an array

  plDriv = (PLDRIVDATA) pdop->pdriv;

  #if      DEBUG
    LogCall( "prde_FillPdb(%lp, %lp)", ((PSZ)&pdop)+sizeof(pdop) );
  #endif                                 /* DEBUG                             */

  PrintLog( (PSZ) "sizeof(DV) = %d\n", sizeof(DV) );
  PrintLog( (PSZ) "sizeof(DDC) = %d\n", sizeof(DDC) );

  /*
  ** Create a heap and carve out a DV
  */
  // @V3.0129238 - pdv structure needed for other processing, moved up.
  if (!(pdv = CreateDCHeap( ) ) )
  {
    RIP( "prde_FillPdb: can't allocate DV instance" );
    return( (ULONG) (ERROR_NEG) );
  }

  // @V3.0129238
  /* @V4.0157269 check return code */
  if ( BuildKeyName( pdop, (PSZ)aSegName, &pDeviceName, pdv, &pTempDriv,
                                                 &pdv->fIsDestnLAN ) == FALSE )
  {
    return( (ULONG) (ERROR_NEG) );
  }

  pdv->pExtraDV = SearchExtraDV( pDeviceName );
      
  /*
  ** Initalize Dynamic font List
  ** Destroy this list at DisablePdb
  */
  if ( ULGreVersion >= 0x220 &&
       GplFontMgrCheckEnvironment() &&
       !CHECKFLAG_EXT(pdv->pExtraDV,ulFlags,NO_FNTMGR) )
  {
     pdv->pDynFntList = DynFntListInit(aSegName, NULL, NULL);
  }
  
  uDynFonts = DynFntListQueryItemsCount( pdv->pDynFntList );
  
  
  if (pTempDriv != NULL)
  {
    plDriv = (PLDRIVDATA) pTempDriv;
  }

// @V3.0129238

  /*
  ** @V3.0129238
  ** Load the DESPPD structure.  This will contain PPD data that is needed
  ** to initialize the CNFDATA structure.
  */
  if ((pdesPpd = LoadPPBResource( pdv, pDeviceName )) == NULL)
  {
    return( (ULONG) ERROR_NEG );
  }

  pResbuf = pdesPpd->pPSStringBuff;                              // @V3.1142031

  SetUpJPResource( pdv, (PLDRIVDATA)plDriv );                            //@RES

  /*
  ** @V3.1142031
  ** Allocate a local DRIVDATA.
  */
  pQueueName = (PSZ) &aSegName[ 6 ];
  if ((pTermChar = (PSZ) strchr( pQueueName, ',' )) != NULL)
  {
    *pTermChar = 0;
  }
  if ((pLocalDD = InitializeLocalDRIVDATA( (PDRIVDATA) plDriv, pdesPpd,
                                           pQueueName, pDeviceName,
                                           pdv, &pcnfData )) == NULL)
  {
    RIP( "prde_FillPdb: can't allocate CNFDATA instance" );
    return( (ULONG) (ERROR_NEG) );
  }
  pdv->pCNFData = pcnfData;

  #if      DEBUG
    OpenLogFile( pdv );
  #endif

  /*
  ** Initialize the channel structure.
  */
  pdv->cn.fChannelIsValid = FALSE;
  pdv->cn.fChannelError = FALSE;

  /*
  ** Allocate the output buffer
  */
  /*
  ** Insert an error return code in the event GplMemoryAlloc fails.
  */
  if ((pdv->cn.abBuf = (PCHAR) GplMemoryAlloc( pdv->pDCHeap, ABBUF_SIZE ))
        == NULL)
  {
    return( (ULONG) ERROR_NEG );
  }

  /* @V4.0174400 Allocate new buffer */
  if ((pdv->cn.pbBin2Hex = (PCHAR) GplMemoryAlloc( pdv->pDCHeap, BIN2HEXSIZE ))
        == NULL)
  {
    return( (ULONG) ERROR_NEG );
  }

  // @V3.1142031
  if (pTempDriv != NULL)
  {
    plDriv = (PLDRIVDATA) pdop->pdriv;
  }

  /*
  **DCR1399.8 build key from printer name - don't use keyapp could be network,
  **name change, ect... have changed name of printer.
  */
  /*@V3.0116308
  ** Let BuildKeyName set the flags... pass in pdv
  */
  // @V3.0129238 - Buildkeyname moved to beginning of function.

  /*
  ** check the pcnfData->szSegName.  if it is NULL, set it to a
  ** default value.  i pulled this into a subroutine, because it
  ** confused the compiler when it was inline.
  */
  /*
  ** CheckSegName( pcnfData, apResources );
  */
  /*
  ** Overrule Os2.ini if pdop->pdrivdata contains information
  */

// @V3.0129238

  /*
  ** we are passed in a DEVOPENSTRUC.  we must now save a local copy
  ** of it.  since the DEVOPENSTRUC is made up of pointers to strings,
  ** we must save the strings themselves, as we are not
  ** guaranteed the application will keep them around.  the pointers in the
  ** DEVOPENSTRUC must point to the local string.
  **
  ** copy the logical address passed in the DEVOPENSTRUC into
  ** dev_dop.logaddress, and make the dop pointer point to it.
  */

  // @V3.1142031
  /*@V3.2115649 moved up here since it *may* change forms on us */
  pdv->dop.pdriv = pLocalDD;
  CopyDEVOPENSTRUCData( pdv, pdop );

  /*
  ** Initialize the size and orientation of the canvas.
  */
  SetCanvasMetrics( &pdv->canvas, pdesPpd, pcnfData );

  /* D74609
  ** Read in the postscript language level
  */
  pdv->usLanguageLevel = pdesPpd->desItems.usLanguageLevel;

  /*
  ** Read in the Initialization string used for mode switching to
  ** Postscript mode from current mode  :                           @1462
  */
  if ( pcnfData->uPrinterPropFlags & MODESWITCH )                 //@V3.0116308
  { /* Set mode switching OK */                                   //@V3.0116308
    SETFLAG( pdv->ulGenFlags, MODESWITCH_OK );                    //@V3.0116308
  }                                                               //@V3.0116308
  if (((k = pdesPpd->desItems.ofsInitString) != -1) &&   // If string exists
     (CHECKFLAG( pdv->ulGenFlags, MODESWITCH_OK )))               //@V3.0116308
  {
    /*
    ** Get the length of the init string
    */
    /*
    ** Strings are now NULL-terminated.
    */
    pdv->usInitLength = strlen( pResbuf + k );

    CopyStr( pdv->szInitString, pResbuf + k );
  }
  else
  {
    pdv->usInitLength = 0;

    /*
    ** add a terminating null to be safe
    */
    pdv->szInitString[0] = '\0';
  }

  /*
  ** Read in the Termination string used for mode switching out of
  ** Postscript mode to default mode  :                             @1462
  */
  if ((k = pdesPpd->desItems.ofsTermString) != -1)   /* if a string exists  */
  {
    /*
    ** Get the length of the term string
    */
    /*
    ** Strings are now NULL-terminated.
    */
    pdv->usTermLength = strlen( pResbuf + k );

    CopyStr( pdv->szTermString, pResbuf + k );
  }
  else
  {
    pdv->usTermLength = 0;

    /*
    ** add a terminating null to be safe
    */
    pdv->szTermString[0] = '\0';
  }

  /*
  ***************************for od_mem kran******************
  */
  /*
  ** Dynamically unhook the functions for MEMORY DC
  */
  if (param2)
  {
    apfnDispatch = (PFNL *)param2;

    /*
    ** copy back the functions for MEMORY DC.
    */
    if (((PDENPARAMS) ((ULONG) pdop + sizeof( DEVOPENSTRUC )))->ulType ==
                      OD_MEMORY)
    {
      for (usFunN = 0 ; usFunN <= NGREMAX ; ++usFunN)
      {
        apfnDispatch[usFunN] = od_memory_vect[usFunN].pfnl;
      }

      
      if ( ULGreVersion >= RASTER_ENGINE_22 )
      {
        Hook22Calls( apfnDispatch );
      }
    }
    else // Not memory
    {
      if ( ULGreVersion >= 0x23C )
      {
        GREDRVHOOKSET  HookSet;
        HookSet.HookPair[ GRECHARSTRINGPOS ].pGre =
                        (PFUN)(od_memory_vect[ NGreCharStringPos & 0x00FF ].pfnl);
        HookSet.HookPair[ GRECHARSTRINGPOS ].pDrv =
                               (PFUN)(apfnDispatch[ NGreCharStringPos & 0x00FF ]);
        HookSet.HookPair[ GREQUERYCHARPOSITIONS ].pGre =
                   (PFUN)(od_memory_vect[ NGreQueryCharPositions & 0x00FF ].pfnl);
        HookSet.HookPair[ GREQUERYCHARPOSITIONS ].pDrv =
                          (PFUN)(apfnDispatch[ NGreQueryCharPositions & 0x00FF ]);
        GplEDCSetUp( &HookSet, &pdv->EDCGeneralData );  // Set up vectors
        apfnDispatch[ NGreCharStringPos      & 0x00FF ] = (PFNL)GplCharStringPos;
        apfnDispatch[ NGreCharString         & 0x00FF ] = (PFNL)GplCharString;
      }
    }
  }

  /*
  ********************check above code again*****************
  */

  /*
  ** Allocate memory for fonts list and create one
  */

  /*  ** Get the font count
  */
  if ( pcnfData->lFontCount == -1L )  
  {
    pcnfData->lFontCount = DefaultFontCount( pdesPpd );
  }

// @V3.0129238
  if ( pcnfData->sUsePDFonts )                                   // @V3.1142031
  {                                                               //@V3.0115481
    uHWFonts = pdesPpd->desFonts.iFonts;  
  }                                                               //@V3.0115481
  else                                                            //@V3.0115481
  {                                                               //@V3.0115481
    uHWFonts = 0;                                                 //@V3.0115481
  }                                                               //@V3.0115481
  cFnt = uHWFonts;

  Regrec.pfn = (PFNEH)ExceptHandler;
  DosSetExceptionHandler( (PEXCEPTIONREGISTRATIONRECORD) &Regrec );
  ulException = setjmp( Regrec.jmp );
  if( ulException )
  {
    goto ReleaseSem;
  }

  /* Get the sem */
  DosRequestMutexSem( globals.hSem, SEM_INDEFINITE_WAIT );

// this if() is harmful, remove it //@246325
//  if ( pcnfData->lFontCount )                                    // @V3.1142031
//  {
    cFnt   += SFQueryFonts( pdv );     /* total fonts             */
//  }

  
  // Add dynamic fonts to drivers font list
  cFnt += uDynFonts;

  if (cFnt > MAX_FONTS)                /* max amount we have room for       */
  {
    cFnt = MAX_FONTS;
  }
  pdv->cFonts = cFnt;                  /* save total fonts                  */

  if (!(pdv->paFonts = (PAFNT)GplMemoryAlloc( pdv->pDCHeap, cFnt*sizeof(FNT) )))
  {
    PrintLog( (PSZ) "prde_FillPdb: can't allocate Fonts Array\n" );
    return( (ULONG) ((long)ERROR_NEG) );
  }

/* DBCS enabling start */                                               //@DBCS
  /*
  ** Set the number of DBCS fonts temporary. We have to get the correct
  ** number of DBCS fonts later.
  */
  cDBCSFnt = F5_JFONTS;
  pdv->cDBCSFonts = cDBCSFnt;
  pdv->bMakeBold = TRUE;

  /*
  ** Allocate the buffer for DBCS font.
  */
  if (!(pdv->paDBCSFonts = (PADBCSFNT)GplMemoryAlloc( pdv->pDCHeap,
                                             cDBCSFnt*sizeof(DBCSFNT) )))
  {
    PrintLog( (PSZ) "prde_FillPdb: can't allocate DBCSFonts Array\n" );
    return( (ULONG) ((long)ERROR_NEG) );
  }

  /*
  ** Get the current code page for the default code page. If we couldn't
  ** get the current code page, use 850 as the default.
  */
  if (DosQueryCp( (ULONG)sizeof(arCP), (PULONG)arCP, (PULONG)&pcCP ) ||
      arCP[0] == 0L)
    ulCurrentCP = (ULONG)850;
  else
    ulCurrentCP = arCP[0];

  /*
  ** The following codes are only for Japanese environment.
  */
  if (ulCurrentCP == 932L || ulCurrentCP == 942L)
  {
    flMin = FALSE;
    flGot = FALSE;

    /*
    ** Switch the code set by the level of JIS standard.
    */
    sShiftJIS_Arrangement = FALSE;

    if ( PrfQueryProfileData( HINI_USERPROFILE, (PSZ)"PMNLS_DBCS_FONT",
        (PSZ)"ShiftJIS_Arrangement", (PLONG)TempBuf, &ulReadDataSize ) )
    {
      if (!strcmp( TempBuf, "JIS90" ))
        sShiftJIS_Arrangement = TRUE;

      PrintLog( (PSZ)"ShiftJIS_Arrangement =  %d\n" , sShiftJIS_Arrangement );
    }
  }
/* DBCS enabling end   */                                               //@DBCS

  j = pdesPpd->desFonts.ofsFontnames;

  /*
  ** Point to font table instead of allocating memory
  */
  /*
  ** Transfer the fonts name to DV structure .
  */
  // @V3.1142031
  for (i = 0; i < uHWFonts && i < cFnt && pcnfData->sUsePDFonts; i++)
  {
    k = *( pResbuf + j );

    (*pdv->paFonts)[i].pszFontName = FontResourceName[k];

/* DBCS enabling start */
    /*
    ** Driver need to handle specially for Japanese font.
    */
    if (ulCurrentCP == 932L || ulCurrentCP == 942L)
    {
      if ((m = MatchHWFontNameJpn( (*pdv->paFonts)[i].pszFontName )) != 0 )
      {
        (*pdv->paFonts)[i].pszFullName = (PSZ)FontFullName[m];
// @V4.3486J begin
        // Temp solution !!!
        // Switch driver default font to JPN font when JPN codepage.
        // Set first MINCHO family font as default font.
        // This solves slow printing when default font is selected.
        // Default font is coded in PPD files and almost the case
        // it is coded with Courie, which can not handle DBCS chars!!
        if( !bDBCSDefaultFont)
        {
          PSZ pszFullName = (PSZ)FontFullName[m];
          if( (szIsEqual(pszFullName, RYUMINLKL    )) ||
              (szIsEqual(pszFullName, MINCHO       )) ||
              (szIsEqual(pszFullName, HGMINCHOL    )) ||
              (szIsEqual(pszFullName, RICOHMINCHOL )) )
          {
            strcpy( pcnfData->szFontName, pszFullName);
            bDBCSDefaultFont = TRUE;
          }
        }
// @V4.3486J end

        PrintLog( (PSZ) "m = %d, (*pdv->paFonts)[%d].pszFullName =  %ls\n",
                         m, i, (PSZ)(*pdv->paFonts)[i].pszFullName );
      }
      (*pdv->paFonts)[i].usResource = m;
      j++;
      continue;
    }
/* DBCS enabling end   */                                               //@DBCS

    (*pdv->paFonts)[i].pszFullName = (PSZ) FontFullName[k];
    (*pdv->paFonts)[i].usResource  = k;

    j++;
  }

  
  // Add dynamic fonts to drivers font list
  for ( j = 0; j < uDynFonts && i + j < cFnt ; j++)
  {
    prDynFnt = DynFntListQueryItem ( pdv->pDynFntList, j );
    //assign ulDeviceFont to logical font entry after font realize
    //prDynFnt->ulDeviceFont = i+j;
    (*pdv->paFonts)[i+j].pszFontName = (PSZ) prDynFnt->rFontProfile.szDeviceName;
    (*pdv->paFonts)[i+j].pszFullName = (PSZ) prDynFnt->rFontProfile.szFontName;
    (*pdv->paFonts)[i+j].usResource  = 0;
    (*pdv->paFonts)[i+j].bLoaded  = TRUE | DYNFNT;
    (*pdv->paFonts)[i+j].prDynFnt = prDynFnt;
  }
  i += uDynFonts;
  

  /*  ** Pass the number of HW fonts
  */
// @V3.1142031
// this if() is harmful, remove it //@246325
//  if ( pcnfData->lFontCount )
//  {
    // @V3.1142031
  FillSFonts( pdv, (PVOID) &(*pdv->paFonts)[i], cFnt-i, uHWFonts );
/* DBCS enabling start */                                               //@DBCS
  /* Set the DBCS font name information. */
  for (i = 0; i < cDBCSFnt; i++)
  {
    if (sShiftJIS_Arrangement == FALSE)
      (*pdv->paDBCSFonts)[i] = JOFonts[i];
    else
      (*pdv->paDBCSFonts)[i] = JNFonts[i];

    PrintLog( (PSZ) "(*pdv->paDBCSFonts)[%d].szFontName =  %ls\n", i,
                    (PSZ)(*pdv->paDBCSFonts)[i].szFontName);
    PrintLog( (PSZ) "(*pdv->paDBCSFonts)[%d].szH2ByteName =  %ls\n", i,
                    (PSZ)(*pdv->paDBCSFonts)[i].szH2ByteName);
    PrintLog( (PSZ) "(*pdv->paDBCSFonts)[%d].szV2ByteName =  %ls\n\n", i,
                    (PSZ)(*pdv->paDBCSFonts)[i].szV2ByteName);
  }
/* DBCS enabling end   */                                               //@DBCS
//  } //@246325

ReleaseSem:
  DosReleaseMutexSem( globals.hSem );
  DosUnsetExceptionHandler( (PEXCEPTIONREGISTRATIONRECORD)&Regrec );

  /*
  ** copy various device property things.
  */
  // @V3.1142031
  pdv->shPageno = 1;                     /* starting page no                  */


  if (pTempDriv != NULL)
  {
    GplMemoryFree( pTempDriv );
    pTempDriv = NULL;
  }

  /*
  ** copy the data type into the dev_dop.datatype and make the dop
  ** pointer point to it.
  */
  /*
  ** Note can only be STD if queued
  */
  xpdop = (xPDEVOPENSTRUC) pdop;
  // @V3.1142031


  /* @V3.0GAMMA1
  ** If user has gamma set up table
  ** and producing output ( going raw )
  ** The size is 256 colors by 3 (RGB)
  */
  if ( pdv->usDataType == PM_Q_RAW      &&
       (pcnfData->sGammaValues.lRed != NO_GAMMA ||
        pcnfData->sGammaValues.lGreen != NO_GAMMA ||
        pcnfData->sGammaValues.lBlue != NO_GAMMA))
  {
    pdv->pbGammaTable = GplMemoryAlloc( pdv->pDCHeap, 4 * 256 );
    if ( GplGammaCreateTable( pdv->pbGammaTable,
                              pcnfData->sGammaValues.lRed,
                              pcnfData->sGammaValues.lGreen,
                              pcnfData->sGammaValues.lBlue,
                              1L,
                              0L ) )
    { /* Failure: free table, set ptr to zero */
      GplMemoryFree( pdv->pbGammaTable );
      pdv->pbGammaTable = 0;
    }
  }

  /*
  ** Create the async output thread.
  */
  if ( xpdop->ulType == OD_DIRECT                                   ||
      ( xpdop->ulType == OD_QUEUED && pdv->usDataType == PM_Q_RAW ) ||
        pcnfData->iDestnType != SYSTEM                               )
  {
    if ((i = (SHORT) GplThreadCreateInstance( pdv->pDCHeap, pcnfData->hmod,
                              &pdv->hThread, (PSZ)PSCRIPT_DRV_NAME )) == FALSE)
    {
      pdv->hThread = 0;
      GplErrSetError( PMERR_CREATE_THREAD );
      return( ERROR_NEG );
    }
  }

  return( (ULONG) pdv );
}


/*
** !!!CR there is no code to check the graphics engine version number
** !!!So,what 's it supposed to check for?
*/

/***************************************************************************
 *
 * FUNCTION NAME = prde_FillLdb  (Enable Subfunction 1)
 *
 *
 * DESCRIPTION : Sets up the dispatch table for the graphics engine, calls
 *               display.dll to get a dispatch table for its entry points.
 *               Sets the return flags to tell the engine that:
 *
 *                   Bit 0 == 1   Each DC requires its own physical device
 *                                block.
 *
 *                    Bit 1 == 0   Multiple DC's may coexist. **Bit2 == 0
 * Device/File names in the DevOpenStruc *are significant. **Note:When we load
 * the display driver we call it as
 *
 * if  we *were the graphics engine module. This kind of *charade continues
 * while  we're using the display
 *                     driver as our imaging engine.  The display driver
 *                     sees the DC as a memory DC while the engine sees
 *                     it as a printer DC.
 *
 *  Comments:
 *
 *  The initialization process is serialized with semaphores
 *  because it is possible for more than one process to have done
 *  an OpenDC at the same time.
 *
 *  But first we must put it on the ExitList, because when any
 *  process grabs a semaphore we must be able to free the semaphore
 *  if the process dies unexpectedly
 *
 *
 * INPUT         = FLParamsLst    *param1
 *                 FLReturnsLst   *param2
 *
 *
 * OUTPUT        = NONE
 *
 *
 * RETURN-NORMAL = SUCCESS
 *
 * RETURN-ERROR  = FAILURE
 *
 **************************************************************************/

#define EXLST_PRTY_UNLOCK       0xFD00   /* Unlock DLL: free semaphores, etc */

SHORT prde_FillLdb( FLParamsLst  *param1, FLReturnsLst *param2 )
{
  static BOOL   fGotPibTib  = FALSE;
  SHORT  usRetCode;

  RIPIF( fRipOnEnter,"###### Entering Fill Log Dev Blk ######" );

  #if DEBUG
      LogCall( "prde_FillLdb(%lp, %lp)", ((PB) &param1) + sizeof(param1) );
  #endif

/*** Exit list Not needed - Clean up in _DLL_InitTerm  *******************
**DosExitList( EXLST_ADD | EXLST_PRTY_UNLOCK, (PFNEXITLIST) Exitpdd );****
*************************************************************************/

  DosRequestMutexSem( tsemDriver, SEM_INDEFINITE_WAIT );

  /*
  ** create the driver's global heap and initialize some stuff.
  ** this heap is for  constant driver wide stuff,ie resource
  ** string tables,etc. there will be a separate heap created
  ** for  each DDC opened. These DDC specific heaps will be
  ** destroyed when each DDC is closed. this global heap will
  ** be created when the first DDC is opened ,and will remain
  ** in place,as the driver will remain in memory until the
  ** cows come home.
  */
/*InitGlobalHeap( );*/

  /*
  ** set a flag which means that the logical device block has been
  ** established.  this flag is used in InitGlobal and KillGlobalHeap.
  ** it is used so that we don't try to create the heap when it exists,
  ** or deleted it once the logical device block exists.
  */
  SetLDBFlag( );

  if (!fGotPibTib)
  {
    if (param1->ulVersion > 0x120L)
    {
      aAER = param2->aAER;
    }

    /*
    ** if (DosGetInfoBlocks(&ptib, &ppib))
    ** {
    **   RIP( "prde_FillLdb: DosGetInfoBlocks failed" );
    **   GplErrSetError(PMERR_BASE_ERROR );
    **   goto Failure;
    ** }
    ** else
    */

    fGotPibTib = TRUE;
  }

  /*
  **  Install ptrs our functions in engine's dispatch tbl.
  */
  usRetCode = InstallDispatchVectors( param2->apfn,param1 );

  if (usRetCode == FAILURE)
  {
    RIP( "FillLdb: InstallDispatchVectors failed" );
    goto Failure;
  }

  /*
  ** Set the flags to show that we want:
  **   bit 0 = 1 => each DC requires its own pDeviceBlock (Pdb)
  **   bit 1 = 0 => an arbitary number of DCs can co-exist
  **   bit 2 = 0 => the device and file name fields of OpenDevDc
  **                are significant, and should not be ignored.
  ** All other bits are reserved and should not be modified.
  */
  *(param2->pFlags) &= 0xFFFFFFF8L;
  *(param2->pFlags) |= 0x00000081L;
  usRetCode = (SHORT) SUCCESS;

CleanUpAndExit:

  DosReleaseMutexSem( tsemDriver );
  return( usRetCode );

Failure:

  usRetCode = (SHORT)
  FAILURE;
  goto CleanUpAndExit;
}


/***************************************************************************
 *
 * FUNCTION NAME = prde_DisablePdb
 *
 * DESCRIPTION : Disable pDeviceBlock subfunction
 *
 * INPUT         = PDV   pdv  Pointer to the driver's device structure
 *                 PB    Param2
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

SHORT prde_DisablePdb( PDV pdv, PB param2 )
{
  PFNT  pFnt;
  INT   i;
  PCACHEDFONT pCachedFont;
  PVOID pDCHeap;

  #if      DEBUG
    LogCall( "prde_DisablePdb(%lp, %lp)", ((PB)&pdv) + sizeof(pdv) );
    CloseLogFile( pdv );
  #endif

  /*
  ** Free the memory allocated to the device.
  */
  if (pdv)
  {
    if (pdv->hThread)
    {
      GplThreadDeleteInstance( &pdv->hThread );

      /*
      ** @V3.0100101
      ** Zero-out the thread handle.
      */
      pdv->hThread = (HTHREAD) 0;
    }

    /*
    ** these pointers were allocated at the time of opening a dc so
    ** release the allocated memory now.
    */
    for (i = 0; i < pdv->cFonts; i++)
    {                                  /* free softfont string entries      */
      pFnt = &(*pdv->paFonts)[i];

      if ((SHORT)pFnt->usResource <= 0) 
      {
        /*
        ** I'm counting on the global heap having been created
        ** HM_MOVEABLE, so I don't need to tell it the size of
        ** the memory to free
        **
        ** If the font is dynamic, name is in DynFnt record
        ** Don't free it
        */
        if (pFnt->pszFullName && !( pFnt->bLoaded & DYNFNT ) )
        {
          GplMemoryFree( pFnt->pszFullName );
        }
      }
    }
    GplMemoryFree( (PB) pdv->paFonts );
    
    // Destroy Dynamic font list
    DynFntListDone( pdv->pDynFntList );

/* DBCS enabling start */                                               //@DBCS
    /*
    ** Free the area for Japanese font.
    */
    GplMemoryFree( (PB) pdv->paDBCSFonts );
    // @V3.1142031
    pdv->paDBCSFonts = NULL;
/* DBCS enabling end   */                                               //@DBCS

    pCachedFont = pdv->FontCache;
    for ( i = 0; i < NUMCACHEDFONTS; i++ )
    {
      if ( pCachedFont->pFontDef )
      {
        GplMemoryFree( pCachedFont->pFontDef );
      }
      pCachedFont++;
    }

    /* @V3.0GAMMA1
    ** Free Gamma table if allocated
    */
    if ( pdv->pbGammaTable )
    {
      GplMemoryFree( pdv->pbGammaTable );
    }

    if (pdv->pdesPPD != NULL)
    {
      FreePPBResource( pdv->pdesPPD );
      pdv->pdesPPD = NULL;
    }

    // DJP
    if (pdv->pCNFData != NULL)
    {
      FreeLocalDRIVDATA( pdv->dop.pdriv );
      pdv->dop.pdriv = NULL;
      pdv->pCNFData = NULL;
    }

    GplMemoryFree( (PB) pdv->cn.abBuf );
    GplMemoryFree( (PCHAR) pdv->cn.pbBin2Hex );                   //@V4.0174400
    pDCHeap = pdv->pDCHeap;
    GplMemoryFree( pdv );
    KillHeap( pDCHeap );
  }
  return( SUCCESS );
}

/***************************************************************************
 *
 * FUNCTION NAME = Exitpdd
 *
 * DESCRIPTION :
 *
 * This is where processes go when they die.
 *
 * The usTermCode parameter specifies the reason the process
 * ended. This parameter can be one of the following values:
 *
 * Value           Meaning
 * ----------------------------------------------
 * TC_EXIT         Normal exit
 * TC_HARDERROR    Hard-error abort
 * TC_KILLPROCESS  Unintercepted DosKillProcess
 * TC_TRAP         Trap operation
 *
 * The important reason for this routine is that the process may have died
 * unexpectedly, such as by a GP fault.  If the process is holding a
 * semaphore then we must release it now so that the death of this process
 * does not cause the whole system to freeze while waiting on a semaphore
 * that will never be freed.
 *
 * INPUT         = SHORT usTremCode
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = Does not return.  See the documentation for DosExitList.
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

VOID Exitpdd( SHORT usTermCode )
{
  /*
  ** Now we release any global semaphores owned by the dead process.
  */
  DosReleaseMutexSem( tsemDriver );

  DosCloseMutexSem( tsemDriver );

}


/***************************************************************************
 *
 * FUNCTION NAME = ProfileAllocStringQuery
 *
 * DESCRIPTION   = This function queries the size, in bytes, a buffer is
 *  needed for a string from the OS2.INI file.  It then allocates the memory
 *  and copies the profile string to the buffer.  This is used to retrieve
 *  profile strings of variable sizes.
 *  This function frees the profile string buffer if an error occurs, but it
 *  is the programmer's responsibility to free the buffer if this function
 *  returns successful.
 *  This function uses GplMemoryAlloc() to allocate memory to the buffer, so
 *  GplMemoryFree() should be used to free memory.
 *
 * INPUT         = HINI hIni - Initialization file handle.
 *                 PSZ pszAppName - String containing application name to be
 *                   queried.
 *                 PSZ pszKeyName - String containing key name that is to be
 *                   queried.
 *                 PSZ pszDefaultName - String that contains a default profile
 *                   name.  This name is provided to the return buffer if the
 *                   string being searched for cannot be found.
 *                   ** IMPORTANT** If no default string is desired, this
 *                   should be set to NULL.
 *
 * OUTPUT        = PPVOID ppBuffer - Double pointer.  The buffer containing
 *                   the profile string is allocated and its address is stored
 *                   here and returned to the calling function.
 *
 * RETURN-NORMAL = Non-0 - Number of characters in buffer.
 * RETURN-ERROR  = 0 - Error in memory allocation, profile search failed, or
 *                 simply no strings were found.
 *
 ****************************************************************************/
LONG ProfileAllocStringQuery( HINI hIni, PSZ pszAppName, PSZ pszKeyName,
                              PSZ pszDefaultName, PPVOID ppBuffer )
{
  ULONG ulDataLength;       /* Profile string length, in characters. */
  LONG ulNumOfStrChars = 0; /* Return values for this function.      */

  /*
  ** Initially, set the double-pointer to NULL.
  */
  *ppBuffer = NULL;

  /*
  ** Retrieve the memory size needed for the specific key name.
  ** PrfQueryProfileSize returns either TRUE or FALSE.
  */
  if (PrfQueryProfileSize( hIni, pszAppName, pszKeyName,
                           &ulDataLength ) == TRUE)
  {
    /*
    ** Allocate memory where the profile string will be stored.  The reason
    **     1 is added to ulDataLength is to take the NULL character into
    ** consideration.
    */
    if ((*ppBuffer = (PVOID) GplMemoryAlloc( pProcessHeap, ulDataLength + 1 )) !=0 )
    {
      /*
      ** Retrieve the needed string from the OS2.INI file.
      ** PrfQueryProfileString returns the number of characters returned in
      ** the string.  Therefore, retrieve the number of characters returned.
      ** This value will be returned by the function.
      ** If 0 is returned, it means that there is no string for the buffer.
      ** Therefore, free the buffer resserved for ppBuffer and set it to NULL.
      */
      if ((ulNumOfStrChars = PrfQueryProfileString( hIni, pszAppName, pszKeyName,
                                                    pszDefaultName, (PSZ) *ppBuffer,
                                                    ulDataLength)) == 0)
      {
        GplMemoryFree( *ppBuffer );
        *ppBuffer = NULL;
      }
    }
  }

  return( ulNumOfStrChars );
}





/*
** @V3.0129238 - to end - new function
*/
/***************************************************************************
 *
 * FUNCTION NAME = LoadPPBResource
 *
 * DESCRIPTION
 * Takes a given device name and searches the list of PPB resources in the
 * driver for a matching PPB.  If a match is found, then the PPB data is
 * loaded in the respective fields in the DESPPD structure.
 * If a match is not found, then the device is converted to the Generic
 * Postscript PPB and is loaded.  If, for some reason, the default PPB could
 * not be loaded, the function returns NULL.
 * The PPB contents are generated by the PPD compiler.  The following data
 * is copied, in order:
 * - The contents of the DESPPD structure.
 * - The User Interface block list.
 * - The Postscript String Buffer.
 * - The compressed string data.
 * - The form strings.
 *
 * INPUT
 * pdv         - Ptr to DV
 * pDeviceName - Name of the device to retrieve the PPB data.
 *
 * OUTPUT
 *
 * RETURN-NORMAL - Allocated memory for the DESPPD structure.
 * RETURN-ERROR - NULL
 *
 ****************************************************************************/
PDESPPD LoadPPBResource( PDV pdv, PSZ pDeviceName )
{
  CNFDATA stCNFData;
  PDESPPD pdesPpd;
  PB      apResources[ IMAXRES + 1 ];
  BOOL    bRC;
  PVOID   pHeap;                                                   //@V3.1138185

  /*
  ** Save the ptr to PPB data in DV for life of DC
  */
  if ( pdv )             //If pdv
  {                      //And
    if ( pdv->pdesPPD )  //pdesPPD is not null
    {
      return pdv->pdesPPD;
    }
  }

  memset( &stCNFData, 0, sizeof( CNFDATA ) );
  memset( apResources, 0, sizeof( apResources ) );
  strcpy( stCNFData.szSegName, pDeviceName );
  stCNFData.lGetPtr = 0;

  apResources[ CNFRES ] = (PB) &stCNFData;

  if ( pdv )                                                       //@V3.1138185
  {                                                                //@V3.1138185
    pHeap = pdv->pDCHeap;                                          //@V3.1138185
  }                                                                //@V3.1138185
  else                                                             //@V3.1138185
  {                                                                //@V3.1138185
    pHeap = pProcessHeap;                                          //@V3.1138185
  }                                                                //@V3.1138185
  bRC = LoadInfoSegment( apResources, pHeap );                     //@V3.1138185

  if ( bRC == TRUE )
  {
    pdesPpd = (PDESPPD) apResources[ PPDRES ];
    pdesPpd->pPSStringBuff = (PBYTE) apResources[ RESBUF ];
  }

  // @V3.1140397 - DIRRES buffer no longer needed.
  if (apResources[ DIRRES ] != NULL)
  {
    GplMemoryFree( apResources[ DIRRES ] );
    apResources[ DIRRES ] = NULL;
  }

  if ( pdv )
  {
    if ( bRC == TRUE )
    {
      pdv->pdesPPD = pdesPpd;
    }
    else
    {
      pdv->pdesPPD = NULL;
    }
  }

  if ( bRC == TRUE )
  {
    return( pdesPpd );
  }
  else
  {
    return NULL;
  }
}


/*****************************************************************************
 *
 * FUNCTION NAME = FreePPBResource
 *
 * DESCRIPTION
 * Frees the PPB buffers that are accessed by the DESPPD structure.
 * The following buffers are freed, in order:
 * - The User Interface Block list.
 * - The Postscript string buffer.
 * - The DESPPD structure buffer.
 *
 * INPUT
 * pdesPpd - PPD description structure.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL = None
 * RETURN-ERROR  = None
 *
 ****************************************************************************/
VOID FreePPBResource( PDESPPD pdesPPD )
{
  /*
  ** If NULL, then nothing to free.
  */
  if (pdesPPD != NULL)
  {
    /*
    ** Free the UI block list.
    */
    if (pdesPPD->stUIList.pBlockList != NULL)
    {
      GplMemoryFree( pdesPPD->stUIList.pBlockList );
      pdesPPD->stUIList.pBlockList = NULL;
    }

    // @V3.1147743 - Free the UIC block list
    if (pdesPPD->stUICList.puicBlockList != NULL)
    {
      GplMemoryFree( pdesPPD->stUICList.puicBlockList );
      pdesPPD->stUICList.puicBlockList = NULL;
    }

    /*
    ** Free the Postscript string buffer.
    */
    if (pdesPPD->pPSStringBuff != NULL)
    {
      GplMemoryFree( pdesPPD->pPSStringBuff );
      pdesPPD->pPSStringBuff = NULL;
    }

    /*
    ** Free the DESPPD structure.
    */
    GplMemoryFree( pdesPPD );
  }
}


/***************************************************************************
 *
 * FUNCTION NAME = QueryUIOptionString
 *
 * DESCRIPTION
 * Retrieves a given keyword (UI block name) and returns the first option
 * (UI entry name) that is selected.  For mulitple selections, this function
 * can be called in succession and returns the next selected option found
 * until the end occurs.
 * This function returns a pointer to the option string.  The option string
 * is stored in pdesppd->pPSStringBuff.
 *
 * For multiple selections, each bit in the UI selection (UI_SEL) corresponds
 * to an option selection.  For example, if bit 0 is set, the first item is
 * selection, for bit 1, it is option 2, etc.  For multpile selections,
 * multiple bits in UI_SEL are set.  In order to know the last selection
 * that was queried, this function requires a "bookmark" that tells it the
 * last selection that was queried so that it does not return the same
 * selection again.  This "bookmark" is called pofsSelBit and is described
 * below.  To identify if a UI is a single or multiple selection, look at
 * its matching "*OpenUI" in the PPD.  If you see "PickMany", then it is a
 * multiple selection.  Multiple selections are very rare, the default is
 * either "PickOne" or "Boolean", both which are single selections.
 *
 * INPUT
 * pdesPpd - PPD description structure.  This includes the option string that
 *   will be returned.
 * pUISel - The UI Selection List.
 * pKeyword - Keyword string to search.
 * pofsSelBit - Only needed for multiple selections, can be NULL.  This flag
 *   is used within the function to tell it the last selection that was
 *   returned.
 *   IMPORTANT:  On the initial call for multiple selections, this flag
 *   *MUST* be set to 0.
 *   For single selections, this flag is not needed and can be NULL.
 *
 * OUTPUT
 * pofsSelBit - If a pointer was provided, this returns with the last selected
 *   bit set.
 *   For example, if the second option was returned, this flag returns the
 *   second bit set, or 2.  If the fourth option was returned, this returns 8.
 *   The value for this flag should be passed in to the next call of this
 *   function for the same UI.  The caller should not modifiy this value
 *   except to reset it to 0, which causes this function to start all over
 *   again and return the first selection.
 *   If there are no more options to return, this is set to -1.
 *
 * RETURN-NORMAL = This returns the pointer to the matching option string for
 *                 the first option that is found.  If no option is found,
 *                 NULL is returned.
 * RETURN-ERROR  = None
 *
 ****************************************************************************/
 // @V3.1147743 - Modify function
PBYTE QueryUIOptionString( PDESPPD pdesPPD, PUI_SEL pUISelList,
                           PBYTE pKeyword, PINT pofsSelBit,
                           PUI_BLOCK *pReturnBlock )
{
  INT       iLoop;                  // Local loop counter
  UI_SEL    uUICurrentSel;          // Current UI Selection value
  PBYTE     pBlockName;             // Pointer to name of current block
  INT       iLocalSel;              // Local bit selector
  PUI_BLOCK pUIBlock = pdesPPD->stUIList.pBlockList;
                                    // Current block pointer
  PBYTE     pRC = NULL;             // Function return code

  /*
  ** If a return value (pofsSelBit) is provided, then copy to a local value.
  ** Otherwise, set the local value to 0.
  */
  if (pofsSelBit != NULL)
  {
    iLocalSel = *pofsSelBit;
  }
  else
  {
    iLocalSel = 0;
  }

  /*
  ** With a given keyword, search through the Block List until a matching
  ** keyword string is found.
  ** Remember that the a block is a variable length, so we can't just apply
  ** an offset to retrieve the current block, we have to increment a pointer
  ** to the next block.
  */
  for (iLoop = 0 ; iLoop < (INT) pdesPPD->stUIList.usNumOfBlocks ; iLoop++)
  {
    pBlockName = (PBYTE) (pdesPPD->pPSStringBuff +
                          pUIBlock->ofsUIName);

    if (!strcmp( pKeyword, pBlockName ))
    {
      break;
    }

    INCREMENT_BLOCK_PTR( pUIBlock );
  }

  /*
  ** The following is TRUE if a matching keyword string was found.
  */
  if (iLoop < (INT) pdesPPD->stUIList.usNumOfBlocks)
  {
    if (pReturnBlock != NULL)
    {
      *pReturnBlock = pUIBlock;
    }

    uUICurrentSel = (UI_SEL) *(pUISelList + iLoop);

    if (iLocalSel > (INT)sizeof( UI_SEL ))
    {
      iLocalSel = 0;
    }
    uUICurrentSel >>= iLocalSel;

    /*
    ** Query the first set UI by shifting the UI Selection Entry to
    ** the right until a set bit is found.
    */
    for (iLoop = iLocalSel ; iLoop < (INT)sizeof( UI_SEL ) * 8 ; iLoop++)
    {
      if ((uUICurrentSel & 1) == 1)
      {
        break;
      }
      uUICurrentSel >>= 1;
    }

    if ((uUICurrentSel & 1) == 1)
    {
      if ((uUICurrentSel >> 1) != 0)
      {
        iLocalSel = iLoop + 1;
      }
      else
      {
        iLocalSel = -1;
      }
      pRC = pUIBlock->uiEntry[ iLoop ].ofsOption +
            pdesPPD->pPSStringBuff;
    }
    else
    {
      pRC = NULL;
      iLocalSel = -1;
    }
  }
  else
  {
    pRC = NULL;
    iLocalSel = -1;
  }

  /*
  ** If provided, copy back to the caller.
  */
  if (pofsSelBit != NULL)
  {
    *pofsSelBit = iLocalSel;
  }

  return( pRC );
}


/***************************************************************************
 *
 * FUNCTION NAME = SetUIOption
 *
 * DESCRIPTION
 * Retrieves a given keyword (UI block name) and option string (UI Entry
 * name) and sets the matching bit in the UI selection entry for the given
 * string data.
 *
 * INPUT
 * pdesPpd - PPD description structure.  This includes the option string that
 *   will be returned.
 * pUISelList - The UI Selection List buffer.
 * pKeyword - Keyword string to search.
 * pOption - Option string to set matching bit.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL = None
 * RETURN-ERROR  = None
 *
 ****************************************************************************/
INT SetUIOption( PDESPPD pdesPPD, PUI_SEL pUISelList, PBYTE pKeyword,
                 PBYTE pOption )
{
  INT       ofsBlock;                // Offset of block array
  PUI_BLOCK pUIBlock;                // Pointer to the current block
  INT       ofsEntry = -1;           // Offset of entry array

  if ((pUIBlock = QueryBlockFromKeyword( &pdesPPD->stUIList,
                  pdesPPD->pPSStringBuff, pKeyword, &ofsBlock ))
      != NULL)
  {
    /*
    ** Run through the entry list until a matching option is found.  If
    ** found, set the matching bit in the UI Selection List.
    */
    if (QueryEntryFromOption( pdesPPD->pPSStringBuff, pUIBlock, pOption,
                              &ofsEntry ) != NULL)
    {
      *(pUISelList + ofsBlock) = (1 << ofsEntry);
    }
  }

  return( ofsEntry );
}


/***************************************************************************
 *
 * FUNCTION NAME = QueryBlockFromKeyword
 *
 * DESCRIPTION
 * With a given keyword string, finds the matching block for the given
 * keyword.  The keyword must be the same keyword that is found in the PPD:
 *
 *   "*OpenUI *keyword"
 *
 * except the keyword should not include the asterisk.
 *
 * The function not only returns the pointer to the matching block, but it
 * also returns, if requested, the zero-based offset of the returned block
 * in respect to the location of that block in the list.  For example, if the
 * block returned is the first block in the list, 0 is returned.  If the block
 * returned is the second block in the list, 1 is returned, etc.
 *
 * INPUT
 * pUIList - Pointer to the list of blocks.
 * pPSStringBuff - PPB string buffer.  The blocks are located in this buffer.
 * pKeyword - Keyword to search for in the list.
 *
 * OUTPUT
 * pofsBlock - Optional.  If not NULL, returns the zero-based offset of where
 *  the block was found in the list.  If no matching block was found, this
 *  returns -1.
 *
 * RETURN-NORMAL = Pointer to keyword block.
 * RETURN-ERROR  = NULL
 *
 ****************************************************************************/
PUI_BLOCK QueryBlockFromKeyword( PUI_LIST pUIList, PBYTE pPSStringBuff,
                                 PBYTE pKeyword, PINT pofsBlock )
{
  UINT      uiLoop;                                   // Local loop counter
  PBYTE     pBlockName;                               // Name of current block
  PUI_BLOCK pInBlock = pUIList->pBlockList;           // Input block pointer
  PUI_BLOCK pUIBlockRC = NULL;                        // Block return code

  /*
  ** These pointers are required.
  */
  if (pUIList != NULL && pPSStringBuff != NULL && pKeyword != NULL)
  {
    if (pofsBlock != NULL)
    {
      *pofsBlock = -1;
    }

    for (uiLoop = 0 ; uiLoop < pUIList->usNumOfBlocks ; uiLoop++)
    {
      pBlockName = pInBlock->ofsUIName + pPSStringBuff;

      if (!CompareStri( pBlockName, pKeyword ))
      {
        pUIBlockRC = pInBlock;

        if (pofsBlock != NULL)
        {
          *pofsBlock = (INT) uiLoop;
        }

        break;
      }

      INCREMENT_BLOCK_PTR( pInBlock );
    }
  }
  else                    // One or more arguments are NULL - invalid.
  {
    GplErrSetError( PMERR_INVALID_PARAMETERS );
  }

  return( pUIBlockRC );
}


/***************************************************************************
 *
 * FUNCTION NAME = QueryEntryFromOption
 *
 * DESCRIPTION
 * With a given option string, finds the matching entry within a given block
 * for the matching option.  The option string must be the same in the PPD in
 * the format:
 *
 *   "*OpenUI *keyword"
 *   "*keyword option:"
 *
 * except that option should not contain a colon.
 *
 * The function not only returns the pointer to the matching entry, but it
 * also returns, if requested, the zero-based offset of the returned entry
 * in respect to the location of that entry in the block.  For example, if the
 * entry returned is the first entry in the block, 0 is returned.  If the entry
 * returned is the second entry in the block, 1 is returned, etc.
 *
 * INPUT
 * pPSStringBuff - PPB string buffer.  The blocks are located in this buffer.
 * pUIBlock - UI option block where entry exists.
 * pOption - Option string to search for in the block.
 *
 * OUTPUT
 * pofsEntry - Optional.  If not NULL, returns the zero-based offset of where
 *  the entry was found in the block.  If no matching entry was found, this
 *  returns -1.
 *
 * RETURN-NORMAL = Pointer to option entry.
 * RETURN-ERROR  = NULL
 *
 ****************************************************************************/
PUI_ENTRY QueryEntryFromOption( PBYTE pPSStringBuff, PUI_BLOCK pUIBlock,
                                PBYTE pOption, PINT pofsEntry )
{
  UINT      uiLoop;             // Local loop counter
  PBYTE     pEntryName;         // Current UI Entry name
  PUI_ENTRY pEntryRC = NULL;    // Current entry return code

  if (pofsEntry != NULL)
  {
    *pofsEntry = -1;
  }

  for (uiLoop = 0 ; uiLoop < pUIBlock->usNumOfEntries ; uiLoop++)
  {
    pEntryName = pUIBlock->uiEntry[ uiLoop ].ofsOption + pPSStringBuff;

    if (szIsEqual( pOption, pEntryName ))
    {
      pEntryRC = &pUIBlock->uiEntry[ uiLoop ];

      if (pofsEntry != NULL)
      {
        *pofsEntry = (INT) uiLoop;
      }

      break;
    }
  }

  return( pEntryRC );
}


/***************************************************************************
 *
 * FUNCTION NAME = QueryDefDrivFromQue
 *
 * DESCRIPTION
 * If a pointer to a DRIVDATA is invalid, then this function queries the
 * current queue for the current DRIVDATA.
 *
 * An invalid DRIVDATA is considered to be if the pointer is NULL, or if the
 * size is smaller then the DRIVDATA size of OS/2 version 1.3.  In either case,
 * the DRIVDATA from the queue is queried.
 *
 * Memory is allocated to a return pointer and the queue's DRIVDATA is copied.
 *
 * NOTE: This return pointer should be considered a temporary pointer and the
 *       memory should be freed elsewhere.
 *
 * INPUT
 * pdop - A PDEVOPENSTRUC structure.
 * qbuf - Contains the DRIVDATA pointer retrieved from the queue.
 *
 * OUTPUT
 * ppTempDriv - Temporary DRIVDATA pointer.  The data from qbuf's DRIVDATA is
 *  copied here.
 *
 * RETURN-NORMAL = None
 * RETURN-ERROR  = None
 *
 ****************************************************************************/
VOID QueryDefDrivFromQue( PDEVOPENSTRUC pdop, PPRQINFO6 qbuf,
                          PDRIVDATA *ppTempDriv, PBOOL pIsDestnLAN )
{
  /*
  ** Do nothing if no temp DRIVDATA pointer is provided.
  */
  if (ppTempDriv != NULL)
  {
    /*
    ** A current DRIVDATA is considered invalid if the pointer is NULL, or if
    ** the size is smaller than the DRIVDATA size of OS/2 version 1.3.
    */
    if (pdop->pdriv != NULL &&
        pdop->pdriv->cb < PRE_13_BUFFER_SIZE)
    {
      *ppTempDriv = GplMemoryAlloc( pProcessHeap, qbuf->pDriverData->cb );
      memcpy( *ppTempDriv, qbuf->pDriverData, qbuf->pDriverData->cb );
    }
  }

  // @V3.0130814
  if (qbuf->pszRemoteComputerName != NULL &&
      *qbuf->pszRemoteComputerName != 0)
  {
    *pIsDestnLAN = TRUE;
  }
}


/***************************************************************************
 *
 * FUNCTION NAME = ConvertColorModel
 *
 * DESCRIPTION
 * In the PPD version 4.2 spec, the UI string "ColorModel" allows the printer
 * to render a job to the supported color or grayscale.  Essentially, this
 * enables the printer to convert jobs to grayscale, if selected.  However, the
 * driver also converts color internally to grayscale, if selected.  Out of
 * the two, it is preferred that the printer do the conversion since the
 * printer is fined-tuned for better output.
 *
 * In earlier versions of the driver, "ColorModel" was not supported, and the
 * driver did all the conversion.  In order to be backward compatible, this
 * driver needs to know when to let the printer do the conversion or when it
 * should do the conversion.
 *
 * This function is responsible for assuring that the correct flags are set so
 * that the right component does the conversion.  This is only needed when
 * printing across the LAN since that is the only case when it is possible to
 * encounter earlier versions of the driver.
 *
 * The format is as follows:
 *
 * - If printing across the LAN *AND* if "ColorModel" is supported, then this
 *   function queries to see a grayscale-type selection is made:
 *   - If "ColorModel" isn't supported by the printer, then this function
 *     continues on its normal route.
 *   - If printing locally, the color flag does not need to be modified since
 *     the control will eventually pass back to the same driver.
 * - The PPD spec states that the option for "ColorModel" can be *ANY*
 *   string (i.e. there is no one string to identify grayscale, it can be any
 *   string).  Therefore, the only way this driver can identify if grayscale
 *   has been selected is to compare the current selection against the default
 *   value.  **THIS DRIVER ASSUMES THAT THE DEFAULT VALUE FOR COLORMODEL IS A
 *   COLOR SELECTION**.  If the current selection DOES NOT MATCH the default
 *   value, then it is assumed that a monochrome value is selected.
 * - If it has been determined that a monochrome value was selected, then
 *   the driver's color flag (fIsColorDevice in pCNFData) is set to FALSE.
 * - When receiving data from the LAN, if "ColorModel" is supported and if
 *   fIsColorDevice is set to FALSE, then this function sets it back to TRUE
 *   and lets the device handle the rendering.
 * - At the receiving end of LAN printing (on the sever side), this function
 *   checks to see if "ColorModel" is among the list of UI selections.  This
 *   list is created by ConvertUIBitsToStrings().  If it is not, add
 *   "ColorModel" and the monochrome value.  It is not necessary to perform
 *   this function if color is selected because no conversion is needed and
 *   a color printer will normally print in color.
 *
 * Again, it is important to stress that this driver assumes that the default
 * value for ColorModel ("*DefaultColorModel") is set to the color selection.
 * Since the values for color and monochrome can be any value, it is
 * important for this driver to have a fixed point of reference to be able
 * to distinguish if monochrome was selected or not.
 *
 * DEPENDENCY
 * BuildKeyName() determines if the job is going across the LAN.  Therefore,
 * this function must be called after BuildKeyName().
 *
 * RESTRICTION
 * The UI string buffer must be created and stored in pdv->pUISelectList.  The
 * default values may be there, but the list must exist.  This list is created
 * by ConvertUIBitsToStrings().
 *
 * INPUT
 * pdesPPD - PPD data structure.
 * pCNFData - Current selections in Job/Printer Properties.
 * pdv - Device structure.
 * bIsDestnLAN - If TRUE, then the job is going across the LAN.  This value
 *   is retrieved from BuildKeyName().
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL = None
 * RETURN-ERROR  = None
 *
 ****************************************************************************/
// @V3.1142031
VOID ConvertColorModel( PDESPPD pdesPPD, PCNFDATA pCNFData, PDV pdv )
{
  PUI_BLOCK pUIColor;          // Pointer to the ColorModel UI block
  INT       ofsBlock;          // Offset of above block in UI list
  PUI_SEL   pUISelList;        // Pointer to current selection for ColorModel
  PCHAR     pCMString;         // Pointer to "ColorModel" in UI list
  PCHAR     pGroupTerm;        // Pointer to terminator in group string
  INT       ofsColorSelect;    // Value of color UI string to send

  /*
  ** First, query if the device supports color.  If the device does not support
  ** color, then no processing needs to be done.
  ** Also, query if the device supports the "ColorModel" UI.  If it doesn't,
  ** then the driver can convert the image to monochrome.
  ** QueryBlockFromKeyword returns, among other things, the zero-based offset
  ** of the ColorModel Block in respect the the entire UI block list
  ** (ofsBlock).
  */
  if (pdesPPD->desItems.fIsColorDevice == TRUE &&
      (pUIColor = QueryBlockFromKeyword( &pdesPPD->stUIList,
                                         pdesPPD->pPSStringBuff,
                                         UINAME_COLORMODEL, &ofsBlock ))
      != NULL)
  {
    /*
    ** Is the destination a network based device?
    */
    if (pdv->fIsDestnLAN == TRUE)
    {
      /*
      ** Assign a pointer to the UI selection list.
      */
      pUISelList = ASSIGN_UISELLIST_PTR( pCNFData ) + ofsBlock;

      /*
      ** Since the UI ColorModel values can be *ANY* value, the only thing we
      ** can go with is to assume that the default ColorModel value is set
      ** to color, not monochrome.  In that case, query the current selection
      ** against the default ColorModel value.  Remember, that each value in
      ** the UI Selection List corresponds to a block in the list.  ofsBlock
      ** contains the zero-based offset of the ColorModel block in respect to
      ** the UI list, so add that value to the base UI selection list pointer
      ** (pUISelList) to get the current selection for ColorModel.
      ** Also, remember that the default entry is a zero-based offset to the
      ** entry in the list.  By shifting a bit left to this zero-based offset,
      ** you will convert the value to the default selection.
      ** If a match does not exist, then the value selected for ColorModel is
      ** a monochrome value.
      */
      if (*pUISelList != (UI_SEL) (1 << pUIColor->usDefaultEntry))
      {
        pCNFData->jobProperties.fIsColorDevice = FALSE;
      }
    }
    /*
    ** At this point, ColorModel is supported, but fIsColorDevice is FALSE.
    ** This can happen for two reasons: 1) The value was set to FALSE (above)
    ** and execution is at the server or 2) the data was received from an
    ** earlier version of the driver where ColorModel was not supported.  In
    ** either case, since ColorModel is supported now, set the value to TRUE.
    ** It does not matter if ColorModel is set to true or false, all that
    ** matters is that it is supported, so let the device do the conversion.
    */
    else if (pCNFData->jobProperties.fIsColorDevice == FALSE)
    {
      /*
      ** "ColorModel" is somewhere in the list (at least the default setting
      ** was inserted).  Find it.
      */
      pCMString = strstr( pdv->pUISelectList, UINAME_COLORMODEL );

      /*
      ** Since the default value is assumed to be a color setting and the
      ** point in this code indicates a monochrome setting, remove the
      ** color setting by using memmove() to move the area of the buffer after
      ** ColorModel up.  This will erase ColorModel and the code below can
      ** insert the monochrome value.
      */
      if (pCMString != NULL && *(pCMString + strlen( UINAME_COLORMODEL )) ==
          ',')
      {
        pGroupTerm = strchr( pCMString, ';' ) + 1;
        memmove( pCMString, pGroupTerm, strlen( pGroupTerm ) + 1 );
      }

      /*
      ** Save the string "ColorModel".
      */
      SaveINIGroupData( (PBYTE) pdv->pUISelectList, UINAME_COLORMODEL );

      /*
      ** Since the default value is alwasy asummed to be color and if
      ** monochrome was selected, then set the current offset value to the
      ** value that is NOT the default.  Save the value.
      */
      if (pUIColor->usDefaultEntry == 0)
      {
        ofsColorSelect = 1;
      }
      else
      {
        ofsColorSelect = 0;
      }
      SaveINIGroupData( (PBYTE) pdv->pUISelectList, pdesPPD->pPSStringBuff +
                        pUIColor->uiEntry[ ofsColorSelect ].ofsOption );

      SaveINIGroupData( (PBYTE) pdv->pUISelectList, NULL );

      pCNFData->jobProperties.fIsColorDevice = TRUE;
    }
  }
}

/* DBCS enabling start */                                               //@DBCS
/***************************************************************************
 *
 * FUNCTION NAME =  MatchHWFontNameJpn
 *
 * DESCRIPTION   =
 *
 * Returns the index number (1-n), in the current printer's list of supported
 * fonts, of the font that has the specified face name, or 0 if not found.
 *
 * Effects: Scans the list of all fonts offered by the current printer until
 *          one is found whose font name is the same as that requested. The
 *          index of this matching font is then returned. If no match is
 *          found, 0 is returned.
 *
 * Warnings: Fonts have two different names.  The FullName is the most
 *           complete; an example is "ITC Avant Garde Gothic Book Oblique".
 *           However, the font names used in the printer font list have an
 *           abbreviated form like "AvantGarde-BookOblique".
 *
 * INPUT         = PSZ     pszFontName
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = Index number of desired font, or 0 if it wasn't found.
 *
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/

SHORT MatchHWFontNameJpn( PSZ pszFontName )
{
  SHORT i;

  /*
  ** Find the resource number corresponding to this fontfullname
  */
  for (i = 0; FontResourceName[i]; i++)
  {
    if (szIsEqual(pszFontName,
                  (PSZ)FontResourceName[i]) )
    {
      /*
      ** On Japanese environment, the one font face name is related with
      ** two font full names. Then the driver need to adjust the index of
      ** font resource.
      */
      if (szIsEqual (pszFontName, (PSZ)GOTHIC_NAME))
      {
        if (flGot)
        {
          flGot = FALSE;
          continue;
        }
        else
          flGot = TRUE;
      }
      else if (szIsEqual (pszFontName, (PSZ)MINCHO_NAME))
      {
        if (flMin)
        {
          flMin = FALSE;
          continue;
        }
        else
          flMin = TRUE;
      }
      return i;
    }
  }

  return 0;
}
/* DBCS enabling end   */                                               //@DBCS





// @V3.1142031 - New function
/***************************************************************************
 *
 * FUNCTION NAME = CopyDEVOPENSTRUCData
 *
 * DESCRIPTION
 * Copies a source DEVOPENSTRUC to a destination DEVOPENSTRUC in a PDV
 * buffer
 *
 * INPUT
 * pdv - Contains the destination DEVOPENSTRUC.
 * pdop - Contains the source DEVOPENSTRUC.
 *
 * OUTPUT
 * None
 *
 * RETURN-NORMAL = None
 * RETURN-ERROR  = None
 *
 **************************************************************************/
VOID CopyDEVOPENSTRUCData( PDV pdv, PDEVOPENSTRUC pdop )
{
  xPDEVOPENSTRUC xpdop;
  PDEVOPENSTRUC  pLclDop     = &pdv->dop;
  PDV_DOP        pLcldev_dop = &pdv->dev_dop;
  PCNFDATA       pcnfData = (PCNFDATA) pdv->dop.pdriv->abGeneralData;
  BOOL           fIgnoreFormsMisMatch = FALSE;
  CHAR           aBuffer[MAX_PSIZE];
  CHAR           aSpoolerParms[MAX_SPOOLERPARM];
  PSZ            pszParmEquals;
  PSZ            pszPRTYParm = NULL;
  PCHAR          pChar;

  if (pdop->pszLogAddress != NULL)
  {
    szCopy( (PSZ) pLcldev_dop->LogAddress, (PSZ) pdop->pszLogAddress,
            sizeof( pLcldev_dop->LogAddress ) );
    pLclDop->pszLogAddress = (PSZ) pLcldev_dop->LogAddress;
  }

  /*
  ** get the driver name and save it.
  */
  szCopy( (PSZ) pLcldev_dop->DriverName, (PSZ)PSCRIPT_DRV_NAME,
          sizeof( pLcldev_dop->DriverName ) );
  pLclDop->pszDriverName = (PSZ) pLcldev_dop->DriverName;

  /*
  ** copy the data type into the dev_dop.datatype and make the dop
  ** pointer point to it.
  */
  /*
  ** Note can only be STD if queued
  */
  xpdop = (xPDEVOPENSTRUC) pdop;
  if ( (pdop->pszDataType != NULL)                     &&
       szIsEqual( pdop->pszDataType, (PSZ)"PM_Q_STD" ) &&
       ( xpdop->ulType == OD_QUEUED )    )  ////////    &&        //@V4.1190984
////// ( pcnfData->iDestnType == SYSTEM) )                        //@V4.1190984
  {
    szCopy( (PSZ)pLcldev_dop->DataType, pdop->pszDataType,
            sizeof( pLcldev_dop->DataType ) );
    pdv->usDataType = PM_Q_STD;
  }
  else
  {
    szCopy( (PSZ)pLcldev_dop->DataType, (PSZ) "PM_Q_RAW",
            sizeof( pLcldev_dop->DataType )  );
    pdv->usDataType = PM_Q_RAW;
  }

  /* @V4.1190984
  ** Due to changes in the engine we can no longer simply switch from STD to
  ** RAW when going to JP file (vs Que output print to file). The engine
  ** "sees" the STD flag in the users DEVOPENSTUCT and optimizes some things
  ** causing the driver not to get some calls.
  ** We can't change the flag there cause it is in the users data.
  ** -So we must spool STD then change the destination on pass 2.
  */
  // If the job is not to system and spooled STD then record what type and
  // change the destination back to system
  if ( pcnfData->iDestnType != SYSTEM  &&   // IF -NOT- system -AND-
       pdv->usDataType == PM_Q_STD      )   // job is std
  {
    // Record type
    if ( pcnfData->iDestnType == RAW )
    {
      SETFLAG( pcnfData->ulFlags, RAW_FILE );
    }
    else
    {
      SETFLAG( pcnfData->ulFlags, ENCAPS_FILE );
    }

    // Reset back to system
    pcnfData->iDestnType = SYSTEM;
  }

  /* @V4.1190984
  ** If job has a destination flag set and is raw then change the destination
  */
  if ( CHECKFLAG( pcnfData->ulFlags, RAW_FILE | ENCAPS_FILE ) != 0 &&
       pdv->usDataType == PM_Q_RAW                                  )
  {
    if ( CHECKFLAG( pcnfData->ulFlags, RAW_FILE ) != 0 )
    {
      pcnfData->iDestnType = RAW;
    }
    else
    {
      pcnfData->iDestnType = ENCAPS;
    }

    CLEARFLAG( pcnfData->ulFlags, RAW_FILE | ENCAPS_FILE );
  }


  pLclDop->pszDataType = pLcldev_dop->DataType;

  /*
  ** copy the comments.  if the user has given us a pointer to comments,
  ** copy the comments into dev_dop.comment, and make the dop pointer
  ** point to it.  otherwise, set the dop pointer to NULL.
  */
  if (pdop->pszComment != NULL)
  {
    szCopy( (PSZ) pLcldev_dop->Comment,
            (PSZ) pdop->pszComment,
            sizeof( pLcldev_dop->Comment ) );
    pLclDop->pszComment = (PSZ) pLcldev_dop->Comment;
  }

  /*
  ** copy the queueprocname.  if the user has given us a pointer to
  ** the queue proc name, copy the name into dev_dop.queueprocname,
  ** and make the dop pointer point to it.  otherwise, set the dop
  ** pointer to NULL.
  */
  if (pdop->pszQueueProcName != NULL)
  {
    szCopy( (PSZ) pLcldev_dop->QueueProcName,
            (PSZ) pdop->pszQueueProcName,
            sizeof( pLcldev_dop->QueueProcName ) );
    pLclDop->pszQueueProcName = (PSZ) pLcldev_dop->QueueProcName;
  }

  /*
  ** copy the queueproc parameters.  if the user has given us a pointer to
  ** the queue proc params, copy the params into dev_dop.queueprocparams,
  ** and make the dop pointer point to it.  otherwise, set the dop pointer
  ** to NULL.
  */
  if (pdop->pszQueueProcParams != NULL)
  {
    szCopy( (PSZ) pLcldev_dop->QueueProcParams, (PSZ) "COL=C ",
            sizeof( pLcldev_dop->QueueProcParams ) );
    szCopy( (PSZ) (pLcldev_dop->QueueProcParams + 6),
            (PSZ) pdop->pszQueueProcParams,
            (sizeof( pLcldev_dop->QueueProcParams ) - 6) );
    pLclDop->pszQueueProcParams = (PSZ) pLcldev_dop->QueueProcParams;

    /* @V4.0160760
    ** If this is a raw job comming in make a note
    */
    if ( strstr( pdop->pszQueueProcParams, "DATATYPE=PM_Q_RAW" ) )
    {
      SETFLAG( pdv->ulGenFlags, DATATYPE_RAW );
    }
  }

  /*
  ** copy the spooler parameters.  if the user has given us a pointer to
  ** the spooler params, copy the params into dev_dop.spoolerparams, and
  ** make the dop pointer point to it.  otherwise, set the dop pointer
  ** to NULL.
  */
  /*
  ** @V3.1142412
  ** In the case of auto tray select, do not copy "FORM=".  This way, the
  ** spooler will not then query if the form inserted is mapped to a
  ** specific tray.  In the case of auto tray select, the printer will
  ** automatically assign a tray.
  */
  /* @V3.1147743
  ** We dont want to have a  forms mismatch for Manual tray or
  ** Autotray when the Mismatch button is checked
  */
  if ( strcmp( pcnfData->u.iv.aTraySelected, MANUALFEED_STRING ) == 0 )
  {
    fIgnoreFormsMisMatch = TRUE;
  }
  else
  {
    ReadPrtPropOptionsINI( pcnfData->szKeyApp, INISUBKEY_OVERRIDEMM,
                           &fIgnoreFormsMisMatch );
  }

  /* @V3.2115649 copy over parms to local mem */
  if ( pdop->pszSpoolerParams != NULL )
  {
    szCopy( aSpoolerParms, pdop->pszSpoolerParams, MAX_SPOOLERPARM );
  }
  else
  {
    aSpoolerParms[0] = '\0';
  }

  /* @V3.2115649 Process PRTY parm part I
  ** If it's at the begining no problem now.  If it's end need to isolate
  ** it so it isn't picked up as a form
  */
  if ( aSpoolerParms[0]                                          &&
       ( pszPRTYParm = strstr( aSpoolerParms, "PRTY=" ) ) != NULL )
  {
    /* If in last position chop it off */
    if ( pszPRTYParm != aSpoolerParms )
    {
      *(pszPRTYParm - 1) = '\0';
    }
  }

  /* @V3.2115649 If a form name is provided and it is different from  JP
  ** change it
  */
  if ( aSpoolerParms[0] != NULL                                         &&
       ( pszParmEquals = strstr( aSpoolerParms, "FORM=" ) )
                                                               != NULL  &&
       *(pszParmEquals+5) != '\0' )
  {
    strcpy( aBuffer, pszParmEquals );  /* Copy the forms into temp buff */

    /* If the form names don't match then reset the form name */
    if ( CompareRealNames( &aBuffer[ 5 ], pcnfData->jobProperties.szFormName ) )
    {
      /* Copy supplied name as form name */
      SetNewFormName( &aBuffer[ 5 ], pdv->pdesPPD, pcnfData );            //@V3.2115649
    }

  }

  if ( pcnfData->jobProperties.szFormName[0] != '\0' &&
       fIgnoreFormsMisMatch == FALSE                  )            //@V3.1147743
  {
    GetOldFormName( pdv->pdesPPD, pcnfData->jobProperties.szFormName,
                    aBuffer );
    szCopy( (PSZ) pLcldev_dop->SpoolerParams, (PSZ) "FORM=",
            sizeof( pLcldev_dop->SpoolerParams ) );
    szCopy( (PSZ) (pLcldev_dop->SpoolerParams + 5),
            (PSZ) aBuffer,
            (sizeof( pLcldev_dop->SpoolerParams ) - 5) );
    pLclDop->pszSpoolerParams = (PSZ) pLcldev_dop->SpoolerParams;
  }

  /* @V3.2115649 Process PRTY parm part II
  ** If at begining chop of blank if there is one.
  ** If at end no need to to anything
  */
  if ( pszPRTYParm )
  {
    if ( pszPRTYParm == aSpoolerParms ) /* at begining */
    {
      if ( ( ( pChar = strchr( pszPRTYParm, ' ' ) ) ) != 0 )
      {
        *pChar = '\0';
      }
    }
    strcat( pLcldev_dop->SpoolerParams," " );
    strcat( pLcldev_dop->SpoolerParams, pszPRTYParm );
  }


  /*
  ** copy the network parameters.  if the user has given us a pointer to
  ** the network params, copy the params into dev_dop.networkparams, and
  ** make the dop pointer point to it.  otherwise, set the dop pointer
  ** to NULL.
  */
  if (pdop->pszNetworkParams != NULL)
  {
    szCopy( (PSZ) pLcldev_dop->NetworkParams,
            (PSZ) pdop->pszNetworkParams,
            sizeof( pLcldev_dop->NetworkParams ) );
    pLclDop->pszNetworkParams = (PSZ) pLcldev_dop->NetworkParams;
  }
}

/*
** New Functions For @V3.1147608
*/
/*********************************************************************\
**
** FUNCTION: ResStrToBin
**
** DESCRIPTION: Converts the XXXxYYYdpi string to shorts
**
\*********************************************************************/

VOID ResStrToBin( PSZ         pResStr,  /* Ptr to resolution string  */
                  PRESOLUTION pRes      /* Ptr to resolution var     */
                )
{
  PSZ        pszYRes;

  pRes->x = atoi( pResStr );
  if ( pRes->x == 0 )                   /* Check return value from   */
  {                                     /* atoi.  If 0, atoi wasn't  */
    pRes->y = 0;                        /* able to convert to an     */
    return ;                            /* integer. So we'll return. */
  }                                     /* @V4.0173031               */

  pszYRes = strchr( pResStr, 'x' );     /* Look for possible y res   */

  if ( pszYRes )                        /* Check result from strchr  */
  {
    pRes->y = atoi( ++pszYRes );        /* Set y to second value     */
    if ( pRes->y == 0 )                 /* Check return value from   */
    {                                   /* atoi.  If 0, atoi wasn't  */
      return ;                          /* able to convert to an     */
                                        /* integer. So we'll return. */
    }                                   /* @V4.0173031               */
  }
  else
  {
    pRes->y = pRes->x;                  /* y = x (square resolution) */
  }

  return;
}

/*****************************************************************************\
**
** FUNCTION: GetCurrentResolution
**
** DESCRIPTION: Gets the current resolution from Job Props
**
\*****************************************************************************/

VOID GetCurrentResolution( PRESOLUTION  pRes,
                           PDESPPD      pdesPpd,
                           PCNFDATA     pcnfData )
{
//  INT ofsSelBit = 0;
  PSZ pResStr;

  pResStr = (PSZ) QueryUIOptionString( pdesPpd,
                                       ASSIGN_UISELLIST_PTR( pcnfData ),
                                       UINAME_RESOLUTION, NULL,
                                       NULL );

  if (pResStr != NULL && *pResStr != 0)
  {
    ResStrToBin( pResStr, pRes );
  }
  else
  {
    pRes->x = pRes->y = pdesPpd->desItems.iResDpi;
  }

  return;
}


/*****************************************************************************\
**
** FUNCTION: CheckForPrinterName
**
** DESCRIPTION: This is a quick search of printer resources to see if a
**  particular printer is known by the driver
**
** RETURNS: TRUE is found, FALSE if not
**
\*****************************************************************************/

BOOL CheckForPrinterName( PSZ pszTargetPrinter )
{
  BOOL       fRC = FALSE;              // Return code
  INT        i;                        // Counter
  INT        iCntFiles;                // Stack var
  PDRENTRY   pDrTable;                 // pointer to printer segments
  PSIGNATURE pSignature;               // Pointer to signature

  // Get the directory of PPBs resource
  if ( DosGetResource( pscript_module,
                       ALLPPDS,
                       DIRECTORY_PPB,
                       (PPVOID) &pSignature ) != 0 )
  { // Non Zero is bad news, return
    return( FALSE );
  }

  // Make copy of count for fast access
  iCntFiles = pSignature->cntEntries;

  pDrTable = (PDRENTRY)((BYTE *)pSignature + sizeof( SIGNATURE ));

  // Must loop thru entire list cause it is not perfectly sorted
  for ( i = 0; i < iCntFiles; i++ )
  {
    if ( strcmp( pszTargetPrinter, pDrTable->szName ) == 0 )
    {
      fRC = TRUE;
      break;
    }
    pDrTable++;
  }

  DosFreeResource( pSignature );
  return fRC;
}


/*****************************************************************************\
**
** FUNCTION: SearchExtraDV
**
** DESCRIPTION: Search for extra device information
**
** RETURNS: pointer to ExtraDV if found, NULL if not
**
\*****************************************************************************/

PEXTRA_DV SearchExtraDV( PSZ szDeviceName )
{
  extern EXTRA_DV ExtraDV[];
  
  PEXTRA_DV pExtraDV;
  INT iDevice;
  BOOL cmp;

  if( !szDeviceName || !*szDeviceName )
    return NULL;
  
  cmp = TRUE;
  for( iDevice = 0; cmp; iDevice++)
  {
    pExtraDV=&ExtraDV[iDevice];
    if( *pExtraDV->szDeviceName )
    {
      cmp = strcmp( pExtraDV->szDeviceName, szDeviceName );
      if ( !cmp )
        return pExtraDV;
    }
    else
      return NULL;
  }

  return NULL;
}

