/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
//#pragma  pagesize(55)

/**************************************************************************
 *
 * SOURCE FILE NAME = PLOTTERS.C
 *
 * DESCRIPTIVE NAME = Plotter Data Definitions
 *
 *
 * VERSION = V2.0
 *
 * DATE      09/18/88
 *
 * DESCRIPTION Contains defintions of plotter characteristics for all
 *             supported plotters
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *             PlotterClass
 *             PlotterDef
 *             usPlotterCount
 *             PrintOffTable
 *             PhysicalPageSize
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#define INCL_GENPLIB_COMPRESS          /* include genplib compression       */
#include "plotters.h"
#include "dialog.h"
#include "color.h"

#define HPGL_HP7440AGEC (HPGL_ARCS | HPGL_CHARSET7 | HPGL_CIRCLE | HPGL_EDGERECT | HPGL_FILLRECT | HPGL_POLYGON)

#define HPGL_HP7470A    (HPGL_ARCS | HPGL_CIRCLE)

#define HPGL_HP7475A    (HPGL_ARCS | HPGL_CHARSET7 | HPGL_CIRCLE | HPGL_EDGERECT | HPGL_FILLRECT | HPGL_PENTHICK)

#define HPGL_HP7580A    (HPGL_ARCS | HPGL_AUTOPEN | HPGL_AUTOVIEW | HPGL_CIRCLE)

#define HPGL_HP7585A    (HPGL_ARCS | HPGL_AUTOPEN | HPGL_AUTOVIEW | HPGL_CIRCLE)


#define PENTYPES_80 9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9, \
                    9,9,9,9,9,9,9,9,9,9

// new page protect PJL commands
PSZ     pszPJLPageProtOFF = "@PJL SET PAGEPROTECT=OFF \012",
        pszPJLPageProtLTR = "@PJL SET PAGEPROTECT=LETTER \012",
        pszPJLPageProtA4  = "@PJL SET PAGEPROTECT=A4 \012",
        pszPJLPageProtLGL = "@PJL SET PAGEPROTECT=LEGAL \012",
        pszPJLPageProtLEDGER = "@PJL SET PAGEPROTECT=LEDGER \012",
        pszPJLPageProtAUTO= "@PJL SET PAGEPROTECT=AUTO \012",
        pszPJLPageProtON  = "@PJL SET PAGEPROTECT=ON \012";

/*
**      Definition data for the plotters handled by this driver.
*/

POINTL aptlRes_Table [MAX_RESOLUTIONS] =
{
   {150 , 150},       /* RES_150X150INDEX     0000  */
   {180 , 180 },      /* RES_180X180INDEX     0001  */
   {200 , 200 },      /* RES_200X200INDEX     0002  */
   {204 , 204 },      /* RES_204X204INDEX     0003  */
   {300 , 300 },      /* RES_300X300INDEX     0004  */
   {600 , 600 },      /* RES_600X600INDEX     0005  */
   {800 , 800 },      /* RES_800X800INDEX     0006  */
   {1200, 600 },      /* RES_1200X600INDEX    0007  */
   {1200, 1200}       /* RES_1200X1200INDEX   0008  */
};
/*
** Changed to "far" so that devmode.c could access it...                @MARK
** Because I added a new pen width, I had to add to the PenTypeSupport in
** the DEVICEINFO initialisation in the PLOTTERCLASS elements...        @MARK
*/
PLOTTERCLASS PlotterClass [MAX_PLOTTER_CLASSES] =
{
   /*
   ** #0 HP7440A (ColorPro) or IBM6180
   */
   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_NONE,                      /* HPGL Capabilities without GEC */
       HPGL_HP7440AGEC,                /* HPGL Capabilities with GEC */
                                       /* Odd device implementations */
       OD_COLOR,                       /* Color Device            */
       0,                              /* Max Polygon without GEC */
       86,                             /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       0,                              /* P1P2Table Entry     */
       0,                              /* PaperResTable Entry */
       0,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           /*
           ** DeviceInfo
           */

           { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },/* Pen type support */
           { 1, 0, 0, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           1,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_A4,         /* Media Size support */
           { 0, 0, 0, 0, 0, 0, 0, 0 }, /* ForceValue */
           { 1, 40, 1 },               /* Speed: Min,Max,Incr */
           { 0, 0, 0 },                /* Force: Min,Max,Incr */
           { 0, 0, 0 }                 /* Accel: Min,Max,Incr */
       },
       {
           /*
           ** penOptions
           */

           { 40, 10, 0, 0, 0 },
           { 0, 0, 0, 0, 0 },
           { 0, 0, 0, 0, 0 }

       },
       {
           /*
           ** DefProfile
           */
           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           0,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #1  HP 7470A, or IBM7371
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_HP7470A,                   /* HPGL Capabilities without GEC */
       HPGL_HP7470A,                   /* HPGL Capabilities with GEC */
                                       /* Odd device implementations */
       OD_COLOR,                       /* Color Device            */
       0,                              /* Max Polygon without GEC */
       0,                              /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       0,                              /* P1P2Table Entry     */
       0,                              /* PaperResTable Entry */
       1,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Pen type support */
           { 1, 0, 0, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           2,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_A4,         /* Media size support */
           { 0, 0, 0, 0, 0, 0, 0, 0 }, /* ForceValue */
           { 4, 38, 1 },
           { 0, 0, 0 },
           { 0, 0, 0 }
       },
       {
           /*
           ** PenOptions
           */

           { 38, 10, 0, 0, 15 },
           { 0, 0, 0, 0, 0 },
           { 0, 0, 0, 0, 0 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 0, 0, 0, 0, 0, 0 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           0,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #2  HP 7475A, or IBM7372
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_HP7475A,                   /* HPGL Capabilities without GEC */
       HPGL_HP7475A,                   /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE,                    /* Odd device implementations */
       0,                              /* Max Polygon without GEC */
       0,                              /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       1,                              /* P1P2Table Entry     */
       1,                              /* PaperResTable Entry */
       2,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Pen type support */
           { 1, 0, 0, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           6,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_A4 | MEDSZ_A3,     /* Media size */
           { 0, 0, 0, 0, 0, 0, 0, 0 },     /* ForceValue */
           { 1, 38, 1 },
           { 0, 0, 0 },
           { 0, 0, 0 }
       },
       {
           /*
           ** PenOptions
           */

           { 38, 10, 0, 0, 15 },
           { 0, 0, 0, 0, 0 },
           { 0, 0, 0, 0, 0 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 0, 0 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           0,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #3  HP 7550A or IBM 6182 enhanced mode
   */
   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE |                   /* Odd device implementations filltype */
//     6182 has 2 modes - enhanced mode requires OD_USERIW
//                        standard mode does not require OD_USERID
//                        The hardware default is Standard
//                         our default is Enhanced
       OD_USERIW |                     /* IW in user units */
       OD_FILLRECT_INCLUSIVE,          /* @MJH2 */
       626,                            /* Max Polygon without GEC */
       626,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       2,                              /* P1P2Table Entry     */
       2,                              /* PaperResTable Entry */
       3,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_A4 | MEDSZ_A3,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           0,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #4  HP 7580A
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_HP7580A,                   /* HPGL Capabilities without GEC */
       HPGL_HP7580A,                   /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_USERIW,                      /* Odd device implementations */
       0,                              /* Max Polygon without GEC */
       0,                              /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       3,                              /* P1P2Table Entry     */
       3,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1,  /* Media size */
           { 10, 18, 26, 34, 42, 50, 58, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 40, 10, 0, 0, 0 },
           { 2, 0, 6, 2, 1 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           3,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #5  HP 7585A
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_HP7585A,                   /* HPGL Capabilities without GEC */
       HPGL_HP7585A,                   /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_USERIW,                      /* Odd device implementations */
       0,                              /* Max Polygon without GEC */
       0,                              /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0,  /* Media size */
           { 10, 18, 26, 34, 42, 50, 58, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 40, 10, 0, 0, 0 },
           { 2, 0, 6, 2, 1 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #6  HP 7580B, or IBM7374
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_USERIW,                      /* Odd device implementations */
       218,                            /* Max Polygon without GEC */
       218,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       3,                              /* P1P2Table Entry     */
       3,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1,  /* Media size */
           { 10, 18, 26, 34, 42, 50, 58, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 0, 60, 30, 15 },
           { 2, 0, 6, 2, 1 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           3,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #7  HP 7585B or IBM7375-1
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_USERIW,                      /* Odd device implementations */
       218,                            /* Max Polygon without GEC */
       218,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0,  /* Media size */
           { 10, 18, 26, 34, 42, 50, 58, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 0, 60, 30, 15 },
           { 2, 0, 6, 2, 1 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #8  HP 7586B or IBM7375-2
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE | OD_USERIW,        /* Odd device implementations */
       218,                            /* Max Polygon without GEC */
       218,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
            MEDSZ_R24 | MEDSZ_R36,                 /* Media size */
           { 10, 18, 26, 34, 42, 50, 58, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 0, 60, 30, 15 },
           { 2, 0, 6, 2, 1 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #9  HP7570A (DraftPro), or IBM6184
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE | OD_USERIW,        /* Odd device implementations */
       256,                            /* Max Polygon without GEC */
       256,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       5,                              /* P1P2Table Entry     */
       5,                              /* PaperResTable Entry */
       4,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 0, 0, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           /*
           ** The Draftpro DXL supports all Architectural  paper sizes
           **
           */
           MEDSZ_C | MEDSZ_D | MEDSZ_A2 | MEDSZ_A1 |  /* Media size */
           MEDSZ_AB | MEDSZ_AC |                      /* Media size */
           MEDSZ_AD | MEDSZ_AE,                       /* Media size */
           { 0, 0, 0, 0, 0, 0, 0, 0 }, /* ForceValue */
           { 1, 40, 1 },
           { 0, 0, 0 },
           { 0, 0, 0 }
       },
       {
           /*
           ** PenOptions
           */

           { 40, 0, 0, 20, 15 },
           { 0, 0, 0, 0, 0 },
           { 0, 0, 0, 0, 0 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           3,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #10  HP7595A (DraftMaster I) or IBM 6186-1
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE | OD_USERIW,        /* Odd device implementations */
       256,                            /* Max Polygon without GEC */
       256,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       6,                              /* P1P2Table Entry     */
       6,                              /* PaperResTable Entry */
       5,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
            MEDSZ_AB | MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 30, 30 },
           { 2, 2, 6, 3, 3 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #11  HP7596A (DraftMaster II) or IBM 6186-2
   */

   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE | OD_USERIW,        /* Odd device implementations */
       256,                            /* Max Polygon without GEC */
       256,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       6,                              /* P1P2Table Entry     */
       6,                              /* PaperResTable Entry */
       5,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
            MEDSZ_R24 | MEDSZ_R36 |                       /* Media size */
            MEDSZ_AB | MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 30, 30 },
           { 2, 2, 6, 3, 3 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #12  HPGL2 PaintJet XL
   */

   {
       "\033%-1BBP;",                  /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       ((HPGL_ALL | HPGL2) & ~HPGL_AUTOVIEW), /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2) & ~HPGL_AUTOVIEW), /* HPGL Capabilities with GEC */
                                              /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_COLOR |                      /* Color Device            */
       OD_VERTICAL_P1P2,               /* P1P2 is in vertical units */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_180X180,                    /* Supported resolutions */
       7,                              /* P1P2Table Entry     */
       7,                              /* PaperResTable Entry */
       6,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_A4 | MEDSZ_A3,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           0,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_180X180INDEX              /* Default resolution */
       }
   },

   /*
   ** #13  DesignJet 600  ( HPGL2 )
   */

   {
//     "\033%0BBP5,1",                   /* Device Mode Init String */
//      (PSZ)NULL,                       /* Device Mode Termination String */
       "\033%-12345X@PJL ENTER LANGUAGE = HPGL2\x00a\033%-1BBP5,1", /*Mode Init Str*/
       "\033%0A\033%-12345X",          /* Device Mode Termination String */
                                       /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* HPGL Capabilities with GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_VERTICAL_P1P2 |              /* P1P2 is in vertical units */
       OD_HPRTL,                       /* Supports HPRTL language */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_300X300,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       7,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       //could not get adaptive compression to work on the 650c with
       //bitmaps greater than 32k
       //DRV_COMPRESS_ADAPTIVE,        /* Supported driver compression modes  */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
           MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
           MEDSZ_R24 | MEDSZ_R36 |                       /* Media size */
           MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,               /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           4,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_300X300INDEX              /* Default resolution */
       }
   },

   /*
   ** #14 PaintJet XL 300( HPGL2 )
   */
   {
       "\033%-12345X",                  /*Mode Init Str*/
       "\033%0A\033E\033%-12345X",      /* Device Mode Termination String */
                                       /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* HPGL Capabilities with GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_VERTICAL_P1P2 |              /* P1P2 is in vertical units */
       OD_PCL |                        /* Supports PCL language  */
       OD_COLOR |                      /* Color Device           */
       OD_BITMAP_SCALING,              /* Bitmap scalling        */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_300X300,                    /* Supported resolutions */
       7,                              /* P1P2Table Entry     */
       7,                              /* PaperResTable Entry */
       8,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B |         /* Media size */
           MEDSZ_A4 | MEDSZ_A3,        /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           0,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_300X300INDEX              /* Default resolution */
       }
   },

   /*
   ** #15  (HP DraftMaster Series)
   */

   {
       "\033%0BBP5,1",                 /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_FILLTYPE | OD_USERIW,        /* Odd device implementations */
       256,                            /* Max Polygon without GEC */
       256,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       6,                              /* P1P2Table Entry     */
       6,                              /* PaperResTable Entry */
       9,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
            MEDSZ_R24 | MEDSZ_R36 |                       /* Media size */
            MEDSZ_AB | MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 30, 30 },
           { 2, 2, 6, 3, 3 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of Active Carousels */
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },
   /*
   ** #16  DesignJet 650C  ( HPGL2 / HPRTL Color Device )
   */

   {
       "\033%-12345X@PJL ENTER LANGUAGE = HPGL2\x00a\033%-1BBP5,1", /*Mode Init Str*/
       "\033%0A\033%-12345X",          /* Device Mode Termination String */
                                       /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* HPGL Capabilities with GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_VERTICAL_P1P2 |              /* P1P2 is in vertical units */
       OD_HPRTL |                      /* Supports HPRTL language */
       OD_COLOR |                      /* Color Device            */
       OD_BITMAP_SCALING |             /* Bitmap scalling        */
       OD_NEEDS_GAMMA,                 /* Do a default gamma correction */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_300X300,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       7,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       //could not get adaptive compression to work on the 650c with
       //bitmaps greater than 32k
       //DRV_COMPRESS_ADAPTIVE,        /* Supported driver compression modes  */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
           MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
           MEDSZ_R24 | MEDSZ_R36 |                       /* Media size */
           MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,               /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           4,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_300X300INDEX              /* Default resolution */
       }
   },

   /*
   ** #17 MONO PCL/HPGL2 Device ( HPGL2 )
   */
   {
       "\033%-12345X", /*Mode Init Str*/
       "\033%0A\033E\033%-12345X",     /* Device Mode Termination String */
                                       /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* HPGL Capabilities with GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_VERTICAL_P1P2 |              /* P1P2 is in vertical units */
       OD_PCL |                        /* Supports PCL language  */
       OD_PAGEPROTECT |                /* Supports page protection */
       OD_BITMAP_SCALING,              /* Bitmap scalling        */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_600X600 |                   /* Supported resolutions */
       RES_1200X600,
       7,                              /* P1P2Table Entry     */
       7,                              /* PaperResTable Entry */
       8,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B |         /* Media size */
           MEDSZ_A4 | MEDSZ_A3,        /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           0,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_600X600INDEX              /* Default resolution */
       }
   },


   /*
   ** #18  HPC3170A (Draft Pro Plus Series...)
   */

   {
       "\033%-12345X@PJL ENTER LANGUAGE = HPGL2\033%-1BBP", /*Mode Init Str*/
       "\033%-12345X@PJL",             /* Device Mode Termination String */
       HPGL_ALL | HPGL2,               /* HPGL Capabilities without GEC */
       HPGL_ALL | HPGL2,               /* HPGL Capabilities with GEC */
       OD_COLOR | OD_HPGL2_PENPLOTTER  /* Color Device            */
       | OD_FILLTYPE | OD_USERIW,      /* Odd device implementations */
       256,                            /* Max Polygon without GEC */
       256,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       6,                              /* P1P2Table Entry     */
       6,                              /* PaperResTable Entry */
       5,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           0,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
            MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
            MEDSZ_AB | MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 60, 1 },
           { 1, 8, 1 },
           { 1, 4, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 30, 30 },
           { 2, 2, 6, 3, 3 },
           { 4, 4, 4, 4, 4 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           4,                            /* Default Media size */
           1,                            /* number of Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },

   /*
   ** #19  DesignJet 230  ( HPGL2 / HPRTL Color Device )
   ** Designjet 230 class is a dup of the 650 class.
   ** However the 230 had a     drawing white text with
   ** a thin pen.  Therefore, we needed to know we were
   ** printing on a 230 to code around the     by increasing
   ** the pen width when drawing white.
   */

   {
       "\033%-12345X@PJL ENTER LANGUAGE = HPGL2\x00a\033%-1BBP5,1", /*Mode Init Str*/
       "\033%0A\033%-12345X",          /* Device Mode Termination String */
                                       /* HPGL Caps.  without GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* HPGL Capabilities with GEC */
       ((HPGL_ALL | HPGL2 | HPGL2_BEZIER) & ~HPGL_AUTOVIEW),
                                       /* Odd device implementations */
       OD_USERIW |                     /* IW is in user device units */
       OD_FILLTYPE |                   /* Supports fill type command FT */
       OD_VERTICAL_P1P2 |              /* P1P2 is in vertical units */
       OD_HPRTL |                      /* Supports HPRTL language */
       OD_COLOR |                      /* Color Device            */
       OD_BITMAP_SCALING |             /* Bitmap scalling        */
       OD_NEEDS_GAMMA,                 /* Do a default gamma correction */
       1024,                           /* Max Polygon without GEC */
       1024,                           /* Max Polygon with GEC */
       256,                            /* Max HPGL2 pens for pen palette (NP) */
       RES_300X300,                    /* Supported resolutions */
       4,                              /* P1P2Table Entry     */
       4,                              /* PaperResTable Entry */
       7,                              /* PrintOffTable Entry */
       GPLCOMPRESS_RLL  |              /* Supported Genplib compression modes */
       GPLCOMPRESS_TIFF |
       GPLCOMPRESS_DELTAROW,
       //could not get adaptive compression to work on the 650c with
       //bitmaps greater than 32k
       //DRV_COMPRESS_ADAPTIVE,        /* Supported driver compression modes  */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
      {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           0,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_C | MEDSZ_D | MEDSZ_E |
           MEDSZ_A4 | MEDSZ_A3 | MEDSZ_A2 | MEDSZ_A1 | MEDSZ_A0 |
           MEDSZ_R24 | MEDSZ_R36 |                       /* Media size */
           MEDSZ_AC | MEDSZ_AD | MEDSZ_AE,               /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */
           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */
                                         /* Pen color is a 1 based index */
                                         /* into the ColorList aray      */
                                         /* 0=no pen                     */
           {                             /* Default Pen Colors Carousel 1*/
             IDX_YELLOW     ,IDX_ORANGE     ,IDX_RED       ,IDX_GREEN       ,
             IDX_RED_VIOLET ,IDX_CYAN       ,IDX_VIOLET    ,IDX_BLUE        ,
             IDX_BROWN      ,IDX_BLACK      ,IDX_WHITE     ,IDX_GRAY        ,
             IDX_DARKBLUE   ,IDX_DARKRED    ,IDX_DARKPINK  ,IDX_DARKGREEN   ,
             IDX_DARKCYAN   ,IDX_DARKGRAY   ,IDX_LIGHTGRAY ,IDX_REDGRAY     ,
             IDX_GREENGRAY  ,IDX_BLUEGRAY   ,IDX_BLUSH     ,IDX_CRIMSON     ,
             IDX_BRICKRED   ,IDX_SAND       ,IDX_SALMON    ,IDX_SIENNABROWN ,
             IDX_TAN        ,IDX_BUFF       ,IDX_LIGHTPEACH,IDX_DARKPEACH   ,
             IDX_LIGHTBROWN ,IDX_DARKBROWN  ,IDX_PARCHMENT ,IDX_PALEYELLOW  ,
             IDX_GOLD       ,IDX_DARKGOLD   ,IDX_PALEGREEN ,IDX_LIGHTGREEN  ,
             IDX_DEEPGREEN  ,IDX_MINTGREEN  ,IDX_SEAGREEN  ,IDX_LIGHTEMERALD,
             IDX_DARKEMERALD,IDX_EVERGREEN  ,IDX_AQUA      ,IDX_TURQUOISE   ,
             IDX_SPRUCE     ,IDX_SEAGRAY    ,IDX_PASTELBLUE,IDX_SKYBLUE     ,
             IDX_CERULEAN   ,IDX_TRUEBLUE   ,IDX_ICEBLUE   ,IDX_DUSTYBLUE   ,
             IDX_ROYALBLUE  ,IDX_FLAGBLUE   ,IDX_DARKVIOLET,IDX_INDIGO      ,
             IDX_PURPLEWASH ,IDX_LIGHTPURPLE,IDX_PURPLE    ,IDX_GRAPE       ,
             IDX_DARKGRAPE  ,IDX_PURPLEGRAY ,IDX_HOTPINK   ,IDX_LIGHTMAGENTA,
             IDX_MAGENTA    ,IDX_DARKMAGENTA,IDX_PALEROSE  ,IDX_LIGHTROSE   ,
             IDX_ROSE       ,IDX_DARKROSE   ,IDX_BURGUNDY  ,IDX_D19PCTGRAY  ,
             IDX_D38PCTGRAY ,IDX_D44PCTGRAY ,IDX_D56PCTGRAY,IDX_D63PCTGRAY
           },
           { PENTYPES_80 },              /* Default Pen Types Carousel 1*/
           4,                            /* Default Media size */
           MAX_CAROUSELS,                /* # of active Active Carousels */
           FL_USEAPPCOLORS,              /* Default for usFlags */
                                         /* Default for UseAppColors = 1 */
           RES_300X300INDEX              /* Default resolution */
       }
   },
   /*
   ** #20  IBM 6182 Standard MODE
   */
   {
       (PSZ)NULL,                      /* Device Mode Init String */
       (PSZ)NULL,                      /* Device Mode Termination String */
       HPGL_ALL,                       /* HPGL Capabilities without GEC */
       HPGL_ALL,                       /* HPGL Capabilities with GEC */
       OD_COLOR |                      /* Color Device            */
       OD_FILLTYPE |                   /* Odd device implementations filltype */
//     6182 has 2 modes - enhanced mode requires OD_USERIW
//                        standard mode does not require OD_USERID
//                        The default is Standard
       OD_FILLRECT_INCLUSIVE,          /* @MJH2 */
       626,                            /* Max Polygon without GEC */
       626,                            /* Max Polygon with GEC */
       0,                              /* Max HPGL2 pens for pen palette (NP) */
       RES_204X204,                    /* Supported resolutions */
       2,                              /* P1P2Table Entry     */
       2,                              /* PaperResTable Entry */
       3,                              /* PrintOffTable Entry */
       GPLCOMPRESS_NONE,               /* Supported Genplib compression modes */
       DRV_COMPRESS_NONE,              /* Supported driver compression modes  */
       {
           { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Pen type support */
           { 1, 1, 1, 1 },             /* Options support */
           1,                          /* Paper feed support? */
           0,                          /* GEC Support */
           8,                          /* Pens per carousel */
           1,                          /* Default Color sort state */
           MEDSZ_A | MEDSZ_B | MEDSZ_A4 | MEDSZ_A3,    /* Media size */
           { 15, 24, 30, 36, 45, 51, 57, 66 },     /* ForceValue */
           { 1, 80, 1 },
           { 1, 8, 1 },
           { 1, 6, 1 }
       },
       {
           /*
           ** PenOptions
           */

           { 50, 10, 60, 20, 15 },
           { 2, 2, 6, 2, 1 },
           { 6, 6, 6, 6, 6 }
       },
       {
           /*
           ** DefProfile
           */

           { 10, 3, 4, 1, 8, 5, 6, 2 },  /* Default Pen Colors */
           { 0 },                        /* default Pen Types P3 */
           0,                            /* Default Media size */
           1,                            /* number of active Active Carousels*/
           FALSE,                        /* Default for usFlags */
                                         /* Default for UseAppColors = 0 */
           RES_204X204INDEX              /* Default resolution */
       }
   },
};

/*
**      Values used to set P1P2,  being the limit for plotting area.   Values
**    are in PLOTTER UNITS
*/
/**************************** old stuff ***********************************/
/* P1P2 is calulated from the physical papersize - clips                  */
/**************************************************************************/
/**************************end old stuff *****************************/

/*
**   Location of lower left hand corner in portrait mode,  at power up.
**   This is the nearest to the edge of the paper allowed by the plotter,
**   Some computation is required to use these values in portrait mode -
**   see escquery.c.
**      Values are in mm.
**   Numbers are in Portrait Mode.
**
*/

POINTS PrintOffTable [10][MAX_MEDIA_SIZES] =
{
    {   /* #0 HP7440A */
        { 9, 14 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 9, 14 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 }
    },
    {   /* #1 HP7470A */
        { 12, 14 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 12, 14 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 }
    },
    {   /* #2 HP7475A */
        { 18, 22 },
        { 18, 22 },
        { 0 },
        { 0 },
        { 0 },
        { 18, 22},
        { 18, 22},
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 }
    },
    {   /* #3 HP7550A */
        {13, 10 },      /* was 13, 15 */
        {13, 10 },      /* was 13, 15 */
        { 0 },
        { 0 },
        { 0 },
        {13, 10 },      /* was 13, 15 */
        {13, 10 },      /* was 13, 15 */
        { 0 },
        { 0 },
        { 0 },
        { 0 },
        { 0 }
    },
    {   /* #4 HP7570A & HP7580A & HP7585A & HP7580B & HP7585B & HP7586B */
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 },
        { 15, 31 }
    },
    {   /* #5 HP7595A & HP7596A & HPC3170A*/
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 },
        { 5, 31 }
    },
    { /* #6    PAINTJET_XL */
      /*
      ** clip limits were rounded up to whole even numbers
      */

        { 6, 4 },                               /* A  206 X 271 mm */
        { 6, 4 },                               /* B  269 X 420 mm */
        { 0 },                                  /* C               */
        { 0 },                                  /* D               */
        { 0 },                                  /* E               */
        { 6, 4 },                               /* A4 202 X 289 mm */
        { 6, 4 }                                /* A3 279 X 408 mm */
    },
    { /* #7 DesignJet 600 */
      /* The book has 10 for the y expand clip. However, I found */
      /* it to actually be 12.                                   */
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 }
    },
    { /* #8    PAINTJET_XL 300 HPGL2*/
        /*
        ** clip limits were rounded up to whole even numbers
        */
        { 5, 6 },  // { 6.5, 12.5 },            /* A  206 X 267 mm */
        { 5, 6 },                               /* B  270 X 420 mm */
        { 0 },                                  /* C               */
        { 0 },                                  /* D               */
        { 0 },                                  /* E               */
        { 5, 6 },                               /* A4 200 X 285 mm */
        { 5, 6 }                                /* A3 287 X 408 mm */
    },
    { /* #9    DraftMaster Series SX RX and MX */
        /*
        ** clip limits were rounded up to whole even numbers
        */
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 },
        { 6, 17 }
    }
};

/*
**
**   The real form size - paper size in plotter.  Plotting area is less.
**   Units are mm.  A zero second dimension implies a roll.
**   Numbers are in Portrait Mode
*/

POINTS PhysicalPageSize [MAX_MEDIA_SIZES] =
{
    { 216, 279 },       /* A (8.5 x 11 in.)    */
    { 279, 432 },       /* B (11 x 17 in.)     */
    { 432, 559 },       /* C (17 x 22 in.)     */
    { 559, 863 },       /* D (22 x 34 in.)     */
    { 863, 1118 },      /* E (34 x 44 in.)     */
    { 210, 297 },       /* A4 (210 x 297 mm)   */
    { 297, 420 },       /* A3 (297 x 420 mm)   */
    { 420, 594 },       /* A2 (420 x 594 mm)   */
    { 594, 841 },       /* A1 (594 x 841 mm)   */
    { 841, 1189 },      /* A0 (841 x 1189 mm)  */
    { 610, 0 },         /* Roll (24 x ??? in.) */
    { 914, 0 },         /* Roll (36 x ??? in.) */
    { 311, 457 },       /* Architectural B: 12in x 18in  */
    { 457, 610 },       /* Architectural C: 18in x 24in  */
    { 610, 914 },       /* Architectural D: 24in x 36in  */
    { 610, 1219 }       /* Architectural E: 36in x 48in  */
};

/*
**      Map ID to name
*/

PLOTTERDEF PlotterDef [] =
{
#if IBM
    { CLASS_HP7440A,              IBM6180,        "IBM6180"   },
    { CLASS_HP7550A,              IBM6182,        "IBM6182"   },
    { CLASS_HP7570A,              IBM6184,        "IBM6184"   },
    { CLASS_HP7595A,              IBM6186_1,      "IBM6186-1" },
    { CLASS_HP7596A,              IBM6186_2,      "IBM6186-2" },
    { CLASS_HP7470A,              IBM7371,        "IBM7371"   },
    { CLASS_HP7475A,              IBM7372,        "IBM7372"   },
    { CLASS_HP7580B,              IBM7374,        "IBM7374"   },
    { CLASS_HP7585B,              IBM7375_1,      "IBM7375-1" },
    { CLASS_HP7586B,              IBM7375_2,      "IBM7375-2" },
#endif
#if HP
    { CLASS_HP7440A,              COLORPRO,        "HP7440A"   },
    { CLASS_HP7470A,              HP7470A,         "HP7470A"   },
    { CLASS_HP7475A,              HP7475A,         "HP7475A"   },
    { CLASS_HP7550A,              HP7550A,         "HP7550A"   },
//  private for Japan apar
//    { CLASS_6182STANDARD,         HP7550A,         "HP7550A"   },
    { CLASS_HP7570A,              DRAFTPRO,          "HP7570A"   },
    { CLASS_HP7580A,              HP7580A,           "HP7580A"   },
    { CLASS_HP7580B,              HP7580B,           "HP7580B"   },
    { CLASS_HP7585A,              HP7585A,           "HP7585A"   },
    { CLASS_HP7585B,              HP7585B,           "HP7585B"   },
    { CLASS_HP7586B,              HP7586B,           "HP7586B"   },
    { CLASS_HP7595A,              DRAFTMASTER1,      "HP7595A"   },
    { CLASS_HP7596A,              DRAFTMASTER2,      "HP7596A"   },
    { CLASS_PAINTJET_XL,          PAINTJET_XL,       "PaintJet XL HP-GL/2" },
    { CLASS_DESIGNJET650,         DESIGNJET200,      "DesignJet 200"},
    { CLASS_DESIGNJET650,         DESIGNJET220,      "DesignJet 220"},
    { CLASS_DESIGNJET230,         DESIGNJET230,      "DesignJet 230"},
    { CLASS_DESIGNJET650,         DESIGNJET250C,     "DesignJet 250C"},
    { CLASS_DESIGNJET650,         DESIGNJET330,      "DesignJet 330"},
    { CLASS_DESIGNJET650,         DESIGNJET350C,     "DesignJet 350C"},

    { CLASS_DESIGNJET650,         DESIGNJET430,      "DesignJet 430"},
    { CLASS_DESIGNJET650,         DESIGNJET450C,     "DesignJet 450C"},
    { CLASS_DESIGNJET650,         DESIGNJET455CA,    "DesignJet 455CA"},

    { CLASS_DESIGNJET600,         DESIGNJET600,      "DesignJet 600"},
    { CLASS_DESIGNJET650,         DESIGNJET650C,     "DesignJet 650C"},
    { CLASS_DESIGNJET650,         DESIGNJET700C,     "DesignJet 700C"},
    { CLASS_DESIGNJET650,         DESIGNJET750C,     "DesignJet 750C"},
    { CLASS_DESIGNJET650,         DESIGNJET750CPLUS, "DesignJet 750C Plus"},
    { CLASS_DESIGNJET650,         DESIGNJET755CM,    "DesignJet 755CM"},
    { CLASS_DESIGNJET650,         DESIGNJET2000CP,   "DesignJet 2000CP"},
    { CLASS_DESIGNJET650,         DESIGNJET2500CP,   "DesignJet 2500CP"},
    { CLASS_DESIGNJET650,         DESIGNJET3000C,    "DesignJet 3000C"},
    { CLASS_DESIGNJET650,         DESIGNJET3500C,    "DesignJet 3500C"},
    { CLASS_DRAFTMASTER_SERIES,   DRAFTMASTER_SX,    "DraftMaster SX"},
    { CLASS_DRAFTMASTER_SERIES,   DRAFTMASTER_RX,    "DraftMaster RX"},
    { CLASS_DRAFTMASTER_SERIES,   DRAFTMASTER_MX,    "DraftMaster MX"},
    { CLASS_6182STANDARD,         GRAPHTECH_MP5200,  "MP5200"},
    { CLASS_6182STANDARD,         GRAPHTECH_MP5300,  "MP5300"},
    { CLASS_6182STANDARD,         IBM6182STANDARD,   "IBM6182 Standard"},

    { CLASS_DESIGNJET650,         XEROX2230IJ,       "Xerox 2230ij"},
    { CLASS_DESIGNJET650,         XEROX2240IJ,       "Xerox 2240ij"},
    { CLASS_DESIGNJET650,         XEROX8830,         "Xerox 8830"}
#ifdef PRIVATE
   ,{ CLASS_DRAFTPROPLUS_SERIES,  HPC3170A,        "HPC3170A"      }
#endif
#ifdef DEBUG
   ,{ CLASS_PAINTJET_XL300,       PAINTJET_XL300,  "PaintJet XL300 HP-GL/2"}
   ,{ CLASS_PCLHPGL2MONO,         LASERJET4,       "LaserJet 4 HP-GL/2"}
#endif
/*
** NOTE: When adding More plotter Classes, Don't forget to update
** the CENTERORIGIN(p) macro in Uitls.h
*/

#endif
};
USHORT  usPlotterCount = (sizeof( PlotterDef ) / sizeof( PlotterDef[ 0 ]) );


//////////////////////////////////////////////////////////////////////////
/*************************************************************************
 ***************** PER PROCESS DATA  *************************************
 *************************************************************************
 */
//#pragma data_seg( PerProcess )
  PERPROCESS PerProcess;
//#pragma data_seg( DATA32 )
/******************* END PER PROCESS DATA ********************************/
