/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
// INNERGRE.H - Macros for access to INNER GRE functions
// These InnerGre32Entry.. calls are used to call display driver for
// memory DC and bitmaps.

ULONG APIENTRY InnerGre32Entry2(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry3(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry4(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry5(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry6(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry7(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry8(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry9(HDC hDC, ...);
ULONG APIENTRY InnerGre32Entry10(HDC hDC, ...);

// Mask off the COM_PATH and COM_AREA flags to the shadow memory dc.
#define INNERCOMMASK  (0xFFFF0000 & ~(COM_AREA | COM_PATH))
#define INNERFLAGS(ulFunN, ul) (ulFunN | ((ul) & INNERCOMMASK))

// Bitmap functions.
#define InnerGreCreateBitmap(a,b,c,d,e,f) (HBITMAP) InnerGre32Entry7((a),(PBITMAPINFOHEADER2)(b),(ULONG)(c),(PBYTE)(d),(PBITMAPINFO2)(e),0L,INNERFLAGS(NGreCreateBitmap,(f)))
#define InnerGreDeleteBitmap(a,b) (BOOL) InnerGre32Entry3((HBITMAP)(a),0L,INNERFLAGS(NGreDeleteBitmap,(b)))
#define InnerGreSelectBitmap(a,b,c) (HBITMAP) InnerGre32Entry4((a),(HBITMAP)(b),0L,INNERFLAGS(NGreSelectBitmap,(c)))
#define InnerGreGetBitmapBits(a,b,c,d,e,f,g) (LONG) InnerGre32Entry8((a),(HBITMAP)(b),(LONG)(c),(LONG)(d),(PBYTE)(e),(PBITMAPINFO2)(f),0L,INNERFLAGS(NGreGetBitmapBits,(g)))
#define InnerGreSetBitmapBits(a,b,c,d,e,f,g) (LONG) InnerGre32Entry8((a),(HBITMAP)(b),(LONG)(c),(LONG)(d),(PBYTE)(e),(PBITMAPINFO2)(f),0L,INNERFLAGS(NGreSetBitmapBits,(g)))
#define InnerGreDrawBits(a,b,c,d,e,f,g,h) (LONG) InnerGre32Entry9((a),(PBYTE)(b),(PBITMAPINFO2)(c),(LONG)(d),(PPOINTL)(e),(LONG)(f),(ULONG)(g),0L,INNERFLAGS(NGreDrawBits,(h)))
#define InnerGreGetPel(a,b,c) (LONG) InnerGre32Entry4((a),(PPOINTL)(b),0L,INNERFLAGS(NGreGetPel,(c)))
#define InnerGreSetPel(a,b,c) (LONG) InnerGre32Entry4((a),(PPOINTL)(b),0L,INNERFLAGS(NGreSetPel,(c)))
#define InnerGreBitblt(a,b,c,d,e,f,g,h) (LONG) InnerGre32Entry9((a),(b),(LONG)(c),(PBITBLTPARAMETERS)(d),(LONG)(e),(ULONG)(f),(PBITBLTATTRS)(g),0L,INNERFLAGS(NGreBitblt,(h)))
#define InnerGreImageData(a,b,c,d,e) (LONG) InnerGre32Entry6((a),(PBYTE)(b),(LONG)(c),(LONG)(d),0L,INNERFLAGS(NGreImageData,(e)))

// PS function.
#define InnerGreErasePS(a,b) (BOOL) InnerGre32Entry3((a),0L,INNERFLAGS(NGreErasePS,(b)))

// Lock functions.
#define InnerGreLockDevice(a,b) (BOOL) InnerGre32Entry3((a),0L,INNERFLAGS(NGreLockDevice,(b)))
#define InnerGreUnlockDevice(a,b) (BOOL) InnerGre32Entry3((a),0L,INNERFLAGS(NGreUnlockDevice,(b)))


// Attributes functions.
#define InnerGreDeviceSetAttributes(a,b,c,d,e,f) (ULONG) InnerGre32Entry7((a),(ULONG)(b),(ULONG)(c),(ULONG)(d),(PBUNDLE)(e),0L,INNERFLAGS(NGreDeviceSetAttributes,(f)))
#define InnerGreDeviceGetAttributes(a,b,c,d,e) (BOOL) InnerGre32Entry6((a),(ULONG)(b),(ULONG)(c),(PBUNDLE)(d),0L,INNERFLAGS(NGreDeviceGetAttributes,(e)))
#define InnerGreDeviceSetGlobalAttribute(a,b,c,d,e) (ULONG) InnerGre32Entry6((a),(ULONG)(b),(ULONG)(c),(ULONG)(d),0L,INNERFLAGS(NGreDeviceSetGlobalAttribute,(e)))
#define InnerGreSetAttributes(a,b,c,d,e,f) (ULONG) InnerGreEntry7((a),(ULONG)(b),(ULONG)(c),(ULONG)(d),(PBUNDLE)(e),0L,INNERFLAGS(NGreSetAttributes,(f)))
#define InnerGreSetGlobalAttribute(a,b,c,d,e) (ULONG) InnerGre32Entry6((a),(ULONG)(b),(ULONG)(c),(ULONG)(d),0L,INNERFLAGS(NGreSetGlobalAttribute,(e)))

// Color functions.
#define InnerGreQueryColorData(a,b,c,d) (BOOL) InnerGre32Entry5((a),(LONG)(b),(PLONG)(c),0L,INNERFLAGS(NGreQueryColorData,(d)))
#define InnerGreQueryLogColorTable(a,b,c,d,e,f) (LONG) InnerGre32Entry7((a),(ULONG)(b),(LONG)(c),(LONG)(d),(PLONG)(e),0L,INNERFLAGS(NGreQueryLogColorTable,(f)))
#define InnerGreCreateLogColorTable(a,b,c,d,e,f,g) (BOOL) InnerGre32Entry8((a),(ULONG)(b),(ULONG)(c),(LONG)(d),(LONG)(e),(PLONG)(f),0L,INNERFLAGS(NGreCreateLogColorTable,(g)))
#define InnerGreRealizeColorTable(a,b) (BOOL) InnerGre32Entry3((a),0L,INNERFLAGS(NGreRealizeColorTable,(b)))
#define InnerGreUnrealizeColorTable(a,b) (BOOL) InnerGre32Entry3((a),0L,INNERFLAGS(NGreUnrealizeColorTable,(b)))
#define InnerGreQueryRealColors(a,b,c,d,e,f) (LONG) InnerGre32Entry7((a),(ULONG)(b),(LONG)(c),(LONG)(d),(PLONG)(e),0L,INNERFLAGS(NGreQueryRealColors,(f)))
#define InnerGreQueryNearestColor(a,b,c,d) (LONG) InnerGre32Entry5((a),(ULONG)(b),(COLOR)(c),0L,INNERFLAGS(NGreQueryNearestColor,(d)))
#define InnerGreQueryColorIndex(a,b,c,d) (LONG) InnerGre32Entry5((a),(ULONG)(b),(COLOR)(c),0L,INNERFLAGS(NGreQueryColorIndex,(d)))
#define InnerGreQueryRGBColor(a,b,c,d) (LONG) InnerGre32Entry5((a),(ULONG)(b),(COLOR)(c),0L,INNERFLAGS(NGreQueryRGBColor,(d)))

// Line functions.
#define InnerGreGetStyleRatio(a,b,c) (BOOL) InnerGre32Entry4((a),(PBYTE)(b),0L,INNERFLAGS(NGreGetStyleRatio,(c)))
#define InnerGreDisjointLines(a,b,c,d) (LONG) InnerGre32Entry5((a),(PPOINTL)(b),(LONG)(c),0L,INNERFLAGS(NGreDisjointLines,(d)))
#define InnerGreGetCurrentPosition(a,b,c) (BOOL) InnerGre32Entry4((a),(PPOINTL)(b),0L,INNERFLAGS(NGreGetCurrentPosition,(c)))
#define InnerGreSetCurrentPosition(a,b,c) (BOOL) InnerGre32Entry4((a),(PPOINTL)(b),0L,INNERFLAGS(NGreSetCurrentPosition,(c)))
#define InnerGreGetLineOrigin(a,b,c) (LONG) InnerGre32Entry4((a),(PPOINTL)(b),0L,INNERFLAGS(NGreGetLineOrigin,(c)))
#define InnerGreSetLineOrigin(a,b,c,d) (BOOL) InnerGre32Entry5((a),(PPOINTL)(b),(LONG)(c),0L,INNERFLAGS(NGreSetLineOrigin,(d)))
#define InnerGrePolyLine(a,b,c,d) (LONG) InnerGre32Entry5((a),(PPOINTL)(b),(LONG)(c),0L,INNERFLAGS(NGrePolyLine,(d)))
#define InnerGreDrawLinesInPath(a,b,c,d,e) (BOOL) InnerGre32Entry6((a),(PRECTL)(b),(PCURVE)(c),(LONG)(d),0L,INNERFLAGS(NGreDrawLinesInPath,(e)))
#define InnerGrePolyShortLine(a,b,c) (LONG) InnerGre32Entry3((a),(PSHORTLINE)(b),0L,INNERFLAGS(NGrePolyShortLine,(c)))
#define InnerGrePolyScanline(a,b,c) (ULONG) InnerGre32Entry4((a),(PSCANDATA)(b),0L,INNERFLAGS(NGrePolyScanline,(c)))
#define InnerGreDrawBorder(a,b,c,d,e,f,g,h) (BOOL) InnerGre32Entry9((a),(PRECTL)(b),(LONG)(c),(LONG)(d),(COLOR)(e),(COLOR)(f),(ULONG)(g),0L,INNERFLAGS(NGreDrawBorder,(h)))

// Char functions
#define InnerGreCharStringPos(a,b,c,d,e,f,g,h,i) (LONG) InnerGre32Entry10((a),(PPOINTL)(b),(PRECTL)(c),(ULONG)(d),(LONG)(e),(PCH)(f),(PLONG)(g),(PCSP_INFO)(h),0L,INNERFLAGS(NGreCharStringPos,(i)))
#define InnerGreGetCodePage(a,b) (LONG) InnerGre32Entry3((a),0L,INNERFLAGS(NGreGetCodePage,(b)))
#define InnerGreSetCodePage(a,b,c) (BOOL) InnerGre32Entry4((a),(ULONG)(b),0L,INNERFLAGS(NGreSetCodePage,(c)))

// Marker function.
#define InnerGrePolyMarker(a,b,c,d) (LONG) InnerGre32Entry5((a),(PPOINTL)(b),(LONG)(c),0L,INNERFLAGS(NGrePolyMarker,(d)))

// Transform function.
#define InnerGreSetModelXform(a,b,c,d) (BOOL) InnerGre32Entry5((a),(PXFORM)(b),(ULONG)(c),0L,INNERFLAGS(NGreSetModelXform,(d)))

// Clip functions.
#define InnerGreSelectClipRegion(a,b,c,d) (LONG) InnerGre32Entry5((a),(HRGN)(b),(PHRGN)(c),0L,INNERFLAGS(NGreSelectClipRegion,(d)))
#define InnerGreCopyClipRegion(a,b,c,d,e) (LONG) InnerGre32Entry6((a),(HRGN)(b),(PRECTL)(c),(ULONG)(d),0L,INNERFLAGS(NGreCopyClipRegion,(e)))

// Device functions.
#define InnerGreQueryDeviceCaps(a,b,c,d,e) (BOOL) InnerGre32Entry6((a),(LONG)(b),(PLONG)(c),(LONG)(d),0L,INNERFLAGS(NGreQueryDeviceCaps,(e)))
#define InnerGreQueryDeviceBitmaps(a,b,c,d) (BOOL) InnerGre32Entry5((a),(PBITMAPFORMAT)(b),(LONG)(c),0L,INNERFLAGS(NGreQueryDeviceBitmaps,(d)))
#define InnerGreQueryDevResource2(a,b,c,d) (PVOID) InnerGre32Entry5((a),(ULONG)(b),(ULONG)(c),0L,INNERFLAGS(NGreQueryDevResource2,(d)))

// Escape function.
#define InnerGreEscape(a,b,c,d,e,f,g) (LONG) InnerGre32Entry8((a),(ULONG)(b),(LONG)(c),(PBYTE)(d),(PLONG)(e),(PBYTE)(f),0L,INNERFLAGS(NGreEscape,(g)))

