/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = INITTERM.C
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION =
 *
 * DATE
 *
 * DESCRIPTION=This file contains the DLL initialization and termination
 *             functions.
 *
 * FUNCTIONS
 *             _DLL_InitTerm
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#define  INCL_32
#include <os2.h>
#include "init.h"
extern HMODULE hModule;
int  _CRT_init(void);
void _CRT_term(void);
int  _rmem_init(void);
void _rmem_term(void);

#define INCL_GENPLIB_RUNTIME           /* genplib dll init code            */
#include <genplib.h>                   /* generic printer lib header       */

/***************************************************************************
 *
 * FUNCTION NAME = _DLL_InitTerm
 *
 * DESCRIPTION   = This function initializes the PMPLOT.DRV.
 *                 Saves the HMODULE assigned to us from the OS.
 *
 * INPUT         = ModHandle - Handle to module, assigned to us from OS
 *                 ulFlag    - Initialization flag
 *
 * OUTPUT        = 1L
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 **************************************************************************/
ULONG _System _DLL_InitTerm (HMODULE ModHandle, ULONG ulFlag)
{
   APIRET rc;
   //Int3();
   switch( ulFlag )
   {
       /*  ulFlag is 0 so the DLL is being loaded, get the Module Handle      */
       /*  Might also want to allocate some global heap here, will have to    */
       /*  look into it                                                       */

       case 0:
#ifdef _V3_CRT_
           if ( _CRT_init() == -1 )        /* Need to initialize runtimes for V3 */
           {
             return 0UL;
           }
#endif
#ifdef _RMEM_
           if ( _rmem_init() == -1 )  /* Need to initialize runtimesfor V3 */
           {
             return 0UL;
           }
#endif
           GplRuntimeInit();               /* init genplib */
           hModule = ModHandle;
           break;

       case 1:
           GplRuntimeTerm();               /* term genplib */
#ifdef _V3_CRT_
           _CRT_term();    /* Clean up runtime environment */
#endif
#ifdef _RMEM_
           _rmem_term();   /* Clean up runtime environment */
#endif
           break;

       default:
           break;

   }
   return 1L;
}


